---
lang: ko
title: 환영하는 커뮤니티 구축
description: 사람들이 프로젝트를 사용하고, 기여하고, 전파하도록 격려하는 커뮤니티를 구축합니다.
class: building
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
---

## Setting your project up for success

프로젝트를 시작하고, 단어를 전파하면, 사람들이 그것을 확인하고 있습니다. 굉장합니다! 자, 어떻게 그들을 주변에 붙이게 할까요?

환영하는 커뮤니티는 프로젝트의 미래와 평판에 대한 투자입니다. 프로젝트가 처음으로 기여한 것을 보기 시작한 경우, 초반 참여자에게 긍정적인 경험을 제공하고, 그들이 계속해서 다시 돌아올 수 있도록 하십시오.

### 사람들이 환영받는다고 느끼게하기

프로젝트 커뮤니티에 대해 생각하는 한 가지 방법은 @MikeMcQuaid는 [contributor funnel](https://mikemcquaid.com/2018/08/14/the-open-source-contributor-funnel-why-people-dont-contribute-to-your-open-source-project/)라고 언급했습니다:

![Contributor funnel](/assets/images/building-community/contributor_funnel_mikemcquaid.png)

커뮤니티를 구축하면서 깔때기의 맨 위에 있는 누군가(잠재 사용자)가 이론적으로 맨 아래(활동중인 메인테이너)로 나아갈 수있는 방법을 생각해보십시오. 목표는 기여자 환경의 각 단계에서 마찰을 줄이는 것입니다. 사람들이 쉽게 이를 이겨낸다면, 더 많은 일을 하도록 동기 부여를 느낄 것입니다.

문서화로 시작하기:

* **프로젝트를 쉽게 사용할 수 있도록하십시오.** [친숙한 README](../starting-a-project/#writing-a-readme)와 명확한 코드 예제를 사용한다면 프로젝트에 착수한 모든 사람이 쉽게 시작할 수 있습니다.
* **기여 방법을 분명히 설명하십시오.**, [CONTRIBUTING 파일](../starting-a-project/#writing-your-contributing-guidelines)를 사용하고 이슈를 최신 상태로 유지하시기 바랍니다.

[깃허브의 2017 오픈소스 설문](http://opensourcesurvey.org/2017/)에 따르면 불완전하거나 혼란스러운 문서가 오픈소스 사용자에게 가장 큰 문제임이 드러났습니다. 좋은 문서는 사람들이 프로젝트와 상호 작용하도록 유도합니다. 결국 누군가가 이슈를 열거나 pull request를 진행합니다. 이러한 상호 작용을 통해 유입 경로로 이동할 수 있습니다.

* **누군가 새로운 프로젝트를 시작했을 때 관심을 가져주셔서 감사합니다!** 누군가가 돌아오고 싶지 않게 만드는 것은 부정적인 경험 하나로도 충분합니다.
* **즉각 반응합니다.** 한달동안 이슈에 답변하지 않으면, 프로젝트에 대해 이미 잊어버렸을 가능성이 있습니다.
* **받아들일 수 있는 기여 유형에 대해 개방적이어야합니다.** 많은 기여자는 버그 신고 또는 작은 수정으로 시작합니다. 프로젝트에 [기여할 수 있는 많은 방법](../how-to-contribute/#what-it-means-to-contribute)이 있습니다. 사람들이 어떻게 도와주고 싶어하는지 거들어주십시오.
* **당신이 동의하지 않는 기여가 있다면,** 그들에게 아이디어에 대해 감사해하고, 프로젝트의 범위에 맞지 않는 [이유를 설명](../best-practices/#learning-to-say-no)하며, 관련 문서를 링크하면됩니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  Contributing to open source is easier for some than others. There's a lot of fear of being yelled at for not doing something right or just not fitting in. (...) By giving contributors a place to contribute with very low technical proficiency (documentation, web content markdown, etc) you can greatly reduce those concerns.
  <p markdown="1" class="pquote-credit">
— @mikeal, ["평범한 오픈소스를 기반으로하는 기여자 키우기"](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

오픈소스 제공자의 대다수는 "임시 기여자"입니다. 때때로 프로젝트에만 기여하는 사람들입니다. 캐주얼 기여자는 프로젝트 진행 속도를 최대로 끌어 올릴 시간이 없을 수도 있기 때문에, 당신의 일은 그들이 기여하기 쉽게 만드는 것입니다.

다른 참여자를 격려하는 것은 자신에게도 투자입니다. 가장 열렬한 팬에게 흥분을 줄 수있는 힘을 실어 줄 때, 모든 것을 스스로 할 수있는 부담이 줄어 듭니다.

### 모든 곳에 문서화하기

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  Have you ever been to a (tech-) event where you didn't know anyone, but everyone else seemed to stand in groups and chat like old friends? (...) Now imagine you want to contribute to an open source project, but you don't see why or how this is happening.
  <p markdown="1" class="pquote-credit">
— @janl, ["지속가능한 오픈소스"](https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

새로운 프로젝트를 시작하면, 작업을 비공개로 유지하는 것이 자연스럽게 느껴질 수 있습니다. 그러나 오픈소스 프로젝트는 공개적으로 프로세스를 문서화할 때 번창합니다.

당신이 일을 적을 때, 더 많은 사람들이 모든 단계에서 참여할 수 있습니다. 자신이 필요로 하지 않는 것에 대해서 도움을 받을 수도 있습니다.

무언가를 쓰는 것은 기술 문서 이상의 것을 의미합니다. 뭔가를 쓰거나 프로젝트에 대해 개인적으로 토론할 충동을 느낄 때마다, 공개할 수 있는지 스스로에게 자문 해보십시오.

프로젝트의 로드맵, 찾고있는 기여 유형, 기여 검토 방법 또는 특정 결정을 한 이유에 대해 투명하게 공개하십시오.

여러 사용자가 동일한 문제를 겪고있는 경우, README에 답변을 문서화하십시오.

회의의 경우, 관련 이슈에 메모나 테이크아웃을 게시하는 것을 고려하십시오. 이 투명성 수준에서 얻을 수있는 피드백은 당신을 놀라게 할 수 있습니다.

모든 것을 문서화하는 것은 당신이 하는 일에도 적용됩니다. 프로젝트에 대한 실질적인 업데이트를 진행중인 경우, pull request에 넣고 진행중인 작업(WIP)으로 표시합니다. 그렇게하면 다른 사람들이 조기에 프로세스에 참여할 수 있습니다.

### 반응하기

당신의 [프로젝트를 홍보](../finding-users)하는 것처럼, 사람들은 당신을 위해 의견을 갖습니다. 그들은 어떻게 일을하는지, 시작하는 데 도움이 필요하다는 것에 대해 질문을 할 수 있습니다.

누군가가 이슈를 제기하거나, pull request를 제출하거나, 프로젝트에 관한 질문을 하면 좋게 반응하십시오. 신속하게 대처할 때, 사람들은 대화의 일부에 참여했다는 기분을 느낄 것이며, 더 적극적으로 참여할 것입니다.

요청을 즉시 검토할 수 없더라도 조기에 이를 인정하면 참여를 늘리는 데 도움이됩니다. @tdreyno가 [Middleman](https://github.com/middleman/middleman/pull/1466)의 pull request에 응답 한 방법은 다음과 같습니다:

![중개인 pull request](/assets/images/building-community/middleman_pr.png)

48시간 내에 코드 리뷰를 받은 기여자들이 훨씬 더 높은 수익률과 반복 기여도를 보였습니다는 것을 [모질라 스터디가 발견했습니다](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177).

스택 오버플로우, 트위터 또는 레딧과 같은 인터넷상의 다른 장소에서도 프로젝트에 대한 토의가 발생할 수 있습니다. 이러한 장소중 일부에서 알림을 설정하여 누군가가 프로젝트를 언급할 때 알림을 받을 수 있습니다.

### 커뮤니티에 모일 곳을 제공하기

커뮤니티에 모일 수 있는 이유는 두 가지입니다.

첫번째 이유는 그들을 위한 것입니다. 사람들이 서로를 알게 도와주세요. 공통 관심사를 가진 사람들은 필연적으로 그것에 대해 이야기 할 곳을 원할 것입니다. 커뮤니케이션이 공개되고 접근이 용이할 때, 누구나 과거 기록을 읽어 신속하게 참여하고 참여할 수 있습니다.

두번째 이유는 당신을 위한 것입니다. 사람들에게 프로젝트에 관해 이야기 할 수 있는 공공장소를 제공하지 않으면 직접 연락을 취할 것입니다. 처음에는 개인 메시지에 "단지 한 번" 응답하는 것만큼 쉬운 것처럼 보일 수 있습니다. 그러나 시간이 지남에 따라 프로젝트가 대중화되면 특히 체력이 고갈될 것입니다. 개인적으로 프로젝트에 대한 사람들과 소통하려는 유혹에 현혹되지 마십시오. 대신 지정된 공개 채널로 안내하십시오.

공개적인 의사소통은 사람들에게 직접 이메일을 보내거나 블로그에 댓글을 다는 대신 문제를 열도록 지시하는 것처럼 간단할 수 있습니다. 또한 메일링 리스트를 설정하거나 Twitter 계정, 슬랙 또는 IRC채널을 만들어 사람들이 프로젝트에 관해 이야기할 수 있습니다. 또는 위의 모든 것을 시도하십시오!

[Kubernetes kops](https://github.com/kubernetes/kops#getting-involved)은 커뮤니티 회원들을 돕기 위해 격주로 근무 시간을 따로 지정합니다:

> Kops는 또한 격주로 커뮤니티에 도움과 안내를 제공하기 위해 시간을 마련했습니다. Kops 메인테이너는 신규 이민자와의 협력, 홍보 및 새로운 기능 토론에 전념한 시간을 별도로 마련하기로 동의했습니다.

공공 커뮤니케이션에 대한 주목할만한 예외로는: 1) 보안 문제와 2) 민감한 행동 규범 위반이 있습니다. 사람들이 이러한 문제를 개인적으로 보고할 수 있는 방법을 항상 마련해야합니다. 개인 이메일을 사용하지 않으려면 전용 이메일 주소를 설정하십시오.

## Growing your community

커뮤니티는 매우 강력합니다. 그 힘은 어떻게 사용하는지에 따라 축복이나 저주가 될 수 있습니다. 프로젝트 공동체가 성장함에 따라, 그것이 파괴가 아닌 건설의 힘이 될 수 있도록 돕는 방법이 있습니다.

### Don't tolerate bad actors

모든 인기있는 프로젝트는 필연적으로 커뮤니티를 돕기보다는, 해를 입는 사람들도 끌어 들일 것입니다. 그들은 불필요한 논쟁을 시작하거나, 사소한 기능을 말다툼하거나, 다른 사람들을 괴롭힐 수 있습니다.

이러한 유형의 사람들에 대한 무관용 정책을 채택하기 위해 최선을 다하십시오. 선택하지 않는다면, 부정적인 사람들이 커뮤니티의 다른 사람들을 불편하게 만듭니다. 그들은 심지어 떠날지도 모릅니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/okdistribute?s=180" class="pquote-avatar" alt="avatar">
  The truth is that having a supportive community is key. I'd never be able to do this work without the help of my colleagues, friendly internet strangers, and chatty IRC channels. (...) Don't settle for less. Don't settle for assholes.
  <p markdown="1" class="pquote-credit">
— @okdistribute, ["FOSS 프로젝트를 어떻게 실행하는가"](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

프로젝트의 사소한 측면에 대한 정기적인 토의는 중요한 작업에 집중하는 것을 포함하여, 다른 사람을 혼란스럽게합니다. 프로젝트에 도착한 새로운 사람들은 이러한 대화를 보고 참여하기를 원하지 않을 수 있습니다.

프로젝트에서 부정적인 행동이 발생하면, 공개적으로 말합니다. 친절하지만 확고한 어조로 왜 그들의 행동이 용납되지 않는지 설명합니다. 문제가 지속되면, [떠날 것을 요청해야 할 수도 있습니다](../code-of-conduct/#enforcing-your-code-of-conduct). [행동 규범](../code-of-conduct/)은 이 대화를 위해 건설적인 가이드가 될겁니다.

### 장소에 있는 기여자를 만나기

훌륭한 문서는 커뮤니티가 성장함에 따라 중요해질 것입니다. 프로젝트에 익숙하지 않은 캐주얼 기여자는, 필요한 컨텍스트를 빨리 얻기 위해 문서를 읽습니다.

CONTRIBUTING 파일에서 새 참여자에게 시작 방법을 명시하십시오. 이러한 목적으로 전용 섹션을 만들고 싶을 수도 있습니다. [Django](https://github.com/django/django)를 예로 들어보면, 새로운 참여자를 환영 할 수 있는 특별 방문 페이지가 있습니다.

![Django 새로운 기여자 페이지](/assets/images/building-community/django_new_contributors.png)

이슈 대기열에서, 기여자의 다른 유형에 적합한 버그 라벨을 붙이십시오: 예를 들어, [_"first timers only"_](https://kentcdodds.com/blog/first-timers-only), _"good first issue"_, 혹은 _"documentation"_이 있습니다. [이 라벨들은](https://github.com/librariesio/libraries.io/blob/6afea1a3354aef4672d9b3a9fc4cc308d60020c8/app/models/github_issue.rb#L8-L14)
프로젝트에 익숙하지 않은 사용자가 문제를 신속하게 스캔하고 시작하기가 쉽습니다.

마지막으로, 문서를 사용하여 사람들이 모든 단계에서 환영받는다고 느끼게 하십시오.

프로젝트에 도착한 대부분의 사람들과 결코 상호 작용하지 않습니다. 누군가가 협박을 당하거나 어디에서 시작해야할지 모르기 때문에 당신이 받지 못한 기여가 있을 수 있습니다. 몇 가지 종류의 단어조차도 누군가가 귀하의 프로젝트에서 좌절감에서 벗어나지 못하게합니다.

예시로, 여기 [Rubinius](https://github.com/rubinius/rubinius/)가 [기여 가이드](https://github.com/rubinius/rubinius/blob/master/.github/contributing.md)를 시작하는 방법은 다음과 같습니다:

> Rubinius를 사용해 주셔서 감사드립니다. 이 프로젝트는 사랑의 노동이며, 버그를 포착하고 성능을 개선하며, 문서화에 도움이 되는 모든 사용자에게 감사드립니다. 모든 기여는 의미가 있으므로, 참여해 주셔서 감사합니다. 말하지면, 우리가 귀하의 문제를 성공적으로 해결할 수 있도록 따라야 할 몇 가지 지침이 있습니다.

### Share ownership of your project

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/sagesharp?s=180" class="pquote-avatar" alt="avatar">
  Your leaders will have different opinions, as all healthy communities should! However, you need to take steps to ensure the loudest voice doesn't always win by tiring people out, and that less prominent and minority voices are heard.
  <p markdown="1" class="pquote-credit">
— @sagesharp, ["좋은 커뮤니티는 어떻게 만듭니까?"](https://sage.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

사람들은 소유권을 느낄 때 프로젝트에 기여하게 되어 기쁩니다. 그렇다고 해서 프로젝트의 비전을 뒤집거나 원하지 않는 기여를 받아 들일 필요가 있다는 것을 의미하지는 않습니다. 그러나 당신이 다른 사람에게 더 많은 것을 줄수록, 더 많이 붙어있게됩니다.

가능한 커뮤니티와 소유권을 공유하는 방법을 찾을 수 있는지 확인하십시오. 다음은 몇 가지 아이디어입니다:

* **쉬운(중요하지 않은) 버그를 수정하는 것을 방지**하는 대신, 그것들로 새로운 기부자를 모집할 기회로 사용하거나, 기여하고자 하는 사람을 멘토링하십시오. 초기에는 부자연스럽게 보일 수 있지만, 시간이 지남에 따라 투자가 이루어집니다. 예시로, @michaeljoseph가 기여자에게 직접 아래의 [Cookiecutter](https://github.com/audreyr/cookiecutter) 이슈에 대한 pull request을 제출하도록 요청했습니다.

![Cookiecutter 이슈](/assets/images/building-community/cookiecutter_submit_pr.png)

* 프로젝트에 기여한 사람(예를 들어, [Sinatra](https://github.com/sinatra/sinatra/blob/master/AUTHORS.md))을 모두 나열하는 **프로젝트의 CONTRIBUTORS 혹은 AUTHORS 파일을 시작하십시오.**

* 만약 상당한 규모의 커뮤니티가 있다면, 기여자들에게 감사하는 **뉴스 레터를 보내거나 블로그 포스트를 작성하십시오**. Rust의 [This Week in Rust](https://this-week-in-rust.org/)와 Hoodie의 [Shoutouts](http://hood.ie/blog/shoutouts-week-24.html)는 두개의 좋은 예시입니다.

* **모든 참여자에게 커밋 접근 권한을 부여하십시오.** @felixge는 이것이 사람들로 하여금 [패치를 작성하는 것에 더 흥분하도록](https://felixge.de/2013/03/11/the-pull-request-hack.html) 만들었고, 잠시동안 일하지 않은 프로젝트에 대한 새로운 메인테이너를 발견했습니다.

* 만약 프로젝트가 깃허브에 있는 경우, .**프로젝트를 개인 계정에서 [조직](https://help.github.com/articles/creating-a-new-organization-account/)으로 옮기고** 하나 이상의 백업 메인테이너를 추가하십시오. 조직에서는 외부 공동 작업자와 함께 프로젝트를 보다 쉽게 ​​작업 할 수 있습니다.

실제로 [대부분의 프로젝트](https://peerj.com/preprints/1233.pdf)는 대부분의 작업을 수행하는 1 ~ 2명의 메인테이너만 있습니다. 프로젝트가 커지고, 커뮤니티가 커질수록 쉽게 도움을 얻을 수 있습니다.

전화를 받는 사람을 항상 찾지는 못하더라도, 신호를 내보내는 것은 다른 사람들이 들어올 확률을 높입니다. 그리고 일찍 시작할수록 더 빨리 사람들이 도울 수 있습니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gr2m?s=180" class="pquote-avatar" alt="avatar">
  \[It's in your\] best interest to recruit contributors who enjoy and who are capable of doing the things that you are not. Do you enjoy coding, but not answering issues? Then identify those individuals in your community who do and let them have it.
  <p markdown="1" class="pquote-credit">
— @gr2m, ["환영하는 커뮤니티"](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## Resolving conflicts

프로젝트의 초기 단계에서, 중요한 결정을 내리는 것은 쉽습니다. 당신이 무언가를 하고 싶을 때, 그것을 하도록합니다.

프로젝트가 인기화되면서, 더 많은 사람들이 의사 결정에 관심을 가질 것입니다. 기여자가 큰 커뮤니티에 없더라도, 프로젝트에 많은 사용자가 있는 경우 의사 결정에 중점을 두거나 자신의 문제를 제기하는 사람들을 찾을 수 있습니다.

대부분, 친근하고 정중한 공동체를 육성하고, 공개적으로 프로세스를 문서화한 경우, 커뮤니티는 해결책을 찾아야합니다. 그러나 때로는 문제를 해결하기가 더 어려워집니다.

### 친절에 대한 기준 설정하기

귀하의 커뮤니티가 어려운 이슈로 어려움을 겪을 때, 기분이 좋아질 수 있습니다. 사람들은 화가 나거나 좌절감을 느껴 다른 사람이나 당신이 다른 사람에게 행복을 가져갈 수 있습니다.

메인테이너로서의 당신의 임무는 이러한 상황이 악화되는 것을 막는 것입니다. 주제에 대해 강한 의견을 갖고 있다고해도, 시합에 뛰어 들고 의견을 피하는 대신 메인테이너 또는 진행자의 입장을 취하십시오. 누군가가 불친절하거나 대화를 독점한다면, 토론을 시민적이고 생산적으로 유지하기 위해 [즉시 행동하십시오](../building-community/#dont-tolerate-bad-actors).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kennethreitz?s=180" class="pquote-avatar" alt="avatar">
  As a project maintainer, it's extremely important to be respectful to your contributors. They often take what you say very personally.
  <p markdown="1" class="pquote-credit">
— @kennethreitz, ["정성을 들이거나 당신의 길로 가기"](https://www.kennethreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

다른 사람들은 당신에게 인도를 구합니다. 좋은 모범을 보입니다. 여전히 실망, 불행 또는 염려를 표현할 수 있지만 침착하게 행동하십시오.

시원하게 유지하는 것은 쉽지 않지만, 리더십을 입증하면 커뮤니티의 건강이 향상됩니다. 인터넷에게 감사합니다.

### README를 헌법으로 다루기

귀하의 README는 [일련의 지시 사항 이상](../starting-a-project/#writing-a-readme)입니다. 또한 목표, 제품 비전 및 로드맵에 대해 이야기 할 수 있는 장소이기도 합니다. 사람들이 특정 기능의 장점에 대해 토론하는 데 지나치게 집중한다면, README를 다시 읽고 프로젝트의 더 높은 비전에 대해 이야기하는 것이 도움이 될 수 있습니다. README에 초점을 맞추면 대화를 비 개인화하므로 건설적인 토론을 할 수 있습니다.

### 목적지가 아닌, 여행에 집중하기

일부 프로젝트는 주요 결정을 내리기 위해 투표 프로세스를 사용합니다. 언뜻보기에 합당한 반면, 투표는 서로의 의견을 경청하고 다루기보다 "대답"을 얻는 것을 강조합니다.

투표는 정치적으로 진행될 수 있으며, 커뮤니티 멤버들은 서로에게 호의를 베풀거나 특정 방식으로 투표하도록 압박을 느끼고 있습니다. 모든 사람이 투표를 하든, [다수가 침묵](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority-of-users)하든간에, 또는 사용자가 커뮤니티에서 투표를 하지 못했거나 투표를 모르는 사용자가 발생할겁니다.

때로는, 투표는 필요한 동점자입니다. 그러나 합의가 아닌 당신이 할 수 있는만큼 ["consensus seeking"](https://en.wikipedia.org/wiki/Consensus-seeking_decision-making)을 강조합니다.

합의를 추구하는 과정에서, 커뮤니티 구성원들은 그들이 적절하게 의견을 들을 때까지 주요 관심사에 대해 논의합니다. 사소한 우려가 남아있을 때, 커뮤니티는 앞으로 나아갑니다. "Consensus seeking"는 커뮤니티가 완벽한 대답에 도달하지 못할 수도 있음을 인정합니다. 대신 듣기와 토론의 우선 순위를 정합니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lee-dohm?s=180" class="pquote-avatar" alt="avatar">
  Part of the reason why a voting system doesn't exist for Atom Issues is because the Atom team isn't going to follow a voting system in all cases. Sometimes we have to choose what we feel is right even if it is unpopular. (...) What I can offer and pledge to do...is that it is my job to listen to the community.
  <p markdown="1" class="pquote-credit">
— @lee-dohm on [Atom의 의사 결정 과정](https://discuss.atom.io/t/prioritize-issues-feature-requests-based-on-voting-system/27642/2)
  </p>
</aside>

실제로 프로젝트 메인테이너로서, 합의 과정을 추구하지 않더라도 사람들이 듣고 있다는 사실을 아는 것이 중요합니다. 다른 사람들이 느끼는 것을 느끼게하고, 자신의 우려를 해결하기 위해 노력하는 것은 민감한 상황을 확산시키는 데 많은 도움이됩니다. 그런 다음, 당신의 말을 행동으로 후속 조치하십시오.

결단을 내리기 위해 서두르지 마십시오. 모든 사람이 의견을 듣고 모든 정보가 공개되기 전에 공개되도록 해야합니다.

### 대화는 행동에 초점을 맞추기

토론은 중요하지만, 생산적 대화와 비생산적 대화의 차이점이 있습니다.

그것이 적극적으로 결의안을 향해 움직이는 한 토론을 장려하십시오. 대화가 심해지거나 화제가 되는 것이 확실하다면, 잽이 개인적으로 달라 지거나, 사람들이 사소한 세부 사항에 대해 애매한 말을 하고 있습니다.

이러한 대화를 계속하도록 허용하는 것은 당면 문제에 좋지 않을 뿐만 아니라 커뮤니티의 건강에도 좋지 않습니다. 이러한 유형의 대화가 허용되거나 심지어 권장된다는 메시지를 보내고, 사람들이 향후 문제를 제기하거나 해결하지 못하도록 막을 수 있습니다.

당신이나 다른 사람들이 만든 모든 요점으로, 자신에게 _"이것이 우리를 어떻게 결의안에 더 가까이 가게 할 수 있습니까?"_라고 물어봅니다.

대화가 풀리기 시작하면, 대화에 재집중하고자 _"다음 단계는 무엇입니까?"_라고 그룹에 요청하십시오.

대화가 명확하게 어디로도 가지 않는 경우, 명확한 조치가 취해지지 않았거나 적절한 조치가 이미 취해져서, 문제를 종결하며 이유를 설명합니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Guiding a thread toward usefulness without being pushy is an art. It won't work to simply admonish people to stop wasting their time, or to ask them not to post unless they have something constructive to say. (...) Instead, you have to suggest conditions for further progress: give people a route, a path to follow that leads to the results you want, yet without sounding like you're dictating conduct.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_OSS 생성하기_](https://producingoss.com/en/producingoss.html#common-pitfalls)
  </p>
</aside>

### 현명하게 전투를 선택하기

상황이 중요합니다. 토론에 참여한 사람과 그들이 커뮤니티의 나머지 부분을 대표하는 방법을 고려하십시오.

커뮤니티의 모든 사람들이 이 문제에 대해 화가 나거나, 심지어 이 이슈에 관여 했습니까? 또는 트러블메이커입니까? 적극적인 목소리가 아닌 조용한 커뮤니티 회원을 고려하는 것을 잊지 마십시오.

이 문제가 커뮤니티의 광범위한 요구를 반영하지 않는다면, 소수의 사람들의 우려를 인정할 필요가 있습니다. 명확한 해결 방법이 없는 반복되는 문제인 경우, 주제에 대한 이전 토론을 지정하고 스레드를 닫습니다.

### 커뮤니티 동점자 식별하기

좋은 태도와 명확한 의사 전달을 통해, 가장 어려운 상황을 해결할 수 있습니다. 그러나 생산적인 대화에서 조차, 진행 방법에 대한 견해 차이가 있을 수 있습니다. 이러한 경우에는, 동점자 역할을 할 수 있는 개인 또는 그룹을 식별하십시오.

tiebreaker는 프로젝트의 주요 메인테이너가 될 수도 있고, 투표를 기반으로 결정을 내릴 수 있는 소규모 그룹일 수도 있습니다. 이상적으로, 당신은 tiebreaker와 관련 프로세스를 GOVERNANCE 파일에서 식별하여 사용해야합니다.

당신의 tiebreaker는 최후의 수단이어야합니다. 분열적인 이슈는 커뮤니티가 성장하고 배울 수있는 기회입니다. 이러한 기회를 포용하고 협업 프로세스를 사용하여 가능하면 해결 방법으로 이동하십시오.

## Community is the ❤️ of open source

건강하고, 번영하는 커뮤니티는 매주 수천 시간을 오픈소스에 쏟아 붓고 있습니다. 많은 기여자가 오픈소스에서 일하는 이유 - 또는 일하지 않는 이유 - 를 다른 사람들에게 지적합니다. 그 힘을 건설적인 방법으로 활용하는 방법을 배우면, 잊지 못할 오픈소스 경험이 있는 누군가를 도울 수 있습니다.
