---
lang: fr
title: Etre payé pour faire de l'Open Source
description: Soutenez votre travail en open source en obtenant un soutien financier pour votre temps ou votre projet.
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## Pourquoi certaines personnes cherchent un soutien financier

Une grande partie du travail open source est volontaire. Par exemple, une personne peut rencontrer un bogue dans un projet qu'elle utilise et soumettre une solution rapide, ou alors, elle peut s'amuser à bricoler un projet open source pendant son temps libre.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
  Je cherchais un projet de programmation comme "hobby" qui me garderait occupé pendant la semaine autour de Noël. (...) J'avais un ordinateur à la maison, et pas grand-chose d'autre dans les mains. J'ai décidé d'écrire un interprèteur pour le nouveau langage de script auquel j'avais pensé récemment. (...) J'ai choisi Python comme titre de travail.
  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["Programming Python"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

Il y a plusieurs raisons pour lesquelles une personne ne voudrait pas être payée pour son travail open source.

* **Ils ont peut-être déjà un emploi à temps plein qu'ils aiment**, ce qui leur permet de contribuer à l'open source pendant leur temps libre.
* **Ils aiment penser à l'open source comme un passe-temps** ou une évasion créative et ne veulent pas se sentir financièrement obligés de travailler sur leurs projets.
* **Ils ont d'autres avantages à contribuer à l'open source**, comme bâtir leur réputation ou leur portfolio, apprendre une nouvelle compétence ou se sentir plus proches d'une communauté.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  Les dons financiers ajoutent un sentiment de responsabilité, pour certains. (...) Il est important pour nous, dans le monde où nous vivons dans un monde en évolution rapide, de pouvoir dire "pas maintenant, j'ai envie de faire quelque chose de complètement différent".
  <p markdown="1" class="pquote-credit">
— @alloy, ["Why We Don't Accept Donations"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

Pour d'autres, surtout lorsque les contributions sont en cours ou demandent beaucoup de temps, être payé pour contribuer à l'open source est la seule façon de participer, soit parce que le projet l'exige, soit pour des raisons personnelles.

Maintenir des projets populaires peut être une responsabilité importante, en prenant 10 ou 20 heures par semaine au lieu de quelques heures par mois.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  Demandez à n'importe quel responsable de projet open source, et il vous parlera de la quantité de travail nécessaire pour gérer un projet. Vous avez des clients. Vous fixez des problèmes pour eux. Vous créez de nouvelles fonctionnalités. Cela devient une véritable demande sur votre temps.
  <p markdown="1" class="pquote-credit">
— @ashedryden, ["The Ethics of Unpaid Labor and the OSS Community"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

Le travail rémunéré permet également aux personnes de différents horizons de faire des contributions significatives. Certaines personnes ne peuvent pas se permettre de consacrer du temps non rémunéré à des projets Open Source, en fonction de leur situation financière actuelle, de leur dette, de leur famille ou d'autres obligations. Cela signifie que le monde ne voit jamais les contributions de personnes talentueuses qui ne peuvent pas se permettre de faire du bénévolat. Cela a des implications éthiques, comme @ashedryden [a décrit](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community), puisque le travail qui est fait est biaisés en faveur de ceux qui ont déjà des avantages dans la vie, qui obtiennent ensuite des avantages supplémentaires en fonction de leurs contributions bénévoles, tandis que d'autres qui ne peuvent pas faire de bénévolat n'obtiennent pas d'opportunités ultérieures, ce qui renforce le manque de diversité au sein de la communauté de l'open source.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
    Les logiciels libres offrent des avantages considérables à l'industrie de la technologie, ce qui, à son tour, profite à toutes les industries. (...) Cependant, si les seules personnes qui peuvent se concentrer sur elle sont les chanceux et les obsédés, alors il y a un énorme potentiel inexploité.
  <p markdown="1" class="pquote-credit">
— @isaacs, ["Money and Open Source"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

Si vous cherchez un soutien financier, il y a deux pistes à considérer. Vous pouvez financer votre propre temps en tant que contributeur, ou vous pouvez trouver un financement organisationnel pour le projet.

## Financer votre temps

Aujourd'hui, beaucoup de gens sont payés pour travailler à temps plein ou à temps partiel. La façon la plus courante d'être payé pour votre temps est de parler à votre employeur.

Il est plus facile de plaider en faveur du travail open source si votre employeur utilise réellement le projet, mais soyez créatif avec votre argumentaire. Peut-être que votre employeur n'utilise pas le projet, mais ils utilisent Python, et le maintien d'un projet populaire Python aide à attirer de nouveaux développeurs Python. Peut-être que cela rend votre employeur plus convivial en général.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/hzoo?s=180" class="pquote-avatar" alt="avatar">
  Comme beaucoup en open source, je me débattais avec le fardeau de maintenir un projet. Quand j'ai commencé à faire de l'open source, je restais juste en retard pour travailler dessus ou juste quand je rentrais à la maison. (...) J'ai pu discuter avec mon patron des problèmes auxquels je faisais face et nous avons eu des idées sur la façon dont nous pourrions intégrer des tâches open source étant donné notre propre utilisation de Babel.
  <p markdown="1" class="pquote-credit">
— @hzoo, ["Maintainer Stories"](https://github.com/open-source/stories/hzoo)
  </p>
</aside>

Si vous n'avez pas de projet Open Source sur lequel vous souhaitez travailler, mais préférez que votre travail actuel soit ouvert, demandez à votre employeur d'ouvrir certains de ses logiciels internes.

De nombreuses entreprises développent des programmes open source pour construire leur marque et recruter des talents de qualité.

@hueniverse, par exemple, a trouvé qu'il y avait des raisons financières pour justifier [l'investissement de Walmart dans l'open source](https://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html). Et @jamesgpearce a trouvé que le programme open source de Facebook [a fait une différence](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon) dans le recrutement:

> Il est étroitement lié à notre culture de hackers et à la perception de notre organisation. Nous avons demandé à nos employés: "Connaissiez-vous le logiciel Open Source sur Facebook ?" Les deux tiers ont dit "Oui". La moitié a déclaré que le programme a contribué positivement à leur décision de travailler pour nous. Ce ne sont pas des chiffres marginaux, et j'espère, une tendance qui se poursuit.

Si votre entreprise suit cette voie, il est important de garder les limites entre les activités communautaires et corporatives. En fin de compte, l'open source s'appuie sur les contributions de personnes du monde entier, et c'est plus important que n'importe quelle entreprise ou emplacement.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  Être payé pour travailler sur l'open source est une opportunité rare et merveilleuse, mais vous ne devriez pas avoir à abandonner votre passion dans le processus. Votre passion devrait être pourquoi les entreprises veulent vous payer.
  <p markdown="1" class="pquote-credit">
— @jessfraz, ["Blurred Lines"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

Si vous ne pouvez pas convaincre votre employeur actuel d'accorder la priorité au travail open source, envisagez de trouver un nouvel employeur qui encourage les contributions des employés à l'open source. Cherchez des entreprises qui rendent explicite leur dévouement au travail open source. Par exemple :

* Certaines entreprises, comme [Netflix](https://netflix.github.io/) ou [PayPal](https://paypal.github.io/), ont des sites Web qui soulignent leur implication dans l'open source
* [Zalando](https://opensource.zalando.com) a publié sa [politique de contribution open source](https://opensource.zalando.com/docs/using/contributing/) pour les employés

Les projets provenant d'une grande entreprise, tels que [Go](https://github.com/golang) ou [React](https://github.com/facebook/react), emploieront probablement des personnes pour travailler sur Open source.

Enfin, en fonction de votre situation personnelle, vous pouvez essayer de collecter des fonds de manière indépendante pour financer votre travail open source. Par exemple :

* @gaearon a fait financer son travail sur [Redux](https://github.com/reactjs/redux) via une [campagne de crowdfunding sur Patreon](https://redux.js.org/)
* @andrewgodwin a fait financer le travail sur les migrations de schémas Django [à travers une campagne Kickstarter](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django)

## Trouver du financement pour votre projet

Au-delà des arrangements pour les contributeurs individuels, les projets recueillent parfois des fonds auprès d'entreprises, de particuliers ou d'autres pour financer des travaux en cours.

Le financement organisationnel pourrait servir à payer les contributeurs actuels, à couvrir les coûts de gestion du projet (tels que les frais d'hébergement) ou à investir dans de nouvelles fonctionnalités ou idées.

À mesure que la popularité de l'open source augmente, la recherche de financement pour des projets est encore expérimentale, mais il existe quelques options communes disponibles.

### Gagnez de l'argent pour votre travail grâce à des campagnes de crowdfunding ou de parrainage

Trouver des commandites fonctionne bien si vous avez déjà un public ou une réputation solide, ou si votre projet est très populaire.
Quelques exemples de projets sponsorisés incluent:

* **[webpack](https://github.com/webpack)** collecte des fonds auprès des entreprises et des particuliers [via OpenCollective](https://opencollective.com/webpack)
* **[Vue](https://github.com/vuejs/vue)** est [financé par Patreon](https://github.com/open-source/stories/yyx990803)
* **[Ruby Together](https://rubytogether.org/),** une organisation à but non lucratif qui paie pour travailler sur [bundler](https://github.com/bundler/bundler), [RubyGems](https://github.com/rubygems/rubygems), et d'autres projets d'infrastructure Ruby

### Créer un flux de revenus

En fonction de votre projet, vous pouvez facturer un support commercial, des options hébergées ou des fonctionnalités supplémentaires. Quelques exemples incluent:

* **[Sidekiq](https://github.com/mperham/sidekiq)** propose des versions payantes pour un support supplémentaire
* **[Travis CI](https://github.com/travis-ci)** offre des versions payantes de son produit
* **[Ghost](https://github.com/TryGhost/Ghost)** est un organisme à but non lucratif avec un service géré payant

Certains projets populaires, tels que [npm](https://github.com/npm/npm) et [Docker](https://github.com/docker/docker), permettent même de lever du capital-risque pour soutenir la croissance de leur entreprise.

### Demande de financement

Certaines fondations de logiciels et sociétés offrent des subventions pour le travail open source. Parfois, des subventions peuvent être versées à des personnes sans créer une entité juridique pour le projet.

* **[Read the Docs](https://github.com/rtfd/readthedocs.org)** a reçu une subvention de [Mozilla Open Source Support](https://www.mozilla.org/en-US/grants/)
* **[OpenMRS](https://github.com/openmrs)** le travail a été financé par [Stripe's Open-Source Retreat](https://stripe.com/blog/open-source-retreat-2016-grantees)
* **[Libraries.io](https://github.com/librariesio)** a reçu une subvention de la [Sloan Foundation](https://sloan.org/programs/digital-technology)
* La **[Python Software Foundation](https://www.python.org/psf/grants/)** offre des subventions pour les travaux liés à Python

Pour des options plus détaillées et des études de cas, @nayafia [a écrit un guide](https://github.com/nayafia/lemonade-stand) pour être payé pour le travail open source. Différents types de financement nécessitent des compétences différentes, alors considérez vos forces pour déterminer quelle option vous convient le mieux.

## B&acirc;tir un dossier pour un soutien financier

Que votre projet soit une nouvelle idée, ou qu'il existe depuis des années, vous devriez vous attendre à réfléchir sérieusement à l'identification de votre bailleur de fonds cible et à présenter un cas convaincant.

Que vous cherchiez à payer pour votre temps libre ou à collecter des fonds pour un projet, vous devriez être en mesure de répondre aux questions suivantes.

### Impact

Pourquoi ce projet est-il utile ? Pourquoi vos utilisateurs, ou les utilisateurs potentiels, l'apprécient-ils autant ? Où sera-ce dans cinq ans ?

### Traction

Essayez de recueillir des preuves que votre projet compte, que ce soit des mesures, des anecdotes ou des témoignages. Y a-t-il des entreprises ou des personnes remarquables qui utilisent votre projet en ce moment ? Si non, une personne en vue l'a-t-elle approuvée ?

### Valeur au donateur

Les bailleurs de fonds, que ce soit votre employeur ou une fondation subventionnaire, sont fréquemment approchés avec des opportunités. Pourquoi devraient-ils soutenir votre projet par rapport à toute autre opportunité ? Comment en bénéficient-ils personnellement ?

### Utilisation des fonds

Qu'allez-vous accomplir exactement avec le financement proposé ? Concentrez-vous sur les jalons ou les résultats du projet plutôt que de payer un salaire.

### Comment vous recevrez les fonds

Le bailleur de fonds a-t-il des exigences en matière de déboursement ? Par exemple, vous devrez peut-être être un but non lucratif ou avoir un sponsor fiscal à but non lucratif. Ou peut-être que les fonds doivent être donnés à un entrepreneur individuel plutôt qu'à une organisation. Ces exigences varient selon les bailleurs de fonds, alors assurez-vous de faire vos recherches à l'avance.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
  Pendant des années, nous avons été la principale ressource en matière d'icônes conviviales pour les sites Web, avec une communauté de plus de 20 millions de personnes et une présence sur plus de 70 millions de sites Web, y compris Whitehouse.gov. (...) La version 4 était il y a trois ans. La technologie Web a beaucoup changé depuis, et franchement, Font Awesome est devenu un peu obsolète. (...) C'est pourquoi nous introduisons Font Awesome 5. Nous modernisons et réécrivons le CSS et redessinons chaque icône de haut en bas. Nous parlons d'une meilleure conception, d'une meilleure cohérence et d'une meilleure lisibilité.
  <p markdown="1" class="pquote-credit">
— @davegandy, [Font Awesome Kickstarter video](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## Expérimentez et n'abandonnez pas

Il n'est pas facile de gagner de l'argent, qu'il s'agisse d'un projet open source, d'un but non lucratif ou d'un démarrage de logiciel, et dans la plupart des cas, vous devez être créatif. Identifier comment vous voulez être payé, faire votre recherche, et vous mettre dans la peau de votre bailleur de fonds vous aidera à construire un argument convaincant pour le financement.
