---
lang: es
title: C&oacute;mo Contribuir con el C&oacute;digo Abierto
description: ¿Quieres colaborar con el c&oacute;digo abierto? Una gu&iacute;a para hacer contribuciones al c&oacute;digo abierto, para principiantes y veteranos.
class: contribute
order: 1
image: /assets/images/cards/contribute.png
related:
  - beginners
  - building
---

## ¿Para qu&eacute; contribuir?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/errietta?s=180" class="pquote-avatar" alt="avatar">
  Trabajar en \[freenode\] me ha ayudado a conseguir muchas de las habilidades que luego he usado en mis estudios en la universidad y en mi actual trabajo. ¡Creo que trabajar en proyectos de c&oacute;digo abierto me ayuda tanto como ayuda al proyecto!
  <p markdown="1" class="pquote-credit">
— @errietta, ["Por qu&eacute; me gusta contribuir con el software de c&oacute;digo abierto"](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

Contribuir en proyectos de c&oacute;digo abierto puede ser una provechosa manera de aprender, enseñar, y conseguir experiencia en cualquier habilidad que puedas imaginar.

¿Para qu&eacute; contribuye la gente en proyectos de c&oacute;digo abierto? ¡Por muchas razones!

### Mejora tus habilidades existentes

Ya sea codificaci&oacute;n, diseño interfaces de usuario, dise&ntilde;o gr&aacute;fico, redacci&oacute;n u organizaci&oacute;n, si lo que est&aacute;s buscando es pr&aacute;ctica, hay una tarea esper&aacute;ndote en un proyecto de c&oacute;digo abierto.

### Conoce personas que están interesadas en temas similares

Los proyectos de c&oacute;digo abierto con comunidades c&aacute;lidas y acogedoras hacen que la gente regrese a trav&eacute;s de los años. Muchas personas forman amistades de por vida a trav&eacute;s de su participaci&oacute;n en el c&oacute;digo abierto, ya sea para presenciar exposiciones en conferencias entre pares o largas conversaciones nocturnas sobre burritos.

### Encuentra mentores y enseña a otros

Trabajar con otros en un proyecto compartido significa que tendr&aacute;s que explicar c&oacute;mo haces las cosas, as&iacute; como pedir ayuda. Los momentos de aprendizaje y enseñanza pueden ser actividades satisfactorias para todos los involucrados.

### Construye artefactos p&uacute;blicos que te ayudar&aacute;n a construir una reputaci&oacute;n (y una carrera)

Por definici&oacute;n, todo tu c&oacute;digo abierto es p&uacute;blico, lo que significa que consigues ejemplos de manera gratuita para llevar a cualquier lugar como una demostraci&oacute;n de lo que haces.

### Conoce las habilidades de las personas

El c&oacute;digo abierto ofrece oportunidades para practicar habilidades de liderazgo y gesti&oacute;n, a resolver conflictos, organizar equipos  y a priorizar el trabajo.

### Es poderoso ser capaz de hacer cambios, incluso pequeños

No necesitas convertirte en un colaborador de toda la vida para disfrutar la participaci&oacute;n con el c&oacute;digo abierto. ¿Alguna vez viste un error de tipograf&iacute;a, y deseaste que &aacute;lguien pudiera corregirlo? En un proyecto de c&oacute;digo abierto, es justamente lo que puedes hacer. El c&oacute;digo abierto ayuda a las personas a sentir acci&oacute;n en sus vidas, en la forma en que experimentan al mundo y eso en si mismo es gratificante.

## Qu&eacute; significa contribuir

Si eres un colaborador de c&oacute;digo abierto nuevo, el proceso puede ser intimidatorio. ¿C&oacute;mo encontrar el proyecto adecuado? ¿Qu&eacute; hacer si no sabes c&oacute;mo codificar? ¿Qu&eacute; pasa si algo sale mal?

¡No debes preocuparte! Hay todo tipo de formas de involucrarse con un proyecto de c&oacute;digo abierto, y unos pocos consejos te ayudar&aacute;n a sacar el m&aacute;ximo provecho de tu experiencia.

### No necesitas contribuir con c&oacute;digo

Un error conceptual com&uacute;n acerca de contribuir con el c&oacute;digo abierto es que debes contribuir con c&oacute;digo. De hecho, son a menudo las otras partes de un proyecto las [m&aacute;s descuidadas o pasadas por alto](https://github.com/blog/2195-the-shape-of-open-source). ¡Le har&aacute;s un _enorme_ favor al proyecto si te ofreces a trabajar en este tipo de contribuciones!

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/orta?s=180" class="pquote-avatar" alt="avatar">
  Me han reconocido por mi trabajo en CocoaPods, pero la mayor&iacute;a de las personas no conoce que en realidad yo no realizo ning&uacute;n trabajo real en la propia herramienta CocoaPods. Mi tiempo en el proyecto se dedica principalmente a hacer cosas como documentar y a trabajar en la marca.
  <p markdown="1" class="pquote-credit">
— @orta, ["Movi&eacute;ndose al Software de c&oacute;digo abierto por defecto"](https://realm.io/news/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

Incluso si te gusta codificar, otro tipo de contribuciones son una gran manera de involucrarse con un proyecto y conocer a otros miembros de la comunidad. Construir esas relaciones te dar&aacute; oportunidades de trabajar en otras partes del proyecto.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/brettcannon?s=180" class="pquote-avatar" alt="avatar">
  Llegu&eacute; por primera vez al equipo de desarrollo de Python (alias python-dev) cuando envi&eacute; un correo electr&oacute;nico a su lista de correos el 17 de junio de 2002, aceptando mi parche. R&aacute;pidamente me encontr&eacute; con un error de c&oacute;digo abierto, y decid&iacute; comenzar a limpiar el resumen de correos electr&oacute;nicos para el grupo. Me dieron una gran excusa para pedir aclaraciones sobre un tema, pero principalmente pude notar cu&aacute;ndo &aacute;lguien señalaba algo que necesitaba ser reparado.
  <p markdown="1" class="pquote-credit">
— @brettcannon, ["Hostorias de un encargado"](https://github.com/open-source/stories/brettcannon)
  </p>
</aside>

### ¿Te gusta planificar eventos?

* Organiza workshops o reuniones acerca del proyecto, [como hizo @fzamperin para NodeSchool](https://github.com/nodeschool/organizers/issues/406)
* Organiza la conferencia del proyecto (si es que tienen una)
* Ayuda a la comunidad de miembros a encontrar las conferencias apropiadas y a presentar propuestas para disertar

### ¿Te gusta diseñar?

* Reestructura los diseños para mejorar la usabilidad del proyecto
* Dirige la investigaci&oacute;n de los usuarios para reorganizar y refinar la navegaci&oacute;n del proyecto o sus men&uacute;s, [como lo sugiere Drupal](https://www.drupal.org/community-initiatives/drupal-core/usability)
* Re&uacute;ne una gu&iacute;a de estilos para ayudar al proyecto a tener un diseño con consistencia visual
* Crea diseños para las remeras o un nuevo logo, [como hicieron los colaboradores de hapi.js's](https://github.com/hapijs/contrib/issues/68)

### ¿Te gusta escribir?

* Escribe y mejora la documentaci&oacute;n del proyecto
* Sanea la carpeta de ejemplos para mostrar c&oacute;mo se usa el proyecto
* Inicia el bolet&iacute;n informativo para el proyecto, o aspectos m&aacute;s destacados a enviar a la lista de correos
* Escribe tutoriales para el proyecto, [como hicieron los colaboradores de pypa's](https://github.com/pypa/python-packaging-user-guide/issues/194)
* Escribe una traducci&oacute;n de la documentaci&oacute;n del proyecto

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kittens?s=180" class="pquote-avatar" alt="avatar">
  De verdad, \[documentation\] es s&uacute;per-importante. Por lejos la documentaci&oacute;n ha sido enorme y fue el factor que termin&oacute; con la torre de Babel. Hay secciones que ciertamente podr&iacute;an mejorar con algo de trabajo e incluso la adici&oacute;n de un p&aacute;rrafo aqu&iacute; o all&aacute; es extremadamente apreciada.
  <p markdown="1" class="pquote-credit">
— @kittens, ["Llamado a los colaboradores"](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### ¿Te gusta organizar?

* Vincula los problemas duplicados, y sugiere nuevas etiquetas para los problemas, para mantener todo organizado
* Recorre los problemas abiertos y sugiere cerrar los m&aacute;s antiguos, [como hizo @nzakas para eslint](https://github.com/eslint/eslint/issues/6765)
* Realiza preguntas clarificadoras en los problemas recientemente abiertos para hacer que la discusi&oacute;n avance

### ¿Te gusta programar?

* Encuentra un problema abierto para entrar, [como  lo hizo @dianjin para Leaflet](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560)
* Pregunta si puedes ayudar a escribir alguna nueva funcionalidad
* Automatiza la configuraci&oacute;n del proyecto
* Mejora las herramientas y las pruebas

### ¿Te gusta ayudar a las personas?

* Responde las preguntas acerca del proyecto en, por ejemplo, Stack Overflow ([como este ejemplo Postgres](https://stackoverflow.com/questions/18664074/getting-error-peer-authentication-failed-for-user-postgres-when-trying-to-ge)) o en reddit
* Responde preguntas a las personas en los problemas abiertos
* Ayuda a moderar los foros de discusi&oacute;n o canales de conversaci&oacute;n

### ¿Te gusta ayudar a otros a programar?

* Revisa el c&oacute;digo que otras personas presentan
* Escribe tutoriales sobre c&oacute;mo puede usarse un proyecto
* Ofr&eacute;cete como tutor de otro colaborador, [como lo hizo @ereichert para @bronzdocen on Rust](https://github.com/rust-lang/book/issues/123#issuecomment-238049666)

### ¡No tienes que trabajar solamente en proyectos de software!

Mientras que el "c&oacute;digo abierto" a menudo se refiere a software, puedes colaborar en casi cualquier cosa. Existen libros, recetas, listas y clases que se desarrollan como proyectos de c&oacute;digo abierto.

Por ejemplo:

* @sindresorhus sanea una [lista de "asombrosos"](https://github.com/sindresorhus/awesome)
* @h5bp mantiene una [lista de preguntas potenciales para entrevistas](https://github.com/h5bp/Front-end-Developer-Interview-Questions) para desarrolladores candidatos de front-end
* @stuartlynn y @nicole-a-tesla hicieron una [colecci&oacute;n de hechos graciosos sobre puffins](https://github.com/stuartlynn/puffin_facts)

Incluso si no eres un desarrollador de software, trabajar en la documentaci&oacute;n de un proyecto puede ayudar a comenzar en el c&oacute;digo abierto. Es con frecuencia menos intimidante trabajar en proyectos que no involucran c&oacute;digo, y ese proceso de colaboraci&oacute;n te dar&aacute; confianza y experiencia.

## Orient&aacute;ndote a un nuevo proyecto

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shaunagm?s=180" class="pquote-avatar" alt="avatar">
  Si vas tras un rastreador de problemas y las cosas parecen confusas, no eres solo tu. Esas herramientas requieren mucho conocimiento impl&iacute;cito, pero las personas puede ayudarte a navegarlo y tu puedes hacerles preguntas.
  <p markdown="1" class="pquote-credit">
— @shaunagm, ["C&oacute;mo Contribuir con el C&oacute;digo Abierto"](https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/)
  </p>
</aside>

Para cualquier otra cosa distinta de una correcci&oacute;n de error tipogr&aacute;fico, contribuir con el c&oacute;digo abierto es como caminar hacia un grupo de extraños en una fiesta. Si comienzas a hablar sobre las llamas, mientras ellos est&aacute;n muy involucrados en una discusi&oacute;n sobre el pez dorado, es probable que te miren de manera un poco extraña.

Antes de lanzarte con los ojos cerrados con tus propias sugerencias, comienza aprendiendo c&oacute;mo leer a la sala. Si lo haces, aumentan las probabilidades de que tus ideas se noten y sean escuchadas.

### Anatom&iacute;a de un proyecto de c&oacute;digo abierto

Todas las comunidades de c&oacute;digo abierto son diferentes.

Luego de pasar años en un proyecto de c&oacute;digo abierto significa que aprendiste a conocer un proyecto de c&oacute;digo abierto. Si te mueves a un proyecto diferente encontrar&aacute;s que el vocabulario, las normas, y los estilos de comunicaci&oacute;n son completamente diferentes.

Dicho esto, muchos proyectos de c&oacute;digo abierto siguen una estructura organizacional similar. Entender los roles de las  diferentes comunidades y el proceso en general te ayudar&aacute; a estar rapidamente orientado para cualquier proyecto nuevo.

Un proyecto de c&oacute;digo abierto tiene los siguientes tipos de personas:

* **Autor:** La/s persona/s u organizaci&oacute;n que cre&oacute;/crearon el proyecto.
* **Dueño:** La/s persona/s que tiene/n la propiedad administrativa sobre la organizaci&oacute;n o el repositorio(no siempre es la misma que el autor original)
* **Encargados:** Colaboradores que son responsables de dirigir la visi&oacute;n y la administrar aspectos organizacionales del proyecto. (Pueden tambi&eacute;n ser autores o dueños del proyecto.)
* **Colaboradores:** Cualquiera que haya contribuido con algo al proyecto.
* **Miembros de la comunidad:** Las personas que utilizan al proyecto. Pueden tener un rol activo en las conversaciones o expresar su opini&oacute;n sobre la direcci&oacute;n que toma el proyecto.

Los proyectos m&aacute;s grandes pueden tener tambi&eacute;n subcomisiones o grupos de trabajo enfocados en tareas diferentes, como herramientas, priorizaci&oacute;n de urgencias, moderaci&oacute;n de la comunidad, y organizaci&oacute;n de eventos. Busca en el sitio web del proyecto una p&aacute;gina del "equipo", o en su repositorio para encontrar la documentaci&oacute;n pol&iacute;tica de gobierno, para encontrar &eacute;sta documentaci&oacute;n.

Un proyecto tambi&eacute;n tiene documentaci&oacute;n. Estos archivos est&aacute;n normalmente listados en un nivel alto del repositorio.

* **LICENSE:** Por definici&oacute;n, cada proyecto de c&oacute;digo abierto debe tener una [licencia open source](https://choosealicense.com). Si el proyecto no tiene una licencia, entonces no es de c&oacute;digo abierto.
* **README:** El archivo README es un manual de instrucci&oacute;n que da la bienvenida al proyecto a los nuevos miembros de la comunidad. Explica por qu&eacute; el proyecto es &uacute;til y c&oacute;mo comenzar.
* **CONTRIBUTING:** Mientras que el archivo READMES ayuda a las personas a _usar_ el proyecto, el archivo CONTRIBUTING ayuda a las personas a _contribuir_ con el proyecto. Explica qu&eacute; tipo de contribuciones son necesarias y c&oacute;mo llevar adelante el trabajo. Si bien no todos los proyectos tienen un archivo CONTRIBUTING, su presencia señala que se trata de un buen proyecto para contribuir.
* **CODE_OF_CONDUCT:** Sienta s&oacute;lidas reglas sobre la conducta de los participantes asociados y ayuda a facilitar un entorno acogedor y amistoso. Si bien no todos los proyectos tienen un archivo CODE_OF_CONDUCT, su presencia señala que se trata de un buen proyecto para contribuir.
* **Otra documentaci&oacute;n:** Puede haber documentaci&oacute;n adicional, como tutoriales, recorridos o pol&iacute;ticas de gobierno, especialmente en proyectos de mayor envergadura.

Finalmente, los proyectos de c&oacute;digo abierto utilizan las siguientes herramientas para organizar la discusi&oacute;n. La lectura de estos archivos te dar&aacute;n una buena imagen de c&oacute;mo piensa y trabaja la comunidad.

* **Seguidor de problemas (Issue tracker):** Es donde las personas discuten los problemas relacionados con el proyecto.
* **Pull requests:** Es donde las personas discuten y revisan los cambios que est&aacute;n en progreso.
* **Foros de discusi&oacute;n o lista de correos electr&oacute;nicos:** Algunos proyectos pueden utilizar estos canales de conversación para t&oacute;picos de conversaci&oacute;n (por ejemplo _"C&oacute;mo hago para..._ o _"Qu&eacute; piensas sobre..."_ en luga de reportes de errores o pedido de requerimientos). Otros utilizan un rastreador de problemas para todas las conversaciones.
* **Canal de chat s&iacute;ncrono:** Algunos proyectos utilizan canales de chat (como Slack o IRC) para conversaciones casuales, colaboraci&oacute;n e intercambios r&aacute;pidos.

## Encontrando un proyecto donde contribuir

¡Ahora que ya has descubierto c&oacute;mo funcionan los proyectos de c&oacute;digo abierto, es tiempo de encontrar un proyecto con el que contribuir!

Si nunca antes contribuiste al c&oacute;digo abierto, acepta algunos consejos del presidente de los Estados Unidos, John F. Kennedy, quien una vez dijo, _"No preguntes qu&eacute; es lo que tu pa&iacute;s puede hacer por ti;, preg&uacute;ntate qu&eacute; es lo que t&uacute; puedes hacer por &eacute;l"_

Las contribuciones al c&oacute;digo abierto ocurren en todos los niveles a lo largo de los proyectos. No necesitas pensar demasiado cu&aacute;l ser&aacute; tu primera colaboraci&oacute;n, o c&oacute;mo se ver&aacute;.

En su lugar, comienza pensando sobre el proyecto que ya est&aacute;s utilizando o que quisieras utilizar. Los proyectos con los que contribuir&aacute;s activamente son aquellos a los que volver&aacute;s.

En esos proyectos, cuando te encuentres pensando que algo podr&iacute;a hacerse mejor o diferente, act&uacute;a siguiendo tu instinto.

El c&oacute;digo abierto no es un club exclusivo; est&aacute; hecho de personas igual a t&iacute;. El t&eacute;rmino de fantas&iacute;a  "C&oacute;digo abierto" es solo un nombre para tratar a los problemas del mundo como resolubles.

Puedes recorrer un archivo README y encontrar un v&iacute;nculo roto o un error tipogr&aacute;fico. O tal vez eres un nuevo usuario y te diste cuenta de que algo est&aacute; roto, o hay un problema que crees que realmente deber&iacute;a estar en la documentaci&oacute;n. En lugar de ignorarlo y continuar, o solicitar que &aacute;lguien lo solucione, observa si puedes ayudar lanz&aacute;ndote sobre &eacute;l. ¡De eso se trata el c&oacute;digo abierto!

> [El 28% de las contribuciones casuales](https://www.igor.pro.br/publica/papers/saner2016.pdf) a la documentaci&oacute;n del c&oacute;digo abierto se trata de documentaci&oacute;n, como correcciones tipogr&aacute;ficas, reformateos o redacci&oacute;n de una traducci&oacute;n.

Puedes tambi&eacute;n utilizar algunos de los siguientes recursos para ayudarte a descubrir nuevos proyectos:

* [GitHub Explore](https://github.com/explore/)
* [Open Source Friday](https://opensourcefriday.com)
* [First Timers Only](https://www.firsttimersonly.com/)
* [CodeTriage](https://www.codetriage.com/)
* [24 Pull Requests](https://24pullrequests.com/)
* [Up For Grabs](https://up-for-grabs.net/)
* [Contributor-ninja](https://contributor.ninja)

### Una lista de verificaci&oacute;n antes de que contribuyas

Una vez que hayas encontrado un proyecto con el que quisieras contribuir, realiza un recorrido r&aacute;pido para asegurarte de que el proyecto es adecuado para aceptar contribuciones. De otra manera, tu duro trabajo puede no tener nunca una respuesta.

Aqu&iacute; tienes una lista pr&aacute;ctica para evaluar si un proyecto es conveniente para nuevos colaboradores.

**Satisface la definici&oacute;n de c&oacute;digo abierto**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
  ¿Tiene una licencia? Usualmente, es un archivo ubicado LICENSE en la ra&iacute;z del repositorio.
  </label>
</div>

**El proyecto acepta contribuciones activamente**

Observa la actividad de los commit en la rama principal. En GitHub, puedes ver esta informaci&oacute;n en la p&aacute;gina del repositorio.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
  ¿Cu&aacute;ndo ocurri&oacute; el &uacute;ltimo commit?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
  ¿Cu&aacute;ntos colaboradores tiene el proyecto?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
  ¿Con qu&eacute; frecuencia las personas hacen un commit? (En GitHub, puedes encontrar esta informaci&oacute;n haciendo click en "Commits", en la barra superior.)
  </label>
</div>

Luego, busca en los problemas del proyecto.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    ¿Cu&aacute;ntos problemas abiertos existen?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    ¿Los responsables responden r&aacute;pidamente a los problemas cuando son abiertos?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    ¿Existe una discusi&oacute;n activa en los problemas?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    ¿Se abrieron recientemente nuevos problemas?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    ¿Se est&aacute;n cerrando los problemas? (En GitHub, haz click en el v&iacute;nculo "closed" de la p&aacute;gina de problemas para ver los problemas cerrados.)
  </label>
</div>

Ahora haz lo mismo para los pull requests del proyecto.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    ¿Cu&aacute;ntos pull requests existen?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">
    ¿Los responsables responden r&aacute;pidamente a los pull requests cuando se abren?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    ¿Existe una discusi&oacute;n activa en los pull requests?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    ¿Existen pull requests recientes?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">
    ¿C&oacute;mo de reciente ocurri&oacute; la entrada (merge) de un pull request? (En GitHub, haz click en el v&iacute;nculo "closed" en la p&aacute;gina de pull requests para ver los PRs cerrados.)
  </label>
</div>

**El proyecto es acogedor**

Un proyecto que es amigable y acogedor indica que ser&aacute; receptivo de nuevos colaboradores.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">
    ¿Los encargados responden de manera colaborativa a las preguntas en los problemas?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">
    Las personas son amigables en los problemas, foros de discusi&oacute;n y chat (por ejemplo IRC o Slack)?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">
    ¿Los pull requestes son revisados?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">
    ¿Los encargados agradecen a las personas por sus contribuciones?
  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Siempre que veas un hilo largo, comprueba las respuestas de los principales desarrolladores que llegan m&aacute;s tarde al hilo. ¿Est&aacute;n resumiendo de forma constructiva y tomando medidas para llevar el hilo hacia una decisi&oacute;n y al mismo tiempo contin&uacute;an siendo educados? Si ves que se agitan banderas de guerra pasando en frente, frecuentemente indica que la energ&iacute;a se est&aacute; encaminando a discutir m&aacute;s que en desarrollar.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Produciendo Software de c&oacute;digo abierto_](https://producingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## C&oacute;mo enviar una contribuci&oacute;n

Ya encontraste un proyecto que te gustaba, y est&aacute;s listo para hacer una contribuci&oacute;n. ¡Por fin! A continuaci&oacute;n de mostramos c&oacute;mo hacer que tu contribuci&oacute;n siga por el buen camino.

### Comunic&aacute;ndote de manera efectiva

Sin importar si eres un colaborador para una sola vez o est&aacute;s intentando unirte a una comunidad, trabajar con otras personas es una de las habilidades m&aacute;s importantes que desarrollar&aacute;s en un proyecto de c&oacute;digo abierto.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shubheksha?s=180" class="pquote-avatar" alt="avatar">
  \[Como un nuevo colaborador,\] me di cuenta r&aacute;pidamente que necesitaba hacer preguntas si quer&iacute;a poder cerrar el problema. Recorr&iacute; el c&oacute;digo base. Una vez que comprend&iacute; lo que estaba ocurriendo, pregunt&eacute; que me orientaran. ¡Y voilà! Pude resolver el problema luego de conseguir todos los detalles relevantes que necesitaba.
  <p markdown="1" class="pquote-credit">
— @shubheksha, [El Muy Accidentado Viaje de un Principiante a trav&eacute;s del Mundo del C&oacute;digo Abierto](https://medium.freecodecamp.com/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39#.pcswr2e78)
  </p>
</aside>

Antes de abrir un problema o un pull request, o de hacer una pregunta en un chat, ten en cuenta los siguientes puntos para ayudar a que tus ideas lleguen a buen puerto de manera efectiva.

**Da contexto.** Ayuda a los dem&aacute;s a ponerse al d&iacute;a r&aacute;pidamente. Si tienes un error, explica lo que est&aacute;s tratando de hacer y c&oacute;mo reproducirlo. Si est&aacute;s sugiriendo una nueva idea, explica por qu&eacute; crees que ser&iacute;a &uacute;til para el proyecto (¡no solamente para t&iacute;¡).

> 😇 _"No ocurre X cuando yo hago Y"_
>
> 😢 _"¡X se ha roto! Por favor rep&aacute;renlo."_

**Haz tu tarea de antemano.** Est&aacute; bien desconocer cosas, pero mostrando que lo intentaste. Antes de solicitar ayuda, aseg&uacute;rate de comprobar el README, la documentaci&oacute;n, los problemas (abiertos o cerrados), la lista de correos, y de buscar en internet por una respuesta. Las personas agradecer&aacute;n cuando demuestres que est&aacute;s tratando de aprender.

> 😇 _"No estoy seguro de c&oacute;mo implementar X. Verifiqu&eacute; en los documentos de ayuda y no encontr&eacute; ninguna menci&oacute;n."_
>
> 😢 _"¿C&oacute;mo soluciono X?"_

**Mant&eacute;n tus solicitudes cortas y directas.** Al igual que el env&iacute;o de un correo, cualquier contribuci&oacute;n, sin importar lo simple o &uacute;til que sea, requiere la revisi&oacute;n de parte de otra persona. Muchos proyectos tienen m&aacute;s solicitudes de entrada que personas disponibles para ayudar. Se conciso. Aumentar&aacute;s las probabilidades de que &aacute;lguien pueda ayudarte.

> 😇 _"Me gustar&iacute;a escribir un tutorial para una API."_
>
> 😢 _"D&iacute;as atr&aacute;s estaba manejando por la autopista y me detuve para cargar combustible, y entonces tuve la gran idea de algo que deber&iacute;amos estar haciendo pero antes de explicarlo, perm&iacute;tanme mostrarles..."_

**Mant&eacute;n todas las comunicaciones p&uacute;blicas.** Pese a que es tentador, no te dirijas a los responsables de manera privada a menos que necesites compartir informaci&oacute;n sensible (como un problema de seguridad o violaciones a la conducta serias). Cuando mantienes las conversaciones p&uacute;blicas, m&aacute;s personas pueden aprender y verse beneficiadas de tu intercambio. La discusi&oacute;n puede ser, en s&iacute; misma, una contribuci&oacute;n.

> 😇 _(como un comentario) "@-responsable ¡Qu&eacute; tal! ¿C&oacute;mo deber&iacute;amos proceder con &eacute;ste PR?"_
>
> 😢 _(como un correo electr&oacute;nico) "Que tal, disculpa que te moleste con un correo electr&oacute;nico, pero me estaba preguntando si tendr&aacute;s la oportunidad de revisar mi PR"_

**Est&aacute; bien hacer preguntas (¡pero se paciente!).** Todos fueron nuevos en el proyecto en alg&uacute;n momento, e incluso los colaboradores experimentados necesitan ponerse al d&iacute;a cuando miran un nuevo proyecto. Por lo mismo, incluso responsables de mucha antig&uuml;edad no est&aacute;n siempre familiarizados con todas las partes del proyecto. Mu&eacute;strales la misma paciencia que quieres que ellos tengan contigo.

> 😇 _"Gracias por estudiar &eacute;ste error. Segu&iacute; tus sugerencias. Esta es la salida."_
>
> 😢 _"¿Por qu&eacute; no pueden solucionar mi problema? ¿No es este acaso su proyecto?"_

**Respeta las decisiones de la comunidad.** Tus ideas pueden ser diferentes a las prioridades de la comunidad o a la visi&oacute;n. Pueden devolverte alguna retroalimentaci&oacute;n o decidir no continuar con tu idea. Mientras que tu buscas atenci&oacute;n y compromiso, los responsables deben convivir con tu decisi&oacute;n por m&aacute;s tiempo que t&uacute;. Si no est&aacute;s de acuerdo con la direcci&oacute;n tomada, siempre puedes trabajar en tu propio fork o comenzar tu propio proyecto.

> 😇 _"Lamento que no puedan dar soporte a mi situaci&oacute;n, pero como lo explicas solo afecta a una minor&iacute;a de usuarios, y lo entiendo. Gracias por escuchar."_
>
> 😢 _"¿Por qu&eacute; no dan soporte a mi situaci&oacute;n? ¡Es inaceptable!"_

**Por encima de todo mantenlo con clase.** El c&oacute;digo abierto est&aacute; formado por colaboradores de todo el mundo. El contexto se pierde a trav&eacute;s de idiomas, culturas, geograf&iacute;as y zonas horarias. Adem&aacute;s, la comunicaci&oacute;n escrita hace m&aacute;s dif&iacute;cil transmitir un tono o estado de &aacute;nimo. Asume buenas intenciones en esas conversaciones. Est&aacute; bien, tratando de volver a una idea, solicitar m&aacute;s contexto, o aclarar m&aacute;s tu posici&oacute;n. Trata de dejar a Internet como un lugar mejor del que t&uacute; lo encontraste.

### Dando contexto

Antes de hacer nada, haz una r&aacute;pida verificaci&oacute;n para asegurarte que tu idea no se haya discutido anteriormente. Navega por el README del proyecto, los problemas (abiertos y cerrados), lista de correos electr&oacute;nicos, y en Stack Overflow. No necesitas dedicar horas para todo esto, pero una mirada r&aacute;pida buscando algunas palabras clave resolver&aacute; gran parte de la tarea.

Si no puedes encontrar tu idea en ning&uacute;n otro lado, est&aacute;s listo para dar el paso. Si el proyecto est&aacute; en GitHub, es probable que lo comuniques abriendo un problema o un pull request:

* **Problemas (Issues)** son como comenzar una conversaci&oacute;n o discusi&oacute;n
* **Pull requests** son para comenzar a trabajar en una soluci&oacute;n
* **Para una comunicaci&oacute;n ligera,** como una explicaci&oacute;n o una pregunta de "c&oacute;mo", trata preguntando en Stack Overflow, IRC, Slack u otro canal de chat, si el proyecto tiene alguno

Antes de abrir un problema o un pull request, verifica los documentos de verificaci&oacute;n del proyecto (com&uacute;nmente es un archivo que se llama CONTRIBUTING), para ver si se necesitan incluir algo espec&iacute;fico, puede ser que soliciten que respetes un modelo, o requerir que utilices pruebas.

Si quieres hacer una contribuci&oacute;n sustancial, abre un problema para preguntar antes de ponerte a trabajar en ello. Es de gran ayuda observar el proyecto por un tiempo (en GitHub, [puedes hacer click en "Watch"](https://help.github.com/articles/watching-repositories/) para ser notificado de todas las conversaciones), y conocer a los miembros de la comunidad, antes de realizar trabajo alguno que pueda no ser aceptado.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gaearon?s=180" class="pquote-avatar" alt="avatar">
    Aprender&aacute;s <em>mucho</em> tomando un proyecto que utilizas activamente, "observarlo" en GitHub y leyendo cada problema y PR.
<p markdown="1" class="pquote-credit">
— @gaearon [sobre la adhesi&oacute;n a proyectos](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### Abriendo un problema

Frecuentemente deber&iacute;as abrir un problema en las siguientes situaciones:

* Reportar un error que t&uacute; no puedes resolver
* Discutir un t&oacute;pico o idea de alto nivel (por ejemplo sobre la comunidad, la visi&oacute;n o pol&iacute;ticas)
* Proponer una nueva caracter&iacute;stica u otra idea del proyecto

Consejos para comunicar los problemas:

* **Si ves un problema abierto en el que quieres entrar,** com&eacute;ntalo en el problema, para permitir que las personas sepan que te preocupa. De esa manera, es menos probable que se duplique el trabajo en la comunidad.
* **Si un problema fue abierto hace mucho tiempo,** es posible que se est&eacute; tratando en otro lugar o que ya haya sido resuelto, de modo que primero pregunta por una confirmaci&oacute;n antes de ponerte a trabajar.
* **Si abriste un problema, pero m&aacute;s tarde descubriste que estaba resuelto,** comenta en tu propio problema, para que las personas lo sepan, y luego cierra el problema. Incluso documentar ese resultado es una contribuci&oacute;n al proyecto.

### Abriendo un pull request

Usualmente deber&iacute;as abrir un pull request en las siguientes situaciones:

* Enviar arreglos triviales (por ejemplo una correcci&oacute;n tipogr&aacute;fica, un link ca&iacute;do o un error obvio)
* Comenzar a trabajar en una contribuci&oacute;n que ya fue solicitada, o que ya discutiste en un problema

Un pull request no representa trabajo terminado. Usualmente es mejor abrir un pull request de forma temprana, de manera que otros puedan observar o dar retroalimentaci&oacute;n a tu progreso. Solo m&aacute;rcalo como "trabajo en proceso" (WIP por sus siglas en ingl&eacute;s, work in progress) en la l&iacute;nea del tema. Siempre puedes agregar m&aacute;s commits despu&eacute;s.

Si el proyecto est&aacute; alojado en GITHUb, ac&aacute; te explicamos los pasos para enviar un pull request:

* **[Abre un fork del repositorio](https://guides.github.com/activities/forking/)** y haz un clon local. Conecta tu repositorio local con el repositorio "superior" original agreg&aacute;ndolo como remoto. Descarga los cambios desde el repositorio superior con frecuencia de manera que puedas mantener al d&iacute;a, de forma que cuando tu env&iacute;es tu pull request, sea menos probable que haya conflictos. (ver m&aacute;s instrucciones detalladas [aqu&iacute;](https://help.github.com/articles/syncing-a-fork/).)
* **[Crea una rama](https://guides.github.com/introduction/flow/)** para tus ediciones.
* **Haz referencia a cualquier problema relevante** o documentaci&oacute;n de soporte en tu PR (por ejemplo "Cierra #37.")
* **Incluye capturas de pantalla del antes y del despu&eacute;s** si tus cambios incluyen diferencias en el HTML o CSS. Arrastra y suelta las im&aacute;genes en el cuerpo de tu pull request.
* **¡Has pruebas de tus cambios!** Corre tus cambios contra las pruebas existentes si realmente existen, y crea nuevas pruebas si es necesario. Sin importar que existan o no las pruebas, aseg&uacute;rate que tus cambios no produzcan roturas del proyecto existente.
* **Contribuye con el estilo del proyecto** con el m&aacute;ximo de tus capacidades. Esto significa utilizar indentaci&oacute;n, punto y comas o comentarios de manera diferente a lo que har&iacute;as en tu repositorio, pero que hacen m&aacute;s sencillo para los responsables combinar y para otros de entender y mantener el proyecto en el futuro.

Si se trata de tu primer pull request, verifica [Haz un Pull Request](http://makeapullrequest.com/), que fue creado por @kentcdodds como un recurso de recorrido gratuito.

## Qu&eacute; pasa luego de que enviaste una contribuci&oacute;n

¡Lo hiciste! Felicitaciones por convertirte en un colaborador open source. Esperamos que &eacute;sta sea la primera de muchas.

Luego de que enviaste tu contribuci&oacute;n, una de las siguientes situaciones puede ocurrir:

### 😭 No tienes una respuesta.

Ojal&aacute; que  [hayas verificado el proyecto buscando signos de actividad](#una-lista-de-verificación-antes-de-que-contribuyas) antes de hacer cualquier contribuci&oacute;n. Incluso en proyectos activos, de cualquier manera, es posible que tu contribuci&oacute;n no tenga una respuesta.

Si no tuviste una respuesta en m&aacute;s de una semana, es justo responder en el mismo hilo, preguntando a &aacute;lguien por una revisi&oacute;n. Si conoces el nombre de la persona correcta para que revise tu contribuci&oacute;n, puedes hacer una @-menci&oacute;n en ese hilo.

**No contactes a esa persona** de manera privada; recuerda que las comunicaciones p&uacute;blicas son vitales para los proyectos de c&oacute;digo abierto.

Si haces una llamada educada y todav&iacute;a nadie responde, es posible que nadie te responda jam&aacute;s. No es un sentimiento agradable, pero no dejes que te desanime. ¡Les pasa a todos! Existen muchas razones posibles por las que no tuviste tu respuesta, incluyendo circunstancias personales que pueden estar fuera de control. Trata de encontrar otro proyecto u otra forma de contribuir. En todo caso, &eacute;sta es una buena raz&oacute;n para no invertir mucho tiempo en hacer contribuciones antes de ver que existen otros miembros en la comunidad que est&aacute;n comprometidos y responden.

### 🚧 Alguien pide cambios a tu colaboraci&oacute;n.

Es com&uacute;n que te pidan hacer cambios a tu contribuci&oacute;n, ya sea una retroalimentaci&oacute;n sobre el alcance de tu idea, o cambios en tu c&oacute;digo.

Cuando &aacute;lguien te pide cambios, comp&oacute;rtate de manera sensible, Se tomaron el tiempo necesario para revisar tu contribuci&oacute;n. Abrir un pull request y luego alejarse es de malos modales. Si no sabes c&oacute;mo hacer los cambios, investiga el problema, y luego pregunta por ayuda si la necesitas.

Si no tienes el tiempo para volver a trabajar en ese problema (por ejemplo, si la conversaci&oacute;n tuvo lugar durante meses, y tus circunstancias cambiaron), permite que el responsable lo sepa, de manera que no quede a la espera de una respuesta. Alguien puede sentirse complacido de hacerse cargo.

### 👎 Tu contribuci&oacute;n no es aceptada.

Al final tu contribuci&oacute;n puede o no ser aceptada. Con suerte, no hayas necesitado poner demasiado esfuerzo en ella. Si no est&aacute;s seguro de por qu&eacute; no fue aceptada, es completamente razonable preguntar al responsable por retroalimentaci&oacute;n y esclarecimiento. De cualquier manera, al final debes aceptar que se trata de su decisi&oacute;n. No discutas ni adoptes una postura hostil. ¡Siempre ser&aacute;s bienvenido a hacer un fork y trabajar en tu propia versi&oacute;n si no est&aacute;s de acuerdo!

### 🎉 Tu contribuci&oacute;n es aceptada.

¡Hurra! ¡Hiciste una contribuci&oacute;n al c&oacute;digo abierto exitosamente!

## ¡Lo hiciste!

Si acabas de hacer tu primera contribuci&oacute;n al c&oacute;digo abierto, o si est&aacute;s buscando nuevas formas de contribuir, esperamos que est&eacute; inspirado para continuar la acci&oacute;n. Si tu contribuci&oacute;n no fue aceptada, no te olvides de dar las gracias cuando un responsable puso esfuerzo en ayudarte. El c&oacute;digo abierto es llevado adelante por personas como tu: un problema, un pull request, un comentario o choca esos cinco por vez.
