---
lang: zh-cn
title: 如何为开源做贡献
description: 想为开源贡献力量？本指南针为"菜鸟"和初学者而准备！
class: contribute
order: 1
image: /assets/images/cards/contribute.png
related:
  - beginners
  - building
---

## Why contribute to open source?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/errietta?s=180" class="pquote-avatar" alt="avatar">
  在 \[自由代码\] 下工作，让我学习到了职业生涯中非常重要的技能，无论是大学还是实际的工作，我认为从开源项目中得到的收获的远大於我的贡献！
  <p markdown="1" class="pquote-credit">
— @errietta, ["我为何是如此的热衷于为开源软件贡献力量"](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

为开源贡献力量，得到的回报就是能够学习到很多、受教很多、且能够锻炼任何你能够想到的经验。

为什么会有人为开源做贡献？这可能是很多人都不明白的地方，这里不妨列出一些！

### 巩固现有技能

无论是撰写代码、设计用户界面、图形设计、撰写文档、亦或是组织活动，假如你有实践的愿望，你总能在开源项目中找到自己的位置。

### 遇见那些和你"臭味相投"的人

开源项目一般都会有一个和谐、热心的社区，以让大家团结一致。实际上，开源界经常发生这样的情形，很多人的深厚友谊都是通过共同参与开源所建立起来的，至于具体的方式，可能是在一次技术研讨会上相谈甚欢，也可能是一直在聊天室中探讨问题。

### 寻找导师，并且尝试帮助他人

和他人共同在一个共享的项目下工作，这意味着需要向他人解释清楚自己是如何做的，同理，也需要向他人求助，询问别人是如何做的。相互学习和彼此教学对于每位参与者都能满载而归。

### 在公众间建立你的声誉（职业口碑）

根据开源的定义，你在开源下所有的工作都是公开的，这也就意味着开源项目是一个很好展示你实力的地方。

### 学习领导和管理的艺术

开源为实践领导力和管理技能提供了很好的机会，比如解决冲突、组织团队、工作的优先级排列。

### 鼓励作出改变，哪怕改变是很微小的

在开源的世界里，作出贡献的不一定非得是花了很长时间拥有大量经验的人。你是否遇到过浏览某些网站发现有拼写错误，希望有人能修改它？其实，在开源的项目中，你只需要做就可以了。没有那么多的顾忌，开源让人们在很舒服的状态做事，而这才是这个世界应有的体验。

## What it means to contribute

如果你是一名开源界的新手，可能会对贡献的流程心生畏惧。比如：该如何找到正确的项目？不懂编码又想参与怎么办？万一做错事情了怎么办？

其实没有关系的啦！条条大路通罗马，开源项目有太多的路径可以参与！以下是一些实用的技巧，帮助你快速的获得经验。

### 你不具备编码的能力

对于为开源做贡献常见的误解就是：为开源做贡献必须得提交代码。事实上，代码固然重要，但是项目中不需编码的重要部分[经常被忽视](https://github.com/blog/2195-the-shape-of-open-source)。你若做了这部分，对于项目来说可是莫大的贡献，而这根本就不需要什么撰写代码！

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/orta?s=180" class="pquote-avatar" alt="avatar">
  我被大家所熟知是因为为 CocoaPods 做了一些事, 其实大伙并不知道我实际并没有为 CocoaPods本身做了什么，我大多数的工作是诸如撰写文档、品牌宣传之类的。
  <p markdown="1" class="pquote-credit">
— @orta, ["默认迁移到开源软件"](https://realm.io/news/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

即使你是一位开发者，非代码的贡献对于项目来说也是举足轻重的，尤其是对于社区的其他成员来说。用心维系这些关系能够让你有工作到项目其它部分的机会。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/brettcannon?s=180" class="pquote-avatar" alt="avatar">
  我第一次接触Python开发团队（简称 python-dev)是在 2002年6月17日，当时我是向其邮件列表发送了一份邮件，是关于请求通过我的补丁的。我很快就又发现了开源的bug，于是决定开始为小组收集邮件摘要，然后他们给了我一个澄清问题的理由，但是更加重要的是，我能够捕获到某人指出需要修复的问题。
  <p markdown="1" class="pquote-credit">
— @brettcannon, ["维护者的故事"](https://github.com/open-source/stories/brettcannon)
  </p>
</aside>

### 是否热衷于规划事件？

* 为项目组织研讨会或线下分享，[一如 @fzamperin 为 NodeSchool 所做的那样](https://github.com/nodeschool/organizers/issues/406)
* 为项目组织大型会议（假如它有的话）
* 帮助社区成员寻找合适的技术会议，且帮助有实力的成员提交演讲的拟稿

### 是否偏向于设计？

* 重新布置布局以提高项目的可用性
* 进行用户研究以重新组织和完善项目的导航或菜单
* 整理一个风格指南，以帮助项目有一致的视觉设计
* 创建t恤的艺术或一个新的标志，[就像 hapi.js 的贡献者那样](https://github.com/hapijs/contrib/issues/68)

### 你是否热衷于写作？

* 撰写和改进项目的文档
* 能够以实例来展示项目该如何使用的
* 为项目撰写新闻稿，或者到邮件列表高调布道
* 为项目撰写教程， [一如 pypa 的贡献者所做的](https://github.com/pypa/python-packaging-user-guide/issues/194)
* 翻译项目的文档为本土语言

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kittens?s=180" class="pquote-avatar" alt="avatar">
  说真心话， \[文档\] 是非常重要的. 目前Babel的文档已经很棒了，这也是其杀手锏的特性之一。当然，还有一些章节需要大家的完善，即使是随便在哪儿增加一个段落都很感激。
  <p markdown="1" class="pquote-credit">
— @kittens, ["贡献者召集令"](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### 你喜欢组织活动吗？

* 链接重复的问题，并建议新的问题标签，使事物井井有条
* 通过开放的问题，并建议关闭旧的，[就像 @nzakas 为 eslint 做的](https://github.com/eslint/eslint/issues/6765)
* 把最近开放的问题阐述清晰，以推动讨论

### 享受编码的乐趣？

* 找到一个开放的问题并解决它，[就像 @dianjin 为 Leaflet 做的](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560)
* 想一想你是否可以帮忙写一个新的功能
* 自动化项目设置
* 改进工具和测试

### 热衷于帮助他人？

* 回答关于项目的问题，例如在 Stack Overflow（[像 Postgres 的这个示例](https://stackoverflow.com/questions/18664074/getting-error-peer-authentication-failed-for-user-postgres-when-to-ge)）或者 reddit 上
* 为人们解答公开的问题
* 帮助缓和讨论板或对话渠道

### 在编码方面是否喜欢帮助他人？

* 为他人的提交审核代码
* 为如何利用项目撰写教程
* 为其他贡献者做导师， [正如 @ereichert 为 @bronzdoc 所做的那样，哦，是 Rust 项目](https://github.com/rust-lang/book/issues/123#issuecomment-238049666)

### 其实不必一定是软件项目！

尽管人们一提起"开源"二字，默认就是指开源软件，其实不尽然，开源可以是任何事情的修饰，而不仅仅是指软件而言的。比如图书、食谱、列表、以及任何可以开源的项目类。

举例来说：

* @sindresorhus 创建了 ["惊奇" 列表](https://github.com/sindresorhus/awesome)
* @h5bp 维护了针对前端开发者的[面试题](https://github.com/h5bp/Front-end-Developer-Interview-Questions)
* @stuartlynn 和 @nicole-a-tesla 制作了[收集关于海雀的有趣的事实](https://github.com/stuartlynn/puffin_facts)

尽管你是一名软件开发者，也可以去撰写一些文档去帮助新的入门者。其实项目中那些看起来令人生畏的项目并不是写代码，做开发者总得挑战自己，其实在做得过程中可以增强信心和获得全新的体验。

## Orienting yourself to a new project

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shaunagm?s=180" class="pquote-avatar" alt="avatar">
  如果你跟着了一条issue，还发现了令人感到困惑的事情，这很正常，不是你一个人这样。这些工具需要大量的隐式的知识，但是总会有人带着你熟悉这些，当然你要找他们问对的问题。
  <p markdown="1" class="pquote-credit">
— @shaunagm, ["如何为开源做贡献"](https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/)
  </p>
</aside>

为开源做贡献，除了单词拼写错误之外，大多数时候就像是走在陌生人中间，浑身上下不适。这就像人们已经在西边讨论的非常深入了，你突然开始讲东，肯定会让人感到不舒服。

与其盲目的在项目中游荡，不如静下心来学习规则。这样反而会让你的想法被注意到，也会有人听到你的声音。

### 分析感兴趣的开源项目

每一个开源社区都是不一样的。

在某一个开源项目扎根多年，这意味着你只是对这一个开源项目无比的熟悉。若是切换到不同的项目，可能会发现完全是另外一回事，所谓的使用词汇、习惯用语、沟通方式都发生了变化。

然而，很多的开源项目还是遵循类似的组织结构的。理解不同的社区角色和全部的流程，可以很好的帮助你快速的切入新的项目。

一个典型的开源项目均会有如下类型的人：

* **作者:** 项目的创始人或创始组织
* **归属者:** 代码仓库或组织的管理员（不一定和作者是同一个人）
* **维护者:** 贡献者，负责项目的未来走向和组织的管理（他们通常也是项目的作者或归属者。）
* **贡献者:** 只要是为项目做出了贡献，就算。
* **社区成员:** 那些实用项目的人们。他们或许是积极的讨论者，又或者是为项目的方向提出意见的人。

一个较大的项目，可能下面还会细分子社区，或者是针对不同的任务分成不同的小组，比如工具小组、分流、社区事务、以及活动组织等。径直到项目到web站点，找到"团队"页面，或者是查看治理文档，从而获得类似到信息。

靠谱的开源项目，一般都会有一个文档的，这些文档文件通常会在代码仓库的顶级目录列出。

* **许可协议:** 根据开源软件的定义，每一个开源项目必须是有[开源许可协议](https://choosealicense.com)的. 可以这么认为：假如说某个项目源码开放，但是没有任何的许可协议，那么它就不能叫做开源。
* **README:**  README 是一个介绍性的说明文件，对初次光临社区对人们表示欢迎，它通常会解释项目有何用处，为何发起，以及如何快速入门等。
* **贡献:**  READMES 帮助人们来认识项目，贡献这个文件则是帮助对项目如何做贡献。它解释了目前项目需要什么样类型对贡献者，社区对流程是啥样的。并非所有的项目都会有这个文件，它某种程度上也是展示项目对于贡献者的友好程度。
* **行为准则:** 顾名思义，即是一些参与社区时的一些礼仪、说话方式、行为等，帮助形成一种友好的氛围，不是所有的项目都会撰写行为准则文件，它某种程度上也是展示项目对于贡献者的友好程度。
* **其它文档:** 有些项目也许还有其它文档，例如教程、导游，或者是治理规则，这在大型项目中常见。

此外，开源项目还会利用如下一些工具来进行组织讨论，阅读这些归档对于理解社区的想法、是如何工作的有非常大的作用。

* **问题追踪:** 这里是人们讨论项目相关问题的地方。
* **Pull requests:** 审核代码、以及相关的问题讨论。
* **论坛或邮件列表:** 一些项目会实用会话式的主题（例如 _"How do I..."_ 或 _"What do you think about..."_ 来替代Bug报告或特性请求）。然而有一些项目关于讨论全部实用问题追踪。
* **即时在线聊天:** 有一些项目会实用聊天频道（诸如 Slack 或 IRC），从而能够随意的谈话、协作和快速交流。

## Finding a project to contribute to

你读到这里，说明已经对于一个开源项目如何运作的有了清晰的认识，是该找一个合适的项目做贡献的时候了！

假如你之前从来都没有为开源做过贡献的话，那么请记住来自美国总统约翰 F.肯尼迪的这段话：**不要问你的国家能为你做什么，要问你能为国家做什么。**

开源项目的方方面面都需要贡献者，你先不要通盘考虑该往哪里贡献，或者是它将如何看。

相反，从你已经使用到的或者打算用到项目开启贡献之路，在你积极的贡献过程中，项目也会反馈给你，让你更好的定位自己。

一旦进入某项目，不论何时，你都要听从自己的直觉，做你认为更好或者不同的事情。

开源并不是高级俱乐部；它就是由你这样的人所浇铸和打造。**"开源"只是针对这个世界的需要修复的问题的一个梦幻术语罢了。**

你或许在查看 README的时候，发现了损坏的链接，又或者拼写错误。又或者是你是一名新手，使用的过程中发现了问题，又或者是某问题应该在文档中注明。请不要坐视不理，径直绕开，或者是请求他人修复，伸出你的援助之手，解决这些你能看到的问题。而这正是开源的精髓之所在！

> [28% 的随意贡献](https://www.igor.pro.br/publica/papers/saner2016.pdf) 就是说明了文档的开源，诸如拼写错误，段落语句调整、或者是翻译。

你也可以利用如下列出的资源来找到合适的新项目：

* [GitHub 探索](https://github.com/explore/)
* [Open Source Friday](https://opensourcefriday.com)
* [First Timers Only](https://www.firsttimersonly.com/)
* [CodeTriage](https://www.codetriage.com/)
* [24 Pull Requests](https://24pullrequests.com/)
* [Up For Grabs](https://up-for-grabs.net/)
* [像忍者一样贡献](https://contributor.ninja)

### A checklist before you contribute

当你找到了你打算贡献的项目时，在进一步行动之前，作一个快速的扫描工作，以确保项目是否接受贡献的。否则，你煞费苦心的工作可能没有任何的回报。

这是一个简易的检查表，用来评估一个项目是否适合新的贡献者。

**符合开源的定义**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
  有许可协议吗？通常情况下，会在根目录有一个叫做 LICENSE 的文件。
  </label>
</div>

**项目被接收的提交活跃度**

在主干上确认提交的活跃度。在GitHub上托管的开源项目，你可以在仓库主页上看到这些信息。

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
  最后一次提交是在什么时候？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
  项目目前有多少贡献者？
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
  人们提交的频繁吗？ (在 GitHub，可以在顶栏里点击"commits"来展现。）
  </label>
</div>

接下来，就是看项目的 issue 数量。

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    目前有多少个还处于开放状态的 issue？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    项目的维护者对于处于开放状态的issue响应是否迅速？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    是否有讨论很活跃的issue？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    issue 均是近期产生的吗？
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    有没有关闭的issue？ (在 GitHub, 点击 "closed" 标签就可以看到所有已经关闭的issue。)
  </label>
</div>

同样再来看看 PR的情形。

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    现下有多少处于开放状态的PR？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">
    当提交了PR后，维护者响应是否迅速？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    是否有活跃讨论的 PR？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    均是近期的RP吗？
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">
    最近有多少PR合并？ (在 GitHub, 点击 RP页面的 "closed" 的标签页来查看已经关闭的标签页。)
  </label>
</div>

**项目的受欢迎程度**

一个项目的友好程度和受欢迎意味着更能吸引新的贡献者。

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">
    在issue的问题中，维护者的回答是否非常有帮助？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">
    人们在issue的讨论中、在线聊天室、论坛是否很友好？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">
    PR是否被review？
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">
    维护者是否对做贡献的人们道声"谢谢"？
  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  当你看到一个很长的对话时，来自核心开发者的零星的响应排在列表的后面。你就得考虑，他们在作建设性的总结？是否保持风度的情况下做出最后的决定？如果你看到的是更多的口水仗，而且还在继续，这通常意味着社区的能量重心已经不在开发上了。
  <p markdown="1" class="pquote-credit">
— @kfogel, [_开源软件生产力_](https://producingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## How to submit a contribution

你已经找到了你喜爱的项目，也已准备好贡献了，迫不及待、跃跃欲试了。好吧！以下就是带领你如何以正确的姿势作贡献。

### 有效沟通

无论你处于什么样的目的：仅仅是一次性的贡献，亦或是永久性的加入社区，都的和他人进行沟通和交往，这是你要在开源圈发展必须修炼的技能。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shubheksha?s=180" class="pquote-avatar" alt="avatar">
  \[作为一名新手,\] 我很快的就意识到，我若是要关闭一条issue时，我不得不问更多的问题。我浏览了代码库，一旦我觉得有什么问题的时候，我就得需要更多的指点，瞧！ 在我得到所有的所需要的信息后，我就可以解决这个问题！
  <p markdown="1" class="pquote-credit">
— @shubheksha, [一名菜鸟进入开源世界的坎坷之旅](https://medium.freecodecamp.com/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39#.pcswr2e78)
  </p>
</aside>

在你开启一个isse或PR之前，或者是在聊天室问问题之前，请牢记下面所列出的几点建议，会让你的工作更加的高效。

**给出上下文** 以便于让其他人能够快速的理解。比方说你运行程序时遇到一个错误，要解释你是如何做的，并描述如何才能再现错误现象。又比方说你是提交一个新的想法，要解释你为什么这么想，对于项目有用处吗（不仅仅是只有你！）

> 😇 _"当我做 Y 的时候 X 不能工作"_
>
> 😢 _"X 出问题! 请修复它。"_

**在进一步行动前，做好准备工作。** 不知道没关系，但是要展现你尝试过、努力过。在寻求帮助之前，请确认阅读了项目的 README、文档、问题（开放的和关闭的）、邮件列表，并搜索了网络。当你表现出很强烈的求知欲的时候，人们是非常欣赏这点的，会很乐意的帮助你。

> 😇 _"我不确定 X 是如何实现的，我查阅了相关的帮助文档，然而毫无所获。"_
>
> 😢 _"我该怎么做 X ?"_

**保持请求内容短小而直接。** 正如发送一份邮件，每一次的贡献，无论是多么的简单，都是需要他人去查阅的。很多项目都是请求的人多，提供帮助的人少。相信我，保持简洁，你能得到他人帮助的机会会大大的增加。

> 😇 _"我很乐意写 API 的教程。"_
>
> 😢 _" 有一天我驾驶汽车行驶在高速公路上，在某个加油站加油的时候，突发奇想，我们应该这么做，不过在我进一步解释之前，我先和大家展示一下。。。"_

**让所有的沟通都是在公开场合下进行。** 哪怕是很不起眼的小事，也不要去给维护者发私信，除非是你要分享一些敏感信息（诸如安全问题或严重的过失）。你若能够保持谈话是公开的，很多人可以你们交换的意见中学习和受益。

> 😇 _(评论) "@维护者 你好！我们该如何处理这个PR？"_
>
> 😢 _(邮件) "你好，非常抱歉给发信，但是我实在很希望你能看一下我提交的PR。"_

**大胆的提问（但是要谨慎！）。** 每个人参与社区，开始的时候都是新手，哪怕是非常有经验的贡献者也一样，在刚进入一个新的项目的时候，也是新手。出于同样的原因,甚至长期维护人员并不总是熟悉一个项目的每一部分。给他们同样的耐心,你也会得到同样的回报。

> 😇 _"感谢查看了这个错误，我按照您的建议做了，这是输出结果。"_
>
> 😢 _"你为什么不修复我的问题？这难道不是你的项目吗？"_

**尊重社区的决定。** 你的想法可能会和社区的优先级、愿景等有差异，他们可能对于你的想法提供了反馈和最后的决定的理由，这时你应该去积极的讨论，并寻求妥协的办法，维护者必须慎重的考虑你的想法。但是如果你实在是不能同意社区的做法，你可以坚持自己！保持自己的分支，或者另起炉灶。

> 😇 _"你不能支持我的用例，我蛮失望，但是你的解释仅仅是对一小部分用户起作用，我理解是为什么。感谢你的耐心倾听。"_
>
> 😢 _"你为什么不支持我的用例？这是不可接受的！"_

**以上几点，要铭记在心。** 开源是由来自世界各地的人们共同协作实现的。面临的问题是跨语言、跨文化、不同的地理为止、不同的时区，另外，撰写文字的沟通更是难上加难，无法传达语气和情绪。请让这些会话都充满善意吧！在以下情形中请保持礼貌：推动一个想法、请求更多的上下文、进一步澄清你的立场。既然你在互联网找到了自己的所需，那么请尝试让它变得更好！

### 收集上下文

在正式开始之前，做一些快速的检查项，以确保你的想法是没有被讨论过的。遍历项目的 README、问题（开放的和关闭的都算）、邮件列表、Stack Overflow。毋需去花好几个小时去全部折腾一遍，但是使用几个关键的词汇来搜索一下是必要的。

如果你没有找到和你想法一样的内容，你就可以继续了。如果项目是在 GitHub上的话，你可以通过开启一个issue或PR：

* **Issues** 开启一次对话或讨论
* **Pull requests** 请求接受自己的解决方法
* **少量的沟通，** 诸如澄清或how-to的问题，尝试到 Stack Overflow 、IRC、Slack或其它聊天频道。

在你创建issue和PR之前，请检查项目的贡献者文档（文件名通常叫做 CONTRIBUTING，或者就直接包含在README中），找一些你需要的较具体的东西，例如，他们会要求你遵循某个模版，或者是要求你使用某个测试。

如果你做的是一个非常实际的贡献，在正式开启之前，先创建一个issue。监视项目是很有帮助的（在GitHub，[点击 "Watch"](https://help.github.com/articles/watching-repositories/)，所有的对话都会通知到你），要让社区的成员们知道你要做的工作，免得你做了之后，再让他们知道，他们不同意，就浪费了。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gaearon?s=180" class="pquote-avatar" alt="avatar">
  你能够从单个的项目学习到 <em>很多</em> ，只要你踊跃的去使用，在GitHub上密切观察项目，并阅读每一个 issue 和 PR。
<p markdown="1" class="pquote-credit">
— @gaearon [参与项目](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### 创建 issue

你应该在遇到下列情况下，去创建一个 issue：

* 报告你自己无法解决的错误
* 讨论一个高级主题或想法(例如. 社区、远景、政策等)
* 期望实现某新的特性，或者其它项目的想法

在issue的沟通中几点实用的技巧:

* **如果你刚好看到一个开放的issue，恰是你打算解决的，** 添加评论，告诉他人你将负责这个。这样的话，可以避免他人重复劳动。
* **如果说某个issue已经开放很久了，** 这可能是已经有人正在解决中，又或者是早已经解决过了，所以也请添加评论，在打算开启工作之前，最好是确认一下。
* **如果你创建了一issue，但是没多久自己解决了，** 也要添加评论，让其他人知道，然后关闭该issue。记录本身就是为社区的贡献。

### 创建 pull request

在下面的情形时，请你务必使用PR：

* 提交补丁 (例如，纠正拼写错误、损坏的链接、或者是其它较明显的错误）
* 开始一项别人请求的任务，或者是过去在issue中早就讨论过的

一个 PR 并不代表着工作已经完成。它通常是尽早的开启一个PR，是为了其他人可以观看或者给作者反馈意见。只需要在子标题标记为"WIP"（正在进行中）。作者可以在后面添加很多评论。

如果说项目是托管在 GitHub上的，以下是我们总结出的提交RP的建议：

* **[Fork 代码仓库](https://guides.github.com/activities/forking/)** 并克隆到本地，在本地的仓库配置"上游"为远端仓库。这样你可以在提交你的PR时保持和"上游"同步，会减少很多解决冲突的时间。(更多关于同步的说明，请参考[这里](https://help.github.com/articles/syncing-a-fork/).)
* **[创建一个分支](https://guides.github.com/introduction/flow/)** 用于自己编辑。
* **参考任何相关的issue** 或者在你的RP中支持文档(比如. "Closes #37.")
* **包含之前和之后的快照** 如果你的改动是包含了不同的 HTML/CSS。在你的PR中拖拉相应的图片。
* **测试你的改动！** 若测试用例存在的话，跑一遍，以覆盖你的更改，若没有的话，则创建相应的用例。无论测试是否存在，一定要确保你的改动不会破坏掉现有的项目。
* **和项目现有的风格保持一致** 尽你最大的努力，这也就是意味着在使用缩进、分号、以及注释很可能和你自己的风格大相径庭，但是为了节省维护者的精力，以及未来他人更好的理解和维护，还请你容忍一下。

如果这是你第一次提交PR。可以浏览[PR制造](http://makeapullrequest.com/)的文档，这是 @kentcdodds 专门为初次创建PR的人写的公开的资料。

## What happens after you submit a contribution

很不错，你做到了！恭贺你成为开源贡献者。我们希望这是一个良好的开端。

在你提交了贡献之后，下面几种情形中的某种是可能发生的：

### 😭 没有人响应你。

希望你确认在开始工作之前[检查过了项目的活跃度](#a-checklist-before-you-contribute)，不过即使检查过了，也不保证一个活跃的项目，没有人理会你的贡献也是很正常的。

如果过去了一周，依旧没有人响应，请心平气和的在后面跟帖，询求他人帮助你审核下。如果你熟悉某个人可以审核你的贡献，你可以使用@+名字，直接提醒他一下。

**千万不要** 私下里去联系他人；一定要记住，开源项目所有的沟通都应该是公开的。

如果你做了所有该做的事情，还是没有人理你，那就是真的没有人对你的贡献做出响应。这可能感觉上不太好受，但是千万不要灰心。每个人都会遇到这样的情况。其实有太多种原因没有人响应你的提交了，包括很多个人情形都是不在你控制范围的。再接再厉，换一种方法去提交，或者换一个项目。这年头，很多社区成员都在积极的参与和响应他人，都在抢夺优秀的人才，若没有人搭理你，你换地方是没有任何不对的地方的。

### 🚧 其他人的要求你对自己的提交做出变更。

对于自己的提交作出变更这件事非常的普遍，可能是你获得了反馈，也可能是变更了代码。

当有人提出变更时，请表现出大度的地方，要及时响应。他们花时间审核了你的提交，要尊重他们。开启了PR，然后一走了之，是一种恶习。如果你不知道如何修改，请花时间深入研究问题的所在，如果还是没有想到好的办法，那么是该向他人求助的时候了。

如果你因为没有时间而无法继续在此issue继续工作（举例来说，如果对话已经过去了一个月了，没有任何的回复和进度，环境肯定变得不一样了），那么请向维护者告知你无法在及时的响应了，肯定有人非常乐意接替你的工作的。

### 👎 你的贡献没有获得通过。

你的提交最后可能没有被接受。真心希望你没有在此作出过多的努力。如果你不确定为什么没有被接收的话，这正是一个很好的询问维护者反馈和澄清的机会。最终，无论如何，你都要对他们的决定表示尊重。不要去做过多无谓的争论或者是充满敌意的谩骂。如果你坚持自己，你可以随意的fork项目，按照自己的思路发展出分支来。

### 🎉 你的贡献被接收。

太棒了！你已经成功的做到了，为开源做贡献也不过如此！

## You did it!

你刚刚完成了自己的开源贡献处女秀，接下来，你可能打算寻找另外的方法来做贡献，希望本文给你提供了灵感和实践。即使是你的贡献没有被采纳或接收，也不要有失风度，请对帮助过你的维护者表示感谢！

开源就是由你这样的人所铸造：开启一个issue，在提交PR，评论、讨论、收集反馈，直到被接收。就是这么简单。
