---
lang: ta
title: திறந்த மூல திட்டத்தைத் தொடங்குவது
description: திறந்த மூல உலகத்தைப் பற்றி மேலும் அறிந்து உங்கள் சொந்த திட்டத்தைத் தொடங்க தயாராகுங்கள்.
class: beginners
order: 2
image: /assets/images/cards/beginner.png
related:
  - finding
  - building
---

## திறந்த மூலத்தின் "என்ன" மற்றும் "ஏன்"

எனவே திறந்த மூலத்துடன் தொடங்குவது பற்றி நீங்கள் யோசித்துக் கொண்டிருக்கிறீர்களா? வாழ்த்துக்கள்! உங்கள் பங்களிப்பை உலகம் பாராட்டுகிறது. திறந்த மூலத்தின் என்ன, அதை ஏன் மக்கள் செய்வது பற்றி பேசலாம்.

### "திறந்த மூலம்" என்றால் என்ன?

ஒரு திட்டம் திறந்த மூலமாக இருக்கும்போது, அதாவது **உங்கள் திட்டத்தை எந்தவொரு நோக்கத்திற்காகவும் காணலாம், பயன்படுத்தலாம், மாற்றலாம் மற்றும் விநியோகிக்க முடியும்.** இந்த அனுமதிகள் [திறந்த மூல உரிமம்](https://opensource.org/licenses) மூலமாக  செயல்படுத்தப்படும்.

திறந்த மூலம் சக்திவாய்ந்தது, ஏனெனில் இது தத்தெடுப்புக்கு தடைகளை குறைக்கிறது, கருத்துக்களை விரைவில் பரப்ப அனுமதிக்கிறது.

இது எவ்வாறு வேலை செய்கிறது என்பதைப் புரிந்துகொள்வதற்கு, உங்கள் நண்பர் ஒரு உணவருந்த அழைக்கும் பொழுது நீங்கள் ஒரு செர்ரி பை(பழ அப்பம்) கொண்டுவருகிறீர்கள் என கற்பனை செய்து பாருங்கள்

* எல்லோரும் பழ அப்பம் சுவைக்கின்றனர் (_உபயோகித்தல்_)
* பை ஒரு வெற்றி! நீங்கள் வழங்கிய செய்முறையை அவர்கள் கேட்கிறார்கள் (_நோக்குதல்_)
* ஒரு நண்பர், அலெக்ஸ், ஒரு இனிய மாவுப்பண்டம் சமையற்காரர், சர்க்கரையை குறைக்க யோசனை சொன்னார் (_மாற்று_)
* மற்றொரு நண்பர், லிசா, அடுத்த வாரம் ஒரு விருந்துக்கு அதை உபயோகிக்க கேட்கிறார் (_பகிர்தல்_)

ஒப்பீட்டளவில், ஒரு மூடிய மூல செயல்முறை ஒரு உணவகத்திற்கு சென்று செர்ரி பழ அப்பம் ஒரு துண்டு உத்தரவிடுதல். நீங்கள் பழ அப்பம் சாப்பிட ஒரு கட்டணம் செலுத்த வேண்டும், மற்றும் உணவகம் ஒருவேளை நீங்கள் அவர்களின் செய்முறையை கொடுக்காமல் போகலாம். நீங்கள் அவர்களின் பழ அப்பத்தை சரியாக நகலெடுத்து அதை உங்கள் சொந்த பெயரில் விற்பனை செய்தால், உணவகம் உங்களுக்கு எதிராக நடவடிக்கை எடுக்கலாம்.

### ஏன் மக்கள் தங்கள் வேலையை திறந்த மூலமாக்கிறார்கள்?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kentcdodds?s=180" class="pquote-avatar" alt="avatar">
  திறந்த மூலத்தைப் பயன்படுத்துவதற்கும், ஒத்துழைப்பதற்கும் எனக்கு கிடைத்த மிகச் சிறப்பான அனுபவங்களில் ஒன்று, நான் பல பிரச்சனைகளை எதிர்கொள்ளும் பிற நிரலாளர்களுடன் நான் உருவாக்கும் உறவுகளில்தான் வருகிறது.
  <p markdown="1" class="pquote-credit">
— @kentcdodds, ["திறந்த மூலத்தில் நுழைவது எப்படி எனக்கு ஆச்சரியமாக இருக்கிறது"](https://medium.com/@kentcdodds/how-getting-into-open-source-has-been-awesome-for-me-8480cd756a80)
  </p>
</aside>

ஒரு நபர் அல்லது அமைப்பு திட்ட மூலத்தை ஏன் திறக்க வேண்டும் என்பதற்கு [பல காரணங்கள் உள்ளன](https://ben.balter.com/2015/11/23/why-open-source/). சில உதாரணங்கள் பின்வருமாறு:

* **கூட்டு முயற்சி:** திறந்த மூல திட்டங்கள் உலகில் யாரிடமிருந்தும் மாற்றங்களை ஏற்கலாம். உதாரணமாக, [Exercism](https://github.com/exercism/) என்பது, 350 பங்களிப்பாளர்களுடன் உள்ள ஒரு நிரலாக்க பயிற்சிபாட தளமாகும்.

* **ஏற்றல் மற்றும் மறுகலப்பு செய்தல்:** திறந்த மூல திட்டங்களை ஏறக்குறைய எந்த நோக்கத்திற்காகவும் பயன்படுத்தலாம். மற்ற விஷயங்களை உருவாக்க மக்கள் அதை பயன்படுத்தலாம். உதாரணமாக, [b2](https://github.com/WordPress/book/blob/master/Content/Part%201/2-b2-cafelog.md) என்று அழைக்கப்படும் ஒரு திட்டத்தின் ஒரு முனையாகத் துவங்கியது [வேர்ட்பிரஸ்](https://github.com/WordPress).

* **வெளிப்படைத்தன்மை:** தவறுகள் அல்லது முரண்பாடுகளுக்கு எவரும் திறந்த மூல திட்டத்தை ஆய்வு செய்ய முடியும். [பல்கேரியா](https://medium.com/@bozhobg/bulgaria-got-a-law-requiring-source-98bf626cf70a) அல்லது [ஐக்கிய நாடுகள்](https://sourcecode.cio.gov/) போன்ற அரசாங்கங்களுக்கு, வங்கி அல்லது சுகாதாரம் போன்ற ஒழுங்குபடுத்தப்பட்ட தொழிற்சாலைகள், மற்றும் பாதுகாப்பு மென்பொருள் [Let's Encrypt](https://github.com/letsencrypt) போன்றவற்றிற்கு வெளிப்படைத்தன்மை முக்கியமானது.

திறந்த மூலம் மென்பொருளுக்கு மட்டும் அல்ல. தரவு தொகுப்புகளிலிருந்து புத்தகங்கள் வரை அனைத்தையும் திறக்கலாம். நீங்கள் மூலத்தைத் திறக்க முடியும் என்பதில் கருத்துக்களுக்கு [கிட்ஹப் Explore](https://github.com/explore) என்பதைப் பார்க்கவும்.

### திறந்த மூலம் என்றால் "இலவசம்" என்றா அர்த்தம்?

திறந்த மூலத்தின் மிகப்பெரிய சமநிலைகளில் ஒன்று, பணம் செலவாகாது என்பதுதான். "இருப்பினும், "இலவசம்" என்பது திறந்த மூலத்தின் மொத்த மதிப்பின் ஒரு இடை விளைவுப் பொருள் ஆகும்.

[திறந்த மூல உரிமம்](https://opensource.org/osd-annotated) யாராலும் எந்த நோக்கத்திற்காகவும் உங்கள் திட்டத்தை பயன்படுத்தலாம், மாற்றலாம் மற்றும் பகிர்ந்து கொள்ளலாம் என்பதால், திட்டங்கள் தானாகவே கட்டணமின்றி இருக்கின்றன. Iதிட்டத்தை பயன்படுத்த பணம் செலவு என்றால், யாரோனும் சட்டபூர்வமாக ஒரு நகல் எடுத்து அதற்கு பதிலாக இலவச பதிப்பை பயன்படுத்த முடியும்.

இதன் விளைவாக, பெரும்பாலான திறந்த மூல திட்டங்கள் இலவசம், ஆனால் "கட்டணமின்றி" என்பது திறந்த மூல வரையறையின் பகுதியாக இல்லை. திறந்த மூல திட்டங்களளின் வரையறைக்கு உட்பட்டு, திறந்த மூல திட்டங்களுக்கு மறைமுக வழிகாட்டுதல் வழிகாட்டுதல்கள் அல்லது இரட்டை உரிமம் அல்லது வரையறுக்கப்பட்ட அம்சங்கள் மூலம் கட்டணம் வசூலிக்க வழிகள் உள்ளன.

## எனது சொந்த திறந்த மூல திட்டத்தை நான் தொடங்க வேண்டுமா?

குறுகிய பதில், ஆம், பலன் எதுவாயினும் உங்கள் சொந்த திட்டத்தை தொடங்குவது எப்படி திறந்த மூல வேலை என்பதை அறிய ஒரு சிறந்த வழியாகும்.

நீங்கள் முன்பு ஒரு திட்டத்தை ஆதரிக்கவில்லை என்றால், மக்கள் என்ன சொல்கிறார்களோ, அல்லது யாரிடமாவது கவனிக்கிறார்களா என நீங்கள் கவலைப்படலாம். இது போன்று உங்களுக்கு தோன்றினால், நீங்கள் தனியாக இல்லை!

திறந்த மூல வேலை என்பது மற்ற படைப்பாற்றல் செயல்பாடுகளைப் போலவே, அது எழுதுவது அல்லது ஓவியமாக இருந்தாலும். உங்கள் வேலையை உலகத்துடன் பகிர்ந்து கொள்ள பயமாக இருக்கலாம், ஆனால் சிறந்த விளங்க ஒரே வழி பயிற்சியின் மூலம் மட்டுமே - உங்களுக்கு ஒரு பார்வையாளர் இல்லையென்றாலும் கூட.

நீங்கள் இன்னும் நம்பவில்லை என்றால், உங்கள் குறிக்கோள்களைப் பற்றி சிந்திக்க சிறிது நேரம் ஒதுக்குங்கள்.

### உங்கள் இலக்குகளை அமைத்தல்

இலக்குகள் எதைப் பற்றி வேலை செய்ய வேண்டும், எதைப் பற்றி சொல்ல வேண்டும், மற்றவர்களிடமிருந்து உங்களுக்கு உதவி தேவை என்பவற்றைக் கண்டுபிடிக்க உதவுகிறது. உங்களை நீங்களே கேட்டுக் கொள்ளுங்கள், _நான் இந்த திட்டத்தை திறக்க வேண்டும்?_

இந்த கேள்விக்கு ஒரு சரியான பதில் இல்லை. நீங்கள் ஒரு திட்டத்திற்கு பல இலக்குகளை அல்லது பல்வேறு இலக்குகளுடன் வெவ்வேறு திட்டங்களைக் கொண்டிருக்கலாம்.

உங்களுடைய ஒரே குறிக்கோள் உங்கள் வேலையை காட்ட விரும்பினால், நீங்கள் பங்களிப்புகளை விரும்பக்கூடாது, மேலும் உங்கள் README இல் சொல்லவும் கூட இருக்கலாம். மறுபுறம், உங்களுக்கு பங்களிப்பாளர்கள் தேவைப்பட்டால், தெளிவான ஆவணங்கள் மீது நேரத்தை முதலீடு செய்து புதுமுகங்களின் வரவேற்பைப் பெறுவீர்கள்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mavris?s=180" class="pquote-avatar" alt="avatar">
  ஒரு நேரத்தில் நான் தனிப்பயன் UIAlertView ஐ உருவாக்கியிருந்தேன்... அதை திறந்த மூலமாக மாற்ற முடிவு செய்தேன். அதனால் நான் அதை சக்தி வாய்ந்ததாக மாற்றியமைத்து கிட்ஹப் க்கு பதிவேற்றியுள்ளேன். நான் என் முதல் ஆவணத்தை எப்படி நிரலாளர்களுக்கு அவர்கள் திட்டங்களில் அதை பயன்படுத்த வேண்டுமென விளக்கி எழுதினேன். இது ஒரு எளிமையான திட்டமாக இருப்பதால், யாரும் இதைப் பயன்படுத்தவில்லை, ஆனால் என்னுடைய பங்களிப்பைப் பற்றி நான் நன்றாகவே உணர்கிறேன்.
  <p markdown="1" class="pquote-credit">
— @mavris, ["சுய-கற்றல் மென்பொருள் உருவாக்குநர்கள்: ஏன் திறந்த மூல நமக்கு முக்கியம்"](https://medium.com/rocknnull/self-taught-software-engineers-why-open-source-is-important-to-us-fe2a3473a576)
  </p>
</aside>

உங்கள் திட்டம் வளரும் போது, உங்களுடைய சமூகம் உங்களிடமிருந்து வெறும் குறியீட்டை தாண்டி மேலும் எதிர்பார்க்கும். சிக்கல்களை எதிர்கொண்டு, குறியீட்டை மறுபரிசீலனை செய்தல் மற்றும் உங்கள் திட்டத்தை மேம்படுத்துதல் திறந்த மூல திட்டத்தில் உள்ள முக்கிய பணிகளும் ஆகும்.

நீங்கள் நிரலாக்குதல் அல்லாத பணிகளில் நேரம் செலவிடுவது உங்கள் திட்டத்தின் அளவு மற்றும் நோக்கம் சார்ந்து இருக்கும் போது, நீங்கள் அவர்களுக்கு உரையாற்ற ஒரு பராமரிப்பாளராக தயாராக இருங்கள் அல்லது உங்களுக்கு உதவ யாரையாவது அடையாளம் காணுங்கள்.

**நீங்கள் ஒரு திட்டத்தை திறந்த மூலமாக்கும் நிறுவனத்தின் ஒரு பகுதியாக இருந்தால்,** உங்களுடைய திட்டத்தின் உள் ஆதாரங்களை வளர்த்துக்கொள்ள வேண்டும் என்பதை உறுதிப்படுத்தவும். நீங்கள் அறிமுகப்படுத்திய பின்னர் திட்டத்தை பராமரிப்பதற்கு யார் பொறுப்பு என்பதை நீங்கள் அறிய விரும்புகிறீர்கள், உங்கள் சமூகத்துடன் அந்தப் பணிகளை எவ்வாறு பகிர்ந்து கொள்கிறீர்கள் என்பதை நீங்கள் தெரிந்துகொள்ள வேண்டும்.

உங்களுக்கு அர்ப்பணிக்கப்பட்ட வரவு செலவுத் திட்டம் அல்லது தொழில் முன்னேற்ற ஆக்க முயற்சி, இயக்கம் மற்றும் செயல்திட்டத்திற்கான பட்ஜெட் ஊழியர்கள் தேவைப்பட்டால், ஆரம்பத்திலேயே உரையாடல்களைத் தொடங்குங்கள்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/captainsafia?s=180" class="pquote-avatar" alt="avatar">
  நீங்கள் திட்டத்தைத் திறக்க ஆரம்பிக்கும் போது, உங்கள் நிர்வாக செயல்முறைகள் உங்கள் திட்டத்தைச் சுற்றி சமூகத்தின் பங்களிப்புகளையும் திறன்களையும் கருத்தில் கொள்ளுதல் முக்கியம். திட்டத்தின் முக்கிய அம்சங்களில் உங்கள் வியாபாரத்தில் பணியாற்றாத பங்களிப்பாளர்களை உட்படுத்த பயம் வேண்டாம் - குறிப்பாக அடிக்கடி பங்களிப்பவர்களாக இருந்தால்.
  <p markdown="1" class="pquote-credit">
— @captainsafia, ["நீங்கள் ஒரு திட்டம் திறந்த மூலமாக்குகிறீர்கள், ம்ம்?"](https://writing.safia.rocks/2016/12/06/so-you-wanna-open-source-a-project-eh/)
  </p>
</aside>

### மற்ற திட்டங்களுக்கு பங்களிப்பு

மற்றவர்களுடன் எப்படி ஒத்துழைக்க வேண்டும் அல்லது திறந்த மூல வேலை எப்படி இயங்குகிறது என்பதை அறிவது உங்கள் இலக்கு என்றால், ஏற்கனவே இருக்கும் திட்டத்திற்கு பங்களிப்பு செய்யுங்கள். ஏற்கனவே நீங்கள் பயன்படுத்த விரும்பும் திட்டத்தில் தொடங்கவும். ஒரு திட்டத்தில் பங்களிப்பு தட்டச்சு அல்லது ஆவணங்களை பிழைத்திருத்துதல் என எளியமையானதாக இருக்கலாம்.

ஒரு பங்களிப்பாளராக எவ்வாறு தொடங்குவது என்பது உங்களுக்கு தெரியாவிட்டால், எங்கள் [திறந்த மூல வழிகாட்டிக்கு எவ்வாறு பங்களிப்பது](../how-to-contribute/) காணுங்கள்.

## உங்கள் சொந்த திறந்த மூல திட்டத்தை துவக்குதல்

உங்களுடைய வேலையை திறக்க சரியான நேரம் என்று எதுவும் இல்லை. நீங்கள் ஒரு யோசனை, நடப்பிலிருக்கும் வேலை, அல்லது பல ஆண்டுகளாக மூடிய திட்டம் என எதையும் திறக்கலாம்.

பொதுவாக பேசுகையில், உங்கள் திட்டத்தை நீங்கள் மற்றவர்கள் நோக்குவதற்கு மற்றும் உங்கள் வேலையைப் பற்றி கருத்துத் தெரிவிப்பதை வசதியாக கருதும்பொழுது உங்கள் திட்டத்தைத் திறக்க வேண்டும்.

எந்த கட்டத்தில் நீங்கள் உங்கள் திட்டத்தை திறக்க முடிவு செய்தாலும், ஒவ்வொரு திட்டமும் பின்வரும் ஆவணங்கள் சேர்க்கப்பட வேண்டும்:

* [திறந்த மூல உரிமம்](https://help.github.com/articles/open-source-licensing/#where-does-the-license-live-on-my-repository)
* [README](https://help.github.com/articles/create-a-repo/#commit-your-first-change)
* [பங்களிப்பு நெறிமுறைகள்](https://help.github.com/articles/setting-guidelines-for-repository-contributors/)
* [நடத்தை குறியீடு](../code-of-conduct/)

ஒரு பராமரிப்பாளராக, இந்த கூறுகள் எதிர்பார்ப்புகளைத் தொடர்புகொள்வதற்கும், பங்களிப்புகளை நிர்வகிப்பதற்கும், எல்லோருடைய சட்ட உரிமைகளையும் (உங்கள் சொந்த உள்ளடங்கலாக) பாதுகாக்கும். அவர்கள் நேர்மறையான அனுபவத்தைப் பெற்றிருப்பதற்கான வாய்ப்புகளை கணிசமாக அதிகரிக்கிறார்கள்.

உங்கள் திட்டம் கிட்ஹப் இல் இருந்தால், உங்கள் கோப்பகத்தை உங்கள் மூல அடைவில் பரிந்துரைக்கப்படும் கோப்புப்பெயர்கள் மூலம் கிட்ஹப் அங்கீகரிக்கவும், தானாக உங்கள் வாசகர்களுக்கு அவற்றைப் பரப்பவும் உதவும்.

### உரிமம் தெரிவு செய்தல்

திறந்த மூல உரிமம் மற்றவர்கள் பயன்படுத்தலாம், நகலெடுக்கலாம், மாற்றலாம், மற்றும் விளைவுகள் இல்லாமல் உங்கள் திட்டத்திற்கு மீண்டும் பங்களிக்கலாம் என உத்திரவாதம் அளிக்கிறது. இது ஒட்டக்கூடிய சட்டப்பூர்வ சூழ்நிலைகளிலிருந்து உங்களை பாதுகாக்கிறது. **திறந்த மூல திட்டத்தை நீங்கள் தொடங்கும்போது உரிமம் சேர்க்கப்பட வேண்டும்.**

சட்ட வேலை வேடிக்கை இல்லை. நல்ல செய்தி என்னவெனில் உங்கள் களஞ்சியத்தில் ஏற்கனவே உரிமம் நகலெடுத்து ஒட்டலாம். உங்கள் கடின உழைப்பைப் பாதுகாக்க இது ஒரு நிமிடம் மட்டுமே ஆகும்.

[MIT](https://choosealicense.com/licenses/mit/), [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/), மற்றும் [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) மிகவும் பிரபலமான திறந்த மூல உரிமங்கள், ஆனால் தேர்ந்தெடுக்க [மற்ற விருப்பங்கள் தெரிவுகளும் உள்ளன](https://choosealicense.com).

நீங்கள் கிட்ஹப் இல் புதிய திட்டத்தை உருவாக்கும்போது, உரிமம் ஒன்றைத் தேர்ந்தெடுக்கும் உரிமை உங்களுக்கு உள்ளது. ஒரு திறந்த மூல உரிமத்தை உட்படுத்துவது உங்கள் கிட்ஹப் திட்டத்தை திறந்த மூலமாக்கும்.

![உரிமம் தேர்ந்தெடு](/assets/images/starting-a-project/repository-license-picker.png)

ஒரு திறந்த மூல திட்டத்தை நிர்வகிப்பதற்கான சட்ட அம்சங்களைப் பற்றி நீங்கள் மற்ற கேள்விகளை அல்லது கவலையைப் பெற்றிருக்கிறீர்கள் என்றால், [நாங்கள் உங்கள் பாதுகாப்பிற்கு உள்ளோம்](../legal/).

### README எழுதுவது

README கள் உங்கள் திட்டத்தை எவ்வாறு பயன்படுத்துவது என்பதை விளக்கவும். உங்கள் திட்டப்பணிகளுக்கான காரணத்தையும் உங்கள் பயனர்கள் என்ன செய்யலாம் என்பதையும் அவை விளக்கும்.

உங்கள் README இல் பின்வரும் கேள்விகளுக்கு பதிலளிக்க முயற்சி செய்க:

* இந்த திட்டம் என்ன செய்கிறது?
* ஏன் இந்த திட்டம் பயனுள்ளதாக இருக்கும்?
* நான் எப்படி தொடங்குவது?
* எனக்கு உதவி தேவைப்பட்டால், எங்கிருந்து உதவி கிடைக்கும்?

நீங்கள் பங்களிப்புகளை எவ்வாறு கையாளுகிறீர்கள், திட்டத்தின் இலக்குகள் என்ன, உரிமங்கள் மற்றும் பண்புக்கூறு பற்றிய தகவல்கள் போன்ற மற்ற கேள்விகளுக்கு பதிலளிக்க உங்கள் README ஐ பயன்படுத்தலாம். பங்களிப்புகளை ஏற்றுக்கொள்ள விரும்பவில்லை என்றால், அல்லது உங்கள் திட்டம் இன்னும் தயாரிப்புக்கு தயாராக இல்லை என்றால், இந்த தகவலை கீழே எழுதவும்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/tracymakes?s=180" class="pquote-avatar" alt="avatar">
  சிறந்த ஆவணங்கள் என்றால் அதிக பயனர்கள், குறைவான ஆதரவு கோரிக்கைகளும், அதிக பங்களிப்பாளர்கள் ஆகும். (...) உங்கள் வாசகர்கள் நீங்கள் இல்லை என்பதை நினைவில் கொள்ளுங்கள். முற்றிலும் மாறுபட்ட அனுபவங்களைக் கொண்ட ஒரு திட்டத்திற்கு வந்தவர்கள் இருக்கிறார்கள்.
  <p markdown="1" class="pquote-credit">
— @tracymakes, ["எழுதும் உங்கள் சொற்கள் படிக்கப்படவேண்டுமென (காணொளி)"](https://www.youtube.com/watch?v=8LiV759Bje0&list=PLmV2D6sIiX3U03qc-FPXgLFGFkccCEtfv&index=10)
  </p>
</aside>

சில நேரங்களில், மக்கள் ஒரு README எழுதுவதைத் தவிர்ப்பதால், திட்டம் முடிவடையாததுபோல் அவர்கள் உணர்கிறார்கள் அல்லது பங்களிப்புகளை விரும்பவில்லை. இவை ஒவ்வொன்றும் எழுத மிகவும் நல்ல காரணங்கள்.

மேலும் உத்வேகம் பெறுவதற்காக, @18F இன் ["README களை வாசிக்கக்கூடியதாக செய்தல்"](https://pages.18f.gov/open-source-guide/making-readmes-readable/) or @PurpleBooth's [README வார்ப்புரு](https://gist.github.com/PurpleBooth/109311bb0361f32d87a2) முழுமையான README எழுதுவதற்கு பயன்படுத்தவும்.

நீங்கள் மூல அடைவில் ஒரு README கோப்பை சேர்க்கும்போது, கிட்ஹப் தானாக களஞ்சியத்தின் முகப்பு பக்கத்தில் காண்பிக்கும்.

### உங்கள் பங்களிப்பு வழிமுறைகளை எழுதுதல்

உங்கள் திட்டத்தில் பங்கெடுக்க எப்படி உங்கள் பார்வையாளர்களுக்கு ஒரு CONTRIBUTING கோப்பு சொல்கிறது. உதாரணமாக, நீங்கள் இதில் பின்வரும் தகவல்களைக் கொண்டிருக்கலாம்:

* ஒரு பிழை அறிக்கையை எவ்வாறு பதிவு செய்யலாம் ([சிக்கல் மற்றும் இழு கோரிக்கை வார்ப்புருக்களை](https://github.com/blog/2111-issue-and-pull-request-templates) பயன்படுத்தி முயற்சி செய்யுங்கள்)
* ஒரு புதிய அம்சத்தை எப்படி பரிந்துரைப்பது
* எப்படி உங்கள் சூழலை அமைப்பது மற்றும் சோதனைகள் ஓட்டுவது

தொழில்நுட்ப விவரங்களுடன் கூடுதலாக, பங்களிப்பிற்கான உங்கள் எதிர்பார்ப்புகளை தொடர்புகொள்வதற்கான ஒரு வாய்ப்பாக உள்ளது:

* நீங்கள் தேடும் பங்களிப்பு வகைகள்
* திட்டத்திற்கான உங்கள் செயல் திட்டம் அல்லது பார்வை
* எப்படி பங்களிப்பாளர்கள் உங்களுடன் தொடர்பு கொள்ள வேண்டும் (அல்லது கூடாது)

ஒரு இரக்கம் உள்ள, நட்புரீதியான தொனியைப் பயன்படுத்தி, பங்களிப்பிற்கான குறிப்பிட்ட பரிந்துரைகளை வழங்குதல் (ஆவணங்கள் எழுதுதல் அல்லது வலைத்தளமாக்குதல் போன்றவை) புதுமுகங்கள் வரவேற்பு மற்றும் பங்கேற்க ஆர்வமுடையவையாக இருப்பதால் நீண்ட தூரம் செல்லலாம்.

உதாரணமாக, [ஆக்டிவ் அட்மின்](https://github.com/activeadmin/activeadmin/) [அதன் பங்களிப்பு வழிகாட்டி](https://github.com/activeadmin/activeadmin/blob/master/CONTRIBUTING.md) உடன் தொடங்குகிறது:

> முதலில், ஆக்டிவ் அட்மினுக்கு பங்களிக்க கருதியதற்கு நன்றி. ஆக்டிவ் அட்மின் போன்ற ஒரு பெரிய கருவியை உருவாக்கியது உங்களை போன்ற மக்கள் தான்.

உங்கள் திட்டத்தின் ஆரம்ப கட்டங்களில், உங்கள் CONTRIBUTING கோப்பு எளியதாக இருக்கலாம். பிழைகள் அல்லது கோப்புப் பிரச்சினைகள், மற்றும் எந்த ஒரு தொழில்நுட்ப தேவைகள் (சோதனைகள் போன்றவை) பங்களிப்பைச் செய்வது குறித்து புகாரளிப்பது எப்போது என்பதை நீங்கள் எப்பொழுதும் விளக்க வேண்டும்.

காலப்போக்கில், உங்கள் பங்களிப்புக் கோப்பில் நீங்கள் அடிக்கடி கேட்கப்படும் கேள்விகள் சேர்க்கப்படலாம். இந்த தகவலை எழுதுவது குறைவான மக்கள் உங்களை மீண்டும் அதே கேள்விகளை கேட்க வேண்டும் என்பதாகும்.

உங்கள் பங்களிப்புக் கோப்பை எழுதுவதற்கு அதிக உதவிக்காக, @nayafia இன் [பங்களிப்பு வழிகாட்டி வார்ப்புரு](https://github.com/nayafia/contributing-template/blob/master/CONTRIBUTING-template.md) அல்லது @mozilla's ["எப்படி ஒரு CONTRIBUTING.md உருவாக்கவும்"](Https://mozillascience.github.io/working-open-workshop/contributing/) என பார்க்கவும்.

உங்கள் README லிருந்து உங்கள் பங்களிப்பு கோப்பினை இணைக்க, அதிகமானோர் அதைப் பார்க்கிறார்கள். நீங்கள் ஒரு [பங்களிப்பு கோப்பு உங்கள் திட்டத்தின் களஞ்சியத்தில் வைக்கும்போது](https://help.github.com/articles/setting-guidelines-for-repository-contributors/), உங்கள் பங்களிப்பாளர் ஒரு சிக்கல் உருவாக்கும் போது அல்லது ஒரு மிகுதிக் கோரிக்கையைத் திறக்கும் போது கிட்ஹப் தானாகவே கோப்பில் இணைக்கப்படும்

![பங்களிப்பு நெறிமுறைகள்](/assets/images/starting-a-project/Contributing-guidelines.jpg)

### நடத்தை குறியீடு நிலைநாட்டுதல்

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mlynch?s=180" class="pquote-avatar" alt="avatar">
  ஏதாவது ஒரு விதத்தில் துஷ்பிரயோகம் என்பதை ஒரு பயனராகவோ அல்லது ஒரு பராமளிப்பளாராக ஒரு காரணியாக எப்படி இருக்க வேண்டுமென்பதை விளக்க முயற்சிக்கும்போதோ அல்லது ஒரு பயனராக ... ஒரு எளிய கேள்வியைக் கேட்கும்போதோ நாம் அனைவரும் அனுபவங்கள் சந்தித்திருக்கிறோம். (...) ஒரு நடத்தை நெறிமுறை எளிதில் குறிப்பிடப்பட்ட மற்றும் இணைக்கக்கூடிய ஆவணமாகிறது, இது உங்கள் குழுவானது மிகவும் ஆக்கபூர்வமான சொற்பொழிவுகளை மிகவும் தீவிரமாக எடுத்துக்கொள்வதை காட்டுகிறது.
  <p markdown="1" class="pquote-credit">
— @mlynch, ["திறந்த மூலத்தை ஒரு மகிழ்ச்சியான இடமாக அமைத்தல்"](https://medium.com/ionic-and-the-mobile-web/making-open-source-a-happier-place-3b90d254f5f)
  </p>
</aside>

இறுதியாக, உங்கள் திட்டத்தின் பங்கேற்பாளர்களுக்கு நடத்தைக்கான விதிகளை அமைப்பதற்கு ஒரு நடத்தை நெறிமுறை உதவுகிறது. ஒரு சமூகம் அல்லது நிறுவனத்திற்கான திறந்த மூல திட்டத்தை நீங்கள் தொடங்கினால், இது குறிப்பாக மதிப்புமிக்கது. பராமரிப்பாளராக உங்கள் அழுத்தத்தை குறைக்கும் ஆரோக்கியமான, ஆக்கபூர்வமான சமூக நடத்தைக்கு ஒரு நடத்தை நெறிமுறை உங்களுக்கு உதவுகிறது.

மேலும் தகவலுக்கு, எங்கள் [நடத்தை வழிகாட்டி](../code-of-conduct/).

கூடுதலாக பங்கேற்பாளர்கள் _எப்படி_ நடந்து கொள்ள வேண்டும் என நீங்கள் எதிர்பார்க்கிறீர்கள், ஒரு நெறிமுறை குறியீடு கூட இந்த எதிர்பார்ப்புகளை யாருக்கு எப்போது உபயோகிக்கப்படும், மற்றும் ஒரு மீறல் ஏற்படுமானால் என்ன செய்ய வேண்டும் என்பதை விவரிக்க முனைகிறது.

திறந்த மூல உரிமங்களைப் போலவே, நடத்தை நெறிமுறைகளுக்கான தரநிலைகளும் உள்ளன, எனவே நீங்கள் சொந்தமாக எழுத வேண்டியதில்லை. [பங்களிப்பாளரின் உடன்படிக்கை](https://contributor-covenant.org/) என்பது, [40,000 திறந்த மூல திட்டங்களுக்கு](https://contributor-covenant.org/adopters/) பயன்படுத்துகின்ற ஒரு நெறிமுறை குறியீடாகும், குபெர்னீஸ், ரெயில்ஸ் மற்றும் ஸ்விஃப்ட் உட்பட. நீங்கள் பயன்படுத்தும் உரை எதுவாக இருந்தாலும், தேவையான போது உங்கள் நடத்தை நெறிமுறை செயல்படுத்துவதற்கு நீங்கள் தயாராக இருக்க வேண்டும்.

உரையை நேரடியாக உங்கள் களஞ்சியத்தில் CODE_OF_CONDUCT கோப்பில் ஒட்டுக. உங்கள் திட்டத்தின் கோப்பகத்தில் மூல அடைவில் கோப்பை வைத்திருங்கள், அதை எளிதாக கண்டுபிடிக்கலாம், மேலும் அதை README இலிருந்து இணைக்கவும்.

## உங்கள் திட்டத்திற்கான பெயரிடுதல் மற்றும் முத்திரை பதித்தல்

வணிகச் சின்னம் என்பது ஒரு கவர்ச்சியுள்ள முத்திரை அல்லது திட்டப்பணி பெயரை விட அதிகம். நீங்கள் உங்கள் திட்டத்தைப் பற்றி என்ன பேசுகிறீர்கள், மற்றும் நீங்கள் உங்கள் செய்தியுடன் யாரை சென்றடைகிறீர்கள் என்பது தான்.

### சரியான பெயரைத் தேர்ந்தெடுப்பது

நினைவில் எளிதான ஒரு பெயரைத் தேர்ந்தெடுத்து, திட்டம் என்ன செய்வதென்று சில யோசனைகள் தெரிவியிங்கள். உதாரணத்திற்கு:

* [சென்ட்ரி](https://github.com/getsentry/sentry) தகர்வொலி அறிக்கைக்காக செயலிகளை கண்காணிக்கிறது
* [தின்](https://github.com/macournoyer/thin) ஒரு வேகமான மற்றும் எளிமையான ரூபி வலை சேவையகம்

ஏற்கனவே இருக்கும் திட்டத்தின் மீது நீங்கள் கட்டியெழுப்பினால், முன்னொட்டாக தங்கள் பெயரைப் பயன்படுத்தி உங்கள் திட்டம் என்ன என்பதை தெளிவுபடுத்துவதற்கு உதவலாம் (எடுத்துக்காட்டாக, [node-fetch](https://github.com/bitinn/node-fetch) `window.fetch` ஐ Node.js க்கு கொண்டு வருகிறது).

தெளிவு எல்லாவற்றிற்கும் மேலானது. சிலேடை பேச்சு வேடிக்கையானது, ஆனால் சில நகைச்சுவைகளை நீங்கள் வேறுபட்ட கலாச்சாரங்களுடன் அல்லது வேறுபட்ட அனுபவங்களுடன் மக்களுக்கு மொழிபெயர்க்க முடியாது என்பதை நினைவில் கொள்க. உங்கள் சாத்தியமான சில பயனர்கள் நிறுவன ஊழியர்களாக இருக்கலாம்: வேலையில் உங்கள் திட்டத்தை விளக்க அவர்களுக்கு நீங்கள் சங்கடத்தை உண்டாக்க வேண்டாம்!

### பெயர் முரண்பாடுகளைத் தவிர்த்தல்

[இதே போன்ற பெயரில் திறந்த மூல திட்டங்களுக்கான சரிபார்க்கவும்](http://ivantomic.com/projects/ospnc/), குறிப்பாக நீங்கள் ஒரே மொழியை அல்லது சுற்றுச்சூழலைப் பகிர்ந்து கொள்ளும் பொழுது. பிரபலமான ஒரு திட்டத்தினுடன் உங்கள் பெயர் மேற்பொருந்துதல் இருந்தால், உங்கள் பார்வையாளர்களை குழப்பக்கூடும்.

வலைத்தளம், கீச்சு கைப்பிடி அல்லது உங்கள் திட்டத்தை பிரதிநிதித்துவப்படுத்தும் பிற பண்புகளை நீங்கள் விரும்பினால், நீங்கள் விரும்பும் பெயர்களை பெறலாம் என்பதை உறுதிப்படுத்தவும். நீங்கள் இன்னும் அவற்றை பயன்படுத்த விரும்பவில்லை என்றால் கூட, மன அமைதிக்காக [இப்போது அந்த பெயர்களை வைத்திருக்கவும்](https://instantdomainsearch.com/).

உங்கள் திட்டத்தின் பெயர் எந்த வர்த்தக முத்திரைகளிலும் மீறவில்லை என்பதை உறுதிப்படுத்திக் கொள்ளுங்கள். ஒரு நிறுவனம் பின்னர் உங்கள் திட்டத்தை நீக்குமாறு கேட்கலாம் அல்லது உங்களுக்கு எதிரான சட்ட நடவடிக்கை எடுக்கலாம். அது ஆபத்துக்கு மதிப்பு இல்லை.

வர்த்தக முத்திரை மோதல்களுக்கு [WIPO குளோபல் பிராண்ட் டேட்டாபேஸ்](http://www.wipo.int/branddb/en/) சரிபார்க்கலாம். நீங்கள் ஒரு நிறுவனத்தில் இருந்தால், இதில் உங்கள் [சட்ட குழு உங்களுக்கு உதவும்](../legal/).

இறுதியாக, உங்கள் திட்டத்தின் பெயரை கூகுளில் தேடுங்கள். மக்கள் உங்கள் திட்டத்தை எளிதில் கண்டுபிடிக்க முடியுமா? வேறு எதையாவது நீங்கள் காண விரும்பாதவை தேடல் முடிவுகளில் தோன்றுகிறதா?

### எப்படி எழுதுவது (மற்றும் நிரலாக்குதல்) உங்கள் நிறுவனஅடையாளத்தை பாதிக்கிறது!

உங்கள் திட்டத்தின் வாழ்நாள் முழுவதிலும், நீங்கள் நிறைய எழுதுவீர்கள்: README கள், பயிற்சிகள், சமூகம் ஆவணங்கள், சிக்கல்களுக்கு பதிலளித்தல், சில வேளைகளில் செய்திமடல்கள் மற்றும் அஞ்சல் பட்டியல்கள்.

இது உத்தியோகபூர்வ ஆவணமாக்கல் அல்லது ஒரு தற்காலிக மின்னஞ்சலாக இருந்தாலும், உங்கள் எழுத்து பாணி உங்கள் திட்டத்தின் நிறுவனஅடையாளத்தின் ஒரு பகுதியாகும். உங்கள் பார்வையாளர்களிடம் நீங்கள் எப்படி நடந்துகொள்வீர்கள் என்பதையும், நீங்கள் அறிவிக்க விரும்பும் தொனி அதுதானா என்பதையும் கவனியுங்கள்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  நான் மின்னஞ்சல் பட்டியலிலுள்ள ஒவ்வொரு பிரியிலும் ஈடுபட முயன்றேன், மாதிரியான நடத்தைகளை காட்டுவது, மக்களிடம் பரிவாக இருப்பது, அவர்களின் பிரச்சினைகளை தீவிரமாக எடுத்துக் கொண்டு, ஒட்டுமொத்தமாக உதவ முயற்சித்தேன். சிறிது காலத்திற்கு பிறகு, மக்கள் கேள்விகளை மட்டும் கேட்க மாட்டார்கள், ஆனால் பதிலுடன் உதவி செய்வார்கள், நான் முழுதாக மகிழும் அளவிற்கு, என் பாணியை நையாண்டி செய்வார்கள்.
  <p markdown="1" class="pquote-credit">
— @janl [கவுச்டிபி](https://github.com/apache/couchdb), ["நிலையான திறந்த மூலம்"](https://writing.jan.io/2015/11/20/sustainable-open-source.html) பற்றி
  </p>
</aside>

கனிவான, உள்ளடக்கிய மொழி (ஒற்றை நபரைக் குறிப்பிடும் போதும் "அவர்கள்" போன்றவை) உங்கள் திட்டத்தை புதிய பங்களிப்பாளர்களுக்கு வரவேற்பதாக உணர வைக்கும். எளிமையான மொழியை கடைபிடியுங்கள், உங்கள் வாசகர்களில் பலருக்கு ஆங்கிலம் தாய்மொழியாக இல்லாமலிருக்கலாம்.

நீங்கள் வார்த்தைகளை எப்படி எழுதுகிறீர்களோ அப்படியே, உங்கள் குறியீட்டு பாணி உங்கள் திட்டத்தின் நிலையக அடையாள பகுதியாகவும் மாறும். [Angular](https://github.com/johnpapa/angular-styleguide) மற்றும் [jQuery](https://contribute.jquery.org/style-guide/js/) இரண்டும் கடுமையான குறியீட்டு முறை மற்றும் வழிகாட்டுதல்கள் உள்ள திட்டங்களுக்கான உதாரணங்களாகும்.

நீங்கள் தொடங்கும் பொழுதே, உங்கள் திட்டத்திற்கு ஒரு பாணி வழிகாட்டி எழுத தேவையில்லை, மற்றும் நீங்கள் எப்படியும் உங்கள் திட்டத்தில் வேறு குறியீட்டு பாணியை ஒருங்கிணைத்து அனுபவிக்கலாம். ஆனால் உங்கள் எழுத்து மற்றும் குறியீட்டு நடை எப்படி பல்வேறு வகையான மக்களை கவர்ந்திழுக்க அல்லது ஊக்கப்படுத்தலாம் என்பதை நீங்கள் எதிர்பார்க்க வேண்டும். உங்கள் திட்டத்தின் ஆரம்ப கட்டங்கள் நீங்கள் பார்க்க விரும்பும் முன்னோடிகளை அமைக்கும் வாய்ப்பாக இருக்கும்.

## உங்கள் முன்-வெளியீட்டு பட்டியல்

உங்கள் திட்டத்தைத் திறக்க தயாரா? உதவிக்கு ஒரு பட்டியல் இங்கே. அனைத்து பெட்டிகளையும் சரிபார்க்கவும்? நீங்கள் செல்ல தயாராக உள்ளீர்கள்! ["வெளியிடு" என்பதைக் சொடுக்கவும்](https://help.github.com/articles/making-a-private-repository-public/) பின்பு உங்களை நீங்களே தட்டிக்கொடுத்து கொள்ளவும்.

**ஆவணப்படுத்தல்**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
    திட்டமானது திறந்த மூல உரிமத்துடன் LICENSE கோப்பை கொண்டுள்ளது
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
    திட்டப்பணி அடிப்படை ஆவணங்கள் (README, CONTRIBUTING, CODE_OF_CONDUCT)
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
    நினைவில் வைக்க எளிய பெயர், திட்டம் என்ன செய்கின்றது என சில யோசனைகள் தெரிவிக்கின்றன, ஏற்கனவே இருக்கும் திட்டத்துடன் முரண்படவில்லை அல்லது வர்த்தக முத்திரைகளை மீறவில்லை
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
    தெளிவாக ஒழுங்கமைக்கப்பட்ட மற்றும் பெயரிடப்பட்ட சிக்கல்களால், சிக்கல் வரிசை புதுப்பித்த நிலையில் உள்ளது
  </label>
</div>

**Code**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    திட்டம் நிலையான குறியீடு மரபுகள் மற்றும் தெளிவான செயல்பாடு/முறை/மாறி பெயர்களை பயன்படுத்துகிறது
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    தெளிவான விளக்கக் குறிப்பு கொண்ட குறியீடு, எண்ணங்கள் மற்றும் விளிம்பு வழக்குகளை ஆவணப்படுத்துதல்
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    மீள்பார்வை வரலாறு, சிக்கல்கள் அல்லது இழு கோரிக்கைகளில் நுண்உணர் பொருட்கள் இல்லை (எடுத்துக்காட்டாக, கடவுச்சொற்கள் அல்லது பிற அல்லாத பொது தகவல்கள்)
  </label>
</div>

**மக்கள்**

நீங்கள் ஒரு தனிநபர் என்றால்:

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
  நீங்கள் சட்ட துறையுடன் பேசினீர்கள் மற்றும் / அல்லது உங்கள் நிறுவனத்தின் ஐபி மற்றும் திறந்த மூலக் கொள்கைகள் அறிந்து கொண்டீர்கள் (நீங்கள் எங்காவது ஒரு ஊழியராக இருந்தால்)
  </label>
</div>

நீங்கள் ஒரு நிறுவனம் அல்லது அமைப்பாக இருந்தால்:

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    உங்கள் சட்ட துறையுடன் நீங்கள் பேசினீர்கள்
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    திட்டத்தை அறிவித்து, ஊக்குவிப்பதற்கான சந்தைப்படுத்தலுக்கான திட்டம் உங்களிடம் உள்ளது
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    சமுதாய இடைசெயல்களை நிர்வகிப்பதில் யாரோ கடமைப்பட்டுள்ளனர் (சிக்கல்களுக்கு பதிலளிப்பது, மறுபரிசீலனை செய்தல் மற்றும் இழு கோரிக்கைகள் இணைத்தல்)
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    குறைந்தபட்சம் இரண்டு பேர் இந்த திட்டத்திற்கு நிர்வாக அணுகலைக் கொண்டுள்ளனர்
  </label>
</div>

## நீங்கள் செய்தீர்கள்!

உங்களுடைய முதல் திட்டத்தை திறந்து வைப்பதில் வாழ்த்துக்கள். பலன் எதுவாயினும், பொதுவில் வேலை செய்வது சமுதாயத்திற்கு ஒரு பரிசு. ஒவ்வொரு அணுகலும், கருத்து தெரிவிக்கவும், கோரிக்கை விடுக்கவும், நீங்களாகவும், மற்றவர்களுக்காகவும் கற்றுக்கொள்ளவும் வளரவும் வாய்ப்புகளை உருவாக்குகிறீர்கள்.
