---
lang: ta
title: திறந்த மூல வேலைக்கு பணம் பெறுதல்
description: உங்கள் நேரத்தை அல்லது உங்கள் திட்டத்திற்கான நிதி ஆதாரத்தை பெறுவதன் மூலம் திறந்த மூலத்தில் உங்கள் பணியைத் தொடரவும்.
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## ஏன் சிலர் நிதி ஆதரவை நாடுகின்றனர்

பெரும்பான்மையான திறந்த மூல வேலை தன்னார்வலர்களால் செய்யப்படுகிறது. உதாரணமாக, யாரோ ஒருவர் அவர்கள் ஒரு திட்டத்தில் ஒரு பிழையைச் சந்திக்க நேரிடலாம் அல்லது ஒரு விரைவான பிழைத்திருத்தத்தை சமர்ப்பிக்கலாம், அல்லது திறந்த மூல திட்டத்திற்கு தங்களது ஓய்வு நேரத்திலே பழுது நீக்கல் செய்யலாம்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
நான் கிறிஸ்துமஸ் முழுவதும் வாரம் முழுவதும் ஆக்கிரமிக்க ஒரு "பொழுதுபோக்கு" நிரலாக்க திட்டம் தேடினேன். (...) என் வீட்டில் ஒரு கணினி இருந்தது, என் கைகளில் அதிகமாக இல்லை. நான் சமீபத்தில் நினைத்துக்கொண்டிருந்த புதிய ஸ்கிரிப்டிங் மொழிக்கான மொழிபெயர்ப்பாளரை எழுத முடிவு செய்தேன். (...) நான் பைத்தானை ஒரு வேலை தலைப்பாக தேர்ந்தெடுத்தேன்.
  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["பைதான் நிரலாக்குதல்"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

ஒரு திறந்த மூல வேலைக்காக ஒரு நபர் பணம் பெற விரும்பவில்லை என்பதற்கு பல காரணங்கள் உள்ளன.

* **அவர்கள் ஏற்கனவே விரும்பும் ஒரு முழுநேர வேலையை கொண்டுள்ளார்கள்**, அதனால் அவர்களது ஓய்வு நேரத்தில் திறந்த மூலத்திற்கு பங்களிக்க உதவுகிறது.
* **அவர்கள் பொழுதுபோக்கு அல்லது ஆக்கப்பூர்வமான விலகலுக்காக திறந்த மூலத்தைப்** பற்றி நினைத்து மகிழ்கிறார்கள், தங்கள் திட்டங்களில் பணியாற்றுவதற்காக நிதி ரீதியாக கடமைப்பட்டிருக்க விரும்பவில்லை.
* தங்கள் நற்பெயரை அல்லது இலாக்காகளை உருவாக்கி, ஒரு புதிய திறமையைக் கற்றுக்கொள்வது அல்லது ஒரு சமூகத்திற்கு நெருக்கமாக உணருதல் போன்ற பிற திறன்களை **திறந்த மூலத்திற்கு பங்களிக்கப்பதன் மூலம் ஆதாயங்களாக அவர்கள் பெறுகிறார்கள்**.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  நிதி நன்கொடைகள் சிலவற்றிற்கு பொறுப்பைக் காட்டுகின்றன. (...) உலகெங்கிலும் இணைக்கப்பட்ட, வேகமான உலகில் நாம் வாழ்கிறோம், "இப்பொழுது இல்லை, முற்றிலும் மாறுபட்ட ஒன்றைச் செய்வது போல் உணர்கிறேன்" என்று நமக்குத் தெரியும்.
  <p markdown="1" class="pquote-credit">
— @alloy, ["ஏன் நாம் நன்கொடைகளை ஏற்றுக்கொள்ளக்கூடாது"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

மற்றவர்களுக்கு, குறிப்பாக நன்கொடைகள் தொடர்ககின்ற றல்லது குறிப்பிடத்தக்க நேரத்திற்கு தேவைப்படும் போது, திறந்த மூலத்திற்கு பங்களிக்க பணம் செலுத்துவது மட்டுமே அவர்கள் பங்கேற்கக்கூடிய ஒரே வழி, திட்டத்திற்கு தேவை, அல்லது தனிப்பட்ட காரணங்களுக்காக அல்ல.

பிரபலமான திட்டங்களை பராமரிப்பது குறிப்பிடத்தக்க பொறுப்பாகும், மாதத்திற்கு சில மணிநேரத்திற்கு பதிலாக வாரத்திற்கு 10 அல்லது 20 மணி நேரம் எடுத்துக்கொள்ளலாம்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  எந்த திறந்த மூல திட்ட பராமரிப்பாளரையும் கேளுங்கள், ஒரு திட்டத்தை நிர்வகிக்கும் பணியின் அளவைப் பற்றி அவர்கள் உங்களுக்கு கூறுவார்கள். உங்களுக்கு வாடிக்கையாளர்கள் உள்ளனர். நீங்கள் அவர்களுக்காக பிரச்சினைகளை சரிசெய்கிறீர்கள். புதிய அம்சங்களை உருவாக்குகிறீர்கள். இது உங்கள் நேரத்திற்கு ஒரு உண்மையான கோரிக்கையாகும்.
  <p markdown="1" class="pquote-credit">
— @ashedryden, ["செலுத்தப்படாத தொழிலாளர் மற்றும் திறந்த மூல சமூகத்தின் நெறிமுறைகள்"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

பணம் செலுத்தும் வேலை, வாழ்க்கையின் பல்வேறு துறைகளிலிருந்தும் அர்த்தமுள்ள பங்களிப்புகளை செய்ய உதவுகிறது. சிலர் திறந்த மூல திட்டங்களில் தங்கள் தற்போதைய நிதி நிலை, கடன், அல்லது குடும்பம் அல்லது பிற கவனிப்பு கடமைகளின் அடிப்படையில் பணம் செலுத்தப்படாத நேரத்தை செலவிட முடியாது. அதாவது, தங்கள் நேரத்தை தன்னார்வத் தொகையை வழங்க முடியாத திறமையான மக்களிடமிருந்து பங்களிப்பை உலகம் காணாது. இதில் நீதிநெறிக்குரிய உட்குறிப்பீடுகள் உள்ளதால், @ashedryden[விவரித்ததுப்போல்](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community), வாழ்க்கையில் நன்மைகளை அனுபவிப்பவர்களுக்கே ஆதரவளித்து பணி செய்யப்படுவதால், தன்னார்வ பங்களிப்புகளை அடிப்படையாகக் கொண்டு கூடுதல் நன்மைகள் கிடைக்கும், பின்னர் தன்னார்வத் தொண்டு செய்யாத மற்றவர்கள் பின்னர் வாய்ப்புகளை பெறவில்லை, இது திறந்த மூலத்தின் சமூகத்தின் தற்போதைய பல்வகைமையை வலுப்படுத்தும்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
  OSS ஆனது தொழில்நுட்ப தொழிற்துறைக்கு பாரிய நன்மைகளை அளிக்கிறது, இது அனைத்து தொழிற்துறைகளுக்கும் பயன் தருகிறது. (...) எனினும், அதை கவனம் செலுத்த மட்டுமே மக்கள் அதிர்ஷ்டம் மற்றும் அன்போடு இருந்தால், பின்னர் ஒரு பெரிய பயன்படுத்தப்பெறாத ஆற்றல் வளம் உள்ளது.
  <p markdown="1" class="pquote-credit">
— @isaacs, ["பணம் மற்றும் திறந்த மூலம்"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

நீங்கள் நிதி ஆதரவு தேடுகிறீர்களானால், இரண்டு பாதைகள் பரிசீலிக்கப்படுகின்றன. உங்கள் சொந்த நேரத்தை ஒரு பங்களிப்பாளராக நீங்கள் ஆதரிக்கலாம் அல்லது திட்டத்திற்கான நிறுவன நிதியுதவியைக் காணலாம்.

## உங்கள் நேரத்திற்கான நிதிநல்கல்

இன்று, பலர் திறந்த மூலத்தில் பகுதி அல்லது முழுநேர வேலைக்கு பணம் சம்பாதிக்கின்றனர். உங்கள் நேரத்திற்கு பணம் சம்பாதிக்க மிகவும் பொதுவான வழி உங்களை பணி அமர்த்துவரிடம் பேசுவதாகும்.

உங்கள் முதலாளி உண்மையிலேயே திட்டத்தை பயன்படுத்துகிறார்களானால், திறந்த மூல வேலைக்கு ஒரு விஷயத்தை எளிதாக்கலாம், ஆனால் உங்கள் சுருதிடன் ஆக்கப்பூர்வமாகப் பெறலாம். ஒருவேளை உங்கள் முதலாளி இந்த திட்டத்தை பயன்படுத்தவில்லை, ஆனால் பைதான் பயன்படுத்தப்படுகிறது, மேலும் பிரபலமான பைத்தான் திட்டத்தை பராமரிக்க புதிய பைத்தான் நிரல் உருவாக்குபவர்களை ஈர்க்கிறது. ஒருவேளை அது உங்கள் முதலாளி பொதுவாக நிரலர் நட்புக்கு மிகவும் பொருத்தமானதாக இருக்கும்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/hzoo?s=180" class="pquote-avatar" alt="avatar">
  திறந்த மூலத்தில் பலரைப் போலவே, ஒரு திட்டத்தை பராமரிப்பதற்கான சுமையோடு நான் போராடினேன். நான் முதலில் திறந்த மூலத்தை ஆரம்பித்தபோது, நான் வேலைக்குச் செல்வதில் தாமதம் அல்லது நான் வீட்டிற்கு வந்தவுடன் வேலை செய்வதாயிருந்தது. (...) என் முதலாளியுடன் நான் எதிர்கொள்ளும் பிரச்சினைகள் பற்றி விவாதிக்க முடிந்தது மற்றும் நாம் பாபேலில் சொந்த பயன்பாடு கொடுக்கப்பட்ட திறந்த மூல பணிகளை எப்படி இணைத்துக்கொள்ள முடியும் என்ற கருத்துக்கள் வந்தது.
  <p markdown="1" class="pquote-credit">
— @hzoo, ["பராமரிப்பாளர் கதைகள்"](https://github.com/open-source/stories/hzoo)
  </p>
</aside>

நீங்கள் வேலை செய்ய உங்களிடம் திறந்த மூல திட்டப்பணி இல்லை என்றால், தற்போதைய பணி வெளியீடு திறந்த மூலமாக்க, உங்கள் சொந்த மென்பொருளில் சிலவற்றை திறக்க உங்கள் முதலாளிக்கு ஒரு வழக்கு உருவாக்கவும்.

பல நிறுவனங்கள் திறந்த மூல திட்டங்களை தங்கள் வியாபாரக் குறி உருவாக்க மற்றும் செயல் திறனை மிக்கவர்களை பணியமர்த்துவதற்கு உருவாக்குகின்றன.

@hueniverse, உதாரணமாக, [வால்மார்ட்டின் திறந்த மூலதன முதலீட்டை](https://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html) நியாயப்படுத்த நிதி காரணங்களைக் கண்டறிந்துள்ளனர். மற்றும் ஃபேஸ்புக்கின் திறந்த மூல நிரல் ஆட்சேர்ப்பில் [வேறுபாட்டை உருவாக்கியதை](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon) @jamesgpearce கண்டறிந்தார்:

> இது எங்கள் கொந்தர் கலாச்சாரத்துடன் நெருக்கமாக உள்ளது, எங்கள் அமைப்பு எவ்வாறு உணரப்பட்டது. நாங்கள் எங்கள் ஊழியர்களிடம் கேட்டோம், "முகநூலில் திறந்த மூல மென்பொருள் திட்டம் பற்றி நீங்கள் அறிந்திருக்கிறீர்களா?". மூன்றில் இரண்டு பங்கு "ஆம்" என்றார். ஒரு பாதிபேர் அந்த செயல்முறைத் திட்டம் எங்களுக்கு வேலை செய்யத் தீர்மானித்தது. இவை குறுகலான எண்களாக இல்லை, மேலும் தொடர்கின்ற ஒரு போக்கு.

உங்கள் நிறுவனம் இந்த வழியில் செல்லும்பொழுது, சமூகம் மற்றும் பெருநிறுவன செயல்பாடுகளுக்கு இடையில் எல்லைகளை வைத்திருக்க வேண்டியது அவசியம்.இறுதியாக, திறந்த மூலமானது உலகெங்கிலும் உள்ள மக்களிடமிருந்து நன்கொடைகள் மூலம் தன்னைத் தக்கவைத்துக்கொள்வதோடு, எந்த ஒரு நிறுவனத்தையும் அல்லது இடத்தையும் விட இது பெரியதாகும்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  திறந்த மூலத்தில் பணியாற்றுவதற்கு பணம் சம்பாதிப்பது ஒரு அபூர்வமான மற்றும் அற்புதமான வாய்ப்பாகும், ஆனால் நீங்கள் செயல்பாட்டில் உங்கள் ஆர்வத்தை கைவிட்டுவிடக் கூடாது. நிறுவனங்கள் உங்களுக்கு ஏன் பணம் கொடுக்க வேண்டும் என்பதே உங்கள் உணர்வுக்காக.
  <p markdown="1" class="pquote-credit">
— @jessfraz, ["மங்கலான கோடுகள்"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

திறந்த மூல வேலைக்கு முன்னுரிமை கொடுக்க உங்கள் தற்போதைய பணியாளரை நீங்கள் சமாதானப்படுத்த முடியாவிட்டால், ஒரு புதிய முதலாளி கண்டுபிடிப்பதை கருத்தில் கொள்க. திறந்த மூல வேலை வெளிப்படையான அர்ப்பணிப்பு செய்யும் நிறுவனங்களைக் கவனியுங்கள். உதாரணத்திற்கு:

* சில நிறுவனங்கள், [நெட்ஃபிக்ஸ்](https://netflix.github.io/) or [பேபால்](https://paypal.github.io/), திறந்த மூலத்தில் தங்கள் ஈடுபாட்டை வலைத்தளங்கள்ல் உயர்த்தி உரைக்கின்றன
* [ரேக்ஸ்பேஸ்](https://www.rackspace.com/en-us)  ஊழியர்களுக்கான [திறந்த மூல பங்களிப்பு கொள்கையை](https://blog.rackspace.com/rackspaces-policy-on-contributing-to-open-source/) வெளியிட்டது

[Go](https://github.com/golang) அல்லது [React](https://github.com/facebook/react) போன்ற ஒரு பெரிய நிறுவனத்தில் தோன்றிய திட்டங்கள், திறந்த மூலத்தில் மேலும் வேலை செய்ய மக்களைப் பயன்படுத்தக்கூடும்.

இறுதியாக, உங்களுடைய தனிப்பட்ட சூழ்நிலைகளை பொறுத்து, நீங்கள் உங்கள் திறந்த மூல வேலைக்கு நிதி திரட்ட முயற்சி செய்யலாம். உதாரணத்திற்கு:

* @gaearon  தனது [Redux](https://github.com/reactjs/redux) திட்டத்திற்கான நிதியை [பேட்ரியன் கூட்டல் நிதி பிரச்சாரத்தின்](https://redux.js.org/) மூலம் திரட்டினார்.
* @andrewgodwin  டிஜாங்க் திட்ட அமைப்புமுறைகளை [kickstarter பிரச்சாரத்தின்](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django) மூலம் திரட்டினார்.

## உங்கள் திட்டத்திற்கான நிதிகளைக் கண்டறிதல்

தனிப்பட்ட பங்களிப்பாளர்களுக்கான ஏற்பாடுகளுக்கு அப்பால், சில நேரங்களில் திட்டங்கள் நிறுவனங்கள், தனிநபர்கள் அல்லது மற்றவர்களிடம் இருந்து பணத்தை திரட்டுகின்றன.

நிறுவன நிதியளிப்பு நடப்பு பங்களிப்பாளர்களுக்கு செலுத்துவதை நோக்கி செல்லலாம், திட்டத்தை இயங்கும் செலவுகள் (ஹோஸ்டிங் கட்டணங்கள் போன்றவை) அல்லது புதிய அம்சங்கள் அல்லது யோசனைகளை முதலீடு செய்தல் ஆகியவற்றை உள்ளடக்கும்.

திறந்த மூலத்தின் புகழ் அதிகரிக்கும்போது, திட்டங்களுக்கான நிதிகளைக் கண்டறிவது இன்னும் பரிசோதனையாகும், ஆனால் சில பொதுவான விருப்பத்தெரிவுகள் உள்ளன.

### பிரச்சாரங்களை அல்லது விளம்பரதாரர்கள் மூலம் உங்கள் பணிக்கான பணம் திரட்டவும்

உங்களிடம் வலுவான பார்வையாளர்களோ அல்லது நற்பெயரைப் பெற்றிருந்தால், உங்கள் திட்டம் மிகவும் பிரபலமாக இருந்தால், நிதியுதவிகளை கண்டறிவது நல்லது.
நிதியளிக்கும் திட்டங்களின் சில உதாரணங்கள் பின்வருமாறு:

* **[வெப்பேக்](https://github.com/webpack)** நிறுவனங்கள் மற்றும் தனிநபர்களிடமிருந்து [OpenCollective மூலம்](https://opencollective.com/webpack) நிதி திரட்டுகிறது
* **[Vue](https://github.com/vuejs/vue)**  [பேட்ரன் மூலம் நிதியளிக்கப்பட்டது](https://github.com/open-source/stories/yyx990803)
* **[ரூபி டுகேதர்](https://rubytogether.org/),**  [பண்ட்லர்](https://github.com/bundler/bundler), [ரூபிஜெம்ஸ்](https://github.com/rubygems/rubygems), மற்றும் பிற ரூபி உள்கட்டமைப்பு திட்டங்களுக்கு பணிக்கு பணம் செலுத்துகின்ற ஒரு இலாப நோக்கமற்ற அமைப்பு

### வருவாய் நீரோடை உருவாக்கவும்

உங்கள் திட்டத்தை பொறுத்து, நீங்கள் வணிக ஆதரவு, ஹோஸ்ட் செய்யப்பட்ட விருப்பங்கள், அல்லது கூடுதல் அம்சங்களுக்கு கட்டணம் வசூலிக்கலாம். ஒரு சில உதாரணங்கள் பின்வருமாறு:

* **[சைட்கிக்](https://github.com/mperham/sidekiq)** கூடுதல் ஆதரவுக்கான கட்டண பதிப்புகள் வழங்குகிறது
* **[டிராவிஸ் சிஐ](https://github.com/travis-ci)** அதன் தயாரிப்பின் கட்டண பதிப்புகள் வழங்குகிறது
* **[கோஸ்ட்](https://github.com/TryGhost/Ghost)** ஒரு இலாப நோக்கமற்றத பணம் செலுத்திய நிர்வகிக்கப்பட்ட சேவை

[என்பிஎம்](https://github.com/npm/npm) and [டாக்கர்](https://github.com/docker/docker), போன்ற சில பிரபலமான திட்டங்கள், தங்கள் வணிக வளர்ச்சியை ஆதரிப்பதற்காக துணிகர மூலதனத்தை அதிகரிக்கின்றன.

### மானிய நிதிக்கு விண்ணப்பிக்கவும்

சில மென்பொருள் அடித்தளங்கள் மற்றும் நிறுவனங்கள் திறந்த மூல வேலைகளுக்கு மானியங்களை வழங்குகின்றன. சில நேரங்களில், திட்டத்திற்கான ஒரு சட்ட நிறுவனம் ஒன்றை அமைக்காமல் தனிநபர்களுக்கு மானியங்கள் வழங்கப்படலாம்.

* **[ரீட் த டாக்ஸ்](https://github.com/rtfd/readthedocs.org)** [மோசில்லா திறந்த மூல ஆதரவு](https://www.mozilla.org/en-US/grants/) மூலம் கொடை பெற்றது
* **[ஓபன்எம்ஆர்எஸ்](https://github.com/openmrs)** பணி [Stripe's திறந்த மூல ரிட்ரேட்](https://stripe.com/blog/open-source-retreat-2016-grantees) மூலம் நிதி பெற்றது
* **[லைப்பிரரி.ஐஓ](https://github.com/librariesio)** [ஸ்லோன் அறக்கட்டளை](https://sloan.org/programs/digital-technology) மூலம் கொடை பெற்றது
* **[பைத்தான் மென்பொருள் அறக்கட்டளை](https://www.python.org/psf/grants/)** பைத்தான் தொடர்பான பணிக்கு மானியங்களை வழங்குகிறது

மேலும் விரிவான விருப்ப தெரிவுகள் மற்றும் வழக்கு ஆய்வுகளுக்கு, திறந்த மூல வேலைக்கு பணம் சம்பாதிக்க @nayafia [ஒரு வழிகாட்டி எழுதினார்](https://github.com/nayafia/lemonade-stand). வெவ்வேறு விதமான நிதியுதவி பல்வேறு திறமைகளுக்குத் தேவைப்படுகிறது, எனவே உங்கள் விருப்பங்களை நீங்கள் சிறப்பாகச் செயல்படுத்துவதை கண்டுபிடிக்க உங்கள் பலத்தை கருத்தில் கொள்ளுங்கள்.

## நிதியுதவிக்கு ஒரு வகை செய்தல்

உங்கள் திட்டம் ஒரு புதிய யோசனையாக இருந்தாலும் அல்லது பல ஆண்டுகளாக இருந்தாலும் சரி, உங்கள் இலக்கு அனுபவத்தை அடையாளம் காண்பதில் குறிப்பிடத்தக்க சிந்தனை வைக்க வேண்டும் மற்றும் ஒரு கட்டாய வழக்கு ஒன்றை உருவாக்கும்.

நீங்கள் உங்கள் சொந்த நேரத்திற்காக அல்லது ஒரு திட்டத்திற்கான நிதி திரட்ட, நீங்கள் பின்வரும் கேள்விகளுக்கு பதிலளிக்க வேண்டும்.

### தாக்கம்

ஏன் இந்த திட்டம் பயனுள்ளதாக இருக்கும்? ஏன் உங்கள் பயனர்கள், அல்லது சாத்தியமான பயனர்கள் அதை விரும்புகிறார்கள்? இது ஐந்து ஆண்டுகளில் எங்கு இருக்கும்?

### இழுவை

உங்கள் திட்டம் முக்கியம் என்பதற்கான அளவீடுகள், நிகழ்வுகள், அல்லது சான்றுகள் ஆதாரங்களாக சேகரிக்க முயற்சிக்கவும். இப்போது உங்கள் திட்டத்தை பயன்படுத்தி வரும் நிறுவனங்கள் அல்லது குறிப்பிடத்தக்க மக்கள் இருக்கிறீர்களா? இல்லையென்றால், ஒரு முக்கிய நபர் அதை ஆதரித்தாரா?

### முதலீட்டாளர்களுக்கு மதிப்பு

முதலீட்டாளர்கள், உங்களுடைய முதலாளிகளோ அல்லது மானிய நிதியளிப்பு நிறுவனமோ அடிக்கடி வாய்ப்புகளை சந்திக்கிறார்கள். வேறு எந்த சந்தர்ப்பத்திலும் உங்கள் திட்டத்தை ஏன் அவர்கள் ஆதரிக்க வேண்டும்? அவர்கள் எப்படி தனிப்பட்ட முறையில் பயனடைகிறார்கள்?

### நிதிகளைப் பயன்படுத்துதல்

முன்மொழியப்பட்ட நிதிக்கு என்ன, சரியாக, நீங்கள் சாதிக்க வேண்டும்? ஊதியத்தை செலுத்துவதற்கு பதிலாக திட்ட மைல்கற்கள் அல்லது விளைவுகளை கவனம் செலுத்துங்கள்.

### எவ்வாறு நீங்கள் நிதிகளைப் பெறுவீர்கள்

முதலீட்டாளர்களுக்கு பிரித்துவழங்குதல் குறித்து ஏதேனும் தேவைகள் உள்ளனவா? எடுத்துக்காட்டாக, நீங்கள் ஒரு இலாப நோக்கமற்றவராக அல்லது லாபமற்ற நிதிய நிதியளிப்பாளராக இருக்க வேண்டும். Oஅல்லது ஒருவேளை நிதி ஒரு நிறுவனத்திற்கு பதிலாக தனிப்பட்ட ஒப்பந்தக்காரருக்கு கொடுக்கப்பட வேண்டும். இந்த தேவைகள் நிதிதாரர்களிடையே வேறுபடுகின்றன, எனவே உங்கள் ஆராய்ச்சி முன்னதாகவே செய்ய வேண்டும்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
  பல ஆண்டுகளாக, வலைத்தள நட்பு சின்னங்களின் முன்னணி ஆதாரமாக நாங்கள் இருக்கிறோம், 20 மில்லியன் மக்களுக்கு மேலான ஒரு சமூகம், மேலும் Whitehouse.gov உள்ளிட்ட 70 மில்லியன் வலைத்தளங்களில் இடம்பெற்றது. (...) பதிப்பு 4 மூன்று ஆண்டுகளுக்கு முன்பு இருந்தது. வலை தொழில்நுட்பம் பின்னர் நிறைய மாறிவிட்டது, மற்றும் வெளிப்படையாக, எழுத்துரு அற்புதம் ஒரு சிறிது பழையதாகி விட்டது. (...) அதனால் தான் நாங்கள் எழுத்துரு வியப்பா 5 அறிமுகப்படுத்துகிறோம். நாங்கள் CSS ஐ நவீனமயமாக்குவதன் மற்றும் மறுபிரதி எடுக்கின்றோம் மற்றும் மேலிருந்து கீழும் ஒவ்வொரு ஐகானை மறுவடிவமைக்கிறோம். நாங்கள் சிறந்த வடிவமைப்பு, சிறந்த நிலைத்தன்மை மற்றும் சிறந்த வாசிப்பு ஆகியவற்றைப் பற்றி பேசுகிறோம்.
  <p markdown="1" class="pquote-credit">
— @davegandy, [எழுத்துரு வியப்பா கிக் ஸ்டாடர் வீடியோ](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## பரிசோதனை செய்யுங்கள் மற்றும் தளர்ந்துவிடாதீர்கள்

பணத்தை உயர்த்துவது எளிதானது அல்ல, நீங்கள் ஒரு திறந்த மூல திட்டம், ஒரு இலாப நோக்கமற்ற அல்லது ஒரு மென்பொருள் துளிர் நிறுவனம், மற்றும் பெரும்பாலான சந்தர்ப்பங்களில் நீங்கள் படைப்பாற்றல் பெற்றிருக்க வேண்டும். நீங்கள் எப்படி பணம் சம்பாதிக்க வேண்டும், ஆராய்ச்சி செய்து, உங்கள் முதலீட்டாளர்களுடைய காலணிகளில் உங்களை வைத்துக் கொள்ளுதல், நிதிக்கு உறுதியான ஒரு சூழ்நிலையை உருவாக்கும்.

>
