---
lang: ta
title: பராமரிப்பாளர்களுக்கான சிறந்த நடைமுறைகள்
description: திறந்த மூல பராமரிப்பாளராக உங்கள் வாழ்க்கையை எளிதாக்குவது, உங்கள் சமூகத்தை செயல்படுத்துவதற்கான செயல்முறைகளை ஆவணப்படுத்துதல்.
class: best-practices
order: 5
image: /assets/images/cards/best-practices.png
related:
  - metrics
  - leadership
---

## ஒரு பராமரிப்பாளராக இருப்பது எதை அர்த்தப்படுத்துகிறது?

நிறைய மக்கள் பயன்படுத்தும் திறந்த மூல திட்டத்தை நீங்கள் பராமரித்தால், நீங்கள் குறைவாக குறியிடுவதையும் சிக்கல்களுக்கு அதிகமாக பதிலளிப்பதையும் கவனித்திருக்கலாம்.

ஒரு திட்டத்தின் ஆரம்ப கட்டங்களில், நீங்கள் புதிய கருத்துக்களை பரிசோதித்து, நீங்கள் விரும்பியவற்றை அடிப்படையாக கொண்ட முடிவுகளை எடுப்பீர்கள். உங்கள் திட்டம் பிரபலமடையும்போது, உங்கள் பயனர் மற்றும் பங்களிப்பாளர்களுடன் மேலும் நீங்கள் வேலை செய்வீர்கள்.

ஒரு திட்டத்தை பராமரிக்க, நிரலாக்கத்தை விட அதிக ஈடுபாடு வேண்டும். இந்த பணிகள் பெரும்பாலும் எதிர்பாராதவை, ஆனால் அவை வளரும் திட்டத்திற்கு முக்கியம். செயல்முறைகளை ஆவணப்படுத்துவதிலிருந்து சமூகத்தை மேம்படுத்துவதுவரை, சில எளிய வழிமுறைகளை நாங்கள் சேகரித்துள்ளோம்.

## உங்கள் செயல்முறைகளை ஆவணப்படுத்துதல்

ஆவணப்படுத்துதல், ஒரு பராமரிப்பாளராக நீங்கள் செய்ய வேண்டிய முக்கிய கடமையாகும்.

ஆவணம் உங்கள் சொந்த சிந்தனையை தெளிவுபடுத்துவதோடு மட்டுமல்லாமல், உங்களுடைய தேவை அல்லது எதிர்பார்ப்பை அடுத்தவர்கள் கேட்கும்முன் சொல்ல உதவுகிறது.

உங்கள் நோக்குடன் ஏதாவது பொருந்தாதபோது, இல்லை என்று சொல்வதை ஆவணப்படுத்துதல் எளிதாகிறது. அது மட்டுமல்லாமல் மற்றவர்கள் உதவி செய்ய முன்வரும்போது, இது அவர்களின் பணியை எளிமையாக்குகிறது. யார் உங்கள் திட்டத்தை வாசிப்பார்கள் அல்லது பயன்படுத்துகிறார்களோ என்பது உங்களுக்குத் தெரியாது.

நீங்கள் முழு பத்திகளாக எழுதாவிட்டாலும், புல்லட் புள்ளிகளைக் கொண்டு எழுதுவது, எழுதாமல் இருப்பதைவிட மேலாகும்.

உங்கள் ஆவணங்களை புதுப்பித்த நிலையில் வைக்க நினைவில் கொள்ளுங்கள். நீங்கள் இதை எப்போதும் செய்ய இயலாவிட்டால், உங்கள் காலாவதியான ஆவணங்களை நீக்குங்கள் அல்லது காலாவதியானது என்பதைக் குறிப்பிடுக. அதனால் பங்களிப்பாளர்கள் புதுப்பிப்புகளுக்கு வரவேற்பு உள்ளதாக அறிவார்கள்.

### உங்கள் திட்டத்தின் பார்வையை எழுதுங்கள்

உங்கள் திட்டத்தின் இலக்குகளை எழுதுவதன் மூலம் தொடங்கவும். அவற்றை உங்கள் README இல் சேர்க்கவும், அல்லது VISION எனப்படும் ஒரு தனி கோப்பை உருவாக்கவும். ஒரு செயல்திட்டத் திட்டத்தின் வழியே உதவக்கூடிய பிற கைவினைப்பொருட்கள் இருந்தால், அதை பொதுவெளியில் வைக்கவும்.

தெளிவான, ஆவணப்படுத்தப்பட்ட பார்வை உங்களின் கவனத்தை ஒருமுகபடுத்துவதோடு  மற்றவர்களின் பங்களிப்புகளில் இருந்து "வரையெல்லை தொய்வை" தவிர்க்க உதவுகிறது.

எடுத்துக்காட்டாக, @lord ஒரு திட்டத்தின் பார்வை கொண்டிருப்பதால், நேரம் செலவிட வேண்டிய கோரிக்கைகளை அவர் கண்டுபிடித்தார். ஒரு புதிய பராமரிப்பாளராக, [Slate](https://github.com/lord/slate) க்கு தனது முதல் அம்ச கோரிக்கை கிடைத்தபோது, அவர் தனது திட்டத்தின் நோக்குடன் ஒட்டவில்லை என்று வருத்தப்பட்டார்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lord?s=180" class="pquote-avatar" alt="avatar">
  நான் அதைத் எடுத்தேன். நான் ஒரு முழுமையான தீர்வை கொண்டு வர முயற்சிக்கவில்லை. ஒரு அரை ஆணை தீர்வுக்கு பதிலாக, "நான் இப்போது இதற்கு நேரம் இல்லை, ஆனால் நான் நீண்ட கால இருந்தால்-நன்று பட்டியலில் அதை சேர்க்க வேண்டும்" என்று நான் கூறினேன்.
  <p markdown="1" class="pquote-credit">
— @lord, ["Tips for new open source maintainers"](https://lord.io/blog/2014/oss-tips/)
  </p>
</aside>

### உங்கள் எதிர்பார்ப்புகளை தெரிவிக்கவும்

விதிகள் எழுதுவதற்கு கடினமாக இருக்கலாம். மற்றவர்களின் நடத்தைகளை நீங்கள் கண்காணிப்பதைப்போல சில நேரங்களில் நீங்கள் நினைக்கலாம்.

நன்கு எழுதப்பட்டு, செயல்படுத்தப்படும் விதிகள், பராமரிப்பவர்களுக்கு அதிகாரம் அளிக்கிறது. நீங்கள் செய்ய விரும்பாத விஷயங்களைச் செய்வதில் இழுக்கப்படுவதை அவர்கள் தடுக்கிறார்கள்.

உங்கள் திட்டத்தைச் சந்திக்கும் பெரும்பான்மையானவர்கள் உங்களுக்கு அல்லது உங்களுடைய சூழ்நிலைகளை பற்றி எதுவும் தெரியாது. அவர்கள் வழக்கமாக பயன்படுத்துவதாலும், சார்ந்துஇருப்பதாலும், திட்டப்பணியில் நீங்கள் செய்யும் வேலைக்கு பணம் பெறுகிறீர்கள் என அவர்கள் எண்ணலாம். ஒருவேளை ஒரு கட்டத்தில் உங்கள் திட்டத்தில் நிறைய நேரம் போடலாம், ஆனால் இப்போது நீங்கள் ஒரு புதிய வேலை அல்லது குடும்ப அங்கத்தினருடன் ஓய்வில்லாமல் இருக்கலாம்.

இந்த அனைத்து நன்றாக இருக்கிறது! மற்றவர்கள் அதைப் பற்றி அறிந்திருப்பதை உறுதிப்படுத்தவும்.

உங்கள் திட்டத்தை பராமரிப்பது பகுதியாக அல்லது முற்றிலும் தன்னார்வமாக இருந்தால், நீங்கள் எவ்வளவு நேரம் செலவு செய்வீர்கள் என்பது பற்றி நேர்மையாக இருக்க வேண்டும். இந்த நேரமென்பது திட்டப்பணிக்கு தேவையான நேரமோ அல்லது நீங்கள் திட்டப்பணிக்காக எவ்வளவு நேரம் செலவிட வேண்டும் என்று மற்றவர்கள் விரும்பும் அளவிற்கு இணையாக இருக்கவேண்டுமென்பதில்லை.

ஆவணப்படுத்த வேண்டிய முக்கிய விதிமுறைகளில் சில:

* ஒரு பங்களிப்பு எவ்வாறு மதிப்பாய்வு செய்யப்படுகிறது மற்றும் ஏற்றுக்கொள்ளப்படுகிறது (_அவைகளுக்கு சோதனைகள் தேவையா? இடுவு வார்ப்புரு?_)
* நீங்கள் ஏற்கும் பங்களிப்பு வகைகள் (_உங்கள் குறியீட்டின் ஒரு பகுதியுடன் மட்டுமே உதவி வேண்டுமா?_)
* எப்பொழுது பின்தொடர்வது பொருத்தமாக இருக்கும் (_உதாரணமாக, "7 நாட்களுக்குள் ஒரு பராமரிப்பாளரின் பதிலை எதிர்பார்க்கலாம். அதற்குமேலும் எந்த பதிலும் இல்லாமலிருந்தால், பிரியில் எனக்கு செய்தி அனுப்பவும்."_)
* நீங்கள் திட்டத்தில் எவ்வளவு நேரம் செலவு செய்கிறீர்கள் (_உதாரணமாக, "இந்த திட்டத்தில் வாரத்திற்கு 5 மணிநேரம் மட்டுமே செலவிடுகிறோம்"_)

[ஜெகில்](https://github.com/jekyll/jekyll/tree/master/docs), [கோகோபாட்ஸ்](https://github.com/CocoaPods/CocoaPods/wiki/Communication-&-Design-Rules), மற்றும் [ஹோம்புருவ்](https://github.com/Homebrew/brew/blob/bbed7246bc5c5b7acb8c1d427d10b43e090dfd39/docs/Maintainers-Avoiding-Burnout.md) பராமரிப்பாளர்களுக்கும் பங்களிப்பாளர்களுக்கும் தரவின் விதிகள் கொண்ட பல திட்டங்களுக்கான உதாரணங்கள்.

### கருத்துப்பரிமாற்றத்தை பொதுவில் வைக்கவும்

உங்கள் கருத்துப்பரிமாற்றத்தை ஆவணப்படுத்த மறக்காதீர்கள். முடிந்தவரை திட்டப்பணி குறித்த கருத்துப்பரிமாற்றங்களை பொதுவில் வைக்கவும். ஒரு அம்ச கோரிக்கையை அல்லது ஆதரவு தேவை பற்றி விவாதிக்க தனிப்பட்ட முறையில் உங்களைத் தொடர்பு கொள்ள முயற்சித்தால், ஒரு அஞ்சல் முகவரி அல்லது சிக்கல் தடமி போன்ற பொதுத் தொடர்புத் தலையீட்டை அவர்களை அமைதியாக வழிநடத்துகிறது.

நீங்கள் மற்ற பராமரிப்பாளர்களுடன் சந்தித்தால், அல்லது தனிப்பட்ட முறையில் ஒரு பெரிய முடிவை எடுத்தால், உங்கள் உரையை இடுகையிடும் போதும், இந்த உரையாடல்களை பொதுவில் ஆவணப்படுத்துங்கள்.

அவ்வாறே, உங்கள் சமூகத்தில் சேருகின்ற எவருக்கும் பல வருடங்களாக இருக்கின்றவருக்கு கிடைத்த அதே தகவலை அணுக முடியும்.

## இல்லை என சொல்ல கற்றல்

நீங்கள் விஷயங்களை எழுதிவிட்டீர்கள். பெரும்பாலும், எல்லோரும் உங்கள் ஆவணங்கள் படிக்க வேண்டும், ஆனால் உண்மையில், நீங்கள் இந்த அறிவு உள்ளது என்று மற்றவர்களுக்கு ஞாபகப்படுத்த வேண்டும்.

எவ்வாறாயினும், உங்கள் விதிகளை நடைமுறைப்படுத்த வேண்டிய அவசியம் ஏற்பட்டால், சூழ்நிலைகளைத் தனிமைப்படுத்த உதவுகிறது.

இல்லை என்று சொல்வது எளிதானது இல்லை, ஆனால் _"உங்கள் பங்களிப்பு இந்த திட்டத்தின் அளவுகோல்களுடன் பொருந்தவில்லை"_ என்பது _"உங்கள் பங்களிப்பு எனக்கு பிடிக்கவில்லை"_ என்பதைவிட தனிப்பட்டமுறையில் இல்லாமல் உள்ளது.

ஒரு பராமரிப்பாளராக இல்லை என கூறும் பல சூழ்நிலைகளை நீங்கள் எதிர்கொள்வீர்கள்: நோக்கம் பொருந்தாத அம்ச கோரிக்கைகள், ஒருவர் கலந்துரையாடலைத் தடம்புரள செய்தல், மற்றவர்களுக்கு தேவையற்ற வேலையைச் செய்வது.

### உரையாடலை நட்புணர்வுடன் வைத்துக் கொள்ளுங்கள்

இடுவு மற்றும் இழு கோரிக்கை வரிசை ஆகியவை இல்லை என சொல்ல வேண்டிய இடங்களில் முக்கியமானவையாகும். ஒரு திட்ட பராமரிப்பாளராக, நீங்கள் தவிர்க்க விரும்பாத பரிந்துரைகளை பெறுவீர்கள்.

பங்களிப்பு உங்கள் திட்டத்தின் நோக்கத்தை மாற்றுகிறது அல்லது உங்கள் பார்வைக்கு பொருந்தவில்லை. ஒருவேளை நல்ல யோசனை, ஆனால் செயல்படுத்துதலில் சரியின்மை.

காரணம் எதுவாயினும், உங்கள் திட்டத்தின் தரத்தைச் சந்திக்காத பங்களிப்புகளை சமாளிப்பதற்கு இது சாத்தியமாகும்.

நீங்கள் ஏற்றுக்கொள்ள விரும்பாத பங்களிப்பைப் பெற்றால், உங்கள் முதல் பிரதிபலிப்பு அதை புறக்கணிக்கலாம் அல்லது நீங்கள் அதைப் பார்க்கவில்லை என்று பாசாங்கு செய்யலாம். அவ்வாறு செய்வது மற்றவரின் உணர்ச்சிகளை காயப்படுத்தி, உங்கள் சமூகத்தின் பிற முக்கிய பங்களிப்பாளர்களைத் தடுக்கலாம்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/krausefx?s=180" class="pquote-avatar" alt="avatar">
  பெரிய அளவிலான திறந்த மூல திட்டங்களுக்கு ஆதரவைக் கையாளும் திறவுகோல் சிக்கல்களை நகர்த்துவதாகும். இடுவுகள் ஸ்தம்பிக்காமல் இருக்க முயற்சிக்கவும். நீங்கள் ஒரு iOS டெவலப்பர் என்றால் ரேடர்களைச் சமர்ப்பிக்க எவ்வளவு விரக்தியடைகிறீர்கள் என்று உங்களுக்குத் தெரியும். 2 வருடங்கள் கழித்து, iOS இன் சமீபத்திய பதிப்பை மீண்டும் முயற்சிக்கவும் என்று கூறப்படலாம் .
  <p markdown="1" class="pquote-credit">
— @KrauseFx, ["திறந்த மூல சமூகங்களைக் அளவிடுதல்"](https://krausefx.com/blog/scaling-open-source-communities)
  </p>
</aside>

நீங்கள் தேவையற்ற பங்களிப்பை மூடுவதற்காக வருத்தம் கொள்ள தேவையில்லை. காலப்போக்கில், உங்கள் திட்டத்தில் பதிலளிக்கப்படாத இடுவுகள் மற்றும் இழு கோரிக்கைகள் மனஅழுத்தத்தையும், அச்சுறுத்தலையும் அதிகரிக்கிறது.

நீங்கள் ஏற்க விரும்பாத பங்களிப்புகளை உடனடியாக மூடிவிடுதல் நல்லது. உங்கள் திட்டத்தில் ஏற்கனவே வேலைகள் நிறைய இருந்தால்,  [திறம்பட சிக்கல்களை எவ்வாறு தீர்க்க முடியும்](https://words.steveklabnik.com/how-to-be-an-open-source-gardener) @steveklabnik சொல்லும் சில பரிந்துரைகள்.

இரண்டாவதாக, பங்களிப்புகளை புறக்கணிப்பது உங்கள் சமூகத்திற்கு ஒரு எதிர்மறை சமிக்ஞையை அனுப்புகிறது. ஒரு திட்டத்திற்கு பங்களிப்பது அச்சுறுத்தலாக இருக்கலாம், குறிப்பாக ஒருவரின் முதல் முறை. நீங்கள் அவர்களின் பங்களிப்பை ஏற்றுக் கொள்ளாவிட்டாலும், அதன் பின்னால் உள்ள நபரிடம் ஒப்புக்கொள்வதோடு, அவர்களின் ஆர்வத்திற்கு நன்றி தெரிவிக்கவும். இது ஒரு பெரிய பாராட்டு!

பங்களிப்பை ஏற்றுக்கொள்ள விரும்பவில்லை எனில்:

* **நன்றி சொல்லுங்கள்** அவர்களின் பங்களிப்புக்காக
* **திட்டத்தின் வரம்பிற்குள் ஏன் இது பொருந்தாது**  என்பதை விளக்கவும், முன்னேற்றத்துக்கான தெளிவான பரிந்துரைகளை வழங்கவும். பரிவுடன் அதே சமயம் உறுதியுடன் இருங்கள்.
* **தொடர்புடைய ஆவணங்களுடன் இணையுங்கள்**, உங்களிடம் இருந்தால். நீங்கள் ஏற்றுக்கொள்ள விரும்பாத விடயங்களுக்கு மீண்டும் மீண்டும் கோரிக்கைகளை நீங்கள் கண்டால், தவிர்க்கவேண்டிய ஆவணத்தில் அவற்றைச் சேர்க்கவும்.
* **கோரிக்கையை மூடவும்**

நீங்கள் பதிலளிப்பதற்கு 1-2 க்கும் மேற்பட்ட வாக்கியங்கள் தேவையில்லை. உதாரணமாக, [செலரியின்](https://github.com/celery/celery/) ஒரு பயனரின் விண்டோஸ் தொடர்பான பிழை அறிக்கைக்கு, @berkerpeksag [மறு மொழி](https://github.com/celery/celery/issues/3383):

![Celery screenshot](/assets/images/best-practices/celery.png)

இல்லை என கூறுவதற்கு அச்சமிருந்தால், நீங்கள் மட்டும் தனித்து இல்லை. @jessfraz [கூறுவதுபோல்](https://blog.jessfraz.com/post/the-art-of-closing/):

> பல திறந்த மூல திட்டங்கள், மெசோஸ், குபெர்னிஸ், குரோமியம் ஆகியவற்றின் பராமரிப்பாளர்களிடம் நான் பேசியபோது, அவர்கள் அனைவருக்கும் நீங்கள் விரும்பாத இணைப்புகளை "இல்லை" என்று கூறுவது ஒரு பராமரிப்பாளரின் கடினமான பகுதிகளில் ஒன்று என்று ஓப்புக்கொண்டனர்.

ஒருவரின் பங்களிப்பை ஏற்றுக்கொள்ள விரும்பாதது பற்றி குற்றவுணர்வு கொள்ளவேண்டிய அவசியமில்லை. திறந்த மூலத்தின் முதல் விதி, @shykes [கூற்றுப்படி](https://twitter.com/solomonstre/status/715277134978113536) : _"இல்லை என்பது தற்காலிகம், ஆம் என்பது நிரந்தரம்."_ மற்றொரு நபரின் உற்சாகத்துடன் சமரசம் செய்வது ஒரு நல்ல விஷயம், ஒரு பங்களிப்பை நிராகரிப்பது என்பது பின்னால் உள்ள நபரை நிராகரிப்பது போலவே அல்ல.

இறுதியில், ஒரு பங்களிப்பு போதுமானதாக இல்லையென்றால், அதை ஏற்றுக்கொள்வதற்கான எந்த கடமையும் இல்லை. உங்கள் திட்டத்தில் மக்கள் பங்களிக்கும் போது, தயவுசெய்து பதிலளிக்கவும், ஆனால் நீங்கள் உண்மையிலேயே நம்பும் மாற்றங்களை ஏற்கவும். இல்லை என அடிக்கடி சொல்வதால், அது எளிமையாகிறது. உண்மை.

### செயல்திறனுடன் இருங்கள்

முதல் இடத்தில் தேவையற்ற பங்களிப்புகளின் அளவு குறைக்க, உங்கள் பங்களிப்பு செயல்முறை உங்கள் பங்களிப்பு வழிகாட்டி பங்களிப்புகளை சமர்ப்பிக்கும் மற்றும் ஏற்றுக்கொள்வதையும் விளக்கவும்.

பல குறைந்த தரவரிசை பங்களிப்புகளைப் பெறுகிறீர்கள் என்றால், பங்களிப்பாளர்கள் பணிபுரியும் பணி செய்யும்முன் செய்யவேண்டியவைகளில் சில உள்ளன. உதாரணமாக:

* ஒரு இடுவு அல்லது இழு கோரிக்கை வார்ப்புரு/பட்டியல் நிரப்புக
* ஒரு இழு கோரிக்கை சமர்ப்பிக்கும் முன் ஒரு இடுவு திறக்கவும்

அவர்கள் உங்கள் விதிகள் பின்பற்றவில்லை என்றால், உடனடியாக இடுவை மூடிவிட்டு உங்கள் ஆவணத்தை சுட்டிக்காட்டவும்.

இந்த அணுகுமுறை முதலில் தவறாக உணரக்கூடும் என்றாலும், இரு கட்சிகளுக்கும் நன்மை பயக்கும். நீங்கள் ஏற்கெனவே பல மணிநேரம் வீணடிக்கப்பட்ட வேலைகளில் ஒருவரை இழுக்க வேண்டுமென்ற வாய்ப்பு குறைகிறது. அது உங்கள் பணிச்சுமையை எளிதாக நிர்வகிக்க உதவுகிறது.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikemcquaid?s=180" class="pquote-avatar" alt="avatar">
  அவர்கள் பணி தொடங்கும் முன் அல்லது என்ன ஏற்றுக்கொள்ள மாட்டார்கள் அல்லது எதிர்காலத்தில் ஒரு நல்ல அறிகுறியை எப்படி பெற முடியும் என்பதை, அவர்களுக்கு ஒரு CONTRIBBUTING.md கோப்பு மூலம் விளக்கவும்.
  <p markdown="1" class="pquote-credit">
— @MikeMcQuaid, ["தயவுடன் இழுக்க கோரிக்கைகளை மூடுதல்"](https://github.com/blog/2124-kindly-closing-pull-requests)
  </p>
</aside>

சில நேரங்களில், நீங்கள் இல்லை என சொல்லும்போது, உங்கள் பங்களிப்பாளருக்கு வருத்தமளிக்கலாம் அல்லது உங்கள் முடிவை விமர்சிக்கலாம். அவர்களின் நடத்தை விரோதமானது என்றால், [நிலைமையைத் தணிப்பதற்கான நடவடிக்கைகளை எடுக்கவும்](https://github.com/jonschlinkert/maintainers-guide-to-staying-positive#action-items) அல்லது  ஆக்கபூர்வமாக ஒத்துழைக்க தயாராக இல்லை என்றால் அவர்களை உங்கள் சமூகத்திலிருந்து நீக்கவும்.

### வழிகாட்டுதலை அரவணையுங்கள்

ஒருவேளை உங்கள் சமூகத்தில் உள்ளவர்கள் உங்கள் திட்டத்தின் தரத்தைச் சந்திக்காத பங்களிப்பைச் சமர்ப்பிக்கலாம். நிரந்தரமாக நிராகரிக்கப்படுவதன் மூலம் இரு கட்சிகளுக்கும் ஏமாற்றமளிக்கலாம்.

உங்கள் திட்டத்தை யாராவது ஆர்வத்துடன் பார்க்கிறார்களோ, ஆனால் சிறிது மெருகூற்றல் தேவைப்படுவதால், பொறுமையாக இருங்கள். ஒவ்வொரு சூழ்நிலையிலும் அவர்களின் பங்களிப்புகள் திட்டத்தின் எதிர்பார்ப்புகளை ஏன் பூர்த்தி செய்யவில்லை என்பதை தெளிவாக விளக்குங்கள். எளிமையான அல்லது குறைவான தெளிவற்ற பணியை சுட்டிக்காட்டும் முயற்சியில், "நல்ல முதல் பிழை" என்ற பெயரில், அவர்களுக்கு நல்ல தொடக்கத்தை ஊக்கப்படுத்தவேண்டும். உங்களிடம் நேரம் இருந்தால், அவர்கள் முதல் பங்களிப்பு மூலம் அவர்களை வழிகாட்டுதல், அல்லது உங்கள் சமூகத்தில் வழிகாட்ட வேறு யாரையேனும் ஒருவரை கண்டுபிடியுங்கள்.

## உங்கள் சமூகத்தை ஊக்குவிக்கவும்

நீங்களே எல்லாவற்றையும் செய்ய வேண்டியதில்லை. உங்கள் திட்டத்தின் சமூகம் ஒரு காரணத்திற்காக உள்ளது! செயல்படும் பங்களிப்பாளர்களைக் கொண்டிராவிட்டாலும் கூட, நிறைய பயனர்கள் இருந்தால், அவர்களை கொண்டு  வேலை செய்யுங்கள்.

### பணிச்சுமையை பகிர்ந்து கொள்ளுங்கள்

நீங்கள் அடுத்தவர்கள் பங்களிக்க விரும்பினால், அவர்களிடம் உதவியை கேட்கவும்.

புதிய பங்களிப்பாளர்கள் மீண்டும் மீண்டும் பங்களிப்பதை நீங்கள் காணும்போது, அதிக பொறுப்புகளை வழங்குவதன் மூலம் அவர்களின் வேலைகளை அங்கீகரியுங்கள். மற்றவர்கள் தலைமைத்துவ பாத்திரங்களாக வர விரும்பினால், எவ்வாறு வளரலாம் என்பதை ஆவணப்படுத்தவும்.

[திட்டப்பணியின் முதலாளுமையை பகிர](../building-community/#share-ownership-of-your-project) அடுத்தவர்களை ஊக்கப்படுத்துவத்தின் மூலம் உங்கள் சொந்த பணிச்சுமையை பெரிதும் குறைக்க முடியும், என @lmccart தனது திட்டப்பணியில் கண்டறிந்தார், [p5.js](https://github.com/processing/p5.js?files=1).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lmccart?s=180" class="pquote-avatar" alt="avatar">
  "ஆமாம், யாருக்கும் ஈடுபாடு இருக்க முடியும், நீங்கள் நிறைய குறியீட்டு நிபுணத்துவங்களைக் கொண்டிருக்க வேண்டியதில்லை [...]." என்று சொன்னேன். ஓரு [நிகழ்விற்கு] வருவதற்கு பலர் ஓப்புக் கொண்டனர். இது உண்மையா என்று? அப்பொழுது நான் ஆச்சரியம் கொண்டேன். அங்கு 40 பேர் இருப்பார்கள். அவர்கள் ஒவ்வொருவருடனும் நான் அமர வேண்டுமென்றில்லை... ஆனால் அனைவரும் ஓன்று கூடுவதனால், வேலை சுலபமாகிறது. ஒரு நபர் கற்றவுடன், அதை தன் அருகில் உள்ளவருக்கு கற்பிப்பார்.
  <p markdown="1" class="pquote-credit">
— @lmccart, [""திறந்த மூலம்" என்பதன் பொருள் என்ன? p5.js பதிப்பு"](https://medium.com/@kenjagan/what-does-open-source-even-mean-p5-js-edition-98c02d354b39)
  </p>
</aside>

நீங்கள் உங்கள் திட்டத்திலிருந்து தற்காலிகமாகவோ அல்லது நிரந்தரமாக விலக வேண்டியிருந்தால், வேறு யாரிடமேனும் உங்கள் திட்டத்தை எடுத்துக்கொள்ளுமாறு கேட்டுக்கொள்வதில் எந்த வருத்தமும் கொள்ள தேவையில்லை.

மற்றவர்கள் அதன் திசையைப் பற்றி ஆர்வத்துடன் இருந்தால், அவர்களுக்கு அணுகல் வழங்க அல்லது அதிகாரப்பூர்வமாக மற்றவர்களிடம் கட்டுப்பாட்டை ஒப்படைக்கவும். யாராவது உங்கள் திட்டத்தின் கிளையை, வேறு எங்காவது பராமரித்து வந்தால், உங்கள் அசல் திட்டத்திடமிருந்து பிணைப்பை இணைக்கவும். பல மக்கள் உங்கள் திட்டம் வாழ வேண்டும் என எண்ணுவது பெரிய விஷயம்!

@progrium திட்டத்தின் நோக்கை ஆவணப்படுத்திருந்ததால், அவர் திட்டத்தில் இருந்து விலகி பின்னர் கூட [Dokku](https://github.com/dokku/dokku) அந்த இலக்குகளை வாழ உதவியது என [கண்டறிந்தார்](https://progrium.com/blog/2015/12/04/leadership-guilt-and-pull-requests/)

> நான் விரும்பியதை விவரிக்கும் ஒரு விக்கி பக்கத்தையும் நான் ஏன் விரும்பினேன் என்றும் எழுதினேன். சில காரணங்களால், பராமரிப்பாளர்கள் அந்த திசையில் திட்டத்தை நகர்த்தியதில் எனக்கு ஆச்சரியமாக இருந்தது! அது நான் நகர்த்துவதை போல இருந்ததா? எல்லா நேரத்திலும் இல்லை. ஆனால் நான் எழுதியதை நோக்கி திட்டத்தை கொண்டு சென்றது.

### மற்றவர்களுக்குத் தேவையான தீர்வுகளை உருவாக்கவும்

உங்களுடைய திட்டம் என்ன செய்ய வேண்டும் என்பதைப் பொறுத்து ஒரு பங்களிப்பாளருக்கு வித்தியாசமான அபிப்ராயம் இருந்தால், அவர்கள் தங்கள் சொந்த கிளையில் வேலை செய்ய மெதுவாக ஊக்குவிக்க வேண்டும்.

ஒரு திட்டத்தை நகலெடுப்பது ஒரு கெட்ட காரியம் அல்ல. திட்டங்களை நகலெடுத்து மாற்றியமைப்பது திறந்த மூலத்தில் உள்ள விஷயங்களில் ஒன்றாகும். உங்கள் சமூக உறுப்பினர்கள் தங்கள் சொந்த கிளையில் வேலை செய்ய ஊக்குவிப்பார்கள், உங்கள் திட்டத்தின் பார்வைக்கு முரணாக இல்லாமல், அவர்கள் தேவைப்படும் படைப்புக்கு வெளிச் செல்லும் வழியை வழங்க முடியும்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/geerlingguy?s=180" class="pquote-avatar" alt="avatar">
  நான் 80% பயன்பாடு வழக்கை பூர்த்தி செய்கிறேன். நீங்கள் ஒரு யுனிகார்னாக இருந்தால், தயவுசெய்து என் திட்டத்தை நகலெடுத்துக் கொள்ளுங்கள். நான் புண்பட மாட்டேன்! என் பொது திட்டங்கள் கிட்டத்தட்ட எப்போதும் பொதுவான பிரச்சினைகளைத் தீர்ப்பதற்குத்தான். என் திட்டத்தை நகலெடுத்தோ அல்லது அதை விரிவுபடுத்துவதன் மூலம் ஆழமாக செல்ல நான் முயற்சி செய்கிறேன்.
  <p markdown="1" class="pquote-credit">
— @geerlingguy, ["நான் ஏன் PR ஐ மூடுகிறேன்"](https://www.jeffgeerling.com/blog/2016/why-i-close-prs-oss-project-maintainer-notes)
  </p>
</aside>

அதேபோல், இது உங்களுக்கு அலைக்கற்றை இல்லாத பொழுது உங்கள் தீர்வை உண்மையில் விரும்பும் ஒரு பயனருக்கு இது பொருந்தும். APIகள் மற்றும் தனிப்பயனாக்குதல் கொக்கிகள் வழங்குவதன் மூலம், மற்றவர்கள் தங்கள் சொந்த தேவைகளை பூர்த்தி செய்ய முடியும், மூலத்தை நேரடியாக மாற்றியமைக்க முடியாது. கோகோபாட்களுக்கான கூடுதல் ஊக்குவிப்புகளை "மிகவும் சுவாரஸ்யமான சில கருத்துக்களுக்கு" வழிவகுத்தது என்று @orta [கண்டறிந்தார்](https://artsy.github.io/blog/2016/07/03/handling-big-projects/):

> ஒரு திட்டம் பெரியதாகிவிட்டால், அவை புதிய குறியீட்டை அறிமுகப்படுத்துவது பற்றி மிகவும் பழமைவாதமாக இருக்க வேண்டும் என்பது கிட்டத்தட்ட தவிர்க்க முடியாதது. நீங்கள் "இல்லை" என்று சொல்வது நல்லது, ஆனால் நிறைய பேர் சட்டப்பூர்வ தேவைகளை கொண்டிருக்கிறார்கள். எனவே, அதற்கு பதிலாக நீங்கள் ஒரு கருவியாக உங்கள் மேடையாக மாற்ற முடிகிறது.

## தானியங்கு பொறிகளை கொண்டு வாருங்கள்

மற்றவர்கள் உங்களுக்கு உதவக்கூடிய பணிகளைச் செய்வது போலவே, எந்தவொரு மனிதனும் செய்ய வேண்டாத பணிகளும் உள்ளன. தானியங்கு பொறிகள் உங்கள் நண்பர்களே. ஒரு பராமரிப்பாளராக உங்கள் வாழ்வை எளிதாக்குவதற்கு அவற்றைப் பயன்படுத்துங்கள்.

### உங்கள் குறியீட்டின் தரத்தை மேம்படுத்துவதற்கு சோதனைகள் மற்றும் பிற சரிபார்ப்பு முறைகள் தேவை

சோதனைகளை சேர்ப்பதன் மூலம் நீங்கள் உங்கள் திட்டத்தை தானியங்க செய்யக்கூடிய மிக முக்கியமான வழிகளில் ஒன்றாகும்.

சோதனைகள், பங்களிப்பாளர்களுக்கு அவர்கள் எதையும் உடைக்க மாட்டார்கள் என்று நம்பிக்கையை தருகிறது. விரைவாக பங்களிப்புகளை மதிப்பாய்வு செய்து ஏற்றுக்கொள்வதற்கும் அவை எளிதாக்குகின்றன. நீங்கள் துரிதமாக பதிலளிக்கிறீர்கள் என்றால், உங்கள் சமுதாயத்தை இன்னும் அதிகமாக ஈடுபடுத்தலாம்.

அனைத்து எதிர்வரும் பங்களிப்புகளை இயக்கும் தானியங்கு சோதனைகள் அமைக்கவும், உங்கள் சோதனைகளை எளிதில் பங்களிப்பவர்களால் இயக்க முடியும் என்பதை உறுதி செய்யவும். அனைத்து குறியீட்டு பங்களிப்புகளும் சமர்ப்பிக்கப்படுவதற்கு முன் உங்கள் சோதனைகளை கடக்க வேண்டும். எல்லா சமர்ப்பிப்புகளுக்குமான குறைந்தபட்ச தரமான தரத்தை அமைக்க உதவுவீர்கள். கிட்ஹப்-இல் [தேவைப்படும் நிலை சரிபார்ப்புக்கள்](https://help.github.com/articles/about-required-status-checks/) உங்கள் சோதனைகளை கடந்துசெல்லாமல் மாற்றம் எதுவும் சேர்க்கப்படாது என்பதை உறுதிப்படுத்த உதவுகிறது.

நீங்கள் சோதனையைச் சேர்த்தால், உங்கள் பங்களிப்புக் கோப்பில் (CONTRIBUTING file) அவர்கள் எவ்வாறு வேலை செய்கின்றன என்பதை விளக்கிச் சொல்லுங்கள்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/edunham?s=180" class="pquote-avatar" alt="avatar">
  மக்கள் வேலை செய்யும் அனைத்து குறியீட்டிற்கும் சோதனைகள் தேவை என்று நான் நம்புகிறேன். குறியீடு முழுமையாக மற்றும் செய்தபின் சரியானதாக இருந்தால், அதில் மாற்றங்கள் தேவையில்லை - ஏதாவது தவறு ஏற்பட்டால், அது "அது செயலிழக்கச் செய்கிறது" அல்லது "இது போன்ற ஒரு அம்சம் இல்லை" என்பதை நாம் மட்டும் குறியீட்டை எழுதலாம். நீங்கள் எடுக்கும் மாற்றங்களைப் பொருட்படுத்தாமல், நீங்கள் தற்செயலாக அறிமுகப்படுத்தக்கூடிய எந்தப் பின்னடைவுகளையும் கையாளுவதற்கு சோதனைகள் அவசியம்.
  <p markdown="1" class="pquote-credit">
— @edunham, ["ரஸ்ட்'ஸ் சமுதாய தன்னியக்கமாக்கல்"](https://edunham.net/2016/09/27/rust_s_community_automation.html)
  </p>
</aside>

### அடிப்படை பராமரிப்பு பணிகளை தானியங்குபடுத்துவதற்கு கருவிகளைப் பயன்படுத்துங்கள்

ஒரு பிரபலமான திட்டத்தை பராமரிப்பது பற்றிய நற்செய்தி என்னவெனில் மற்ற பராமரிப்பாளர்கள் இதே போன்ற பிரச்சினைகளை எதிர்கொண்டு, அதற்காக ஒரு தீர்வை உருவாக்கினர்.

பராமரிப்பு பணியின் சில அம்சங்களை தானியங்குபடுத்துவதற்கு [பல்வேறு வகையான கருவிகள்](https://github.com/showcases/tools-for-open-source) உள்ளன. ஒரு சில உதாரணங்கள்:

* [சொற்பொருள் வெளியீடு](https://github.com/semantic-release/semantic-release) உங்கள் வெளியீட்டை தானியங்குபடுத்துகிறது
* [குறிப்பிடு-செயலி](https://github.com/facebook/mention-bot) இழு கோரிக்கைகளுக்கு சாத்தியமான விமர்சகர்களை குறிப்பிடுகின்றது
* [இடர்](https://github.com/danger/danger) குறியீடு மதிப்பாய்வை தானியங்குபடுத்துவதற்கு உதவுகிறது

பிழை அறிக்கைகள் மற்றும் பிற பொதுவான பங்களிப்புகளுக்கு, கித்ஹப்-இல் உள்ள [சிக்கல் வார்ப்புருக்கள் மற்றும் இழு கோரிக்கை சிக்கல் வார்ப்புருக்கள்](https://github.com/blog/2111-issue-and-pull-request-templates), நீங்கள் பெறும் தகவலை தடையின்றிப் பெருவதற்கு உதவும். @TalAter உங்கள் சிக்கல் மற்றும் PR வார்ப்புருக்கள் எழுதுவதற்கு உதவுவதற்கு [உங்கள் சொந்த சாதனை வழிகாட்டியைத் தேர்வுசெய்யவும்](https://www.talater.com/open-source-templates/#/) உருவாக்கினார்.

உங்கள் மின்னஞ்சல் அறிவிப்புகளை நிர்வகிக்க, [மின்னஞ்சல் வடிகட்டிகள்](https://github.com/blog/2203-email-updates-about-your-own-activity) மூலம் முன்னுரிமை கொடுத்து ஒழுங்குபடுத்தலாம்.

நீங்கள் இன்னும் சிறிது மேம்பட்ட பெற விரும்பினால், பாணி வழிகாட்டிகள் மற்றும் பிசிரிழை மூலம் திட்ட பங்களிப்புகளை தரப்படுத்தி அவற்றை ஆய்வு மற்றும் ஏற்க எளிதாக செய்ய முடியும்.

இருப்பினும், உங்கள் தரவுகள் மிக சிக்கலானதாக இருந்தால், அவர்கள் பங்களிப்புக்கு தடைகளை அதிகரிக்க முடியும். நீங்கள் எல்லோருடைய வாழ்க்கையையும் எளிதாக்கிக்கொள்ள போதுமான விதிகள் மட்டுமே சேர்க்கிறீர்கள் என்பதை உறுதிப்படுத்தவும்.

எந்த கருவிகளைப் பயன்படுத்துவது என்பது உங்களுக்குத் தெரியாவிட்டால், பிற பிரபலமான திட்டங்கள், குறிப்பாக உங்கள் சுற்றுச்சூழலில் உள்ளவை என்ன என்பதைப் பாருங்கள். உதாரணமாக, பங்களிப்பு செயல்முறை பிற முனை தொகுதிகள் எவ்வாறு இருக்கும்? இதேபோன்ற கருவிகள் மற்றும் அணுகுமுறைகளைப் பயன்படுத்துவதன் மூலம் உங்கள் இலக்கு பங்களிப்பாளர்களுக்கு உங்கள் செயல்முறை நன்கு அறியப்படும்.

## இடைநிறுத்தம் எடுப்பது பரவாயில்லை

திறந்த மூல வேலை உங்களுக்கு மகிழ்ச்சியைக் கொடுத்தது. ஒருவேளை இப்போது நீங்கள் தனிமை அல்லது குற்ற உணர்வு கொள்ளலாம்.

உங்கள் திட்டங்களைப் பற்றி நீங்கள் யோசித்துக்கொண்டிருக்கும்போது ஒருவேளை நீங்கள் கவலைகள் அல்லது அச்சம் வளர்வதாக உணரலாம். இதற்கிடையில், பிரச்சினைகள் மற்றும் கோரிக்கைகளை இழுக்கின்றன.

வெளிப்படையான மூல வேலைகளில், குறிப்பாக பராமரிப்பாளர்களிடையே, தீய்வு என்பது ஒரு உண்மையான மற்றும் பரவலான பிரச்சினையாகும். ஒரு பராமரிப்பாளராக, உங்களுடைய மகிழ்ச்சி என்பது திறந்த மூல திட்டத்தின் உயிர் பிழைப்பதற்கான ஒரு நிபந்தனையற்ற தேவையாகும்.

சொல்வதற்கு அவசியமில்லை, ஒரு இடைவெளி எடுத்துக்கொள்ளுங்கள்! ஒரு விடுமுறை எடுக்க எரிந்தொழியும் வரை நீங்கள் காத்திருக்க வேண்டியதில்லை. @brettcannon, ஒரு பைதான் உள்ளக மேம்பாட்டாளர், 14 வருடங்கள் திறந்த மூல தன்னார்வ பணிக்கு பிறகு [ஒரு மாத கால விடுமுறை](https://snarky.ca/why-i-took-october-off-from-oss-volunteering/) எடுத்து கொள்ள முடிவு செய்தார்.

வேறு எந்த வகையிலான பணிமுறையையும் போல, வழக்கமான இடைவெளிகளை எடுத்துக் கொண்டால், நீங்கள் உங்கள் வேலையைப் புதுப்பித்து, மகிழ்ச்சியுடன், உற்சாகமாக வைத்திருப்பீர்கள்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/danielbachhuber?s=180" class="pquote-avatar" alt="avatar">
  WP-CLI ஐ பராமரிப்பதில், முதலில் நான் மகிழ்ச்சியடைந்தேன், என் ஈடுபாட்டின் மீது தெளிவான எல்லைகளை அமைத்தேன். என் சாதாரண பணி அட்டவணையின் ஒரு பகுதியாக, வாரத்திற்கு 2-5 மணிநேரத்தை நான் கண்டிருக்கிறேன். இது என் ஈடுபாடு ஒரு உணர்வு, மற்றும் மிகவும் வேலை உணர்கிறேன் இருந்து வைத்திருக்கிறது. நான் பணிபுரியும் பிரச்சினைகளுக்கு முன்னுரிமை அளிப்பதால், மிக முக்கியமானது என்னவென்று நான் நினைக்கிறேன். நான் பணிபுரியும் பிரச்சினைகளுக்கு முன்னுரிமை அளிப்பதால், நான் மிகவும் முக்கியம் என நினைப்பதில் நான் தொடர்ந்து முன்னேற்றம் செய்ய முடிகிறது.
  <p markdown="1" class="pquote-credit">
— @danielbachhuber, ["என் இரங்கல்கள், நீங்கள் இப்போது ஒரு பிரபலமான திறந்த மூல திட்டத்தின் பராமரிப்பாளர்"](https://runcommand.io/2016/06/26/my-condolences-youre-now-the-maintainer-of-a-popular-open-source-project/)
  </p>
</aside>

சில நேரங்களில், எல்லோருக்கும் உங்கள் அவசியம் தேவைப்படுவது போல் உணர்ந்தால் திறந்த மூல வேலைகளில் இருந்து இடைவேளி எடுப்பது கடினம். நீங்கள் விலகிச் செல்லவதால் மக்கள் உங்களை குற்றவாளியாக உணர முயற்சி செய்யலாம்.

நீங்கள் ஒரு திட்டத்தில் இருந்து விலகி நிற்கையில், உங்கள் பயனர்களுக்கும் சமூகத்திற்கும் ஆதரவைக் கண்டறிய உதவுங்கள். உங்களுக்குத் தேவையான ஆதரவைக் கண்டுபிடிக்க முடியவில்லை என்றால், எப்படியாவது ஒரு இடைவெளியை எடுங்கள். நீங்கள் கிடைக்காதபோது தொடர்புகொள்வதை உறுதிப்படுத்திக் கொள்ளுங்கள், எனவே உங்கள் மறுமொழியின்மை காரணமாக மக்கள் குழப்பமடைவதில்லை.

இடைவெளிகளை எடுத்துக்கொள்வது வெறும் விடுமுறையை விட அதிகமாகும். நீங்கள் வார இறுதிகளில் திறந்த மூல வேலை செய்ய விரும்பவில்லை என்றால், அல்லது வேலை நேரங்களில், அந்த எதிர்பார்ப்புகளை மற்றவர்களுக்கு தெரிவிக்க வேண்டும், எனவே அவர்கள் உங்களை தொந்தரவு செய்யக்கூடாது என அறிவர்.

## உங்களை முதலில் கவனித்துக் கொள்ளுங்கள்!

ஒரு பிரபலமான திட்டத்தை பராமரிப்பது, முந்தைய வளர்ச்சியை விட வேறுபட்ட திறமைகளுக்குத் தேவை, ஆனால் அது குறைவான நன்மதிப்பும் இல்லை. ஒரு பராமரிப்பாளராக, சிலர் மட்டுமே அனுபவப்படும் தலைமை மற்றும் தனிப்பட்ட திறமைகளை நீங்கள் பயிற்சி செய்வீர்கள். நிர்வகிப்பது எப்போதும் எளிதல்ல, தெளிவான எல்லைகளை அமைத்தல் மற்றும் நீங்கள் வசதியாக உள்ளதை மட்டும் எடுத்துக்கொள்வது, மகிழ்ச்சியாக, புத்துணர்ச்சியுடனும், பயனுள்ளதாகவும் இருக்க உதவும்.
