---
lang: ko
title: 오픈소스에 기여하는 방법
description: 오픈소스에 기여하고 싶습니까? 초보자와 숙련자를 위한 오픈소스 기여에 대한 가이드입니다.
class: contribute
order: 1
image: /assets/images/cards/contribute.png
related:
  - beginners
  - building
---

## Why contribute to open source?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/errietta?s=180" class="pquote-avatar" alt="avatar">
  Working on \[freenode\] helped me earn many of the skills I later used for my studies in university and my actual job. I think working on open source projects helps me as much as it helps the project!
  <p markdown="1" class="pquote-credit">
— @errietta, ["왜 나는 오프소스 소프트웨어에 기여하는 것을 좋아하는가"](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

오픈소스에 기여하는 것은 당신이 상상할 수 있는 모든 기술을 배우고, 가르치고, 구축하는 보람찬 방법이 될 수 있습니다.

왜 사람들은 오픈소스에 기여합니까? 이에는 많은 이유가 있습니다!

### 기존 기술 향상

코딩, 사용자 인터페이스 디자인, 그래픽 디자인, 글쓰기 또는 조직화등의 실습을 원한다면 오픈소스 프로젝트에 대한 작업이 있습니다.

### 비슷한 것에 관심이있는 사람들을 만나십시오

따뜻하고 환영하는 커뮤니티가 있는 오픈소스 프로젝트는 사람들이 수년간 돌아오도록합니다. 많은 사람들이 부리토에 관한 회의나 심야 온라인 채팅를 가지고 서로를 실행하고 있든간에 오픈소스에 참여함으로써 평생동안 우정을 나누고 있습니다.

### 멘토를 찾고 다른 사람들을 가르치십시오

공유 프로젝트에서 다른 사람들과 함께 일한다는 것은 당신이 일을 어떻게하는지 설명하고, 다른 사람들에게 도움을 요청해야 함을 의미합니다. 학습하고 가르치는 행위는 관련된 모든 사람들에게 성취감있는 활동이 될 수 있습니다.

### 평판(및 경력)을 키우는 데 도움이 되는 공공 예제 만들기

정의에 따르면, 모든 오픈소스 저작물은 공개되어 있으므로, 어디서나 할 수 있는 무료 예제를 얻을 수 있습니다.

### 사람들의 기술 습득

오픈소스는 충돌 해결, 사람들의 팀 구성 및 작업 우선순위 지정과 같은 리더십 및 관리 기술을 연습 할 수있는 기회를 제공합니다.

### 작은 것조차도 변경할 수 있는 힘이 있습니다

오픈소스에 참여하는 것을 즐기는 평생 기여자가 될 필요는 없습니다. 웹 사이트에 오타가 있는 것을 본 적이 있고, 누군가 그것을 고치기를 바랬습니까? 오픈소스 프로젝트에서 여러분은 그렇게 할 수 있습니다. 오픈소스는 사람들이 삶에 대해 어떻게 대처하고 그들이 세상을 경험하는지를 느끼도록 도와줍니다.

## What it means to contribute

새로운 오픈소스 기여자라면, 기여하는 과정이 위협적일 수 있습니다. 올바른 프로젝트를 어떻게 찾을 수 있습니까? 코딩 방법을 모르는 경우에는 어떻게 해야합니까? 뭔가 잘못되면 어떡하죠?

걱정 마세요! 오픈소스 프로젝트에 참여하는 데는 여러 가지 방법이 있으며, 몇 가지 팁을 통해 경험을 최대한 활용할 수 있습니다.

### 코드를 제공할 필요가 없습니다

오픈소스에 기여하는 것에 대한 일반적인 오해는 코드를 작성해야한다는 것입니다. 실제로 대부분 프로젝트에서 [무시되거나 간과되는 부분](https://github.com/blog/2195-the-shape-of-open-source)입니다 . 이러한 유형의 기여를 제공하도록 제안함으로써 프로젝트에 큰 도움을 줄 것입니다!

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/orta?s=180" class="pquote-avatar" alt="avatar">
  I’ve been renowned for my work on CocoaPods, but most people don’t know that I actually don’t do any real work on the CocoaPods tool itself. My time on the project is mostly spent doing things like documentation and working on branding.
  <p markdown="1" class="pquote-credit">
— @orta, ["기본적으로 OSS으로 이동하기"](https://realm.io/news/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

코드 작성을 원한다고해도, 다른 유형의 기여는 프로젝트에 참여하고 다른 커뮤니티 회원을 만날 수 있는 좋은 방법입니다. 이러한 관계를 구축하면 프로젝트의 다른 부분에서 작업 할 수있는 기회가 주어집니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/brettcannon?s=180" class="pquote-avatar" alt="avatar">
  I first reached out to the Python development team (aka python-dev) when I emailed the mailing list on June 17, 2002 about accepting my patch. I quickly caught the open source bug, and decided to start curating email digests for the group. They gave me a great excuse to ask for clarifications about a topic, but more critically I was able to notice when someone pointed out something that needed fixing.
  <p markdown="1" class="pquote-credit">
— @brettcannon, ["메인테이너 이야기"](https://github.com/open-source/stories/brettcannon)
  </p>
</aside>

### 기획 행사가 마음에 드십니까?

* [@fzamperin이 NodeSchool에 대했던 것처럼](https://github.com/nodeschool/organizers/issues/406), 프로젝트에 관한 워크샵이나 모임을 조직하기
* 프로젝트 컨퍼런스 구성하기 (있는 경우)
* 커뮤니티 구성원들이 적절한 회의를 찾고 말하기에 대한 제안서 제출하기

### 디자인하고 싶습니까?

* 프로젝트의 유용성을 높이기 위해 레이아웃 재구성하기
* [Drupal 제안처럼](https://www.drupal.org/community-initiatives/drupal-core/usability),사용자 조사를 통해, 프로젝트의 네비게이션 또는 메뉴를 재구성하고 수정하기
* 프로젝트가 일관성있는 시각적 디자인을 가질 수 있도록, 스타일 가이드를 작성하기
* [hapi.js의 기여처럼](https://github.com/hapijs/contrib/issues/68), 티셔츠 혹은 새로운 로고를 위한 예슐 작품 만들기

### 글 쓰고 싶습니까?

* 프로젝트의 문서 작성 및 개선하기
* 프로젝트 사용법을 보여주는 예제 폴더를 선별하기
* 프로젝트의 뉴스 레터를 시작하거나 메일링 리스트의 하이라이트를 관리하십시오.
* [PyPA의 기여처럼](https://github.com/pypa/python-packaging-user-guide/issues/194), 프로젝트의 튜토리얼을 작성하기.
* 프로젝트의 문서의 번역문 작성하기

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kittens?s=180" class="pquote-avatar" alt="avatar">
  Seriously, \[documentation\] is mega-important. The documentation so far has been great and has been a killer feature of Babel. There are sections that could certainly use some work and even the addition of a paragraph here or there is extremely appreciated.
  <p markdown="1" class="pquote-credit">
— @kittens, ["기여자 부르기"](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### 조직하는 것을 좋아합니까?

* 중복된 이슈에 대한 링크 및 새로운 이슈 라벨 제안, 정리된 상태 유지하기
* [@nzakas가 ESLint에 했던것처럼](https://github.com/eslint/eslint/issues/6765), 열려있는 이슈를 검토하고, 오래된 이슈를 닫을 것을 제안하기
* 최근 열린 이슈에 대한 질문을 명확히 하여 토론으로 나아가게하기

### 코드 작성하고 싶습니까?

* [@dianjin이 Leaflet 했던것처럼](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560), 해결할 문제를 찾기
* 새로운 기능을 작성하는 데 도움을 줄 수 있는지 물어보기
* 프로젝트 설정 자동화하기
* 툴링 및 테스트 개선하기

### 사람들을 돕는 것을 좋아합니까?

* 예를 들어, Stack Overflow의 ([Postgres 예시](https://stackoverflow.com/questions/18664074/getting-error-peer-authentication-failed-for-user-postgres-when-trying-to-ge)) 혹은 Reddit과 관련된 질문에 대답해주기
* 열린 이슈에서 사람들의 질문에 대답해주기
* 토론 보드나 대화 채널의 관리 돕기

### 다른 사람들의 코드를 돕는 것을 좋아합니까?

* 다른 사람들의 제출한 코드를 리뷰하기
* 프로젝트를 어떻게 쓰는가에 대한 튜토리얼 작성하기
* [@ereichert처럼 Rust에서 @bronzdoc을 사용하고](https://github.com/rust-lang/book/issues/123#issuecomment-238049666), 다른 기여자를 멘토로 초대하기

### 소프트웨어 프로젝트만으로 작업할 필요는 없습니다!

"오픈소스"는 종종 소프트웨어를 의미하지만, 무엇이든간에 거의 협력 할 수 있습니다. 오픈소스 프로젝트로 개발되는 책, 요리법, 목록 및 수업이 있습니다.

예시로 아래와 같습니다:

* @sindresorhus는 [list of "awesome" lists](https://github.com/sindresorhus/awesome)를 만들었습니다
* @h5bp는 프론트엔드 개발자 후보군용 [list of potential interview questions](https://github.com/h5bp/Front-end-Developer-Interview-Questions)을 관리하고 있습니다
* @stuartlynn과 @nicole-a-tesla는 [collection of fun facts about puffins](https://github.com/stuartlynn/puffin_facts)를 만들었습니다

비록 당신이 소프트웨어 개발자일지라도, 문서 프로젝트 작업은 오픈소스에서 시작하는 데 도움이 될 수 있습니다. 코드를 포함하지 않는 프로젝트에서 작업하는 것이 종종 위협적이지 않으며, 협업 프로세스가 자신감과 경험을 쌓을 수 있습니다.

## Orienting yourself to a new project

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shaunagm?s=180" class="pquote-avatar" alt="avatar">
  If you go to an issue tracker and things seem confusing, it's not just you. These tools require a lot of implicit knowledge, but people can help you navigate it and you can ask them questions.
  <p markdown="1" class="pquote-credit">
— @shaunagm, ["어떻게 오픈소스에 기여하는가"](https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/)
  </p>
</aside>

오타를 수정하는 이상의 것, 오픈소스에 기여하는 것은 파티에서 낯선 사람들에게 다가가는 것과 같습니다. 라마에 대해 이야기하기 시작하면, 금붕어에 관한 토론이 깊어지면서 아마 당신을 조금 이상하게 보게 될 것입니다.

자신의 제안으로 맹목적으로 뛰어 들기 전에, 먼저 방을 읽는 법을 배우십시오. 그렇게하면 아이디어가 눈에 띄고 들리게 될 확률이 높아집니다.

### 오픈소스 프로젝트의 해부학

모든 오픈소스 커뮤니티는 다릅니다.

하나의 오픈소스 프로젝트에 수년을 보내다 보면 하나의 오픈소스 프로젝트를 알게되었다는 것을 의미합니다. 다른 프로젝트로 이동하면 어휘, 규범 및 의사 소통 스타일이 완전히 다른 것을 알 수 있습니다.

즉, 많은 오픈소스 프로젝트는 비슷한 조직 구조를 따릅니다. 서로 다른 커뮤니티 역할과 전반적인 프로세스를 이해하면 새로운 프로젝트를 신속하게 수행할 수 있습니다.

일반적인 오픈소스 프로젝트에는 다음 유형의 사람들이 있습니다:

* **작성자:** 이 프로젝트를 만든 사람 혹은 조직
* **소유자:** 조직 또는 저장소에 대한 관리 권한을 가진 사람 (항상 원래 작성자와 동일하지는 않음)
* **메인테이너:** 비전을 주도하고 프로젝트의 조직 측면을 관리하는 책임이 있는 기여자. (그들은 프로젝트의 저자 또는 소유자일 수도 있습니다.)
* **기여자:** 프로젝트에 다시 기여한 모든 사람.
* **커뮤니티 맴버:** 프로젝트를 사용하는 사람들. 대화에서 적극적이거나 프로젝트 방향에 대한 의견을 표명할 수 있습니다.

더 큰 프로젝트에는 툴링, 선별, 커뮤니티 중재 및 이벤트 조직과 같은 다양한 업무에 초점을 둔 소위원회 또는 실무 그룹이 있을 수도 있습니다. 프로젝트 웹 사이트에서 "팀" 페이지를 찾거나 거버넌스 문서 저장소에 이 정보를 찾으십시오.

프로젝트에도 문서가 있습니다. 이러한 파일은 대개 저장소의 최상위 레벨에 나열됩니다.

* **라이선스:** 정의에 의하면, 모든 오픈소스 프로젝트는 반드시 [오픈소스 라이선스를 가져야 합니다](https://choosealicense.com). 만약 프로젝트가 라이선스를 가지지 않는다면, 이건  오픈소스가 아닙니다.
* **README:** README는 새로운 커뮤니티 구성원을 프로젝트에 환영하게 하는 지침서입니다. 왜 프로젝트가 유용하고 시작하는 방법을 설명합니다.
* **CONTRIBUTING:** README는 사람들이 프로젝트를 사용하는 데 도움이되지만, CONTRIBUTING 문서는 사람들이 프로젝트에 _기여_하는 데 도움이됩니다. 필요한 기여 유형과 프로세스 작동 방식을 설명합니다. 모든 프로젝트가 CONTRIBUTING 파일을 갖고있는 것은 아니지만, 공존하는 환영 프로젝트임을 알립니다.
* **CODE_OF_CONDUCT:** code of conduct는 참가자의 행동에 대한 기본 원칙을 설정하고, 친절하고 환영할만한 환경을 조성하는 데 도움이 됩니다. 모든 프로젝트가 CODE_OF_CONDUCT 파일을 가지고있는 것은 아니지만, 그 존재가 기여할 수 있는 환영 프로젝트임을 알립니다.
* **다른 문서:** (특히 큰 프로젝트의 경우) 튜토리얼, 연습장 또는 거버넌스 정책과 같은 추가 문서가 있을 수 있습니다.

마지막으로 오픈소스 프로젝트는 다음 도구를 사용하여 토론을 구성합니다. 기록 보관소를 읽으면 커뮤니티가 어떻게 사고하고 작동하는지 잘 알 수 있습니다.

* **Issue tracker:** 사람들이 프로젝트와 관련된 이슈를 토론하는 공간입니다.
* **Pull requests:** 사람들이 토론하고 진행중인 변경 사항을 검토합니다.
* **토론 포럼 혹은 메일링 리스트:** 일부 프로젝트는 회화 주제(ex. _"How do I..."_ or _"What do you think about..."_ instead of bug reports or feature requests)에 대해 이러한 채널을 사용할 수 있습니다. 다른 사람들은 모든 대화에 이슈 트래커를 사용합니다.
* **동기식 채널 채팅:** 일부 프로젝트에서는 일상 회화, 공동 작업 및 빠른 교환을 위해 채팅 채널 (예 : 슬랙 또는 IRC)을 사용합니다.

## Finding a project to contribute to

이제 오픈소스 프로젝트가 어떻게 작동하는지 알게 되었으니, 이제는 기여할 프로젝트를 찾아야 할 때입니다!

이전에 오픈소스에 기여한 적이 없다면, John F. Kennedy 미국 대통령의 _"Ask not what your country can do for you - ask what you can do for your country."_ 발언에서 조언을 구하십시오.

오픈소스에 기여하는 것은 프로젝트 전반에 걸쳐 모든 수준에서 발생합니다. 첫 번째 기여가 정확히 무엇인지 또는 어떻게 보일지를 생각할 필요가 없습니다.

대신, 이미 사용하고 있거나 사용하고 싶은 프로젝트에 대해 생각해보십시오. 적극적으로 기여할 프로젝트는 자신이 다시 찾아 오는 프로젝트입니다.

그 프로젝트 내에서, 뭔가가 더 좋거나 다를 수 있다고 생각할 때마다 본능에 따라 행동하십시오.

오픈소스는 독점적인 클럽이 아닙니다; 그것은 당신 같은 사람들에 의해 만들어졌습니다. "오픈소스"는 전세계 문제를 유연하게 해결할 수 있는 멋진 용어입니다.

README를 스캔하여 깨진 링크 또는 오타를 찾을 수 있습니다. 또는 새로운 사용자이고 무언가가 고장 났거나, 실제로 문서에 있어야한다고 생각되는 문제를 발견했습니다. 그것을 무시하고 계속 나아가거나, 다른 사람에게 그것을 고치라고 요구하는 대신, 피칭을 통해 도움을 줄 수 있는지 확인하십시오. 오픈소스가 무엇인지 알아보십시오!

> [일반적인 기여의 28%](https://www.igor.pro.br/publica/papers/saner2016.pdf)는 오타 수정, 서식 재 지정 또는 번역 작성과 같은 문서입니다.

또한 다음 리소스 중 하나를 사용하여 새 프로젝트를 찾고 기여할 수 있습니다.

* [GitHub Explore](https://github.com/explore/)
* [Open Source Friday](https://opensourcefriday.com)
* [First Timers Only](https://www.firsttimersonly.com/)
* [CodeTriage](https://www.codetriage.com/)
* [24 Pull Requests](https://24pullrequests.com/)
* [Up For Grabs](https://up-for-grabs.net/)
* [Contributor-ninja](https://contributor.ninja)

### A checklist before you contribute

기여하고 싶은 프로젝트를 찾았으면, 프로젝트가 기여를 받기에 적합한 지 빠르게 확인하십시오. 그렇지 않으면, 노력이 절대로 응답을 받지 못할 수도 있습니다.

다음은 프로젝트가 새로운 기여자에게 좋은가에 대한 여부를 평가하는 편리한 체크리스트입니다.

**오픈소스의 정의를 충족시킵니다**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
  라이선스가 있습니까? 대부분, 저장소의 최상단에 있는 LICENSE라 불리는 파일입니다.
  </label>
</div>

**프로젝트가 적극적으로 기여를 받습니다**

마스터 브랜치에서 커밋 활동을 살펴보십시오. GitHub에서는 이 정보를 저장소의 홈페이지에서 볼 수 있습니다.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
  최신 커밋은 언제 있습니까?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
  프로젝트에 참여한 기여자가 몇 명입니까?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
  얼마나 사람들 자주 커밋합니까? (깃허브에서는, 상단 바에 있는 "Commits"을 클릭하여 찾을 수 있습니다.)
  </label>
</div>

다음으로, issues 프로젝트의 이슈를 봅시다.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    얼마나 많은 공개 이슈가 있습니까?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    메인테이너가 열린 이슈에 신속하게 대응합니까?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    이슈에 대한 활발한 토론이 있습니까?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    최근에 이슈가 있습니까?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    이슈가 닫히고 있습니까? (깃허브에서는, 이슈 페이지에서 닫힌 이슈를 "closed" 탭을 눌러 볼 수 있습니다.)
  </label>
</div>

이제 프로젝트의 pull requests에 대해 동일한 작업을 수행하십시오.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    얼마나 많은 pull requests가 열리고 있습니까?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">
    메인테이너가 열린 pull requests에 신속하게 대응합니까?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    pull requests에서 활발히 토론이 나옵니까?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    최근 pull requests가 있습니까?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">
    최근 모든 pull requests가 병합되고 있습니까? (깃허브에서는,pull requests 페이지에서 "closed" 탭을 눌러 닫힌 PR을 볼 수 있습니다.)
  </label>
</div>

**프로젝트가 환영합니다**

프로젝트가 친근하게 환영한다는 신호로 새로운 기여자를 받아 들일 것입니다.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">
    관리자가 이슈의 질문에 도움이 됩니까?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">
    이슈, 토론 포럼 및 채팅(예를 들어. IRC 혹은 Slack)에 있는 사람들이 친절합니까?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">
    pull requests가 리뷰를 받고 있습니까?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">
    메인테이너가 기여자들에게 고마워합니까?
  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Whenever you see a long thread, spot check responses from core developers coming late in the thread. Are they summarizing constructively, and taking steps to bring the thread to a decision while remaining polite? If you see a lot of flame wars going on, that's often a sign that energy is going into argument instead of into development.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_OSS 생산_](https://producingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## How to submit a contribution

원하는 프로젝트를 찾았으면 기꺼이 기여할 준비가되었습니다. 마침내! 올바른 방법으로 기여를 받는 방법은 다음과 같습니다.

### 효과적으로 의사 소통하기

일회 기여자이든 커뮤니티에 참여하려고하든, 관계없이 다른 사람들과 협력하는 것은 오픈소스에서 개발할 가장 중요한 기술 중 하나입니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shubheksha?s=180" class="pquote-avatar" alt="avatar">
  \[As a new contributor,\] I quickly realized I had to ask questions if I wanted to be able to close the issue. I skimmed through the code base. Once I had some sense of what was going on, I asked for more direction. And voilà! I was able to solve the issue after getting all the relevant details I needed.
  <p markdown="1" class="pquote-credit">
— @shubheksha, [초보자가 오픈소스 세계를 통해 즐기는 매우 울퉁불퉁한 여정](https://medium.freecodecamp.com/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39#.pcswr2e78)
  </p>
</aside>

이슈를 열거나 pull request를 하기 전에, 또는 채팅에서 질문을 하기 전에, 아이디어를 효과적으로 전달할 수 있도록 이러한 점을 명심하십시오.

**context 제공하기.** 다른 사람들이 신속하게 속도를 낼 수 있도록 도와주십시오. 오류가 발생하는 경우, 수행하려는 작업과 오류를 재현하는 방법을 설명하십시오. 새로운 아이디어를 제안하는 경우, 프로젝트에 유용하다고 생각하는 이유를 설명하십시오 (귀하뿐 아니라!).

> 😇 _"제가 Y를 하려면 X가 안됩니다"_
>
> 😢 _"X 가 망가졌네요! 이거 고쳐주세요."_

**미리 과제하기.** 무언가 알지는 못하지만 시도한 것을 보여주십시오. 도움을 요청하기 전에 프로젝트의 README, 문서, 이슈 (공개 또는 비공개), 메일링 리스트를 확인하고 인터넷에서 답변을 검색하십시오. 사람들은 당신이 배우려고한다는 것을 증명할 때 감사해할 것입니다.

> 😇 _"X를 구현하는 방법을 잘 모르겠네요. 도움말 문서를 확인했고 모든 멘션도 찾지 못했습니다."_
>
> 😢 _"X는 어떻게 해요?"_

**요청을 짧고 직접적으로 유지하기.** 이메일을 보내는 것과 마찬가지로 모든 기여는 아무리 간단하거나 도움이된다 하더라도, 다른 사람의 검토가 필요합니다. 많은 프로젝트는 도움을 줄 수있는 사람들보다 많은 요청을 받고 있습니다. 간결하게 하십시오. 누군가가 당신을 도울 수있는 기회를 증가시킬 것입니다.

> 😇 _"API 튜토리얼을 작성하고 싶습니다."_
>
> 😢 _"저는 다른 날 고속도로를 몰고 가스로 달려 들었어요. 그리고 나서 저는 우리가 해야 할 일에 대해 이 놀라운 생각을 가지고 있었고요. 그렇지만 제가 설명하기 전에, 님께 보여주기 위해서..."_

**모든 커뮤니케이션을 공개하기.** 유혹스러운 일이긴하지만, 중요한 정보(예 : 보안 문제 또는 심각한 행동 위반)를 공유해야하는 경우가 아니면 메인테이너에게 개인적으로 연락하지 마십시오. 대화를 공개 할 때 더 많은 사람들이 귀하의 교류를 통해 배우고 이익을 얻을 수 있습니다. 토론은 그 자체로 기여할 수 있습니다.

> 😇 _(댓글로) "@-메인테이너 안녕하세요! 이 PR은 어떻게 진행되고 있나요?"_
>
> 😢 _(이메일로) "안녕하세요, 이메일을 보내서 죄송합니다만.제 PR을 검토할 기회가 있었는지 궁금합니다."_

**질문을 하는 것은 괜찮습니다(그러나 참을성 있으십시오!).** 누구나 프로젝트를 처음 접했을뿐 아니라 경험 많은 공헌자도 새로운 프로젝트를 볼 때 속도를 높여야 합니다. 마찬가지로, 오랜 기간의 메인테이너가 프로젝트의 모든 부분을 항상 잘 알고있는 것은 아닙니다. 그들에게 당신이 보여주기를 바라는 것과 같은 인내심을 보여주십시오.

> 😇 _"이 오류 찾아주셔서 고맙습니다. 저는 이 제안에 따를게요. 이렇게 출력되네요."_
>
> 😢 _"왜 내 문제를 해결할 수 없어요? 이 프로젝트는 님이 만든게 아닌가요?"_

**커뮤니티의 의사 결정을 존중하기.** 귀하의 아이디어는 커뮤니티의 우선 순위 또는 비전과 다를 수 있습니다. 그들은 의견을 제시하거나 아이디어를 추구하지 않기로 결정할 수 있습니다. 토론하고 타협을 찾아야하지만, 메인테이너는 당신보다 더 오래 결정을 내리지 않고 살아야합니다. 당신이 그들의 방향에 동의하지 않으면, 당신은 항상 자신의 포크에서 일하거나 자신의 프로젝트를 시작할 수 있습니다.

> 😇 _"제 use case를 지원할 수 없다는 점에 실망했지만, 사용자의 작은 부분에만 영향을 주었다고 설명하셨으니 이해됩니다. 들어주셔서 감사합니다."_
>
> 😢 _"왜 use case를 지원하지 않나요? 납득할 수 없네요!"_

**무엇보다도 고급스러움을 유지하기.** 오픈소스는 전 세계의 공동 작업자로 구성됩니다. 컨텍스트는 언어, 문화, 지역 및 시간대에 걸쳐 손실됩니다. 또한 서면 의사 소통을 통해 분위기 나 분위기를 전달하기가 더 어려워집니다. 이 대화에서 좋은 의도를 가정하십시오. 정중하게 생각을 뒤로 밀거나, 더 많은 맥락을 묻거나, 더 자세하게 설명하는 것은 좋습니다. 인터넷을 찾은 때보다 더 나은 곳을 떠나보십시오.

### 컨텍스트 수집

어떤 일을 하기 전에, 빠른 시일내에 당신의 아이디어가 다른 곳에서 논의되지 않았는지 확인하십시오. 프로젝트의 README, 이슈(공개 및 폐쇄), 메일링 리스트 및 스택 오버플로우를 생략하십시오. 모든 것을 처리하는 데 몇 시간을 허비하지 않아도 되지만, 핵심 용어에 대한 빠른 검색은 먼 길을 가집니다.

다른 곳에서 아이디어를 찾을 수 없다면, 움직일 준비가 된 것입니다. 프로젝트가 GitHub에 있다면, 이슈를 열거나 pull request을 열어 소통할 수 있습니다:

* **이슈**는 대화나 토론을 시작하는 것과 같습니다
* **Pull requests** 는 솔루션에서 일을 시작하기 위한 것입니다
* 명확한 질문이나 How-To 질문과 같은 **간단한 커뮤니케이션의 경우,** 프로젝트에 하나의 채팅 채널이있으면 스택 오버플로우, IRC, 슬랙 또는 다른 채팅 채널을 요청합니다

이슈를 열거나 pull request을 요청하기 전에, 프로젝트의 기여 문서(일반적으로 CONTRIBUTING 또는 README 파일)를 확인하여 구체적인 내용을 포함해야하는지 확인하십시오. 예를 들어, 템플릿을 따르거나 테스트를 사용하도록 요청할 수 있습니다.

실질적인 기여를 하고 싶다면, 이슈를 열고 작업하십시오. 수락되지 않을 수 있는 일을 하기 전에(깃허브에서는, ["Watch"를 클릭](https://help.github.com/articles/watching-repositories/)하여 토론을 알림 받을 수 있습니다), 잠시동안 프로젝트를 보고 커뮤니티 멤버를 알게되면 도움이됩니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gaearon?s=180" class="pquote-avatar" alt="avatar">
  You'll learn <em>a lot</em> from taking a single project you actively use, "watching" it on GitHub and reading every issue and PR.
<p markdown="1" class="pquote-credit">
— @gaearon [프로젝트 합류](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### 이슈 열기

일반적으로 다음과 같은 상황에서 이슈를 열어야합니다:

* 스스로 해결할 수 없는 오류를 보고
* 높은 수준의 주제 또는 아이디어 (예시. 커뮤니티, 비전, 정책) 토론
* 새로운 기능이나 다른 프로젝트 아이디어 제안

이슈에서 의사소통을 위한 팁:

* **해결하려는 이슈가 공개적으로 보이면,** 사람들이 당신이 그것에 대해 알 수 있도록 이슈에 대해 의견을 말하십시오. 그렇게하면 사람들은 중복으로 작업할 가능성이 줄어 듭니다.
* **이슈가 조금 전에 열렸다면,** 다른 곳에서 해결되었거나, 이미 해결되었기 때문에 작업을 시작하기 전에 확인을 요청하십시오.
* **이슈를 열었지만 나중에 대답을 알아 낸 경우,** 사람들에게 알리고 이슈를 해결할 수 있도록 이슈에 대한 의견을 말하십시오. 그 결과를 문서화하는 것조차도 프로젝트에 대한 기여입니다.

### pull request 열기

일반적으로 다음 상황에서 pull request를 열어야합니다:

* 사소한 수정 사항 제출 (예 : 오타, 깨진 링크 또는 분명한 오류)
* 이미 이슈를 열었거나 이미 논의한 내용을 기여로 시작하기

pull request은 완료된 작업을 나타내지 않아도됩니다. 일반적으로 초기에 pull request을 열면 다른 사람이 진행 상황을 보거나 피드백을 줄 수 있습니다. 제목 줄에 "WIP"(진행중인 작업)이라고 표시하십시오. 나중에 커밋을 더 추가 할 수 있습니다.

프로젝트가 GitHub에 있는 경우, pull request을 제출하는 방법은 다음과 같습니다:

* **[저장소를 포크하고](https://guides.github.com/activities/forking/)** 로컬에 클론합니다. 리모트로 추가하여 로컬을 원래의 "업스트림"저장소에 연결하십시오. "업스트림"의 변경 사항을 자주 가져 와서 최신 상태로 유지하면 pull request을 제출할 때, 병합 충돌이 덜 발생할 수 있습니다. ([이 곳](https://help.github.com/articles/syncing-a-fork/)에서 더 자세한 지침보기.)
* 수정을 위한 **[브랜치 생성하기](https://guides.github.com/introduction/flow/)**.
* **모든 관련있는 이슈** 혹은 PR에서 지원중인 문서 참조하기 (ex. "#37 닫음.")
* **전후의 스크린 샷 포함합니다** 변경 사항에 HTML/CSS의 차이가 포함되어있는 경우, pull request의 본문에 이미지를 끌어다 놓습니다.
* **변경점을 테스트합니다!** 기존 테스트가 있는 경우 변경 사항을 실행하고 필요한 경우 새 테스트를 작성하십시오. 테스트의 존재 여부와 상관없이 변경 사항이 기존 프로젝트를 손상시키지 않는지 확인하십시오.
* 당신의 능력을 최대한 발휘하여 **프로젝트 스타일에 기여하십시오.** 이는 들여 쓰기, 세미콜론 또는 주석을 자신의 저장소에서와 다르게 사용하는 것을 의미 할 수 있지만, 메인테이너가 병합하기 쉽고, 다른 사람들이 나중에 이해하고 유지할 수 있게 해줍니다.

만약 이것이 첫 pull request 라면, @kentcdodds가 무료 walkthrough 리소스로 생성한 [Make a Pull Request](http://makeapullrequest.com/)를 확인하십시오.

## What happens after you submit a contribution

훌륭합니다! 오픈소스 기여자가 되신 것을 축하드립니다. 우리는 그것이 많은 사람들 중 첫번째가 되기를 바랍니다.

기여를 제출하면 다음 중 하나가 발생합니다.

### 😭 당신은 응답을 얻지 못합니다.

기여를 하기 전에, [활동의 징조가 있는지 프로젝트를 확인](#a-checklist-before-you-contribute)했기를 바랍니다. 그러나 활발한 프로젝트에서도 기여가 응답을 받지 못할 수도 있습니다.

1주일 이내에 응답을 받지 못했다면, 같은 쓰레드에서 정중하게 응답하여 누군가에게 검토를 요청하는 것이 좋습니다. 기여자를 검토할 수있는 적절한 사람의 이름을 아는 경우, 해당 스레드에서 이름을 @로 표기할 수 있습니다.

**절대** 그 사람에게 개인적으로 연락하지 마세요; 공개적인 의사소통은 오픈소스 프로젝트에서 필수적이라는 것을 기억하십시오.

정중한 충돌을 하고도 아직 아무도 응답하지 않으면, 아무도 응답하지 않을 가능성이 있습니다. 그것은 큰 감정이 아니지만, 그것이 당신을 낙담하게 하지마십시오. 모두에게 일어난 일입니다! 귀하가 통제 할 수 없는 개인적 상황을 포함하여 응답을 받지 못한 이유는 여러 가지가 있을 수 있습니다. 다른 프로젝트나 기여 방법을 찾으십시오. 다른 커뮤니티 구성원들이 참여하고 반응하기 전에 기여에 많은 시간을 투자하지 않는 것이 좋은 이유입니다.

### 🚧 누군가 기여를 변경 요청해야합니다.

아이디어의 범위에 대한 피드백이든 코드의 변경 사항이든, 기여 내용을 변경하라는 메시지가 표시되는 것이 일반적입니다.

누군가 변경 사항을 요청하면, 반응적입니다. 그들은 당신의 기여를 검토할 시간을 가졌습니다. PR을 열고 멀리두는 것은 나쁜 형태입니다. 만약 변경 방법을 모르는 경우, 문제를 조사한 다음 필요한 경우 도움을 요청하십시오.

만약 더 이상 문제를 해결할 시간이 없다면 (예를 들어, 대화가 몇 달 동안 계속되고 상황이 변경된 경우), 메인테이너에게 알려서 응답을 기대하지 않도록 하십시오. 다른 사람이 기꺼이 받아 들일 수 있습니다.

### 👎 귀하의 기여가 받아지지 않았습니다.

귀하의 기여는 결국 받아지거나 수락되지 않을 수도 있습니다. 다행히도 이미 너무 많은 작업을 하지 않았으면 합니다. 왜 그것이 받아들여지지 않았는지 확신할 수 없다면, 메인테이너 담당자에게 피드백과 설명을 요청하는 것이 합리적입니다. 그러나 궁극적으로 이것이 자신의 결정임을 존중해야합니다. 논쟁하거나 적대적인 태도를 취하지 마십시오. 동의하지 않으면, 항상 자신의 버전을 포크하고 작업할 수 있습니다!

### 🎉 귀하의 기여가 받아졌습니다.

만세! 성공적으로 오픈소스 기여를 만들었습니다!

## You did it!

처음으로 오픈소스에 기여한 사람이든, 새로운 방식으로 기여할 사람을 찾고 있든, 우리는 이 행동에 영감을 얻으시기 바랍니다. 기여가 승인되지 않더라도, 관리자가 당신을 돕기 위해 노력할 때 감사하다는 말을 잊지 마십시오. 오픈소스는 당신과 같은 사람들이 만듭니다: one issue, pull request, comment, or high-five at a time.
