---
lang: id
title: Bagaimana Berkontribusi pada Open Source
description: Ingin berkontribusi pada open source? Sebuah panduan untuk melakukan kontribusi open source, untuk pemula dan veteran.
class: contribute
order: 1
image: /assets/images/cards/contribute.png
related:
  - beginners
  - building
---

## Mengapa berkontribusi pada open source?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/errietta?s=180" class="pquote-avatar" alt="avatar">
  Bekerja pada \[freenode\] membantu saya mendapatkan banyak ketrampilan yang saya gunakan pada pembelajaran di universitas dan pekerjaan saya nantinya. Saya pikir bekerja pada proyek open source membantu saya sebanyak saya membantu proyek itu sendiri.!
  <p markdown="1" class="pquote-credit">
— @errietta, ["Why I love contributing to open source software"](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

Berkontribusi pada open source bisa jadi merupakan cara yang bermanfaat untuk belajar, mengajar, dan membangun pengalaman pada segala ketrampilan yang dapat Anda bayangkan.

Mengapa orang-orang berkontribusi pada open source? Banyak alasannya!

### Meningkatkan ketrampilan yang sudah ada

Baik pemrograman, perancangan antar muka, desain grafis, menulis, maupun mengelola, jika Anda mencari tempat berlatih, terdapat tugas bagi Anda pada proyek open source.

### Bertemu orang yang tertarik pada hal yang sama

Proyek open source dengan komunitas yang hangat membuat orang-orang kembali selama bertahun-tahun. Banyak orang membentuk pertemanan jangka panjang melalui partisipasi mereka pada open source, baik pertemuan pada konferensi atau chat tengah malam tentang burrito.

### Mencari mentor dan mengajarkan ke pihak lain

Bekerja dengan banyak orang pada proyek berarti Anda harus menjelaskan bagaimana Anda melakukan segala sesuatu, sekaligus meminta orang lain untuk bantuan. Kegiatan belajar dan mengajar bisa menjadi aktivitas yang menyenangkan bagi semua orang yang terlibat.

### Membangun koleksi publik yang membantu Anda mengembangkan reputasi (dan karir)

Secara definisi, semua pekerjaan open source bersifat publik, artinya Anda mendapatkan contoh gratis untuk dibawa kemana saja sebagai demonstrasi tentang apa saja yang dapat Anda lakukan.

### Belajar ketrampilan tentang orang

Open source menawarkan kesempatan untuk belajar ketrampilan kepemimpinan dan manajemen, seperti menyelesaikan konflik, mengelola sekelompok orang, dan memprioritaskan pekerjaan.

### Memberdayakan untuk membuat perubahan, meskipun kecil

Anda tidak perlu menjadi kontributor jangka panjang untuk menikmati partisipasi pada open source. Apakah Anda melihat sebuah kesalahan ketik pada website, dan berharap seseorang akan memperbaikinya? Pada proyek open source, Anda bisa melakukannya. Open source membantu orang merasa memiliki hak atas hidup mereka dan bagaimana mereka merasakan bahwa dunia, dan segala isinya sangatlah memuaskan.

## Apa artinya berkontribusi

Jika Anda merupakan kontributor open source yang baru, proses ini bisa jadi menakutkan. Bagaimana Anda menemukan proyek yang sesuai? Bagaimana jika Anda tidak tahu bagaimana membuat kode program? Bagaimana jika terjadi kesalahan?

Tidak perlu khawatir! Terdapat banyak cara untuk bisa ikut terlibat pada proyek open source, dan beberapa tips akan membantu Anda memaksimalkan pengalaman Anda.

### Anda tidak perlu memberikan kontribusi dalam bentuk kode

Kesalahpahaman yang sering terjadi tentang berkontribusi pada open source adalah Anda harus memberikan kontribusi dalam bentuk kode. Kenyataannya, seringkali banyak bagian lain dari proyek yang [seringkali terabaikan atau diabaikan](https://github.com/blog/2195-the-shape-of-open-source). Anda bisa memberikan bantuan _besar_ bagi proyek dengan menawarkan diri untuk jenis kontribusi semacam ini.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/orta?s=180" class="pquote-avatar" alt="avatar">
  Saya menjadi terkenal karena pekerjaan saya pada CocoaPods, tetapi banyak orang tidak tahu bahwa saya tidak melakukan pekerjaan yang berarti pada perangkat CocoaPods itu sendiri. Waktu saya pada proyek lebih banyak dihabiskan untuk melakukan kegiatan seperti dokumentasi dan pencitraan.
  <p markdown="1" class="pquote-credit">
— @orta, ["Moving to OSS by default"](https://realm.io/news/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

Meskipun Anda suka untuk menulis kode program, kontribusi jenis lain merupakan cara yang baik untuk bisa berpartisipasi pada proyek dan bertemu dengan anggota komunitas lainnya. Membangun hubungan tersebut akan memberikan Anda kesempatan untuk bekerja pada bagian lain dari proyek.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/brettcannon?s=180" class="pquote-avatar" alt="avatar">
  Saya pertama kali menghubungi tim pengembang Python (python-dev) ketika saya mengirimkan pesan email kepada mailing list pada 17 Juni 2002 tentang perbaikan dari saya. Saya dengan cepat menemukan kesalahan, dan memutuskan untuk mulai memilih email dari grup. Mereka memberikan saya alasan yang baik untuk bertanya tentang klarifikasi sebuah topik, tetapi yang lebih penting lagi saya mampu mendeteksi apabila seseorang menunjukkan sesuatu yang perlu diperbaiki.
  <p markdown="1" class="pquote-credit">
— @brettcannon, ["Maintainer Stories"](https://github.com/open-source/stories/brettcannon)
  </p>
</aside>

### Apakah Anda suka merencanakan kegiatan?

* Mengelola workshop atau acara pertemuan tentang proyek, [seperti yang dilakukan @fzamperin untuk NodeSchool](https://github.com/nodeschool/organizers/issues/406)
* Mengelola konferensi sebuah proyek (jika ada)
* Membantu anggota komunitas menemukan konferensi yang sesuai dan mengirimkan proposal untuk berbicara

### Apakah Anda suka mendesain?

* Restrukturisasi layout untuk meningkatkan usabilitas proyek
* Melakukan penelitian pengguna untuk menata ulang dan meningkatkan navigasi atau menu proyek, [seperti yang disarankan Drupal](https://www.drupal.org/community-initiatives/drupal-core/usability)
* Membuat panduan untuk membantu proyek memiliki desain visual yang konsisten
* Membuat hasil seni untuk pakaian atau logo baru, [seperti kontributor hapi.js](https://github.com/hapijs/contrib/issues/68)

### Apakah Anda suka menulis?

* Menulis dan meningkatkan dokumentasi proyek
* Buatlah sebuah folder contoh yang menunjukkan bagaimana proyek dapat digunakan
* Memulai laporan berkala untuk proyek atau buat hal-hal penting dari mailing list
* Menulis tutorial untuk proyek, [seperti kontributor pypa](https://github.com/pypa/python-packaging-user-guide/issues/194)
* Menulis terjemahan untuk dokumentasi proyek

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kittens?s=180" class="pquote-avatar" alt="avatar">
  Serius, \[dokumentasi\] sangatlah penting. Dokumentasi sejauh ini sudah sangat bagus dan merupakan fitur utama dari Babel.  Terdapat beberapa bagian yang bisa dikembangkan dan bahkan penambahan sebuah paragraf disini dan disana akan sangat dihargai.
  <p markdown="1" class="pquote-credit">
— @kittens, ["Call for contributors"](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### Apakah Anda suka mengelola?

* Menghubungkan masalah-masalah yang duplikat dan memberikan label pada masalah untuk menjaga pengelolaan
* Menyarankan menghapus laporan masalah yang lama, [seperti yang dilakukan @nzakas untuk eslint](https://github.com/eslint/eslint/issues/6765)
* Menanyakan pertanyaan klarifikasi pada laporan masalah yang baru saja dibuat untuk diskusi kedepannya

### Apakah Anda suka membua kode program?

* Mencari laporan masalah yang ingin diselesaikan, [seperti yang dilakukan @dianjin untuk Leaflet](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560)
* Bertanya jika Anda hendak membantu menuliskan fitur baru
* Melakukan otomatisasi setup proyek
* Meningkatkan perlengkapan dan pengujian

### Apakah Anda suka membantu orang lain?

* Menjawab pertanyaan tentang proyek, pada (misalnya) Stack Overflow ([seperti contoh Postgres ini](https://stackoverflow.com/questions/18664074/getting-error-peer-authentication-failed-for-user-postgres-when-trying-to-ge)) atau reddit
* Menjawab pertanyaan pada permasalahaan terbuka
* Membantu memoderasi halaman diskusi atau chanel diskusi

### Apakah Anda suka membantu orang lain dalam membuat program?

* Me-review kode dari pengajuan orang lain
* Menulis tutorial bagaimana proyek bisa digunakan
* Menawarkan diri untuk menjadi mentor bagi kontributor lainnya, [seperti yang dilakukan @ereichert untuk @bronzdoc pada Rust](https://github.com/rust-lang/book/issues/123#issuecomment-238049666)

### Anda tidak harus bekerja pada proyek perangkat lunak!

Meskipun "open source" seringkali merujuk pada perangkat lunak, Anda bisa berkolaborasi pada segala sesuatu. Terdapat buku, resep makanan, daftar, dan kelas yang dapat dikembangkan sebagai proyek open source.

Sebagai contoh:

* @sindresorhus menghasilkan [daftar "awesome"](https://github.com/sindresorhus/awesome)
* @h5bp mengelola [daftar pertanyaan potensial untuk wawancara](https://github.com/h5bp/Front-end-Developer-Interview-Questions) bagi kandidat developer front-end
* @stuartlynn dan @nicole-a-tesla membuat [kumpulan fakta lucu tentang puffin](https://github.com/stuartlynn/puffin_facts)

Meskipun Anda seorang pengembang perangkat lunak, bekerja pada proyek dokumentasi bisa membantu Anda untuk memulai pada open source. Seringkali bekerja pada proyek yang tidak melibatkan kode tidak terlalu menakutkan dan proses kolaborasi ini akan membangun rasa percaya diri dan pengalaman Anda.

## Berorientasi pada proyek baru

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shaunagm?s=180" class="pquote-avatar" alt="avatar">
  Jika Anda mengunjungi issue tracker dan tampaknya membingungkan, hal itu terjadi bukan hanya kepada Anda saja. Perangkat ini membutuhkan banyak pemahaman implisit, tetapi orang lain mampu membantu Anda dalam mengeksplorasi dan Anda bisa bertanya kepada mereka.
  <p markdown="1" class="pquote-credit">
— @shaunagm, ["How to Contribute to Open Source"](https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/)
  </p>
</aside>

Untuk aktivitas yang lebih dari sekedar kesalahan penulisan, berkontribusi pada open source seperti berjalan pada sebuah kelompok orang asing pada sebuah pesta. Jika Anda berbicara tentang hewan llamas, sedangkan mereka sedang membicarakan tentang ikan mas, mungkin mereka akan memandang Anda dengan aneh.

Sebelum memberikan masukan, pelajari bagaimana membaca situasi ruangan. Dengan melakukan hal ini akan meningkatkan peluang ide Anda akan dilihat dan didengarkan.

### Anatomi proyek open source

Setiap komunitas open source memiliki perbedaan.

Menghabiskan waktu bertahun-tahun pada satu proyek open source berarti Anda terbiasa pada satu proyek open source. Dengan berpindah pada proyek yang berbeda maka Anda akan mendapati bahwa kosa kata, norma, dan gaya komunikasi yang digunakan sangatlah berbeda.

Meski demikian, banyak proyek open source mengikuti struktur organisasi yang sama. Memahami perbedaan peran komunitas yang berbeda-beda dan proses secara luas akan membantu Anda untuk beradaptasi dengan setiap proyek baru.

Proyek open source pada umumnya memiliki beberapa jenis orang sebagai berikut:

* **Pencipta (Author):** Orang atau organisasi yang menciptakan proyek
* **Pemilik (Owner):** Orang atau organisasi yang memiliki kepemilikan administratif terhadap organisasi atau repositori (tidak selalu sama dengan pencipta awal)
* **Pengelola (Maintainers):** Kontributor yang bertanggung jawab untuk menggerakan visi dan mengelola aspek organisasi dari proyek. (Mereka juga bisa merupakan pencipta atau pemilik dari proyek.)
* **Kontributor (Contributors):** Semua orang yang telah mengkontribusikan sesuatu kepada proyek.
* **Anggota Komunitas (Community Members):** Orang-orang yang menggunakan proyek. Mereka mungkin aktif pada diskusi atau mengungkapkan opini mereka pada arah sebuah proyek.

Proyek yang lebih besar mungkin memiliki sub komite atau kelompok kerja yang berfokus pada tugas yang berbeda-beda, seperti peralatan, pengujian, moderasi komunitas, dan pengelola kegiatan. Lihat pada website proyek untuk halaman "anggota", atau pada repositori untuk dokumentasi organisasi, untuk menemukan informasi ini.

Sebuah proyek juga memiliki dokumentasi. Dokumentasi ini biasanya ditempatkan pada posisi teratas dari sebuah repositori.

* **LICENSE:** Secara definisi, setiap proyek open source harus memiliki sebuah [lisensi open source](https://choosealicense.com). Jika sebuah proyek tidak memiliki lisensi, maka proyek tersebut bukan bersifat open source.
* **README:** Dokumen README adalah manual instruksi yang menyambut anggota komunitas baru pada sebuah proyek. Dokumen ini juga menjelaskan kenapa proyek ini berguna dan bagaimana untuk memulainya.
* **CONTRIBUTING:** Jika README membantu orang-orang _menggunakan_ proyek, dokumentasi kontribusi membantu orang-orang untuk _berkontribusi_ pada proyek. Dokumen ini menjelaskan jenis kontribusi seperti apa yang diperlukan dan bagaimana cara kerja dari proses kontribusinya. Meskipun tidak setiap proyek memiliki dokumen CONTRIBUTING, keberadaan dokumen ini menandakan bahwa proyek ini menerima kontribusi.
* **CODE_OF_CONDUCT:** Dokumen kode etik (_code of conduct_) menentukan aturan dasar bagi perilaku partisipan dan membantu memfasilitasi lingkungan yang kondusif dan bersahabat. Meskipun tidak setiap proyek memiliki dokumen CODE_OF_CONDUCT, keberadaan dokumen ini menandakan bahwa proyek ini menerima kontribusi.
* **Dokumentasi lainnya:** Mungkin terdapat dokumentasi tambahan, seperti tutorial, panduan, atau kebijakan lainnya, terutama pada proyek yang lebih besar.

Akhirnya, proyek open source menggunakan peralatan berikut untuk mengelola diskusi. Membaca dari arsip akan memberikan gambaran tentang bagaimana komunitas berpikir dan bekerja.

* **Issue tracker:** Dimana orang-orang mendiskusikan laporan masalah yang berkaitan dengan proyek.
* **Pull requests:** Dimana orang-orang mendiskusikan dan me-review perubahan yang sedang dikerjakan.
* **Forum diskusi atau mailing list:** Beberapa proyek mungkin menggunakan media ini untuk topik diskusi (misalnya. _"Bagaimana saya ..."_ atau _"Apakah pendapat Anda tentang ..."_ daripada laporan kesalahan atau pengajuan fitur baru). Beberapa proyek menggunakan _issue tracker_ untuk semua diskusi.
* **Media chat:** Beberapa proyek menggunakan media chat (seperti Slack atau IRC) untuk diskusi sehari-hari, kolaborasi, dan pertukaran yang bersifat cepat.

## Menemukan sebuah proyek untuk melakukan kontribusi

Setelah Anda paham bagaimana proyek open source bekerja, sekarang saatnya untuk menemukan sebuah proyek untuk berkontribusi!

Jika Anda belum pernah berkontribusi ke open source sebelumnya, ambil saran dari presin Amerika Serikat John F. Kennedy, yang mengatakan demikian , _"(Jangan tanyakan apa yang bisa dilakukan negara kepada dirimu - tanyakan apa yang bisa engkau lakukan untuk negaramu) - Ask not what your country can do for you - ask what you can do for your country."_

Berkontribusi ke open source bisa terjadi pada semua tingkatan, pada semua bagian proyek. Anda tidak perlu berpikir berlebihan tentang apa kontribusi pertama Anda atau bagaimana bentuknya.

Mulailah dengan proyek yang sudah Anda gunakan, atau ingin Anda gunakan. Proyek dimana Anda akan aktif berkontribusi didalamnya adalah proyek dimana Anda akan selalu datang kembali kepadanya.

Didalam proyek-proyek tersebut, setiap kali Anda mendapati tentang segala sesuatu yang bisa ditingkatkan atau berbeda, lakukan berdasarkan insting Anda.

Open source bukanlah klub ekslusif; Open source dibuat oleh orang-orang seperti Anda. "Open source" hanyalah istilah keren untuk menadai bahwa masalah yang ada di dunia sebagai sesuatu yang bisa diperbaiki.

Anda bisa melihat dokumen README dan menemukan tautan yang tidak valid atau kesalahan pengetikkan. Atau Anda sebagai pengguna baru dan melihat bahwa ada yang salah, atau sebuah laporan dimana Anda rasa penting untuk didokumentasikan. Daripada mengabaikannya, atau meminta orang lain untuk memperbaikinya, cari tahu apakah Anda bisa membantu dengan ikut serta didalamnya. Itulah makna sesungguhnya dari open source!

> [28% dari kontribusi umum](https://www.igor.pro.br/publica/papers/saner2016.pdf) pada open source adalah berupa dokumentasi, seperti kesalahan pengetikkan, pemformatan ulang, atau menuliskan terjemahan.

Anda juga bisa menggunakan salah satu dari beberapa sumber daya berikut untuk mencari dan berkontribusi pada proyek baru:

* [GitHub Explore](https://github.com/explore/)
* [Open Source Friday](https://opensourcefriday.com)
* [First Timers Only](https://www.firsttimersonly.com/)
* [CodeTriage](https://www.codetriage.com/)
* [24 Pull Requests](https://24pullrequests.com/)
* [Up For Grabs](https://up-for-grabs.net/)
* [Contributor-ninja](https://contributor.ninja)

### Daftar sebelum Anda berkontribusi

Ketika Anda telah menemukan sebuah proyek dimana Anda hendak melakukan kontribusi, lakukan pencarian secara cepat untuk memastikan proyek tersebut sesuai untuk menerima kontribusi. Jika tidak, usaha keras Anda mungkin tidak akan mendapatkan respon.

Berikut adalah daftar yang bisa digunakan untuk mengevaluasi apakah sebuah proyek sesuai untuk kontributor baru.

**Memenuhi definisi open source**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
  Apakah memiliki lisensi? Biasanya terdapat dokumen bernama LICENSE pada bagian atas dari repositori.
  </label>
</div>

**Proyek secara aktif menerima kontribusi**

Lihat pada aktivitas commit pada branch master. Pada GitHub, Anda bisa melihat informasi ini pada homepage repositori.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
  Kapan commit terakhir ?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
  Berapa banyak kontributor yang dimiliki proyek?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
  Seberapa sering orang melakukan commit? (Pada GitHub, Anda bisa mendapatkan informasi ini dengan memilih menu "Commits" pada bagian atas.)
  </label>
</div>

Berikutnya, lihat pada laporan masalah yang dihadapi pada proyek.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    Berapa banyak laporan masalah yang masih belum diselesaikan?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    Apakah pengelola merespon dengan cepat pada sebuah laporan masalah baru?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    Apakah terdapat diskusi aktif pada setiap laporan masalah yang ada?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    Apakah laporan masalah tersebut muncul baru-baru ini?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    Apakah laporan masalah yang ada sudah diselesaikan? (Pada GitHub, klik tab "closed" pada halaman Issues untuk melihat laporan masalah yang sudah terselesaikan.)
  </label>
</div>

Sekarang lakukan hal yang sama untuk pull request pada proyek.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    Berapa banyak pull request pada proyek?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">
    Apakah pengelola merespon dengan cepat terhadap pull request baru?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    Apakah terdapat diskusi aktif pada pull request?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
   Apakah pull request tersebut muncul baru-baru ini?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">
    Kapan pull request diterima? (Pada GitHub, klik tab "closed" pada halaman Pull Requests untuk melihat PR yang sudah diselesaikan.)
  </label>
</div>

**Proyek menyambut**

Sebuah proyek yang bersahabat dan menyambut menandai bahwa mereka sangat menerima kontributor baru.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">
    Apakah pengelola menanggapi pertanyaan pada laporan masalah dengan sangat membantu?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">
    Apakah orang-orang bersahabat pada laporan masalah, forum diskusi, dan chat (misalnya. IRC atau Slack)?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">
    Apakah dilakukan review terhadap pull request?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">
    Apakah pengelola berterima kasih kepada orang lain atas kontribusinya?
  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Setiap kali Anda melihat diskusi yang panjang, amati respon dari pengembang inti di bagian akhir dari diskusi. Apakah mereka meringkasnya secara konstruktif dan mengambil langkah-langkah untuk mendapatkan kesimpulan tanpa mengabaikan sopan santun? Jika Anda melihat banyak perdebatan yang tidak konstruktif (_flame war_), biasanya merupakan sebuah tanda bahwa energi dihabiskan untuk berargumentasi dibandingkan untuk pengembangan proyek.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](https://producingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## Bagaimana mengajukan kontribusi

Anda telah menemukan sebuah proyek yang Anda sukai, dan Anda siap untuk membuat sebuah kontribusi. Akhirnya! Berikut adalah langkah-langkah untuk menjadikan kontribusi Anda di jalan yang benar.

### Berkomunikasi secara efektif

Apakah Anda merupakan kontributor atau mencoba untuk bergabung dengan sebuah komunitas, bekerja dengan orang lain merupakan salah satu keahlian paling penting yang perlu diasah dalam dunia open source.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shubheksha?s=180" class="pquote-avatar" alt="avatar">
  \[Sebagai kontributor baru,\] saya menyadari bahwa saya perlu bertanya jika ingin menutup sebuah laporan masalah. Saya mengamati kode program. Setelah saya mengetahui situasinya, saya bertanya untuk pengarahan lebih lanjut. Dan akhirnya! Saya berhasil menutup sebuah laporan masalah setelah mendapatkan semua informasi relevan yang saya butuhkan.
  <p markdown="1" class="pquote-credit">
— @shubheksha, [A Beginner's Very Bumpy Journey Through The World of Open Source](https://medium.freecodecamp.com/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39#.pcswr2e78)
  </p>
</aside>

Sebelum Anda membuka sebuah laporan masalah atau pull request, atau bertanya pada media chat, perhatikan beberapa poin berikut untuk membantu ide Anda secara efektif.

**Berikan konteks.** Bantu orang lain untuk memahami kondisinya. Jika Anda menjumpai sebuah kesalahan, jelaskan apa yang hendak Anda lakukan dan bagaimana mengulangi kesalahan tersebut. Jika Anda menyarankan sebuah ide baru, jelaskan kenapa Anda pikir itu merupakan ide yang baik untuk proyek (tidak hanya untuk Anda!).

> 😇 _"X tidak berfungsi ketika saya melakukan Y"_
>
> 😢 _"X rusak! Tolong perbaiki."_

**Lakukan pekerjaan rumah Anda sebelumnya.** Tidak masalah untuk tidak mengetahui beberapa hal, tetapi tunjukan bahwa Anda telah berusaha. Sebelum bertanya untuk meminta bantuan, pastikan untuk melihat dokumen README, dokumentasi, laporan masalah (terbuka atau tertutup), mailing list, dan cari Internet untuk sebuah jawaban. Orang-orang akan menghargai ketika Anda menunjukkan bahwa Anda berusaha untuk belajar.

> 😇 _"Saya tidak yakin bagaimana mengimplementasikan X. Saya telah melihat dokumen bantuan dan tidak menemukan apapun."_
>
> 😢 _"Bagaimana saya melakukan X?"_

**Buatlah permintaan singkat dan langsung.** Seperti halnya mengirimkan sebuah email, setiap kontribusi, sekecil apapun atau sepenting apapun, akan membutuhkan orang lain untuk me-reviewnya. Banyak proyek memiliki lebih banyak permintaan dibandingkan jumlah orang yang ada untuk membantu. Pastikan permintaan Anda jelas. Anda akan mendapatkan peluang lebih tinggi dimana seseorang akan ada untuk membantu Anda.

> 😇 _"Saya ingin menulis tutorial API."_
>
> 😢 _"Saya sedang mengemudi di jalan tol di suatu hari dan berhenti untuk mengisi bahan bakar, lalu saya mendapatkan ide cemerlang yang seharusnya kita lakukan, tetapi sebelum saya menjelaskan hal itu, ijinkan saya untuk menunjukkan kepada Anda..."_

**Buat semua komunikasi terbuka secara publik.** Meskipun hal ini sangat menarik, hindari menghubungi pengelola secara pribadi kecuali Anda perlu membagikan informasi yang bersifat sensitif (misalnya masalah keamanan atau pelanggaran berat). Ketika Anda membuat semua komunikasi terbuka secara publik, banyak orang bisa belajar dan mendapatkan manfaat dari pertukaran informasi Anda. Diskusi itu sendiri bisa menjadi sebuah kontribusi.

> 😇 _(sebagai komentar) "@-maintainer Hallo! Bagaimana saya harus melanjutkan untuk PR ini?"_
>
> 😢 _(sebagai email) "Hallo, maaf menganggu Anda melalui email, tetapi saya ingin tahu apakah Anda ingin melakukan review terhadap PR saya"_

**Tidak masalah untuk bertanya (tetapi harap sabar!).** Setiap orang pernah menjadi orang baru pada sebuah proyek, dan bahkan kontributor yang berpengalaman sekalipun perlu memahami kondisi ketika mereka melihat pada sebuah proyek baru. Dengan kondisi yang sama, bahkan pengelola yang sudah lama sekalipun tidak selalu memahami dengan setiap bagian dari proyek. Berikan kesabaran yang sama seperti Anda mengharapkan mereka sabar dengan Anda.

> 😇 _"Terima kasih karena telah melihat kesalahan ini. Saya mengikuti petunjuk Anda. Berikut hasil keluarannya."_
>
> 😢 _"Kenapa Anda tidak bisa memperbaiki masalah saya? Bukankah ini proyek Anda?"_

**Hargai keputusan komunitas.** Ide Anda mungkin berbeda dengan prioritas atau visi komunitas. Mereka mungkin menawarkan masukan atau memutuskan untuk tidak melanjutkan ide Anda. Meskipun sebaiknya Anda mendiskusikan dan mencoba mencari  titik temu, pengelola harus menanggung tanggung jawab atas keputusan Anda jauh lebih lama dibandingkan Anda. Jika Anda tidak setuju dengan mereka, Anda tetap bisa bekerja pada _fork_ Anda sendiri atau memulai proyek Anda sendiri.

> 😇 _"Saya kecewa Anda tidak bisa mendukung kasus saya, tetapi seperti yang telah Anda jelaskan, masalah itu hanya akan berdampak pada sebagian kecil pengguna, dan saya bisa memahami. Terima kasih telah mendengarkan."_
>
> 😢 _"Kenapa Anda tidak mendukung kasus saya? Hal ini tidak bisa saya terima!"_

**Diatas itu semua, pertahankan kualitas.** Open source terbentuk dari kolaborator dari seluruh penjuru dunia. Konteks menjadi hilang dalam berbagai bahasa, budaya, geografis, dan zona waktu. Lebih dari itu, komunikasi tertulis menjadikannya lebih susah untuk menyalurkan nada atau suasana hati. Selalu asumsikan niat baik dalam percapakan. Merupakan hal yang biasa untuk menolak sebuah ide secara halus, bertanya untuk konteks yang lebih lanjut, atau mengklarifikasi posisi Anda. Harap jadikan Internet tempat yang lebih baik dibandingkan ketika Anda menemukannya.

### Mengumpulkan konteks

Sebelum melakukan apapun, pastikan bahwa ide Anda belum pernah didiskusikan sebelumnya. Baca dokumen README, laporan masalah (terbuka dan tertutup), mailing list, dan Stack Overflow. Anda tidak perlu menghabiskan waktu berjam-jam untuk mencari semua informasi, tetapi cukup lakukan pencarian secara cepat untuk beberapa istilah kunci.

Jika Anda tidak bisa menemukan ide Anda dimanapun, Anda siap untuk bergerak. Jika proyek tersebut berada pada GitHub, Anda bisa berkomunikasi dengan membuka sebuah laporan masalah atau melakukan pull request:

* **Laporan masalah (Issues)** adalah seperti memulai percakapan atau diskusi
* **Pull requests** adalah untuk memulai pekerjaan pada sebuah solusi
* **Untuk komunikasi yang ringan,** seperti mengklarifikasi pertanyaan bagaimana, cobalah bertanya melalui Stack Overflow, IRC, Slack, atau media chat lainnya, jika ada.

Sebelum Anda membuka sebuah laporan masalah atau melakukan pull request, periksa dokumen kontribusi proyek (biasanya pada dokumen bernama CONTRIBUTING, atau pada README), untuk melihat apakah Anda perlu mencantumkan informasi yang spesifik. Sebagai contoh, mereka mungkin meminta Anda untuk mengikuti sebuah template, atau mengharuskan Anda untuk menggunakan perangkat pengujian.

Jika Anda hendak melakukan kontribusi yang cukup substansial, buatlah sebuah laporan masalah sebelum memulai bekerja. Sangatlah bermanfaat untuk mengamati proyek dalam kurun waktu tertentu (pada Github, [Anda bisa memilih menu "Watch"](https://help.github.com/articles/watching-repositories/) untuk mendapatkan notifikasi dari semua percakapan), dan mengenal anggota komunitas, sebelum memulai pekerjaan yang belum tentu akan diterima.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gaearon?s=180" class="pquote-avatar" alt="avatar">
  Anda akan belajar <em>banyak</em> dari proyek yang Anda gunakan secara aktif, "melihatnya" pada GitHub dan membaca semua laporan masalah dan PR.
<p markdown="1" class="pquote-credit">
— @gaearon [on joining projects](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### Membuka laporan masalah

Anda biasanya akan membuka sebuah laporan masalah pada situasi berikut:

* Melaporkan kesalahan yang tidak bisa Anda selesaikan sendiri
* Mendiskusikan topik tingkat tinggi atau ide (misalnya komunitas, visi, kebijakan)
* Mengajukan fitur baru atau ide proyek lainnya

Tips untuk berkomunikasi pada laporan masalah:

* **Jika Anda melihat laporan masalah yang masih terbuka yang hendak Anda selesaikan,** berikan komentar Anda pada laporan masalah tersebut agar orang lain tahu. Dengan cara begitu, kecil kemungkinan orang lain akan mengerjakan hal yang sama.
* **Jika sebuah laporan masalah baru saja dibuka beberapa saat yang lalu,** ada kemungkinan bahwa laporan tersebut sedang dikerjakan oleh orang lain, atau sudah diperbaiki, sehingga berikan komentar untuk bertanya untuk konfirmasi sebelum memulai pekerjaan.
* **Jika Anda membuka sebuah laporan masalah, tetapi menemukan jawabannya sendiri,** berikan komentar untuk menginformasikan kepada orang lain, lalu tutup laporan masalah tersebut. Bahkan mendokumentasikan hasilnya juga merupakan sebuah kontribusi pada proyek.

### Membuka pull request

Anda biasanya akan membuka sebuah pull request pada situasi berikut:

* Mengajukan perbaikan sederhana (misalnya kesalahan ketik, link tidak valid, atau kesalahan yang jelas terlihat)
* Mulai bekerja pada sebuah kontribusi yang sudah ditanyakan sebelumnya, atau yang sudah Anda diskusikan pada sebuah laporan masalah.

Sebuah pull request tidak harus mencerminkan sebuah pekerjaan yang sudah selesai. Biasakan untuk membuka pull request di awal, sehingga orang lain bisa melihat atau memberikan masukan untuk perkembangan Anda. Tandai dengan "WIP" (_Work in Progress_) pada baris _subject_. Anda tetap bisa menambahkan commit lainnya.

Jika proyek berada pada GitHub, berikut cara untuk membuka pull request:

* **[Fork repositori](https://guides.github.com/activities/forking/)** dan clone secara lokal. Hubungkan lokal Anda dengan repositori asli "_upstream_" dengan menambahkannya sebagai remote. Pull semua perubahan dari "upstream" secara berkala sehingga Anda selalu _up to date_ dan ketika Anda mengajukan pull request Anda, _merge conflict_ akan lebih jarang terjadi. (Lihat instruksi lebih detail [disini](https://help.github.com/articles/syncing-a-fork/).)
* **[Membuat sebuah branch](https://guides.github.com/introduction/flow/)** untuk hasil pengeditan Anda.
* **Referensikan laporan masalah yang berhubungan** atau dokumentasi pendukung pada PR Anda (Misalnya. "Menutup #37.")
* **Sertakan tangkapan layar sebelum dan sesudah** jika perubahan Anda meliputi perubahan pada HTML/CSS. Tarik dan letakkan gambar citra pada bagian _body_ dari pull request Anda.
* **Uji perubahan Anda!** Jalankan perubahan Anda terhadap pengujian jika ada dan buat uji baru jika diperlukan. Apapun kondisinya, pastikan perubahan Anda tidak merusak proyek yang sudah ada.
* **Kontribusi sesuai dengan gaya proyek** sesuai kemampuan Anda. Hal ini berarti menggunakan indentasi, titik koma, dan komentar yang berbeda seperti yang Anda lakukan pada repositori Anda sendiri, tetapi memudahkan bagi pengelola untuk melakukan _merge_ dan orang lain untuk memahami dan mengelolanya di masa depan.

Jika ini merupakan pull request pertama Anda, lihat [Make a Pull Request](http://makeapullrequest.com/), yang dibuat oleh @kentcdodds sebagai sumber panduan informasi gratis.

## Apa yang terjadi setelah Anda mengajukan sebuah kontribusi

Anda melakukannya! Selamat karena telah menjadi kontributor open source. Kami berharap ini yang pertama untuk banyak orang.

Setelah Anda mengajukan kontribusi Anda, salah satu hal berikut akan terjadi:

### 😭 Anda tidak mendapatkan respon.

Semoga Anda [menguji tanda-tanda aktivitas proyek](#daftar-sebelum-anda-berkontribusi) sebelum memulai sebuah kontribusi. Bahkan pada proyek yang aktif, ada kemungkinan bahwa kontribusi Anda tidak akan mendapatkan respon.

Jika Anda belum mendapatkan respon lebih dari satu minggu, sangatlah masuk akal untuk bertanya pada tempat yang sama, meminta orang lain untuk melakukan review. Jika Anda mengetahui orang yang tepat untuk melakukan review terhadap kontribusi Anda, Anda bisa menyebut mereka menggunakan @-kontak pada diskusi.

**Jangan** menghubungi orang tersebut secara pribadi; harap diingat bahwa komunikasi publik sangatlah vital bagi proyek open source.

Jika Anda bertanya secara sopan dan masih tidak ada yang merespon, ada kemungkinan tidak akan ada yang merespon. Ini bukan perasaan yang menyenangkan, tetapi jangan sampai membuat Anda kecewa. Hal ini terjadi pada siapapun juga Terdapat banyak alasan masuk akal kenapa Anda tidak mendapatkan respon, termasuk kondisi pribadi yang diluar kendali Anda. Cobalah untuk mencari proyek atau cara lain untuk berkontribusi. Hal ini merupakan alasan yang bagus untuk tidak menginvestasikan waktu terlalu lama dalam membuat kontribusi sebelum anggota komunitas yang lain merespon Anda.

### 🚧 Seseorang meminta perubahan terhadap kontribusi Anda

Sangatlah normal dimana Anda diminta untuk membuat perubahan terhadap kontribusi Anda, apakah dalam bentuk masukan terhadap ruang lingkup ide Anda atau perubahan pada kode Anda.

Ketika seseorang mengharapkan perubahan, berikan respon dengan cepat. Mereka telah meluangkan waktu untuk melakukan review terhadap kontribusi Anda. Membuka sebuah PR dan meninggalkannya merupakan contoh yang buruk. Jika Anda tidak tahu bagaimana cara membuat perubahan, lakukan pengamatan terhadap masalah, lalu bertanya jika Anda memerlukannya.

Jika Anda tidak memiliki waktu untuk mengerjakan laporan masalah tersebut (misalnya jika diskusi telah berjalan selama berbulan-bulan, dan kondisi Anda sudah mengalami perubahan), berikan informasi kepada pengelola sehingga mereka tidak lagi mengharapkan adanya respon dari Anda. Mungkin terdapat orang lain yang akan mengambil alih.

### 👎 Kontribusi Anda tidak diterima.

Kontribusi Anda mungkin bisa diterima atau tidak pada akhirnya. Semoga Anda tidak menghabiskan waktu terlalu banyak. Jika Anda tidak yakin kenapa tidak diterima, sangatlah masuk akal untuk menanyakan kepada pengelola untuk masukan dan klarifikasi. Meski demikian, Anda tetap harus menghargai keputusan akhir mereka. Jangan berdebat atau bahkan menyerang. Anda selalu diijinkan untuk melakukan _fork_ dan bekerja pada versi Anda sendiri jika Anda tidak setuju.

### 🎉 Kontribusi Anda diterima.

Hooray! Anda telah membuat kontribusi open source!

## Anda berhasil!

Apakah Anda baru saja membuat kontribusi pertama Anda, atau Anda mencari cara baru untuk berkontribusi, kami berharap Anda terinsipirasi untuk mengambil sebuah tindakan. Meskipun jika kontribusi Anda tidak diterima, jangan lupa untuk mengucapkan terima kasih kepada pengelola yang meluangkan waktu untuk membantu Anda. Open source terbentuk oleh orang-orang seperti Anda: satu masalah, pull request, komentar, atau tos pada satu waktu.
