---
lang: fr
title: Construire des communautés accueillantes
description: Construire une communauté qui encourage les gens à utiliser, contribuer et évangéliser votre projet.
class: building
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
---

## Mise en place de votre projet pour le succ&egrave;s

Vous avez lancé votre projet, vous passez le mot, et les gens le vérifient. Impressionnant ! Maintenant, comment les faites-vous rester ?

Une communauté accueillante est un investissement dans l'avenir et la réputation de votre projet. Si votre projet commence à peine à voir ses premières contributions, commencez par donner aux premiers contributeurs une expérience positive et facilitez-les pour qu'ils reviennent.

### Faites que les gens se sentent les bienvenus

Une façon de penser à la communauté de votre projet est ce que @MikeMcQuaid appelle l'[entonnoir du contributeur](https://mikemcquaid.com/2018/08/14/the-open-source-contributor-funnel-why-people-dont-contribute-to-your-open-source-project/):

![Entonnoir du contributeur](/assets/images/building-community/contributor_funnel_mikemcquaid.png)

Au fur et à mesure que vous construisez votre communauté, réfléchissez à la façon dont une personne en haut de l'entonnoir (un utilisateur potentiel) pourrait théoriquement se frayer un chemin vers le bas (un responsable actif). Votre but est de réduire la friction à chaque étape de l'expérience du contributeur. Quand les gens ont des victoires faciles, ils se sentent incités à faire plus.

Commencez avec votre documentation:

* **Facilitez l'utilisation de votre projet par quelqu'un.** [Un fichier README amical](../starting-a-project/#ecrire-un-fichier-readme) et des exemples de code clair faciliteront la tâche à tous ceux qui atterriront votre projet pour commencer.
* **Expliquez clairement comment contribuer**, en utilisant [votre fichier CONTRIBUTING](../starting-a-project/#r&eacute;daction-de-vos-directives-de-contribution) et en gardant vos issues à jour.

[L'enquête open source 2017 de GitHub](http://opensourcesurvey.org/2017/) a montrée que la documentation incomplète ou confuse est le plus gros problème pour les utilisateurs open source. Une bonne documentation invite les gens à interagir avec votre projet. Finalement, quelqu'un va ouvrir une issue ou faire une pull request. Utilisez ces interactions comme des opportunités pour les déplacer dans l'entonnoir.

* **Quand quelqu'un arrive sur votre projet, remerciez-le de son intérêt !** Il suffit d'une expérience négative pour que quelqu'un ne veuille pas revenir.
* **Soyez réactif.** Si vous ne répondez pas à leur problème pendant un mois, les chances sont, ils ont déjà oublié votre projet.
* **Soyez ouvert sur les types de contributions que vous accepterez.** De nombreux contributeurs commencent par un rapport de bug ou une petite correction. Il y a [plusieurs façons de contribuer](../how-to-contribute/#que-signifie-contribuer) à un projet. Laissez les gens aider comment ils veulent aider.
* **S'il y a une contribution avec laquelle vous n'êtes pas d'accord,** remerciez-les pour leur idée et [expliquez pourquoi](../best-practices/#apprendre-&agrave;-dire-non) cela ne rentre pas dans le cadre de la projet, en reliant à la documentation pertinente si vous l'avez.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  Contribuer à l'open source est plus facile pour certains que pour d'autres. Il y a beaucoup de peur d'être accusé de ne pas faire quelque chose de juste ou de ne pas s'intégrer. (...) En donnant aux contributeurs une place pour contribuer avec une très faible compétence technique (documentation, démarque web, etc), vous pouvez réduire considérablement ces préoccupations.
  <p markdown="1" class="pquote-credit">
— @mikeal, ["Growing a contributor base in modern open source"](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

La majorité des contributeurs open source sont des "contributeurs occasionnels": des personnes qui contribuent à un projet uniquement à l'occasion. Un contributeur occasionnel n'a peut-être pas le temps de se familiariser avec votre projet, alors votre travail consiste à rendre la contribution plus facile.

Encourager les autres contributeurs est un investissement en vous aussi. Lorsque vous permettez à vos plus grands fans de courir avec le travail qui les intéresse, il y a moins de pression pour tout faire vous-même.

### Documentez tout

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  Avez-vous déjà assisté à un événement (technique) où vous ne connaissiez personne, mais tout le monde semblait se tenir en groupe et discuter comme de vieux amis? (...) Maintenant, imaginez que vous voulez contribuer à un projet open source, mais vous ne voyez pas pourquoi ou comment cela se passe.
  <p markdown="1" class="pquote-credit">
— @janl, ["Sustainable Open Source"](https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Lorsque vous démarrez un nouveau projet, il peut sembler naturel de garder votre travail privé. Mais les projets Open Source prospèrent lorsque vous documentez votre processus en public.

Quand vous écrivez les choses, plus de gens peuvent participer à chaque étape du chemin. Vous pourriez obtenir de l'aide sur quelque chose dont vous ne saviez même pas que vous en aviez besoin.

Ecrire des choses signifie plus que de la documentation technique. Chaque fois que vous ressentez le besoin d'écrire quelque chose ou de discuter en privé de votre projet, demandez-vous si vous pouvez le rendre public.

Soyez transparent au sujet de la feuille de route de votre projet, des types de contributions que vous recherchez, de la façon dont les contributions sont examinées ou des raisons pour lesquelles vous avez pris certaines décisions.

Si vous remarquez que plusieurs utilisateurs rencontrent le même problème, documentez les réponses dans le fichier README.

Pour les réunions, pensez à publier vos notes ou vos plats à emporter dans un numéro pertinent. Les commentaires que vous obtiendrez de ce niveau de transparence pourraient vous surprendre.

Documenter tout s'applique au travail que vous faites aussi. Si vous travaillez sur une mise à jour substantielle de votre projet, placez-la dans une pull request et marquez-la comme un travail en cours (WIP). De cette façon, d'autres personnes peuvent se sentir impliqués dans le processus dès le début.

### Soyez réactif

Comme vous [faites la promotion de votre projet](../finding-users), les gens auront des commentaires pour vous. Ils peuvent avoir des questions sur la façon dont les choses fonctionnent, ou ont besoin d'aide pour commencer.

Essayez d'être réactif lorsque quelqu'un soumet une issue, une pull request ou une question à propos de votre projet. Lorsque vous répondez rapidement, les gens ont l'impression de participer à un dialogue, et ils seront plus enthousiastes à l'idée de participer.

Même si vous ne pouvez pas examiner la demande immédiatement, le reconnaître au début permet d'augmenter l'engagement. Voici comment @tdreyno a répondu à une pull request sur [Middleman](https://github.com/middleman/middleman/pull/1466):

![la pull request Middleman](/assets/images/building-community/middleman_pr.png)

[Une étude de Mozilla a trouvé que](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) les contributeurs qui ont reçu des avis de code dans les 48 heures avaient un taux de rendement beaucoup plus élevé et recommencaient a contriber.

Des conversations sur votre projet pourraient également avoir lieu dans d'autres endroits sur Internet, tels que Stack Overflow, Twitter ou Reddit. Vous pouvez configurer des notifications dans certains de ces endroits afin d'être averti lorsque quelqu'un mentionne votre projet.

### Donnez à votre communauté point de rassemblement

Il y a deux raisons de donner à votre communauté un point de rassemblement.

La première raison est pour eux. Aidez les gens à se connaître. Les personnes ayant des intérêts communs voudront inévitablement un endroit pour en parler. Et quand la communication est publique et accessible, n'importe qui peut lire les archives passées pour se mettre au courant et participer.

La deuxième raison est pour vous. Si vous ne donnez pas aux gens un lieu public pour parler de votre projet, ils vous contacteront probablement directement. Au début, il peut sembler assez facile de répondre aux messages privés "juste une fois". Mais au fil du temps, surtout si votre projet devient populaire, vous serez épuisé. Résistez à la tentation de communiquer avec des personnes au sujet de votre projet en privé. Au lieu de cela, dirigez-les vers un canal public désigné.

La communication publique peut être aussi simple que de diriger les gens à ouvrir une issue au lieu de vous envoyer directement un e-mail ou de commenter votre blog. Vous pouvez également créer une liste de diffusion ou créer un compte Twitter, Slack ou un canal IRC pour que les gens puissent parler de votre projet. Ou essayez tout ce qui précède !

[Kubernetes kops](https://github.com/kubernetes/kops#getting-involved) réserve des heures de bureau toutes les deux semaines pour aider les membres de la communauté:

> Kops a également du temps mis de côté toutes les deux semaines pour offrir de l'aide et des conseils à la communauté. Les mainteneurs de Kops ont convenu de consacrer du temps spécifiquement dédié au travail avec les nouveaux arrivants, en aidant sur les PR, et en discutant de nouvelles fonctionnalités.

Les exceptions notables à la communication publique sont: 1) les problèmes de sécurité et 2) les violations de code de conduite sensibles. Vous devriez toujours avoir un moyen pour les gens de signaler ces problèmes en privé. Si vous ne souhaitez pas utiliser votre adresse e-mail personnelle, configurez une adresse e-mail dédiée.

## Cultiver votre communaut&eacute;

Les communautés sont extrêmement puissantes. Ce pouvoir peut être une bénédiction ou une malédiction, selon la façon dont vous l'utilisez. Au fur et à mesure que la communauté de votre projet grandit, il existe des moyens de l'aider à devenir une force de construction, pas de destruction.

### Ne tol&egrave;rez pas les mauvais acteurs

Tout projet populaire attirera inévitablement des gens qui nuisent à votre communauté plutôt que de l'aider. Ils peuvent lancer des débats inutiles, ergoter sur des fonctionnalités triviales, ou intimider les autres.

Faites de votre mieux pour adopter une politique de tolérance zéro envers ces types de personnes. Si rien n'est fait, les personnes négatives mettront mal à l'aise les autres membres de votre communauté. Ils peuvent même partir.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/karissa?s=180" class="pquote-avatar" alt="avatar">
  La vérité est qu'ayant une communauté de soutien est la clé. Je ne serais jamais capable de faire ce travail sans l'aide de mes collègues, des étrangers sympathiques sur Internet, et des canaux IRC bavards. (...) Ne vous contentez pas de moins. Ne vous contentez pas de connards.
  <p markdown="1" class="pquote-credit">
— @karissa, ["How to Run a FOSS Project"](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

Des débats réguliers sur des aspects triviaux de votre projet distraient les autres, y compris vous, de se concentrer sur des tâches importantes. Les nouvelles personnes qui arrivent à votre projet peuvent voir ces conversations et ne veulent pas participer.

Lorsque vous voyez un comportement négatif se produire sur votre projet, appelez-le publiquement. Expliquez, d'un ton ferme mais ferme, pourquoi leur comportement n'est pas acceptable. Si le problème persiste, vous devrez peut-être [leur demander de partir](../code-of-conduct/#appliquer-votre-code-de-conduite). Votre [code de conduite](../code-of-conduct/) peut être un guide constructif pour ces conversations.

### Rencontrez les contributeurs là où ils sont

Une bonne documentation devient seulement plus importante au fur et à mesure que votre communauté se développe. Les contributeurs occasionnels, qui ne connaissent peut-être pas votre projet, lisent votre documentation pour obtenir rapidement le contexte dont ils ont besoin.

Dans votre fichier CONTRIBUTING, expliquez explicitement aux nouveaux contributeurs comment démarrer. Vous pouvez même créer une section dédiée à cet effet. [Django](https://github.com/django/django), par exemple, a une page de destination spéciale pour accueillir de nouveaux contributeurs.

![Page des nouveaux contributeurs de Django](/assets/images/building-community/django_new_contributors.png)

Dans votre liste d'issue en attente, étiquetez les bogues qui conviennent à différents types de contributeurs : par exemple, [_"first timers only"_](https://medium.com/@kentcdodds/first-timers-only-78281ea47455), _"good first issue"_, ou _"documentation"_. [Ces étiquettes](https://github.com/librariesio/libraries.io/blob/6afea1a3354aef4672d9b3a9fc4cc308d60020c8/app/models/github_issue.rb#L8-L14) facilitent l'analyse rapide de vos issues par une personne nouvelle dans votre projet de commencer.

Enfin, utilisez votre documentation pour que les gens se sentent les bienvenus à chaque étape du processus.

Vous n'interagirez jamais avec la plupart des personnes qui atterrissent sur votre projet. Il se peut que vous ayez reçu des contributions parce que quelqu'un se sentait intimidé ou ne savait pas par où commencer. Même quelques mots gentils peuvent empêcher quelqu'un de quitter votre projet avec de la frustration.

Par exemple, voici comment [Rubinius](https://github.com/rubinius/rubinius/) commence [son guide de contribution] (https://github.com/rubinius/rubinius/blob/master/.github/contributing.md) :

> Nous voulons commencer par vous dire merci d'utiliser Rubinius. Ce projet est un travail d'amour, et nous apprécions tous les utilisateurs qui détectent les bogues, améliorent les performances et aident à la documentation. Chaque contribution est significative, alors merci de votre participation. Cela étant dit, voici quelques lignes directrices que nous vous demandons de suivre afin que nous puissions résoudre votre problème avec succès.

### Partager la propri&eacute;t&eacute; de votre projet

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/sarahsharp?s=180" class="pquote-avatar" alt="avatar">
  Vos leaders auront des opinions différentes, comme devraient le faire toutes les communautés en bonne santé ! Cependant, vous devez prendre des mesures pour vous assurer que la voix la plus forte ne gagne pas toujours en fatiguant les gens, et que des voix moins importantes et minoritaires soient entendues.
  <p markdown="1" class="pquote-credit">
— @sarahsharp, ["What makes a good community?"](https://sarah.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

Les gens sont enthousiastes à l'idée de contribuer à des projets lorsqu'ils éprouvent un sentiment d'appartenance. Cela ne signifie pas que vous devez retourner la vision de votre projet ou accepter des contributions que vous ne voulez pas. Mais plus vous donnez du crédit aux autres, plus ils resteront.

Voyez si vous pouvez trouver le moyen de partager la propriété avec votre communauté autant que possible. Voici quelques idées:

* **Résistez à corriger les bogues faciles (non critiques).** Utilisez-les plutôt comme des opportunités de recruter de nouveaux contributeurs, ou d'encadrer quelqu'un qui aimerait contribuer. Cela peut sembler anormal au début, mais votre investissement sera rentable au fil du temps. Par exemple, @michaeljoseph a demandé à un contributeur de soumettre une pull request sur une issue [Cookiecutter](https://github.com/audreyr/cookiecutter) ci-dessous, plutôt que de le réparer lui-même.

![Problème de Cookiecutter](/assets/images/building-community/cookiecutter_submit_pr.png)

* **Démarrez un fichier CONTRIBUTORS ou AUTHORS dans votre projet** qui répertorie tous ceux qui ont contribué à votre projet, comme [Sinatra](https://github.com/sinatra/sinatra/blob/master/AUTHORS.md).

* Si vous avez une communauté importante **, envoyez un bulletin d'information ou rédigez un article** remerciant les contributeurs. [La semaine de Rust](https://this-week-in-rust.org/) et celle de Hoodie [Shoutouts](http://hood.ie/blog/shoutouts-week-24.html) sont deux bons exemples.

* **Donnez à chaque contributeur un droit de commit.** @felixge a trouvé que cela rendait les gens [plus excités de fignoler leurs patches](https://felixge.de/2013/03/11/the-pull-request-hack.html ), et il a même trouvé de nouveaux responsables pour des projets sur lesquels il n'avait pas travaillé depuis longtemps.

* Si votre projet est sur GitHub, **déplacez votre projet de votre compte personnel vers un [compte Organisation](https://help.github.com/articles/creating-a-new-organization-account/)** et ajoutez au moins un administrateur de sauvegarde. Les organisations facilitent le travail sur des projets avec des collaborateurs externes.

La réalité est que [la plupart des projets ont seulement](https://peerj.com/preprints/1233.pdf) un ou deux mainteneurs qui font la plupart du travail. Plus votre projet est important et plus votre communauté est grande, plus il est facile de trouver de l'aide.

Même s'il se peut que vous ne trouviez pas toujours quelqu'un pour répondre à l'appel, envoyer un signal augmente les chances que d'autres personnes interviennent. Plus tôt vous commencerez, plus tôt les gens pourront vous aider.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gr2m?s=180" class="pquote-avatar" alt="avatar">
  \[Il est dans votre\] intérêt de recruter des collaborateurs qui aiment et qui sont capables de faire les choses dont vous n'êtes pas. Aimez-vous le codage, mais ne répondez pas aux problèmes ? Ensuite, identifiez les personnes de votre communauté qui le font et laissez-les en avoir.
  <p markdown="1" class="pquote-credit">
— @gr2m, ["Welcoming Communities"](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## R&eacute;soudre les conflits

Au début de votre projet, prendre des décisions importantes est facile. Quand vous voulez faire quelque chose, vous le faites simplement.

Au fur et à mesure que votre projet gagne en popularité, de plus en plus de gens s'intéresseront aux décisions que vous prendrez. Même si vous n'avez pas une grande communauté de contributeurs, si votre projet compte beaucoup d'utilisateurs, vous trouverez des personnes qui pèsent sur les décisions ou qui soulèvent des problèmes.

Pour la plupart, si vous avez cultivé une communauté amicale et respectueuse et documenté vos processus ouvertement, votre communauté devrait être capable de trouver une solution. Mais parfois, vous rencontrez un problème qui est un peu plus difficile à résoudre.

### Mettre la barre pour la gentillesse

Lorsque votre communauté est aux prises avec un problème difficile, la colère peut monter. Les gens peuvent devenir fâchés ou frustrés et s'en prendre à un autre ou à vous.

Votre travail en tant que mainteneur consiste à éviter l'escalade de ces situations. Même si vous avez une opinion forte sur le sujet, essayez de prendre la position d'un modérateur ou d'un facilitateur, plutôt que de vous jeter dans la bagarre et de faire valoir vos points de vue. Si quelqu'un est méchant ou accapare la conversation, [agissez immédiatement](../building-community/#ne-tol&egrave;rez-pas-les-mauvais-acteurs) pour garder les discussions civiles et productives.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kennethreitz?s=180" class="pquote-avatar" alt="avatar">
  En tant que responsable du projet, il est extrêmement important d'être respectueux envers vos contributeurs. Ils prennent souvent ce que vous dites très personnellement.
  <p markdown="1" class="pquote-credit">
— @kennethreitz, ["Be Cordial or Be on Your Way"](https://www.kennethreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

D'autres personnes se tournent vers vous pour obtenir des conseils. Donner le bon exemple. Vous pouvez toujours exprimer votre déception, votre tristesse ou votre inquiétude, mais faites-le calmement.

Garder son calme n'est pas facile, mais faire preuve de leadership améliore la santé de votre communauté. L'internet vous remercie.

### Traitez votre fichier README en tant que constitution

Votre fichier README est [plus qu'un simple jeu d'instructions](../starting-a-project/#ecrire-un-fichier-readme). C'est aussi un endroit où parler de vos objectifs, de votre vision du produit et de votre feuille de route. Si les gens sont trop concentrés sur le débat sur le mérite d'une fonctionnalité particulière, il peut être utile de revoir votre fichier README et de parler de la vision plus élevée de votre projet. En vous concentrant sur votre fichier README, vous dépersonnalisez la conversation, ce qui vous permet d'avoir une discussion constructive.

### Focus sur le voyage, pas la destination

Certains projets utilisent un processus de vote pour prendre des décisions importantes. Bien que raisonnable à première vue, le vote met l'accent sur le fait d'arriver à une "réponse", plutôt que d'écouter et de répondre aux préoccupations de l'autre.

Le vote peut devenir politique, où les membres de la communauté se sentent poussés à se faire des faveurs ou à voter d'une certaine manière. Pas tout le monde vote, que ce soit la [majorit&eacute;  silencieuse](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority-of-users) dans votre communauté, ou les utilisateurs actuels qui ne savaient pas qu'un vote avait lieu.

Parfois, le vote est un arbitre nécessaire. Cependant, autant que vous le pouvez, insistez sur ["recherche de consensus"](https://en.wikipedia.org/wiki/Consensus-seeking_decision-making) plutôt que sur un consensus.

Dans le cadre d'un processus de recherche de consensus, les membres de la communauté discutent des préoccupations majeures jusqu'à ce qu'ils sentent qu'ils ont été suffisamment entendus. Lorsque seules des préoccupations mineures subsistent, la communauté va de l'avant. La recherche d'un consensus reconnaît qu'une communauté peut ne pas être capable d'atteindre une réponse parfaite. Au lieu de cela, il donne la priorité à l'écoute et à la discussion.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lee-dohm?s=180" class="pquote-avatar" alt="avatar">
  Une partie de la raison pour laquelle un système de vote n'existe pas pour les issues Atom est parce que l'équipe Atom ne va pas suivre un système de vote dans tous les cas. Parfois, nous devons choisir ce que nous ressentons, même si c'est impopulaire. (...) Ce que je peux offrir et m'engager à faire... c'est que c'est mon travail d'écouter la communauté.
  <p markdown="1" class="pquote-credit">
— @lee-dohm on [Atom's decisionmaking process](https://discuss.atom.io/t/prioritize-issues-feature-requests-based-on-voting-system/27642/2)
  </p>
</aside>

Même si vous n'adoptez pas un processus de recherche de consensus, en tant que responsable de projet, il est important que les gens sachent que vous écoutez. Faire en sorte que les autres se sentent entendus, et s'engager à résoudre leurs problèmes, contribue grandement à la diffusion des situations sensibles. Ensuite, suivez vos mots avec des actions.

Ne vous précipitez pas dans une décision pour avoir une résolution. Assurez-vous que tout le monde se sent entendu et que toutes les informations ont été rendues publiques avant de passer à une résolution.

### Maintenir la conversation centrée sur l'action

La discussion est importante, mais il y a une différence entre les conversations productives et improductives.

Encouragez la discussion tant qu'elle avance activement vers la résolution. S'il est clair que la conversation est en train de languir ou de sortir du sujet, les jabs deviennent personnels, ou les gens ergotent sur des détails mineurs, il est temps de les fermer.

Permettre ces conversations de continuer n'est pas seulement mauvais pour le problème en question, mais mauvais pour la santé de votre communauté. Il envoie un message que ces types de conversations sont autorisés ou même encouragés, et cela peut décourager les gens de relever ou de résoudre des futures issues.

Avec chaque point que vous ou d'autres avez fait valoir, demandez-vous:_"Comment cela nous rapproche-t-il d'une résolution ?"_

Si la conversation commence à se dérouler, demandez au groupe: _"Quelles étapes devrions-nous prendre ensuite ?"_ Pour recentrer la conversation.

Si une conversation ne va clairement nulle part, il n'y a pas de mesures claires à prendre, ou les mesures appropriées ont déjà été prises, fermez l'issue et expliquez pourquoi vous l'avez fermé.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Guider un fil vers l'utilité sans être arriviste est un art. Cela ne servira pas simplement à exhorter les gens à cesser de perdre leur temps, ou à leur demander de ne pas afficher, à moins qu'ils aient quelque chose de constructif à dire. (...) Au lieu de cela, vous devez suggérer des conditions pour de nouveaux progrès: donner aux gens un itinéraire, un chemin à suivre qui mène aux résultats que vous voulez, mais sans donner l'impression que vous dictez une conduite.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](https://producingoss.com/en/producingoss.html#common-pitfalls)
  </p>
</aside>

### Choisissez vos batailles avec sagesse

Le contexte est important. Considérez qui est impliqué dans la discussion et comment il représente le reste de la communauté.

Est-ce que tout le monde dans la communauté est mécontent, voir même concerné par ce problème ? Ou est ce un fauteur de troubles solitaire ? N'oubliez pas de considérer vos membres de la communauté silencieuse, pas seulement les voix actives.

Si le problème ne représente pas les besoins plus larges de votre communauté, vous devrez peut-être simplement prendre en compte les préoccupations de quelques personnes. S'il s'agit d'un problème récurrent sans résolution claire, indiquez-le aux discussions précédentes sur le sujet et fermez le fil.

### Identifier un arbitre communautaire

Avec une bonne attitude et une communication claire, la plupart des situations difficiles peuvent être résolues. Cependant, même dans une conversation productive, il peut simplement y avoir une différence d'opinion sur la façon de procéder. Dans ces cas, identifiez un individu ou un groupe de personnes pouvant servir d'arbitre d'égalité.

Un arbitre pourrait être le principal responsable du projet, ou il pourrait s'agir d'un petit groupe de personnes qui prendrait une décision en fonction du vote. Idéalement, vous avez identifié une condition de départage et le processus associé dans un fichier GOVERNANCE avant de devoir l'utiliser.

Votre bris d'égalité devrait être un dernier recours. Les problèmes diviseurs sont une opportunité pour votre communauté de grandir et d'apprendre. Adoptez ces opportunités et utilisez un processus collaboratif pour passer à une résolution dans la mesure du possible.

## La communauté est le ❤️ de l'open source

Des communautés saines et prospères alimentent les milliers d'heures consacrées à l'open source chaque semaine. Beaucoup de contributeurs pointent vers d'autres personnes comme la raison de travailler - ou ne pas travailler - sur l'open source. En apprenant comment exploiter ce pouvoir de manière constructive, vous aiderez quelqu'un à vivre une expérience open source inoubliable.
