---
lang: es
title: Tu C&oacute;digo de Conducta
description: Facilita el comportamiento sano y constructivo, adoptando y aplicando un c&oacute;digo de conducta.
class: coc
order: 8
image: /assets/images/cards/coc.png
related:
  - building
  - leadership
---

## Por qué es necesario un código de conducta

Un c&oacute;digo de conducta es un documento que establece expectativas de comportamiento para los participantes de tu proyecto. Adoptar, y aplicar, un c&oacute;digo de conducta, ayuda a crear una atmosfera social positiva para la comunidad.

Los c&oacute;digos de conducta ayudan a proteger no solo a tus participantes, sino tambi&eacute;n a ti mismo. Si mantienes un proyecto, sabr&aacute;s que las actitudes improductivas de otros participantes pueden hacerte sentir sin energ&iacute;a o infeliz acerca de tu trabajo.

Un c&oacute;digo de conducta te alienta a facilitar un comportamiento saludable y constructivo por parte de la comunidad. Ser proactivo reduce la probabilidad de que tanto t&uacute;, como otros, se sientan fatigados con el proyecto, y te ayuda a tomar acci&oacute;n cuando alguien hace algo con lo que no concuerdas.

## Estableciendo un c&oacute;digo de conducta

Intenta establecer un c&oacute;digo de conducta tan tempranamente como sea posible: idealmente, cuando crees t&uacute; proyecto.

Adem&aacute;s de comunicar tus expectativas, un c&oacute;digo de conducta describe lo siguiente:

*	Donde el c&oacute;digo de conducta toma efecto _(¿solamente en las issues y pull requests, o en actividades de la comunidad como eventos?)_
*	A quien o quienes aplica el c&oacute;digo de conducta _(miembros de la comunidad y responsables de mantenimiento, pero ¿Qu&eacute; hay acerca de los sponsors?)_
*	Que sucede si alguien viola el c&oacute;digo de conducta
*	De qu&eacute; manera alguien puede reportar una violaci&oacute;n

Siempre que sea posible, haga uso del art. El [Contributor Covenant](https://www.contributor-covenant.org/) es un c&oacute;digo de conducta usado por m&aacute;s de 40,000 proyectos de software libre, incluyendo Kubernetes, Rails, and Swift.

El [Django Code of Conduct](https://www.djangoproject.com/conduct/) y el [Citizen Code of Conduct](http://citizencodeofconduct.org/) son tambi&eacute;n dos ejemplos de buenos c&oacute;digos de conducta.

Ubica un archivo CODIGO_DE_CONDUCTA en el directorio ra&iacute;z de tu proyecto, y enl&aacute;zalo desde tu LEEME, as&iacute; el mismo se encuentra visible a tu comunidad.

## Decidiendo de qu&eacute; manera vas a aplicar tu c&oacute;digo de conducta

<aside markdown="1" class="pquote">
  Un c&oacute;digo de conducta que no es (o no puede) ser aplicado, es incluso peor que no tener un c&oacute;digo de conducta: Esto demostrar&iacute;a que los valores en el c&oacute;digo de conducta no son importantes o no son respetados en tu comunidad.
  <p markdown="1" class="pquote-credit">
— [Ada Initiative](https://adainitiative.org/2014/02/18/howto-design-a-code-of-conduct-for-your-community/)
  </p>
</aside>

Deber&iacute;as explicar de qu&eacute; manera tu c&oacute;digo de conducta va a ser aplicado **_antes_** de que una violaci&oacute;n ocurra. Hay varios motivos para ello:

*	Esto demuestra que eres serio acerca de tomar acciones cuando sea necesario.

*	Tu comunidad se sentir&aacute; m&aacute;s segura de que sus reclamos son realmente revisados.

*	Brindaras a tu comunidad la seguridad de que el proceso de revisi&oacute;n es justo y transparente, en el caso en que se encuentren siendo investigados por una violaci&oacute;n.

Deber&iacute;as brindar a las personas, una manera privada (por ejemplo, mediante una direcci&oacute;n de email) de reportar una violaci&oacute;n al c&oacute;digo de conducta y explicar qui&eacute;n recibe dicho reporte. Puede ser un responsable de mantenimiento, un grupo de tales responsables, o un grupo de trabajo de c&oacute;digo de conducta.

Recuerda que alguien puede que desee reportar una violaci&oacute;n acerca de la persona que recibe dichos reportes. En tal caso, br&iacute;ndales la posibilidad de que dichos reportes, sean revisados por alguien m&aacute;s. Por ejemplo, @ctb y @mr-c [explican en su proyecto](https://github.com/dib-lab/khmer/blob/master/CODE_OF_CONDUCT.rst), [khmer](https://github.com/dib-lab/khmer):

> Instancias de abuso, acoso o similares comportamientos inaceptables pueden ser reportados mandando un email a **khmer-project@idyll.org** el cual solamente se dirigir&aacute; a C. Titus Brown and Michael R. Crusoe. Para reportar una cuesti&oacute;n que involucra a ambos, por favor env&iacute;a un email a **Judi Brown Clarke, Ph.D.** el Director de Diversidad en el BEACON Center for the Study of Evolution in Action, un centro de la Fundaci&oacute;n de Ciencia Nacional para la Ciencia y Tecnologia.*

Para inspirarte, mira el [manual de ejecuci&oacute;n de Django](https://www.djangoproject.com/conduct/enforcement-manual/)  (aunque quiz&aacute;s no necesites algo tan amplio, dependiendo del tama&ntilde;o de tu proyecto).

## Aplicando tu c&oacute;digo de conducta

En ocasiones, a pesar de tus mayores esfuerzos, alguien har&aacute; algo que violara este c&oacute;digo. Existen diferentes maneras de abordar el comportamiento negativo o da&ntilde;ino en la pr&aacute;ctica.

### Recolectar informaci&oacute;n acerca de la situaci&oacute;n

Ot&oacute;rgale la importancia a lo que cada miembro de la comunidad tiene para decir como se la dar&iacute;as a lo que t&uacute; tienes para decir. Si recibes un reporte de que alguien ha violado el c&oacute;digo de conducta, t&oacute;matelo seriamente e investiga el asunto, incluso si no condice con tu experiencia con dicha persona. De esta manera, demuestras a tu comunidad que valoras su perspectiva y conf&iacute;as en su juicio.

El miembro de la comunidad puede ser un reincidente quien constantemente hace sentir incomodos a los dem&aacute;s o puede haber hecho o dicho algo por &uacute;nica vez. En ambas situaciones podemos tomar acciones, dependiendo del contexto.

Antes de que respondas, t&oacute;mate tu tiempo para entender lo que sucedi&oacute;. Lee los comentarios y conversaciones pasados de la persona para entender mejor quienes son y por qu&eacute; podr&iacute;an haber actuado de tal manera. Intenta recolectar perspectivas de otros acerca de dicha persona y su comportamiento.

<aside markdown="1" class="pquote">
  No entres en discusiones. No se desv&iacute;e a tratar con el comportamiento de otra persona antes de que haya terminado de tratar con el asunto en cuesti&oacute;n. Enf&oacute;cate en lo que necesitas.
  <p markdown="1" class="pquote-credit">
— Stephanie Zvan, ["So You've Got Yourself a Policy. Now What?"](https://the-orbit.net/almostdiamonds/2014/04/10/so-youve-got-yourself-a-policy-now-what/)
  </p>
</aside>

### Toma acciones apropiadas

Luego de recolectar y procesar suficiente informaci&oacute;n, necesitaras decidirte que hacer. Mientras consideras tus siguientes pasos, recuerda que tu objetivo como moderador es fomentar un ambiente seguro, respetuoso y colaborativo. Considera no solamente como tratar la situaci&oacute;n en cuesti&oacute;n, sino tambi&eacute;n como tu respuesta afectara al comportamiento y expectativas del resto de tu comunidad.

Cuando alguien reporta una violaci&oacute;n al c&oacute;digo de conducta, es tu trabajo ocuparte de ella, y no de otra persona. A veces, quien reporta est&aacute; revelando la informaci&oacute;n con gran riesgo para su carrera, reputaci&oacute;n o integridad f&iacute;sica. Forzarlos a confrontar a su acosador puede poner en una posici&oacute;n comprometedora a quien reporta. Debes comunicarte de manera directa con la persona en cuesti&oacute;n, a menos que quien reporta expl&iacute;citamente solicite lo contrario.

Existen varias maneras de responder a una violaci&oacute;n del c&oacute;digo de conducta:

* **Dar a la persona en cuesti&oacute;n una advertencia p&uacute;blica** y explicarle de que manera su comportamiento ha impactado negativamente en los dem&aacute;s, preferiblemente en el canal en donde ocurri&oacute;. Siempre que sea posible, la comunicaci&oacute;n p&uacute;blica transmite a la comunidad la seriedad con la que consideras al c&oacute;digo de conducta. Se amable, pero firme, en la manera en que te comunicas.

* **Acercarse de forma privada a la persona** en cuesti&oacute;n para explicarle de que manera su comportamiento impacto negativamente en los dem&aacute;s. Puedes usar un canal de comunicaci&oacute;n privado si la situaci&oacute;n involucra informaci&oacute;n personal. Si te comunicas de manera privada con alguien, es una buena idea realizar una copia carb&oacute;n a los primeros que hayan reportado la situaci&oacute;n, de esta manera sabr&aacute;n que tomaste acciones. P&iacute;dele consentimiento a quien reporta antes de enviarle una copia carb&oacute;n.

En ocasiones, no es posible lograr una soluci&oacute;n. La persona en cuesti&oacute;n puede volverse agresiva y hostil cuando sea confrontada o puede que no cambie su comportamiento. Frente a esta situaci&oacute;n, deber&iacute;as considerar tener en cuenta medidas m&aacute;s fuertes. Por ejemplo:

* **Suspender a la persona** en cuesti&oacute;n del proyecto, aplicando una prohibici&oacute;n en la participaci&oacute;n en todo aspecto del proyecto.

* **Expulsar permanentemente** a la persona del proyecto.

La expulsi&oacute;n de miembros no debe ser tomado a la ligera y representa una permanente e irreconciliable diferencia de perspectiva. Deber&iacute;as tomar estas medidas solamente cuando es evidente que no puede llegarse a una soluci&oacute;n.

## Tus responsabilidades como responsable de mantenimiento

Un c&oacute;digo de conducta no es una ley aplicada arbitrariamente. T&uacute; eres quien aplica el c&oacute;digo de conducta y es tu responsabilidad seguir las reglas que el c&oacute;digo de conducta establece.

Como encargado de mantenimiento, t&uacute; estableces las directrices de tu comunidad y las aplicas de acuerdo a las reglas establecidas en tu c&oacute;digo de conducta. Esto implica considerar seriamente a cualquier violaci&oacute;n al c&oacute;digo de conducta. Quien reporta merece una justa y total revisi&oacute;n de su reclamo. Si determinas que el comportamiento reportado no es una violaci&oacute;n, comun&iacute;cate de manera clara con ellos y expl&iacute;cales por qu&eacute; no tomaras ninguna acci&oacute;n. Lo que hacen con eso depende de ellos: tolerar el comportamiento con el cual ten&iacute;an un problema, o dejar de participar en la comunidad.

Un reporte de comportamiento que _t&eacute;cnicamente_ no viola el c&oacute;digo de conducta puede indicar que hay un problema en tu comunidad, y deber&iacute;as investigar este problema potencial y actuar acorde. Esto puede incluir revisar tu c&oacute;digo de conducta para clarificar comportamientos aceptables y/o hablar con la persona cuyo comportamiento fue reportado y explicarles que si bien no han violado el c&oacute;digo de conducta, est&aacute;n rozando el borde de lo que se espera y est&aacute;n haciendo sentir incomodos a ciertos participantes.

Finalmente, como responsable de mantenimiento, t&uacute; estableces y aplicas los est&aacute;ndares de comportamiento aceptable. Tienes la habilidad para moldear los valores de la comunidad del proyecto, y los participantes cuentan con que apliques dichos valores de manera justa e imparcial.

## Promover el comportamiento que quieres ver en el mundo 🌎

Cuando un proyecto parece hostil y poco acogedor, incluso cuando se trata solamente de una persona cuyo comportamiento es tolerado por los dem&aacute;s, te arriesgas a perder mucho m&aacute;s contribuidores, algunos de los cuales quiz&aacute;s no conozcas jam&aacute;s. No siempre es f&aacute;cil adoptar o aplicar un c&oacute;digo de conducta, pero fomentar un ambiente acogedor ayudara a que tu comunidad crezca.
