---
lang: de
title: Wie zu Open Source beitragen?
description: Möchten Sie zu Open Source beitragen? Hier finden Sie einen Leitfaden für Einsteiger und Fortgeschrittene.
class: contribute
order: 1
image: /assets/images/cards/contribute.png
related:
  - beginners
  - building
---

## Warum eigentlich zu Open-Source-Projekten beitragen?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/errietta?s=180" class="pquote-avatar" alt="avatar">

  Die Arbeit an \[freenode\] lehrte mich viele Fähigkeiten, die sich später in meinem Universitätsstudium und meinen Beruf als nützlich erwiesen. Ich denke, an Open-Source zu arbeiten, half mir selbst ebenso sehr wie dem Projekt.

  _Working on \[freenode\] helped me earn many of the skills I later used for my studies in university and my actual job. I think working on open source projects helps me as much as it helps the project!_

  <p markdown="1" class="pquote-credit">
— @errietta, ["Why I love contributing to open source software"](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

Zu Open Source beizutragen, kann ein lohnender Weg sein, um nahezu alle erdenklichen Fertigkeiten zu erlernen, zu lehren und Erfahrungen zu sammeln.

Warum tragen Menschen zu Open Source bei? Es gibt viele Gründe!

### Bestehende Fähigkeiten verbessern

Ob Programmierung, User Interface Design, Grafikdesign, Schreiben oder Organisieren: Wenn Sie auf der Suche nach Praxiserfahrung sind, werden Sie dafür passende Aufgaben in einem Open-Source-Projekt finden.

### Treffen Sie Menschen, die an ähnlichen Dingen interessiert sind

Open-Source-Projekte mit warmherzigen, einladenden Communities schaffen langfristige Hobbys für viele Leute. Lebenslange Freundschaften können durch ihre Teilnahme an Open Source entstehen, sei es bei Konferenzen oder bei nächtlichen Online-Chats über Lahmacuns.

### Mentoren finden und andere unterrichten

Wenn Sie mit anderen an einem gemeinsamen Projekt arbeiten, müssen Sie erklären, wie Sie dabei vorgehen und gleichzeitig andere Menschen um Hilfe bitten. Das Lernen und Lehren kann eine erfüllende Tätigkeit für alle Beteiligten sein.

### Öffentliche Ergebnisse zeugen von Ihrer Arbeit und fördern Ihren Ruf (und Ihre Karriere)

Per Definition ist Ihre gesamte Open-Source-Arbeit öffentlich. Sie erstellen automatisch ein Portfolio. So können Sie überall vorzeigen, was Sie zu leisten im Stande sind.

### Sozialkompetenzen erlernen

Softwareentwicklung ist eine soziale Tätigkeit, und Open-Source-Projekte bieten Führungserfahrungen, denn es müssen z.B. Konflikte gelöst, Teams organisiert und Aufgaben priorisiert werden.

### Es ist ermutigend, auch kleine Änderungen vornehmen zu können.

Sie müssen nicht lebenslang an Open Source mithelfen. Haben Sie schon einmal einen Tippfehler auf einer Website gesehen und sich gewünscht, dass ihn jemand beheben würde? Bei einem Open-Source-Projekt können Sie genau das tun. Open Source hilft Leuten, selbst in die Hand zu nehmen, wie sie die Welt erleben, und das ist an sich schon befriedigend.

## Was "einen Beitrag leisten" bedeutet

Wenn Sie gerade erst anfangen, Open-Source-Arbeit zu leisten, kann der Prozess einschüchternd wirken. Wie finden Sie das richtige Projekt? Was, wenn Sie nicht wissen, wie man programmiert? Was, wenn etwas schief geht?

Keine Sorge! Es gibt viele Möglichkeiten, zu einem Open-Source-Projekt beizutragen. Die folgenden paar Tipps helfen Ihnen, dabei gute Erfahrungen zu machen.

### Sie müssen keinen Code beisteuern

Ein weit verbreiteter Irrtum! Aber in Wirklichkeit sind es oft andere Projektaspekte, die am [meisten Unterstützung benötigen](https://github.com/blog/2195-the-shape-of-open-source). Sie tun dem Projekt einen _großen_ Gefallen, indem Sie anbieten, bei nicht-Code-Aspekten mitzuwirken!

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/orta?s=180" class="pquote-avatar" alt="avatar">

  Ich bin bekannt für meine Arbeit an CocoaPods, aber die meisten Leute wissen nicht, dass ich eigentlich keine echte Arbeit am CocoaPods-Tool selbst mache. Meine Zeit im Projekt verbringe ich hauptsächlich mit Dokumentation und Marketing.

  _I've been renowned for my work on CocoaPods, but most people don't know that I actually don't do any real work on the CocoaPods tool itself. My time on the project is mostly spent doing things like documentation and working on branding._

  <p markdown="1" class="pquote-credit">
— @orta, ["Moving to OSS by default"](https://realm.io/news/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

Auch wenn Sie gerne Code schreiben, sind andere Beitragsarten eine gute Möglichkeit, sich an einem Projekt zu beteiligen und andere Leute aus der Community zu treffen. Solche Beziehungen aufzubauen, ebnet Ihnen den Weg zur Mitarbeit an anderen Projektaspekten.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/brettcannon?s=180" class="pquote-avatar" alt="avatar">

  Ich habe mich zum ersten Mal an das Python-Entwicklungsteam ("python-dev") gewandt, als ich am 17. Juni 2002 eine E-Mail bezüglich eines Patches von mir an die Mailingliste schickte. Das Open-Source-Fieber packte mich sofort und ich beschloss, E-Mail-Zusammenfassungen für die Gruppe zu kuratieren. So hatte ich immer eine gute Ausrede, um mir Dinge erklären zu lassen. Aber noch wichtiger war die Möglichkeit, schnell mitzubekommen wenn jemand auf einen Reparaturbedarf hinwies.

  _I first reached out to the Python development team (aka python-dev) when I emailed the mailing list on June 17, 2002 about accepting my patch. I quickly caught the open source bug, and decided to start curating email digests for the group. They gave me a great excuse to ask for clarifications about a topic, but more critically I was able to notice when someone pointed out something that needed fixing._

  <p markdown="1" class="pquote-credit">
— @brettcannon, ["Maintainer Stories"](https://github.com/open-source/stories/brettcannon)
  </p>
</aside>

### Planen Sie gerne Veranstaltungen?

* Veranstalten Sie Workshops oder Meetups über das Projekt, wie @fzamperin [für NodeSchool](https://github.com/nodeschool/organizers/issues/406)
* Organisieren Sie die Projektkonferenz (falls vorhanden)
* Unterstützen Sie die Community-Mitglieder dabei, die richtigen Konferenzen zu finden und dort Vortragsideen einzureichen.

### Mögen Sie Design-Arbeit?

* Verbessern Sie Layouts, um das Projekt benutzerfreundlicher zu machen
* Führen Sie Nutzerstudien durch, um Navigation oder Menüs der Software zu verfeinern ([wie z.B. Drupal es vorschlägt](https://www.drupal.org/community-initiatives/drupal-core/usability))
* Erstellen Sie einen Designleitfaden, um dem Projekt zu einem einheitlichen visuellen Design zu verhelfen
* Erstellen Sie Kunst für T-Shirts oder ein neues Logo, [wie z.B. die Mitwirkenden von hapi.js](https://github.com/hapijs/contrib/issues/68)

### Schreiben Sie gerne?

* Erstellen und verbessern Sie die Projektdokumentation
* Erstellen Sie eine Übersicht von Anwendungsbeispielen, welche die Verwendungsmöglichkeiten der Software zeigen
* Starten Sie einen Newsletter für das Projekt oder kuratieren Sie Highlights aus der Mailingliste
* Schreiben Sie Tutorials für das Projekt, so [wie die Mitwirkenden von PyPA](https://github.com/pypa/python-packaging-user-guide/issues/194)
* Übersetzen Sie die Projektdokumentation

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kittens?s=180" class="pquote-avatar" alt="avatar">

  Ernsthaft, die \[Dokumentation\] ist mega-wichtig. Sie war bisher großartig und ein Killer-Feature von Babel. Aber es gibt Abschnitte, die sicherlich einiger Verbesserung bedürfen, und auch einen Absatzes hier oder dort hinzuzufügen.

  _Seriously, \[documentation\] is mega-important. The documentation so far has been great and has been a killer feature of Babel. There are sections that could certainly use some work and even the addition of a paragraph here or there is extremely appreciated._

  <p markdown="1" class="pquote-credit">
— @kittens, ["Call for contributors"](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### Organisieren Sie gerne?

* Verlinken Sie doppelte Issues und schlagen Sie neue Labels vor, um den Issue Tracker in Ordnung zu halten
* Gehen Sie offene Issues durch und schlagen Sie alte zur Schließung vor, wie @nzakas [in ESLint](https://github.com/eslint/eslint/issues/6765)
* Stellen Sie konstruktive Fragen zu kürzlich eingereichten Issues, um Diskussionen voranzubringen

### Mögen Sie das Programmieren?

* Finden Sie ein offenes Issue, das Sie bearbeiten können, wie @dianjin [in Leaflet](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560)
* Bieten Sie die Implementierung neuer Funktionen an
* Automatisieren Sie etwas, z.B. die Softwareinstallation
* Verbessern Sie Werkzeuge oder Tests

### Helfen Sie gerne anderen Leuten?

* Beantworten Sie Fragen zum Projekt, z.B. auf Stack Overflow ([wie dieses Postgres-Beispiel zeigt](https://stackoverflow.com/questions/18664074/getting-error-peer-authentication-failed-for-user-postgres-when-trying-to-ge)) oder auf Reddit
* Beantworten Sie Fragen in offenen Issues
* Helfen Sie bei der Moderation von Diskussionsforen oder anderen Kommunikationskanälen

### Helfen Sie gerne Anderen beim Programmieren?

* Überprüfen Sie den Code in Pull Requests
* Schreiben Sie Tutorials, wie ein Projekt verwendet werden kann
* Bieten Sie einem Anderen Mentoring an, wie @ereichert für @bronzdoc [in Rust](https://github.com/rust-lang/book/issues/123#issuecomment-238049666)

### Es muss nicht immer ein Softwareprojekt sein!

Während sich "Open Source" oft auf Software bezieht, kann man an fast allen anderen Arten von Projekten zusammenarbeiten: Bücher, Rezepte, Listen, Kurse, uvm. werden als Open-Source-Projekte entwickelt.

Zum Beispiel:

* @sindresorhus kuratiert eine [Liste von "awesome"-Listen](https://github.com/sindresorhus/awesome)
* @h5bp unterhält eine [Liste möglicher Bewerbungsfragen](https://github.com/h5bp/Front-end-Developer-Interview-Questions) für Frontend-Entwickler\*innen
* @stuartlynn und @nicole-a-tesla [sammeln lustige Fakten über Papageitaucher](https://github.com/stuartlynn/puffin_facts)

Auch wenn Sie ein\*e Software-Entwickler\*in sind, kann Ihnen die Arbeit an einem Dokumentationsprojekt den Einstieg in Open Source erleichtern. Es ist oft weniger einschüchternd, an Projekten zu arbeiten, die keinen Code beinhalten, um Vertrauen und Erfahrung in den Zusammenarbeitsprozess als solchen zu stärken.

## Sich in einem neuen Projekt orientieren

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shaunagm?s=180" class="pquote-avatar" alt="avatar">

  Wenn Sie sich einen Issue Tracker anschauen und er Dinge verwirrend erscheinen lässt, dann sind sie mit dem Gefühlt vermutlich nicht allein. Diese Werkzeuge erfordern viel implizites Wissen. Sie können es von anderen Leuten erlernen, und Sie können ihnen Fragen stellen.

  _If you go to an issue tracker and things seem confusing, it's not just you. These tools require a lot of implicit knowledge, but people can help you navigate it and you can ask them questions._

  <p markdown="1" class="pquote-credit">
— @shaunagm, ["How to Contribute to Open Source"](https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/)
  </p>
</aside>

Für alles über eine Tippfehlerkorrektur hinaus ist ein Beitrag zu Open Source, als würde man sich zu einer Gruppe von Fremden auf einer Party gesellen. Wenn Sie anfangen, über Lamas zu reden, während die Anderen tief in einer Diskussion über Goldfische stecken, werden diese Sie wahrscheinlich ein wenig seltsam ansehen.

Bevor Sie blindlings mit Ihren eigenen Vorschlägen daherkommen, lernen Sie zunächst, die Situation zu einzuschätzen. Dies erhöht die Chancen, dass später Ihre Ideen wahrgenommen und gehört werden.

### Anatomie eines Open-Source-Projekts

Jede Open-Source-Community ist anders.

Jahrelanges Arbeiten an einem Open-Source-Projekt bedeutet, dass Sie dieses eine kennengelernt haben. Wechseln Sie zu einem anderen Projekt, werden Sie feststellen, dass das Vokabular, die Normen und die Kommunikationsstile völlig unterschiedlich sein können.

Allerdings folgen viele Open-Source-Projekte einer ähnlichen Organisationsstruktur. Das Verständnis der verschiedenen Rollen in der Community und des Gesamtprozesses wird Ihnen helfen, sich schnell auf jedes neue Projekt einzustellen.

Ein typisches Open-Source-Projekt beinhaltet die folgenden Typen von Personen:

* **Autor\*in:** Die Person/en oder Organisation, die das Projekt erstellt hat/haben
* **Owners:** Die Person/en, die administrativen Zugang zu der Organisation oder dem Repository hat/haben (nicht immer derselbe wie der/die ursprüngliche Autor*in).
* **Maintainers:** Mitwirkende, die für die Umsetzung der Vision verantwortlich sind, und für die organisatorischen Aspekte des Projekts. (Dies können auch Autoren oder Eigentümerinnen des Projekts sein.)
* **Contributors:** Alle, die etwas zum Projekt beigetragen haben.
* **Community-Mitglieder:** Personen, die das Projekt nutzen. Sie können in Diskussionen aktiv sein oder ihre Meinung über die Richtung des Projekts äußern.

Größere Projekte können auch Gremien oder Arbeitsgruppen haben, die sich auf verschiedene Aufgaben konzentrieren, wie z.B. Tooling, Triage, Community-Moderation und Eventorganisation. Suchen Sie auf der Website eines Projekts nach einer "Team"-Seite oder im Repository nach "Governance"-Dokumentation, um diese Informationen zu finden.

Ein Projekt hat auch eine Dokumentation. Diese Dateien werden in der Regel im Hauptverzeichnis eines Repositories aufgelistet.

* **LICENSE:** Per Definition muss jedes Open-Source-Projekt eine [Open-Source-Lizenz](https://choosealicense.com) haben. Wenn das Projekt keine Lizenz hat, ist es nicht Open Source.
* **README:** Die README ist die Bedienungsanleitung, die neue Community-Mitglieder im Projekt willkommen heißt. Sie erklärt, warum das Projekt nützlich ist, und wie man beginnen kann, es zu nutzen.
* **CONTRIBUTING:** Während READMEs den Menschen helfen, das Ergebnis des Projektes _zu nutzen_, hilft die Kontributionsdokumentation dabei, zum Projekt beizutragen. Sie erklärt, welche Arten von Beiträgen benötigt werden und wie der Prozess funktioniert. Obwohl nicht jedes Projekt eine CONTRIBUTING-Datei hat, signalisiert ihre Präsenz, dass dieses Projekt offen für Beiträge ist.
* **CODE_OF_CONDUCT:** Der Verhaltenskodex legt die Grundregeln für das Verhalten der Teilnehmer\*innen fest und trägt dazu bei, ein freundliches und einladendes Umfeld zu schaffen. Obwohl nicht jedes Projekt eine CODE_OF_CONDUCT-Datei hat, signalisiert ihre Präsenz, dass dieses Projekt offen für Beiträge ist.
* **Andere Dokumentation:** Es kann zusätzliche Tutorials, Walkthroughs oder Governance-Richtlinien geben, vor Allem bei größeren Projekten.

Schließlich verwenden Open-Source-Projekte die folgenden Werkzeuge, um Diskussionen zu organisieren. Wenn Sie die Archive durchlesen, erhalten Sie ein gutes Bild davon, wie die Gemeinschaft denkt und arbeitet.

* **Issue Tracker:** Wo Leute über Themen diskutieren, die im Zusammenhang mit dem Projekt stehen.
* **Pull Requests:** Wo Leute anstehende Änderungen diskutieren und überprüfen.
* **Diskussionsforen oder Mailinglisten:** Einige Projekte nutzen solche Kanäle für Konversationen (z.B. _"Wie kann ich..."_ oder _"Was denkt ihr über..."_) anstelle von Fehlerberichten oder Feature Requests. Andere verwenden den Issue Tracker für alle Konversationen.
* **Synchroner Chat-Kanal:** Einige Projekte verwenden Kanäle wie z.B. Slack oder IRC für gelegentliche Gespräche, Zusammenarbeit und schnellen Austausch.

## So finden Sie ein Projekt, zu dem Sie beitragen können

Sie haben gelernt, wie Open-Source-Projekte funktionieren. Jetzt ist es an der Zeit, ein Projekt zum Beitragen zu finden!

Wenn Sie noch nie zu Open Source beigetragen haben, nehmen Sie einen Ratschlag von US-Präsident John F. Kennedy an, der einmal sagte: _"Fragen Sie nicht, was Ihr Land für Sie tun kann - fragen Sie, was Sie für Ihr Land tun können".

Zu Open Source können Sie auf allen möglichen Ebenen beitragen, in allen möglichen Projekten. Sie müssen nicht darüber nachdenken, was genau Ihr erster Beitrag sein wird oder wie er aussehen wird.

Denken Sie stattdessen zunächst über die Projekte nach, die Sie bereits verwenden oder verwenden möchten. Nach dieser Logik könnten dies die Projekte werden, zu denen Sie aktiv beitragen werden.

Innerhalb dieser Projekte, wann immer Sie sich denken, dass etwas besser oder anders sein könnte, handeln Sie nach Ihrem Instinkt.

Open Source ist kein exklusiver Club, sondern besteht auf Leuten wie Ihnen. "Open Source" ist nur ein schicker Begriff, um die Probleme der Welt als behebbar zu begreifen.

Sie können eine README überfliegen und einen defekten Link oder einen Tippfehler finden. Oder Sie sind ein\*e neue\*r Benutzer\*in und haben bemerkt, dass etwas kaputt ist, oder ein Problem, das Ihrer Meinung nach wirklich dokumentiert sein sollte. Anstatt es zu ignorieren und weiterzuziehen oder jemand zu bitten, es zu reparieren, können Sie vielleicht selbst mitmachen und mithelfen. Das ist des Pudels Kern bei Open Source!

> [28% der Gelegenheitsbeiträge](https://www.igor.pro.br/publica/papers/saner2016.pdf) zu Open Source betreffen die Dokumentation (z.B. eine Korrektur der Rechtschreibung oder Formatierung, oder das Schreiben einer Übersetzung).
>
> [28% of casual contributions](https://www.igor.pro.br/publica/papers/saner2016.pdf) to open source are documentation, such as a typo fix, reformatting, or writing a translation.

Auf einer der folgenden Seiten können Sie neue Projekte zum Beitragen entdecken (alle englischsprachig):

* [GitHub Explore](https://github.com/explore/)
* [Open Source Friday](https://opensourcefriday.com)
* [First Timers Only](http://www.firsttimersonly.com/)
* [CodeTriage](https://www.codetriage.com/)
* [24 Pull Requests](https://24pullrequests.com/)
* [Up For Grabs](http://up-for-grabs.net/)
* [Contributor-ninja](https://contributor.ninja)

### Eine Checkliste, bevor Sie einen Beitrag leisten

Wenn Sie ein Projekt gefunden haben, zu dem Sie beitragen möchten, prüfen Sie kurz, ob das Projekt Ihren Beitrag wahrscheinlich annehmen wird oder nicht. Sonst wird Ihre harte Arbeit vielleicht nicht fruchten.

Hier ist eine praktische Checkliste, um zu beurteilen, ob ein Projekt für neue Mitwirkende geeignet ist.

**Erfüllt die Definition von Open Source**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">

  Hat es eine Lizenz? In der Regel finden Sie diese in einer Datei namens LICENSE im Hauptordner.

  _Does it have a license? Usually, this is a file called LICENSE in the root of the repository._

  </label>
</div>

**Das Projekt nimmt aktiv Beiträge entgegen**

Sehen Sie sich die Commit-Aktivität auf dem Master-Branch an. Auf GitHub können Sie diese Informationen auf der Repository-Hauptsite sehen.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">

  Wann gab es den letzten Commit?

  _When was the latest commit?_

  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">

  Wie viele Mitwirkende hat das Projekt?

  _How many contributors does the project have?_

  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">

  Wie oft engagieren sich Menschen? (Auf GitHub finden Sie diese Information, indem Sie in der oberen Leiste auf "Commits" klicken.)

  _How often do people commit? (On GitHub, you can find this by clicking "Commits" in the top bar.)_

  </label>
</div>

Schauen Sie sich als nächstes die Issues des Projekts an.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">

    Wie viele Issues sind offen?

    _How many open issues are there?_

  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">

    Reagieren die Maintainer\*innen schnell auf neu erstellte Issues?

    _Do maintainers respond quickly to issues when they are opened?_

  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">

    Werden Issues aktiv diskutiert?

    _Is there active discussion on the issues?_

  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">

    Sind die Issues aktuell?

    _Are the issues recent?_

  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">

    Werden Issues auch wieder geschlossen? (Klicken Sie bei GitHub auf der Seite "Issues" auf "closed", um geschlossene Issues zu sehen.)

    _Are issues getting closed? (On GitHub, click the "closed" tab on the Issues page to see closed issues.)_

  </label>
</div>

Führen Sie nun die selben Schritte für die Pull Requests des Projekts durch.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">

    Wie viele Pull Requests gibt es?

    _How many open pull requests are there?_

  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">

    Reagieren die Maintainer\*innen schnell auf neu erstellte Pull Requests?

    _Do maintainers respond quickly to pull requests when they are opened?_

  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">

    Werden Pull Requests aktiv diskutiert?

    _Is there active discussion on the pull requests?_

  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">

    Sind die Pull Requests aktuell?

    _Are the pull requests recent?_

  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">

    Wie kürzlich wurden Pull Requests ge-merged? (Klicken Sie bei GitHub auf der "Pull Requests"-Seite auf "closed", um geschlossene PRs zu sehen).

    _How recently were any pull requests merged? (On GitHub, click the "closed" tab on the Pull Requests page to see closed PRs.)_

  </label>
</div>

**Das Projekt ist einladend**

Ein Projekt, das freundlich und einladend ist, signalisiert Offenheit gegenüber neuen Mitwirkenden.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">

    Antworten die Maintainer\*innen auf eine hilfsbereite Art und Weise auf Issues?

    _Do the maintainers respond helpfully to questions in issues?_

  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">

    Gehen Leute in den Issues, im Diskussionsforum oder Chat (z.B. IRC oder Slack) freundlich miteinander um?

    _Are people friendly in the issues, discussion forum, and chat (for example, IRC or Slack)?_

  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">

    Werden Pull Requests begutachtet?

    _Do pull requests get reviewed?_

  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">

    Danken die Maintainer\*innen den Beitragenden?

    _Do maintainers thank people for their contributions?_

  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">

  Wann immer Sie einen langen Diskussionsbeitrag sehen, überprüfen Sie die Antworten der Core-Entwickler, die spät in die Diskussion einsteigen. Fassen sie konstruktiv zusammen und unternehmen Schritte, um die Diskussion zu einer Entscheidung zu führen, und bleiben sie dabei höflich? Wenn du viele Flame Wars siehst, zeigt dies an, dass Energie im Streit verschwendet wird, anstatt in die Entwicklung gesteckt zu werden.

  _Whenever you see a long thread, spot check responses from core developers coming late in the thread. Are they summarizing constructively, and taking steps to bring the thread to a decision while remaining polite? If you see a lot of flame wars going on, that's often a sign that energy is going into argument instead of into development._

  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](http://producingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## Wie man einen Beitrag einreicht

Sie haben ein Projekt gefunden, das Ihnen gefällt, und sind zum Leisten eines Beitrags bereit? Endlich! So erreichen Sie dies auf die richtige Art und Weise.

### Effektive Kommunikation

Unabhängig davon, ob Sie ein\*e einmalige\*r Beitragende\*r sind oder versuchen, einer Gemeinschaft beizutreten, ist die Zusammenarbeit mit anderen eine der wichtigsten Fähigkeiten, die Sie bei der Open-Source-Arbeit entwickeln werden.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shubheksha?s=180" class="pquote-avatar" alt="avatar">

  \[Als neue Kontributorin,\] wurde mir schnell klar, dass ich Fragen stellen musste, wenn ich ein Problem lösen wollte. Ich habe den Quellcode durchgelesen. Sobald ich ein Gefühl für dessen Abläufe hatte, bat ich um mehr Orientierung. Und voilà! Ich war in der Lage, das Problem zu lösen, nachdem ich alle relevanten Details erhalten hatte, die ich brauchte.

  _\[As a new contributor,\] I quickly realized I had to ask questions if I wanted to be able to close the issue. I skimmed through the code base. Once I had some sense of what was going on, I asked for more direction. And voilà! I was able to solve the issue after getting all the relevant details I needed._

  <p markdown="1" class="pquote-credit">
— @shubheksha, [A Beginner's Very Bumpy Journey Through The World of Open Source](https://medium.freecodecamp.com/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39)
  </p>
</aside>

Bevor Sie ein Issue oder Pull Request aufmachen oder eine Frage im Chat stellen, sollten Sie diese Punkte im Hinterkopf behalten, damit Ihre Ideen effektiv rüberkommen.

**Erklären Sie den Kontext.** Bringen Sie andere schnell auf den neuesten Stand. Wenn Sie auf einen Fehler stoßen, erklären Sie, was Sie zu tun versuchen und wie Sie ihn reproduzieren können. Wenn Sie eine neue Idee vorschlagen, erklären Sie deren Nutzen für das Projekt (nicht nur für Sie!).

> 😇 _"X funktioniert nicht, wenn ich Y tue"_
>
> 😢 _"X ist kaputt! Bitte reparieren!"_

**Machen Sie Ihre Hausaufgaben vorher.** Es ist OK, nichts zu wissen, aber zeigen Sie, dass Sie es versucht haben. Bevor Sie um Hilfe bitten, stellen Sie sicher, dass Sie die README, die Dokumentation, Issues (offene und geschlossene), die Mailingliste und das Internet nach einer Antwort durchsucht haben. Die Leute werden Lernversuche zu schätzen wissen.

> 😇 _"Ich bin mir nicht sicher, wie man X implementiert. Ich habe die Hilfeseiten überprüft, aber X dort nicht erwähnt gefunden."_
>
> 😢 _"Wie mache ich X?"_

**Halte Anfragen kurz und direkt.** Ähnlich wie das Senden einer E-Mail, erfordert jeder Beitrag, egal wie einfach oder hilfreich er ist, eine Überprüfung durch jemand anderen. Viele Projekte haben mehr eingehende Anfragen als helfende Personen. Seien Sie kurz und bündig. Sie erhöhen die Chance, dass Ihnen jemand helfen kann.

> 😇 _"Ich würde gerne eine API-Anleitung schreiben."_
>
> 😢 _"Ich fuhr neulich auf der Autobahn und hielt zum Tanken an, und dann hatte ich diese erstaunliche Idee für etwas, was wir tun sollten, aber bevor ich das erkläre, lass mich dir etwas zeigen..."_

**Kommuniziere öffentlich.** Obwohl es verlockend ist, sollten Sie sich nicht privat an Projektbetreuer\*innen wenden, es sei denn, Sie müssen vertrauliche Informationen weitergeben (z.B. ein Sicherheitsproblem oder eine schwere Verletzung des Verhaltenskodex). Vom öffentlichen Austausch können mehr Menschen lernen und profitieren. Diskussionen können an sich schon Beiträge zum Projekt sein.

> 😇 _(als Kommentar) "@-maintainer Hallo! Wie sollen wir dieses PR behandeln?"_
>
> 😢 _(als E-Mail) "Hallo, und t'schuldigung, dass ich per Mail schreibe, aber ich habe mich gefragt, ob Sie schon Zeit hatten, mein PR zu prüfen?"_

**Fragen stellen, ist OK (aber seien Sie geduldig!).** Jeder war irgendwann einmal neu im Projekt, und selbst erfahrene Mitwirkende müssen sich auf den neuesten Stand bringen, wenn sie sich ein neues Projekt ansehen. Ebenso sind selbst langjährige Maintainer\*innen nicht immer mit jedem Teil des Projekts vertraut. Zeigen Sie ihnen die gleiche Geduld, die Sie von ihnen erwarten würden.

> 😇 _"Danke, dass Sie sich diesen Fehler angesehen haben. Ich bin Ihren Ratschlägen gefolgt. Hier ist die Ausgabe."_
>
> 😢 _"Warum kannst Du mein Problem nicht lösen? Ist das nicht Dein Projekt?"_

**Respektieren Sie die Entscheidungen der Gemeinschaft.** Ihre Ideen könnten von den Prioritäten oder der Vision der Gemeinschaft abweichen. Diese gibt Ihnen vielleicht eine Rückmeldung oder beschließt, Ihre Idee nicht weiterzuverfolgen. Auch wenn Sie Kompromisse suchen und besprechen sollten, müssen die Maintainer\*innen mit einer Entscheidung länger leben als Sie selbst. Wenn Sie mit deren Richtung nicht einverstanden sind, können Sie jederzeit an Ihrem eigenen Fork arbeiten oder Ihr eigenes Projekt starten.

> 😇 _"Ich bin enttäuscht, dass Sie meinen Anwendungsfall nicht unterstützen können, aber ich verstehe Ihre Erläuterung, dass er nur einen kleinen Teil der Benutzer\*innen betrifft. Danke fürs Zuhören."_
>
> 😢 _"Warum unterstützen Sie meinen Anwendungsfall nicht? Das ist inakzeptabel!"_

**Vor allem: Bewahren Sie Stil.** Open Source besteht aus Menschen aus der ganzen Welt, die mit uns zusammenarbeiten. Nuancen gehen über Sprachen, Kulturen, Regionen und Zeitzonen hinweg verloren. Darüber hinaus erschwert die schriftliche Kommunikation die Vermittlung eines Tonfalls oder einer Stimmung. Nehmen Sie in Open-Source-Diskussionsn gute Absichten an. Es ist in Ordnung, eine Idee höflich zurückzuweisen, nach Kontext zu fragen oder Ihre Position genauer zu erklären. Versuchen Sie einfach, das Internet an einem besseren Ort zu verlassen, als wenn Sie es gefunden haben.

### Erfassen Sie den Kontext

Bevor Sie etwas tun, sollten Sie kurz sicherzustellen, dass Ihre Idee nicht schon an anderer Stelle besprochen wurde. Überfliegen Sie die README des Projekts, Issues (offen und geschlossen), die Mailingliste und Stack Overflow. Sie müssen nicht stundenlang alles durchgehen, aber eine schnelle Suche nach ein paar Schlüsselbegriffen bringt Sie weiter.

Wenn Sie Ihre Idee woanders nicht finden können, sind Sie bereit für den ersten Schritt. Wenn sich das Projekt auf GitHub befindet, werden Sie Ihre Idee vermutlich als Issue kommunizieren, oder ein Pull Request stellen:

* **Issues** sind wie ein Gespräch oder eine Diskussion.
* **Pull Requests** sind der Beginn der Arbeit an einer Lösung.
* **Eine unkomplizierte Kommunikation,** wie z.B. die Klärung einer Vorgehensweise oder Frage, versuchen Sie es in Stack Overflow, IRC, Slack oder anderen Chat-Kanälen, falls das Projekt über solche verfügt.

Bevor Sie ein Issue oder Pull Request öffnen, überprüfen Sie die Beitragsdokumentationen des Projekts (normalerweise eine Datei namens CONTRIBUTING, oder in der README), um zu verstehen, was in Anfragen erwünscht ist. Beispielsweise kann das Projekt verlangen, dass Sie einer Vorlage folgen oder Tests verwenden.

Wenn Sie einen substantiellen Beitrag leisten wollen, öffnen Sie eine Issue, bevor Sie daran arbeiten. Bevor Sie Arbeiten ausführen, die möglicherweise nicht angenommen werden, schauen Sie sich das Projekt lieber eine Weile an (auf GitHub, [auf "Watch" klicken](https://help.github.com/articles/watching-repositories/), um über alle Konversationen informiert zu werden), und lernen die Community-Mitglieder kennen.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gaearon?s=180" class="pquote-avatar" alt="avatar">

  Sie lernen <em>sehr viel</em>, wenn Sie ein von Ihnen genutztes Projekt, auf GitHub "watchen" und jedes Issue und PR lesen.

  _You'll learn <em>a lot</em> from taking a single project you actively use, "watching" it on GitHub and reading every issue and PR._

<p markdown="1" class="pquote-credit">
— @gaearon [on joining projects](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### Ein Issue erstellen

In der Regel sollten Sie in den folgenden Situationen ein Issue erstellen:

* Melden Sie einen Fehler, den Sie nicht selbst beheben können.
* Diskutieren Sie ein übergeordnetes Thema oder eine Idee (z.B. über die Community, Vision oder Regelungen des Projekts).
* Ein neues Feature oder eine andere Projektidee vorschlagen

Tipps für die Kommunikation zu Issues:

* **Wenn Sie ein offenes Issue sehen, das Sie in Angriff nehmen wollen,** kommentieren Sie dies und lassen Sie die Leute wissen, dass Sie am Ball. Auf diese Weise ist es weniger wahrscheinlich, dass jemand eine Arbeit doppelt macht.
* **Wenn ein Issue vor einer Weile geöffnet wurde,** ist es möglich, dass es woanders bearbeitet wird, oder bereits gelöst wurde. Daher bitten Sie um Bestätigung, bevor Sie mit der Arbeit beginnen.
* **Wenn Sie ein Issue geöffnet haben, aber die Antwort später selbst herausgefunden haben,** kommentieren Sie das Issue, um anderen Leuten die Antwort mitzuteilen. Schließen Sie danach das Issue. Auch die Dokumentation dieses Ergebnisses ist ein Beitrag zum Projekt.

### ein Pull Request erstellen

In den folgenden Situationen sollten Sie in der Regel ein Pull Request öffnen:

* Triviale Korrekturen einreichen (z.B. eines Tippfehlers, eines defekten Links oder eines offensichtlichen Fehlers)
* Beginn der Arbeit an einem Beitrag, um den Sie bereits gebeten wurden oder den Sie bereits in einem Issue diskutiert haben.

Ein Pull Request muss keine fertige Arbeit darstellen. Es ist in der Regel besser, es frühzeitig zu starten, damit andere zuschauen oder Feedback zu Ihrem Fortschritt geben können. Markieren Sie es einfach als "WIP" (Work in Progress) in der Betreffzeile. Sie können später jederzeit weitere Commits hinzufügen.

Wenn das Projekt auf GitHub läuft, können Sie hier ein Pull Request stellen:

* **[Forken Sie das Repository](https://guides.github.com/activities/forking/)** und klonen Sie es lokal. Verbinden Sie Ihr lokales mit dem ursprünglichen "upstream"-Repository, indem Sie es als Remote hinzufügen. Pullen Sie Änderungen von "upstream" möglichst oft, damit Sie auf dem Laufenden bleiben, und Konflikte beim Einreichen Ihres Pull Requests weniger wahrscheinlich werden. ([detailliertere Anweisungen finden Sie hier](https://help.github.com/articles/syncing-a-fork/).)
* **[Erstellen Sie einen Branch](https://guides.github.com/introduction/flow/)** für Ihre Änderungen.
* **Verweisen Sie auf relevante Issues** oder unterstützende Dokumentation in Ihrem PR (z.B. "Closes #37").
* **Fügen Sie Vorher-/Nachher-Bildschirmfotos hinzu**, wenn Ihre Änderungen Unterschiede in HTML/CSS enthalten. Ziehen Sie die Bilder per Drag & Drop in den Textkörper Ihres Pull Requests.
* **Testen Sie Ihre Änderungen!** Führen Sie vorhandene Tests aus und erstellen bei Bedarf neue. Egal ob es Tests gibt oder nicht, stellen Sie sicher, dass Ihre Änderungen das bestehende Projekt nicht brechen.
* **Tragen Sie im Stil des Projekts bei,** nach bestem Wissen und Gewissen. Dies kann bedeuten, dass Sie Einrückungen, Semikolons oder Kommentare anders verwenden als in Ihrem eigenen Repository, aber es erleichtert dem oder der Betreuer\*in das Zusammenführen, und anderen das Verständnis und die Pflege in der Zukunft.

Wenn dies Ihr erstes Pull Request ist, sehen Sie sich [Make a Pull Request](http://makeapullrequest.com/) an, die @kentcdodds als Video-Tutorial erstellt hat. Sie können auch üben, ein Pull Request in @Roshanjossey\s "[First Contributions](https://github.com/Roshanjossey/first-contributions)"-Repository zu erstellen.

## Was passiert, nachdem Sie einen Beitrag eingereicht haben?

Geschafft! Herzlichen Glückwunsch, dass Sie zu einem Open-Source-Projekt beigetragen haben. Wir hoffen, dass weitere folgen.

Nachdem Sie einen Beitrag eingereicht haben, tritt einer der folgenden Fälle ein:

### 😭 Sie erhalten keine Antwort.

Hoffentlich haben Sie [das Projekt auf Anzeichen von Aktivität überprüft](#eine-checkliste-bevor-sie-einen-beitrag-leisten), bevor Sie einen Beitrag leisten. Auch bei einem aktiven Projekt kann es jedoch vorkommen, dass Ihr Beitrag keine Resonanz findet.

Wenn Sie seit über einer Woche keine Antwort erhalten haben, ist es fair, nachzuhaken und höflich jemanden um eine Rezension zu bitten. Wenn Sie den Namen der richtigen Person kennen, um Ihren Beitrag zu überprüfen, können Sie sie oder ihn mit einem `@` erwähnen.

Kontaktieren Sie diese Person **nicht** privat, denn öffentliche Kommunikation ist für Open-Source-Projekte unerlässlich.

Wenn Sie höflich nachhaken und trotzdem niemand antwortet, könnte dies für immer so bleiben. Es ist kein gutes Gefühl, aber lassen Sie sich davon nicht entmutigen. Sowas passiert allen mal! Es gibt viele mögliche Gründe und Umstände, die außerhalb Ihrer Kontrolle liegen, und die eine Antwort an Sie verhindert haben könnten. Versuchen Sie, ein anderes Projekt oder einen anderen Weg zu finden, um einen Beitrag zu leisten. Genau darum ist es ein guter Grund, nicht zu viel Zeit in Beiträge zu investieren, bevor nicht andere Mitglieder des Projektes auf Sie reagieren.

### 🚧 Jemand wünscht Änderungen an Ihrem Beitrag.

Es ist üblich, dass Sie aufgefordert werden, Änderungen an Ihrem Beitrag vorzunehmen, z.B. bezüglich des Umfangs Ihrer Idee oder bezüglich Ihres Code.

Wenn jemand Änderungen vorschlägt, reagieren Sie darauf. Der- oder diejenige hat sich die Zeit genommen, Ihren Beitrag zu überprüfen. Ein Pull Request zu eröffnen aber nicht weiterzuverfolgen, ist schlechter Stil. Wenn Sie nicht wissen, wie Sie Änderungen vornehmen sollen, recherchieren Sie dies und bitten um Hilfe, wenn Sie sie brauchen.

Wenn Sie keine Zeit mehr haben, an dem Problem zu arbeiten (zum Beispiel, wenn das Thema seit Monaten vor sich hin brodelt aber sich Ihre Umstände geändert haben), lassen Sie es den Maintainer\*in wissen, damit sie oder er keine Antwort erwartet. Vielleicht übernimmt jemand anderes Ihren Pull Request.

### 👎 Ihr Beitrag wird nicht angenommen.

Ihr Beitrag kann schlussendlich akzeptiert werden oder auch nicht. Hoffentlich haben Sie nicht schon zu viel Arbeit investiert. Wenn Sie nicht sicher sind, warum es nicht akzeptiert wurde, ist es durchaus sinnvoll, die oder den Maintainer\*in um Rückmeldung und Erläuterung zu bitten. Letztendlich müssen Sie jedoch deren Entscheidung respektieren. Werden Sie nicht ausfallend. Sie haben immer die Möglichkeit, an Ihrem eigenen Fork des Projektes zu arbeiten, wenn Sie mit dem Original nicht einverstanden sind!

### 🎉 Ihr Beitrag wird angenommen.

Hurra! Sie haben erfolgreich einen Open-Source-Beitrag geleistet!

## Sie haben es geschafft!

Egal, ob Sie gerade Ihren ersten Open-Source-Beitrag geleistet haben oder nach neuen Beitragsmöglichkeiten suchen: Wir hoffen, Sie zum Mitmachen motiviert zu haben. Selbst wenn Ihr Beitrag nicht angenommen wurde, vergessen Sie nicht, sich zu bedanken, wenn ein\*e Projektbetreuer\*in sich bemüht hat, Ihnen zu helfen. Open Source wird von Leuten wie Ihnen gemacht: Issue für Issue, Pull Request für Pull Request, usw., oder auch mal alle Neune auf einmal.
