---
lang: de
title: Ihr Verhaltenskodex
description: Fördern Sie ein gesundes und konstruktives Miteinander durch die Festlegung und Durchsetzung eines Verhaltenskodex.
class: coc
order: 8
image: /assets/images/cards/coc.png
related:
  - building
  - leadership
---

## Warum brauche ich einen Verhaltenskodex?

Ein Verhaltenskodex ist ein Dokument, das die Erwartungen an das Verhalten der Projektteilnehmer\*innen festlegt. Einen Verhaltenskodex festzulegen und durchzusetzen, kann dazu beitragen, eine positive soziale Atmosphäre für Ihre Community zu schaffen.

Verhaltenskodizes schützen nicht nur Ihre Teilnehmer\*innen, sondern auch Sie selbst. Wenn Sie ein Projekt pflegen, werden Sie vielleicht feststellen, dass unproduktive Einstellungen von anderen dazu führen können, dass Sie sich im Laufe der Zeit ausgelaugt oder unglücklich über Ihre Arbeit fühlen.

Ein Verhaltenskodex bevollmächtigt Sie, ein gesundes, konstruktives Miteinander zu fördern. Proaktiv zu sein, verringert die Wahrscheinlichkeit, dass Sie oder andere projektmüde werden, und hilft Ihnen, Maßnahmen gegen unerwünschtes Verhalten zu ergreifen.

## Einen Verhaltenskodex festlegen

Versuchen Sie, so früh wie möglich einen Verhaltenskodex festzulegen: idealerweise, sobald Sie Ihr Projekt starten.

Neben der Klarstellung Ihrer Erwartungen beschreibt ein Verhaltenskodex Folgendes:

* Wo er gilt _(nur für Issue und Pull Requests oder auch bei Community-Veranstaltungen?)_
* Für wen er gilt _(Community-Mitglieder und Maintainer\*innen; Aber was ist mit den Sponsor\*innen?)_
* Was passiert, wenn jemand gegen ihn verstößt
* Wie jemand Verstöße melden kann

Wo immer Sie können, nutzen Sie Vorhandenes. Der [Contributor Covenant](https://contributor-covenant.org/) ist ein Verhaltenskodex, der von über 40.000 Open-Source-Projekten wie Kubernetes, Rails und Swift verwendet wird.

Der [Django-Verhaltenskodex](https://www.djangoproject.com/conduct/) und der [Citizen Code of Conduct](http://citizencodeofconduct.org/) sind ebenfalls zwei gute Beispiele.

Legen Sie eine CODE_OF_CONDUCT-Datei in das Stammverzeichnis Ihres Projekts und machen Sie sie für Ihre Community sichtbar, indem Sie sie von Ihrer CONTRIBUTING- oder README-Datei verlinken.

## Entscheiden, wie Sie Ihren Verhaltenskodex durchsetzen.

<aside markdown="1" class="pquote">

  Ein Verhaltenskodex, der nicht durchgesetzt wird (oder werden kann), ist schlimmer als gar kein Verhaltenskodex: Er sendet die Botschaft, dass die Werte des Verhaltenskodex in Ihrer Community nicht wirklich wichtig oder respektiert werden.

  _A code of conduct that isn't (or can't be) enforced is worse than no code of conduct at all: it sends the message that the values in the code of conduct aren't actually important or respected in your community._

  <p markdown="1" class="pquote-credit">
— [Ada Initiative](https://adainitiative.org/2014/02/18/howto-design-a-code-of-conduct-for-your-community/)
  </p>
</aside>

Sie sollten erklären, wie Ihr Verhaltenskodex durchgesetzt wird, **_bevor_** es zu einem Verstoß kommt. Dafür gibt es mehrere Gründe:

* Es zeigt, dass Sie es mit Maßnahmen ernst meinen, wenn sie gebraucht werden.

* Ihre Community wird sich sicherer fühlen, dass Beschwerden tatsächlich geprüft werden.

* Sie vergewissern Ihre Community, dass der Überprüfungsprozess fair und transparent ist, sollte es jemals zu einem Verstoß kommen.

Sie sollten Leuten einen privaten Weg (z.B. eine E-Mail-Adresse) geben, um einen Verstoß gegen den Verhaltenskodex zu melden und erklären, wer diesen Bericht erhält. Es kann ein\*e Maintainer\*in, eine Gruppe von Maintainer\*innen oder eine Verhaltenskodex-Arbeitsgruppe sein.

Vergessen Sie nicht, dass jemand einen Verstoß über eine Person melden können möchte, die diese Berichte erhält. Bieten Sie in diesem Fall die Möglichkeit, Verstöße an eine andere Person zu melden. @ctb und @mr-c zum Beispiel [erklären zu ihrem Projekt](https://github.com/dib-lab/khmer/blob/master/CODE_OF_CONDUCT.rst), [khmer](https://github.com/dib-lab/khmer):

> Fälle von missbräuchlichem, belästigendem oder anderweitig inakzeptablem Verhalten können per E-Mail an **khmer-project@idyll.org** gemeldet werden, die nur an C. Titus Brown und Michael R. Crusoe geht. Um ein Problem zu melden, das einen von ihnen betrifft, senden Sie bitte eine E-Mail an **Judi Brown Clarke, Ph.D.** den Diversity Director am BEACON Center for the Study of Evolution in Action, einem NSF Center for Science and Technology.*
>
> Instances of abusive, harassing, or otherwise unacceptable behavior may be reported by emailing **khmer-project@idyll.org** which only goes to C. Titus Brown and Michael R. Crusoe. To report an issue involving either of them please email **Judi Brown Clarke, Ph.D.** the Diversity Director at the BEACON Center for the Study of Evolution in Action, an NSF Center for Science and Technology.*

Django's [Enforcement Manual](https://www.djangoproject.com/conduct/enforcement-manual/) dürfte für Sie eine gute Vorlage liefern, auch wenn Sie für ein kleineres Projekt vielleicht weniger umfassende Regeln benötigen.

## Durchsetzung Ihres Verhaltenskodexes

Manchmal wird jemand trotz Ihrer Bemühungen etwas tun, das gegen diesen Kodex verstößt. Es gibt mehrere Möglichkeiten, negatives oder schädliches Verhalten zu bekämpfen, wenn es auftritt.

### Sammeln Sie Informationen über die Situation.

Nehmen Sie jede Stimme aus der Community so wichtig wie Ihre eigene. Wenn Sie einen Bericht erhalten, dass jemand gegen den Verhaltenskodex verstoßen hat, nehmen Sie ihn oder sie ernst und untersuchen Sie die Angelegenheit, auch wenn sie nicht Ihren eigenen Erfahrungen mit dieser Person entspricht. Damit signalisieren Sie Ihrer Gemeinschaft, dass Sie ihre Perspektive schätzen und ihrem Urteilsvermögen vertrauen.

Das betroffene Community-Mitglied kann ein\*e Wiederholungstäter\*in sein, der oder die anderen immer wieder Ärger bereitet, oder es hat nur einmal etwas gesagt oder getan. Beides kann je nach Kontext Anlass zum Handeln sein.

Bevor Sie antworten, geben Sie sich Zeit, um zu verstehen, was passiert ist. Lesen Sie die bisherigen Kommentare und Gespräche der Person durch, um besser zu verstehen, wer es ist und warum sie oder er so gehandelt haben könnten. Versuchen Sie, andere Perspektiven als Ihre eigenen über diese Person und ihr Verhalten zu sammeln.

<aside markdown="1" class="pquote">

  Lassen Sie sich nicht in einen Streit hineinziehen. Lassen Sie sich nicht von Jemandes Verhalten von der Abwicklung einer Sache ablenken. Konzentrieren Sie sich auf das, was Sie brauchen.

  _Don't get pulled into an argument. Don't get sidetracked into dealing with someone else's behavior before you've finished dealing with the matter at hand. Focus on what you need._

  <p markdown="1" class="pquote-credit">
— Stephanie Zvan, ["So You've Got Yourself a Policy. Now What?"](https://the-orbit.net/almostdiamonds/2014/04/10/so-youve-got-yourself-a-policy-now-what/)
  </p>
</aside>

### Ergreifen Sie geeignete Maßnahmen

Nachdem Sie genügend Informationen gesammelt und verstanden haben, müssen Sie entscheiden, was zu tun ist. Denken Sie bei Ihren nächsten Schritten daran, dass es Ihr Ziel als Moderator\*in ist, eine sichere, respektvolle und kollaborative Umgebung zu fördern. Überlegen Sie nicht nur, wie Sie mit dieser Situation umgehen, sondern auch, wie sich Ihre Reaktion auf das Verhalten und die Erwartungen Ihrer Community auswirken könnte.

Wenn jemand einen Verstoß gegen einen Verhaltenskodex meldet, sind Sie gefragt, nicht die Community. Manchmal enthüllt die oder der Meldende Informationen, die eine große Gefahr für Karriere, Ruf oder körperliche Unversehrtheit darstellen. Sie oder ihn zu zwingen, den Gemeldeten zu konfrontieren, könnte eine kompromittierende Situation erzeugen. Sie sollten die direkte Kommunikation mit der gemeldeten Person übernehmen, es sei denn, die oder der Meldende verlangt ausdrücklich etwas anderes.

Es gibt einige Möglichkeiten, wie Sie auf einen Verstoß gegen den Verhaltenskodex reagieren können:

* **Geben Sie der betreffenden Person eine öffentliche Warnung** und erklären Sie, wie sich sein oder ihr Verhalten negativ auf andere ausgewirkt hat. Nutzen Sie dafür vorzugsweise den Kommunikationskanal, auf dem das schädliche Verhalten aufgetreten ist. Öffentliche Kommunikation zeigt dem Rest der Gemeinschaft, dass Sie den Verhaltenskodex ernst nehmen. Seien Sie freundlich, aber bestimmt.

* **Privat auf die betreffende Person zugehen**, um zu erklären, wie sich ihr oder sein Verhalten negativ auf andere ausgewirkt hat. Sie können einen privaten Kommunikationskanal verwenden, wenn es sich um sensible persönliche Daten handelt. Wenn Sie mit jemandem privat kommunizieren, setzen Sie die meldende Person darüber in Kenntnis. Aber setzen Sie sie bei E-Mails nicht ohne Erlaubnis in CC.

Manchmal kann keine Lösung erreicht werden. Die gemeldete Person kann aggressiv oder feindselig werden, wenn er oder sie damit konfrontiert wird oder das Verhalten nicht ändert. In dieser Situation sollten Sie vielleicht stärkere Maßnahmen in Betracht ziehen. Zum Beispiel:

* **zeitweise Suspendierung** in Form eines vorübergehenden Verbots, sich an den Aspekten des Projekts zu beteiligen.

* Die Person **dauerhaft aus dem Projekt verbannen**.

Projektteilnehmer\*innen auszuschließen, sollte nicht auf die leichte Schulter genommen werden, da es eine permanente und unvereinbare Meinungsverschiedenheit darstellt. Sie sollten diese Maßnahmen nur ergreifen, wenn klar ist, dass eine Lösung nicht möglich ist.

## Ihre Verantwortung als Maintainerin

Ein Verhaltenskodex sollte nicht willkürlich durchgesetzt werden. Sie sind der oder die Vollstrecker\*in des Verhaltenskodexes und es ist Ihre Verantwortung, diese Regeln auch zu befolgen.

Als Maintainer\*in legen Sie die Richtlinien für Ihre Community fest und setzen diese durch. Dies bedeutet, dass jeder Bericht über einen Verstoß gegen den Verhaltenskodex ernst genommen wird. Dem oder der Beschwerdeführer\*in ist eine gründliche und faire Prüfung geschuldet. Wenn Sie feststellen, dass das gemeldete Verhalten kein Verstoß ist, stellen Sie dies klar und erklären Sie, warum Sie nichts dagegen unternehmen werden. Die Reaktion der meldenden Person ist eine andere Sache: das nur persönlich als problematisch empfundene Verhalten zu tolerieren oder die Projekt-Community zu verlassen.

Ein gemeldetes Verhalten, das _genau genommen nicht_ gegen den Verhaltenskodex verstößt, kann dennoch auf ein Problem in Ihrer Gemeinschaft hinweisen. Sie sollten dieses potenzielle Problem untersuchen und entsprechend handeln. Dies kann die Überarbeitung Ihres Verhaltenskodex umfassen, um akzeptables Verhalten zu klären und/oder mit der Person zu sprechen, deren Verhalten gemeldet wurde. In diesem Falle stellen Sie klar, dass sie oder er vielleicht nicht konkret gegen den Verhaltenskodex verstoßen hat, aber den Rand des Akzeptablen erreicht haben, und andere Teilnehmer\*innen sich unwohl fühlen.

Letztendlich setzen Sie als Maintainer\*in die Standards für akzeptables Verhalten (durch). Sie haben die Fähigkeit, die Gemeinschaftswerte des Projekts zu gestalten. Die Teilnehmer\*innen erwarten, dass Sie diese Werte auf faire und ausgewogene Weise durchsetzen.

## Fördern Sie das Verhalten, das Sie in der Welt sehen wollen 🌎

Wenn ein Projekt feindselig oder unwillkommen erscheint, und wenn auch nur durch das von Anderen tolerierte Verhalten einer einzelnen Person, riskieren Sie den Verlust vieler weiterer Mitwirkender. Es ist nicht immer einfach, einen Verhaltenskodex anzunehmen oder durchzusetzen, aber die Förderung einer einladenden Umgebung wird Ihrer Gemeinschaft helfen, zu wachsen.
