//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//============================================================================
// Example: uniform uncertainty visualization
//
#include <vtkm/cont/Initialize.h>
#include <vtkm/filter/uncertainty/ContourUncertainUniform.h>
#include <vtkm/io/VTKDataSetReader.h>
#include <vtkm/io/VTKDataSetWriter.h>

int main(int argc, char** argv)
{
  auto opts = vtkm::cont::InitializeOptions::DefaultAnyDevice;
  vtkm::cont::InitializeResult config = vtkm::cont::Initialize(argc, argv, opts);

  //vtkm::io::VTKDataSetReader reader("/Users/n5j/Desktop/supernova_visit_400_400_400_ReduceMinMax.vtk");
  vtkm::io::VTKDataSetReader reader("/Users/n5j/Desktop/beetle_496_832_832_ReduceMinMax.vtk");
  vtkm::cont::DataSet ds_from_file = reader.ReadDataSet();

  vtkm::filter::uncertainty::ContourUncertainUniform filter;
  filter.SetIsoValue(900);
  filter.SetCrossProbabilityName("CrossProbablity");
  filter.SetNumberNonzeroProbabilityName("NonzeroProbablity");
  filter.SetEntropyName("Entropy");
  filter.SetMinField("ensemble_min");
  filter.SetMaxField("ensemble_max");
  vtkm::cont::DataSet ds = filter.Execute(ds_from_file);

  vtkm::io::VTKDataSetWriter writer("/Users/n5j/Desktop/out_beetle_visit_Result.vtk");
  //vtkm::io::VTKDataSetWriter writer("/Users/n5j/Desktop/out_supernova_visit.vtk");
  writer.WriteDataSet(ds);

  return 0;
}
