//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//============================================================================
// Example: uniform uncertainty visualization
//
#include <vtkm/cont/ArrayHandle.h>
#include <vtkm/cont/Field.h>
#include <vtkm/cont/Initialize.h>
#include <vtkm/filter/uncertainty/ContourUncertainUniform.h>
#include <vtkm/filter/uncertainty/UniformMC.h>
#include <vtkm/io/VTKDataSetReader.h>
#include <vtkm/io/VTKDataSetWriter.h>

int main(int argc, char** argv)
{
  auto opts = vtkm::cont::InitializeOptions::DefaultAnyDevice;
  vtkm::cont::InitializeResult config = vtkm::cont::Initialize(argc, argv, opts);

  vtkm::io::VTKDataSetReader reader(
    "/Users/nrushadjoshi/Desktop/beetle_496_832_832_ReduceMinMax.vtk");
  vtkm::cont::DataSet ds_from_file_mc = reader.ReadDataSet();

  // Monte Carlo
  vtkm::filter::uncertainty::UniformMC filter_mc;
  filter_mc.SetIsoValue(900);
  filter_mc.SetCrossProbabilityName("CrossProbablityMC");
  filter_mc.SetNumberNonzeroProbabilityName("NonCrossProbablity");
  filter_mc.SetEntropyName("Entropy");
  filter_mc.SetMinField("ensemble_min");
  filter_mc.SetMaxField("ensemble_max");
  vtkm::cont::DataSet ds_mc = filter_mc.Execute(ds_from_file_mc);

  vtkm::io::VTKDataSetWriter writer_mc(
    "/Users/nrushadjoshi/Desktop/out_beetle_visit_Result_mc_500.vtk");
  writer_mc.WriteDataSet(ds_mc);

  vtkm::cont::DataSet ds_from_file = reader.ReadDataSet();
  // Closed form
  vtkm::filter::uncertainty::ContourUncertainUniform filter;
  filter.SetIsoValue(900);
  filter.SetCrossProbabilityName("CrossProbablity");
  filter.SetNumberNonzeroProbabilityName("NonzeroProbablity");
  filter.SetEntropyName("Entropy");
  filter.SetMinField("ensemble_min");
  filter.SetMaxField("ensemble_max");
  vtkm::cont::DataSet ds = filter.Execute(ds_from_file);

  vtkm::io::VTKDataSetWriter writer("/Users/nrushadjoshi/Desktop/out_beetle_visit_Result.vtk");
  writer.WriteDataSet(ds);

  //std::cout << "check 1" << std::endl;

  // vtkm::cont::Field CrossProb = ds.GetField("CrossProbablity");
  // vtkm::cont::Field CrossProbMC = ds_mc.GetField("CrossProbablityMC");

  // //std::cout << "check 2" << std::endl;

  // vtkm::cont::ArrayHandle<vtkm::Float64> crossProbArray;
  // CrossProb.GetData().AsArrayHandle(crossProbArray);

  // vtkm::cont::ArrayHandle<vtkm::Float64> crossProbArrayMC;
  // CrossProbMC.GetData().AsArrayHandle(crossProbArrayMC);

  // //std::cout << "check 3" << std::endl;
  // // Create a portal for reading elements
  // vtkm::cont::ArrayHandle<vtkm::Float64>::ReadPortalType portal = crossProbArray.ReadPortal();
  // vtkm::cont::ArrayHandle<vtkm::Float64>::ReadPortalType portalMC = crossProbArrayMC.ReadPortal();
  // // Iterate through the elements of the crossProbArray using a for loop
  // for (vtkm::Id i = 0; i < crossProbArray.GetNumberOfValues(); ++i)
  // {
  //   vtkm::FloatDefault value = portal.Get(i);
  //   vtkm::FloatDefault valueMC = portalMC.Get(i);
  //   // Do something with the value, e.g., print it
  //   //std::cout << "Element at index " << i << ": " << value << std::endl;
  //   //std::cout << "Element at index " << i << ": " << valueMC << std::endl;
  //   if (value > valueMC)
  //   {
  //     if ((value - valueMC) > 0.05)
  //     {
  //       std::cout << "Error: Not expected" << std::endl;
  //     }
  //   }
  //   else
  //   {
  //     if ((valueMC - value) > 0.05)
  //     {
  //       std::cout << "Error: Not expected" << std::endl;
  //     }
  //   }
  // }
  return 0;
}
