include(RunCMake)

function(run_cmake_intdir_strategy base strategy kind)
  if (kind STREQUAL "Object")
    set(varname "CMAKE_INTERMEDIATE_DIR_STRATEGY")
  elseif (kind STREQUAL "Autogen")
    set(varname "CMAKE_AUTOGEN_INTERMEDIATE_DIR_STRATEGY")
  else ()
    message(FATAL_ERROR "unsupported kind: ${kind}")
  endif ()
  unset(ENV{${varname}})

  if (base STREQUAL "IntDirStrategyCache")
    set(RunCMake_TEST_OPTIONS -D${varname}=${strategy})
  elseif (base STREQUAL "IntDirStrategyEnv")
    set(ENV{${varname}} "${strategy}")
  else ()
    message(FATAL_ERROR "unsupported base: ${base}")
  endif ()
  set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/${kind}${base}${strategy}-build)
  run_cmake(${kind}${base}${strategy})
endfunction()

foreach (kind IN ITEMS Object Autogen)
  foreach (strategy IN ITEMS INVALID FULL SHORT)
    run_cmake_intdir_strategy(IntDirStrategyCache ${strategy} ${kind})
    run_cmake_intdir_strategy(IntDirStrategyEnv ${strategy} ${kind})
  endforeach ()
endforeach ()
