## vtkDataSet: GetCellTypes updates

`vtkDataSet`'s method `void GetCellTypes(vtkCellTypes* types)`, has been deprecated in favor of
`void GetDistinctCellTypes(vtkCellTypes* types)`.

`vtkCartesianGrid` subclasses (`vtkImageData`, `vtkRectilinearGrid`) and `vtkStructuredGrid`'s method
`vtkConstantArray<int>* GetCellTypesArray()` has been deprecated in favor of `vtkConstantUnsignedCharArray
GetCellTypes()`.

`vtkUnstructuredGrid`'s method `vtkUnsignedCharArray* GetCellTypesArray()` has been deprecated in favor of
`vtkDataArray* GetCellTypes()`, which is templated to allow returning other arrays, such as
`vtkUnsignedCharArray* GetCellTypes<vtkUnsignedCharArray>()` or
`vtkConstantUnsignedCharArray* GetCellTypes<vtkConstantUnsignedCharArray>()`.

This was done to enable storing the cell types of meshes with only 1 cell type as `vtkConstantUnsignedCharArray` instead
of `vtkUnsignedCharArray`, which saves memory.

It should be noted that due to this change, a cell types array generated by a VTKm filter can now also be stored in
`vtkUnstructuredGrid` as `vtkmDataArray` without needing to copy the data to `vtkUnsignedCharArray`.

Additionally, the majority of VTK filters that were generating single cell type cells have been updated to use
`vtkConstantUnsignedCharArray` to save memory.
