// This file is part of OpenMVG, an Open Multiple View Geometry C++ library.

// Copyright (c) 2015 Pierre Moulon.

// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

#ifndef OPENMVG_CAMERAS_CAMERAS_HPP
#define OPENMVG_CAMERAS_CAMERAS_HPP

#include "openMVG/cameras/Camera_Common.hpp"
#include "openMVG/cameras/Camera_Intrinsics.hpp"
#include "openMVG/cameras/Camera_Pinhole.hpp"
#include "openMVG/cameras/Camera_Pinhole_Radial.hpp"
#include "openMVG/cameras/Camera_Pinhole_Brown.hpp"
#include "openMVG/cameras/Camera_Pinhole_Fisheye.hpp"
#include "openMVG/cameras/Camera_Spherical.hpp"
#include "openMVG/cameras/Camera_undistort_image.hpp"

namespace openMVG
{
/**
* @brief Namespace handling various Camera classes and functions
*/
namespace cameras
{

} // namespace cameras
} // namespace openMVG


#endif // OPENMVG_CAMERAS_CAMERAS_HPP
