/*=========================================================================

   Library: iMSTK

   Copyright (c) Kitware, Inc. & Center for Modeling, Simulation,
   & Imaging in Medicine, Rensselaer Polytechnic Institute.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0.txt

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

=========================================================================*/

#pragma once

#include "imstkSolverBase.h"

#include <memory>
#include <vector>
#include <unordered_map>

namespace imstk
{
class SPHObject;
class SPHModel;
///
/// \class SPHSolver
///
class SPHSolver : public SolverBase
{
public:
    ///
    /// \brief Constructor
    ///
    SPHSolver() = default;

    ///
    /// \brief Prohibit copying
    ///
    SPHSolver(const SPHSolver& other) = delete;
    SPHSolver& operator=(const SPHSolver& other) = delete;

    ///
    /// \brief Add an SPH object into solver
    /// Particles of all SPH objects added to the same SPH solver will interact with each other
    ///
    void addSPHObject(const std::shared_ptr<SPHObject>& sphObject);

    ///
    /// \brief Remove an SPH object from solver
    /// The removed object can still exist in the system and can be added to another SPH solver for running further simulation
    ///
    void removeSPHObject(const std::shared_ptr<SPHObject>& sphObject);

    ///
    /// \brief Advance one time step
    ///
    virtual void solve() override;

private:
    std::vector<std::shared_ptr<SPHModel>> m_vSPHModels;       ///< Set of SPH models in the solver
    std::unordered_map<SPHModel*, size_t>  m_mSPHModelToIndex; ///< Map from SPH model to index of the model in the model set above
};
} // end namespace imstk
