/*=========================================================================

   Library: iMSTK

   Copyright (c) Kitware, Inc. & Center for Modeling, Simulation,
   & Imaging in Medicine, Rensselaer Polytechnic Institute.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0.txt

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

=========================================================================*/

#pragma once

#include "imstkDynamicObject.h"
#include "imstkDynamicalModel.h"
#include "imstkSPHState.h"

namespace imstk
{
class SPHModel;
///
/// \class SPHObject
///
class SPHObject : public DynamicObject<SPHKinematicState>
{
public:
    ///
    /// \brief Constructor
    ///
    SPHObject(const std::string& name);

    ///
    /// \brief Set dynamical model and cast the private SPH model
    ///
    virtual void setDynamicalModel(std::shared_ptr<DynamicalModel<SPHKinematicState>> model) override;

    ///
    /// \brief Initialize the SPH scene object
    ///
    bool initialize() override;

    ///
    /// \brief Get the SPH model of the object
    ///
    const std::shared_ptr<SPHModel>& getSPHModel() const { assert(m_SPHModel); return m_SPHModel; }

protected:
    std::shared_ptr<SPHModel> m_SPHModel;
};
} // end namespace imstk
