########################################################################
#
#       DO NOT CALL THIS DIRECTLY 
#       LET FindQt.cmake deside which FindQtX.cmake to include
#
#       Locates Qt4 include paths and libraries (called by FindQt.cmake)
#
########################################################################

# This module defines
# QT_INCLUDES                   ,list of paths to all include directories of Qt4
#
# QT_INCLUDE_DIR                ,path to "include" of Qt4
# QT_QT_INCLUDE_DIR             ,path to "include/Qt" of Qt4
# QT_QT3SUPPORT_INCLUDE_DIR     ,path to "include/Qt3Support" of Qt
# QT_QTASSISTANT_INCLUDE_DIR    ,path to "include/QtAssistant" of Qt4
# QT_QTCORE_INCLUDE_DIR         ,path to "include/QtCore" of Qt4        
# QT_QTDESIGNER_INCLUDE_DIR     ,path to "include/QtDesigner" of Qt4
# QT_QTGUI_INCLUDE_DIR          ,path to "include/QtGui" of Qt4
# QT_QTMOTIF_INCLUDE_DIR        ,path to "include/QtMotif" of Qt4
# QT_QTNETWORK_INCLUDE_DIR      ,path to "include/QtNetwork" of Qt4
# QT_QTNSPLUGIN_INCLUDE_DIR     ,path to "include/QtNsPlugin" of Qt4
# QT_QTOPENGL_INCLUDE_DIR       ,path to "include/QtOpenGL" of Qt4
# QT_QTSQL_INCLUDE_DIR          ,path to "include/QtSql" of Qt4
# QT_QTXML_INCLUDE_DIR          ,path to "include/QtXml" of Qt4
#
# QT_LIBRARIES                  ,list of path+filename of all optimized libs of Qt4
# QT_LIBRARIES_DEBUG            ,list of path+filename of all debug libs of Qt4
# QT_LIBRARIES_TRYOPTIMIZED     ,list of path+filename of all libs (try optimized, if not found try debug)
# QT_LIBRARIES_TRYDEBUG         ,list of path+filename of all libs (try debug, if not found try optimized)
# QT_LIBRARY_DIR                ,path to "lib" of Qt4
#
# QT_QT3SUPPORT_LIBRARY         ,path+filename for Qt3Support library of Qt4
# QT_QTASSISTANT_LIBRARY        ,path+filename for QtAssistant library of Qt4
# QT_QTCORE_LIBRARY             ,path+filename for QtCore library of Qt4        
# QT_QTDESIGNER_LIBRARY         ,path+filename for QtDesigner library of Qt4
# QT_QTGUI_LIBRARY              ,path+filename for QtGui library of Qt4
# QT_QTMOTIF_LIBRARY            ,path+filename for QtMotif library of Qt4
# QT_QTNETWORK_LIBRARY          ,path+filename for QtNetwork library of Qt4
# QT_QTNSPLUGIN_LIBRARY         ,path+filename for QtNsPlugin library of Qt4
# QT_QTOPENGL_LIBRARY           ,path+filename for QtOpenGL library of Qt4
# QT_QTSQL_LIBRARY              ,path+filename for QtSql library of Qt4
# QT_QTXML_LIBRARY              ,path+filename for QtXml library of Qt4
#
# QT_QT3SUPPORT_LIBRARY_DEBUG   ,path+filename for Qt3Support_debug library of Qt
# QT_QTASSISTANT_LIBRARY_DEBUG  ,path+filename for QtAssistant_debug library of Qt4
# QT_QTCORE_LIBRARY_DEBUG       ,path+filename for QtCore_debug library of Qt4  
# QT_QTDESIGNER_LIBRARY_DEBUG   ,path+filename for QtDesigner_debug library of Qt4
# QT_QTGUI_LIBRARY_DEBUG        ,path+filename for QtGui_debug library of Qt4
# QT_QTMOTIF_LIBRARY_DEBUG      ,path+filename for QtMotif_debug library of Qt4
# QT_QTNETWORK_LIBRARY_DEBUG    ,path+filename for QtNetwork_debug library of Qt4
# QT_QTNSPLUGIN_LIBRARY_DEBUG   ,path+filename for QtNsPlugin_debug library of Qt4
# QT_QTOPENGL_LIBRARY_DEBUG     ,path+filename for QtOpenGL_debug library of Qt4
# QT_QTSQL_LIBRARY_DEBUG        ,path+filename for QtSql_debug library of Qt4
# QT_QTXML_LIBRARY_DEBUG        ,path+filename for QtXml_debug library of Qt4
#
# QT_DEFINITIONS                ,definitions to use when compiling code that uses Qt.
# QT_FOUND                      ,If false, don't try to use Qt (depends on existence of QT_LIBRARY_DIR and QT_INCLUDE_DIR)
#
# also defined, but not for general use are
# QT_MOC_EXECUTABLE             ,where to find the moc tool.
# QT_UIC_EXECUTABLE             ,where to find the uic tool.
# QT_RCC_EXECUTABLE             ,where to find the rcc tool
#
# These are around for backwards compatibility 
# they will be set
# QT_WRAP_CPP                   ,set true if QT_MOC_EXECUTABLE is found
# QT_WRAP_UI                    ,set true if QT_UIC_EXECUTABLE is found
#
#
# These variables do _NOT_ have any effect anymore (compared to FindQt.cmake)
# QT_MT_REQUIRED                , Qt4 is now always multithreaded
#
# These variables are set to "" , because Qt structure changed (They make no sence in Qt4)
# QT_QT_LIBRARY                 , Qt-Library is now splitt into different parts
# QT_QTMAIN_LIBRARY             , Qt-Library is now splitt into different parts

########################################
#
#       Make sure nobody runs this 
#       script directly 
#       only FoundQt.cmake are allowed to
#
########################################
IF(NOT FOUNDQT_CALLED)
  MESSAGE( FATAL_ERROR "Never call FoundQt4.cmake directly. Use FoundQt.cmake.")
ENDIF(NOT FOUNDQT_CALLED)
########################################
#
#       Setting the INCLUDE-Variables
#
########################################
# Set QT_QT_INCLUDE_DIR by searching for qglobal.h
IF(NOT QT_QT_INCLUDE_DIR)
  IF(QT_QMAKE)
    EXEC_PROGRAM( qmake
      ARGS "-query QT_INSTALL_HEADERS" 
      OUTPUT_VARIABLE qt_headers )
  ENDIF(QT_QMAKE)
  FIND_PATH( QT_QT_INCLUDE_DIR qglobal.h
    ${qt_headers}/Qt
    $ENV{QTDIR}/include/Qt
    /usr/local/qt/include/Qt
    /usr/local/include/Qt
    /usr/lib/qt/include/Qt
    /usr/include/Qt
    /usr/share/qt4/include/Qt
    C:/Progra~1/qt/include/Qt
    /usr/include/qt4/Qt)
ENDIF(NOT QT_QT_INCLUDE_DIR)

# Set QT_INCLUDE_DIR by removine "/Qt" in the string ${QT_QT_INCLUDE_DIR}
IF(NOT QT_INCLUDE_DIR)
  IF( QT_QT_INCLUDE_DIR AND NOT QT_INCLUDE_DIR)
    STRING( REGEX REPLACE "/Qt$" "" qt4_include_dir ${QT_QT_INCLUDE_DIR})
    SET( QT_INCLUDE_DIR ${qt4_include_dir})
  ELSE( QT_QT_INCLUDE_DIR AND NOT QT_INCLUDE_DIR)
    IF( NOT Qt_FIND_QUIETLY AND Qt_FIND_REQUIRED) 
      MESSAGE( SEND_ERROR "Could not find qglobal.h")
    ENDIF( NOT Qt_FIND_QUIETLY AND Qt_FIND_REQUIRED)
  ENDIF( QT_QT_INCLUDE_DIR AND NOT QT_INCLUDE_DIR)
ENDIF(NOT QT_INCLUDE_DIR)

# Set QT_QT3SUPPORT_INCLUDE_DIR
IF(NOT QT_QT3SUPPORT_INCLUDE_DIR)
  FIND_PATH( QT_QT3SUPPORT_INCLUDE_DIR Qt3Support ${QT_INCLUDE_DIR}/Qt3Support)
  IF( NOT QT_QT3SUPPORT_INCLUDE_DIR )
    IF( NOT Qt_FIND_QUIETLY) 
      MESSAGE( STATUS "Could not find ${QT_INCLUDE_DIR}/Qt3Support")
    ENDIF( NOT Qt_FIND_QUIETLY)
  ENDIF( NOT QT_QT3SUPPORT_INCLUDE_DIR )
ENDIF(NOT QT_QT3SUPPORT_INCLUDE_DIR)

# Set QT_QTASSISTANT_INCLUDE_DIR
IF(NOT QT_QTASSISTANT_INCLUDE_DIR)
  FIND_PATH( QT_QTASSISTANT_INCLUDE_DIR QtAssistant ${QT_INCLUDE_DIR}/QtAssistant)
  IF( NOT QT_QTASSISTANT_INCLUDE_DIR )
    IF( NOT Qt_FIND_QUIETLY) 
      MESSAGE( STATUS "Could not find ${QT_INCLUDE_DIR}/QtAssistant")
    ENDIF( NOT Qt_FIND_QUIETLY) 
  ENDIF( NOT QT_QTASSISTANT_INCLUDE_DIR )
ENDIF(NOT QT_QTASSISTANT_INCLUDE_DIR)

# Set QT_QTCORE_INCLUDE_DIR
IF(NOT QT_QTCORE_INCLUDE_DIR)
  FIND_PATH( QT_QTCORE_INCLUDE_DIR QtCore ${QT_INCLUDE_DIR}/QtCore)
  IF( NOT QT_QTCORE_INCLUDE_DIR )
    IF( NOT Qt_FIND_QUIETLY) 
      MESSAGE( STATUS "Could not find ${QT_INCLUDE_DIR}/QtCore")
    ENDIF( NOT Qt_FIND_QUIETLY) 
  ENDIF( NOT QT_QTCORE_INCLUDE_DIR )
ENDIF(NOT QT_QTCORE_INCLUDE_DIR)

# Set QT_QTDESIGNER_INCLUDE_DIR
IF(NOT QT_QTDESIGNER_INCLUDE_DIR)
  FIND_PATH( QT_QTDESIGNER_INCLUDE_DIR QtDesigner ${QT_INCLUDE_DIR}/QtDesigner)
  IF( NOT QT_QTDESIGNER_INCLUDE_DIR )
    IF( NOT Qt_FIND_QUIETLY) 
      MESSAGE( STATUS "Could not find ${QT_INCLUDE_DIR}/QtDesigner")
    ENDIF( NOT Qt_FIND_QUIETLY) 
  ENDIF( NOT QT_QTDESIGNER_INCLUDE_DIR )
ENDIF(NOT QT_QTDESIGNER_INCLUDE_DIR)

# Set QT_QTGUI_INCLUDE_DIR
IF(NOT QT_QTGUI_INCLUDE_DIR)
  FIND_PATH( QT_QTGUI_INCLUDE_DIR QtGui ${QT_INCLUDE_DIR}/QtGui)
  IF( NOT QT_QTGUI_INCLUDE_DIR )
    IF( NOT Qt_FIND_QUIETLY) 
      MESSAGE( STATUS "Could not find ${QT_INCLUDE_DIR}/QtGui")
    ENDIF( NOT Qt_FIND_QUIETLY) 
  ENDIF( NOT QT_QTGUI_INCLUDE_DIR )
ENDIF(NOT QT_QTGUI_INCLUDE_DIR)

# Set QT_QTMOTIF_INCLUDE_DIR
IF(NOT QT_QTMOTIF_INCLUDE_DIR)
  FIND_PATH( QT_QTMOTIF_INCLUDE_DIR QtMotif ${QT_INCLUDE_DIR}/QtMotif)
  IF( NOT QT_QTMOTIF_INCLUDE_DIR )
    IF( NOT Qt_FIND_QUIETLY) 
      MESSAGE( STATUS "Could not find ${QT_INCLUDE_DIR}/QtMotif")
    ENDIF( NOT Qt_FIND_QUIETLY) 
  ENDIF( NOT QT_QTMOTIF_INCLUDE_DIR )
ENDIF(NOT QT_QTMOTIF_INCLUDE_DIR)

# Set QT_QTNETWORK_INCLUDE_DIR
IF(NOT QT_QTNETWORK_INCLUDE_DIR)
  FIND_PATH( QT_QTNETWORK_INCLUDE_DIR QtNetwork ${QT_INCLUDE_DIR}/QtNetwork)
  IF( NOT QT_QTNETWORK_INCLUDE_DIR )
    IF( NOT Qt_FIND_QUIETLY) 
      MESSAGE( STATUS "Could not find ${QT_INCLUDE_DIR}/QtNetwork")
    ENDIF( NOT Qt_FIND_QUIETLY) 
  ENDIF( NOT QT_QTNETWORK_INCLUDE_DIR )
ENDIF(NOT QT_QTNETWORK_INCLUDE_DIR)

# Set QT_QTNSPLUGIN_INCLUDE_DIR
IF(NOT QT_QTNSPLUGIN_INCLUDE_DIR)
  FIND_PATH( QT_QTNSPLUGIN_INCLUDE_DIR QtNsPlugin ${QT_INCLUDE_DIR}/QtNsPlugin)
  IF( NOT QT_QTNSPLUGIN_INCLUDE_DIR )
    IF( NOT Qt_FIND_QUIETLY)
      MESSAGE( STATUS "Could not find ${QT_INCLUDE_DIR}/QtNsPlugin")
    ENDIF( NOT Qt_FIND_QUIETLY) 
  ENDIF( NOT QT_QTNSPLUGIN_INCLUDE_DIR )
ENDIF(NOT QT_QTNSPLUGIN_INCLUDE_DIR)

# Set QT_QTOPENGL_INCLUDE_DIR
IF(NOT QT_QTOPENGL_INCLUDE_DIR)
  FIND_PATH( QT_QTOPENGL_INCLUDE_DIR QtOpenGL ${QT_INCLUDE_DIR}/QtOpenGL)
  IF( NOT QT_QTOPENGL_INCLUDE_DIR )
    IF( NOT Qt_FIND_QUIETLY)
      MESSAGE( STATUS "Could not find ${QT_INCLUDE_DIR}/QtOpenGL")
    ENDIF( NOT Qt_FIND_QUIETLY) 
  ENDIF( NOT QT_QTOPENGL_INCLUDE_DIR )
ENDIF(NOT QT_QTOPENGL_INCLUDE_DIR)

# Set QT_QTSQL_INCLUDE_DIR
IF(NOT QT_QTSQL_INCLUDE_DIR)
  FIND_PATH( QT_QTSQL_INCLUDE_DIR QtSql ${QT_INCLUDE_DIR}/QtSql)
  IF( NOT QT_QTSQL_INCLUDE_DIR )
    IF( NOT Qt_FIND_QUIETLY)
      MESSAGE( STATUS "Could not find ${QT_INCLUDE_DIR}/QtSql")
    ENDIF( NOT Qt_FIND_QUIETLY)
  ENDIF( NOT QT_QTSQL_INCLUDE_DIR )
ENDIF(NOT QT_QTSQL_INCLUDE_DIR)


# Set QT_QTXML_INCLUDE_DIR
IF(NOT QT_QTXML_INCLUDE_DIR)
  FIND_PATH( QT_QTXML_INCLUDE_DIR QtXml ${QT_INCLUDE_DIR}/QtXml)
  IF( NOT QT_QTXML_INCLUDE_DIR )
    IF( NOT Qt_FIND_QUIETLY)
      MESSAGE( STATUS "Could not find ${QT_INCLUDE_DIR}/QtXml")
    ENDIF( NOT Qt_FIND_QUIETLY)
  ENDIF( NOT QT_QTXML_INCLUDE_DIR )
ENDIF(NOT QT_QTXML_INCLUDE_DIR)

# Make variables changeble to the advanced user
MARK_AS_ADVANCED(
  QT_INCLUDE_DIR 
  QT_QT_INCLUDE_DIR 
  QT_QT3SUPPORT_INCLUDE_DIR 
  QT_QTASSISTANT_INCLUDE_DIR 
  QT_QTCORE_INCLUDE_DIR 
  QT_QTDESIGNER_INCLUDE_DIR 
  QT_QTGUI_INCLUDE_DIR 
  QT_QTMOTIF_INCLUDE_DIR 
  QT_QTNETWORK_INCLUDE_DIR 
  QT_QTNSPLUGIN_INCLUDE_DIR 
  QT_QTOPENGL_INCLUDE_DIR 
  QT_QTSQL_INCLUDE_DIR 
  QT_QTXML_INCLUDE_DIR
  )

# Set QT_INCLUDES
SET( QT_INCLUDES
  ${QT_INCLUDE_DIR} 
  ${QT_QT_INCLUDE_DIR} 
  ${QT_QT3SUPPORT_INCLUDE_DIR} 
  ${QT_QTASSISTANT_INCLUDE_DIR} 
  ${QT_QTCORE_INCLUDE_DIR} 
  ${QT_QTDESIGNER_INCLUDE_DIR} 
  ${QT_QTGUI_INCLUDE_DIR} 
  ${QT_QTMOTIF_INCLUDE_DIR} 
  ${QT_QTNETWORK_INCLUDE_DIR} 
  ${QT_QTNSPLUGIN_INCLUDE_DIR} 
  ${QT_QTOPENGL_INCLUDE_DIR} 
  ${QT_QTSQL_INCLUDE_DIR} 
  ${QT_QTXML_INCLUDE_DIR} )


########################################
#
#       Setting the LIBRARY-Variables
#
########################################
IF(NOT QT_QTCORE_LIBRARY) 
  IF(QT_QMAKE)
    EXEC_PROGRAM( qmake
      ARGS "-query QT_INSTALL_LIBS" 
      OUTPUT_VARIABLE qt_libs )
  ENDIF(QT_QMAKE)
  # Set QT_QTCORE_LIBRARY  by searching for a lib with "QtCore." as part of the filename
  FIND_LIBRARY(  QT_QTCORE_LIBRARY
    NAMES QtCore 
    PATHS 
    ${qt_libs}
    $ENV{QTDIR}/lib
    /usr/local/qt/lib
    /usr/local/lib
    /usr/lib/qt/lib
    /usr/lib
    /usr/share/qt4/lib
    C:/Progra~1/qt/lib
    /usr/lib/qt4 )
ENDIF(NOT QT_QTCORE_LIBRARY)

# Set QT_QTCORE_LIBRARY_DEBUG by searching for a lib with "QtCore_debug" as part of the filename
IF(NOT QT_QTCORE_LIBRARY_DEBUG)
  IF(QT_QMAKE)
    EXEC_PROGRAM( qmake
      ARGS "-query QT_INSTALL_LIBS" 
      OUTPUT_VARIABLE qt_libs )
  ENDIF(QT_QMAKE)
  FIND_LIBRARY(  QT_QTCORE_LIBRARY_DEBUG
    NAMES QtCore_debug
    PATHS 
    ${qt_libs}
    $ENV{QTDIR}/lib
    /usr/local/qt/lib
    /usr/local/lib
    /usr/lib/qt/lib
    /usr/lib
    /usr/share/qt4/lib
    C:/Progra~1/qt/lib
    /usr/lib/qt4 )
ENDIF(NOT QT_QTCORE_LIBRARY_DEBUG)

# Set QT_LIBRARY_DIR
IF(NOT QT_LIBRARY_DIR)
  IF( QT_QTCORE_LIBRARY  )
    STRING(REGEX MATCH "[^/]*$" qt_qtcore "${QT_QTCORE_LIBRARY}")
    STRING(REGEX REPLACE "/${qt_qtcore}" "" QT_LIBRARY_DIR "${QT_QTCORE_LIBRARY}")
  ELSE( QT_QTCORE_LIBRARY  )
    IF( QT_QTCORE_LIBRARY_DEBUG )
      STRING(REGEX MATCH "[^/]*$" qt_qtcore_debug "${QT_QTCORE_LIBRARY_DEBUG}")
      STRING(REGEX REPLACE "/${qt_qtcore_debug}" "" QT_LIBRARY_DIR "${QT_QTCORE_LIBRARY_DEBUG}")
    ENDIF( QT_QTCORE_LIBRARY_DEBUG )
  ENDIF( QT_QTCORE_LIBRARY  )
ENDIF(NOT QT_LIBRARY_DIR)


# Set QT_QT3SUPPORT_LIBRARY
IF(NOT QT_QT3SUPPORT_LIBRARY)
  FIND_LIBRARY(QT_QT3SUPPORT_LIBRARY  Qt3Support ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QT3SUPPORT_LIBRARY)
IF(NOT QT_QT3SUPPORT_LIBRARY_DEBUG)
  FIND_LIBRARY(QT_QT3SUPPORT_LIBRARY_DEBUG Qt3Support_debug ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QT3SUPPORT_LIBRARY_DEBUG)

# Set QT_QTASSISTANT_LIBRARY
IF(NOT QT_QTASSISTANT_LIBRARY)
  FIND_LIBRARY(QT_QTASSISTANT_LIBRARY  QtAssistant ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QTASSISTANT_LIBRARY)
IF(NOT QT_QTASSISTANT_LIBRARY_DEBUG)
  FIND_LIBRARY(QT_QTASSISTANT_LIBRARY_DEBUG QtAssistant_debug ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QTASSISTANT_LIBRARY_DEBUG)

# Set QT_QTDESIGNER_LIBRARY
IF(NOT QT_QTDESIGNER_LIBRARY)
  FIND_LIBRARY(QT_QTDESIGNER_LIBRARY  QtDesigner ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QTDESIGNER_LIBRARY)
IF(NOT QT_QTDESIGNER_LIBRARY_DEBUG)
  FIND_LIBRARY(QT_QTDESIGNER_LIBRARY_DEBUG QtDesigner_debug ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QTDESIGNER_LIBRARY_DEBUG)

# Set QT_QTGUI_LIBRARY
IF(NOT QT_QTGUI_LIBRARY)
  FIND_LIBRARY(QT_QTGUI_LIBRARY  QtGui ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QTGUI_LIBRARY)
IF(NOT QT_QTGUI_LIBRARY_DEBUG)
  FIND_LIBRARY(QT_QTGUI_LIBRARY_DEBUG QtGui_debug ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QTGUI_LIBRARY_DEBUG)

# Set QT_QTMOTIF_LIBRARY
IF(NOT QT_QTMOTIF_LIBRARY)
  FIND_LIBRARY(QT_QTMOTIF_LIBRARY  QtMotif ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QTMOTIF_LIBRARY)
IF(NOT QT_QTMOTIF_LIBRARY_DEBUG)
  FIND_LIBRARY(QT_QTMOTIF_LIBRARY_DEBUG QtMotif_debug ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QTMOTIF_LIBRARY_DEBUG)

# Set QT_QTNETWORK_LIBRARY
IF(NOT QT_QTNETWORK_LIBRARY)
  FIND_LIBRARY(QT_QTNETWORK_LIBRARY  QtNetwork ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QTNETWORK_LIBRARY)
IF(NOT QT_QTNETWORK_LIBRARY_DEBUG)
  FIND_LIBRARY(QT_QTNETWORK_LIBRARY_DEBUG QtNetwork_debug ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QTNETWORK_LIBRARY_DEBUG)

# Set QT_QTNSPLUGIN_LIBRARY
IF(NOT QT_QTNSPLUGIN_LIBRARY)
  FIND_LIBRARY(QT_QTNSPLUGIN_LIBRARY  QtNsPlugin ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QTNSPLUGIN_LIBRARY)
IF(NOT QT_QTNSPLUGIN_LIBRARY_DEBUG)
  FIND_LIBRARY(QT_QTNSPLUGIN_LIBRARY_DEBUG QtNsPlugin_debug ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QTNSPLUGIN_LIBRARY_DEBUG)

# Set QT_QTOPENGL_LIBRARY
IF(NOT QT_QTOPENGL_LIBRARY)
  FIND_LIBRARY(QT_QTOPENGL_LIBRARY  QtOpenGL ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QTOPENGL_LIBRARY)
IF(NOT QT_QTOPENGL_LIBRARY_DEBUG)
  FIND_LIBRARY(QT_QTOPENGL_LIBRARY_DEBUG QtOpenGL_debug ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QTOPENGL_LIBRARY_DEBUG)

# Set QT_QTSQL_LIBRARY
IF(NOT QT_QTSQL_LIBRARY)
  FIND_LIBRARY(QT_QTSQL_LIBRARY  QtSql ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QTSQL_LIBRARY)
IF(NOT QT_QTSQL_LIBRARY_DEBUG)
  FIND_LIBRARY(QT_QTSQL_LIBRARY_DEBUG QtSql_debug ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QTSQL_LIBRARY_DEBUG)

# Set QT_QTXML_LIBRARY
IF(NOT QT_QTXML_LIBRARY)
  FIND_LIBRARY(QT_QTXML_LIBRARY  QtXml ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QTXML_LIBRARY)
IF(NOT QT_QTXML_LIBRARY_DEBUG)
  FIND_LIBRARY(QT_QTXML_LIBRARY_DEBUG QtXml_debug ${QT_LIBRARY_DIR})
ENDIF(NOT QT_QTXML_LIBRARY_DEBUG)

# Make variables changeble to the advanced user
MARK_AS_ADVANCED(
  QT_QT3SUPPORT_LIBRARY 
  QT_QTASSISTANT_LIBRARY 
  QT_QTCORE_LIBRARY 
  QT_QTDESIGNER_LIBRARY 
  QT_QTGUI_LIBRARY 
  QT_QTMOTIF_LIBRARY 
  QT_QTNETWORK_LIBRARY 
  QT_QTNSPLUGIN_LIBRARY 
  QT_QTOPENGL_LIBRARY 
  QT_QTSQL_LIBRARY 
  QT_QTXML_LIBRARY )

# Set QT_LIBRARIES
SET( QT_LIBRARIES
  ${QT_QT3SUPPORT_LIBRARY} 
  ${QT_QTASSISTANT_LIBRARY} 
  ${QT_QTCORE_LIBRARY} 
  ${QT_QTDESIGNER_LIBRARY} 
  ${QT_QTGUI_LIBRARY} 
  ${QT_QTMOTIF_LIBRARY} 
  ${QT_QTNETWORK_LIBRARY} 
  ${QT_QTNSPLUGIN_LIBRARY} 
  ${QT_QTOPENGL_LIBRARY} 
  ${QT_QTSQL_LIBRARY} 
  ${QT_QTXML_LIBRARY} )

# Make variables changeble to the advanced user
MARK_AS_ADVANCED(
  QT_QT3SUPPORT_LIBRARY_DEBUG 
  QT_QTASSISTANT_LIBRARY_DEBUG 
  QT_QTCORE_LIBRARY_DEBUG 
  QT_QTDESIGNER_LIBRARY_DEBUG 
  QT_QTGUI_LIBRARY_DEBUG 
  QT_QTMOTIF_LIBRARY_DEBUG 
  QT_QTNETWORK_LIBRARY_DEBUG 
  QT_QTNSPLUGIN_LIBRARY_DEBUG 
  QT_QTOPENGL_LIBRARY_DEBUG 
  QT_QTSQL_LIBRARY_DEBUG 
  QT_QTXML_LIBRARY_DEBUG )

# Set QT_LIBRARIES_DEBUG
SET( QT_LIBRARIES_DEBUG
  ${QT_QT3SUPPORT_LIBRARY_DEBUG} 
  ${QT_QTASSISTANT_LIBRARY_DEBUG} 
  ${QT_QTCORE_LIBRARY_DEBUG} 
  ${QT_QTDESIGNER_LIBRARY_DEBUG} 
  ${QT_QTGUI_LIBRARY_DEBUG} 
  ${QT_QTMOTIF_LIBRARY_DEBUG} 
  ${QT_QTNETWORK_LIBRARY_DEBUG} 
  ${QT_QTNSPLUGIN_LIBRARY_DEBUG} 
  ${QT_QTOPENGL_LIBRARY_DEBUG} 
  ${QT_QTSQL_LIBRARY_DEBUG} 
  ${QT_QTXML_LIBRARY_DEBUG} )

# Set QT_LIBRARIES_TRYOPTIMIZED
IF(NOT QT_LIBRARIES_TRYOPTIMIZED)
  IF(QT_QT3SUPPORT_LIBRARY)
    SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QT3SUPPORT_LIBRARY} )
  ELSE(QT_QT3SUPPORT_LIBRARY)
    IF(QT_QT3SUPPORT_LIBRARY_DEBUG)
      SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QT3SUPPORT_LIBRARY_DEBUG} )      
    ENDIF(QT_QT3SUPPORT_LIBRARY_DEBUG)
  ENDIF(QT_QT3SUPPORT_LIBRARY)
  
  IF(QT_QTASSISTANT_LIBRARY)
    SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTASSISTANT_LIBRARY} )
  ELSE(QT_QTASSISTANT_LIBRARY)
    IF(QT_QTASSISTANT_LIBRARY_DEBUG)
      SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTASSISTANT_LIBRARY_DEBUG} )     
    ENDIF(QT_QTASSISTANT_LIBRARY_DEBUG)
  ENDIF(QT_QTASSISTANT_LIBRARY)
  
  IF(QT_QTCORE_LIBRARY)
    SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTCORE_LIBRARY} )
  ELSE(QT_QTCORE_LIBRARY)
    IF(QT_QTCORE_LIBRARY_DEBUG)
      SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTCORE_LIBRARY_DEBUG} )  
    ENDIF(QT_QTCORE_LIBRARY_DEBUG)
  ENDIF(QT_QTCORE_LIBRARY)
  
  IF(QT_QTDESIGNER_LIBRARY)
    SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTDESIGNER_LIBRARY} )
  ELSE(QT_QTDESIGNER_LIBRARY)
    IF(QT_QTDESIGNER_LIBRARY_DEBUG)
      SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTDESIGNER_LIBRARY_DEBUG} )      
    ENDIF(QT_QTDESIGNER_LIBRARY_DEBUG)
  ENDIF(QT_QTDESIGNER_LIBRARY)
  
  IF(QT_QTGUI_LIBRARY)
    SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTGUI_LIBRARY} )
  ELSE(QT_QTGUI_LIBRARY)
    IF(QT_QTGUI_LIBRARY_DEBUG)
      SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTGUI_LIBRARY_DEBUG} )   
    ENDIF(QT_QTGUI_LIBRARY_DEBUG)
  ENDIF(QT_QTGUI_LIBRARY)
  
  IF(QT_QTMOTIF_LIBRARY)
    SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTMOTIF_LIBRARY} )
  ELSE(QT_QTMOTIF_LIBRARY)
    IF(QT_QTMOTIF_LIBRARY_DEBUG)
      SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTMOTIF_LIBRARY_DEBUG} ) 
    ENDIF(QT_QTMOTIF_LIBRARY_DEBUG)
  ENDIF(QT_QTMOTIF_LIBRARY)
  
  IF(QT_QTNETWORK_LIBRARY)
    SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTNETWORK_LIBRARY} )
  ELSE(QT_QTNETWORK_LIBRARY)
    IF(QT_QTNETWORK_LIBRARY_DEBUG)
      SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTNETWORK_LIBRARY_DEBUG} )       
    ENDIF(QT_QTNETWORK_LIBRARY_DEBUG)
  ENDIF(QT_QTNETWORK_LIBRARY)
  
  IF(QT_QTNSPLUGIN_LIBRARY)
    SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTNSPLUGIN_LIBRARY} )
  ELSE(QT_QTNSPLUGIN_LIBRARY)
    IF(QT_QTNSPLUGIN_LIBRARY_DEBUG)
      SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTNSPLUGIN_LIBRARY_DEBUG} )      
    ENDIF(QT_QTNSPLUGIN_LIBRARY_DEBUG)
  ENDIF(QT_QTNSPLUGIN_LIBRARY)
  
  IF(QT_QTOPENGL_LIBRARY)
    SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTOPENGL_LIBRARY} )
  ELSE(QT_QTOPENGL_LIBRARY)
    IF(QT_QTOPENGL_LIBRARY_DEBUG)
      SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTOPENGL_LIBRARY_DEBUG} )        
    ENDIF(QT_QTOPENGL_LIBRARY_DEBUG)
  ENDIF(QT_QTOPENGL_LIBRARY)
  
  IF(QT_QTSQL_LIBRARY)
    SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTSQL_LIBRARY} )
  ELSE(QT_QTSQL_LIBRARY)
    IF(QT_QTSQL_LIBRARY_DEBUG)
      SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTSQL_LIBRARY_DEBUG} )   
    ENDIF(QT_QTSQL_LIBRARY_DEBUG)
  ENDIF(QT_QTSQL_LIBRARY)
  
  IF(QT_QTXML_LIBRARY)
    SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTXML_LIBRARY} )
  ELSE(QT_QTXML_LIBRARY)
    IF(QT_QTXML_LIBRARY_DEBUG)
      SET( QT_LIBRARIES_TRYOPTIMIZED ${QT_LIBRARIES_TRYOPTIMIZED} ${QT_QTXML_LIBRARY_DEBUG} )   
    ENDIF(QT_QTXML_LIBRARY_DEBUG)
  ENDIF(QT_QTXML_LIBRARY)
ENDIF(NOT QT_LIBRARIES_TRYOPTIMIZED)

# Set QT_LIBRARIES_TRYDEBUG
IF(NOT QT_LIBRARIES_TRYDEBUG)
  IF(QT_QT3SUPPORT_LIBRARY_DEBUG)
    SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QT3SUPPORT_LIBRARY_DEBUG} )
  ELSE(QT_QT3SUPPORT_LIBRARY_DEBUG)
    IF(QT_QT3SUPPORT_LIBRARY)
      SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QT3SUPPORT_LIBRARY} )    
    ENDIF(QT_QT3SUPPORT_LIBRARY)
  ENDIF(QT_QT3SUPPORT_LIBRARY_DEBUG)
  
  IF(QT_QTASSISTANT_LIBRARY_DEBUG)
    SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTASSISTANT_LIBRARY_DEBUG} )
  ELSE(QT_QTASSISTANT_LIBRARY_DEBUG)
    IF(QT_QTASSISTANT_LIBRARY)
      SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTASSISTANT_LIBRARY} )   
    ENDIF(QT_QTASSISTANT_LIBRARY)
  ENDIF(QT_QTASSISTANT_LIBRARY_DEBUG)
  
  IF(QT_QTCORE_LIBRARY_DEBUG)
    SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTCORE_LIBRARY_DEBUG} )
  ELSE(QT_QTCORE_LIBRARY_DEBUG)
    IF(QT_QTCORE_LIBRARY)
      SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTCORE_LIBRARY} )        
    ENDIF(QT_QTCORE_LIBRARY)
  ENDIF(QT_QTCORE_LIBRARY_DEBUG)
  
  IF(QT_QTDESIGNER_LIBRARY_DEBUG)
    SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTDESIGNER_LIBRARY_DEBUG} )
  ELSE(QT_QTDESIGNER_LIBRARY_DEBUG)
    IF(QT_QTDESIGNER_LIBRARY)
      SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTDESIGNER_LIBRARY} )    
    ENDIF(QT_QTDESIGNER_LIBRARY)
  ENDIF(QT_QTDESIGNER_LIBRARY_DEBUG)
  
  IF(QT_QTGUI_LIBRARY_DEBUG)
    SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTGUI_LIBRARY_DEBUG} )
  ELSE(QT_QTGUI_LIBRARY_DEBUG)
    IF(QT_QTGUI_LIBRARY)
      SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTGUI_LIBRARY} ) 
    ENDIF(QT_QTGUI_LIBRARY)
  ENDIF(QT_QTGUI_LIBRARY_DEBUG)
  
  IF(QT_QTMOTIF_LIBRARY_DEBUG)
    SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTMOTIF_LIBRARY_DEBUG} )
  ELSE(QT_QTMOTIF_LIBRARY_DEBUG)
    IF(QT_QTMOTIF_LIBRARY)
      SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTMOTIF_LIBRARY} )       
    ENDIF(QT_QTMOTIF_LIBRARY)
  ENDIF(QT_QTMOTIF_LIBRARY_DEBUG)
  
  IF(QT_QTNETWORK_LIBRARY_DEBUG)
    SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTNETWORK_LIBRARY_DEBUG} )
  ELSE(QT_QTNETWORK_LIBRARY_DEBUG)
    IF(QT_QTNETWORK_LIBRARY)
      SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTNETWORK_LIBRARY} )     
    ENDIF(QT_QTNETWORK_LIBRARY)
  ENDIF(QT_QTNETWORK_LIBRARY_DEBUG)
  
  IF(QT_QTNSPLUGIN_LIBRARY_DEBUG)
    SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTNSPLUGIN_LIBRARY_DEBUG} )
  ELSE(QT_QTNSPLUGIN_LIBRARY_DEBUG)
    IF(QT_QTNSPLUGIN_LIBRARY)
      SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTNSPLUGIN_LIBRARY} )    
    ENDIF(QT_QTNSPLUGIN_LIBRARY)
  ENDIF(QT_QTNSPLUGIN_LIBRARY_DEBUG)
  
  IF(QT_QTOPENGL_LIBRARY_DEBUG)
    SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTOPENGL_LIBRARY_DEBUG} )
  ELSE(QT_QTOPENGL_LIBRARY_DEBUG)
    IF(QT_QTOPENGL_LIBRARY)
      SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTOPENGL_LIBRARY} )      
    ENDIF(QT_QTOPENGL_LIBRARY)
  ENDIF(QT_QTOPENGL_LIBRARY_DEBUG)
  
  IF(QT_QTSQL_LIBRARY_DEBUG)
    SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTSQL_LIBRARY_DEBUG} )
  ELSE(QT_QTSQL_LIBRARY_DEBUG)
    IF(QT_QTSQL_LIBRARY)
      SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTSQL_LIBRARY} ) 
    ENDIF(QT_QTSQL_LIBRARY)
  ENDIF(QT_QTSQL_LIBRARY_DEBUG)
  
  IF(QT_QTXML_LIBRARY_DEBUG)
    SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTXML_LIBRARY_DEBUG} )
  ELSE(QT_QTXML_LIBRARY_DEBUG)
    IF(QT_QTXML_LIBRARY)
      SET( QT_LIBRARIES_TRYDEBUG ${QT_LIBRARIES_TRYDEBUG} ${QT_QTXML_LIBRARY} ) 
    ENDIF(QT_QTXML_LIBRARY)
  ENDIF(QT_QTXML_LIBRARY_DEBUG)
ENDIF(NOT QT_LIBRARIES_TRYDEBUG)


#######################################
#
#       Check the executables of Qt 
#          ( moc, uic, rcc )
#
#######################################
IF(NOT QT_MOC_EXECUTABLE)
  IF(QT_QMAKE)
    EXEC_PROGRAM( qmake
      ARGS "-query QT_INSTALL_BINS" 
      OUTPUT_VARIABLE qt_bins ) 
  ENDIF(QT_QMAKE)
  FIND_PROGRAM(QT_MOC_EXECUTABLE 
    NAMES moc
    PATHS
    ${qt_bins}
    $ENV{QTDIR}/bin
    /usr/local/qt/bin
    /usr/local/bin
    /usr/lib/qt/bin
    /usr/bin
    /usr/share/qt4/bin
    C:/Progra~1/qt/bin
    /usr/bin/qt4
    )
ENDIF(NOT QT_MOC_EXECUTABLE)

IF(QT_MOC_EXECUTABLE)
  SET ( QT_WRAP_CPP "YES")
ELSE(QT_MOC_EXECUTABLE)
ENDIF(QT_MOC_EXECUTABLE)

IF(NOT QT_UIC_EXECUTABLE )
  IF(QT_QMAKE)
    EXEC_PROGRAM( qmake
      ARGS "-query QT_INSTALL_BINS" 
      OUTPUT_VARIABLE qt_bins )
  ENDIF(QT_QMAKE)
  FIND_PROGRAM(QT_UIC_EXECUTABLE 
    NAMES uic
    PATHS
    ${qt_bins}
    $ENV{QTDIR}/bin
    /usr/local/qt/bin
    /usr/local/bin
    /usr/lib/qt/bin
    /usr/bin
    /usr/share/qt4/bin
    C:/Progra~1/qt/bin
    /usr/bin/qt4
    )
ENDIF(NOT QT_UIC_EXECUTABLE )

IF(QT_UIC_EXECUTABLE)
  SET ( QT_WRAP_UI "YES")
ELSE(QT_UIC_EXECUTABLE)
ENDIF(QT_UIC_EXECUTABLE)

IF(NOT QT_RCC_EXECUTABLE)
  IF(QT_QMAKE)
    EXEC_PROGRAM( qmake
      ARGS "-query QT_INSTALL_BINS" 
      OUTPUT_VARIABLE qt_bins )
  ENDIF(QT_QMAKE)
  FIND_PROGRAM(QT_RCC_EXECUTABLE 
    NAMES rcc
    PATHS
    ${qt_bins}
    $ENV{QTDIR}/bin
    /usr/local/qt/bin
    /usr/local/bin
    /usr/lib/qt/bin
    /usr/bin
    /usr/share/qt4/bin
    C:/Progra~1/qt/bin
    /usr/bin/qt4
    )
ENDIF(NOT QT_RCC_EXECUTABLE )

MARK_AS_ADVANCED(
  QT_UIC_EXECUTABLE
  QT_MOC_EXECUTABLE
  QT_RCC_EXECUTABLE )

######################################
#
#       deside if Qt got found
#
######################################
# if the includes,libraries,moc,uic and rcc are found then we have it
IF( QT_LIBRARY_DIR AND QT_INCLUDE_DIR AND QT_MOC_EXECUTABLE AND QT_UIC_EXECUTABLE AND QT_RCC_EXECUTABLE)
  SET( QT_FOUND "YES" )
  IF( NOT Qt_FIND_QUIETLY) 
    MESSAGE(STATUS "Found Qt-Version ${QT_INST_MAJOR_VERSION}.${QT_INST_MINOR_VERSION}.${QT_INST_PATCH_VERSION}")
  ENDIF( NOT Qt_FIND_QUIETLY) 
ELSE( QT_LIBRARY_DIR AND QT_INCLUDE_DIR AND QT_MOC_EXECUTABLE AND QT_UIC_EXECUTABLE AND QT_RCC_EXECUTABLE)
  SET( QT_FOUND "NO")
  IF( Qt_FIND_REQUIRED)
    MESSAGE( SEND_ERROR "Qt libraries, includes, moc, uic or/and rcc NOT found!")
  ENDIF( Qt_FIND_REQUIRED)
ENDIF( QT_LIBRARY_DIR AND QT_INCLUDE_DIR AND QT_MOC_EXECUTABLE AND QT_UIC_EXECUTABLE AND  QT_RCC_EXECUTABLE)


#######################################
#
#       System dependent settings  
#
#######################################
# for unix add X11 stuff
IF(UNIX)
  FIND_PACKAGE(X11)
  IF (X11_FOUND)
    SET (QT_LIBRARIES ${QT_LIBRARIES} ${X11_LIBRARIES})
  ENDIF (X11_FOUND)
  IF (CMAKE_DL_LIBS)
    SET (QT_LIBRARIES ${QT_LIBRARIES} ${CMAKE_DL_LIBS})
  ENDIF (CMAKE_DL_LIBS)
ENDIF(UNIX)


#######################################
#
#       compatibility settings 
#
#######################################
# Backwards compatibility for CMake1.4 and 1.2
SET (QT_MOC_EXE ${QT_MOC_EXECUTABLE} )
SET (QT_UIC_EXE ${QT_UIC_EXECUTABLE} )

SET( QT_DEFINITIONS "")
SET( QT_QT_LIBRARY "")
SET( QT_QTMAIN_LIBRARY "")

