# Nothing here yet

INCLUDE (${CMAKE_ROOT}/Modules/CheckSizeOf.cmake)
CHECK_TYPE_SIZE(int      CMAKE_SIZEOF_INT)
CHECK_TYPE_SIZE(long     CMAKE_SIZEOF_LONG)
CHECK_TYPE_SIZE("void*"  CMAKE_SIZEOF_VOID_P)
CHECK_TYPE_SIZE(char     CMAKE_SIZEOF_CHAR)
CHECK_TYPE_SIZE(short    CMAKE_SIZEOF_SHORT)
CHECK_TYPE_SIZE(float    CMAKE_SIZEOF_FLOAT)
CHECK_TYPE_SIZE(double   CMAKE_SIZEOF_DOUBLE)

INCLUDE (${CMAKE_ROOT}/Modules/CheckFunctionExists.cmake)
CHECK_FUNCTION_EXISTS(connect       CMAKE_HAVE_CONNECT)
CHECK_FUNCTION_EXISTS(remove        CMAKE_HAVE_REMOVE)

INCLUDE (${CMAKE_ROOT}/Modules/CheckLibraryExists.cmake)
CHECK_LIBRARY_EXISTS("nsl" "gethostbyname" "" CMAKE_HAVE_GETHOSTBYNAME)
CHECK_LIBRARY_EXISTS("ipc" "shmat" "" CMAKE_HAVE_GETHOSTBYNAME)

INCLUDE (${CMAKE_ROOT}/Modules/CheckIncludeFile.cmake)
CHECK_INCLUDE_FILE("limits.h"       CMAKE_HAVE_LIMITS_H)
CHECK_INCLUDE_FILE("unistd.h"       CMAKE_HAVE_UNISTD_H)
CHECK_INCLUDE_FILE("sys/prctl.h"    CMAKE_HAVE_SYS_PRCTL_H)
CHECK_INCLUDE_FILE("pthread.h"      CMAKE_HAVE_PTHREAD_H)

INCLUDE (${CMAKE_ROOT}/Modules/TestBigEndian.cmake)
TEST_BIG_ENDIAN(CMAKE_WORDS_BIGENDIAN)
