/*=========================================================================

  Program:   Insight Segmentation & Registration Toolkit
  Module:    $RCSfile$
  Language:  C++
  Date:      $Date$
  Version:   $Revision$

Copyright (c) 2001 Insight Consortium
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * The name of the Insight Consortium, nor the names of any consortium members,
   nor of any contributors, may be used to endorse or promote products derived
   from this software without specific prior written permission.

  * Modified source versions must be plainly marked as such, and must not be
    misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/
#include "cmGetFilenameComponentCommand.h"
#include "cmSystemTools.h"

// cmGetFilenameComponentCommand
bool cmGetFilenameComponentCommand::InitialPass(std::vector<std::string> const& args)
{
  if(args.size() < 3)
    {
    this->SetError("called with incorrect number of arguments");
    return false;
    }

  // Check and see if the value has been stored in the cache
  // already, if so use that value
  if(args.size() == 4 && args[3] == "CACHE")
    {
    const char* cacheValue = m_Makefile->GetDefinition(args[0].c_str());
    if(cacheValue && strcmp(cacheValue, "NOTFOUND"))
      {
      return true;
      }
    }
  
  std::string result;
  std::string filename = args[1];
  m_Makefile->ExpandVariablesInString(filename);

  if (args[2] == "PATH")
    {
    result = cmSystemTools::GetFilenamePath(filename);
    }
  else if (args[2] == "NAME")
    {
    result = cmSystemTools::GetFilenameName(filename);
    }
  else if (args[2] == "EXT")
    {
    result = cmSystemTools::GetFilenameExtension(filename);
    }
  else if (args[2] == "NAME_WE")
    {
    result = cmSystemTools::GetFilenameNameWithoutExtension(filename);
    }
  else 
    {
    std::string err = "unknow component " + args[2];
    this->SetError(err.c_str());
    return false;
    }

  if(args.size() == 4 && args[3] == "CACHE")
    {
    m_Makefile->AddCacheDefinition(args[0].c_str(),
                                   result.c_str(),
                                   "",
                                   args[2] == "PATH" ? cmCacheManager::FILEPATH
                                                     : cmCacheManager::STRING);
    }
  else 
    {
    m_Makefile->AddDefinition(args[0].c_str(), result.c_str());
    }

  return true;
}

