#!/usr/bin/python

import sys,os
import time

# Get the path to the directory containing this script.
if __name__ == '__main__':
    selfdir = os.path.abspath(sys.path[0] or os.curdir)
else:
    selfdir = os.path.abspath(os.path.dirname(__file__))

# Open the CMake code file.
fname = os.path.join(selfdir, 'kwsysDateStamp.cmake')
fout = open(fname, 'w');

# Get the current time.
ct = time.localtime()

# Write the CMake code describing the date.
fout.write("""# Do not edit!  Generated by kwsysDateStamp.py

# KWSys version date year component.  Format is CCYY.
SET(KWSYS_VERSION_DATE_YEAR  %04u)

# KWSys version date month component.  Format is MM.
SET(KWSYS_VERSION_DATE_MONTH %02u)

# KWSys version date day component.  Format is DD.
SET(KWSYS_VERSION_DATE_DAY   %02u)
""" % (ct.tm_year, ct.tm_mon, ct.tm_mday))

fout.close()
