/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.picking;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPickingSensorNodeType;
import org.web3d.vrml.renderer.common.nodes.picking.BasePickingNode;

public abstract class BaseLinePicker
extends BasePickingNode {
    protected static final int FIELD_PICKED_POINT = 9;
    protected static final int FIELD_PICKED_NORMAL = 10;
    protected static final int FIELD_PICKED_TEXCOORD = 11;
    protected static final int LAST_LINE_INDEX = 11;
    protected static final int NUM_FIELDS = 12;
    private static final String PICK_GEOM_MSG = "The pickGeometry type is invalid for LinePicker. It must be either LineSet or IndexedLineSet";
    protected static final String LINE_PROTO_MSG = "Proto does not describe a LineSet or IndexedLineSet object";
    protected static final String LINE_NODE_MSG = "Node does not describe a LineSet or IndexedLineSet object";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private float[] vfPickedPoint;
    private float[] vfPickedNormal;
    private float[] vfPickedTextureCoordinate;
    private int numPickedItems;

    public BaseLinePicker() {
        super("LinePicker", PICK_GEOM_MSG);
        this.hasChanged = new boolean[12];
        this.validGeometryNodeNames.add("LineSet");
        this.validGeometryNodeNames.add("IndexedLineSet");
    }

    public BaseLinePicker(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLPickingSensorNodeType)vRMLNodeType);
    }

    public int getPickingType() {
        return 2;
    }

    public void notifyPickStart(int n, VRMLNodeType[] vRMLNodeTypeArray, float[] fArray, float[] fArray2, float[] fArray3) {
        this.processCoordsOutput(n, fArray, fArray2, fArray3);
        super.notifyPickStart(n, vRMLNodeTypeArray, fArray, fArray2, fArray3);
    }

    public void notifyPickChange(int n, VRMLNodeType[] vRMLNodeTypeArray, float[] fArray, float[] fArray2, float[] fArray3) {
        this.processCoordsOutput(n, fArray, fArray2, fArray3);
        super.notifyPickChange(n, vRMLNodeTypeArray, fArray, fArray2, fArray3);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 11) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfPickedPoint;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numPickedItems;
                break;
            }
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfPickedNormal;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numPickedItems;
                break;
            }
            case 11: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfPickedTextureCoordinate;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numPickedItems;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfPickedPoint, this.numPickedItems * 3);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfPickedNormal, this.numPickedItems * 3);
                    break;
                }
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfPickedTextureCoordinate, this.numPickedItems * 2);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseLinePicker.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BaseLinePicker.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    private void processCoordsOutput(int n, float[] fArray, float[] fArray2, float[] fArray3) {
        if (this.intersectionType == 1) {
            return;
        }
        int n2 = n * 3;
        if (this.vfPickedPoint == null || this.vfPickedPoint.length < n2) {
            this.vfPickedPoint = new float[n2];
            this.vfPickedNormal = new float[n2];
            this.vfPickedTextureCoordinate = new float[n2];
        }
        System.arraycopy(fArray, 0, this.vfPickedPoint, 0, n2);
        System.arraycopy(fArray2, 0, this.vfPickedNormal, 0, n2);
        System.arraycopy(fArray3, 0, this.vfPickedTextureCoordinate, 0, n2);
        this.hasChanged[9] = true;
        this.hasChanged[10] = true;
        this.hasChanged[11] = true;
        this.numPickedItems = n;
        this.fireFieldChanged(9);
        this.fireFieldChanged(10);
        this.fireFieldChanged(11);
    }

    static {
        nodeFields = new int[]{4, 3, 0};
        fieldDecl = new VRMLFieldDeclaration[12];
        fieldMap = new HashMap(36);
        BaseLinePicker.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseLinePicker.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFNode", "pickingGeometry");
        BaseLinePicker.fieldDecl[4] = new VRMLFieldDeclaration(3, "MFNode", "pickTarget");
        BaseLinePicker.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseLinePicker.fieldDecl[6] = new VRMLFieldDeclaration(4, "MFNode", "pickedGeometry");
        BaseLinePicker.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseLinePicker.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFString", "intersectionType");
        BaseLinePicker.fieldDecl[7] = new VRMLFieldDeclaration(2, "SFString", "sortOrder");
        BaseLinePicker.fieldDecl[9] = new VRMLFieldDeclaration(4, "MFVec3f", "pickedPoint");
        BaseLinePicker.fieldDecl[10] = new VRMLFieldDeclaration(4, "MFVec3f", "pickedNormal");
        BaseLinePicker.fieldDecl[11] = new VRMLFieldDeclaration(4, "MFVec3f", "pickedTextureCoordinate");
        BaseLinePicker.fieldDecl[8] = new VRMLFieldDeclaration(3, "MFString", "objectType");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(3);
        fieldMap.put("pickingGeometry", n);
        fieldMap.put("set_pickingGeometry", n);
        fieldMap.put("pickingGeometry_changed", n);
        n = new Integer(4);
        fieldMap.put("pickTarget", n);
        fieldMap.put("set_pickTarget", n);
        fieldMap.put("pickTarget_changed", n);
        n = new Integer(1);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(8);
        fieldMap.put("objectType", n);
        fieldMap.put("set_objectType", n);
        fieldMap.put("objectType_changed", n);
        fieldMap.put("sortOrder", new Integer(7));
        fieldMap.put("intersectionType", new Integer(5));
        fieldMap.put("isActive", new Integer(2));
        fieldMap.put("pickedGeometry", new Integer(6));
        fieldMap.put("pickedPoint", new Integer(9));
        fieldMap.put("pickedNormal", new Integer(10));
        fieldMap.put("pickedTextureCoordinate", new Integer(11));
    }
}

