/*=========================================================================

  Program:   Visualization Toolkit
  Module:    TestGPURayCastVolumeUpdate.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// This test volume tests whether updating the volume MTime updates the ,
// geometry in the volume mapper.

#include <vtkColorTransferFunction.h>
#include <vtkDataArray.h>
#include <vtkGPUVolumeRayCastMapper.h>
#include <vtkImageData.h>
#include <vtkInteractorStyleTrackballCamera.h>
#include <vtkNew.h>
#include <vtkOutlineFilter.h>
#include <vtkPiecewiseFunction.h>
#include <vtkPolyDataMapper.h>
#include <vtkRenderer.h>
#include <vtkRenderWindow.h>
#include <vtkRenderWindowInteractor.h>
#include <vtkRTAnalyticSource.h>
#include <vtkSmartPointer.h>
#include <vtkTesting.h>
#include <vtkTestUtilities.h>
#include <vtkVolumeProperty.h>
#include <vtkXMLImageDataReader.h>

static const char * TestGPURayCastVolumeUpdateLog =
"# StreamVersion 1\n"
"EnterEvent 396 237 0 0 0 0 0\n"
"MouseMoveEvent 396 237 0 0 0 0 0\n"
"MouseMoveEvent 390 239 0 0 0 0 0\n"
"MouseMoveEvent 383 240 0 0 0 0 0\n"
"MouseMoveEvent 376 240 0 0 0 0 0\n"
"MouseMoveEvent 369 242 0 0 0 0 0\n"
"MouseMoveEvent 360 244 0 0 0 0 0\n"
"MouseMoveEvent 351 244 0 0 0 0 0\n"
"MouseMoveEvent 342 244 0 0 0 0 0\n"
"MouseMoveEvent 332 244 0 0 0 0 0\n"
"MouseMoveEvent 323 244 0 0 0 0 0\n"
"MouseMoveEvent 315 244 0 0 0 0 0\n"
"MouseMoveEvent 309 244 0 0 0 0 0\n"
"MouseMoveEvent 306 244 0 0 0 0 0\n"
"MouseMoveEvent 304 244 0 0 0 0 0\n"
"MouseMoveEvent 303 244 0 0 0 0 0\n"
"MouseMoveEvent 301 244 0 0 0 0 0\n"
"MouseMoveEvent 298 244 0 0 0 0 0\n"
"MouseMoveEvent 294 244 0 0 0 0 0\n"
"MouseMoveEvent 288 244 0 0 0 0 0\n"
"MouseMoveEvent 281 244 0 0 0 0 0\n"
"MouseMoveEvent 274 244 0 0 0 0 0\n"
"MouseMoveEvent 268 244 0 0 0 0 0\n"
"MouseMoveEvent 262 244 0 0 0 0 0\n"
"MouseMoveEvent 259 244 0 0 0 0 0\n"
"MouseMoveEvent 258 244 0 0 0 0 0\n"
"MouseMoveEvent 256 244 0 0 0 0 0\n"
"MouseMoveEvent 254 244 0 0 0 0 0\n"
"MouseMoveEvent 253 245 0 0 0 0 0\n"
"MouseMoveEvent 251 246 0 0 0 0 0\n"
"MouseMoveEvent 250 246 0 0 0 0 0\n"
"MouseMoveEvent 249 246 0 0 0 0 0\n"
"MouseMoveEvent 246 247 0 0 0 0 0\n"
"MouseMoveEvent 244 248 0 0 0 0 0\n"
"MouseMoveEvent 243 248 0 0 0 0 0\n"
"MouseMoveEvent 240 249 0 0 0 0 0\n"
"MouseMoveEvent 238 249 0 0 0 0 0\n"
"MouseMoveEvent 236 250 0 0 0 0 0\n"
"MouseMoveEvent 233 251 0 0 0 0 0\n"
"MouseMoveEvent 232 251 0 0 0 0 0\n"
"MouseMoveEvent 230 251 0 0 0 0 0\n"
"MouseMoveEvent 229 252 0 0 0 0 0\n"
"MouseMoveEvent 228 252 0 0 0 0 0\n"
"MouseMoveEvent 227 253 0 0 0 0 0\n"
"MouseMoveEvent 226 253 0 0 0 0 0\n"
"MouseMoveEvent 225 254 0 0 0 0 0\n"
"MouseMoveEvent 224 254 0 0 0 0 0\n"
"MouseMoveEvent 223 255 0 0 0 0 0\n"
"LeftButtonPressEvent 223 255 0 0 0 0 0\n"
"StartInteractionEvent 223 255 0 0 0 0 0\n"
"TimerEvent 223 255 0 0 0 0 0\n"
"RenderEvent 223 255 0 0 0 0 0\n"
"TimerEvent 223 255 0 0 0 0 0\n"
"RenderEvent 223 255 0 0 0 0 0\n"
"TimerEvent 223 255 0 0 0 0 0\n"
"RenderEvent 223 255 0 0 0 0 0\n"
"MouseMoveEvent 223 252 0 0 0 0 0\n"
"MouseMoveEvent 224 251 0 0 0 0 0\n"
"TimerEvent 224 251 0 0 0 0 0\n"
"RenderEvent 224 251 0 0 0 0 0\n"
"MouseMoveEvent 228 242 0 0 0 0 0\n"
"MouseMoveEvent 229 240 0 0 0 0 0\n"
"TimerEvent 229 240 0 0 0 0 0\n"
"RenderEvent 229 240 0 0 0 0 0\n"
"MouseMoveEvent 232 233 0 0 0 0 0\n"
"MouseMoveEvent 232 231 0 0 0 0 0\n"
"TimerEvent 232 231 0 0 0 0 0\n"
"RenderEvent 232 231 0 0 0 0 0\n"
"MouseMoveEvent 236 222 0 0 0 0 0\n"
"MouseMoveEvent 237 220 0 0 0 0 0\n"
"MouseMoveEvent 238 218 0 0 0 0 0\n"
"TimerEvent 238 218 0 0 0 0 0\n"
"RenderEvent 238 218 0 0 0 0 0\n"
"MouseMoveEvent 240 212 0 0 0 0 0\n"
"MouseMoveEvent 241 211 0 0 0 0 0\n"
"TimerEvent 241 211 0 0 0 0 0\n"
"RenderEvent 241 211 0 0 0 0 0\n"
"MouseMoveEvent 242 207 0 0 0 0 0\n"
"MouseMoveEvent 242 206 0 0 0 0 0\n"
"TimerEvent 242 206 0 0 0 0 0\n"
"RenderEvent 242 206 0 0 0 0 0\n"
"MouseMoveEvent 244 200 0 0 0 0 0\n"
"MouseMoveEvent 244 199 0 0 0 0 0\n"
"TimerEvent 244 199 0 0 0 0 0\n"
"RenderEvent 244 199 0 0 0 0 0\n"
"MouseMoveEvent 245 192 0 0 0 0 0\n"
"MouseMoveEvent 245 190 0 0 0 0 0\n"
"TimerEvent 245 190 0 0 0 0 0\n"
"RenderEvent 245 190 0 0 0 0 0\n"
"MouseMoveEvent 246 184 0 0 0 0 0\n"
"MouseMoveEvent 246 182 0 0 0 0 0\n"
"TimerEvent 246 182 0 0 0 0 0\n"
"RenderEvent 246 182 0 0 0 0 0\n"
"MouseMoveEvent 246 177 0 0 0 0 0\n"
"MouseMoveEvent 246 176 0 0 0 0 0\n"
"TimerEvent 246 176 0 0 0 0 0\n"
"RenderEvent 246 176 0 0 0 0 0\n"
"MouseMoveEvent 247 172 0 0 0 0 0\n"
"MouseMoveEvent 247 171 0 0 0 0 0\n"
"TimerEvent 247 171 0 0 0 0 0\n"
"RenderEvent 247 171 0 0 0 0 0\n"
"MouseMoveEvent 247 165 0 0 0 0 0\n"
"MouseMoveEvent 248 164 0 0 0 0 0\n"
"MouseMoveEvent 248 163 0 0 0 0 0\n"
"TimerEvent 248 163 0 0 0 0 0\n"
"RenderEvent 248 163 0 0 0 0 0\n"
"MouseMoveEvent 249 159 0 0 0 0 0\n"
"MouseMoveEvent 249 158 0 0 0 0 0\n"
"MouseMoveEvent 249 157 0 0 0 0 0\n"
"TimerEvent 249 157 0 0 0 0 0\n"
"RenderEvent 249 157 0 0 0 0 0\n"
"MouseMoveEvent 249 152 0 0 0 0 0\n"
"MouseMoveEvent 249 150 0 0 0 0 0\n"
"TimerEvent 249 150 0 0 0 0 0\n"
"RenderEvent 249 150 0 0 0 0 0\n"
"MouseMoveEvent 249 147 0 0 0 0 0\n"
"TimerEvent 249 147 0 0 0 0 0\n"
"RenderEvent 249 147 0 0 0 0 0\n"
"MouseMoveEvent 249 145 0 0 0 0 0\n"
"MouseMoveEvent 249 144 0 0 0 0 0\n"
"TimerEvent 249 144 0 0 0 0 0\n"
"RenderEvent 249 144 0 0 0 0 0\n"
"MouseMoveEvent 249 143 0 0 0 0 0\n"
"TimerEvent 249 143 0 0 0 0 0\n"
"RenderEvent 249 143 0 0 0 0 0\n"
"MouseMoveEvent 249 142 0 0 0 0 0\n"
"TimerEvent 249 142 0 0 0 0 0\n"
"RenderEvent 249 142 0 0 0 0 0\n"
"TimerEvent 249 142 0 0 0 0 0\n"
"RenderEvent 249 142 0 0 0 0 0\n"
"TimerEvent 249 142 0 0 0 0 0\n"
"RenderEvent 249 142 0 0 0 0 0\n"
"TimerEvent 249 142 0 0 0 0 0\n"
"RenderEvent 249 142 0 0 0 0 0\n"
"TimerEvent 249 142 0 0 0 0 0\n"
"RenderEvent 249 142 0 0 0 0 0\n"
"TimerEvent 249 142 0 0 0 0 0\n"
"RenderEvent 249 142 0 0 0 0 0\n"
"TimerEvent 249 142 0 0 0 0 0\n"
"RenderEvent 249 142 0 0 0 0 0\n"
"TimerEvent 249 142 0 0 0 0 0\n"
"RenderEvent 249 142 0 0 0 0 0\n"
"TimerEvent 249 142 0 0 0 0 0\n"
"RenderEvent 249 142 0 0 0 0 0\n"
"LeftButtonReleaseEvent 249 142 0 0 0 0 0\n"
"EndInteractionEvent 249 142 0 0 0 0 0\n"
"RenderEvent 249 142 0 0 0 0 0\n"
"MouseMoveEvent 248 141 0 0 0 0 0\n"
"MouseMoveEvent 247 140 0 0 0 0 0\n"
"MouseMoveEvent 246 139 0 0 0 0 0\n"
"MouseMoveEvent 245 138 0 0 0 0 0\n"
"LeftButtonPressEvent 245 138 0 0 0 0 0\n"
"StartInteractionEvent 245 138 0 0 0 0 0\n"
"TimerEvent 245 138 0 0 0 0 0\n"
"RenderEvent 245 138 0 0 0 0 0\n"
"MouseMoveEvent 244 138 0 0 0 0 0\n"
"MouseMoveEvent 243 138 0 0 0 0 0\n"
"TimerEvent 243 138 0 0 0 0 0\n"
"RenderEvent 243 138 0 0 0 0 0\n"
"MouseMoveEvent 237 137 0 0 0 0 0\n"
"MouseMoveEvent 235 137 0 0 0 0 0\n"
"TimerEvent 235 137 0 0 0 0 0\n"
"RenderEvent 235 137 0 0 0 0 0\n"
"MouseMoveEvent 229 135 0 0 0 0 0\n"
"MouseMoveEvent 227 134 0 0 0 0 0\n"
"MouseMoveEvent 225 133 0 0 0 0 0\n"
"TimerEvent 225 133 0 0 0 0 0\n"
"RenderEvent 225 133 0 0 0 0 0\n"
"MouseMoveEvent 219 130 0 0 0 0 0\n"
"MouseMoveEvent 217 129 0 0 0 0 0\n"
"TimerEvent 217 129 0 0 0 0 0\n"
"RenderEvent 217 129 0 0 0 0 0\n"
"MouseMoveEvent 212 126 0 0 0 0 0\n"
"MouseMoveEvent 211 125 0 0 0 0 0\n"
"TimerEvent 211 125 0 0 0 0 0\n"
"RenderEvent 211 125 0 0 0 0 0\n"
"MouseMoveEvent 210 124 0 0 0 0 0\n"
"TimerEvent 210 124 0 0 0 0 0\n"
"RenderEvent 210 124 0 0 0 0 0\n"
"MouseMoveEvent 209 124 0 0 0 0 0\n"
"MouseMoveEvent 208 124 0 0 0 0 0\n"
"TimerEvent 208 124 0 0 0 0 0\n"
"RenderEvent 208 124 0 0 0 0 0\n"
"MouseMoveEvent 207 123 0 0 0 0 0\n"
"TimerEvent 207 123 0 0 0 0 0\n"
"RenderEvent 207 123 0 0 0 0 0\n"
"MouseMoveEvent 204 121 0 0 0 0 0\n"
"TimerEvent 204 121 0 0 0 0 0\n"
"RenderEvent 204 121 0 0 0 0 0\n"
"MouseMoveEvent 202 119 0 0 0 0 0\n"
"TimerEvent 202 119 0 0 0 0 0\n"
"RenderEvent 202 119 0 0 0 0 0\n"
"MouseMoveEvent 200 117 0 0 0 0 0\n"
"TimerEvent 200 117 0 0 0 0 0\n"
"RenderEvent 200 117 0 0 0 0 0\n"
"MouseMoveEvent 199 116 0 0 0 0 0\n"
"MouseMoveEvent 198 115 0 0 0 0 0\n"
"TimerEvent 198 115 0 0 0 0 0\n"
"RenderEvent 198 115 0 0 0 0 0\n"
"MouseMoveEvent 198 113 0 0 0 0 0\n"
"MouseMoveEvent 198 112 0 0 0 0 0\n"
"TimerEvent 198 112 0 0 0 0 0\n"
"RenderEvent 198 112 0 0 0 0 0\n"
"MouseMoveEvent 198 111 0 0 0 0 0\n"
"MouseMoveEvent 197 109 0 0 0 0 0\n"
"TimerEvent 197 109 0 0 0 0 0\n"
"RenderEvent 197 109 0 0 0 0 0\n"
"MouseMoveEvent 197 108 0 0 0 0 0\n"
"TimerEvent 197 108 0 0 0 0 0\n"
"RenderEvent 197 108 0 0 0 0 0\n"
"MouseMoveEvent 197 106 0 0 0 0 0\n"
"TimerEvent 197 106 0 0 0 0 0\n"
"RenderEvent 197 106 0 0 0 0 0\n"
"MouseMoveEvent 197 104 0 0 0 0 0\n"
"MouseMoveEvent 197 103 0 0 0 0 0\n"
"TimerEvent 197 103 0 0 0 0 0\n"
"RenderEvent 197 103 0 0 0 0 0\n"
"MouseMoveEvent 197 102 0 0 0 0 0\n"
"MouseMoveEvent 197 101 0 0 0 0 0\n"
"TimerEvent 197 101 0 0 0 0 0\n"
"RenderEvent 197 101 0 0 0 0 0\n"
"MouseMoveEvent 197 99 0 0 0 0 0\n"
"LeftButtonReleaseEvent 197 100 0 0 0 0 0\n"
"EndInteractionEvent 197 100 0 0 0 0 0\n"
"RenderEvent 197 100 0 0 0 0 0\n"
"MouseMoveEvent 197 96 0 0 0 0 0\n"
"MouseMoveEvent 197 96 0 0 0 0 0\n"
"MouseMoveEvent 197 95 0 0 0 0 0\n"
"MouseMoveEvent 197 93 0 0 0 0 0\n"
"MouseMoveEvent 197 92 0 0 0 0 0\n"
"MouseMoveEvent 197 91 0 0 0 0 0\n"
"MouseMoveEvent 197 90 0 0 0 0 0\n"
"MouseMoveEvent 198 89 0 0 0 0 0\n"
"MouseMoveEvent 198 88 0 0 0 0 0\n"
"LeftButtonPressEvent 198 88 0 0 0 0 0\n"
"StartInteractionEvent 198 88 0 0 0 0 0\n"
"MouseMoveEvent 199 87 0 0 0 0 0\n"
"TimerEvent 199 87 0 0 0 0 0\n"
"RenderEvent 199 87 0 0 0 0 0\n"
"MouseMoveEvent 199 86 0 0 0 0 0\n"
"TimerEvent 199 86 0 0 0 0 0\n"
"RenderEvent 199 86 0 0 0 0 0\n"
"MouseMoveEvent 199 85 0 0 0 0 0\n"
"MouseMoveEvent 199 84 0 0 0 0 0\n"
"TimerEvent 199 84 0 0 0 0 0\n"
"RenderEvent 199 84 0 0 0 0 0\n"
"MouseMoveEvent 199 82 0 0 0 0 0\n"
"MouseMoveEvent 200 81 0 0 0 0 0\n"
"TimerEvent 200 81 0 0 0 0 0\n"
"RenderEvent 200 81 0 0 0 0 0\n"
"MouseMoveEvent 200 79 0 0 0 0 0\n"
"MouseMoveEvent 200 78 0 0 0 0 0\n"
"MouseMoveEvent 200 77 0 0 0 0 0\n"
"TimerEvent 200 77 0 0 0 0 0\n"
"RenderEvent 200 77 0 0 0 0 0\n"
"MouseMoveEvent 200 76 0 0 0 0 0\n"
"MouseMoveEvent 200 75 0 0 0 0 0\n"
"MouseMoveEvent 200 74 0 0 0 0 0\n"
"TimerEvent 200 74 0 0 0 0 0\n"
"RenderEvent 200 74 0 0 0 0 0\n"
"MouseMoveEvent 200 73 0 0 0 0 0\n"
"MouseMoveEvent 200 72 0 0 0 0 0\n"
"TimerEvent 200 72 0 0 0 0 0\n"
"RenderEvent 200 72 0 0 0 0 0\n"
"MouseMoveEvent 200 70 0 0 0 0 0\n"
"MouseMoveEvent 200 69 0 0 0 0 0\n"
"TimerEvent 200 69 0 0 0 0 0\n"
"RenderEvent 200 69 0 0 0 0 0\n"
"MouseMoveEvent 200 68 0 0 0 0 0\n"
"TimerEvent 200 68 0 0 0 0 0\n"
"RenderEvent 200 68 0 0 0 0 0\n"
"MouseMoveEvent 200 67 0 0 0 0 0\n"
"TimerEvent 200 67 0 0 0 0 0\n"
"RenderEvent 200 67 0 0 0 0 0\n"
"TimerEvent 200 67 0 0 0 0 0\n"
"RenderEvent 200 67 0 0 0 0 0\n"
"TimerEvent 200 67 0 0 0 0 0\n"
"RenderEvent 200 67 0 0 0 0 0\n"
"TimerEvent 200 67 0 0 0 0 0\n"
"RenderEvent 200 67 0 0 0 0 0\n"
"TimerEvent 200 67 0 0 0 0 0\n"
"RenderEvent 200 67 0 0 0 0 0\n"
"TimerEvent 200 67 0 0 0 0 0\n"
"RenderEvent 200 67 0 0 0 0 0\n"
"TimerEvent 200 67 0 0 0 0 0\n"
"RenderEvent 200 67 0 0 0 0 0\n"
"TimerEvent 200 67 0 0 0 0 0\n"
"RenderEvent 200 67 0 0 0 0 0\n"
"LeftButtonReleaseEvent 200 67 0 0 0 0 0\n"
"EndInteractionEvent 200 67 0 0 0 0 0\n"
"RenderEvent 200 67 0 0 0 0 0\n"
"MouseMoveEvent 201 66 0 0 0 0 0\n"
"MouseMoveEvent 202 67 0 0 0 0 0\n"
"MouseMoveEvent 203 68 0 0 0 0 0\n"
"MouseMoveEvent 204 69 0 0 0 0 0\n"
"MouseMoveEvent 205 70 0 0 0 0 0\n"
"MouseMoveEvent 206 71 0 0 0 0 0\n"
"MouseMoveEvent 207 74 0 0 0 0 0\n"
"MouseMoveEvent 208 77 0 0 0 0 0\n"
"MouseMoveEvent 210 81 0 0 0 0 0\n"
"MouseMoveEvent 211 85 0 0 0 0 0\n"
"MouseMoveEvent 212 89 0 0 0 0 0\n"
"MouseMoveEvent 213 92 0 0 0 0 0\n"
"MouseMoveEvent 214 96 0 0 0 0 0\n"
"MouseMoveEvent 214 100 0 0 0 0 0\n"
"MouseMoveEvent 215 104 0 0 0 0 0\n"
"MouseMoveEvent 215 107 0 0 0 0 0\n"
"MouseMoveEvent 216 110 0 0 0 0 0\n"
"MouseMoveEvent 216 112 0 0 0 0 0\n"
"MouseMoveEvent 216 114 0 0 0 0 0\n"
"MouseMoveEvent 216 115 0 0 0 0 0\n"
"MouseMoveEvent 217 117 0 0 0 0 0\n"
"MouseMoveEvent 218 119 0 0 0 0 0\n"
"MouseMoveEvent 218 120 0 0 0 0 0\n"
"MouseMoveEvent 218 122 0 0 0 0 0\n"
"MouseMoveEvent 219 124 0 0 0 0 0\n"
"MouseMoveEvent 220 126 0 0 0 0 0\n"
"MouseMoveEvent 220 127 0 0 0 0 0\n"
"MouseMoveEvent 220 128 0 0 0 0 0\n"
"MouseMoveEvent 221 130 0 0 0 0 0\n"
"MouseMoveEvent 222 131 0 0 0 0 0\n"
"LeftButtonPressEvent 222 131 0 0 0 0 0\n"
"StartInteractionEvent 222 131 0 0 0 0 0\n"
"TimerEvent 222 131 0 0 0 0 0\n"
"RenderEvent 222 131 0 0 0 0 0\n"
"MouseMoveEvent 224 132 0 0 0 0 0\n"
"TimerEvent 224 132 0 0 0 0 0\n"
"RenderEvent 224 132 0 0 0 0 0\n"
"MouseMoveEvent 227 137 0 0 0 0 0\n"
"TimerEvent 227 137 0 0 0 0 0\n"
"RenderEvent 227 137 0 0 0 0 0\n"
"MouseMoveEvent 229 143 0 0 0 0 0\n"
"MouseMoveEvent 230 145 0 0 0 0 0\n"
"TimerEvent 230 145 0 0 0 0 0\n"
"RenderEvent 230 145 0 0 0 0 0\n"
"MouseMoveEvent 233 151 0 0 0 0 0\n"
"MouseMoveEvent 233 152 0 0 0 0 0\n"
"TimerEvent 233 152 0 0 0 0 0\n"
"RenderEvent 233 152 0 0 0 0 0\n"
"MouseMoveEvent 235 155 0 0 0 0 0\n"
"MouseMoveEvent 236 156 0 0 0 0 0\n"
"TimerEvent 236 156 0 0 0 0 0\n"
"RenderEvent 236 156 0 0 0 0 0\n"
"MouseMoveEvent 238 160 0 0 0 0 0\n"
"MouseMoveEvent 239 162 0 0 0 0 0\n"
"TimerEvent 239 162 0 0 0 0 0\n"
"RenderEvent 239 162 0 0 0 0 0\n"
"MouseMoveEvent 241 167 0 0 0 0 0\n"
"MouseMoveEvent 241 168 0 0 0 0 0\n"
"TimerEvent 241 168 0 0 0 0 0\n"
"RenderEvent 241 168 0 0 0 0 0\n"
"MouseMoveEvent 242 170 0 0 0 0 0\n"
"MouseMoveEvent 242 171 0 0 0 0 0\n"
"TimerEvent 242 171 0 0 0 0 0\n"
"RenderEvent 242 171 0 0 0 0 0\n"
"MouseMoveEvent 244 176 0 0 0 0 0\n"
"MouseMoveEvent 245 177 0 0 0 0 0\n"
"TimerEvent 245 177 0 0 0 0 0\n"
"RenderEvent 245 177 0 0 0 0 0\n"
"MouseMoveEvent 247 183 0 0 0 0 0\n"
"MouseMoveEvent 247 185 0 0 0 0 0\n"
"TimerEvent 247 185 0 0 0 0 0\n"
"RenderEvent 247 185 0 0 0 0 0\n"
"MouseMoveEvent 249 190 0 0 0 0 0\n"
"MouseMoveEvent 249 191 0 0 0 0 0\n"
"TimerEvent 249 191 0 0 0 0 0\n"
"RenderEvent 249 191 0 0 0 0 0\n"
"MouseMoveEvent 250 194 0 0 0 0 0\n"
"TimerEvent 250 194 0 0 0 0 0\n"
"RenderEvent 250 194 0 0 0 0 0\n"
"MouseMoveEvent 249 201 0 0 0 0 0\n"
"TimerEvent 249 201 0 0 0 0 0\n"
"RenderEvent 249 201 0 0 0 0 0\n"
"MouseMoveEvent 248 208 0 0 0 0 0\n"
"MouseMoveEvent 247 209 0 0 0 0 0\n"
"MouseMoveEvent 246 212 0 0 0 0 0\n"
"TimerEvent 246 212 0 0 0 0 0\n"
"RenderEvent 246 212 0 0 0 0 0\n"
"MouseMoveEvent 244 218 0 0 0 0 0\n"
"MouseMoveEvent 243 219 0 0 0 0 0\n"
"MouseMoveEvent 242 220 0 0 0 0 0\n"
"TimerEvent 242 220 0 0 0 0 0\n"
"RenderEvent 242 220 0 0 0 0 0\n"
"MouseMoveEvent 236 227 0 0 0 0 0\n"
"MouseMoveEvent 234 229 0 0 0 0 0\n"
"TimerEvent 234 229 0 0 0 0 0\n"
"RenderEvent 234 229 0 0 0 0 0\n"
"MouseMoveEvent 226 237 0 0 0 0 0\n"
"MouseMoveEvent 224 239 0 0 0 0 0\n"
"TimerEvent 224 239 0 0 0 0 0\n"
"RenderEvent 224 239 0 0 0 0 0\n"
"MouseMoveEvent 218 245 0 0 0 0 0\n"
"MouseMoveEvent 217 246 0 0 0 0 0\n"
"MouseMoveEvent 216 247 0 0 0 0 0\n"
"TimerEvent 216 247 0 0 0 0 0\n"
"RenderEvent 216 247 0 0 0 0 0\n"
"MouseMoveEvent 212 251 0 0 0 0 0\n"
"TimerEvent 212 251 0 0 0 0 0\n"
"RenderEvent 212 251 0 0 0 0 0\n"
"MouseMoveEvent 210 253 0 0 0 0 0\n"
"TimerEvent 210 253 0 0 0 0 0\n"
"RenderEvent 210 253 0 0 0 0 0\n"
"TimerEvent 210 253 0 0 0 0 0\n"
"RenderEvent 210 253 0 0 0 0 0\n"
"TimerEvent 210 253 0 0 0 0 0\n"
"RenderEvent 210 253 0 0 0 0 0\n"
"TimerEvent 210 253 0 0 0 0 0\n"
"RenderEvent 210 253 0 0 0 0 0\n"
"MouseMoveEvent 209 254 0 0 0 0 0\n"
"TimerEvent 209 254 0 0 0 0 0\n"
"RenderEvent 209 254 0 0 0 0 0\n"
"MouseMoveEvent 208 252 0 0 0 0 0\n"
"MouseMoveEvent 208 250 0 0 0 0 0\n"
"TimerEvent 208 250 0 0 0 0 0\n"
"RenderEvent 208 250 0 0 0 0 0\n"
"MouseMoveEvent 208 244 0 0 0 0 0\n"
"MouseMoveEvent 208 242 0 0 0 0 0\n"
"TimerEvent 208 242 0 0 0 0 0\n"
"RenderEvent 208 242 0 0 0 0 0\n"
"MouseMoveEvent 208 236 0 0 0 0 0\n"
"MouseMoveEvent 208 234 0 0 0 0 0\n"
"TimerEvent 208 234 0 0 0 0 0\n"
"RenderEvent 208 234 0 0 0 0 0\n"
"MouseMoveEvent 210 229 0 0 0 0 0\n"
"MouseMoveEvent 210 227 0 0 0 0 0\n"
"TimerEvent 210 227 0 0 0 0 0\n"
"RenderEvent 210 227 0 0 0 0 0\n"
"MouseMoveEvent 212 221 0 0 0 0 0\n"
"MouseMoveEvent 213 219 0 0 0 0 0\n"
"MouseMoveEvent 213 217 0 0 0 0 0\n"
"TimerEvent 213 217 0 0 0 0 0\n"
"RenderEvent 213 217 0 0 0 0 0\n"
"MouseMoveEvent 215 212 0 0 0 0 0\n"
"MouseMoveEvent 215 211 0 0 0 0 0\n"
"MouseMoveEvent 216 209 0 0 0 0 0\n"
"TimerEvent 216 209 0 0 0 0 0\n"
"RenderEvent 216 209 0 0 0 0 0\n"
"MouseMoveEvent 217 204 0 0 0 0 0\n"
"MouseMoveEvent 218 202 0 0 0 0 0\n"
"TimerEvent 218 202 0 0 0 0 0\n"
"RenderEvent 218 202 0 0 0 0 0\n"
"MouseMoveEvent 220 198 0 0 0 0 0\n"
"MouseMoveEvent 221 196 0 0 0 0 0\n"
"TimerEvent 221 196 0 0 0 0 0\n"
"RenderEvent 221 196 0 0 0 0 0\n"
"MouseMoveEvent 223 190 0 0 0 0 0\n"
"MouseMoveEvent 224 189 0 0 0 0 0\n"
"TimerEvent 224 189 0 0 0 0 0\n"
"RenderEvent 224 189 0 0 0 0 0\n"
"MouseMoveEvent 226 184 0 0 0 0 0\n"
"MouseMoveEvent 226 183 0 0 0 0 0\n"
"TimerEvent 226 183 0 0 0 0 0\n"
"RenderEvent 226 183 0 0 0 0 0\n"
"MouseMoveEvent 228 179 0 0 0 0 0\n"
"MouseMoveEvent 229 178 0 0 0 0 0\n"
"MouseMoveEvent 229 177 0 0 0 0 0\n"
"TimerEvent 229 177 0 0 0 0 0\n"
"RenderEvent 229 177 0 0 0 0 0\n"
"MouseMoveEvent 230 175 0 0 0 0 0\n"
"MouseMoveEvent 230 174 0 0 0 0 0\n"
"TimerEvent 230 174 0 0 0 0 0\n"
"RenderEvent 230 174 0 0 0 0 0\n"
"MouseMoveEvent 230 172 0 0 0 0 0\n"
"TimerEvent 230 172 0 0 0 0 0\n"
"RenderEvent 230 172 0 0 0 0 0\n"
"MouseMoveEvent 231 170 0 0 0 0 0\n"
"TimerEvent 231 170 0 0 0 0 0\n"
"RenderEvent 231 170 0 0 0 0 0\n"
"MouseMoveEvent 231 168 0 0 0 0 0\n"
"TimerEvent 231 168 0 0 0 0 0\n"
"RenderEvent 231 168 0 0 0 0 0\n"
"MouseMoveEvent 231 166 0 0 0 0 0\n"
"TimerEvent 231 166 0 0 0 0 0\n"
"RenderEvent 231 166 0 0 0 0 0\n"
"MouseMoveEvent 231 165 0 0 0 0 0\n"
"MouseMoveEvent 231 164 0 0 0 0 0\n"
"TimerEvent 231 164 0 0 0 0 0\n"
"RenderEvent 231 164 0 0 0 0 0\n"
"MouseMoveEvent 231 163 0 0 0 0 0\n"
"TimerEvent 231 163 0 0 0 0 0\n"
"RenderEvent 231 163 0 0 0 0 0\n"
"MouseMoveEvent 231 161 0 0 0 0 0\n"
"TimerEvent 231 161 0 0 0 0 0\n"
"RenderEvent 231 161 0 0 0 0 0\n"
"MouseMoveEvent 230 158 0 0 0 0 0\n"
"TimerEvent 230 158 0 0 0 0 0\n"
"RenderEvent 230 158 0 0 0 0 0\n"
"MouseMoveEvent 229 157 0 0 0 0 0\n"
"TimerEvent 229 157 0 0 0 0 0\n"
"RenderEvent 229 157 0 0 0 0 0\n"
"MouseMoveEvent 229 156 0 0 0 0 0\n"
"TimerEvent 229 156 0 0 0 0 0\n"
"RenderEvent 229 156 0 0 0 0 0\n"
"MouseMoveEvent 228 154 0 0 0 0 0\n"
"TimerEvent 228 154 0 0 0 0 0\n"
"RenderEvent 228 154 0 0 0 0 0\n"
"MouseMoveEvent 227 153 0 0 0 0 0\n"
"TimerEvent 227 153 0 0 0 0 0\n"
"RenderEvent 227 153 0 0 0 0 0\n"
"MouseMoveEvent 226 152 0 0 0 0 0\n"
"TimerEvent 226 152 0 0 0 0 0\n"
"RenderEvent 226 152 0 0 0 0 0\n"
"MouseMoveEvent 225 151 0 0 0 0 0\n"
"TimerEvent 225 151 0 0 0 0 0\n"
"RenderEvent 225 151 0 0 0 0 0\n"
"TimerEvent 225 151 0 0 0 0 0\n"
"RenderEvent 225 151 0 0 0 0 0\n"
"LeftButtonReleaseEvent 225 151 0 0 0 0 0\n"
"EndInteractionEvent 225 151 0 0 0 0 0\n"
"RenderEvent 225 151 0 0 0 0 0\n"
"MouseMoveEvent 224 151 0 0 0 0 0\n"
"MouseMoveEvent 223 151 0 0 0 0 0\n"
"MouseMoveEvent 222 151 0 0 0 0 0\n"
"MouseMoveEvent 221 151 0 0 0 0 0\n"
"MouseMoveEvent 219 151 0 0 0 0 0\n"
"MouseMoveEvent 218 151 0 0 0 0 0\n"
"MouseMoveEvent 217 151 0 0 0 0 0\n"
"MouseMoveEvent 216 151 0 0 0 0 0\n"
"MouseMoveEvent 215 151 0 0 0 0 0\n"
"MouseMoveEvent 214 151 0 0 0 0 0\n"
"LeftButtonPressEvent 214 151 0 0 0 0 0\n"
"StartInteractionEvent 214 151 0 0 0 0 0\n"
"TimerEvent 214 151 0 0 0 0 0\n"
"RenderEvent 214 151 0 0 0 0 0\n"
"MouseMoveEvent 206 146 0 0 0 0 0\n"
"TimerEvent 206 146 0 0 0 0 0\n"
"RenderEvent 206 146 0 0 0 0 0\n"
"MouseMoveEvent 199 143 0 0 0 0 0\n"
"MouseMoveEvent 198 143 0 0 0 0 0\n"
"TimerEvent 198 143 0 0 0 0 0\n"
"RenderEvent 198 143 0 0 0 0 0\n"
"MouseMoveEvent 192 141 0 0 0 0 0\n"
"MouseMoveEvent 191 140 0 0 0 0 0\n"
"TimerEvent 191 140 0 0 0 0 0\n"
"RenderEvent 191 140 0 0 0 0 0\n"
"MouseMoveEvent 187 136 0 0 0 0 0\n"
"TimerEvent 187 136 0 0 0 0 0\n"
"RenderEvent 187 136 0 0 0 0 0\n"
"MouseMoveEvent 186 135 0 0 0 0 0\n"
"TimerEvent 186 135 0 0 0 0 0\n"
"RenderEvent 186 135 0 0 0 0 0\n"
"MouseMoveEvent 185 135 0 0 0 0 0\n"
"TimerEvent 185 135 0 0 0 0 0\n"
"RenderEvent 185 135 0 0 0 0 0\n"
"MouseMoveEvent 184 135 0 0 0 0 0\n"
"TimerEvent 184 135 0 0 0 0 0\n"
"RenderEvent 184 135 0 0 0 0 0\n"
"MouseMoveEvent 180 136 0 0 0 0 0\n"
"TimerEvent 180 136 0 0 0 0 0\n"
"RenderEvent 180 136 0 0 0 0 0\n"
"LeftButtonReleaseEvent 180 136 0 0 0 0 0\n"
"EndInteractionEvent 180 136 0 0 0 0 0\n"
"RenderEvent 180 136 0 0 0 0 0\n"
"MouseMoveEvent 179 138 0 0 0 0 0\n"
"MouseMoveEvent 179 139 0 0 0 0 0\n"
"MouseMoveEvent 179 140 0 0 0 0 0\n"
"MouseMoveEvent 179 141 0 0 0 0 0\n"
"MouseMoveEvent 179 142 0 0 0 0 0\n"
"MouseMoveEvent 179 143 0 0 0 0 0\n"
"MouseMoveEvent 179 144 0 0 0 0 0\n"
"MouseMoveEvent 178 145 0 0 0 0 0\n"
"MouseMoveEvent 178 146 0 0 0 0 0\n"
"MouseMoveEvent 177 147 0 0 0 0 0\n"
"MouseMoveEvent 177 148 0 0 0 0 0\n"
"MouseMoveEvent 176 149 0 0 0 0 0\n"
"MouseMoveEvent 175 150 0 0 0 0 0\n"
"MouseMoveEvent 174 152 0 0 0 0 0\n"
"MouseMoveEvent 174 153 0 0 0 0 0\n"
"MouseMoveEvent 174 154 0 0 0 0 0\n"
"MouseMoveEvent 173 155 0 0 0 0 0\n"
"MouseMoveEvent 173 157 0 0 0 0 0\n"
"MouseMoveEvent 173 158 0 0 0 0 0\n"
"MouseMoveEvent 172 161 0 0 0 0 0\n"
"MouseMoveEvent 171 162 0 0 0 0 0\n"
"MouseMoveEvent 171 164 0 0 0 0 0\n"
"MouseMoveEvent 171 166 0 0 0 0 0\n"
"MouseMoveEvent 170 167 0 0 0 0 0\n"
"MouseMoveEvent 170 168 0 0 0 0 0\n"
"MouseMoveEvent 169 170 0 0 0 0 0\n"
"MouseMoveEvent 169 172 0 0 0 0 0\n"
"MouseMoveEvent 168 174 0 0 0 0 0\n"
"MouseMoveEvent 167 175 0 0 0 0 0\n"
"MouseMoveEvent 166 176 0 0 0 0 0\n"
"MouseMoveEvent 165 177 0 0 0 0 0\n"
"MouseMoveEvent 164 178 0 0 0 0 0\n"
"MouseMoveEvent 163 179 0 0 0 0 0\n"
"MouseMoveEvent 163 180 0 0 0 0 0\n"
"MouseMoveEvent 162 181 0 0 0 0 0\n"
"MouseMoveEvent 161 182 0 0 0 0 0\n"
"MouseMoveEvent 160 183 0 0 0 0 0\n"
"MouseMoveEvent 159 184 0 0 0 0 0\n"
"LeftButtonPressEvent 159 184 0 0 0 0 0\n"
"StartInteractionEvent 159 184 0 0 0 0 0\n"
"MouseMoveEvent 158 185 0 0 0 0 0\n"
"TimerEvent 158 185 0 0 0 0 0\n"
"RenderEvent 158 185 0 0 0 0 0\n"
"MouseMoveEvent 150 192 0 0 0 0 0\n"
"MouseMoveEvent 149 193 0 0 0 0 0\n"
"MouseMoveEvent 147 195 0 0 0 0 0\n"
"TimerEvent 147 195 0 0 0 0 0\n"
"RenderEvent 147 195 0 0 0 0 0\n"
"MouseMoveEvent 139 203 0 0 0 0 0\n"
"MouseMoveEvent 138 204 0 0 0 0 0\n"
"TimerEvent 138 204 0 0 0 0 0\n"
"RenderEvent 138 204 0 0 0 0 0\n"
"MouseMoveEvent 133 211 0 0 0 0 0\n"
"MouseMoveEvent 133 212 0 0 0 0 0\n"
"MouseMoveEvent 132 213 0 0 0 0 0\n"
"TimerEvent 132 213 0 0 0 0 0\n"
"RenderEvent 132 213 0 0 0 0 0\n"
"MouseMoveEvent 131 215 0 0 0 0 0\n"
"TimerEvent 131 215 0 0 0 0 0\n"
"RenderEvent 131 215 0 0 0 0 0\n"
"MouseMoveEvent 131 217 0 0 0 0 0\n"
"MouseMoveEvent 130 219 0 0 0 0 0\n"
"TimerEvent 130 219 0 0 0 0 0\n"
"RenderEvent 130 219 0 0 0 0 0\n"
"MouseMoveEvent 130 220 0 0 0 0 0\n"
"TimerEvent 130 220 0 0 0 0 0\n"
"RenderEvent 130 220 0 0 0 0 0\n"
"MouseMoveEvent 130 221 0 0 0 0 0\n"
"MouseMoveEvent 130 222 0 0 0 0 0\n"
"TimerEvent 130 222 0 0 0 0 0\n"
"RenderEvent 130 222 0 0 0 0 0\n"
"MouseMoveEvent 130 223 0 0 0 0 0\n"
"TimerEvent 130 223 0 0 0 0 0\n"
"RenderEvent 130 223 0 0 0 0 0\n"
"MouseMoveEvent 131 225 0 0 0 0 0\n"
"TimerEvent 131 225 0 0 0 0 0\n"
"RenderEvent 131 225 0 0 0 0 0\n"
"MouseMoveEvent 132 226 0 0 0 0 0\n"
"TimerEvent 132 226 0 0 0 0 0\n"
"RenderEvent 132 226 0 0 0 0 0\n"
"MouseMoveEvent 133 227 0 0 0 0 0\n"
"MouseMoveEvent 134 228 0 0 0 0 0\n"
"TimerEvent 134 228 0 0 0 0 0\n"
"RenderEvent 134 228 0 0 0 0 0\n"
"MouseMoveEvent 135 229 0 0 0 0 0\n"
"MouseMoveEvent 136 230 0 0 0 0 0\n"
"TimerEvent 136 230 0 0 0 0 0\n"
"RenderEvent 136 230 0 0 0 0 0\n"
"MouseMoveEvent 138 231 0 0 0 0 0\n"
"MouseMoveEvent 140 232 0 0 0 0 0\n"
"TimerEvent 140 232 0 0 0 0 0\n"
"RenderEvent 140 232 0 0 0 0 0\n"
"MouseMoveEvent 142 233 0 0 0 0 0\n"
"MouseMoveEvent 143 233 0 0 0 0 0\n"
"MouseMoveEvent 144 233 0 0 0 0 0\n"
"TimerEvent 144 233 0 0 0 0 0\n"
"RenderEvent 144 233 0 0 0 0 0\n"
"MouseMoveEvent 148 235 0 0 0 0 0\n"
"TimerEvent 148 235 0 0 0 0 0\n"
"RenderEvent 148 235 0 0 0 0 0\n"
"MouseMoveEvent 157 239 0 0 0 0 0\n"
"MouseMoveEvent 158 240 0 0 0 0 0\n"
"TimerEvent 158 240 0 0 0 0 0\n"
"RenderEvent 158 240 0 0 0 0 0\n"
"MouseMoveEvent 163 242 0 0 0 0 0\n"
"TimerEvent 163 242 0 0 0 0 0\n"
"RenderEvent 163 242 0 0 0 0 0\n"
"MouseMoveEvent 165 243 0 0 0 0 0\n"
"MouseMoveEvent 167 244 0 0 0 0 0\n"
"TimerEvent 167 244 0 0 0 0 0\n"
"RenderEvent 167 244 0 0 0 0 0\n"
"MouseMoveEvent 171 246 0 0 0 0 0\n"
"MouseMoveEvent 172 247 0 0 0 0 0\n"
"TimerEvent 172 247 0 0 0 0 0\n"
"RenderEvent 172 247 0 0 0 0 0\n"
"MouseMoveEvent 174 249 0 0 0 0 0\n"
"MouseMoveEvent 175 250 0 0 0 0 0\n"
"TimerEvent 175 250 0 0 0 0 0\n"
"RenderEvent 175 250 0 0 0 0 0\n"
"MouseMoveEvent 176 252 0 0 0 0 0\n"
"MouseMoveEvent 176 253 0 0 0 0 0\n"
"TimerEvent 176 253 0 0 0 0 0\n"
"RenderEvent 176 253 0 0 0 0 0\n"
"MouseMoveEvent 176 257 0 0 0 0 0\n"
"MouseMoveEvent 176 258 0 0 0 0 0\n"
"TimerEvent 176 258 0 0 0 0 0\n"
"RenderEvent 176 258 0 0 0 0 0\n"
"MouseMoveEvent 176 261 0 0 0 0 0\n"
"MouseMoveEvent 176 262 0 0 0 0 0\n"
"TimerEvent 176 262 0 0 0 0 0\n"
"RenderEvent 176 262 0 0 0 0 0\n"
"MouseMoveEvent 175 264 0 0 0 0 0\n"
"MouseMoveEvent 174 265 0 0 0 0 0\n"
"TimerEvent 174 265 0 0 0 0 0\n"
"RenderEvent 174 265 0 0 0 0 0\n"
"MouseMoveEvent 174 266 0 0 0 0 0\n"
"MouseMoveEvent 174 267 0 0 0 0 0\n"
"TimerEvent 174 267 0 0 0 0 0\n"
"RenderEvent 174 267 0 0 0 0 0\n"
"MouseMoveEvent 173 270 0 0 0 0 0\n"
"MouseMoveEvent 173 271 0 0 0 0 0\n"
"MouseMoveEvent 173 272 0 0 0 0 0\n"
"TimerEvent 173 272 0 0 0 0 0\n"
"RenderEvent 173 272 0 0 0 0 0\n"
"MouseMoveEvent 173 275 0 0 0 0 0\n"
"MouseMoveEvent 173 276 0 0 0 0 0\n"
"MouseMoveEvent 173 277 0 0 0 0 0\n"
"TimerEvent 173 277 0 0 0 0 0\n"
"RenderEvent 173 277 0 0 0 0 0\n"
"MouseMoveEvent 173 280 0 0 0 0 0\n"
"MouseMoveEvent 173 282 0 0 0 0 0\n"
"TimerEvent 173 282 0 0 0 0 0\n"
"RenderEvent 173 282 0 0 0 0 0\n"
"MouseMoveEvent 173 285 0 0 0 0 0\n"
"MouseMoveEvent 173 287 0 0 0 0 0\n"
"TimerEvent 173 287 0 0 0 0 0\n"
"RenderEvent 173 287 0 0 0 0 0\n"
"MouseMoveEvent 173 292 0 0 0 0 0\n"
"MouseMoveEvent 174 294 0 0 0 0 0\n"
"TimerEvent 174 294 0 0 0 0 0\n"
"RenderEvent 174 294 0 0 0 0 0\n"
"MouseMoveEvent 174 299 0 0 0 0 0\n"
"MouseMoveEvent 174 300 0 0 0 0 0\n"
"TimerEvent 174 300 0 0 0 0 0\n"
"RenderEvent 174 300 0 0 0 0 0\n"
"MouseMoveEvent 174 305 0 0 0 0 0\n"
"MouseMoveEvent 174 307 0 0 0 0 0\n"
"MouseMoveEvent 174 309 0 0 0 0 0\n"
"TimerEvent 174 309 0 0 0 0 0\n"
"RenderEvent 174 309 0 0 0 0 0\n"
"MouseMoveEvent 174 313 0 0 0 0 0\n"
"MouseMoveEvent 174 314 0 0 0 0 0\n"
"TimerEvent 174 314 0 0 0 0 0\n"
"RenderEvent 174 314 0 0 0 0 0\n"
"MouseMoveEvent 173 317 0 0 0 0 0\n"
"MouseMoveEvent 172 318 0 0 0 0 0\n"
"TimerEvent 172 318 0 0 0 0 0\n"
"RenderEvent 172 318 0 0 0 0 0\n"
"MouseMoveEvent 171 319 0 0 0 0 0\n"
"MouseMoveEvent 170 320 0 0 0 0 0\n"
"MouseMoveEvent 169 321 0 0 0 0 0\n"
"TimerEvent 169 321 0 0 0 0 0\n"
"RenderEvent 169 321 0 0 0 0 0\n"
"MouseMoveEvent 167 323 0 0 0 0 0\n"
"TimerEvent 167 323 0 0 0 0 0\n"
"RenderEvent 167 323 0 0 0 0 0\n"
"MouseMoveEvent 165 323 0 0 0 0 0\n"
"MouseMoveEvent 164 323 0 0 0 0 0\n"
"TimerEvent 164 323 0 0 0 0 0\n"
"RenderEvent 164 323 0 0 0 0 0\n"
"MouseMoveEvent 162 323 0 0 0 0 0\n"
"MouseMoveEvent 161 323 0 0 0 0 0\n"
"TimerEvent 161 323 0 0 0 0 0\n"
"RenderEvent 161 323 0 0 0 0 0\n"
"MouseMoveEvent 158 323 0 0 0 0 0\n"
"MouseMoveEvent 156 323 0 0 0 0 0\n"
"TimerEvent 156 323 0 0 0 0 0\n"
"RenderEvent 156 323 0 0 0 0 0\n"
"MouseMoveEvent 150 323 0 0 0 0 0\n"
"MouseMoveEvent 148 323 0 0 0 0 0\n"
"TimerEvent 148 323 0 0 0 0 0\n"
"RenderEvent 148 323 0 0 0 0 0\n"
"MouseMoveEvent 143 323 0 0 0 0 0\n"
"MouseMoveEvent 141 323 0 0 0 0 0\n"
"MouseMoveEvent 139 323 0 0 0 0 0\n"
"TimerEvent 139 323 0 0 0 0 0\n"
"RenderEvent 139 323 0 0 0 0 0\n"
"MouseMoveEvent 136 323 0 0 0 0 0\n"
"MouseMoveEvent 135 323 0 0 0 0 0\n"
"TimerEvent 135 323 0 0 0 0 0\n"
"RenderEvent 135 323 0 0 0 0 0\n"
"MouseMoveEvent 132 323 0 0 0 0 0\n"
"TimerEvent 132 323 0 0 0 0 0\n"
"RenderEvent 132 323 0 0 0 0 0\n"
"MouseMoveEvent 131 323 0 0 0 0 0\n"
"TimerEvent 131 323 0 0 0 0 0\n"
"RenderEvent 131 323 0 0 0 0 0\n"
"MouseMoveEvent 130 324 0 0 0 0 0\n"
"TimerEvent 130 324 0 0 0 0 0\n"
"RenderEvent 130 324 0 0 0 0 0\n"
"MouseMoveEvent 129 325 0 0 0 0 0\n"
"MouseMoveEvent 128 326 0 0 0 0 0\n"
"TimerEvent 128 326 0 0 0 0 0\n"
"RenderEvent 128 326 0 0 0 0 0\n"
"MouseMoveEvent 127 327 0 0 0 0 0\n"
"TimerEvent 127 327 0 0 0 0 0\n"
"RenderEvent 127 327 0 0 0 0 0\n"
"MouseMoveEvent 126 329 0 0 0 0 0\n"
"TimerEvent 126 329 0 0 0 0 0\n"
"RenderEvent 126 329 0 0 0 0 0\n"
"MouseMoveEvent 126 330 0 0 0 0 0\n"
"TimerEvent 126 330 0 0 0 0 0\n"
"RenderEvent 126 330 0 0 0 0 0\n"
"TimerEvent 126 330 0 0 0 0 0\n"
"RenderEvent 126 330 0 0 0 0 0\n"
"LeftButtonReleaseEvent 126 330 0 0 0 0 0\n"
"EndInteractionEvent 126 330 0 0 0 0 0\n"
"RenderEvent 126 330 0 0 0 0 0\n"
"MouseMoveEvent 128 328 0 0 0 0 0\n"
"MouseMoveEvent 131 322 0 0 0 0 0\n"
"MouseMoveEvent 135 316 0 0 0 0 0\n"
"MouseMoveEvent 140 310 0 0 0 0 0\n"
"MouseMoveEvent 144 301 0 0 0 0 0\n"
"MouseMoveEvent 149 293 0 0 0 0 0\n"
"MouseMoveEvent 154 283 0 0 0 0 0\n"
"MouseMoveEvent 158 272 0 0 0 0 0\n"
"MouseMoveEvent 163 266 0 0 0 0 0\n"
"MouseMoveEvent 165 259 0 0 0 0 0\n"
"MouseMoveEvent 168 253 0 0 0 0 0\n"
"MouseMoveEvent 170 248 0 0 0 0 0\n"
"MouseMoveEvent 172 244 0 0 0 0 0\n"
"MouseMoveEvent 172 243 0 0 0 0 0\n"
"MouseMoveEvent 173 242 0 0 0 0 0\n"
"LeftButtonPressEvent 173 242 0 0 0 0 0\n"
"StartInteractionEvent 173 242 0 0 0 0 0\n"
"TimerEvent 173 242 0 0 0 0 0\n"
"RenderEvent 173 242 0 0 0 0 0\n"
"MouseMoveEvent 174 242 0 0 0 0 0\n"
"MouseMoveEvent 175 242 0 0 0 0 0\n"
"TimerEvent 175 242 0 0 0 0 0\n"
"RenderEvent 175 242 0 0 0 0 0\n"
"MouseMoveEvent 181 252 0 0 0 0 0\n"
"MouseMoveEvent 181 254 0 0 0 0 0\n"
"TimerEvent 181 254 0 0 0 0 0\n"
"RenderEvent 181 254 0 0 0 0 0\n"
"MouseMoveEvent 182 261 0 0 0 0 0\n"
"MouseMoveEvent 182 263 0 0 0 0 0\n"
"TimerEvent 182 263 0 0 0 0 0\n"
"RenderEvent 182 263 0 0 0 0 0\n"
"MouseMoveEvent 182 269 0 0 0 0 0\n"
"MouseMoveEvent 182 270 0 0 0 0 0\n"
"TimerEvent 182 270 0 0 0 0 0\n"
"RenderEvent 182 270 0 0 0 0 0\n"
"MouseMoveEvent 182 274 0 0 0 0 0\n"
"TimerEvent 182 274 0 0 0 0 0\n"
"RenderEvent 182 274 0 0 0 0 0\n"
"MouseMoveEvent 182 275 0 0 0 0 0\n"
"MouseMoveEvent 182 276 0 0 0 0 0\n"
"TimerEvent 182 276 0 0 0 0 0\n"
"RenderEvent 182 276 0 0 0 0 0\n"
"MouseMoveEvent 183 277 0 0 0 0 0\n"
"MouseMoveEvent 184 278 0 0 0 0 0\n"
"TimerEvent 184 278 0 0 0 0 0\n"
"RenderEvent 184 278 0 0 0 0 0\n"
"MouseMoveEvent 186 280 0 0 0 0 0\n"
"MouseMoveEvent 187 281 0 0 0 0 0\n"
"TimerEvent 187 281 0 0 0 0 0\n"
"RenderEvent 187 281 0 0 0 0 0\n"
"MouseMoveEvent 192 284 0 0 0 0 0\n"
"MouseMoveEvent 193 285 0 0 0 0 0\n"
"MouseMoveEvent 195 286 0 0 0 0 0\n"
"TimerEvent 195 286 0 0 0 0 0\n"
"RenderEvent 195 286 0 0 0 0 0\n"
"MouseMoveEvent 198 287 0 0 0 0 0\n"
"TimerEvent 198 287 0 0 0 0 0\n"
"RenderEvent 198 287 0 0 0 0 0\n"
"MouseMoveEvent 200 288 0 0 0 0 0\n"
"MouseMoveEvent 201 288 0 0 0 0 0\n"
"TimerEvent 201 288 0 0 0 0 0\n"
"RenderEvent 201 288 0 0 0 0 0\n"
"MouseMoveEvent 207 288 0 0 0 0 0\n"
"MouseMoveEvent 208 288 0 0 0 0 0\n"
"TimerEvent 208 288 0 0 0 0 0\n"
"RenderEvent 208 288 0 0 0 0 0\n"
"MouseMoveEvent 212 288 0 0 0 0 0\n"
"MouseMoveEvent 213 288 0 0 0 0 0\n"
"MouseMoveEvent 214 288 0 0 0 0 0\n"
"TimerEvent 214 288 0 0 0 0 0\n"
"RenderEvent 214 288 0 0 0 0 0\n"
"MouseMoveEvent 220 288 0 0 0 0 0\n"
"MouseMoveEvent 221 288 0 0 0 0 0\n"
"TimerEvent 221 288 0 0 0 0 0\n"
"RenderEvent 221 288 0 0 0 0 0\n"
"MouseMoveEvent 226 288 0 0 0 0 0\n"
"TimerEvent 226 288 0 0 0 0 0\n"
"RenderEvent 226 288 0 0 0 0 0\n"
"TimerEvent 226 288 0 0 0 0 0\n"
"RenderEvent 226 288 0 0 0 0 0\n"
"MouseMoveEvent 228 288 0 0 0 0 0\n"
"LeftButtonReleaseEvent 228 288 0 0 0 0 0\n"
"EndInteractionEvent 228 288 0 0 0 0 0\n"
"RenderEvent 228 288 0 0 0 0 0\n"
"MouseMoveEvent 230 288 0 0 0 0 0\n"
"MouseMoveEvent 229 287 0 0 0 0 0\n"
"MouseMoveEvent 229 286 0 0 0 0 0\n"
"MouseMoveEvent 228 285 0 0 0 0 0\n"
"MouseMoveEvent 227 284 0 0 0 0 0\n"
"MouseMoveEvent 226 282 0 0 0 0 0\n"
"MouseMoveEvent 225 280 0 0 0 0 0\n"
"MouseMoveEvent 224 279 0 0 0 0 0\n"
"MouseMoveEvent 223 278 0 0 0 0 0\n"
"MouseMoveEvent 222 278 0 0 0 0 0\n"
"MouseMoveEvent 221 278 0 0 0 0 0\n"
"MouseMoveEvent 220 278 0 0 0 0 0\n"
"MouseMoveEvent 219 278 0 0 0 0 0\n"
"LeftButtonPressEvent 219 278 0 0 0 0 0\n"
"StartInteractionEvent 219 278 0 0 0 0 0\n"
"MouseMoveEvent 218 278 0 0 0 0 0\n"
"TimerEvent 218 278 0 0 0 0 0\n"
"RenderEvent 218 278 0 0 0 0 0\n"
"MouseMoveEvent 213 278 0 0 0 0 0\n"
"MouseMoveEvent 212 278 0 0 0 0 0\n"
"TimerEvent 212 278 0 0 0 0 0\n"
"RenderEvent 212 278 0 0 0 0 0\n"
"MouseMoveEvent 206 279 0 0 0 0 0\n"
"TimerEvent 206 279 0 0 0 0 0\n"
"RenderEvent 206 279 0 0 0 0 0\n"
"MouseMoveEvent 196 281 0 0 0 0 0\n"
"MouseMoveEvent 193 281 0 0 0 0 0\n"
"TimerEvent 193 281 0 0 0 0 0\n"
"RenderEvent 193 281 0 0 0 0 0\n"
"MouseMoveEvent 175 287 0 0 0 0 0\n"
"MouseMoveEvent 172 288 0 0 0 0 0\n"
"MouseMoveEvent 169 289 0 0 0 0 0\n"
"TimerEvent 169 289 0 0 0 0 0\n"
"RenderEvent 169 289 0 0 0 0 0\n"
"MouseMoveEvent 159 294 0 0 0 0 0\n"
"TimerEvent 159 294 0 0 0 0 0\n"
"RenderEvent 159 294 0 0 0 0 0\n"
"MouseMoveEvent 155 296 0 0 0 0 0\n"
"TimerEvent 155 296 0 0 0 0 0\n"
"RenderEvent 155 296 0 0 0 0 0\n"
"MouseMoveEvent 152 297 0 0 0 0 0\n"
"MouseMoveEvent 151 297 0 0 0 0 0\n"
"TimerEvent 151 297 0 0 0 0 0\n"
"RenderEvent 151 297 0 0 0 0 0\n"
"MouseMoveEvent 147 298 0 0 0 0 0\n"
"TimerEvent 147 298 0 0 0 0 0\n"
"RenderEvent 147 298 0 0 0 0 0\n"
"MouseMoveEvent 143 298 0 0 0 0 0\n"
"MouseMoveEvent 142 298 0 0 0 0 0\n"
"TimerEvent 142 298 0 0 0 0 0\n"
"RenderEvent 142 298 0 0 0 0 0\n"
"MouseMoveEvent 141 299 0 0 0 0 0\n"
"TimerEvent 141 299 0 0 0 0 0\n"
"RenderEvent 141 299 0 0 0 0 0\n"
"LeftButtonReleaseEvent 141 299 0 0 0 0 0\n"
"EndInteractionEvent 141 299 0 0 0 0 0\n"
"RenderEvent 141 299 0 0 0 0 0\n"
"MouseMoveEvent 141 298 0 0 0 0 0\n"
"MouseMoveEvent 141 297 0 0 0 0 0\n"
"MouseMoveEvent 141 296 0 0 0 0 0\n"
"MouseMoveEvent 141 295 0 0 0 0 0\n"
"MouseMoveEvent 142 293 0 0 0 0 0\n"
"MouseMoveEvent 143 291 0 0 0 0 0\n"
"MouseMoveEvent 143 289 0 0 0 0 0\n"
"MouseMoveEvent 144 286 0 0 0 0 0\n"
"MouseMoveEvent 145 284 0 0 0 0 0\n"
"MouseMoveEvent 147 282 0 0 0 0 0\n"
"MouseMoveEvent 148 279 0 0 0 0 0\n"
"MouseMoveEvent 150 277 0 0 0 0 0\n"
"MouseMoveEvent 152 275 0 0 0 0 0\n"
"MouseMoveEvent 153 274 0 0 0 0 0\n"
"MouseMoveEvent 156 272 0 0 0 0 0\n"
"MouseMoveEvent 157 271 0 0 0 0 0\n"
"MouseMoveEvent 160 270 0 0 0 0 0\n"
"MouseMoveEvent 162 269 0 0 0 0 0\n"
"MouseMoveEvent 163 268 0 0 0 0 0\n"
"MouseMoveEvent 165 267 0 0 0 0 0\n"
"MouseMoveEvent 167 266 0 0 0 0 0\n"
"MouseMoveEvent 168 265 0 0 0 0 0\n"
"MouseMoveEvent 170 264 0 0 0 0 0\n"
"MouseMoveEvent 171 263 0 0 0 0 0\n"
"MouseMoveEvent 173 262 0 0 0 0 0\n"
"MouseMoveEvent 174 261 0 0 0 0 0\n"
"MouseMoveEvent 177 259 0 0 0 0 0\n"
"MouseMoveEvent 178 258 0 0 0 0 0\n"
"MouseMoveEvent 179 257 0 0 0 0 0\n"
"MouseMoveEvent 180 256 0 0 0 0 0\n"
"MouseMoveEvent 181 255 0 0 0 0 0\n"
"MouseMoveEvent 183 254 0 0 0 0 0\n"
"MouseMoveEvent 184 253 0 0 0 0 0\n"
"MouseMoveEvent 185 252 0 0 0 0 0\n"
"MouseMoveEvent 186 251 0 0 0 0 0\n"
"MouseMoveEvent 187 250 0 0 0 0 0\n"
"MouseMoveEvent 188 249 0 0 0 0 0\n"
"MouseMoveEvent 189 248 0 0 0 0 0\n"
"MouseMoveEvent 190 246 0 0 0 0 0\n"
"MouseMoveEvent 191 245 0 0 0 0 0\n"
"LeftButtonPressEvent 191 245 0 0 0 0 0\n"
"StartInteractionEvent 191 245 0 0 0 0 0\n"
"TimerEvent 191 245 0 0 0 0 0\n"
"RenderEvent 191 245 0 0 0 0 0\n"
"MouseMoveEvent 191 247 0 0 0 0 0\n"
"TimerEvent 191 247 0 0 0 0 0\n"
"RenderEvent 191 247 0 0 0 0 0\n"
"MouseMoveEvent 192 248 0 0 0 0 0\n"
"TimerEvent 192 248 0 0 0 0 0\n"
"RenderEvent 192 248 0 0 0 0 0\n"
"MouseMoveEvent 195 251 0 0 0 0 0\n"
"TimerEvent 195 251 0 0 0 0 0\n"
"RenderEvent 195 251 0 0 0 0 0\n"
"MouseMoveEvent 197 252 0 0 0 0 0\n"
"TimerEvent 197 252 0 0 0 0 0\n"
"RenderEvent 197 252 0 0 0 0 0\n"
"TimerEvent 197 252 0 0 0 0 0\n"
"RenderEvent 197 252 0 0 0 0 0\n"
"TimerEvent 197 252 0 0 0 0 0\n"
"RenderEvent 197 252 0 0 0 0 0\n"
"MouseMoveEvent 201 252 0 0 0 0 0\n"
"MouseMoveEvent 202 252 0 0 0 0 0\n"
"MouseMoveEvent 203 252 0 0 0 0 0\n"
"TimerEvent 203 252 0 0 0 0 0\n"
"RenderEvent 203 252 0 0 0 0 0\n"
"MouseMoveEvent 210 252 0 0 0 0 0\n"
"MouseMoveEvent 211 252 0 0 0 0 0\n"
"TimerEvent 211 252 0 0 0 0 0\n"
"RenderEvent 211 252 0 0 0 0 0\n"
"MouseMoveEvent 214 251 0 0 0 0 0\n"
"TimerEvent 214 251 0 0 0 0 0\n"
"RenderEvent 214 251 0 0 0 0 0\n"
"TimerEvent 214 251 0 0 0 0 0\n"
"RenderEvent 214 251 0 0 0 0 0\n"
"TimerEvent 214 251 0 0 0 0 0\n"
"RenderEvent 214 251 0 0 0 0 0\n"
"TimerEvent 214 251 0 0 0 0 0\n"
"RenderEvent 214 251 0 0 0 0 0\n"
"TimerEvent 214 251 0 0 0 0 0\n"
"RenderEvent 214 251 0 0 0 0 0\n"
"MouseMoveEvent 216 251 0 0 0 0 0\n"
"TimerEvent 216 251 0 0 0 0 0\n"
"RenderEvent 216 251 0 0 0 0 0\n"
"MouseMoveEvent 218 250 0 0 0 0 0\n"
"LeftButtonReleaseEvent 218 250 0 0 0 0 0\n"
"EndInteractionEvent 218 250 0 0 0 0 0\n"
"RenderEvent 218 250 0 0 0 0 0\n"
"MouseMoveEvent 219 250 0 0 0 0 0\n"
"MouseMoveEvent 220 249 0 0 0 0 0\n"
"MouseMoveEvent 221 248 0 0 0 0 0\n"
"MouseMoveEvent 222 247 0 0 0 0 0\n"
"MouseMoveEvent 223 246 0 0 0 0 0\n"
"MouseMoveEvent 223 245 0 0 0 0 0\n"
"MouseMoveEvent 223 244 0 0 0 0 0\n"
"MouseMoveEvent 223 243 0 0 0 0 0\n"
"MouseMoveEvent 223 242 0 0 0 0 0\n"
"MouseMoveEvent 223 241 0 0 0 0 0\n"
"MouseMoveEvent 223 239 0 0 0 0 0\n"
"MouseMoveEvent 223 238 0 0 0 0 0\n"
"MouseMoveEvent 222 237 0 0 0 0 0\n"
"MouseMoveEvent 221 236 0 0 0 0 0\n"
"MouseMoveEvent 221 235 0 0 0 0 0\n"
"MouseMoveEvent 221 234 0 0 0 0 0\n"
"MouseMoveEvent 220 233 0 0 0 0 0\n"
"MouseMoveEvent 220 232 0 0 0 0 0\n"
"MouseMoveEvent 220 231 0 0 0 0 0\n"
"MouseMoveEvent 220 230 0 0 0 0 0\n"
"MouseMoveEvent 219 228 0 0 0 0 0\n"
"MouseMoveEvent 219 227 0 0 0 0 0\n"
"MouseMoveEvent 219 226 0 0 0 0 0\n"
"MouseMoveEvent 219 225 0 0 0 0 0\n"
"MouseMoveEvent 218 224 0 0 0 0 0\n"
"MouseMoveEvent 218 222 0 0 0 0 0\n"
"MouseMoveEvent 218 221 0 0 0 0 0\n"
"MouseMoveEvent 218 220 0 0 0 0 0\n"
"LeftButtonPressEvent 218 220 0 0 0 0 0\n"
"StartInteractionEvent 218 220 0 0 0 0 0\n"
"MouseMoveEvent 218 219 0 0 0 0 0\n"
"TimerEvent 218 219 0 0 0 0 0\n"
"RenderEvent 218 219 0 0 0 0 0\n"
"MouseMoveEvent 218 210 0 0 0 0 0\n"
"MouseMoveEvent 218 209 0 0 0 0 0\n"
"TimerEvent 218 209 0 0 0 0 0\n"
"RenderEvent 218 209 0 0 0 0 0\n"
"MouseMoveEvent 218 204 0 0 0 0 0\n"
"MouseMoveEvent 218 202 0 0 0 0 0\n"
"TimerEvent 218 202 0 0 0 0 0\n"
"RenderEvent 218 202 0 0 0 0 0\n"
"MouseMoveEvent 219 199 0 0 0 0 0\n"
"MouseMoveEvent 219 198 0 0 0 0 0\n"
"TimerEvent 219 198 0 0 0 0 0\n"
"RenderEvent 219 198 0 0 0 0 0\n"
"MouseMoveEvent 220 196 0 0 0 0 0\n"
"TimerEvent 220 196 0 0 0 0 0\n"
"RenderEvent 220 196 0 0 0 0 0\n"
"TimerEvent 220 196 0 0 0 0 0\n"
"RenderEvent 220 196 0 0 0 0 0\n"
"MouseMoveEvent 220 194 0 0 0 0 0\n"
"MouseMoveEvent 220 193 0 0 0 0 0\n"
"MouseMoveEvent 220 192 0 0 0 0 0\n"
"TimerEvent 220 192 0 0 0 0 0\n"
"RenderEvent 220 192 0 0 0 0 0\n"
"MouseMoveEvent 221 190 0 0 0 0 0\n"
"TimerEvent 221 190 0 0 0 0 0\n"
"RenderEvent 221 190 0 0 0 0 0\n"
"MouseMoveEvent 221 188 0 0 0 0 0\n"
"TimerEvent 221 188 0 0 0 0 0\n"
"RenderEvent 221 188 0 0 0 0 0\n"
"MouseMoveEvent 221 187 0 0 0 0 0\n"
"TimerEvent 221 187 0 0 0 0 0\n"
"RenderEvent 221 187 0 0 0 0 0\n"
"MouseMoveEvent 221 185 0 0 0 0 0\n"
"LeftButtonReleaseEvent 221 185 0 0 0 0 0\n"
"EndInteractionEvent 221 185 0 0 0 0 0\n"
"RenderEvent 221 185 0 0 0 0 0\n"
"MouseMoveEvent 221 184 0 0 0 0 0\n"
"MouseMoveEvent 220 182 0 0 0 0 0\n"
"MouseMoveEvent 220 181 0 0 0 0 0\n"
"MouseMoveEvent 219 180 0 0 0 0 0\n"
"MouseMoveEvent 220 178 0 0 0 0 0\n"
"MouseMoveEvent 221 177 0 0 0 0 0\n"
"MouseMoveEvent 222 177 0 0 0 0 0\n"
"MouseMoveEvent 223 177 0 0 0 0 0\n"
"MouseMoveEvent 225 178 0 0 0 0 0\n"
"MouseMoveEvent 226 178 0 0 0 0 0\n"
"MouseMoveEvent 227 178 0 0 0 0 0\n"
"MouseMoveEvent 228 179 0 0 0 0 0\n"
"MouseMoveEvent 230 179 0 0 0 0 0\n"
"MouseMoveEvent 233 180 0 0 0 0 0\n"
"MouseMoveEvent 234 180 0 0 0 0 0\n"
"MouseMoveEvent 236 181 0 0 0 0 0\n"
"MouseMoveEvent 238 182 0 0 0 0 0\n"
"MouseMoveEvent 239 182 0 0 0 0 0\n"
"MouseMoveEvent 241 183 0 0 0 0 0\n"
"MouseMoveEvent 243 184 0 0 0 0 0\n"
"MouseMoveEvent 244 185 0 0 0 0 0\n"
"MouseMoveEvent 245 185 0 0 0 0 0\n"
"MouseMoveEvent 246 186 0 0 0 0 0\n"
"MouseMoveEvent 247 187 0 0 0 0 0\n"
"MouseMoveEvent 249 188 0 0 0 0 0\n"
"MouseMoveEvent 250 189 0 0 0 0 0\n"
"MouseMoveEvent 252 190 0 0 0 0 0\n"
"MouseMoveEvent 254 192 0 0 0 0 0\n"
"MouseMoveEvent 257 194 0 0 0 0 0\n"
"MouseMoveEvent 260 197 0 0 0 0 0\n"
"MouseMoveEvent 263 200 0 0 0 0 0\n"
"MouseMoveEvent 268 207 0 0 0 0 0\n"
"MouseMoveEvent 274 214 0 0 0 0 0\n"
"MouseMoveEvent 280 224 0 0 0 0 0\n"
"MouseMoveEvent 284 234 0 0 0 0 0\n"
"MouseMoveEvent 289 243 0 0 0 0 0\n"
"MouseMoveEvent 290 252 0 0 0 0 0\n"
"MouseMoveEvent 293 261 0 0 0 0 0\n"
"MouseMoveEvent 295 273 0 0 0 0 0\n"
"MouseMoveEvent 295 284 0 0 0 0 0\n"
"MouseMoveEvent 297 296 0 0 0 0 0\n"
"MouseMoveEvent 299 309 0 0 0 0 0\n"
"MouseMoveEvent 300 320 0 0 0 0 0\n"
"MouseMoveEvent 300 331 0 0 0 0 0\n"
"MouseMoveEvent 300 338 0 0 0 0 0\n"
"MouseMoveEvent 300 345 0 0 0 0 0\n"
"MouseMoveEvent 300 351 0 0 0 0 0\n"
"MouseMoveEvent 300 357 0 0 0 0 0\n"
"MouseMoveEvent 300 364 0 0 0 0 0\n"
"MouseMoveEvent 300 370 0 0 0 0 0\n"
"MouseMoveEvent 300 374 0 0 0 0 0\n"
"MouseMoveEvent 300 380 0 0 0 0 0\n"
"MouseMoveEvent 300 386 0 0 0 0 0\n"
"MouseMoveEvent 302 390 0 0 0 0 0\n"
"MouseMoveEvent 304 394 0 0 0 0 0\n"
"MouseMoveEvent 304 397 0 0 0 0 0\n"
"MouseMoveEvent 305 399 0 0 0 0 0\n"
;

int TestGPURayCastVolumeUpdate(int argc, char *argv[])
{
  cout << "CTEST_FULL_OUTPUT (Avoid ctest truncation of output)" << endl;

  double scalarRange[2];

  vtkNew<vtkActor> outlineActor;
  vtkNew<vtkPolyDataMapper> outlineMapper;
  vtkNew<vtkGPUVolumeRayCastMapper> volumeMapper;

  vtkNew<vtkXMLImageDataReader> reader;
  const char* volumeFile = vtkTestUtilities::ExpandDataFileName(
                            argc, argv, "Data/vase_1comp.vti");
  reader->SetFileName(volumeFile);
  volumeMapper->SetInputConnection(reader->GetOutputPort());

  // Add outline filter
  vtkNew<vtkOutlineFilter> outlineFilter;
  outlineFilter->SetInputConnection(reader->GetOutputPort());
  outlineMapper->SetInputConnection(outlineFilter->GetOutputPort());
  outlineActor->SetMapper(outlineMapper.GetPointer());

  volumeMapper->GetInput()->GetScalarRange(scalarRange);
  volumeMapper->SetSampleDistance(0.1);
  volumeMapper->SetAutoAdjustSampleDistances(0);
  volumeMapper->SetBlendModeToComposite();

  vtkNew<vtkRenderWindow> renWin;
  renWin->SetMultiSamples(0);
  vtkNew<vtkRenderer> ren;
  renWin->AddRenderer(ren.GetPointer());
  renWin->SetSize(400, 400);
  ren->SetBackground(0.2, 0.2, 0.5);

  vtkNew<vtkRenderWindowInteractor> iren;
  iren->SetRenderWindow(renWin.GetPointer());
  vtkNew<vtkInteractorStyleTrackballCamera> style;
  iren->SetInteractorStyle(style.GetPointer());

  vtkNew<vtkPiecewiseFunction> scalarOpacity;
  scalarOpacity->AddPoint(50, 0.0);
  scalarOpacity->AddPoint(75, 1.0);

  vtkNew<vtkVolumeProperty> volumeProperty;
  volumeProperty->ShadeOn();
  volumeProperty->SetInterpolationType(VTK_LINEAR_INTERPOLATION);
  volumeProperty->SetScalarOpacity(scalarOpacity.GetPointer());

  vtkSmartPointer<vtkColorTransferFunction> colorTransferFunction =
    volumeProperty->GetRGBTransferFunction(0);
  colorTransferFunction->RemoveAllPoints();
  colorTransferFunction->AddRGBPoint(scalarRange[0], 0.6, 0.4, 0.1);

  vtkSmartPointer<vtkVolume> volume = vtkSmartPointer<vtkVolume>::New();
  volume->SetMapper(volumeMapper.GetPointer());
  volume->SetProperty(volumeProperty.GetPointer());

  /// Add sphere in the center of volume
  int dims[3];
  double spacing[3], center[3], origin[3];
  reader->Update();
  vtkSmartPointer<vtkImageData> im = reader->GetOutput();
  im->GetDimensions(dims);
  im->GetOrigin(origin);
  im->GetSpacing(spacing);

  center[0] = origin[0] + spacing[0]*dims[0]/2.0;
  center[1] = origin[1] + spacing[1]*dims[1]/2.0;
  center[2] = origin[2] + spacing[2]*dims[2]/2.0;

  ren->AddViewProp(volume.GetPointer());
  ren->AddActor(outlineActor.GetPointer());

  int valid = volumeMapper->IsRenderSupported(renWin.GetPointer(),
                                              volumeProperty.GetPointer());

  int retVal;
  if (valid)
    {
    renWin->Render();
    ren->ResetCamera();

    vtkNew<vtkRTAnalyticSource> wavelet;
    wavelet->SetWholeExtent(-127, 128,
                            -127, 128,
                            -127, 128);
    wavelet->SetCenter(center);
    outlineFilter->SetInputConnection(wavelet->GetOutputPort());
    volumeMapper->SetInputConnection(wavelet->GetOutputPort());
    outlineFilter->UpdateWholeExtent();
    ren->ResetCamera();
    renWin->Render();

    iren->Initialize();
    retVal = !( vtkTesting::InteractorEventLoop(argc, argv,
                                                iren.GetPointer(),
                                                TestGPURayCastVolumeUpdateLog));
    }
  else
    {
    retVal = vtkTesting::PASSED;
    cout << "Required extensions not supported" << endl;
    }

  return !retVal;
}
