/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.texture.procedural;

import java.awt.image.BufferedImage;
import java.util.Random;

public class TextureGenerator {
    private static final float CR00 = -0.5f;
    private static final float CR01 = 1.5f;
    private static final float CR02 = -1.5f;
    private static final float CR03 = 0.5f;
    private static final float CR10 = 1.0f;
    private static final float CR11 = -2.5f;
    private static final float CR12 = 2.0f;
    private static final float CR13 = -0.5f;
    private static final float CR20 = -0.5f;
    private static final float CR21 = 0.0f;
    private static final float CR22 = 0.5f;
    private static final float CR23 = 0.0f;
    private static final float CR30 = 0.0f;
    private static final float CR31 = 1.0f;
    private static final float CR32 = 0.0f;
    private static final float CR33 = 0.0f;
    private Random rgen = new Random();

    public void setRandomSeed(long l) {
        this.rgen = new Random(l);
    }

    public float[] generateSynthesisTexture(float[] fArray, float f, float f2, int n, int n2) {
        int n3 = n2 * n;
        float[] fArray2 = fArray == null || fArray.length < n3 ? new float[n3] : fArray;
        int n4 = (int)f + 2;
        float[] fArray3 = this.generateSynthesisTexture(f, f2, n, n2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n5 = i * n + j;
                fArray2[n5] = fArray2[n5] + fArray3[i * n + j];
            }
        }
        return fArray2;
    }

    public int[] generateMixedTerrainTexture(int[] nArray, float[] fArray, int n, int n2, BufferedImage[] bufferedImageArray, float[] fArray2, int n3) {
        int n4;
        int n5 = n * n2;
        int[] nArray2 = nArray == null || nArray.length < n5 ? new int[n5] : nArray;
        float[] fArray3 = new float[n3];
        float[] fArray4 = new float[n3];
        int[] nArray3 = new int[n3];
        int[][] nArray4 = new int[n3][2];
        for (n4 = 0; n4 < n3; ++n4) {
            fArray4[n4] = fArray2[n4 + 1] - fArray2[n4];
            nArray4[n4][0] = bufferedImageArray[n4].getWidth();
            nArray4[n4][1] = bufferedImageArray[n4].getHeight();
        }
        n4 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n6;
                int n7;
                int n8;
                float f = fArray[i * n + j];
                for (n8 = 0; n8 < n3; ++n8) {
                    fArray3[n8] = this.texMixFactor(fArray2[n8 + 1], f, fArray4[n8]);
                    n7 = j % nArray4[n8][0];
                    n6 = i % nArray4[n8][1];
                    nArray3[n8] = bufferedImageArray[n8].getRGB(n7, n6);
                }
                n8 = 0;
                n7 = 0;
                n6 = 0;
                for (int k = 0; k < n3; ++k) {
                    if (fArray3[k] == 0.0f) continue;
                    int n9 = nArray3[k] >> 16 & 0xFF;
                    int n10 = nArray3[k] >> 8 & 0xFF;
                    int n11 = nArray3[k] & 0xFF;
                    n8 = (int)((float)n8 + (float)n9 * fArray3[k]);
                    n7 = (int)((float)n7 + (float)n10 * fArray3[k]);
                    n6 = (int)((float)n6 + (float)n11 * fArray3[k]);
                }
                nArray2[n4++] = ((n8 & 0xFF) << 16) + ((n8 & 0xFF) << 8) + (n6 & 0xFF);
            }
        }
        return nArray2;
    }

    public byte[] generateMixedTerrainTexture(byte[] byArray, float[] fArray, int n, int n2, BufferedImage[] bufferedImageArray, float[] fArray2, int n3) {
        int n4;
        int n5 = n * n2 * 3;
        byte[] byArray2 = byArray == null || byArray.length < n5 ? new byte[n5] : byArray;
        float[] fArray3 = new float[n3];
        float[] fArray4 = new float[n3];
        int[] nArray = new int[n3];
        int[][] nArray2 = new int[n3][2];
        for (n4 = 0; n4 < n3; ++n4) {
            fArray4[n4] = fArray2[n4 + 1] - fArray2[n4];
            nArray2[n4][0] = bufferedImageArray[n4].getWidth();
            nArray2[n4][1] = bufferedImageArray[n4].getHeight();
        }
        n4 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n6;
                int n7;
                int n8;
                float f = fArray[i * n + j];
                for (n8 = 0; n8 < n3; ++n8) {
                    fArray3[n8] = this.texMixFactor(fArray2[n8 + 1], f, fArray4[n8]);
                    n7 = j % nArray2[n8][0];
                    n6 = i % nArray2[n8][1];
                    nArray[n8] = bufferedImageArray[n8].getRGB(n7, n6);
                }
                n8 = 0;
                n7 = 0;
                n6 = 0;
                for (int k = 0; k < n3; ++k) {
                    if (fArray3[k] == 0.0f) continue;
                    int n9 = nArray[k] >> 16 & 0xFF;
                    int n10 = nArray[k] >> 8 & 0xFF;
                    int n11 = nArray[k] & 0xFF;
                    n8 = (int)((float)n8 + (float)n9 * fArray3[k]);
                    n7 = (int)((float)n7 + (float)n10 * fArray3[k]);
                    n6 = (int)((float)n6 + (float)n11 * fArray3[k]);
                }
                byArray2[n4] = (byte)n8;
                byArray2[n4 + 1] = (byte)n7;
                byArray2[n4 + 2] = (byte)n6;
                n4 += 3;
            }
        }
        return byArray2;
    }

    public int[] generateMixedTerrainTexture(int[] nArray, float[][] fArray, BufferedImage[] bufferedImageArray, float[] fArray2, int n) {
        int n2;
        int n3 = fArray.length * fArray[0].length;
        int[] nArray2 = nArray == null || nArray.length < n3 ? new int[n3] : nArray;
        float[] fArray3 = new float[n];
        float[] fArray4 = new float[n];
        int[] nArray3 = new int[n];
        int[][] nArray4 = new int[n][2];
        for (n2 = 0; n2 < n; ++n2) {
            fArray4[n2] = fArray2[n2 + 1] - fArray2[n2];
            nArray4[n2][0] = bufferedImageArray[n2].getWidth();
            nArray4[n2][1] = bufferedImageArray[n2].getHeight();
        }
        n2 = fArray.length;
        int n4 = fArray[0].length;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n6;
                int n7;
                int n8;
                float f = fArray[i][j];
                for (n8 = 0; n8 < n; ++n8) {
                    fArray3[n8] = this.texMixFactor(fArray2[n8 + 1], f, fArray4[n8]);
                    n7 = j % nArray4[n8][0];
                    n6 = i % nArray4[n8][1];
                    nArray3[n8] = bufferedImageArray[n8].getRGB(n7, n6);
                }
                n8 = 0;
                n7 = 0;
                n6 = 0;
                for (int k = 0; k < n; ++k) {
                    if (fArray3[k] == 0.0f) continue;
                    int n9 = nArray3[k] >> 16 & 0xFF;
                    int n10 = nArray3[k] >> 8 & 0xFF;
                    int n11 = nArray3[k] & 0xFF;
                    n8 = (int)((float)n8 + (float)n9 * fArray3[k]);
                    n7 = (int)((float)n7 + (float)n10 * fArray3[k]);
                    n6 = (int)((float)n6 + (float)n11 * fArray3[k]);
                }
                nArray2[n5++] = ((n8 & 0xFF) << 16) + ((n8 & 0xFF) << 8) + (n6 & 0xFF);
            }
        }
        return nArray2;
    }

    public byte[] generateMixedTerrainTexture(byte[] byArray, float[][] fArray, BufferedImage[] bufferedImageArray, float[] fArray2, int n) {
        int n2;
        int n3 = fArray.length * fArray[0].length * 3;
        byte[] byArray2 = byArray == null || byArray.length < n3 ? new byte[n3] : byArray;
        float[] fArray3 = new float[n];
        float[] fArray4 = new float[n];
        int[] nArray = new int[n];
        int[][] nArray2 = new int[n][2];
        for (n2 = 0; n2 < n; ++n2) {
            fArray4[n2] = fArray2[n2 + 1] - fArray2[n2];
            nArray2[n2][0] = bufferedImageArray[n2].getWidth();
            nArray2[n2][1] = bufferedImageArray[n2].getHeight();
        }
        n2 = fArray.length;
        int n4 = fArray[0].length;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n6;
                int n7;
                int n8;
                float f = fArray[i][j];
                for (n8 = 0; n8 < n; ++n8) {
                    fArray3[n8] = this.texMixFactor(fArray2[n8 + 1], f, fArray4[n8]);
                    n7 = j % nArray2[n8][0];
                    n6 = i % nArray2[n8][1];
                    nArray[n8] = bufferedImageArray[n8].getRGB(n7, n6);
                }
                n8 = 0;
                n7 = 0;
                n6 = 0;
                for (int k = 0; k < n; ++k) {
                    if (fArray3[k] == 0.0f) continue;
                    int n9 = nArray[k] >> 16 & 0xFF;
                    int n10 = nArray[k] >> 8 & 0xFF;
                    int n11 = nArray[k] & 0xFF;
                    n8 = (int)((float)n8 + (float)n9 * fArray3[k]);
                    n7 = (int)((float)n7 + (float)n10 * fArray3[k]);
                    n6 = (int)((float)n6 + (float)n11 * fArray3[k]);
                }
                byArray2[n5] = (byte)n8;
                byArray2[n5 + 1] = (byte)n7;
                byArray2[n5 + 2] = (byte)n6;
                n5 += 3;
            }
        }
        return byArray2;
    }

    private float texMixFactor(float f, float f2, float f3) {
        float f4 = (f3 - Math.abs(f - f2)) / f3;
        if (f4 < 0.0f) {
            f4 = 0.0f;
        } else if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        return f4;
    }

    private float[] generateSynthesisTexture(float f, float f2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = (int)f + 2;
        float f3 = (float)n / (f - 1.0f);
        float f4 = (float)n2 / (f - 1.0f);
        float f5 = 1.0f / f3;
        float f6 = 1.0f / f4;
        float[] fArray = new float[n6 * n6];
        float[] fArray2 = new float[n6 * n];
        float[] fArray3 = new float[n6];
        float[] fArray4 = new float[n * n2];
        for (n5 = 0; n5 < n6; ++n5) {
            for (n4 = 0; n4 < n6; ++n4) {
                fArray[n5 * n6 + n4] = this.rgen.nextFloat() * 2.0f - 1.0f;
            }
        }
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = n5 * n6;
            float f7 = 0.0f;
            for (n3 = 0; n3 < n; ++n3) {
                fArray2[n5 * n + n3] = this.spline(f7 * f5, 4, fArray, n4);
                if (!((f7 += 1.0f) >= f3)) continue;
                f7 -= f3;
                ++n4;
            }
        }
        for (n5 = 0; n5 < n; ++n5) {
            float f8 = 0.0f;
            int n7 = 0;
            for (n3 = 0; n3 < n6; ++n3) {
                fArray3[n3] = fArray2[n3 * n + n5];
            }
            for (n3 = 0; n3 < n2; ++n3) {
                fArray4[n3 * n + n5] = this.spline(f8 * f6, 4, fArray3, n7) * f2;
                if (!((f8 += 1.0f) >= f4)) continue;
                f8 -= f4;
                ++n7;
            }
        }
        return fArray4;
    }

    private float spline(float f, int n, float[] fArray, int n2) {
        int n3 = n - 3;
        if (n3 < 1) {
            return 0.0f;
        }
        int n4 = (int)(f = (f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f)) * (float)n3);
        if (n4 >= n - 3) {
            n4 = n - 3;
        }
        float f2 = -0.5f * fArray[(n2 += n4) + 0] + 1.5f * fArray[n2 + 1] + -1.5f * fArray[n2 + 2] + 0.5f * fArray[n2 + 3];
        float f3 = 1.0f * fArray[n2 + 0] + -2.5f * fArray[n2 + 1] + 2.0f * fArray[n2 + 2] + -0.5f * fArray[n2 + 3];
        float f4 = -0.5f * fArray[n2 + 0] + 0.0f * fArray[n2 + 1] + 0.5f * fArray[n2 + 2] + 0.0f * fArray[n2 + 3];
        float f5 = 0.0f * fArray[n2 + 0] + 1.0f * fArray[n2 + 1] + 0.0f * fArray[n2 + 2] + 0.0f * fArray[n2 + 3];
        return ((f2 * (f -= (float)n4) + f3) * f + f4) * f + f5;
    }
}

