/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkVectorText.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkVectorText.h"

#include "vtkCellArray.h"
#include "vtkInformation.h"
#include "vtkInformationVector.h"
#include "vtkObjectFactory.h"
#include "vtkPoints.h"
#include "vtkPolyData.h"
#include "vtkTransformPolyDataFilter.h"

#include <locale.h>

vtkStandardNewMacro(vtkVectorText);

typedef struct {
  float x;
  float y;
} VTK_VECTOR_TEXT_POINT;

typedef struct {
  int p1;
  int p2;
  int p3;
} VTK_VECTOR_TEXT_TRIANGLE;

typedef struct {
  float width;
  const VTK_VECTOR_TEXT_POINT *points;
  int ptCount;
  const VTK_VECTOR_TEXT_TRIANGLE *triangles;
  int triCount;
} VTK_VECTOR_TEXT_GLYPH;

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_33 [] = {
{ 0.28000f,-0.07186f}, { 0.43164f,-0.07143f}, { 0.27689f, 0.07714f}, { 0.43472f, 0.07714f}, { 0.32000f, 0.20134f},
{ 0.40000f, 0.20243f}, { 0.31429f, 0.20550f}, { 0.27277f, 0.76857f}, { 0.43848f, 0.76857f}, { 0.27693f, 1.02571f},
{ 0.43429f, 1.02615f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_33 [] = {
{ 2, 1, 3}, { 2, 0, 1}, { 7, 6, 5}, { 6, 4, 5}, { 8, 7, 5}, { 7, 8, 9}, {10, 9, 8},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_34 [] = {
{ 0.25714f, 0.63563f}, { 0.32571f, 0.63563f}, { 0.50286f, 0.63642f}, { 0.25143f, 0.63946f}, { 0.33143f, 0.63840f},
{ 0.33462f, 0.64286f}, { 0.49673f, 0.64286f}, { 0.57714f, 0.63757f}, { 0.58093f, 0.64286f}, { 0.21335f, 0.84286f},
{ 0.36680f, 0.84286f}, { 0.46177f, 0.84286f}, { 0.61522f, 0.84286f}, { 0.21295f, 1.02000f}, { 0.46134f, 1.02000f},
{ 0.61563f, 1.02000f}, { 0.36571f, 1.02307f}, { 0.46550f, 1.02571f}, { 0.21714f, 1.02615f}, { 0.36000f, 1.02723f},
{ 0.61143f, 1.02615f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_34 [] = {
{ 3, 5, 9}, { 7, 6, 2}, { 4, 5, 1}, { 6, 8, 12}, { 0, 1, 5}, { 6,12,11}, { 3, 0, 5},
{ 7, 8, 6}, {11,12,14}, {13, 9,10}, {10, 9,  5}, {15,14,12}, {19,18,10}, {18,13,10},
{17,14,20}, {14,15,20}, {16, 19, 10},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_35 [] = {
{ 0.22286f,-0.09100f}, { 0.32571f,-0.09236f}, { 0.56832f,-0.08857f}, { 0.67429f,-0.09201f}, { 0.28193f, 0.22000f},
{ 0.39470f, 0.22000f}, { 0.63009f, 0.22000f}, { 0.15385f, 0.23143f}, { 0.27429f, 0.22723f}, { 0.40571f, 0.22723f},
{ 0.62286f, 0.22723f}, { 0.74857f, 0.22680f}, { 0.97454f, 0.23143f}, { 0.15385f, 0.33429f}, { 0.97454f, 0.33429f},
{ 0.30344f, 0.34000f}, { 0.65201f, 0.34000f}, { 0.77084f, 0.34000f}, { 0.42286f, 0.34010f}, { 0.42034f, 0.34571f},
{ 0.36041f, 0.60286f}, { 0.70748f, 0.60286f}, { 0.82034f, 0.60286f}, { 0.47429f, 0.60626f}, { 0.15385f, 0.61429f},
{ 0.35429f, 0.61009f}, { 0.70286f, 0.60951f}, { 0.82857f, 0.61009f}, { 0.97454f, 0.61429f}, { 0.15385f, 0.71714f},
{ 0.37714f, 0.72134f}, { 0.50286f, 0.72191f}, { 0.72571f, 0.72134f}, { 0.85143f, 0.72156f}, { 0.97143f, 0.72025f},
{ 0.38605f, 0.72857f}, { 0.49823f, 0.72857f}, { 0.73335f, 0.72857f}, { 0.84613f, 0.72857f}, { 0.45143f, 1.04160f},
{ 0.55735f, 1.04286f}, { 0.80000f, 1.04243f}, { 0.90521f, 1.04286f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_35 [] = {
{ 6, 2, 3}, { 5, 0, 1}, { 0, 5, 4}, {18, 9,10}, {11, 6, 3}, { 4, 9, 8}, {13, 8,15},
{17, 6,11}, { 9, 4, 5}, {13, 7, 8}, {17,12,14}, { 8, 9,15}, {15,19,20}, {16, 6,17},
{12,17,11}, {18,10,16}, {10, 6,16}, {21,16,17}, {18,19, 9}, {15, 9,19}, {20,30,25},
{23,20,19}, {34,33,28}, {29,24,25}, {29,25,30}, {27,21,22}, {33,21,27}, {20,23,30},
{22,21,17}, {33,27,28}, {31,26,32}, {35,30,23}, {32,38,37}, {31,35,23}, {21,32,26},
{26,31,23}, {32,21,38}, {41,37,38}, {36,35,31}, {38,21,33}, {40,39,36}, {42,41,38},
{39,35,36},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_36 [] = {
{ 0.52571f,-0.22882f}, { 0.59429f,-0.22991f}, { 0.52000f,-0.09942f}, { 0.60571f,-0.09385f}, { 0.40571f,-0.07057f},
{ 0.72730f,-0.06571f}, { 0.33143f,-0.03465f}, { 0.80571f,-0.01813f}, { 0.51429f, 0.01891f}, { 0.52152f, 0.02571f},
{ 0.60571f, 0.02014f}, { 0.84571f, 0.02168f}, { 0.25669f, 0.04286f}, { 0.66857f, 0.03800f}, { 0.44571f, 0.04535f},
{ 0.70984f, 0.06571f}, { 0.74535f, 0.10571f}, { 0.74857f, 0.11079f}, { 0.74902f, 0.11143f}, { 0.37057f, 0.12857f},
{ 0.90538f, 0.12857f}, { 0.20823f, 0.15143f}, { 0.35748f, 0.16286f}, { 0.77395f, 0.16857f}, { 0.35429f, 0.17310f},
{ 0.35177f, 0.18000f}, { 0.78134f, 0.21429f}, { 0.92152f, 0.21429f}, { 0.19580f, 0.22571f}, { 0.33480f, 0.25429f},
{ 0.77395f, 0.29429f}, { 0.91177f, 0.32286f}, { 0.76000f, 0.32921f}, { 0.72571f, 0.36972f}, { 0.89355f, 0.37429f},
{ 0.64690f, 0.40857f}, { 0.65143f, 0.40706f}, { 0.64000f, 0.41109f}, { 0.60571f, 0.41986f}, { 0.52109f, 0.43714f},
{ 0.85714f, 0.43270f}, { 0.38857f, 0.49216f}, { 0.79429f, 0.48902f}, { 0.72571f, 0.52437f}, { 0.30454f, 0.54571f},
{ 0.60260f, 0.56286f}, { 0.52043f, 0.58571f}, { 0.26286f, 0.59570f}, { 0.46857f, 0.59800f}, { 0.39429f, 0.65095f},
{ 0.22857f, 0.67295f}, { 0.36823f, 0.70000f}, { 0.75429f, 0.77624f}, { 0.21907f, 0.78571f}, { 0.35891f, 0.78571f},
{ 0.89184f, 0.79714f}, { 0.37714f, 0.85001f}, { 0.72571f, 0.86144f}, { 0.87470f, 0.86571f}, { 0.24571f, 0.89016f},
{ 0.68571f, 0.90956f}, { 0.44000f, 0.92036f}, { 0.60571f, 0.94469f}, { 0.83179f, 0.94571f}, { 0.28000f, 0.94629f},
{ 0.51429f, 0.94891f}, { 0.34286f, 1.00607f}, { 0.75429f, 1.01579f}, { 0.38286f, 1.02784f}, { 0.52043f, 1.06571f},
{ 0.60260f, 1.06571f}, { 0.52260f, 1.12286f}, { 0.60043f, 1.12286f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_36 [] = {
{ 3, 8, 2}, { 2, 8, 4}, {19,12, 6}, {13,11,15}, { 9, 8,10}, { 3, 2, 1}, { 8, 3,10},
{ 5,13,10}, {15,11,16}, { 7,13, 5}, { 4,14, 6}, { 2, 0, 1}, { 5,10, 3}, {12,22,21},
{14, 4, 8}, {13, 7,11}, {11,18,16}, {20,23,18}, {18,17,16}, {20,18,11}, {19, 6,14},
{28,21,29}, {26,23,20}, {12,19,22}, {25,22,24}, {21,22,25}, {21,25,29}, {26,27,30},
{27,26,20}, {31,32,30}, {31,30,27}, {40,33,32}, {37,43,38}, {34,32,31}, {38,39, 9},
{40,32,34}, {38, 9,10}, {43,33,42}, {37,36,43}, {39,38,43}, {42,33,40}, {35,36,37},
{33,43,36}, {39,45,46}, {48,41,39}, {45,39,43}, {41,48,44}, {47,51,50}, {46,62,65},
{48,39,46}, {44,49,47}, {49,44,48}, {54,53,50}, {51,47,49}, {53,56,59}, {53,54,56},
{66,64,56}, {55,58,52}, {58,57,52}, {54,50,51}, {59,56,64}, {67,60,63}, {60,57,63},
{66,61,68}, {61,66,56}, {68,65,69}, {65,62,69}, {62,46,45}, {63,57,58}, {62,60,67},
{68,61,65}, {71,70,72}, {70,62,67}, {62,70,69}, {71,69,70},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_37 [] = {
{ 0.46713f,-0.11143f}, { 0.57143f,-0.11215f}, { 1.19429f,-0.11252f}, { 1.10286f,-0.10252f}, { 1.26444f,-0.09429f},
{ 1.05143f,-0.07759f}, { 1.31429f,-0.06384f}, { 1.14857f,-0.01538f}, { 1.18857f,-0.01807f}, { 0.98857f,-0.01364f},
{ 1.22286f,-0.00771f}, { 1.36784f,-0.00286f}, { 1.11302f, 0.00286f}, { 1.26436f, 0.03143f}, { 1.07787f, 0.04857f},
{ 0.95748f, 0.05429f}, { 1.39681f, 0.06571f}, { 1.28680f, 0.09429f}, { 1.05866f, 0.14000f}, { 1.40991f, 0.14571f},
{ 0.94134f, 0.15143f}, { 0.94134f, 0.21429f}, { 1.29295f, 0.21429f}, { 1.06134f, 0.23714f}, { 1.40723f, 0.23714f},
{ 0.95748f, 0.30000f}, { 1.39387f, 0.30000f}, { 1.07787f, 0.30571f}, { 1.27429f, 0.30371f}, { 1.09561f, 0.33429f},
{ 1.23429f, 0.35465f}, { 1.36616f, 0.36286f}, { 1.13143f, 0.36327f}, { 1.16571f, 0.37277f}, { 1.20571f, 0.36899f},
{ 1.00045f, 0.38571f}, { 1.32000f, 0.41543f}, { 1.06857f, 0.44498f}, { 1.24571f, 0.45681f}, { 0.48000f, 0.46420f},
{ 1.15429f, 0.46723f}, { 0.38857f, 0.47462f}, { 0.55016f, 0.48286f}, { 0.60000f, 0.51330f}, { 0.30286f, 0.52704f},
{ 0.43429f, 0.56177f}, { 0.47429f, 0.55907f}, { 0.26857f, 0.57284f}, { 0.50857f, 0.56943f}, { 0.65355f, 0.57429f},
{ 0.39873f, 0.58000f}, { 0.55007f, 0.60857f}, { 0.24530f, 0.62571f}, { 0.36359f, 0.62571f}, { 0.68252f, 0.64286f},
{ 0.56680f, 0.64857f}, { 0.23050f, 0.69429f}, { 0.34437f, 0.71714f}, { 0.57866f, 0.72286f}, { 0.69563f, 0.72286f},
{ 0.22705f, 0.79143f}, { 0.34705f, 0.81429f}, { 0.69295f, 0.81429f}, { 0.56891f, 0.85429f}, { 0.67959f, 0.87714f},
{ 0.24530f, 0.88286f}, { 0.36359f, 0.88286f}, { 0.38132f, 0.91143f}, { 0.54286f, 0.90975f}, { 0.52000f, 0.93179f},
{ 0.65465f, 0.93429f}, { 0.41714f, 0.94041f}, { 0.47429f, 0.94950f}, { 0.29143f, 0.96914f}, { 0.60571f, 0.99258f},
{ 0.32000f, 0.99868f}, { 0.38286f, 1.03395f}, { 0.53714f, 1.03184f}, { 1.06857f, 1.04249f}, { 1.17287f, 1.04286f},
{ 0.48000f, 1.04395f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_37 [] = {
{ 0, 1,78}, {10, 4, 6}, { 2, 8, 3}, { 9,14,15}, { 4,10, 8}, { 3, 7, 5}, { 7, 3, 8},
{10, 6,13}, {12, 5, 7}, { 5,12, 9}, { 4, 8, 2}, {13,16,17}, {17,19,22}, {14, 9,12},
{15,18,20}, {11,13, 6}, {13,11,16}, {17,16,19}, {18,15,14}, {21,20,18}, {21,23,25},
{22,26,28}, {23,21,18}, {24,22,19}, {25,27,35}, {35,29,37}, {22,24,26}, {28,31,30},
{27,25,23}, {31,28,26}, {27,29,35}, {36,30,31}, {38,34,30}, {38,33,34}, {37,32,40},
{32,33,40}, {38,30,36}, {32,37,29}, {40,33,38}, {42,46,39}, {47,53,52}, {48,43,51},
{39,46,41}, {41,50,44}, {56,57,60}, {45,41,46}, {42,48,46}, {48,42,43}, {50,41,45},
{53,47,44}, {51,49,55}, {54,55,49}, {53,44,50}, {49,51,43}, {55,54,58}, {59,58,54},
{57,56,52}, {57,52,53}, {60,61,65}, {58,62,63}, {57,61,60}, {62,64,63}, {65,66,73},
{66,65,61}, {73,66,75}, {58,59,62}, {63,64,68}, {70,69,68}, {67,75,66}, {70,68,64},
{76,71,72}, {75,67,76}, {74,69,70}, {71,76,67}, {69,77,72}, {72,77,80}, {77,69,74},
{76,72,80}, {79,78, 1},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_38 [] = {
{ 0.58857f,-0.08966f}, { 1.03429f,-0.09235f}, { 0.48000f,-0.08395f}, { 0.66286f,-0.07673f}, { 0.40000f,-0.05914f},
{ 0.72000f,-0.05641f}, { 0.98286f,-0.05473f}, { 0.35429f,-0.03393f}, { 0.78857f,-0.01678f}, { 1.12629f, 0.00857f},
{ 0.29143f, 0.02168f}, { 0.52571f, 0.02991f}, { 0.57714f, 0.02764f}, { 0.62286f, 0.03756f}, { 0.46857f, 0.04645f},
{ 0.87429f, 0.05495f}, { 0.69714f, 0.07393f}, { 0.42132f, 0.08286f}, { 1.04571f, 0.07868f}, { 0.24486f, 0.08857f},
{ 0.75011f, 0.11714f}, { 0.22327f, 0.14000f}, { 0.37927f, 0.14571f}, { 0.78349f, 0.16286f}, { 0.96893f, 0.16286f},
{ 0.96571f, 0.16717f}, { 0.96457f, 0.16857f}, { 0.95937f, 0.18000f}, { 0.35580f, 0.22571f}, { 0.20991f, 0.25429f},
{ 0.36319f, 0.28857f}, { 0.86286f, 0.29600f}, { 1.02437f, 0.31143f}, { 0.22645f, 0.32857f}, { 0.40418f, 0.36286f},
{ 0.40571f, 0.36454f}, { 0.41330f, 0.37429f}, { 1.05421f, 0.40857f}, { 0.28418f, 0.42571f}, { 0.92000f, 0.44119f},
{ 0.53714f, 0.46770f}, { 0.37143f, 0.50250f}, { 0.66758f, 0.54000f}, { 0.46406f, 0.55714f}, { 0.78704f, 0.62571f},
{ 0.59429f, 0.63146f}, { 0.37714f, 0.68444f}, { 0.69296f, 0.70000f}, { 0.85355f, 0.71714f}, { 0.35681f, 0.73429f},
{ 0.50200f, 0.75143f}, { 0.49756f, 0.76286f}, { 0.49502f, 0.76857f}, { 0.72891f, 0.76857f}, { 0.86966f, 0.76857f},
{ 0.34748f, 0.82000f}, { 0.73295f, 0.82000f}, { 0.48764f, 0.82571f}, { 0.87236f, 0.83143f}, { 0.49714f, 0.86089f},
{ 0.35849f, 0.87143f}, { 0.71429f, 0.87650f}, { 0.52000f, 0.89555f}, { 0.69714f, 0.89846f}, { 0.37964f, 0.91714f},
{ 0.84657f, 0.91714f}, { 0.55429f, 0.92073f}, { 0.65714f, 0.92498f}, { 0.60000f, 0.93277f}, { 0.81868f, 0.95714f},
{ 0.42857f, 0.97582f}, { 0.76571f, 1.00436f}, { 0.51429f, 1.02723f}, { 0.72000f, 1.02723f}, { 0.59429f, 1.04437f},
{ 0.64571f, 1.04395f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_38 [] = {
{ 7,17,10}, { 3,13, 0}, { 2,14, 4}, { 6,18,15}, {17, 7, 4}, { 9,18, 6}, { 9, 6, 1},
{ 8,16, 5}, { 0,12, 2}, {17, 4,14}, { 2,11,14}, {12, 0,13}, {13, 5,16}, {15,24,20},
{16, 8,20}, {13, 3, 5}, { 2,12,11}, {10,17,19}, {21,28,29}, {15,20, 8}, {20,24,23},
{40,23,31}, {24,25,26}, {19,22,21}, {31,23,27}, {22,19,17}, {18,24,15}, {28,21,22},
{29,30,33}, {31,32,39}, {23,24,26}, {30,29,28}, {23,26,27}, {33,30,38}, {32,31,27},
{38,36,41}, {38,34,36}, {34,38,30}, {36,34,35}, {39,32,37}, {42,40,31}, {40,41,36},
{42,44,47}, {45,43,40}, {40,43,41}, {50,46,43}, {50,49,46}, {45,40,42}, {48,53,47},
{45,42,47}, {49,52,55}, {53,48,56}, {50,43,45}, {57,60,55}, {52,50,51}, {49,50,52},
{48,47,44}, {54,56,48}, {56,65,61}, {60,59,64}, {59,60,57}, {65,56,58}, {52,57,55},
{64,59,70}, {58,56,54}, {59,62,70}, {68,74,72}, {65,69,61}, {70,66,72}, {63,71,67},
{63,61,69}, {70,62,66}, {67,73,68}, {71,63,69}, {73,67,71}, {68,72,66}, {74,68,75},
{75,68,73},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_39 [] = {
{ 0.25143f, 0.63563f}, { 0.24571f, 0.63946f}, { 0.32571f, 0.63757f}, { 0.32950f, 0.64286f}, { 0.21034f, 0.83714f},
{ 0.36379f, 0.83714f}, { 0.20991f, 1.02000f}, { 0.36420f, 1.02000f}, { 0.21408f, 1.02571f}, { 0.36000f, 1.02615f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_39 [] = {
{ 1, 0, 3}, { 2, 3, 0}, { 1, 3, 4}, { 7, 6, 4}, { 5, 4, 3}, { 7, 4, 5}, { 8, 6, 9},
{ 6, 7, 9},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_40 [] = {
{ 0.50857f,-0.39522f}, { 0.59429f,-0.39447f}, { 0.44000f,-0.30784f}, { 0.51787f,-0.24857f}, { 0.32530f,-0.09429f},
{ 0.43748f,-0.05429f}, { 0.26899f, 0.06571f}, { 0.38134f, 0.20286f}, { 0.23580f, 0.27714f}, { 0.37605f, 0.38000f},
{ 0.23848f, 0.41429f}, { 0.39320f, 0.53429f}, { 0.27177f, 0.59714f}, { 0.43748f, 0.71143f}, { 0.47216f, 0.80286f},
{ 0.36086f, 0.82000f}, { 0.45714f, 0.97936f}, { 0.59573f, 1.04286f}, { 0.50857f, 1.04395f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_40 [] = {
{ 2, 3, 4}, { 0, 3, 2}, { 3, 0, 1}, { 6, 4, 5}, { 3, 5, 4}, { 6, 7, 8}, { 7, 6, 5},
{ 9,10, 8}, { 9, 8, 7}, {10,11,12}, {10, 9,11}, {12,13,15}, {12,11,13}, {14,15,13},
{16,15,14}, {17,18,16}, {17,16,14},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_41 [] = {
{ 0.24000f,-0.39447f}, { 0.33143f,-0.39258f}, { 0.40616f,-0.28857f}, { 0.31641f,-0.24857f}, { 0.48784f,-0.14000f},
{ 0.39681f,-0.05429f}, { 0.55538f, 0.03143f}, { 0.45295f, 0.20286f}, { 0.59580f, 0.23714f}, { 0.59848f, 0.37429f},
{ 0.45823f, 0.38000f}, { 0.44723f, 0.49429f}, { 0.56252f, 0.59714f}, { 0.41714f, 0.64134f}, { 0.47343f, 0.82000f},
{ 0.34857f, 0.83301f}, { 0.37714f, 0.97936f}, { 0.23855f, 1.04286f}, { 0.32571f, 1.04395f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_41 [] = {
{ 0, 1, 3}, { 2, 3, 1}, { 3, 4, 5}, { 3, 2, 4}, { 5, 6, 7}, { 6, 5, 4}, { 7, 8,10},
{ 8, 9,10}, {11,10, 9}, { 8, 7, 6}, {11,12,13}, {13,14,15}, {12,11, 9}, {14,13,12},
{15,16,17}, {16,15,14}, {16,18,17},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_42 [] = {
{ 0.33143f, 0.58250f}, { 0.33714f, 0.58223f}, { 0.53714f, 0.58250f}, { 0.54286f, 0.58194f}, { 0.36213f, 0.61429f},
{ 0.25587f, 0.63714f}, { 0.25266f, 0.64286f}, { 0.62655f, 0.64286f}, { 0.25393f, 0.64857f}, { 0.43429f, 0.73293f},
{ 0.44000f, 0.73049f}, { 0.36715f, 0.78000f}, { 0.50714f, 0.78000f}, { 0.35429f, 0.78613f}, { 0.63429f, 0.80816f},
{ 0.19309f, 0.82571f}, { 0.68389f, 0.82571f}, { 0.19177f, 0.83143f}, { 0.68530f, 0.83143f}, { 0.38857f, 0.86213f},
{ 0.39523f, 0.86571f}, { 0.48000f, 0.86242f}, { 0.47660f, 0.86571f}, { 0.34657f, 0.88286f}, { 0.58857f, 0.90823f},
{ 0.22286f, 0.92522f}, { 0.22857f, 0.92848f}, { 0.64571f, 0.92816f}, { 0.65143f, 0.92675f}, { 0.49295f, 1.02000f},
{ 0.38134f, 1.03714f}, { 0.38550f, 1.04286f}, { 0.49143f, 1.04021f}, { 0.48571f, 1.04437f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_42 [] = {
{ 2,12,10}, { 8, 4,11}, { 8, 5, 4}, { 8, 6, 5}, { 4, 0, 1}, { 2, 3,12}, { 0, 4, 5},
{12, 9,10}, { 9,11, 4}, {19,11,21}, {14,24,12}, {26,25,17}, {16,18,14}, {13,23,15},
{19,21,20}, {11,19,13}, {33,31,30}, {24,21,12}, {12,21, 9}, {21,11, 9}, {26,17,23},
{12, 3, 7}, {27,24,18}, {13,19,23}, {23,17,15}, {20,21,22}, {18,24,14}, {28,27,18},
{33,30,20}, {29,20,22}, {29,33,20}, {32,33,29},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_43 [] = {
{ 0.52836f, 0.10571f}, { 0.64878f, 0.10571f}, { 0.52420f, 0.11143f}, { 0.65295f, 0.11143f}, { 0.52420f, 0.39714f},
{ 0.65295f, 0.39714f}, { 0.22857f, 0.40546f}, { 0.52000f, 0.40329f}, { 0.66286f, 0.40437f}, { 0.95168f, 0.40857f},
{ 0.22437f, 0.52286f}, { 0.95277f, 0.52286f}, { 0.22857f, 0.52900f}, { 0.52311f, 0.53429f}, { 0.65403f, 0.53429f},
{ 0.94857f, 0.52900f}, { 0.52528f, 0.82571f}, { 0.65186f, 0.82571f}, { 0.53143f, 0.82991f}, { 0.64571f, 0.82991f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_43 [] = {
{ 1, 2, 0}, { 1, 3, 2}, { 4, 2, 3}, { 5, 4, 3}, {12, 6, 7}, {14, 4, 8}, { 9,15, 8},
{ 8, 4, 5}, { 9,11,15}, {12, 7,13}, { 6,12,10}, { 7, 4,13}, {14, 8,15}, {17,19,18},
{14,13, 4}, {17,18,16}, {17,16,13}, {17,13,14},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_44 [] = {
{ 0.30286f,-0.28607f}, { 0.30857f,-0.28726f}, { 0.33714f,-0.27355f}, { 0.36571f,-0.25275f}, { 0.27329f,-0.23714f},
{ 0.38670f,-0.23143f}, { 0.30286f,-0.21582f}, { 0.39914f,-0.21429f}, { 0.32115f,-0.19714f}, { 0.41355f,-0.18571f},
{ 0.33800f,-0.16857f}, { 0.42327f,-0.15714f}, { 0.34605f,-0.14571f}, { 0.43277f,-0.10000f}, { 0.35580f,-0.08286f},
{ 0.35472f,-0.07714f}, { 0.28571f,-0.07295f}, { 0.34857f,-0.07295f}, { 0.28000f,-0.06878f}, { 0.27957f, 0.07714f},
{ 0.43168f, 0.07714f}, { 0.28571f, 0.08134f}, { 0.42857f, 0.08025f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_44 [] = {
{ 0, 6, 4}, { 0, 1, 2}, { 0, 2, 6}, { 3, 6, 2}, { 8, 5,10}, { 5, 7,10}, { 6, 5, 8},
{ 5, 6, 3}, {10, 7,12}, { 9,12, 7}, {12,13,14}, {11,12, 9}, {12,11,13}, {18,17,19},
{17,21,19}, {15,14,13}, {15,13,17}, {21,17,22}, {17,20,22}, {18,16,17}, {20,17,13},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_45 [] = {
{ 0.19118f, 0.26000f}, { 0.19429f, 0.25689f}, { 0.60000f, 0.25580f}, { 0.60615f, 0.26000f}, { 0.19118f, 0.38571f},
{ 0.60615f, 0.38571f}, { 0.19429f, 0.38882f}, { 0.60000f, 0.38991f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_45 [] = {
{ 6, 1, 2}, { 6, 0, 1}, { 6, 2, 7}, { 6, 4, 0}, { 7, 2, 3}, { 5, 7, 3},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_46 [] = {
{ 0.28571f,-0.07295f}, { 0.42286f,-0.07295f}, { 0.42857f,-0.07186f}, { 0.27848f,-0.06571f}, { 0.28000f,-0.06878f},
{ 0.43277f,-0.06571f}, { 0.27848f, 0.07143f}, { 0.43277f, 0.07143f}, { 0.27957f, 0.07714f}, { 0.43168f, 0.07714f},
{ 0.28571f, 0.08134f}, { 0.42286f, 0.08134f}, { 0.42857f, 0.08025f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_46 [] = {
{ 0, 3, 4}, { 3, 0, 1}, { 8, 6,10}, { 5, 1, 2}, { 3, 1, 5}, { 6, 3, 5}, { 6, 7,11},
{ 6, 5, 7}, {10, 6,11}, { 9,12,11}, { 9,11, 7},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_47 [] = {
{ 0.14389f,-0.08857f}, { 0.14857f,-0.09256f}, { 0.25004f,-0.08857f}, { 0.56235f, 1.04286f}, { 0.46286f, 1.04358f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_47 [] = {
{ 2, 0, 1}, { 4, 0, 2}, { 3, 4, 2},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_48 [] = {
{ 0.53714f,-0.09009f}, { 0.59429f,-0.09009f}, { 0.66857f,-0.07673f}, { 0.43429f,-0.06723f}, { 0.73143f,-0.05070f},
{ 0.34286f,-0.00972f}, { 0.80571f, 0.01025f}, { 0.54857f, 0.02152f}, { 0.61714f, 0.02891f}, { 0.30241f, 0.03714f},
{ 0.65714f, 0.04645f}, { 0.46857f, 0.05007f}, { 0.42473f, 0.08857f}, { 0.70286f, 0.08454f}, { 0.26645f, 0.10000f},
{ 0.86943f, 0.11143f}, { 0.39955f, 0.12286f}, { 0.73800f, 0.13429f}, { 0.23748f, 0.18000f}, { 0.37034f, 0.19714f},
{ 0.76252f, 0.20286f}, { 0.91236f, 0.26000f}, { 0.21866f, 0.26571f}, { 0.35621f, 0.26571f}, { 0.77823f, 0.28857f},
{ 0.34437f, 0.40286f}, { 0.92680f, 0.40286f}, { 0.20420f, 0.40857f}, { 0.78705f, 0.54000f}, { 0.20723f, 0.58000f},
{ 0.92420f, 0.58571f}, { 0.35277f, 0.64286f}, { 0.22177f, 0.69429f}, { 0.76571f, 0.72437f}, { 0.89966f, 0.74000f},
{ 0.37756f, 0.76286f}, { 0.74498f, 0.79143f}, { 0.26073f, 0.82571f}, { 0.85927f, 0.84857f}, { 0.42473f, 0.85429f},
{ 0.70439f, 0.85429f}, { 0.46286f, 0.88902f}, { 0.66286f, 0.89007f}, { 0.30241f, 0.90000f}, { 0.51009f, 0.91143f},
{ 0.58286f, 0.91823f}, { 0.80725f, 0.92857f}, { 0.77714f, 0.95829f}, { 0.38350f, 0.98000f}, { 0.71429f, 0.99927f},
{ 0.46286f, 1.01681f}, { 0.65714f, 1.01959f}, { 0.53714f, 1.02991f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_48 [] = {
{ 2, 8, 1}, { 0, 7, 3}, { 5,16, 9}, { 2,10, 8}, { 0, 1, 8}, { 7, 0, 8}, {12,16, 5},
{11, 3, 7}, { 3,12, 5}, {15,20,17}, {11,12, 3}, {13, 6,17}, { 6,13, 4}, { 9,16,14},
{10, 4,13}, {14,19,18}, { 4,10, 2}, {15,17, 6}, {19,14,16}, {21,24,20}, {23,18,19},
{22,25,27}, {24,26,28}, {23,22,18}, {21,20,15}, {26,24,21}, {22,23,25}, {29,27,25},
{29,31,32}, {28,30,33}, {31,29,25}, {30,28,26}, {32,35,37}, {46,40,36}, {30,34,33},
{32,31,35}, {43,39,48}, {43,37,35}, {38,36,33}, {38,33,34}, {42,40,49}, {48,41,50},
{39,43,35}, {47,40,46}, {46,36,38}, {41,44,50}, {45,52,44}, {42,51,45}, {41,48,39},
{49,40,47}, {50,44,52}, {52,45,51}, {42,49,51},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_49 [] = {
{ 0.58286f,-0.07186f}, { 0.70857f,-0.07186f}, { 0.30857f, 0.62908f}, { 0.31429f, 0.62657f}, { 0.38286f, 0.65641f},
{ 0.30785f, 0.75143f}, { 0.57714f, 0.77731f}, { 0.47429f, 0.85616f}, { 0.56384f, 0.94000f}, { 0.62857f, 1.02915f},
{ 0.70857f, 1.02882f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_49 [] = {
{ 6, 0, 1}, { 2, 4, 5}, { 7, 5, 4}, { 2, 3, 4}, { 6, 8, 7}, { 6, 7, 4}, {10, 8, 6},
{10, 6, 1}, {10, 9, 8},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_50 [] = {
{ 0.18857f,-0.06878f}, { 0.91429f,-0.06878f}, { 0.18748f,-0.04286f}, { 0.19849f, 0.00857f}, { 0.91429f, 0.05164f},
{ 0.38142f, 0.06000f}, { 0.22943f, 0.07714f}, { 0.46286f, 0.15868f}, { 0.30286f, 0.17832f}, { 0.38286f, 0.25813f},
{ 0.58413f, 0.43143f}, { 0.78286f, 0.44454f}, { 0.67543f, 0.52286f}, { 0.85355f, 0.53429f}, { 0.72045f, 0.58000f},
{ 0.89756f, 0.62571f}, { 0.75470f, 0.64286f}, { 0.35168f, 0.70000f}, { 0.91236f, 0.70000f}, { 0.77295f, 0.71143f},
{ 0.21403f, 0.71714f}, { 0.77295f, 0.74571f}, { 0.22605f, 0.79143f}, { 0.37143f, 0.79804f}, { 0.90244f, 0.80857f},
{ 0.75429f, 0.81228f}, { 0.38902f, 0.83143f}, { 0.24359f, 0.84286f}, { 0.73143f, 0.84689f}, { 0.42454f, 0.87143f},
{ 0.86607f, 0.88857f}, { 0.68000f, 0.89070f}, { 0.28000f, 0.90629f}, { 0.49143f, 0.90823f}, { 0.58857f, 0.91866f},
{ 0.82857f, 0.93555f}, { 0.31597f, 0.94571f}, { 0.37714f, 0.98784f}, { 0.76000f, 0.98657f}, { 0.44571f, 1.01470f},
{ 0.69143f, 1.01470f}, { 0.53714f, 1.02991f}, { 0.62857f, 1.02723f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_50 [] = {
{ 3, 2, 0}, { 3, 5, 6}, { 1, 5, 0}, { 5, 3, 0}, { 1, 4, 5}, { 6, 5, 8}, { 7, 8, 5},
{ 9, 8, 7}, { 9, 7,10}, {11,10, 7}, {10,11,12}, {12,11,14}, {16,15,18}, {16,18,19},
{13,14,11}, {14,13,16}, {21,24,25}, {15,16,13}, {21,19,18}, {23,27,22}, {17,23,22},
{24,21,18}, {27,23,32}, {17,22,20}, {31,42,34}, {30,28,25}, {26,32,23}, {40,31,38},
{35,28,30}, {36,32,26}, {29,36,26}, {34,41,33}, {33,37,29}, {36,29,37}, {33,39,37},
{30,25,24}, {28,38,31}, {38,28,35}, {39,33,41}, {31,40,42}, {41,34,42},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_51 [] = {
{ 0.52571f,-0.09009f}, { 0.63429f,-0.08395f}, { 0.45143f,-0.07756f}, { 0.37143f,-0.04498f}, { 0.74286f,-0.04771f},
{ 0.30857f, 0.00132f}, { 0.81714f, 0.00439f}, { 0.54286f, 0.02152f}, { 0.60000f, 0.02420f}, { 0.64661f, 0.03714f},
{ 0.27429f, 0.03952f}, { 0.46857f, 0.04073f}, { 0.42857f, 0.06759f}, { 0.70857f, 0.07561f}, { 0.88213f, 0.08286f},
{ 0.23429f, 0.10772f}, { 0.38812f, 0.11714f}, { 0.74535f, 0.11714f}, { 0.91109f, 0.14571f}, { 0.77823f, 0.19143f},
{ 0.20764f, 0.20857f}, { 0.92723f, 0.22571f}, { 0.34286f, 0.23215f}, { 0.78437f, 0.27143f}, { 0.92723f, 0.27714f},
{ 0.75429f, 0.36430f}, { 0.89927f, 0.38571f}, { 0.72571f, 0.40132f}, { 0.86857f, 0.43270f}, { 0.67429f, 0.43927f},
{ 0.48000f, 0.45284f}, { 0.48571f, 0.44966f}, { 0.54857f, 0.46152f}, { 0.60000f, 0.46109f}, { 0.83429f, 0.46686f},
{ 0.72693f, 0.52286f}, { 0.49034f, 0.55714f}, { 0.49714f, 0.56395f}, { 0.78857f, 0.56473f}, { 0.58286f, 0.57109f},
{ 0.82857f, 0.60921f}, { 0.67429f, 0.61616f}, { 0.70400f, 0.64857f}, { 0.85294f, 0.65429f}, { 0.72680f, 0.70571f},
{ 0.87009f, 0.72286f}, { 0.35429f, 0.72298f}, { 0.22175f, 0.74571f}, { 0.72991f, 0.76286f}, { 0.72151f, 0.80286f},
{ 0.86244f, 0.80857f}, { 0.38857f, 0.82064f}, { 0.69143f, 0.85832f}, { 0.84571f, 0.85587f}, { 0.26241f, 0.87143f},
{ 0.43429f, 0.87829f}, { 0.64571f, 0.89641f}, { 0.48571f, 0.90723f}, { 0.29330f, 0.91714f}, { 0.60571f, 0.91252f},
{ 0.53143f, 0.91823f}, { 0.80384f, 0.92286f}, { 0.36000f, 0.97750f}, { 0.73143f, 0.98213f}, { 0.44571f, 1.01681f},
{ 0.65714f, 1.01470f}, { 0.52000f, 1.02991f}, { 0.60000f, 1.02723f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_51 [] = {
{ 3,11, 5}, { 9, 8, 1}, { 1, 8, 0}, { 4, 9, 1}, { 9, 4,13}, { 7, 0, 8}, { 6,13, 4},
{17,13, 6}, { 2,11, 3}, { 2, 0, 7}, { 5,16,10}, {12, 5,11}, {10,16,15}, {11, 2, 7},
{16, 5,12}, {17,14,19}, {14,17, 6}, {20,15,22}, {19,18,23}, {22,15,16}, {14,18,19},
{21,23,18}, {23,26,25}, {23,21,24}, {26,28,25}, {30,32,36}, {25,34,27}, {35,32,33},
{35,29,27}, {25,28,34}, {29,35,33}, {26,23,24}, {37,36,32}, {39,32,35}, {35,27,34},
{37,32,39}, {30,31,32}, {39,35,41}, {38,41,35}, {38,42,41}, {40,42,38}, {42,40,44},
{40,43,44}, {44,43,48}, {45,48,43}, {47,46,54}, {49,48,50}, {50,48,45}, {49,53,52},
{63,52,61}, {53,49,50}, {46,51,54}, {58,54,51}, {58,55,62}, {62,55,64}, {66,57,60},
{61,52,53}, {55,58,51}, {59,67,60}, {52,63,56}, {56,65,59}, {55,57,64}, {64,57,66},
{65,56,63}, {67,66,60}, {67,59,65},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_52 [] = {
{ 0.64571f,-0.07295f}, { 0.64000f,-0.06878f}, { 0.77143f,-0.06878f}, { 0.77403f, 0.18571f}, { 0.16265f, 0.19143f},
{ 0.63429f, 0.18882f}, { 0.92000f, 0.19408f}, { 0.15891f, 0.31143f}, { 0.91735f, 0.31143f}, { 0.29653f, 0.31714f},
{ 0.63740f, 0.31714f}, { 0.77714f, 0.31403f}, { 0.16571f, 0.32228f}, { 0.16616f, 0.32286f}, { 0.63429f, 0.79380f},
{ 0.77186f, 1.02000f}, { 0.66857f, 1.02282f}, { 0.76571f, 1.02420f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_52 [] = {
{ 2, 1, 0}, { 1, 3, 5}, { 1, 2, 3}, { 3,10, 5}, { 9, 4, 5}, { 4, 9, 7}, { 6,11, 3},
{ 8,11, 6}, { 7, 9,13}, {15,16,14}, { 9, 5,10}, { 7,13,12}, {13,14,16}, {11,10, 3},
{14,13, 9}, {14,10,11}, {15,17,16}, {15,14,11},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_53 [] = {
{ 0.52571f,-0.09009f}, { 0.61714f,-0.08665f}, { 0.44571f,-0.07673f}, { 0.73143f,-0.05179f}, { 0.35429f,-0.03759f},
{ 0.78914f,-0.01429f}, { 0.30286f, 0.00241f}, { 0.53714f, 0.02152f}, { 0.62857f, 0.03184f}, { 0.84115f, 0.03714f},
{ 0.46857f, 0.03927f}, { 0.66286f, 0.04645f}, { 0.26286f, 0.04921f}, { 0.42286f, 0.06759f}, { 0.71429f, 0.08439f},
{ 0.88045f, 0.09429f}, { 0.23343f, 0.10000f}, { 0.38812f, 0.10571f}, { 0.74535f, 0.12286f}, { 0.35748f, 0.16857f},
{ 0.77294f, 0.18000f}, { 0.91681f, 0.18000f}, { 0.20420f, 0.20857f}, { 0.34286f, 0.22376f}, { 0.78705f, 0.23714f},
{ 0.93295f, 0.27143f}, { 0.79009f, 0.31714f}, { 0.93252f, 0.33429f}, { 0.77714f, 0.38420f}, { 0.91681f, 0.42000f},
{ 0.34857f, 0.43034f}, { 0.75641f, 0.43143f}, { 0.23088f, 0.44857f}, { 0.72000f, 0.47868f}, { 0.40000f, 0.48400f},
{ 0.68000f, 0.50784f}, { 0.86902f, 0.51714f}, { 0.46857f, 0.52437f}, { 0.53143f, 0.53848f}, { 0.57714f, 0.53848f},
{ 0.58857f, 0.53621f}, { 0.60000f, 0.53580f}, { 0.82286f, 0.56972f}, { 0.38494f, 0.59714f}, { 0.77714f, 0.60535f},
{ 0.48571f, 0.64244f}, { 0.69714f, 0.64327f}, { 0.56571f, 0.65848f}, { 0.61714f, 0.65848f}, { 0.43891f, 0.87714f},
{ 0.44571f, 0.88395f}, { 0.88043f, 0.88857f}, { 0.88043f, 1.00857f}, { 0.33714f, 1.01182f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_53 [] = {
{ 7, 1, 8}, { 7, 0, 1}, { 7, 2, 0}, { 2,10, 4}, { 6,13,12}, { 3, 8, 1}, { 3,11, 8},
{10, 2, 7}, { 4,13, 6}, {11, 3,14}, {19,16,12}, { 3, 5,14}, { 9,14, 5}, {10,13, 4},
{22,19,23}, {18,15,20}, {17,12,13}, {15,14, 9}, {14,15,18}, {19,12,17}, {25,26,24},
{20,21,24}, {21,20,15}, {22,16,19}, {25,24,21}, {26,25,27}, {29,28,26}, {29,26,27},
{43,37,45}, {36,31,29}, {34,32,30}, {31,36,33}, {31,28,29}, {32,34,43}, {48,47,41},
{45,38,47}, {42,33,36}, {41,39,40}, {38,39,47}, {37,38,45}, {47,39,41}, {44,33,42},
{43,34,37}, {46,33,44}, {35,46,41}, {33,46,35}, {46,48,41}, {32,43,53}, {43,49,53},
{49,50,53}, {53,50,52}, {50,51,52},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_54 [] = {
{ 0.55429f,-0.09009f}, { 0.66857f,-0.08034f}, { 0.43429f,-0.06213f}, { 0.75429f,-0.04607f}, { 0.34857f,-0.00972f},
{ 0.81143f,-0.00439f}, { 0.59429f, 0.02152f}, { 0.51339f, 0.03143f}, { 0.85188f, 0.04286f}, { 0.67429f, 0.04645f},
{ 0.46286f, 0.05579f}, { 0.27384f, 0.07714f}, { 0.41714f, 0.09597f}, { 0.73143f, 0.09597f}, { 0.89355f, 0.11714f},
{ 0.38771f, 0.14000f}, { 0.91177f, 0.16857f}, { 0.77294f, 0.17429f}, { 0.22816f, 0.18571f}, { 0.36530f, 0.19714f},
{ 0.78705f, 0.24857f}, { 0.92680f, 0.25429f}, { 0.35320f, 0.26000f}, { 0.78665f, 0.30571f}, { 0.20420f, 0.31143f},
{ 0.35320f, 0.31143f}, { 0.92723f, 0.31714f}, { 0.36657f, 0.37429f}, { 0.77395f, 0.37429f}, { 0.75429f, 0.41841f},
{ 0.39179f, 0.42571f}, { 0.89756f, 0.44286f}, { 0.72000f, 0.46418f}, { 0.43429f, 0.47258f}, { 0.19891f, 0.50571f},
{ 0.33714f, 0.50495f}, { 0.48000f, 0.50213f}, { 0.66857f, 0.50086f}, { 0.86241f, 0.50571f}, { 0.55429f, 0.52134f},
{ 0.61143f, 0.51866f}, { 0.80403f, 0.56857f}, { 0.42286f, 0.58821f}, { 0.74286f, 0.60943f}, { 0.34134f, 0.63143f},
{ 0.50857f, 0.62823f}, { 0.68000f, 0.63252f}, { 0.57714f, 0.64134f}, { 0.21563f, 0.66000f}, { 0.77714f, 0.74697f},
{ 0.37502f, 0.75714f}, { 0.90966f, 0.76286f}, { 0.25673f, 0.80286f}, { 0.41901f, 0.83143f}, { 0.73143f, 0.85191f},
{ 0.45143f, 0.86686f}, { 0.87343f, 0.87714f}, { 0.30036f, 0.88286f}, { 0.68000f, 0.89514f}, { 0.50286f, 0.90086f},
{ 0.51429f, 0.90530f}, { 0.52000f, 0.90784f}, { 0.60571f, 0.91866f}, { 0.83846f, 0.92857f}, { 0.35429f, 0.94384f},
{ 0.40571f, 0.98150f}, { 0.76000f, 0.99229f}, { 0.49143f, 1.01748f}, { 0.68571f, 1.02041f}, { 0.56571f, 1.02991f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_54 [] = {
{ 2,10, 4}, { 6, 1, 9}, { 3, 5,13}, { 0, 7, 2}, { 3, 9, 1}, { 1, 6, 0}, { 9, 3,13},
{ 7, 0, 6}, {10, 2, 7}, {20,26,23}, { 4,12,11}, {13, 8,17}, { 4,10,12}, {11,19,18},
{17,21,20}, {15,11,12}, {11,15,19}, {16,17,14}, {18,22,24}, { 8,14,17}, { 8,13, 5},
{24,35,34}, {22,18,19}, {20,21,26}, {28,23,26}, {21,17,16}, {24,27,35}, {24,22,25},
{28,31,29}, {31,28,26}, {24,25,27}, {32,41,37}, {30,35,27}, {34,44,48}, {35,33,42},
{43,37,41}, {46,39,40}, {32,29,38}, {38,29,31}, {33,35,30}, {33,36,42}, {42,36,45},
{45,39,47}, {36,39,45}, {37,46,40}, {41,32,38}, {46,37,43}, {47,39,46}, {44,34,35},
{48,50,52}, {48,44,50}, {49,56,54}, {57,53,64}, {57,52,50}, {54,66,58}, {51,56,49},
{62,69,61}, {53,57,50}, {61,59,60}, {59,65,55}, {65,64,55}, {58,68,62}, {55,64,53},
{66,54,63}, {63,54,56}, {65,59,67}, {69,62,68}, {67,59,61}, {69,67,61}, {68,58,66},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_55 [] = {
{ 0.37143f,-0.07186f}, { 0.50286f,-0.07186f}, { 0.36723f,-0.06571f}, { 0.37335f, 0.02000f}, { 0.52991f, 0.11143f},
{ 0.40379f, 0.18571f}, { 0.59787f, 0.35143f}, { 0.47387f, 0.41429f}, { 0.66857f, 0.51873f}, { 0.53355f, 0.55143f},
{ 0.63384f, 0.72857f}, { 0.80893f, 0.76286f}, { 0.74359f, 0.88286f}, { 0.21714f, 0.88546f}, { 0.92379f, 0.91143f},
{ 0.21403f, 1.00857f}, { 0.92311f, 1.00857f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_55 [] = {
{ 3, 0, 1}, { 2, 0, 3}, { 3, 4, 5}, { 4, 3, 1}, { 6, 7, 5}, { 6, 5, 4}, { 9, 7, 6},
{10, 9, 8}, { 8, 9, 6}, {10,11,12}, {11,10, 8}, {15,13,12}, {12,14,16}, {15,12,16},
{11,14,12},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_56 [] = {
{ 0.53143f,-0.08966f}, { 0.62857f,-0.08665f}, { 0.45143f,-0.07605f}, { 0.73714f,-0.05641f}, { 0.38857f,-0.05343f},
{ 0.34286f,-0.02616f}, { 0.79429f,-0.02250f}, { 0.28571f, 0.02445f}, { 0.58857f, 0.02152f}, { 0.50857f, 0.02823f},
{ 0.85258f, 0.03143f}, { 0.66937f, 0.04286f}, { 0.45143f, 0.05070f}, { 0.71429f, 0.07296f}, { 0.41143f, 0.07868f},
{ 0.24000f, 0.09016f}, { 0.89927f, 0.10571f}, { 0.37669f, 0.12286f}, { 0.76613f, 0.14000f}, { 0.21462f, 0.15714f},
{ 0.35849f, 0.16286f}, { 0.92109f, 0.17429f}, { 0.78705f, 0.22000f}, { 0.34437f, 0.22571f}, { 0.20420f, 0.27143f},
{ 0.92680f, 0.27143f}, { 0.78437f, 0.28286f}, { 0.34748f, 0.28857f}, { 0.77143f, 0.32947f}, { 0.91470f, 0.33429f},
{ 0.21714f, 0.34118f}, { 0.37502f, 0.36286f}, { 0.73296f, 0.39143f}, { 0.89057f, 0.39143f}, { 0.24359f, 0.40286f},
{ 0.41883f, 0.41429f}, { 0.69143f, 0.42722f}, { 0.27275f, 0.44286f}, { 0.85714f, 0.43841f}, { 0.46286f, 0.44371f},
{ 0.50286f, 0.45748f}, { 0.63429f, 0.45470f}, { 0.58286f, 0.46420f}, { 0.80507f, 0.48286f}, { 0.33143f, 0.49007f},
{ 0.40456f, 0.52286f}, { 0.72693f, 0.52286f}, { 0.32000f, 0.57616f}, { 0.54857f, 0.57580f}, { 0.62286f, 0.58319f},
{ 0.82082f, 0.58571f}, { 0.49714f, 0.58657f}, { 0.66286f, 0.60073f}, { 0.28527f, 0.61429f}, { 0.44571f, 0.61582f},
{ 0.70439f, 0.63714f}, { 0.85759f, 0.63714f}, { 0.25756f, 0.67143f}, { 0.72657f, 0.67143f}, { 0.39849f, 0.68286f},
{ 0.87470f, 0.68286f}, { 0.74134f, 0.72857f}, { 0.38705f, 0.73429f}, { 0.88109f, 0.76857f}, { 0.24764f, 0.77429f},
{ 0.73395f, 0.79714f}, { 0.39470f, 0.80286f}, { 0.87177f, 0.82000f}, { 0.71641f, 0.83714f}, { 0.27216f, 0.86571f},
{ 0.44000f, 0.87296f}, { 0.84486f, 0.88286f}, { 0.66286f, 0.89179f}, { 0.48000f, 0.90086f}, { 0.61714f, 0.91184f},
{ 0.54286f, 0.91823f}, { 0.31846f, 0.93429f}, { 0.80571f, 0.93555f}, { 0.38286f, 0.98616f}, { 0.72000f, 0.99800f},
{ 0.43429f, 1.01008f}, { 0.53143f, 1.02991f}, { 0.61714f, 1.02723f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_56 [] = {
{ 0, 9, 2}, {12, 4, 2}, { 1, 8, 0}, { 6,11, 3}, { 5,14, 7}, { 9, 0, 8}, { 8, 1,11},
{ 4,12, 5}, {13,11, 6}, { 1, 3,11}, {12, 2, 9}, { 5,12,14}, {13,10,18}, { 7,17,15},
{10,13, 6}, {15,20,19}, { 7,14,17}, {18,16,22}, {16,18,10}, {20,15,17}, {19,23,24},
{16,21,22}, {22,25,26}, {23,19,20}, {24,27,30}, {25,22,21}, {27,24,23}, {31,34,30},
{31,37,34}, {29,28,26}, {31,30,27}, {29,26,25}, {33,28,29}, {28,33,32}, {36,32,43},
{37,31,44}, {40,45,39}, {44,39,45}, {43,32,38}, {35,44,31}, {42,48,40}, {44,35,39},
{41,46,42}, {36,46,41}, {32,33,38}, {48,42,49}, {46,36,43}, {48,45,40}, {42,46,49},
{51,45,48}, {49,46,52}, {47,54,53}, {52,46,55}, {53,59,57}, {45,54,47}, {45,51,54},
{50,55,46}, {59,53,54}, {50,58,55}, {58,50,61}, {57,62,64}, {61,63,65}, {56,61,50},
{57,59,62}, {60,61,56}, {64,66,69}, {63,67,65}, {64,62,66}, {63,61,60}, {71,68,65},
{76,69,66}, {72,68,77}, {71,65,67}, {76,70,78}, {70,76,66}, {74,82,75}, {80,78,70},
{79,72,77}, {74,72,79}, {80,73,75}, {80,75,81}, {68,71,77}, {73,80,70}, {82,81,75},
{82,74,79},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_57 [] = {
{ 0.50286f,-0.09009f}, { 0.56000f,-0.09009f}, { 0.42857f,-0.07673f}, { 0.64571f,-0.07395f}, { 0.36000f,-0.04771f},
{ 0.74286f,-0.02616f}, { 0.28759f, 0.01429f}, { 0.51429f, 0.02152f}, { 0.57143f, 0.02420f}, { 0.80115f, 0.02571f},
{ 0.47429f, 0.02891f}, { 0.42857f, 0.05007f}, { 0.64000f, 0.04943f}, { 0.24930f, 0.07714f}, { 0.39314f, 0.08286f},
{ 0.85229f, 0.10000f}, { 0.70902f, 0.11143f}, { 0.37057f, 0.12286f}, { 0.22177f, 0.17429f}, { 0.34857f, 0.18947f},
{ 0.75109f, 0.19714f}, { 0.89395f, 0.20286f}, { 0.75429f, 0.20739f}, { 0.75681f, 0.21429f}, { 0.90966f, 0.27143f},
{ 0.50286f, 0.30152f}, { 0.42857f, 0.31605f}, { 0.61714f, 0.31462f}, { 0.37714f, 0.33787f}, { 0.70286f, 0.35759f},
{ 0.78705f, 0.37429f}, { 0.32000f, 0.37846f}, { 0.58286f, 0.42152f}, { 0.50286f, 0.42891f}, { 0.63429f, 0.43184f},
{ 0.78286f, 0.43630f}, { 0.92723f, 0.43714f}, { 0.26286f, 0.44350f}, { 0.45143f, 0.45107f}, { 0.68571f, 0.45750f},
{ 0.41587f, 0.47714f}, { 0.23787f, 0.48857f}, { 0.74498f, 0.52286f}, { 0.36359f, 0.55143f}, { 0.21522f, 0.55714f},
{ 0.92680f, 0.56286f}, { 0.76571f, 0.57009f}, { 0.34437f, 0.63143f}, { 0.77823f, 0.63714f}, { 0.20462f, 0.69429f},
{ 0.77866f, 0.69429f}, { 0.91236f, 0.70000f}, { 0.35429f, 0.74118f}, { 0.76571f, 0.76404f}, { 0.21756f, 0.77429f},
{ 0.38286f, 0.80921f}, { 0.87343f, 0.82571f}, { 0.40759f, 0.84286f}, { 0.72571f, 0.84118f}, { 0.24527f, 0.84857f},
{ 0.69143f, 0.87527f}, { 0.84000f, 0.88221f}, { 0.47429f, 0.89641f}, { 0.28571f, 0.90975f}, { 0.63429f, 0.90784f},
{ 0.54857f, 0.91866f}, { 0.33143f, 0.95527f}, { 0.76000f, 0.96331f}, { 0.39629f, 0.99714f}, { 0.68571f, 1.00437f},
{ 0.49714f, 1.02723f}, { 0.57714f, 1.02991f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_57 [] = {
{ 3, 8, 1}, { 2,11, 4}, { 0, 7, 2}, { 8, 3,12}, { 4,14, 6}, { 0, 1, 8}, { 6,17,13},
{10, 2, 7}, { 7, 0, 8}, { 5,12, 3}, {12, 5,16}, { 2,10,11}, { 4,11,14}, { 5, 9,16},
{18,13,19}, {16,15,20}, {15,23,20}, { 6,14,17}, {13,17,19}, {21,23,15}, {22,20,23},
{23,24,30}, {16, 9,15}, {23,21,24}, {25,32,26}, {27,32,25}, {38,28,26}, {43,41,37},
{34,29,39}, {33,26,32}, {29,34,27}, {30,36,35}, {34,32,27}, {36,30,24}, {28,38,31},
{31,38,37}, {35,39,29}, {38,26,33}, {39,35,42}, {42,35,36}, {40,37,38}, {44,41,43},
{42,36,46}, {44,47,49}, {43,37,40}, {48,46,45}, {36,45,46}, {51,50,48}, {52,54,49},
{47,44,43}, {50,51,53}, {51,48,45}, {59,54,52}, {59,55,63}, {52,49,47}, {53,61,58},
{56,53,51}, {55,59,52}, {53,56,61}, {66,63,57}, {55,57,63}, {62,68,57}, {58,67,60},
{67,58,61}, {68,66,57}, {60,69,64}, {68,62,70}, {60,67,69}, {64,71,65}, {65,70,62},
{70,65,71}, {64,69,71},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_58 [] = {
{ 0.28571f,-0.07295f}, { 0.42857f,-0.07186f}, { 0.28000f,-0.06878f}, { 0.43277f,-0.06571f}, { 0.27957f, 0.07714f},
{ 0.28571f, 0.08134f}, { 0.42857f, 0.08025f}, { 0.27957f, 0.57429f}, { 0.28571f, 0.57009f}, { 0.43168f, 0.57429f},
{ 0.27848f, 0.71714f}, { 0.43277f, 0.71714f}, { 0.28265f, 0.72286f}, { 0.42857f, 0.72329f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_58 [] = {
{ 2, 5, 4}, { 2, 0, 5}, { 0, 3, 5}, { 6, 5, 3}, { 0, 1, 3}, { 7, 8,10}, {10,11,13},
{ 9,10, 8}, {12,10,13}, {11,10, 9},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_59 [] = {
{ 0.30857f,-0.28726f}, { 0.36571f,-0.25275f}, { 0.27323f,-0.23714f}, { 0.39543f,-0.22000f}, { 0.32384f,-0.19143f},
{ 0.33756f,-0.16857f}, { 0.42327f,-0.15714f}, { 0.43277f,-0.10000f}, { 0.35472f,-0.07714f}, { 0.28571f,-0.07295f},
{ 0.34857f,-0.07295f}, { 0.28000f,-0.06878f}, { 0.27957f, 0.07714f}, { 0.43168f, 0.07714f}, { 0.27957f, 0.57429f},
{ 0.43168f, 0.57429f}, { 0.28265f, 0.72286f}, { 0.42857f, 0.72329f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_59 [] = {
{ 2, 1, 4}, { 5, 4, 3}, { 0, 1, 2}, { 5, 6, 8}, { 3, 4, 1}, { 6, 5, 3}, { 6, 7, 8},
{11,10,12}, {12,10,13}, { 8, 7,10}, {11, 9,10}, {13,10, 7}, {17,16,15}, {15,16,14},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_60 [] = {
{ 0.94857f, 0.09939f}, { 0.95269f, 0.10571f}, { 0.95236f, 0.22571f}, { 0.22894f, 0.40857f}, { 0.38919f, 0.46571f},
{ 0.38919f, 0.47143f}, { 0.22748f, 0.52857f}, { 0.23192f, 0.53429f}, { 0.95098f, 0.70571f}, { 0.95216f, 0.83143f},
{ 0.94857f, 0.83523f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_60 [] = {
{ 4, 0, 2}, { 5, 7, 6}, { 4, 3, 0}, { 0, 1, 2}, { 7, 8,10}, { 4, 5, 3}, { 5, 6, 3},
{ 8, 9,10}, { 7, 5, 8},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_61 [] = {
{ 0.22857f, 0.23975f}, { 0.94857f, 0.23975f}, { 0.22437f, 0.35714f}, { 0.95277f, 0.35714f}, { 0.22857f, 0.36329f},
{ 0.94857f, 0.36329f}, { 0.22857f, 0.57385f}, { 0.94857f, 0.57385f}, { 0.22437f, 0.58000f}, { 0.95277f, 0.58000f},
{ 0.22857f, 0.69740f}, { 0.94857f, 0.69740f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_61 [] = {
{ 0, 4, 2}, { 0, 1, 5}, { 4, 0, 5}, { 3, 5, 1}, {11, 7, 9}, {10, 6, 7}, {10, 7,11},
{ 8, 6,10},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_62 [] = {
{ 0.23429f, 0.09914f}, { 0.22857f, 0.10169f}, { 0.22748f, 0.22571f}, { 0.23192f, 0.23143f}, { 0.95116f, 0.40857f},
{ 0.79073f, 0.46571f}, { 0.79073f, 0.47143f}, { 0.95236f, 0.52857f}, { 0.22897f, 0.70571f}, { 0.22857f, 0.83287f},
{ 0.23429f, 0.83563f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_62 [] = {
{ 1, 0, 2}, { 3, 2, 0}, { 3, 0, 5}, { 4, 7, 5}, { 4, 5, 0}, { 6, 5, 7}, { 6,10, 8},
{ 8,10, 9}, {10, 6, 7},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_63 [] = {
{ 0.47429f,-0.07186f}, { 0.62021f,-0.07143f}, { 0.47118f, 0.07714f}, { 0.62329f, 0.07714f}, { 0.49979f, 0.19714f},
{ 0.62021f, 0.19714f}, { 0.49563f, 0.20286f}, { 0.49563f, 0.27714f}, { 0.63681f, 0.31714f}, { 0.50816f, 0.34571f},
{ 0.65714f, 0.36350f}, { 0.53669f, 0.41429f}, { 0.70857f, 0.42384f}, { 0.57868f, 0.47143f}, { 0.82857f, 0.53597f},
{ 0.86902f, 0.58571f}, { 0.73258f, 0.62000f}, { 0.90437f, 0.65429f}, { 0.76086f, 0.66000f}, { 0.77522f, 0.70000f},
{ 0.91580f, 0.70000f}, { 0.34857f, 0.71338f}, { 0.21034f, 0.73429f}, { 0.77866f, 0.75143f}, { 0.91807f, 0.76857f},
{ 0.22605f, 0.80857f}, { 0.76571f, 0.80375f}, { 0.38286f, 0.82144f}, { 0.73714f, 0.85191f}, { 0.25098f, 0.87143f},
{ 0.89143f, 0.86730f}, { 0.43597f, 0.88857f}, { 0.86812f, 0.90571f}, { 0.67429f, 0.90616f}, { 0.48571f, 0.91800f},
{ 0.62857f, 0.92538f}, { 0.29296f, 0.93429f}, { 0.54857f, 0.93277f}, { 0.81143f, 0.96670f}, { 0.35429f, 0.98821f},
{ 0.76571f, 0.99800f}, { 0.44571f, 1.02891f}, { 0.69714f, 1.02680f}, { 0.53143f, 1.04395f}, { 0.60000f, 1.04437f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_63 [] = {
{ 2, 1, 3}, { 2, 0, 1}, { 7, 6, 4}, { 7, 4, 5}, { 8, 9, 7}, {11,10,13}, { 8, 7, 5},
{ 8,10,11}, { 9, 8,11}, {13,12,16}, {12,13,10}, {14,16,12}, {14,15,16}, {16,15,18},
{17,18,15}, {17,23,19}, {17,19,18}, {20,23,17}, {29,27,36}, {26,32,28}, {21,25,22},
{26,23,24}, {27,29,25}, {24,23,20}, {36,31,39}, {28,40,33}, {30,26,24}, {35,44,37},
{31,36,27}, {27,25,21}, {31,34,41}, {42,33,40}, {28,38,40}, {39,31,41}, {38,28,32},
{26,30,32}, {42,35,33}, {41,34,43}, {43,37,44}, {34,37,43}, {44,35,42},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_64 [] = {
{ 0.92571f,-0.39563f}, { 1.16571f,-0.38109f}, { 0.74857f,-0.37236f}, { 0.65143f,-0.34613f}, { 1.33143f,-0.33070f},
{ 0.54286f,-0.29914f}, { 0.86286f,-0.27866f}, { 1.06286f,-0.28134f}, { 1.45650f,-0.26000f}, { 0.73714f,-0.25387f},
{ 1.21143f,-0.25387f}, { 0.43429f,-0.22384f}, { 0.62286f,-0.21216f}, { 1.32144f,-0.20857f}, { 1.55582f,-0.17429f},
{ 0.53714f,-0.16099f}, { 0.52571f,-0.15258f}, { 0.53143f,-0.15669f}, { 0.33714f,-0.11650f}, { 1.45143f,-0.11561f},
{ 0.46286f,-0.09260f}, { 0.80000f,-0.07295f}, { 1.20571f,-0.07252f}, { 1.09714f,-0.06891f}, { 0.71429f,-0.06252f},
{ 1.49714f,-0.06187f}, { 1.63260f,-0.06000f}, { 0.29629f,-0.04857f}, { 1.29714f,-0.04498f}, { 0.90857f,-0.03629f},
{ 1.03384f,-0.02571f}, { 0.62857f,-0.01582f}, { 0.40486f,-0.00857f}, { 0.59429f, 0.01873f}, { 1.41143f, 0.03296f},
{ 0.82857f, 0.03907f}, { 0.77714f, 0.04327f}, { 1.01143f, 0.04414f}, { 1.20000f, 0.05050f}, { 1.16989f, 0.06571f},
{ 1.25143f, 0.06086f}, { 0.90857f, 0.06821f}, { 0.72000f, 0.07561f}, { 0.54771f, 0.09429f}, { 1.15580f, 0.09429f},
{ 0.24420f, 0.10000f}, { 0.35748f, 0.11143f}, { 0.96000f, 0.10725f}, { 0.68527f, 0.11714f}, { 1.33841f, 0.11714f},
{ 1.51579f, 0.15714f}, { 0.66177f, 0.17429f}, { 1.41355f, 0.20286f}, { 1.03514f, 0.20857f}, { 0.65295f, 0.23143f},
{ 0.22437f, 0.23714f}, { 0.51277f, 0.23714f}, { 0.33563f, 0.24857f}, { 1.45355f, 0.27714f}, { 1.07177f, 0.31143f},
{ 1.58478f, 0.31143f}, { 0.65966f, 0.32857f}, { 1.48319f, 0.36857f}, { 0.53184f, 0.39714f}, { 0.23277f, 0.40286f},
{ 0.34478f, 0.40857f}, { 1.60420f, 0.42571f}, { 1.08420f, 0.44286f}, { 0.71514f, 0.48857f}, { 0.25184f, 0.49429f},
{ 1.49295f, 0.49429f}, { 0.57229f, 0.50000f}, { 1.60109f, 0.52857f}, { 1.05714f, 0.54144f}, { 0.75846f, 0.55143f},
{ 0.38645f, 0.55714f}, { 1.47681f, 0.58571f}, { 1.01143f, 0.59527f}, { 0.81714f, 0.60331f}, { 1.58605f, 0.60857f},
{ 1.12878f, 0.61429f}, { 0.65714f, 0.62418f}, { 0.86286f, 0.62319f}, { 0.96571f, 0.62151f}, { 0.92571f, 0.62991f},
{ 0.42857f, 0.64350f}, { 1.44571f, 0.66730f}, { 0.32359f, 0.67714f}, { 1.06048f, 0.68286f}, { 0.74857f, 0.69641f},
{ 1.15429f, 0.71588f}, { 1.28235f, 0.71714f}, { 1.00571f, 0.71800f}, { 0.82857f, 0.73109f}, { 0.92000f, 0.74152f},
{ 1.52657f, 0.75143f}, { 0.51275f, 0.75714f}, { 0.37669f, 0.76286f}, { 1.38286f, 0.76132f}, { 0.59493f, 0.82571f},
{ 1.30857f, 0.82821f}, { 1.45561f, 0.84857f}, { 0.47429f, 0.87296f}, { 0.73143f, 0.89681f}, { 1.18286f, 0.89580f},
{ 1.08571f, 0.92395f}, { 1.37143f, 0.92400f}, { 0.92000f, 0.93580f}, { 0.58286f, 0.95188f}, { 1.30857f, 0.96371f},
{ 0.71429f, 1.00899f}, { 1.18286f, 1.01470f}, { 0.92000f, 1.04437f}, { 1.01143f, 1.04395f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_64 [] = {
{ 0, 6, 2}, { 1, 7, 0}, { 6, 0, 7}, { 7, 1,10}, { 2, 9, 3}, { 3,12, 5}, { 9, 2, 6},
{10, 4,13}, { 4,10, 1}, {15, 5,12}, { 5,15,11}, {13, 8,19}, {12, 3, 9}, { 8,13, 4},
{11,20,18}, {11,15,16}, {17,16,15}, {14,19, 8}, {26,25,14}, {20,11,16}, {22,38,23},
{25,19,14}, {23,39,30}, {30,39,37}, {27,46,45}, {18,32,27}, {32,18,20}, {21,36,24},
{35,29,41}, {24,42,31}, {29,35,21}, {22,28,40}, {38,22,40}, {34,49,40}, {33,31,48},
{36,21,35}, {37,47,41}, {33,48,43}, {43,51,56}, {44,37,39}, {34,40,28}, {47,37,53},
{50,52,34}, {38,39,23}, {52,49,34}, {37,44,53}, {27,32,46}, {42,24,36}, {48,31,42},
{37,41,29}, {45,57,55}, {53,44,59}, {51,54,56}, {52,50,58}, {58,60,62}, {43,48,51},
{45,46,57}, {56,61,63}, {64,55,57}, {91,80,44}, {60,58,50}, {62,66,70}, {56,54,61},
{44,80,67}, {59,44,67}, {71,63,61}, {64,65,69}, {67,80,73}, {65,64,57}, {66,62,60},
{68,71,61}, {71,68,81}, {69,75,87}, {72,70,66}, {74,81,68}, {77,73,80}, {70,79,76},
{75,69,65}, {83,77,88}, {87,85,97}, {81,74,89}, {89,78,93}, {86,76,79}, {70,72,79},
{74,78,89}, {88,77,80}, {75,85,87}, {82,84,94}, {91,90,80}, {86,95,98}, {78,82,93},
{ 92, 83, 88}, { 93, 82, 94}, { 84, 83, 92}, { 94, 84, 92}, { 97, 96,102}, { 95, 86, 79},
{102, 99,108}, { 95,101, 98}, { 96, 97, 85}, { 96, 99,102}, { 98,101,100}, {103,108, 99},
{100,109,104}, {106,100,101}, {108,103,110}, {105,113,107}, {100,106,109}, {104,111,105},
{107,112,110}, {111,104,109}, {113,105,111}, {112,107,113}, {107,110,103},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_65 [] = {
{ 0.14455f,-0.07143f}, { 1.00000f,-0.07252f}, { 1.15573f,-0.07143f}, { 0.29143f,-0.07103f}, { 0.40981f, 0.25429f},
{ 0.86857f, 0.25754f}, { 0.45714f, 0.37713f}, { 0.82478f, 0.38000f}, { 0.45462f, 0.38571f}, { 0.58538f, 0.73429f},
{ 0.63429f, 0.90068f}, { 0.56000f, 1.02454f}, { 0.71429f, 1.02644f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_65 [] = {
{ 5, 1, 2}, { 0, 8,11}, { 6, 4, 5}, {12,10, 7}, { 0, 3, 4}, { 0, 4, 8}, { 6, 5, 7},
{ 6, 8, 4}, { 7, 5, 2}, { 8, 9,11}, { 9,10,11}, {12, 7, 2}, {11,10,12},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_66 [] = {
{ 0.25714f,-0.07186f}, { 0.78286f,-0.06723f}, { 0.86857f,-0.04899f}, { 0.93714f,-0.02045f}, { 1.00725f, 0.03714f},
{ 0.39957f, 0.06000f}, { 0.73143f, 0.05621f}, { 0.80571f, 0.06891f}, { 1.04213f, 0.08857f}, { 0.87555f, 0.10571f},
{ 1.06437f, 0.14000f}, { 0.91070f, 0.15143f}, { 1.08109f, 0.22000f}, { 0.93295f, 0.22571f}, { 0.93252f, 0.26571f},
{ 1.07177f, 0.32286f}, { 0.90857f, 0.34064f}, { 1.04616f, 0.38571f}, { 0.86857f, 0.38686f}, { 0.79429f, 0.42252f},
{ 0.39957f, 0.43143f}, { 1.01296f, 0.43143f}, { 0.69714f, 0.43563f}, { 0.97143f, 0.46686f}, { 0.88197f, 0.51143f},
{ 0.40571f, 0.56437f}, { 0.72000f, 0.56705f}, { 0.39848f, 0.57429f}, { 0.96956f, 0.58571f}, { 0.80571f, 0.58930f},
{ 0.84686f, 0.62000f}, { 0.99641f, 0.62571f}, { 0.86943f, 0.65429f}, { 1.02437f, 0.70571f}, { 0.88420f, 0.71143f},
{ 1.02665f, 0.76857f}, { 0.87429f, 0.79232f}, { 1.01673f, 0.82000f}, { 0.84000f, 0.84984f}, { 0.77714f, 0.88538f},
{ 0.98607f, 0.88857f}, { 0.39957f, 0.89429f}, { 0.71429f, 0.89580f}, { 0.93143f, 0.95296f}, { 0.85714f, 0.99756f},
{ 0.80000f, 1.01470f}, { 0.25714f, 1.02615f}, { 0.70857f, 1.02680f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_66 [] = {
{ 1, 6, 0}, { 2, 7, 1}, { 0,20,46}, { 7, 2, 9}, { 1, 7, 6}, {20,27,46}, { 9, 4,11},
{ 4, 9, 3}, { 2, 3, 9}, {11,10,13}, { 8,11, 4}, {10,11, 8}, {12,13,10}, {14,17,16},
{14,15,17}, {16,21,18}, {14,13,12}, {15,14,12}, {23,18,21}, { 5, 0, 6}, {19,26,22},
{18,24,19}, {16,17,21}, {24,18,23}, {26,19,29}, {19,24,29}, {25,22,26}, {22,25,20},
{30,29,24}, {32,28,31}, {28,32,30}, {32,31,34}, { 0, 5,20}, {34,35,36}, {33,34,31},
{28,30,24}, {36,40,38}, {38,44,39}, {35,37,36}, {34,33,35}, {25,27,20}, {27,41,46},
{40,36,37}, {43,38,40}, {39,45,42}, {42,47,41}, {38,43,44}, {45,39,44}, {47,46,41},
{47,42,45},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_67 [] = {
{ 0.69143f,-0.08966f}, { 0.80000f,-0.08705f}, { 0.60000f,-0.07823f}, { 0.50857f,-0.05070f}, { 0.93143f,-0.05216f},
{ 0.45714f,-0.02486f}, { 1.00000f,-0.01473f}, { 0.39597f, 0.02000f}, { 0.69714f, 0.03563f}, { 0.74857f, 0.03563f},
{ 0.62286f, 0.04899f}, { 0.82286f, 0.04899f}, { 1.08000f, 0.05597f}, { 0.57143f, 0.06784f}, { 0.88000f, 0.07229f},
{ 0.32571f, 0.10064f}, { 0.93143f, 0.10759f}, { 0.49143f, 0.11901f}, { 1.13800f, 0.14000f}, { 0.45600f, 0.15714f},
{ 0.28930f, 0.16286f}, { 0.99641f, 0.18571f}, { 0.41502f, 0.22571f}, { 1.18605f, 0.27714f}, { 0.24319f, 0.28857f},
{ 1.04571f, 0.31105f}, { 0.38244f, 0.32857f}, { 0.22748f, 0.36286f}, { 0.36723f, 0.44286f}, { 0.21866f, 0.52857f},
{ 0.36991f, 0.55714f}, { 0.22705f, 0.60857f}, { 1.02857f, 0.69469f}, { 0.40657f, 0.71143f}, { 1.16694f, 0.72857f},
{ 0.26286f, 0.74089f}, { 0.44187f, 0.78000f}, { 1.13927f, 0.80857f}, { 0.97143f, 0.80914f}, { 0.48000f, 0.82725f},
{ 0.31750f, 0.84286f}, { 0.93714f, 0.85011f}, { 0.53143f, 0.86784f}, { 0.89143f, 0.88331f}, { 1.07582f, 0.90571f},
{ 0.64000f, 0.91252f}, { 0.64571f, 0.91335f}, { 0.65714f, 0.91563f}, { 0.38286f, 0.91868f}, { 0.78857f, 0.91823f},
{ 1.00571f, 0.96902f}, { 0.50286f, 0.99756f}, { 0.93143f, 1.01070f}, { 0.58286f, 1.02680f}, { 0.70286f, 1.04705f},
{ 0.80000f, 1.04437f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_67 [] = {
{ 1, 9, 0}, { 0, 8, 2}, {14, 6,16}, { 4,14,11}, {24,20,22}, { 7,17,15}, { 2,10, 3},
{ 8,10, 2}, { 9, 1,11}, { 0, 9, 8}, { 4,11, 1}, { 3,13, 5}, {12,16, 6}, {10,13, 3},
{ 5,13, 7}, { 7,13,17}, {22,20,15}, {16,12,21}, {14, 4, 6}, {19,15,17}, {23,25,18},
{22,15,19}, {25,21,18}, {18,21,12}, {27,28,29}, {27,24,26}, {26,24,22}, {28,27,26},
{29,30,31}, {30,29,28}, {33,35,31}, {35,33,40}, {33,31,30}, {34,37,32}, {48,42,51},
{36,40,33}, {40,36,48}, {38,44,41}, {44,38,37}, {32,37,38}, {48,39,42}, {36,39,48},
{54,53,47}, {45,51,42}, {49,43,52}, {50,41,44}, {47,45,46}, {41,50,43}, {45,53,51},
{49,54,47}, {53,45,47}, {49,55,54}, {55,49,52}, {52,43,50},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_68 [] = {
{ 0.26286f,-0.07186f}, { 0.70286f,-0.07252f}, { 0.80000f,-0.06109f}, { 0.89714f,-0.03355f}, { 0.99555f, 0.02571f},
{ 0.40528f, 0.06000f}, { 0.72571f, 0.05891f}, { 1.03582f, 0.06571f}, { 0.79547f, 0.07143f}, { 0.88000f, 0.10893f},
{ 1.08150f, 0.12857f}, { 0.92115f, 0.14571f}, { 0.96657f, 0.21429f}, { 1.13966f, 0.26571f}, { 0.99470f, 0.28857f},
{ 1.16420f, 0.39714f}, { 1.01823f, 0.43714f}, { 1.16723f, 0.52857f}, { 1.01823f, 0.53429f}, { 1.15277f, 0.64286f},
{ 1.00000f, 0.65848f}, { 0.97714f, 0.72375f}, { 1.11216f, 0.77429f}, { 0.94286f, 0.78057f}, { 0.87429f, 0.84902f},
{ 1.06607f, 0.85429f}, { 0.81714f, 0.87865f}, { 0.40528f, 0.89429f}, { 0.69143f, 0.89807f}, { 0.97714f, 0.94616f},
{ 0.90857f, 0.98657f}, { 0.81143f, 1.01580f}, { 0.26286f, 1.02615f}, { 0.70286f, 1.02680f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_68 [] = {
{ 2, 6, 1}, { 5, 0, 1}, { 8, 3, 9}, { 3, 8, 2}, { 0,27,32}, { 6, 2, 8}, { 5, 1, 6},
{ 4, 7,11}, { 4, 9, 3}, { 9, 4,11}, {11,10,12}, {11, 7,10}, {13,14,12}, {14,15,16},
{13,12,10}, {16,17,18}, {14,13,15}, {18,19,20}, {17,16,15}, {18,17,19}, {22,21,20},
{21,22,23}, {29,24,23}, {22,20,19}, {26,24,30}, { 0, 5,27}, {25,23,22}, {29,23,25},
{30,24,29}, {26,31,28}, {31,26,30}, {33,32,27}, {28,33,27}, {33,28,31},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_69 [] = {
{ 0.26857f,-0.07186f}, { 1.08000f,-0.06878f}, { 1.08000f, 0.05164f}, { 0.41100f, 0.06000f}, { 0.41100f, 0.42571f},
{ 1.01143f, 0.43100f}, { 1.01563f, 0.55143f}, { 0.41714f, 0.55866f}, { 1.01143f, 0.55757f}, { 0.40991f, 0.56857f},
{ 0.41100f, 0.89429f}, { 1.05143f, 0.89957f}, { 1.05563f, 1.02000f}, { 0.26857f, 1.02615f}, { 1.05143f, 1.02615f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_69 [] = {
{ 0, 4,13}, { 1, 3, 0}, { 1, 2, 3}, { 0, 3, 4}, { 7, 5, 8}, { 5, 7, 4}, { 6, 8, 5},
{ 4, 9,13}, { 7, 9, 4}, { 9,10,13}, {11,14,10}, {14,13,10}, {12,14,11},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_70 [] = {
{ 0.26857f,-0.07186f}, { 0.40571f,-0.07186f}, { 0.40991f, 0.42000f}, { 0.41714f, 0.42723f}, { 0.92615f, 0.43143f},
{ 0.92615f, 0.55143f}, { 0.41714f, 0.55563f}, { 0.40991f, 0.56286f}, { 0.41100f, 0.89429f}, { 1.00571f, 0.90265f},
{ 1.00571f, 1.02307f}, { 0.26857f, 1.02615f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_70 [] = {
{ 0, 2,11}, { 2, 7,11}, { 2, 0, 1}, { 6, 4, 5}, { 4, 6, 3}, { 3, 6, 2}, { 7, 2, 6},
{ 7, 8,11}, {11, 8,10}, { 8, 9,10},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_71 [] = {
{ 0.82286f,-0.08966f}, { 0.65714f,-0.07866f}, { 0.93143f,-0.07335f}, { 0.56571f,-0.05387f}, { 1.05143f,-0.03355f},
{ 0.48000f,-0.01514f}, { 1.12000f, 0.00073f}, { 0.74286f, 0.03866f}, { 0.83429f, 0.04177f}, { 0.38857f, 0.05044f},
{ 0.65143f, 0.05470f}, { 0.92571f, 0.06319f}, { 1.23260f, 0.07714f}, { 0.34857f, 0.09302f}, { 0.54286f, 0.10150f},
{ 1.03429f, 0.11229f}, { 0.50286f, 0.13044f}, { 1.09252f, 0.15714f}, { 0.44421f, 0.19714f}, { 0.27429f, 0.21629f},
{ 0.24252f, 0.31143f}, { 0.39320f, 0.31143f}, { 0.77714f, 0.36243f}, { 1.09143f, 0.35773f}, { 0.22748f, 0.39714f},
{ 0.37605f, 0.40286f}, { 0.77295f, 0.48286f}, { 0.77714f, 0.48900f}, { 1.23429f, 0.48900f}, { 0.22437f, 0.51143f},
{ 0.37295f, 0.51714f}, { 0.23320f, 0.59143f}, { 0.39748f, 0.65429f}, { 1.09143f, 0.68617f}, { 1.08571f, 0.69099f},
{ 0.42073f, 0.71714f}, { 1.21977f, 0.72286f}, { 0.27387f, 0.73429f}, { 1.06286f, 0.75301f}, { 0.30645f, 0.80286f},
{ 0.47616f, 0.80286f}, { 1.02286f, 0.82127f}, { 1.18498f, 0.82571f}, { 0.54286f, 0.86150f}, { 0.34857f, 0.86629f},
{ 0.94286f, 0.88371f}, { 1.14857f, 0.88793f}, { 0.61143f, 0.89580f}, { 0.86286f, 0.91184f}, { 0.40168f, 0.92286f},
{ 0.70857f, 0.91866f}, { 0.80000f, 0.92134f}, { 1.09714f, 0.94384f}, { 0.45714f, 0.96436f}, { 0.53714f, 1.00498f},
{ 1.00000f, 1.00371f}, { 0.93714f, 1.02613f}, { 0.62857f, 1.03252f}, { 0.73714f, 1.04705f}, { 0.84571f, 1.04395f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_71 [] = {
{ 0, 7, 1}, {14, 5, 3}, { 5,14, 9}, { 2, 8, 0}, { 1,10, 3}, { 0, 8, 7}, { 8, 2,11},
{18,13, 9}, {17, 6,12}, {10, 1, 7}, { 4,11, 2}, {13,18,19}, {23,17,12}, {15, 6,17},
{ 4, 6,15}, {16, 9,14}, {11, 4,15}, {14, 3,10}, {19,21,20}, {18, 9,16}, {30,31,29},
{23,27,22}, {25,24,20}, {22,27,26}, {21,19,18}, {25,20,21}, {23,28,27}, {28,23,12},
{29,24,25}, {30,29,25}, {31,32,37}, {38,33,36}, {37,32,39}, {32,31,30}, {35,39,32},
{34,33,38}, {39,40,44}, {38,46,41}, {38,42,46}, {40,39,35}, {44,40,49}, {53,43,54},
{43,49,40}, {42,38,36}, {43,47,54}, {52,41,46}, {41,52,45}, {43,53,49}, {54,47,57},
{50,57,47}, {45,56,48}, {55,45,52}, {48,59,51}, {57,50,58}, {50,51,58}, {56,45,55},
{58,51,59}, {59,48,56},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_72 [] = {
{ 0.26857f,-0.07186f}, { 0.40571f,-0.07186f}, { 0.98857f,-0.07295f}, { 0.98286f,-0.06878f}, { 1.12571f,-0.06878f},
{ 0.40991f, 0.43714f}, { 0.41714f, 0.44437f}, { 0.97714f, 0.44329f}, { 0.41714f, 0.57277f}, { 0.97714f, 0.57385f},
{ 0.40991f, 0.58000f}, { 0.98550f, 1.02571f}, { 1.12571f, 1.02307f}, { 0.26857f, 1.02615f}, { 0.40571f, 1.02615f},
{ 1.12000f, 1.02723f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_72 [] = {
{ 4, 9, 7}, { 0, 5,13}, { 5,10,13}, { 5, 0, 1}, { 8, 7, 9}, { 9, 4,11}, {10, 5, 8},
{ 6, 8, 5}, { 4, 3, 2}, { 7, 8, 6}, {14,13,10}, {12,15,11}, { 3, 4, 7}, { 4,12,11},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_73 [] = {
{ 0.42592f,-0.07143f}, { 0.28571f,-0.06878f}, { 0.28836f, 1.02571f}, { 0.42857f, 1.02307f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_73 [] = {
{ 1, 3, 2}, { 3, 1, 0},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_74 [] = {
{ 0.45143f,-0.09009f}, { 0.50857f,-0.09009f}, { 0.37714f,-0.07756f}, { 0.58404f,-0.07714f}, { 0.33143f,-0.06086f},
{ 0.64000f,-0.05641f}, { 0.26489f,-0.01429f}, { 0.71429f,-0.00117f}, { 0.46286f, 0.03866f}, { 0.53714f, 0.04706f},
{ 0.74902f, 0.04857f}, { 0.41714f, 0.04899f}, { 0.57772f, 0.06571f}, { 0.21143f, 0.06772f}, { 0.37016f, 0.07714f},
{ 0.34498f, 0.11143f}, { 0.77252f, 0.11143f}, { 0.62371f, 0.11714f}, { 0.18705f, 0.16286f}, { 0.32462f, 0.17429f},
{ 0.64420f, 0.22571f}, { 0.79009f, 0.23143f}, { 0.18546f, 0.23714f}, { 0.31472f, 0.25429f}, { 0.64836f, 1.02571f},
{ 0.78857f, 1.02307f}, { 0.78286f, 1.02723f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_74 [] = {
{10,12, 7}, { 4, 2,11}, { 0, 1, 8}, { 3, 8, 1}, {11, 2, 8}, { 0, 8, 2}, { 8, 3, 9},
{ 9, 3,12}, { 4,14, 6}, { 7,12, 5}, { 3, 5,12}, { 6,15,13}, {12,10,17}, {14, 4,11},
{13,19,18}, { 6,14,15}, {22,19,23}, {17,16,20}, {13,15,19}, {16,17,10}, {22,18,19},
{21,20,16}, {20,21,24}, {25,26,24}, {21,25,24},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_75 [] = {
{ 0.25714f,-0.07186f}, { 0.39429f,-0.07186f}, { 1.15502f,-0.07143f}, { 0.97143f,-0.07140f}, { 0.89527f, 0.28857f},
{ 0.89143f, 0.29371f}, { 0.89098f, 0.29429f}, { 0.39848f, 0.30000f}, { 0.57714f, 0.47913f}, { 0.40000f, 0.49126f},
{ 0.68956f, 0.56857f}, { 0.68571f, 0.57371f}, { 0.68527f, 0.57429f}, { 1.13216f, 1.02571f}, { 0.25714f, 1.02615f},
{ 0.39429f, 1.02615f}, { 0.94857f, 1.02680f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_75 [] = {
{ 0, 9,14}, { 0, 7, 9}, { 3,10, 8}, { 3, 6,10}, { 9, 8,16}, { 4, 5, 6}, { 7, 0, 1},
{ 3, 4, 6}, {16, 8,12}, {10,11,12}, { 4, 3, 2}, { 8,10,12}, { 9, 7, 8}, {13,16,12},
{15,14, 9},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_76 [] = {
{ 0.25714f,-0.07186f}, { 0.93714f,-0.07186f}, { 0.94134f, 0.04857f}, { 0.39957f, 0.06000f}, { 0.93714f, 0.05472f},
{ 0.25714f, 1.02615f}, { 0.39429f, 1.02615f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_76 [] = {
{ 3, 0, 1}, { 0, 3, 5}, { 2, 4, 1}, { 3, 1, 4}, { 6, 5, 3},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_77 [] = {
{ 0.39164f,-0.07143f}, { 0.71429f,-0.07186f}, { 1.17143f,-0.07295f}, { 0.25714f,-0.06878f}, { 0.84000f,-0.06947f},
{ 1.16571f,-0.06878f}, { 1.30286f,-0.06878f}, { 0.78286f, 0.09751f}, { 0.78857f, 0.09751f}, { 1.16000f, 0.83018f},
{ 0.40000f, 0.84467f}, { 0.52151f, 0.88286f}, { 0.52000f, 0.88739f}, { 0.51748f, 0.89429f}, { 0.47580f, 1.02000f},
{ 0.25979f, 1.02571f}, { 1.11429f, 1.02285f}, { 1.30286f, 1.02307f}, { 0.46857f, 1.02680f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_77 [] = {
{ 3,10,15}, { 5, 6, 9}, { 6, 5, 2}, { 1,11,10}, { 4, 8, 1}, { 1, 7,11}, { 9,16, 8},
{ 1, 8, 7}, { 9, 8, 4}, {10,18,15}, {13,11,12}, {10, 3, 0}, {10,13,18}, {16, 9,17},
{10,11,13}, {13,14,18}, { 6,17, 9},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_78 [] = {
{ 0.26286f,-0.07186f}, { 0.39429f,-0.07186f}, { 0.98286f,-0.07295f}, { 1.12571f,-0.06878f}, { 0.98286f, 0.17231f},
{ 0.72045f, 0.31143f}, { 0.71678f, 0.31714f}, { 0.72000f, 0.31207f}, { 0.40000f, 0.78092f}, { 0.99122f, 1.02571f},
{ 1.12571f, 1.02307f}, { 0.26286f, 1.02615f}, { 0.40571f, 1.02644f}, { 1.12000f, 1.02723f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_78 [] = {
{ 0, 8,11}, { 8, 0, 1}, { 4, 3, 9}, { 3, 4, 2}, { 4, 5, 2}, { 6, 7, 5}, {12, 6, 4},
{ 4, 6, 5}, { 6,12, 8}, {10,13, 9}, { 8,12,11}, { 3,10, 9},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_79 [] = {
{ 0.70286f,-0.08966f}, { 0.77714f,-0.08966f}, { 0.61143f,-0.07605f}, { 0.89714f,-0.06823f}, { 0.97143f,-0.04073f},
{ 0.49143f,-0.03229f}, { 1.05650f, 0.00857f}, { 0.42286f, 0.01107f}, { 0.70857f, 0.03605f}, { 0.77143f, 0.03605f},
{ 0.63429f, 0.04899f}, { 0.84571f, 0.04899f}, { 1.12725f, 0.07143f}, { 0.35044f, 0.07714f}, { 0.92716f, 0.08286f},
{ 0.54857f, 0.08535f}, { 0.49143f, 0.12704f}, { 1.17465f, 0.13429f}, { 1.01296f, 0.15143f}, { 0.28571f, 0.17016f},
{ 0.43955f, 0.18571f}, { 1.21184f, 0.20286f}, { 0.40784f, 0.23714f}, { 1.08086f, 0.26000f}, { 1.24613f, 0.30000f},
{ 0.23109f, 0.31143f}, { 1.10665f, 0.34571f}, { 0.36764f, 0.36857f}, { 0.21295f, 0.43143f}, { 1.11848f, 0.43714f},
{ 1.26705f, 0.43714f}, { 0.36193f, 0.51143f}, { 1.11848f, 0.51714f}, { 0.21563f, 0.54571f}, { 0.36991f, 0.59143f},
{ 1.25522f, 0.61429f}, { 1.09966f, 0.63714f}, { 0.23236f, 0.64857f}, { 1.23681f, 0.68857f}, { 1.07070f, 0.71714f},
{ 0.41143f, 0.73016f}, { 0.26645f, 0.75143f}, { 1.20486f, 0.76857f}, { 0.45561f, 0.79714f}, { 1.02286f, 0.79270f},
{ 0.98857f, 0.82956f}, { 0.31429f, 0.83650f}, { 1.16045f, 0.84286f}, { 0.53143f, 0.86150f}, { 0.92000f, 0.87800f},
{ 0.35582f, 0.88857f}, { 0.63429f, 0.90764f}, { 0.85143f, 0.90613f}, { 1.10286f, 0.90956f}, { 0.71429f, 0.92134f},
{ 0.79429f, 0.91866f}, { 0.43493f, 0.95714f}, { 1.04000f, 0.95964f}, { 0.52000f, 1.00498f}, { 0.96000f, 1.00327f},
{ 0.89714f, 1.02613f}, { 0.63429f, 1.03866f}, { 0.77714f, 1.04705f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_79 [] = {
{ 0, 8, 2}, { 1, 9, 0}, { 8,10, 2}, { 2,10, 5}, { 9, 1,11}, { 5,16, 7}, {11, 3,14},
{ 3,11, 1}, { 3, 4,14}, { 6,14, 4}, { 7,16,13}, {10,15, 5}, { 0, 9, 8}, {16, 5,15},
{14, 6,18}, {13,20,19}, {12,18, 6}, {18,17,23}, {17,21,23}, {20,22,19}, {18,12,17},
{23,21,26}, {25,19,22}, {13,16,20}, {25,27,28}, {27,25,22}, {21,24,26}, {30,29,26},
{32,35,36}, {30,26,24}, {33,34,37}, {32,29,30}, {28,31,33}, {31,28,27}, {34,33,31},
{36,38,39}, {35,32,30}, {41,37,34}, {38,42,39}, {41,40,46}, {35,38,36}, {39,47,44},
{40,43,46}, {53,45,44}, {46,43,50}, {45,57,49}, {40,41,34}, {56,50,43}, {49,59,52},
{48,56,43}, {57,45,53}, {53,44,47}, {56,48,58}, {39,42,47}, {58,51,61}, {59,49,57},
{51,58,48}, {55,52,60}, {62,54,55}, {59,60,52}, {61,54,62}, {54,61,51}, {62,55,60},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_80 [] = {
{ 0.26286f,-0.07186f}, { 0.40000f,-0.07186f}, { 0.40420f, 0.36857f}, { 0.41143f, 0.37580f}, { 0.73714f, 0.37621f},
{ 0.88571f, 0.40034f}, { 0.98343f, 0.44857f}, { 0.41143f, 0.50420f}, { 0.72571f, 0.50420f}, { 0.40420f, 0.51143f},
{ 1.04045f, 0.51143f}, { 0.82947f, 0.52286f}, { 0.88571f, 0.55296f}, { 0.91678f, 0.58571f}, { 1.08252f, 0.59714f},
{ 0.93966f, 0.63143f}, { 1.09866f, 0.68286f}, { 0.94966f, 0.72857f}, { 0.93355f, 0.79143f}, { 1.08530f, 0.80857f},
{ 0.90857f, 0.83270f}, { 0.86857f, 0.86893f}, { 1.05927f, 0.87143f}, { 0.40528f, 0.89429f}, { 0.82286f, 0.88899f},
{ 0.74857f, 0.89807f}, { 1.02439f, 0.92286f}, { 0.96000f, 0.97641f}, { 0.89143f, 1.00538f}, { 0.26286f, 1.02615f},
{ 0.74286f, 1.02680f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_80 [] = {
{ 0, 9,29}, { 0, 2, 9}, { 2, 7, 9}, { 7, 3, 8}, {12,11, 5}, { 5,11, 4}, { 4, 8, 3},
{ 3, 7, 2}, { 2, 0, 1}, {11, 8, 4}, {13,12, 6}, {10,13, 6}, { 6,12, 5}, {14,15,10},
{15,14,17}, {13,10,15}, {16,17,14}, {17,19,18}, {19,17,16}, {18,19,20}, {20,27,21},
{22,20,19}, { 9,23,29}, {30,25,24}, {25,30,23}, {27,20,26}, {20,22,26}, {28,24,21},
{28,21,27}, {30,29,23}, {30,24,28},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_81 [] = {
{ 1.23429f,-0.15444f}, { 1.13714f,-0.11188f}, { 0.76571f,-0.09009f}, { 0.64571f,-0.08437f}, { 0.84000f,-0.08034f},
{ 0.58286f,-0.07034f}, { 1.27640f,-0.06000f}, { 0.93143f,-0.05470f}, { 0.46857f,-0.02322f}, { 1.00000f,-0.02293f},
{ 0.38857f, 0.03330f}, { 0.76000f, 0.03563f}, { 0.68000f, 0.03866f}, { 0.83547f, 0.04857f}, { 1.09814f, 0.04857f},
{ 0.61714f, 0.05177f}, { 0.87591f, 0.06571f}, { 0.55429f, 0.07800f}, { 0.80000f, 0.10784f}, { 0.49143f, 0.12132f},
{ 0.30857f, 0.12350f}, { 0.74115f, 0.12857f}, { 0.98286f, 0.13189f}, { 1.17355f, 0.14571f}, { 0.42857f, 0.19207f},
{ 0.86857f, 0.19927f}, { 0.26286f, 0.20486f}, { 1.05355f, 0.22000f}, { 0.77714f, 0.23134f}, { 0.39277f, 0.26000f},
{ 1.23177f, 0.27714f}, { 0.23387f, 0.28286f}, { 1.08823f, 0.30571f}, { 0.36420f, 0.36286f}, { 0.20991f, 0.40286f},
{ 0.35580f, 0.43714f}, { 1.25866f, 0.43714f}, { 1.11009f, 0.44286f}, { 0.20723f, 0.51714f}, { 1.25252f, 0.58000f},
{ 0.36420f, 0.59714f}, { 1.09823f, 0.60857f}, { 0.23470f, 0.67714f}, { 0.38857f, 0.68947f}, { 1.21184f, 0.73429f},
{ 1.05143f, 0.73841f}, { 0.42902f, 0.76857f}, { 0.28821f, 0.80286f}, { 1.00571f, 0.80413f}, { 1.17188f, 0.81429f},
{ 0.96000f, 0.84670f}, { 0.51429f, 0.85473f}, { 0.34473f, 0.88286f}, { 1.12000f, 0.88413f}, { 0.57714f, 0.89070f},
{ 0.88571f, 0.89070f}, { 0.64571f, 0.91252f}, { 0.76571f, 0.92093f}, { 0.42857f, 0.95759f}, { 1.03429f, 0.95864f},
{ 0.50286f, 0.99927f}, { 0.96571f, 0.99800f}, { 0.60000f, 1.03252f}, { 0.86857f, 1.03184f}, { 0.69714f, 1.04705f},
{ 0.77143f, 1.04665f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_81 [] = {
{ 0, 6, 1}, {13, 7,16}, {14, 9, 1}, { 9,16, 7}, { 3,15, 5}, {16, 9,14}, {11, 4,13},
{11, 2, 4}, { 7,13, 4}, {12, 3,11}, { 2,11, 3}, {15, 3,12}, { 5,17, 8}, { 8,19,10},
{10,19,20}, {14, 1, 6}, { 5,15,17}, {20,29,26}, {19, 8,17}, {21,18,28}, {22,16,14},
{16,25,18}, {22,14,27}, {24,20,19}, {16,22,25}, {26,29,31}, {18,25,28}, {14,23,27},
{27,30,32}, {30,27,23}, {31,33,34}, {20,24,29}, {37,32,30}, {33,31,29}, {34,33,38},
{36,37,30}, {35,38,33}, {37,39,41}, {38,40,42}, {37,36,39}, {41,44,45}, {40,38,35},
{42,43,47}, {44,41,39}, {46,47,43}, {43,42,40}, {47,46,52}, {45,49,48}, {59,50,48},
{52,51,58}, {53,48,49}, {61,50,59}, {50,61,55}, {58,51,60}, {51,52,46}, {49,45,44},
{59,48,53}, {57,64,56}, {60,54,62}, {55,63,57}, {51,54,60}, {54,56,62}, {62,56,64},
{63,55,61}, {63,65,57}, {57,65,64},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_82 [] = {
{ 0.26857f,-0.07186f}, { 0.40571f,-0.07186f}, { 1.05143f,-0.07215f}, { 1.22359f,-0.07143f}, { 1.22535f,-0.06571f},
{ 1.17465f, 0.01429f}, { 1.17143f, 0.01936f}, { 1.17098f, 0.02000f}, { 0.84571f, 0.24343f}, { 1.00571f, 0.27650f},
{ 0.76571f, 0.34698f}, { 0.91832f, 0.37429f}, { 0.73143f, 0.37678f}, { 0.40991f, 0.40857f}, { 0.68000f, 0.40437f},
{ 0.41714f, 0.41580f}, { 0.62286f, 0.41538f}, { 0.84226f, 0.42571f}, { 0.92571f, 0.44706f}, { 0.99429f, 0.47502f},
{ 1.07582f, 0.54000f}, { 0.41714f, 0.54420f}, { 0.40991f, 0.55143f}, { 0.80000f, 0.54764f}, { 0.88000f, 0.56538f},
{ 1.11641f, 0.60286f}, { 0.94286f, 0.60439f}, { 0.96784f, 0.63714f}, { 1.13823f, 0.67714f}, { 0.98966f, 0.69429f},
{ 0.99277f, 0.74571f}, { 1.14134f, 0.75143f}, { 0.97143f, 0.81493f}, { 1.12823f, 0.82000f}, { 0.93143f, 0.86115f},
{ 1.10498f, 0.87714f}, { 0.89143f, 0.88498f}, { 0.40991f, 0.90000f}, { 0.41714f, 0.90723f}, { 0.78857f, 0.90723f},
{ 1.07011f, 0.92857f}, { 1.01714f, 0.97579f}, { 0.97143f, 0.99865f}, { 0.87429f, 1.02109f}, { 0.26857f, 1.02615f},
{ 0.80571f, 1.02723f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_82 [] = {
{ 2, 9, 8}, { 3, 5, 2}, { 0,37,44}, { 5, 7, 2}, { 5, 6, 7}, { 3, 4, 5}, { 2, 7, 9},
{18,23,17}, {11, 8, 9}, { 8,11,10}, { 0,22,37}, {11,17,10}, {21,16,23}, {21,15,16},
{23,10,17}, {19,24,18}, {23,18,24}, {23,12,10}, {15,21,13}, { 0,21,22}, {16,14,23},
{23,14,12}, {20,26,19}, {26,20,27}, {24,19,26}, {27,25,29}, {28,30,29}, {31,30,28},
{25,27,20}, {30,33,32}, {28,29,25}, {33,30,31}, {32,40,34}, {35,32,33}, { 0, 1,13},
{ 0,13,21}, {41,34,40}, {43,36,42}, {38,39,45}, {32,35,40}, {42,34,41}, {34,42,36},
{36,43,39}, {44,38,45}, {43,45,39}, {37,38,44},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_83 [] = {
{ 0.71429f,-0.08966f}, { 0.53714f,-0.07866f}, { 0.82286f,-0.07101f}, { 0.46286f,-0.05959f}, { 0.38857f,-0.02616f},
{ 0.94286f,-0.01678f}, { 0.33714f, 0.01044f}, { 0.64000f, 0.03866f}, { 0.73143f, 0.04177f}, { 1.00571f, 0.03883f},
{ 0.56000f, 0.05177f}, { 0.28527f, 0.06571f}, { 0.50857f, 0.06930f}, { 0.83587f, 0.07143f}, { 1.04086f, 0.08857f},
{ 0.88127f, 0.10000f}, { 0.43429f, 0.11330f}, { 0.24486f, 0.13429f}, { 0.92613f, 0.15714f}, { 1.07177f, 0.16286f},
{ 0.38771f, 0.16857f}, { 0.94134f, 0.21429f}, { 0.36319f, 0.22571f}, { 0.21563f, 0.23714f}, { 1.08109f, 0.26571f},
{ 0.21403f, 0.27714f}, { 0.93294f, 0.27714f}, { 0.34857f, 0.28916f}, { 0.91011f, 0.31714f}, { 1.06816f, 0.32857f},
{ 0.84000f, 0.36943f}, { 1.04486f, 0.38000f}, { 0.76571f, 0.39673f}, { 0.98286f, 0.45241f}, { 0.53143f, 0.45748f},
{ 0.42857f, 0.49343f}, { 0.92571f, 0.49070f}, { 0.37143f, 0.52535f}, { 0.82857f, 0.53109f}, { 0.31044f, 0.58000f},
{ 0.53143f, 0.60899f}, { 0.43429f, 0.65616f}, { 0.26244f, 0.67143f}, { 0.39891f, 0.71143f}, { 0.90857f, 0.71084f},
{ 0.25295f, 0.72286f}, { 1.04615f, 0.72286f}, { 0.39320f, 0.76857f}, { 0.40359f, 0.80857f}, { 1.03109f, 0.81429f},
{ 0.26327f, 0.82000f}, { 0.87429f, 0.81493f}, { 0.45143f, 0.86956f}, { 0.82286f, 0.87258f}, { 0.28930f, 0.88286f},
{ 0.98812f, 0.90000f}, { 0.50857f, 0.90041f}, { 0.76571f, 0.90151f}, { 0.57714f, 0.91563f}, { 0.67429f, 0.91866f},
{ 0.95443f, 0.94000f}, { 0.35429f, 0.96099f}, { 0.89143f, 0.98784f}, { 0.40000f, 0.99188f}, { 0.83429f, 1.01470f},
{ 0.50286f, 1.03184f}, { 0.74857f, 1.03823f}, { 0.57143f, 1.04437f}, { 0.67429f, 1.04705f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_83 [] = {
{ 2, 8, 0}, { 0, 7, 1}, { 6, 4,16}, { 6,16,11}, { 0, 8, 7}, { 7,10, 1}, { 8, 2,13},
{ 5,15,13}, { 1,10, 3}, {10,12, 3}, { 9,15, 5}, { 4, 3,12}, {15,14,18}, { 5,13, 2},
{14,15, 9}, {16, 4,12}, {21,24,26}, {18,19,21}, {11,20,17}, {20,11,16}, {17,22,23},
{19,18,14}, {22,17,20}, {25,23,27}, {23,22,27}, {24,21,19}, {26,31,28}, {28,33,30},
{24,29,26}, {30,38,32}, {26,29,31}, {34,32,38}, {33,28,31}, {34,40,35}, {33,36,30},
{39,43,42}, {38,30,36}, {41,37,35}, {40,34,38}, {37,41,39}, {41,35,40}, {50,48,54},
{39,41,43}, {44,46,49}, {45,42,43}, {45,47,50}, {48,50,47}, {60,51,55}, {47,45,43},
{51,60,53}, {54,48,61}, {44,49,51}, {55,51,49}, {48,52,61}, {56,63,52}, {57,66,59},
{61,52,63}, {63,56,65}, {62,53,60}, {53,64,57}, {53,62,64}, {59,66,58}, {65,58,67},
{58,65,56}, {66,57,64}, {67,58,68}, {68,58,66},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_84 [] = {
{ 0.54286f,-0.07186f}, { 0.68000f,-0.07186f}, { 0.53757f, 0.89429f}, { 0.68528f, 0.89429f}, { 0.17714f, 0.90265f},
{ 1.04571f, 0.90265f}, { 0.17979f, 1.02571f}, { 1.04571f, 1.02307f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_84 [] = {
{ 0, 3, 2}, { 3, 0, 1}, { 6, 4, 2}, { 6, 3, 7}, { 6, 2, 3}, { 3, 5, 7},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_85 [] = {
{ 0.65714f,-0.09009f}, { 0.77143f,-0.08705f}, { 0.53143f,-0.07034f}, { 0.85714f,-0.07101f}, { 0.47429f,-0.05070f},
{ 0.94286f,-0.03629f}, { 0.38286f, 0.00704f}, { 1.02286f, 0.02445f}, { 0.65714f, 0.04437f}, { 0.78857f, 0.05320f},
{ 0.33669f, 0.06000f}, { 0.58286f, 0.05748f}, { 0.84000f, 0.06823f}, { 0.52000f, 0.08535f}, { 1.07070f, 0.08857f},
{ 0.89714f, 0.10154f}, { 0.46857f, 0.13025f}, { 1.09966f, 0.15714f}, { 0.29143f, 0.15866f}, { 0.94899f, 0.17429f},
{ 0.43177f, 0.19714f}, { 0.27320f, 0.24286f}, { 0.97252f, 0.26000f}, { 1.12680f, 0.33429f}, { 0.26437f, 0.34000f},
{ 0.40991f, 0.34000f}, { 0.98134f, 0.34571f}, { 0.98550f, 1.02571f}, { 1.12571f, 1.02307f}, { 0.26857f, 1.02615f},
{ 0.40571f, 1.02615f}, { 1.12000f, 1.02723f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_85 [] = {
{ 3, 9, 1}, {10,20,18}, { 8, 0, 1}, { 0,11, 2}, { 7,15, 5}, { 0, 8,11}, { 8, 1, 9},
{ 9, 3,12}, {13, 4, 2}, { 5,12, 3}, {15, 7,19}, {16,10, 6}, {12, 5,15}, { 4,13, 6},
{13, 2,11}, {21,18,20}, {13,16, 6}, {19,17,22}, {17,19,14}, { 7,14,19}, {10,16,20},
{25,24,21}, {23,26,22}, {23,22,17}, {25,21,20}, {24,25,29}, {30,29,25}, {28,31,27},
{26,23,27}, {23,28,27},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_86 [] = {
{ 0.57714f,-0.07025f}, { 0.72571f,-0.06947f}, { 0.64571f, 0.06079f}, { 0.65143f, 0.06062f}, { 0.15429f, 1.02560f},
{ 0.30286f, 1.02531f}, { 1.00571f, 1.02531f}, { 1.14857f, 1.02560f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_86 [] = {
{ 0, 2, 4}, { 3, 2, 0}, { 3, 7, 6}, { 1, 3, 0}, { 3, 1, 7}, { 2, 5, 4},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_87 [] = {
{ 0.45143f,-0.07186f}, { 0.60000f,-0.07017f}, { 1.13143f,-0.06912f}, { 1.27429f,-0.06912f}, { 0.52571f, 0.09707f},
{ 1.20000f, 0.09787f}, { 1.13673f, 0.38000f}, { 0.86857f, 0.88103f}, { 0.16571f, 1.02562f}, { 0.78286f, 1.02446f},
{ 1.42857f, 1.02446f}, { 1.56806f, 1.02571f}, { 0.30857f, 1.02615f}, { 0.95429f, 1.02615f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_87 [] = {
{ 2, 6, 7}, { 6, 2, 5}, { 1, 4, 0}, { 7, 9, 4}, {11,10, 5}, { 3, 5, 2}, { 8, 0, 4},
{13, 7, 6}, { 9, 7,13}, { 7, 4, 1}, {11, 5, 3}, {12, 8, 4},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_88 [] = {
{ 0.15194f,-0.07143f}, { 1.14117f,-0.07143f}, { 0.32000f,-0.07106f}, { 0.97143f,-0.07140f}, { 0.65143f, 0.37795f},
{ 0.74607f, 0.49429f}, { 0.56517f, 0.50000f}, { 0.74286f, 0.49909f}, { 0.74219f, 0.50000f}, { 0.65714f, 0.61727f},
{ 0.20016f, 1.02571f}, { 0.96000f, 1.02568f}, { 1.11260f, 1.02571f}, { 0.36571f, 1.02644f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_88 [] = {
{ 0, 2, 6}, { 3, 5, 4}, { 5, 6, 4}, { 5, 8, 6}, { 5, 3, 1}, { 5, 7, 8}, { 4, 6, 2},
{ 9, 6, 8}, {12,11, 8}, { 6,13,10}, {13, 6, 9}, {11, 9, 8},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_89 [] = {
{ 0.71164f,-0.07143f}, { 0.57143f,-0.06878f}, { 0.56891f, 0.39143f}, { 0.71787f, 0.39714f}, { 0.65143f, 0.51441f},
{ 0.43179f, 0.85429f}, { 0.42857f, 0.85936f}, { 0.42812f, 0.86000f}, { 0.15284f, 1.02571f}, { 0.32000f, 1.02535f},
{ 0.98286f, 1.02464f}, { 1.14521f, 1.02571f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_89 [] = {
{ 3, 2, 1}, { 3, 1, 0}, { 4, 2, 3}, { 2, 9, 8}, {11,10, 4}, { 5, 2, 4}, { 5, 6, 7},
{ 2, 7, 9}, { 2, 5, 7}, {11, 4, 3},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_90 [] = {
{ 0.17714f,-0.07186f}, { 1.04000f,-0.06878f}, { 1.04000f, 0.05164f}, { 0.17395f, 0.06000f}, { 0.34602f, 0.06000f},
{ 0.84777f, 0.89429f}, { 0.24000f, 0.89957f}, { 1.02395f, 0.90000f}, { 0.23580f, 1.02000f}, { 1.02286f, 1.02307f},
{ 0.24000f, 1.02615f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_90 [] = {
{ 0, 4, 3}, { 1, 4, 0}, { 1, 2, 4}, { 3, 4, 5}, { 5, 7, 9}, { 4, 7, 5}, { 5,10, 6},
{10, 5, 9}, { 6,10, 8},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_91 [] = {
{ 0.24528f,-0.37429f}, { 0.54025f,-0.37429f}, { 0.54025f,-0.27143f}, { 0.38227f,-0.26571f}, { 0.38286f, 0.91454f},
{ 0.54134f, 0.92286f}, { 0.24836f, 1.02571f}, { 0.53714f, 1.02615f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_91 [] = {
{ 0, 4, 6}, { 3, 1, 2}, { 1, 3, 0}, { 0, 3, 4}, { 5, 7, 4}, { 6, 4, 7},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_92 [] = {
{ 0.46286f,-0.09182f}, { 0.56000f,-0.09256f}, { 0.56469f,-0.08857f}, { 0.14713f, 1.04286f}, { 0.24571f, 1.04358f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_92 [] = {
{ 0, 4, 3}, { 0, 2, 4}, { 0, 1, 2},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_93 [] = {
{ 0.17100f,-0.37429f}, { 0.46597f,-0.37429f}, { 0.17100f,-0.27143f}, { 0.32571f,-0.26723f}, { 0.33295f,-0.26000f},
{ 0.33143f, 0.91201f}, { 0.17143f, 0.91979f}, { 0.16991f, 1.02000f}, { 0.46286f, 1.02615f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_93 [] = {
{ 2, 0, 3}, { 1, 3, 0}, { 1, 4, 3}, { 5, 4, 1}, { 7, 6, 8}, { 5, 8, 6}, { 8, 5, 1},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_94 [] = {
{ 0.18389f, 0.44857f}, { 0.18857f, 0.44458f}, { 0.32000f, 0.44686f}, { 0.68571f, 0.44746f}, { 0.81143f, 0.44445f},
{ 0.81700f, 0.44857f}, { 0.49714f, 0.88224f}, { 0.50286f, 0.88224f}, { 0.44571f, 1.04090f}, { 0.55429f, 1.04168f},
{ 0.45143f, 1.04437f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_94 [] = {
{ 0, 2, 6}, { 0, 6, 8}, { 7, 3, 5}, { 4, 5, 3}, { 2, 0, 1}, {10, 7, 9}, {10, 8, 6},
{10, 6, 7}, { 9, 7, 5},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_95 [] = {
{ 0.11957f,-0.37429f}, { 1.01186f,-0.37429f}, { 0.11957f,-0.28857f}, { 1.01186f,-0.28857f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_95 [] = {
{ 2, 1, 3}, { 2, 0, 1},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_96 [] = {
{ 0.38857f, 0.82420f}, { 0.48000f, 0.82420f}, { 0.48403f, 0.82571f}, { 0.37714f, 0.82989f}, { 0.38286f, 0.82575f},
{ 0.48657f, 0.83143f}, { 0.21296f, 1.02571f}, { 0.38771f, 1.02571f}, { 0.21412f, 1.03143f}, { 0.38286f, 1.03106f},
{ 0.37714f, 1.03295f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_96 [] = {
{ 5, 1, 2}, { 0, 3, 4}, { 3,10, 6}, { 0, 1, 5}, { 7, 3, 0}, { 8, 6,10}, { 7, 0, 5},
{ 3, 7,10}, {10, 7, 9},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_97 [] = {
{ 0.44000f,-0.09009f}, { 0.50286f,-0.08966f}, { 0.36571f,-0.07756f}, { 0.57143f,-0.07907f}, { 0.92716f,-0.07143f},
{ 0.79429f,-0.07106f}, { 0.92930f,-0.06571f}, { 0.62857f,-0.06151f}, { 0.30857f,-0.05514f}, { 0.27429f,-0.03258f},
{ 0.68000f,-0.03629f}, { 0.90748f,-0.00857f}, { 0.48000f, 0.01580f}, { 0.53143f, 0.01621f}, { 0.42768f, 0.02571f},
{ 0.76571f, 0.02129f}, { 0.22073f, 0.03143f}, { 0.61804f, 0.03714f}, { 0.89866f, 0.03714f}, { 0.37130f, 0.06000f},
{ 0.20613f, 0.06571f}, { 0.68000f, 0.07330f}, { 0.34538f, 0.10000f}, { 0.71429f, 0.10809f}, { 0.19580f, 0.11714f},
{ 0.89295f, 0.13429f}, { 0.33907f, 0.15714f}, { 0.74538f, 0.16857f}, { 0.20319f, 0.19714f}, { 0.36000f, 0.20914f},
{ 0.75580f, 0.22000f}, { 0.40000f, 0.24371f}, { 0.22812f, 0.25429f}, { 0.44571f, 0.26041f}, { 0.66286f, 0.29891f},
{ 0.28000f, 0.31258f}, { 0.75848f, 0.31714f}, { 0.75429f, 0.32399f}, { 0.33714f, 0.34657f}, { 0.38857f, 0.36538f},
{ 0.68571f, 0.41320f}, { 0.75772f, 0.43714f}, { 0.35289f, 0.48286f}, { 0.22093f, 0.50000f}, { 0.22857f, 0.49470f},
{ 0.89252f, 0.50571f}, { 0.75580f, 0.51143f}, { 0.22857f, 0.53547f}, { 0.37800f, 0.54571f}, { 0.74286f, 0.55301f},
{ 0.88680f, 0.56286f}, { 0.71429f, 0.58893f}, { 0.41714f, 0.59330f}, { 0.42228f, 0.59714f}, { 0.25800f, 0.60286f},
{ 0.42286f, 0.59759f}, { 0.65143f, 0.61959f}, { 0.48000f, 0.62193f}, { 0.86498f, 0.62571f}, { 0.53143f, 0.62950f},
{ 0.59429f, 0.62950f}, { 0.28187f, 0.63714f}, { 0.84571f, 0.65486f}, { 0.33714f, 0.68436f}, { 0.80571f, 0.69007f},
{ 0.37915f, 0.70571f}, { 0.72571f, 0.72538f}, { 0.45714f, 0.72966f}, { 0.54286f, 0.74152f}, { 0.62286f, 0.74152f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_97 [] = {
{ 3,13, 1}, { 5, 4,15}, { 4,11,15}, {19, 8, 2}, {13, 3, 7}, {13, 0, 1}, {14, 0,12},
{20,22,24}, { 0,14, 2}, {12, 0,13}, {13, 7,17}, {11, 4, 6}, {19, 2,14}, {17,10,21},
{ 7,10,17}, {11,18,15}, {16,22,20}, { 8,19, 9}, {15,23,21}, {15,21,10}, {23,25,27},
{ 9,19,16}, {19,22,16}, {23,15,25}, {24,26,28}, {27,25,30}, {25,15,18}, {30,25,36},
{32,28,26}, {26,24,22}, {29,32,26}, {39,38,31}, {38,35,29}, {32,29,35}, {31,38,29},
{39,34,40}, {33,39,31}, {39,33,34}, {36,41,37}, {40,37,41}, {37,40,34}, {41,36,25},
{41,45,46}, {43,44,47}, {47,48,54}, {48,47,44}, {50,49,46}, {41,25,45}, {50,46,45},
{42,48,44}, {49,64,51}, {52,53,55}, {52,65,63}, {65,52,55}, {52,61,48}, {52,63,61},
{58,49,50}, {49,58,62}, {69,60,56}, {49,62,64}, {54,48,61}, {57,67,65}, {57,65,55},
{51,66,56}, {69,59,60}, {66,51,64}, {68,67,57}, {59,69,57}, {69,68,57}, {69,56,66},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_98 [] = {
{ 0.61143f,-0.09009f}, { 0.50286f,-0.07823f}, { 0.36000f,-0.07186f}, { 0.24000f,-0.06878f}, { 0.72000f,-0.06213f},
{ 0.45714f,-0.05914f}, { 0.77143f,-0.03188f}, { 0.36571f, 0.01806f}, { 0.59429f, 0.02193f}, { 0.83543f, 0.02571f},
{ 0.52000f, 0.02823f}, { 0.66857f, 0.04645f}, { 0.46857f, 0.05179f}, { 0.42704f, 0.08857f}, { 0.72956f, 0.10000f},
{ 0.88784f, 0.10571f}, { 0.39216f, 0.14000f}, { 0.75641f, 0.14000f}, { 0.91470f, 0.18000f}, { 0.37462f, 0.19143f},
{ 0.78665f, 0.23714f}, { 0.36152f, 0.28857f}, { 0.93252f, 0.29429f}, { 0.79236f, 0.36857f}, { 0.93252f, 0.37429f},
{ 0.36420f, 0.38000f}, { 0.77294f, 0.47714f}, { 0.39216f, 0.50000f}, { 0.90899f, 0.50000f}, { 0.42473f, 0.55143f},
{ 0.73143f, 0.55546f}, { 0.88657f, 0.55714f}, { 0.45883f, 0.58571f}, { 0.67429f, 0.60498f}, { 0.50857f, 0.61641f},
{ 0.63429f, 0.62252f}, { 0.56571f, 0.62991f}, { 0.37714f, 0.64118f}, { 0.83429f, 0.63841f}, { 0.37315f, 0.64857f},
{ 0.80571f, 0.66686f}, { 0.74286f, 0.70784f}, { 0.46857f, 0.71355f}, { 0.68571f, 0.72899f}, { 0.56571f, 0.74109f},
{ 0.61714f, 0.74152f}, { 0.24265f, 1.02571f}, { 0.37143f, 1.02307f}, { 0.36571f, 1.02723f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_98 [] = {
{ 3,25,46}, { 5, 1,10}, { 5,12, 7}, { 8, 0, 4}, {11, 6,14}, {11, 4, 6}, { 0, 8, 1},
{ 2, 7, 3}, { 8, 4,11}, {10, 1, 8}, {21, 3,19}, {12,13, 7}, {12, 5,10}, {14, 9,17},
{ 9,14, 6}, {17,15,20}, {16, 7,13}, {15,18,20}, {15,17, 9}, { 3, 7,19}, {22,20,18},
{20,22,23}, {28,26,23}, {22,24,23}, {25, 3,21}, {30,43,33}, {39,46,25}, {28,23,24},
{27,39,25}, {26,31,30}, { 7,16,19}, {31,26,28}, {37,32,42}, {39,27,37}, {40,30,38},
{29,37,27}, {38,30,31}, {35,33,43}, {32,34,42}, {35,45,36}, {37,29,32}, {42,34,36},
{45,35,43}, {43,30,41}, {41,30,40}, {36,45,44}, {42,36,44}, {47,48,46}, {39,47,46},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_99 [] = {
{ 0.53143f,-0.08966f}, { 0.59429f,-0.08966f}, { 0.45714f,-0.07673f}, { 0.68000f,-0.07294f}, { 0.72571f,-0.05343f},
{ 0.37714f,-0.04331f}, { 0.33714f,-0.01543f}, { 0.78857f,-0.01011f}, { 0.58286f, 0.02152f}, { 0.29143f, 0.03016f},
{ 0.49625f, 0.03143f}, { 0.62857f, 0.03034f}, { 0.83107f, 0.03714f}, { 0.45714f, 0.04943f}, { 0.69270f, 0.06571f},
{ 0.26241f, 0.07143f}, { 0.85714f, 0.07873f}, { 0.40457f, 0.09429f}, { 0.72722f, 0.10571f}, { 0.37629f, 0.14000f},
{ 0.74437f, 0.14000f}, { 0.22899f, 0.14571f}, { 0.37184f, 0.15143f}, { 0.36930f, 0.15714f}, { 0.88571f, 0.15295f},
{ 0.89406f, 0.19714f}, { 0.76571f, 0.21540f}, { 0.21034f, 0.22571f}, { 0.34705f, 0.25429f}, { 0.20420f, 0.36286f},
{ 0.34478f, 0.36857f}, { 0.21673f, 0.45429f}, { 0.36252f, 0.47143f}, { 0.75429f, 0.47269f}, { 0.88058f, 0.48857f},
{ 0.88319f, 0.49429f}, { 0.38371f, 0.52286f}, { 0.23849f, 0.52857f}, { 0.72000f, 0.55200f}, { 0.86437f, 0.55714f},
{ 0.43025f, 0.58000f}, { 0.69714f, 0.58127f}, { 0.28527f, 0.61429f}, { 0.47429f, 0.60943f}, { 0.48571f, 0.61387f},
{ 0.83473f, 0.61429f}, { 0.49143f, 0.61641f}, { 0.63429f, 0.62041f}, { 0.54857f, 0.62950f}, { 0.58857f, 0.62991f},
{ 0.81296f, 0.64286f}, { 0.32168f, 0.65429f}, { 0.35429f, 0.67964f}, { 0.76571f, 0.68535f}, { 0.44571f, 0.72327f},
{ 0.67429f, 0.72816f}, { 0.53714f, 0.74109f}, { 0.60000f, 0.74109f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_99 [] = {
{ 2,13, 5}, { 0, 8, 2}, {11, 4,14}, { 1, 8, 0}, { 3,11, 1}, {15,23,21}, { 2,10,13},
{11, 8, 1}, {11, 3, 4}, { 7,14, 4}, {10, 2, 8}, {14, 7,18}, {17, 6,13}, { 6, 5,13},
{17,15, 9}, {18,12,20}, { 7,12,18}, {17, 9, 6}, {16,20,12}, {24,20,16}, {19,15,17},
{15,19,23}, {23,19,22}, {27,28,29}, {26,20,24}, {26,24,25}, {21,28,27}, {28,21,23},
{29,30,31}, {28,30,29}, {31,32,37}, {39,38,33}, {34,39,33}, {32,31,30}, {37,32,36},
{55,49,47}, {37,36,42}, {51,42,36}, {34,35,39}, {45,41,38}, {52,40,43}, {46,43,44},
{50,41,45}, {56,49,57}, {40,51,36}, {51,40,52}, {45,38,39}, {52,43,54}, {47,41,53},
{54,46,48}, {56,48,49}, {53,41,50}, {54,48,56}, {54,43,46}, {57,49,55}, {55,47,53},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_100 [] = {
{ 0.51429f,-0.09009f}, { 0.56571f,-0.08966f}, { 0.62857f,-0.07673f}, { 0.76571f,-0.07186f}, { 0.88571f,-0.06878f},
{ 0.41143f,-0.06486f}, { 0.67429f,-0.05641f}, { 0.36000f,-0.03669f}, { 0.30286f, 0.01025f}, { 0.76000f, 0.01806f},
{ 0.53714f, 0.02152f}, { 0.49714f, 0.02891f}, { 0.60571f, 0.02891f}, { 0.68127f, 0.07143f}, { 0.41714f, 0.07561f},
{ 0.23787f, 0.10571f}, { 0.71579f, 0.11143f}, { 0.38241f, 0.11714f}, { 0.74135f, 0.16286f}, { 0.21395f, 0.16857f},
{ 0.74286f, 0.16739f}, { 0.74538f, 0.17429f}, { 0.34605f, 0.20286f}, { 0.76420f, 0.27714f}, { 0.19277f, 0.28857f},
{ 0.33295f, 0.28857f}, { 0.19277f, 0.36286f}, { 0.76152f, 0.38571f}, { 0.33563f, 0.39714f}, { 0.73355f, 0.50000f},
{ 0.22135f, 0.51143f}, { 0.36784f, 0.51714f}, { 0.69714f, 0.55841f}, { 0.42286f, 0.58686f}, { 0.26857f, 0.60793f},
{ 0.63429f, 0.60943f}, { 0.48571f, 0.62151f}, { 0.56571f, 0.62950f}, { 0.74857f, 0.64048f}, { 0.75269f, 0.64857f},
{ 0.30857f, 0.65582f}, { 0.65714f, 0.71355f}, { 0.40571f, 0.71756f}, { 0.50286f, 0.74109f}, { 0.55429f, 0.74152f},
{ 0.75693f, 1.02571f}, { 0.88571f, 1.02307f}, { 0.88000f, 1.02723f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_100 [] = {
{ 0,11, 5}, {12, 6,13}, { 1, 2,12}, { 7,14, 8}, {10, 0, 1}, {14, 7, 5}, {10, 1,12},
{ 6,12, 2}, { 0,10,11}, { 8,17,15}, { 9,16,13}, {14, 5,11}, { 4, 9, 3}, { 6, 9,13},
{ 9, 4,18}, {16, 9,18}, {15,22,19}, {17, 8,14}, {22,15,17}, {20,18,21}, {21,18, 4},
{19,25,24}, {21, 4,23}, {25,19,22}, {26,24,25}, {26,28,30}, {39,27, 4}, {26,25,28},
{39,38,29}, {29,38,32}, {27,39,29}, {30,31,34}, {32,38,35}, {31,30,28}, {40,34,31},
{36,42,33}, {23, 4,27}, {35,41,37}, {33,40,31}, {40,33,42}, {41,35,38}, {42,36,43},
{37,43,36}, {44,37,41}, {37,44,43}, {46,47,45}, {39, 4,45}, { 4,46,45},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_101 [] = {
{ 0.54857f,-0.09009f}, { 0.61143f,-0.09009f}, { 0.45714f,-0.07462f}, { 0.71429f,-0.07101f}, { 0.40571f,-0.05641f},
{ 0.77714f,-0.04331f}, { 0.33714f,-0.01543f}, { 0.82857f,-0.00670f}, { 0.29714f, 0.02154f}, { 0.56000f, 0.02152f},
{ 0.60571f, 0.02193f}, { 0.49714f, 0.03563f}, { 0.68159f, 0.04286f}, { 0.88150f, 0.05429f}, { 0.45714f, 0.05514f},
{ 0.26286f, 0.06636f}, { 0.72000f, 0.06759f}, { 0.40457f, 0.10000f}, { 0.91216f, 0.11143f}, { 0.77229f, 0.13429f},
{ 0.37057f, 0.15143f}, { 0.22034f, 0.15714f}, { 0.36613f, 0.16286f}, { 0.92834f, 0.16286f}, { 0.36359f, 0.16857f},
{ 0.91429f, 0.16966f}, { 0.79429f, 0.18111f}, { 0.35177f, 0.20286f}, { 0.20462f, 0.22571f}, { 0.33866f, 0.28286f},
{ 0.34286f, 0.28900f}, { 0.93454f, 0.29429f}, { 0.19848f, 0.35714f}, { 0.93295f, 0.39714f}, { 0.34857f, 0.40134f},
{ 0.78857f, 0.40134f}, { 0.34134f, 0.40857f}, { 0.79580f, 0.40857f}, { 0.20462f, 0.41429f}, { 0.35429f, 0.47261f},
{ 0.22327f, 0.49429f}, { 0.91429f, 0.48975f}, { 0.77143f, 0.50661f}, { 0.38857f, 0.54057f}, { 0.74857f, 0.54629f},
{ 0.40725f, 0.56286f}, { 0.25714f, 0.57001f}, { 0.71429f, 0.58154f}, { 0.87070f, 0.58571f}, { 0.45143f, 0.59759f},
{ 0.68000f, 0.60498f}, { 0.29296f, 0.62000f}, { 0.49143f, 0.61681f}, { 0.63429f, 0.62252f}, { 0.54857f, 0.62950f},
{ 0.59429f, 0.62991f}, { 0.33311f, 0.66000f}, { 0.81143f, 0.65543f}, { 0.77143f, 0.68607f}, { 0.41143f, 0.70930f},
{ 0.72000f, 0.71355f}, { 0.45714f, 0.72605f}, { 0.66857f, 0.73050f}, { 0.54286f, 0.74152f}, { 0.60000f, 0.74152f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_101 [] = {
{ 0, 9,11}, {10, 1, 3}, {10, 3,12}, { 5,12, 3}, {17, 8, 6}, {10, 0, 1}, { 0,11, 2},
{ 4,14, 6}, { 0,10, 9}, { 7,16, 5}, { 5,16,12}, {14, 2,11}, {16, 7,19}, {14, 4, 2},
{15, 8,17}, {26,18,25}, {17, 6,14}, {15,27,21}, { 7,13,19}, {23,25,18}, {20,15,17},
{26,19,18}, {18,19,13}, {24,20,22}, {15,20,24}, {15,24,27}, {21,27,28}, {28,29,32},
{33,37,35}, {29,28,27}, {32,29,38}, {35,34,30}, {40,39,46}, {33,35,30}, {31,33,30},
{36,38,29}, {36,29,34}, {37,41,42}, {40,38,36}, {30,34,29}, {39,40,36}, {41,37,33},
{46,43,51}, {51,49,56}, {42,48,44}, {48,42,41}, {44,48,47}, {49,51,45}, {43,46,39},
{56,49,59}, {50,62,53}, {57,47,48}, {64,55,53}, {45,51,43}, {55,63,54}, {58,47,57},
{62,50,60}, {59,52,61}, {59,49,52}, {47,60,50}, {61,54,63}, {60,47,58}, {61,52,54},
{64,53,62}, {55,64,63},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_102 [] = {
{ 0.28000f,-0.07186f}, { 0.40571f,-0.07186f}, { 0.27472f, 0.61429f}, { 0.41100f, 0.61429f}, { 0.16571f, 0.61957f},
{ 0.56000f, 0.61957f}, { 0.56420f, 0.71714f}, { 0.16571f, 0.72329f}, { 0.27472f, 0.72857f}, { 0.41100f, 0.72857f},
{ 0.56000f, 0.72329f}, { 0.41034f, 0.83143f}, { 0.27580f, 0.86000f}, { 0.43429f, 0.89555f}, { 0.28613f, 0.91714f},
{ 0.46286f, 0.91294f}, { 0.50286f, 0.92134f}, { 0.60000f, 0.91830f}, { 0.31107f, 0.96857f}, { 0.34286f, 1.00099f},
{ 0.38857f, 1.02784f}, { 0.61714f, 1.03086f}, { 0.46286f, 1.04395f}, { 0.52571f, 1.04437f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_102 [] = {
{ 0, 3, 2}, { 3, 0, 1}, { 4, 8, 7}, { 9, 3, 5}, { 2, 3, 8}, { 5, 6,10}, { 4, 2, 8},
{ 9, 8, 3}, { 8,11,12}, {11, 8, 9}, {12,11,14}, { 9, 5,10}, {13,19,18}, {13,18,14},
{13,14,11}, {23,15,16}, {15,23,22}, {21,23,17}, {15,20,13}, {19,13,20}, {20,15,22},
{23,16,17},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_103 [] = {
{ 0.46857f,-0.39295f}, { 0.56571f,-0.39563f}, { 0.66286f,-0.37959f}, { 0.35429f,-0.36200f}, { 0.74286f,-0.34616f},
{ 0.28571f,-0.31868f}, { 0.80368f,-0.30000f}, { 0.50857f,-0.28437f}, { 0.62286f,-0.27395f}, { 0.44571f,-0.27101f},
{ 0.23387f,-0.24286f}, { 0.84657f,-0.24286f}, { 0.69200f,-0.23714f}, { 0.38171f,-0.23143f}, { 0.72150f,-0.20286f},
{ 0.87177f,-0.18000f}, { 0.34916f,-0.15714f}, { 0.74899f,-0.14000f}, { 0.22286f,-0.13957f}, { 0.50857f,-0.07295f},
{ 0.56000f,-0.07295f}, { 0.43429f,-0.05959f}, { 0.65143f,-0.05070f}, { 0.37143f,-0.03355f}, { 0.69714f,-0.02527f},
{ 0.89252f,-0.00857f}, { 0.74857f, 0.01873f}, { 0.75042f, 0.02000f}, { 0.75756f, 0.02000f}, { 0.75429f, 0.02333f},
{ 0.29143f, 0.03381f}, { 0.53143f, 0.03866f}, { 0.57143f, 0.03907f}, { 0.47429f, 0.05216f}, { 0.64000f, 0.05787f},
{ 0.41714f, 0.08704f}, { 0.68000f, 0.08439f}, { 0.23216f, 0.12857f}, { 0.38036f, 0.12857f}, { 0.72784f, 0.14000f},
{ 0.35277f, 0.18571f}, { 0.20530f, 0.20857f}, { 0.75538f, 0.20857f}, { 0.19320f, 0.28286f}, { 0.33295f, 0.29429f},
{ 0.76991f, 0.35714f}, { 0.19277f, 0.37429f}, { 0.33563f, 0.40857f}, { 0.75109f, 0.47143f}, { 0.35109f, 0.47714f},
{ 0.21143f, 0.47832f}, { 0.72784f, 0.52286f}, { 0.23787f, 0.55143f}, { 0.39044f, 0.55143f}, { 0.69868f, 0.56286f},
{ 0.66286f, 0.59393f}, { 0.27107f, 0.60857f}, { 0.45143f, 0.60498f}, { 0.48571f, 0.62041f}, { 0.56571f, 0.62991f},
{ 0.57714f, 0.62764f}, { 0.58286f, 0.62723f}, { 0.76571f, 0.63477f}, { 0.32000f, 0.66384f}, { 0.68571f, 0.70213f},
{ 0.39429f, 0.71229f}, { 0.77408f, 0.72286f}, { 0.88878f, 0.72286f}, { 0.62857f, 0.72816f}, { 0.46857f, 0.73580f},
{ 0.56000f, 0.74152f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_103 [] = {
{ 1, 7, 0}, { 8, 4,12}, { 2, 8, 1}, { 0, 9, 3}, { 7, 1, 8}, { 5,13,10}, { 9, 0, 7},
{13, 5, 3}, { 8, 2, 4}, { 6,14,12}, { 6,12, 4}, {11,15,17}, {11,14, 6}, {13, 3, 9},
{14,11,17}, {10,16,18}, {16,10,13}, {17,25,28}, {23,21,33}, {22,32,20}, {32,19,20},
{35,23,33}, {19,31,21}, {23,35,30}, {31,19,32}, {32,22,34}, {26,29,36}, {17,15,25},
{33,21,31}, {26,36,24}, {24,34,22}, {26,27,29}, {36,34,24}, {36,29,39}, {30,38,37},
{39,28,25}, {39,29,28}, {37,40,41}, {38,40,37}, {30,35,38}, {39,25,42}, {44,46,43},
{44,43,41}, {44,41,40}, {42,25,45}, {67,51,48}, {46,47,50}, {67,48,45}, {47,46,44},
{50,49,52}, {49,50,47}, {67,62,51}, {62,54,51}, {56,52,49}, {54,62,55}, {55,64,61},
{60,61,59}, {53,56,49}, {56,53,63}, {63,57,65}, {65,58,69}, {65,57,58}, {70,59,61},
{59,69,58}, {64,55,62}, {67,45,25}, {67,66,62}, {63,53,57}, {68,70,61}, {59,70,69},
{64,68,61},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_104 [] = {
{ 0.24571f,-0.07186f}, { 0.37143f,-0.07186f}, { 0.76000f,-0.07186f}, { 0.88571f,-0.07186f}, { 0.37605f, 0.40286f},
{ 0.37756f, 0.40857f}, { 0.75538f, 0.46000f}, { 0.88950f, 0.47714f}, { 0.38899f, 0.48286f}, { 0.74538f, 0.51714f},
{ 0.88152f, 0.54571f}, { 0.42439f, 0.55143f}, { 0.72000f, 0.56914f}, { 0.47429f, 0.59355f}, { 0.68000f, 0.60331f},
{ 0.85996f, 0.61429f}, { 0.53143f, 0.61748f}, { 0.61143f, 0.62379f}, { 0.37714f, 0.63983f}, { 0.81714f, 0.67296f},
{ 0.45714f, 0.70045f}, { 0.77714f, 0.70213f}, { 0.50857f, 0.72437f}, { 0.68571f, 0.73538f}, { 0.58857f, 0.74152f},
{ 0.24571f, 1.02615f}, { 0.37143f, 1.02615f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_104 [] = {
{ 0, 4,25}, { 4,18,25}, { 6, 2, 3}, { 9, 6, 7}, { 7, 6, 3}, {18, 8,11}, {18,11,13},
{ 9,15,12}, {12,19,14}, {10, 9, 7}, {18,13,20}, { 8, 4, 5}, {15, 9,10}, { 4, 0, 1},
{18, 4, 8}, {17,24,16}, {19,21,14}, {14,23,17}, {20,16,22}, {16,20,13}, {19,12,15},
{17,23,24}, {23,14,21}, {24,22,16}, {18,26,25},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_105 [] = {
{ 0.25143f,-0.07186f}, { 0.37714f,-0.07186f}, { 0.25143f, 0.72329f}, { 0.37714f, 0.72329f}, { 0.25143f, 0.87403f},
{ 0.37714f, 0.87403f}, { 0.25143f, 1.02615f}, { 0.37714f, 1.02615f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_105 [] = {
{ 3, 2, 0}, { 3, 0, 1}, { 4, 5, 6}, { 7, 6, 5},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_106 [] = {
{ 0.14857f,-0.39563f}, { 0.22286f,-0.39252f}, { 0.07383f,-0.38000f}, { 0.26857f,-0.37914f}, { 0.31429f,-0.34989f},
{ 0.34036f,-0.31714f}, { 0.18857f,-0.27462f}, { 0.10286f,-0.26950f}, { 0.36109f,-0.26571f}, { 0.22331f,-0.24857f},
{ 0.37563f,-0.16857f}, { 0.24152f,-0.16286f}, { 0.24571f, 0.72329f}, { 0.37143f, 0.72329f}, { 0.24571f, 0.87403f},
{ 0.37143f, 0.87403f}, { 0.24571f, 1.02615f}, { 0.37143f, 1.02615f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_106 [] = {
{ 1, 6, 0}, { 3, 6, 1}, { 4, 6, 3}, { 9,10,11}, { 7, 0, 6}, { 7, 2, 0}, { 9, 5, 8},
{ 5, 9, 4}, { 6, 4, 9}, { 9, 8,10}, {11,10,12}, {13,12,10}, {14,15,16}, {17,16,15},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_107 [] = {
{ 0.37450f,-0.07143f}, { 0.89788f,-0.07143f}, { 0.24571f,-0.06878f}, { 0.73714f,-0.07035f}, { 0.38004f, 0.24286f},
{ 0.68421f, 0.25429f}, { 0.68045f, 0.26000f}, { 0.68000f, 0.26064f}, { 0.46857f, 0.32924f}, { 0.38286f, 0.40888f},
{ 0.57152f, 0.42571f}, { 0.69714f, 0.72283f}, { 0.86359f, 0.72286f}, { 0.24836f, 1.02571f}, { 0.37714f, 1.02307f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_107 [] = {
{ 2, 9,13}, { 4, 2, 0}, { 5, 8, 3}, { 5, 3, 1}, { 5, 6, 7}, { 9,14,13}, {11, 9,10},
{ 5, 7, 8}, { 7,10, 8}, { 8, 9, 4}, {12,11,10}, { 9, 8,10}, { 2, 4, 9},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_108 [] = {
{ 0.36878f,-0.07143f}, { 0.24000f,-0.06878f}, { 0.24265f, 1.02571f}, { 0.37143f, 1.02307f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_108 [] = {
{ 1, 3, 2}, { 3, 1, 0},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_109 [] = {
{ 0.24571f,-0.07186f}, { 0.37143f,-0.07186f}, { 0.72000f,-0.07295f}, { 1.18857f,-0.07186f}, { 1.31429f,-0.07186f},
{ 0.71429f,-0.06878f}, { 0.84571f,-0.06878f}, { 0.37866f, 0.37429f}, { 0.84723f, 0.40286f}, { 0.85335f, 0.46000f},
{ 0.39109f, 0.48286f}, { 0.71277f, 0.48286f}, { 1.18437f, 0.48286f}, { 1.31807f, 0.52286f}, { 0.87787f, 0.53429f},
{ 0.41143f, 0.53493f}, { 1.17395f, 0.54000f}, { 0.43582f, 0.56857f}, { 0.68784f, 0.56857f}, { 1.14857f, 0.58403f},
{ 0.93143f, 0.59188f}, { 0.66286f, 0.59829f}, { 0.82857f, 0.60801f}, { 0.51009f, 0.61429f}, { 0.36571f, 0.61924f},
{ 0.63429f, 0.61470f}, { 1.09714f, 0.61580f}, { 1.29355f, 0.62000f}, { 0.56000f, 0.62420f}, { 1.00571f, 0.62152f},
{ 1.06286f, 0.62379f}, { 0.41311f, 0.67143f}, { 0.78857f, 0.66975f}, { 1.25561f, 0.67714f}, { 0.90857f, 0.68902f},
{ 0.74286f, 0.70784f}, { 1.20571f, 0.71355f}, { 0.35735f, 0.72286f}, { 0.24571f, 0.72329f}, { 0.50286f, 0.72498f},
{ 0.99429f, 0.73109f}, { 1.16000f, 0.73109f}, { 0.67429f, 0.73470f}, { 0.57714f, 0.74109f}, { 1.05143f, 0.74152f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_109 [] = {
{ 6, 5, 2}, { 0, 7,38}, { 8,11, 5}, { 7, 0, 1}, { 8, 5, 6}, {12, 3, 4}, {12,13,16},
{ 9,11, 8}, {15,17,24}, {11,22,18}, {22,20,34}, {11, 9,22}, {14,22, 9}, {13,12, 4},
{24,17,31}, { 7,10,38}, {10,15,24}, {16,27,19}, {32,21,18}, {24,37,38}, {20,22,14},
{10,24,38}, {27,16,13}, {31,23,39}, {26,41,30}, {30,40,29}, {32,18,22}, {41,19,36},
{34,29,40}, {19,41,26}, {36,19,33}, {23,31,17}, {35,21,32}, {29,34,20}, {39,28,43},
{33,19,27}, {43,28,42}, {25,42,28}, {28,39,23}, {42,25,21}, {42,21,35}, {44,30,41},
{30,44,40},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_110 [] = {
{ 0.24571f,-0.07186f}, { 0.37143f,-0.07186f}, { 0.75429f,-0.07186f}, { 0.88571f,-0.07186f}, { 0.24152f,-0.06571f},
{ 0.37563f,-0.06571f}, { 0.75009f,-0.06571f}, { 0.88991f,-0.06571f}, { 0.37605f, 0.40286f}, { 0.37866f, 0.41429f},
{ 0.38134f, 0.44857f}, { 0.74665f, 0.48286f}, { 0.88950f, 0.48286f}, { 0.39849f, 0.51143f}, { 0.73229f, 0.54000f},
{ 0.88420f, 0.54000f}, { 0.43011f, 0.56286f}, { 0.46286f, 0.58893f}, { 0.69714f, 0.58725f}, { 0.87008f, 0.59143f},
{ 0.51580f, 0.61429f}, { 0.65143f, 0.61343f}, { 0.36571f, 0.62031f}, { 0.56571f, 0.62420f}, { 0.60571f, 0.62379f},
{ 0.61714f, 0.62152f}, { 0.62286f, 0.62109f}, { 0.83955f, 0.64857f}, { 0.40725f, 0.66571f}, { 0.79429f, 0.69179f},
{ 0.45714f, 0.70213f}, { 0.24152f, 0.71714f}, { 0.75429f, 0.71355f}, { 0.35735f, 0.72286f}, { 0.24571f, 0.72329f},
{ 0.52571f, 0.73050f}, { 0.68571f, 0.73538f}, { 0.58857f, 0.74152f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_110 [] = {
{ 1, 4, 0}, { 3, 6, 2}, { 1, 5, 4}, { 3, 7, 6}, { 6,12,11}, {11,15,14}, { 6, 7,12},
{22,16,28}, {10, 8, 9}, {13,22,10}, {10,22, 8}, { 8, 4, 5}, {15,11,12}, { 8,22, 4},
{14,15,19}, {14,19,18}, {25,26,24}, {16,22,13}, {16,17,28}, {30,28,17}, {27,18,19},
{32,23,24}, {29,18,27}, {30,20,35}, {18,32,21}, {31, 4,22}, {20,30,17}, {32,26,21},
{32,24,26}, {32,18,29}, {34,31,33}, {33,31,22}, {35,23,37}, {23,35,20}, {36,23,32},
{37,23,36},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_111 [] = {
{ 0.53143f,-0.08966f}, { 0.59429f,-0.09009f}, { 0.69143f,-0.07101f}, { 0.41143f,-0.06213f}, { 0.76571f,-0.03759f},
{ 0.34857f,-0.02821f}, { 0.81714f,-0.00099f}, { 0.29143f, 0.02154f}, { 0.54286f, 0.02193f}, { 0.60571f, 0.02420f},
{ 0.50857f, 0.02823f}, { 0.64571f, 0.03563f}, { 0.86331f, 0.04857f}, { 0.45143f, 0.05216f}, { 0.25714f, 0.06636f},
{ 0.70857f, 0.07330f}, { 0.89229f, 0.09429f}, { 0.40000f, 0.09597f}, { 0.22771f, 0.12286f}, { 0.38036f, 0.12286f},
{ 0.37714f, 0.12793f}, { 0.37669f, 0.12857f}, { 0.75473f, 0.12857f}, { 0.76657f, 0.15143f}, { 0.77101f, 0.16286f},
{ 0.77355f, 0.16857f}, { 0.92319f, 0.18000f}, { 0.20764f, 0.18571f}, { 0.34816f, 0.19714f}, { 0.78605f, 0.20857f},
{ 0.33563f, 0.26000f}, { 0.19320f, 0.28286f}, { 0.93823f, 0.28857f}, { 0.79848f, 0.29429f}, { 0.33295f, 0.36286f},
{ 0.93866f, 0.37429f}, { 0.19580f, 0.39714f}, { 0.79538f, 0.39714f}, { 0.35277f, 0.47143f}, { 0.92319f, 0.47143f},
{ 0.21184f, 0.48286f}, { 0.77143f, 0.48947f}, { 0.23216f, 0.54000f}, { 0.38742f, 0.54000f}, { 0.89927f, 0.54000f},
{ 0.74286f, 0.54057f}, { 0.71429f, 0.57275f}, { 0.42286f, 0.57813f}, { 0.87678f, 0.58000f}, { 0.27429f, 0.60984f},
{ 0.48571f, 0.61580f}, { 0.64571f, 0.61580f}, { 0.54286f, 0.62950f}, { 0.58857f, 0.62950f}, { 0.60000f, 0.62723f},
{ 0.60571f, 0.62680f}, { 0.83225f, 0.63714f}, { 0.31025f, 0.64857f}, { 0.34857f, 0.67864f}, { 0.75429f, 0.69641f},
{ 0.40000f, 0.70784f}, { 0.45143f, 0.72605f}, { 0.68571f, 0.72538f}, { 0.53714f, 0.74152f}, { 0.60000f, 0.74109f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_111 [] = {
{11, 4,15}, { 8, 0, 1}, {17, 7, 5}, {11, 2, 4}, { 2, 9, 1}, { 8, 1, 9}, { 0, 8,10},
{ 0,10, 3}, { 2,11, 9}, { 3,13, 5}, {10,13, 3}, { 6,12,22}, { 6,15, 4}, {15, 6,22},
{18,28,27}, {17, 5,13}, {14,19,18}, {16,23,22}, {19, 7,17}, { 7,19,14}, {18,19,21},
{24,23,25}, {25,23,16}, {19,20,21}, {16,22,12}, {26,29,25}, {27,30,31}, {26,25,16},
{28,18,21}, {29,26,33}, {30,27,28}, {31,34,36}, {33,32,35}, {26,32,33}, {34,31,30},
{33,35,37}, {40,36,34}, {37,39,41}, {40,38,42}, {39,37,35}, {47,57,43}, {38,40,34},
{43,49,42}, {46,45,56}, {39,44,41}, {41,48,45}, {43,57,49}, {41,44,48}, {43,42,38},
{57,47,58}, {54,55,53}, {56,45,48}, {50,60,47}, {64,63,53}, {64,55,62}, {53,63,52},
{59,62,51}, {61,60,50}, {64,53,55}, {51,62,55}, {52,61,50}, {59,46,56}, {61,52,63},
{46,59,51}, {58,47,60},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_112 [] = {
{ 0.24571f,-0.37740f}, { 0.37454f,-0.37429f}, { 0.56000f,-0.08966f}, { 0.66857f,-0.07966f}, { 0.47429f,-0.06657f},
{ 0.75429f,-0.04331f}, { 0.37584f,-0.00286f}, { 0.80571f,-0.00704f}, { 0.38286f, 0.00159f}, { 0.59429f, 0.02152f},
{ 0.52000f, 0.02891f}, { 0.63429f, 0.02992f}, { 0.85964f, 0.05429f}, { 0.45143f, 0.06725f}, { 0.70857f, 0.07330f},
{ 0.39787f, 0.13429f}, { 0.39514f, 0.14000f}, { 0.39216f, 0.14571f}, { 0.76213f, 0.14571f}, { 0.90538f, 0.14571f},
{ 0.37462f, 0.19714f}, { 0.78327f, 0.20857f}, { 0.92680f, 0.22571f}, { 0.36379f, 0.27143f}, { 0.36152f, 0.28286f},
{ 0.79580f, 0.29429f}, { 0.93563f, 0.30000f}, { 0.36379f, 0.36857f}, { 0.79580f, 0.36857f}, { 0.92680f, 0.43714f},
{ 0.78286f, 0.45547f}, { 0.38286f, 0.47232f}, { 0.75429f, 0.52921f}, { 0.41714f, 0.54057f}, { 0.88571f, 0.56444f},
{ 0.44571f, 0.57582f}, { 0.69143f, 0.59964f}, { 0.51429f, 0.62213f}, { 0.65143f, 0.62213f}, { 0.36571f, 0.63051f},
{ 0.56571f, 0.63563f}, { 0.82704f, 0.64857f}, { 0.45714f, 0.70784f}, { 0.74857f, 0.70657f}, { 0.24571f, 0.72329f},
{ 0.36000f, 0.72329f}, { 0.51429f, 0.73177f}, { 0.69143f, 0.72899f}, { 0.62286f, 0.74152f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_112 [] = {
{ 0, 1, 6}, { 0,24,44}, { 3, 9, 2}, { 2,10, 4}, { 3,11, 9}, { 4,13, 8}, {10, 2, 9},
{11, 5,14}, {11, 3, 5}, { 7,14, 5}, { 4,10,13}, {14,12,18}, {14, 7,12}, { 0,20,24},
{15, 8,13}, { 8,15, 6}, {19,18,12}, {18,19,21}, {21,22,25}, {24,27,44}, {17,15,16},
{22,21,19}, {28,25,26}, {22,26,25}, { 6,15,17}, {29,30,28}, {23,24,20}, {20, 6,17},
{29,28,26}, {30,34,32}, {27,31,44}, { 0, 6,20}, {31,39,44}, {32,41,36}, {41,32,34},
{31,33,39}, {42,37,46}, {39,35,42}, {34,30,29}, {39,33,35}, {38,47,40}, {35,37,42},
{47,38,43}, {40,46,37}, {43,36,41}, {39,45,44}, {46,40,48}, {48,40,47}, {38,36,43},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_113 [] = {
{ 0.76000f,-0.37740f}, { 0.88571f,-0.37740f}, { 0.56571f,-0.09009f}, { 0.45143f,-0.07673f}, { 0.65143f,-0.06784f},
{ 0.36000f,-0.03188f}, { 0.70857f,-0.03465f}, { 0.75580f,-0.00286f}, { 0.74857f, 0.00454f}, { 0.29714f, 0.02418f},
{ 0.54286f, 0.02152f}, { 0.57714f, 0.02193f}, { 0.58857f, 0.02420f}, { 0.59429f, 0.02462f}, { 0.47429f, 0.03927f},
{ 0.64571f, 0.04371f}, { 0.43302f, 0.06571f}, { 0.70670f, 0.09429f}, { 0.23914f, 0.11143f}, { 0.38607f, 0.11714f},
{ 0.38286f, 0.12221f}, { 0.38241f, 0.12286f}, { 0.75008f, 0.17429f}, { 0.21101f, 0.19143f}, { 0.34748f, 0.20857f},
{ 0.76723f, 0.25429f}, { 0.19848f, 0.26000f}, { 0.76723f, 0.27143f}, { 0.33605f, 0.28286f}, { 0.76991f, 0.28857f},
{ 0.19580f, 0.37429f}, { 0.33866f, 0.40286f}, { 0.75429f, 0.45277f}, { 0.21101f, 0.47143f}, { 0.35429f, 0.47832f},
{ 0.73143f, 0.51301f}, { 0.39846f, 0.56286f}, { 0.69296f, 0.56857f}, { 0.25669f, 0.58571f}, { 0.45143f, 0.60902f},
{ 0.61714f, 0.62213f}, { 0.49143f, 0.62723f}, { 0.76571f, 0.62602f}, { 0.29330f, 0.63714f}, { 0.56571f, 0.63522f},
{ 0.72403f, 0.67143f}, { 0.36571f, 0.69641f}, { 0.66286f, 0.71355f}, { 0.77408f, 0.72286f}, { 0.88571f, 0.72329f},
{ 0.44571f, 0.72966f}, { 0.56000f, 0.74152f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_113 [] = {
{29,27,25}, {49,42,32}, {22, 7,25}, { 3,13,11}, { 2,13, 3}, { 4,13, 2}, { 6,15, 4},
{11,13,12}, { 3,14, 5}, {13, 4,15}, {10, 3,11}, {15, 6, 8}, {14, 3,10}, {15, 8,17},
{24,23,18}, { 5,16, 9}, {17, 8,22}, {14,16, 5}, { 9,19,18}, {19,20,21}, {18,19,21},
{42,35,32}, { 7,22, 8}, {16,19, 9}, {49,48,42}, { 7, 0, 1}, {24,18,21}, {23,24,26},
{26,28,30}, {28,26,24}, {30,31,33}, {34,33,31}, {31,30,28}, {33,34,38}, {49,29,25},
{36,43,38}, {49,25, 7}, {35,42,37}, {37,45,40}, {45,37,42}, {29,49,32}, {45,47,40},
{39,43,36}, {46,39,50}, {40,47,44}, {43,39,46}, {36,38,34}, {41,44,51}, {41,50,39},
{49, 7, 1}, {50,41,51}, {51,44,47},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_114 [] = {
{ 0.24571f,-0.07186f}, { 0.37143f,-0.07186f}, { 0.24152f,-0.06571f}, { 0.37563f,-0.06571f}, { 0.37563f, 0.38000f},
{ 0.39748f, 0.50000f}, { 0.41964f, 0.54571f}, { 0.44740f, 0.57429f}, { 0.61714f, 0.57787f}, { 0.62286f, 0.57880f},
{ 0.48000f, 0.59294f}, { 0.57714f, 0.59395f}, { 0.51429f, 0.60134f}, { 0.36571f, 0.61385f}, { 0.41868f, 0.68857f},
{ 0.66769f, 0.69429f}, { 0.66542f, 0.70000f}, { 0.24152f, 0.71714f}, { 0.35735f, 0.72286f}, { 0.24571f, 0.72329f},
{ 0.46286f, 0.72436f}, { 0.60000f, 0.73109f}, { 0.51429f, 0.74109f}, { 0.55429f, 0.74109f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_114 [] = {
{ 1, 2, 0}, { 1, 3, 2}, { 4, 2, 3}, { 5, 6,13}, { 5,13,17}, {21,11,15}, { 2, 4,17},
{ 4, 5,17}, { 6, 7,13}, {18,17,13}, { 7,10,14}, {13, 7,14}, {14,12,20}, {11,21,12},
{ 9,15,11}, {12,14,10}, {19,17,18}, {20,12,22}, { 8, 9,11}, {21,15,16}, {22,12,23},
{23,12,21},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_115 [] = {
{ 0.56000f,-0.09009f}, { 0.46286f,-0.08705f}, { 0.65143f,-0.07395f}, { 0.37143f,-0.06723f}, { 0.70444f,-0.05429f},
{ 0.33143f,-0.04943f}, { 0.76057f,-0.02000f}, { 0.28571f,-0.01813f}, { 0.79582f, 0.01429f}, { 0.50286f, 0.02152f},
{ 0.55429f, 0.02152f}, { 0.56571f, 0.02379f}, { 0.57714f, 0.02420f}, { 0.24571f, 0.02636f}, { 0.64000f, 0.04200f},
{ 0.41714f, 0.04371f}, { 0.22200f, 0.06571f}, { 0.38286f, 0.06725f}, { 0.68384f, 0.07714f}, { 0.83580f, 0.08286f},
{ 0.69927f, 0.10000f}, { 0.34200f, 0.12286f}, { 0.84950f, 0.14000f}, { 0.71009f, 0.15714f}, { 0.19109f, 0.16286f},
{ 0.19370f, 0.16857f}, { 0.32000f, 0.18615f}, { 0.69864f, 0.19143f}, { 0.84723f, 0.20286f}, { 0.65714f, 0.22784f},
{ 0.83641f, 0.24286f}, { 0.80956f, 0.28857f}, { 0.34286f, 0.32371f}, { 0.75429f, 0.33641f}, { 0.30286f, 0.34421f},
{ 0.69143f, 0.36327f}, { 0.25714f, 0.38445f}, { 0.22645f, 0.43714f}, { 0.41143f, 0.44538f}, { 0.37587f, 0.46571f},
{ 0.35885f, 0.48286f}, { 0.21295f, 0.49429f}, { 0.69143f, 0.50460f}, { 0.34478f, 0.51714f}, { 0.81977f, 0.52286f},
{ 0.67514f, 0.55143f}, { 0.35216f, 0.56286f}, { 0.22034f, 0.56857f}, { 0.64000f, 0.59465f}, { 0.38286f, 0.59829f},
{ 0.79429f, 0.61016f}, { 0.24000f, 0.61573f}, { 0.42857f, 0.62041f}, { 0.58286f, 0.62252f}, { 0.48571f, 0.62991f},
{ 0.74689f, 0.67143f}, { 0.28571f, 0.67258f}, { 0.70286f, 0.70045f}, { 0.33714f, 0.70613f}, { 0.38857f, 0.72538f},
{ 0.61714f, 0.73050f}, { 0.47429f, 0.74109f}, { 0.54286f, 0.74109f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_115 [] = {
{ 2,12, 0}, {10, 1,12}, {12, 2,14}, {14, 4, 6}, { 7,17,13}, { 0,12, 1}, { 4,14, 2},
{11,10,12}, {15, 3, 1}, { 3,15, 5}, { 9, 1,10}, {14, 6,18}, {15, 1, 9}, {17, 5,15},
{ 6, 8,18}, { 5,17, 7}, {21,16,13}, {16,21,24}, {18, 8,20}, {23,28,27}, {21,13,17},
{19,22,23}, {26,25,21}, {21,25,24}, {20,19,23}, {19,20, 8}, {28,23,22}, {27,33,29},
{28,30,27}, {31,27,30}, {27,31,33}, {29,38,32}, {35,29,33}, {29,35,38}, {34,38,36},
{32,38,34}, {36,40,37}, {39,36,38}, {41,43,47}, {43,41,37}, {36,39,40}, {50,45,42},
{43,37,40}, {47,46,51}, {46,47,43}, {53,60,54}, {45,57,48}, {52,58,49}, {45,55,57},
{51,49,56}, {49,51,46}, {50,42,44}, {48,57,53}, {56,49,58}, {55,45,50}, {52,59,58},
{59,52,61}, {52,54,61}, {60,53,57}, {61,54,62}, {62,54,60},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_116 [] = {
{ 0.42286f,-0.08395f}, { 0.48000f,-0.08437f}, { 0.55197f,-0.07143f}, { 0.33714f,-0.05914f}, { 0.29901f,-0.02571f},
{ 0.28041f, 0.00857f}, { 0.44571f, 0.04816f}, { 0.44453f, 0.04857f}, { 0.53714f, 0.04344f}, { 0.44000f, 0.05008f},
{ 0.41057f, 0.07714f}, { 0.26748f, 0.10000f}, { 0.40152f, 0.11714f}, { 0.26597f, 0.61429f}, { 0.40260f, 0.61429f},
{ 0.17143f, 0.61957f}, { 0.53450f, 0.62000f}, { 0.53866f, 0.71714f}, { 0.53450f, 0.72286f}, { 0.17143f, 0.72329f},
{ 0.26597f, 0.72857f}, { 0.40260f, 0.72857f}, { 0.26748f, 0.91714f}, { 0.40000f, 0.99545f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_116 [] = {
{10, 5, 4}, { 6, 7, 9}, {10, 4, 3}, {10, 3, 9}, { 8, 6, 1}, { 6, 9, 1}, { 5,10,11},
{ 8, 1, 2}, { 0, 9, 3}, {11,12,13}, { 0, 1, 9}, {10,12,11}, {17,18,16}, {14,13,12},
{21,14,16}, {18,21,16}, {22,20,23}, {20,13,14}, {15,20,19}, {15,13,20}, {20,14,21},
{23,20,21},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_117 [] = {
{ 0.48571f,-0.09009f}, { 0.53714f,-0.09009f}, { 0.41714f,-0.07673f}, { 0.77143f,-0.07295f}, { 0.88000f,-0.07186f},
{ 0.63518f,-0.06571f}, { 0.76571f,-0.06878f}, { 0.88420f,-0.06571f}, { 0.34857f,-0.04771f}, { 0.70857f,-0.01846f},
{ 0.29901f,-0.00857f}, { 0.27429f, 0.02730f}, { 0.52000f, 0.02723f}, { 0.56000f, 0.02764f}, { 0.47339f, 0.03714f},
{ 0.76000f, 0.03684f}, { 0.61714f, 0.04135f}, { 0.43943f, 0.05429f}, { 0.65143f, 0.05787f}, { 0.41330f, 0.07714f},
{ 0.25143f, 0.08437f}, { 0.69143f, 0.08704f}, { 0.39343f, 0.10571f}, { 0.38899f, 0.11714f}, { 0.71473f, 0.11714f},
{ 0.38645f, 0.12286f}, { 0.73294f, 0.15714f}, { 0.23848f, 0.17429f}, { 0.37563f, 0.17429f}, { 0.75009f, 0.26000f},
{ 0.23848f, 0.71714f}, { 0.37295f, 0.71714f}, { 0.75009f, 0.71714f}, { 0.88420f, 0.71714f}, { 0.24265f, 0.72286f},
{ 0.36878f, 0.72286f}, { 0.75429f, 0.72329f}, { 0.88000f, 0.72329f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_117 [] = {
{ 6, 3,15}, { 3, 7,15}, { 3, 4, 7}, { 8,17,10}, { 2,14,17}, { 2,17, 8}, { 5,13, 1},
{19,11,10}, { 9,16, 5}, {12, 1,13}, { 0,12, 2}, {12, 0, 1}, { 9,18,16}, {13, 5,16},
{14, 2,12}, {11,22,20}, {21,18, 9}, {15,21, 9}, {21,15,24}, {20,28,27}, {11,19,22},
{24, 7,26}, {19,10,17}, {24,15, 7}, {25,22,23}, {20,22,25}, {20,25,28}, {26, 7,29},
{31,30,27}, {33,29, 7}, {34,31,35}, {34,30,31}, {31,27,28}, {36,33,37}, {32,29,33},
{36,32,33},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_118 [] = {
{ 0.45714f,-0.06947f}, { 0.58857f,-0.07103f}, { 0.52000f, 0.09808f}, { 0.52571f, 0.09808f}, { 0.47580f, 0.23714f},
{ 0.16151f, 0.71714f}, { 0.88420f, 0.71714f}, { 0.16427f, 0.72286f}, { 0.30286f, 0.71951f}, { 0.74857f, 0.72090f},
{ 0.88145f, 0.72286f}, { 0.29714f, 0.72395f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_118 [] = {
{ 4, 0, 2}, { 0, 4, 5}, { 3, 2, 0}, { 1, 3, 0}, { 3, 6, 9}, { 8,11, 5}, { 9, 6,10},
{ 7, 5,11}, { 8, 5, 4}, { 3, 1, 6},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_119 [] = {
{ 0.39429f,-0.07215f}, { 0.52571f,-0.07215f}, { 0.97714f,-0.07252f}, { 0.84571f,-0.06947f}, { 0.45714f, 0.10650f},
{ 0.46286f, 0.10650f}, { 0.92000f, 0.12073f}, { 0.69143f, 0.52785f}, { 0.15122f, 0.72286f}, { 0.28571f, 0.72090f},
{ 0.62857f, 0.72243f}, { 0.76193f, 0.72286f}, { 1.23164f, 0.72286f}, { 1.10857f, 0.72329f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_119 [] = {
{ 2, 6, 3}, { 0, 4, 8}, { 3, 6, 7}, { 5, 0, 1}, {12,13, 6}, { 5, 4, 0}, { 7,10, 5},
{11,10, 7}, { 7, 5, 1}, {11, 7, 6}, { 4, 9, 8}, {12, 6, 2},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_120 [] = {
{ 0.15697f,-0.07143f}, { 0.88073f,-0.07143f}, { 0.15473f,-0.06571f}, { 0.31429f,-0.07035f}, { 0.72571f,-0.07140f},
{ 0.88250f,-0.06571f}, { 0.52000f, 0.22529f}, { 0.52571f, 0.22529f}, { 0.60332f, 0.33429f}, { 0.43534f, 0.34000f},
{ 0.51429f, 0.45005f}, { 0.17188f, 0.71714f}, { 0.86812f, 0.71714f}, { 0.17412f, 0.72286f}, { 0.86588f, 0.72286f},
{ 0.32571f, 0.72395f}, { 0.71429f, 0.72395f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_120 [] = {
{ 1, 5, 4}, { 2, 6, 9}, { 8, 6, 7}, { 3, 2, 0}, { 4, 8, 7}, { 6, 2, 3}, { 4, 5, 8},
{ 8,10, 6}, {10, 9, 6}, {15,11, 9}, {16,10, 8}, {15, 9,10}, {12,16, 8}, {13,11,15},
{16,12,14},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_121 [] = {
{ 0.34286f,-0.39563f}, { 0.24000f,-0.38043f}, { 0.41714f,-0.37641f}, { 0.45714f,-0.34956f}, { 0.50436f,-0.29429f},
{ 0.32000f,-0.26680f}, { 0.22286f,-0.25766f}, { 0.36652f,-0.25429f}, { 0.54371f,-0.22000f}, { 0.41293f,-0.21429f},
{ 0.46848f,-0.07714f}, { 0.53714f, 0.09292f}, { 0.16998f, 0.72286f}, { 0.30857f, 0.71999f}, { 0.76000f, 0.72246f},
{ 0.88806f, 0.72286f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_121 [] = {
{ 2, 7, 0}, { 0, 5, 1}, { 5, 0, 7}, { 6, 1, 5}, { 3, 7, 2}, { 7, 3, 9}, { 3, 4, 9},
{ 9, 8,10}, { 9, 4, 8}, {10,11,12}, {11,15,14}, {11, 8,15}, {11,10, 8}, {11,13,12},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_122 [] = {
{ 0.17714f,-0.07295f}, { 0.86857f,-0.07186f}, { 0.17143f,-0.06878f}, { 0.87277f,-0.06571f}, { 0.17146f, 0.03714f},
{ 0.34212f, 0.03714f}, { 0.87277f, 0.03714f}, { 0.34132f, 0.04286f}, { 0.44000f, 0.04327f}, { 0.86857f, 0.04329f},
{ 0.20571f, 0.61689f}, { 0.67062f, 0.62000f}, { 0.84991f, 0.64286f}, { 0.20152f, 0.71714f}, { 0.84991f, 0.71714f},
{ 0.20571f, 0.72329f}, { 0.84571f, 0.72329f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_122 [] = {
{ 2, 0, 4}, { 0, 1, 9}, { 0, 5, 4}, { 1, 3, 9}, { 5, 0, 8}, { 5, 7, 4}, { 0, 9, 8},
{ 3, 6, 9}, {12,14,11}, {11,14,16}, {11,16,10}, {12,11, 7}, {11, 4, 7}, {10,15,13},
{15,10,16},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_123 [] = {
{ 0.61143f,-0.39454f}, { 0.46857f,-0.38420f}, { 0.40000f,-0.34154f}, { 0.61143f,-0.27975f}, { 0.35748f,-0.27143f},
{ 0.52000f,-0.26992f}, { 0.47787f,-0.23143f}, { 0.46748f,-0.19143f}, { 0.34134f,-0.18000f}, { 0.46395f, 0.04286f},
{ 0.33563f, 0.05429f}, { 0.45184f, 0.14571f}, { 0.32109f, 0.16286f}, { 0.29143f, 0.21832f}, { 0.42286f, 0.22716f},
{ 0.25143f, 0.24943f}, { 0.18857f, 0.26528f}, { 0.39429f, 0.26698f}, { 0.31413f, 0.32286f}, { 0.18857f, 0.38615f},
{ 0.25143f, 0.40073f}, { 0.41188f, 0.40286f}, { 0.29143f, 0.42775f}, { 0.43514f, 0.44286f}, { 0.32823f, 0.49429f},
{ 0.45866f, 0.52286f}, { 0.34134f, 0.60286f}, { 0.46705f, 0.80857f}, { 0.34478f, 0.84857f}, { 0.47748f, 0.87143f},
{ 0.35748f, 0.91143f}, { 0.50286f, 0.90821f}, { 0.50793f, 0.91143f}, { 0.50857f, 0.91188f}, { 0.61143f, 0.92814f},
{ 0.40571f, 0.99511f}, { 0.46857f, 1.03294f}, { 0.53143f, 1.04437f}, { 0.61143f, 1.04329f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_123 [] = {
{ 0, 3, 5}, { 6, 2, 5}, { 2, 6, 4}, { 0, 5, 1}, { 2, 1, 5}, { 4, 7, 8}, { 7, 4, 6},
{ 8, 9,10}, {10,11,12}, { 9, 8, 7}, {11,10, 9}, {12,17,13}, {12,14,17}, {14,12,11},
{18,15,13}, {16,15,20}, {18,13,17}, {16,20,19}, {15,18,20}, {21,22,18}, {22,21,24},
{22,20,18}, {24,25,26}, {23,24,21}, {25,24,23}, {26,27,28}, {27,26,25}, {28,29,30},
{29,28,27}, {30,29,35}, {31,32,33}, {36,31,33}, {31,36,29}, {36,33,37}, {34,38,37},
{35,29,36}, {34,37,33},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_124 [] = {
{ 0.28571f,-0.39454f}, { 0.38857f,-0.39563f}, { 0.28571f, 1.04329f}, { 0.38857f, 1.04437f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_124 [] = {
{ 3, 2, 0}, { 3, 0, 1},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_125 [] = {
{ 0.17714f,-0.39454f}, { 0.31429f,-0.38613f}, { 0.39429f,-0.33832f}, { 0.17714f,-0.27975f}, { 0.27429f,-0.26784f},
{ 0.43681f,-0.26000f}, { 0.31070f,-0.23714f}, { 0.44950f,-0.19714f}, { 0.32723f,-0.15714f}, { 0.45295f, 0.04857f},
{ 0.33295f, 0.11714f}, { 0.46857f, 0.16404f}, { 0.35387f, 0.19714f}, { 0.51429f, 0.23258f}, { 0.56000f, 0.25681f},
{ 0.39429f, 0.26403f}, { 0.60630f, 0.26571f}, { 0.47702f, 0.32857f}, { 0.41714f, 0.36742f}, { 0.60571f, 0.38615f},
{ 0.54857f, 0.39927f}, { 0.50171f, 0.43143f}, { 0.36086f, 0.43714f}, { 0.46748f, 0.50000f}, { 0.32991f, 0.56857f},
{ 0.45252f, 0.78571f}, { 0.32723f, 0.80286f}, { 0.31748f, 0.87143f}, { 0.29143f, 0.90893f}, { 0.43470f, 0.91714f},
{ 0.17714f, 0.92814f}, { 0.41629f, 0.95714f}, { 0.36571f, 1.01107f}, { 0.32000f, 1.03294f}, { 0.17714f, 1.04329f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_125 [] = {
{ 4, 3, 0}, { 2, 4, 1}, { 6, 7, 8}, { 1, 4, 0}, { 2, 6, 4}, { 5, 6, 2}, { 6, 5, 7},
{ 8, 9,10}, { 9, 8, 7}, {10,11,12}, {15,13,17}, {11,10, 9}, {12,11,15}, {13,14,17},
{13,15,11}, {20,17,14}, {20,14,16}, {19,20,16}, {21,17,20}, {17,21,18}, {22,23,24},
{22,18,21}, {23,22,21}, {25,26,24}, {25,24,23}, {29,27,26}, {29,26,25}, {27,31,28},
{31,27,29}, {32,28,31}, {28,33,30}, {33,34,30}, {33,28,32},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_126 [] = {
{ 0.73714f, 0.34462f}, { 0.20759f, 0.35143f}, { 0.21143f, 0.34662f}, { 0.81143f, 0.34723f}, { 0.66857f, 0.35756f},
{ 0.86857f, 0.36135f}, { 0.25143f, 0.38115f}, { 0.90857f, 0.38086f}, { 0.52000f, 0.41580f}, { 0.32571f, 0.42723f},
{ 0.97140f, 0.43143f}, { 0.37143f, 0.43866f}, { 0.42286f, 0.44093f}, { 0.79429f, 0.49009f}, { 0.21028f, 0.50000f},
{ 0.72571f, 0.49681f}, { 0.86286f, 0.50930f}, { 0.25714f, 0.54115f}, { 0.92571f, 0.54759f}, { 0.32571f, 0.57470f},
{ 0.50286f, 0.57621f}, { 0.96571f, 0.58154f}, { 0.97143f, 0.58073f}, { 0.38857f, 0.58680f}, { 0.44000f, 0.58723f},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_126 [] = {
{ 1,17,14}, { 8, 4,15}, {13, 5, 7}, { 6, 1, 2}, { 5,13, 3}, { 1, 6,17}, { 3,13, 0},
{16,10,18}, {15, 4, 0}, {13, 7,16}, {15, 0,13}, { 8,20,12}, {12,20,11}, { 9,17, 6},
{10,16, 7}, {17, 9,19}, {22,21,18}, {11,20,24}, {11,19, 9}, {20, 8,15}, {11,24,23},
{22,18,10}, {11,23,19},
};

static const VTK_VECTOR_TEXT_GLYPH Letters[] = {
{ 0.438482f,  VTK_VECTOR_TEXT_POINTS_33,  11,  VTK_VECTOR_TEXT_TRIANGLES_33,    7 },
{ 0.615625f,  VTK_VECTOR_TEXT_POINTS_34,  21,  VTK_VECTOR_TEXT_TRIANGLES_34,   17 },
{ 0.974539f,  VTK_VECTOR_TEXT_POINTS_35,  43,  VTK_VECTOR_TEXT_TRIANGLES_35,   43 },
{ 0.921518f,  VTK_VECTOR_TEXT_POINTS_36,  73,  VTK_VECTOR_TEXT_TRIANGLES_36,   75 },
{ 1.409911f,  VTK_VECTOR_TEXT_POINTS_37,  81,  VTK_VECTOR_TEXT_TRIANGLES_37,   79 },
{ 1.126291f,  VTK_VECTOR_TEXT_POINTS_38,  76,  VTK_VECTOR_TEXT_TRIANGLES_38,   78 },
{ 0.364197f,  VTK_VECTOR_TEXT_POINTS_39,  10,  VTK_VECTOR_TEXT_TRIANGLES_39,    8 },
{ 0.595731f,  VTK_VECTOR_TEXT_POINTS_40,  19,  VTK_VECTOR_TEXT_TRIANGLES_40,   17 },
{ 0.598482f,  VTK_VECTOR_TEXT_POINTS_41,  19,  VTK_VECTOR_TEXT_TRIANGLES_41,   17 },
{ 0.685300f,  VTK_VECTOR_TEXT_POINTS_42,  34,  VTK_VECTOR_TEXT_TRIANGLES_42,   32 },
{ 0.952768f,  VTK_VECTOR_TEXT_POINTS_43,  20,  VTK_VECTOR_TEXT_TRIANGLES_43,   18 },
{ 0.432768f,  VTK_VECTOR_TEXT_POINTS_44,  23,  VTK_VECTOR_TEXT_TRIANGLES_44,   21 },
{ 0.606146f,  VTK_VECTOR_TEXT_POINTS_45,   8,  VTK_VECTOR_TEXT_TRIANGLES_45,    6 },
{ 0.432768f,  VTK_VECTOR_TEXT_POINTS_46,  13,  VTK_VECTOR_TEXT_TRIANGLES_46,   11 },
{ 0.562348f,  VTK_VECTOR_TEXT_POINTS_47,   5,  VTK_VECTOR_TEXT_TRIANGLES_47,    3 },
{ 0.926804f,  VTK_VECTOR_TEXT_POINTS_48,  53,  VTK_VECTOR_TEXT_TRIANGLES_48,   53 },
{ 0.708571f,  VTK_VECTOR_TEXT_POINTS_49,  11,  VTK_VECTOR_TEXT_TRIANGLES_49,    9 },
{ 0.914286f,  VTK_VECTOR_TEXT_POINTS_50,  43,  VTK_VECTOR_TEXT_TRIANGLES_50,   41 },
{ 0.927232f,  VTK_VECTOR_TEXT_POINTS_51,  68,  VTK_VECTOR_TEXT_TRIANGLES_51,   66 },
{ 0.920000f,  VTK_VECTOR_TEXT_POINTS_52,  18,  VTK_VECTOR_TEXT_TRIANGLES_52,   18 },
{ 0.932946f,  VTK_VECTOR_TEXT_POINTS_53,  54,  VTK_VECTOR_TEXT_TRIANGLES_53,   52 },
{ 0.927232f,  VTK_VECTOR_TEXT_POINTS_54,  70,  VTK_VECTOR_TEXT_TRIANGLES_54,   70 },
{ 0.923788f,  VTK_VECTOR_TEXT_POINTS_55,  17,  VTK_VECTOR_TEXT_TRIANGLES_55,   15 },
{ 0.926804f,  VTK_VECTOR_TEXT_POINTS_56,  83,  VTK_VECTOR_TEXT_TRIANGLES_56,   85 },
{ 0.927232f,  VTK_VECTOR_TEXT_POINTS_57,  72,  VTK_VECTOR_TEXT_TRIANGLES_57,   72 },
{ 0.432768f,  VTK_VECTOR_TEXT_POINTS_58,  14,  VTK_VECTOR_TEXT_TRIANGLES_58,   10 },
{ 0.432768f,  VTK_VECTOR_TEXT_POINTS_59,  18,  VTK_VECTOR_TEXT_TRIANGLES_59,   14 },
{ 0.952690f,  VTK_VECTOR_TEXT_POINTS_60,  11,  VTK_VECTOR_TEXT_TRIANGLES_60,    9 },
{ 0.952768f,  VTK_VECTOR_TEXT_POINTS_61,  12,  VTK_VECTOR_TEXT_TRIANGLES_61,    8 },
{ 0.952360f,  VTK_VECTOR_TEXT_POINTS_62,  11,  VTK_VECTOR_TEXT_TRIANGLES_62,    9 },
{ 0.918074f,  VTK_VECTOR_TEXT_POINTS_63,  45,  VTK_VECTOR_TEXT_TRIANGLES_63,   41 },
{ 1.632597f,  VTK_VECTOR_TEXT_POINTS_64, 114,  VTK_VECTOR_TEXT_TRIANGLES_64,  114 },
{ 1.155731f,  VTK_VECTOR_TEXT_POINTS_65,  13,  VTK_VECTOR_TEXT_TRIANGLES_65,   13 },
{ 1.081090f,  VTK_VECTOR_TEXT_POINTS_66,  48,  VTK_VECTOR_TEXT_TRIANGLES_66,   50 },
{ 1.186046f,  VTK_VECTOR_TEXT_POINTS_67,  56,  VTK_VECTOR_TEXT_TRIANGLES_67,   54 },
{ 1.167232f,  VTK_VECTOR_TEXT_POINTS_68,  34,  VTK_VECTOR_TEXT_TRIANGLES_68,   34 },
{ 1.080000f,  VTK_VECTOR_TEXT_POINTS_69,  15,  VTK_VECTOR_TEXT_TRIANGLES_69,   13 },
{ 1.005714f,  VTK_VECTOR_TEXT_POINTS_70,  12,  VTK_VECTOR_TEXT_TRIANGLES_70,   10 },
{ 1.234286f,  VTK_VECTOR_TEXT_POINTS_71,  60,  VTK_VECTOR_TEXT_TRIANGLES_71,   58 },
{ 1.125714f,  VTK_VECTOR_TEXT_POINTS_72,  16,  VTK_VECTOR_TEXT_TRIANGLES_72,   14 },
{ 0.428571f,  VTK_VECTOR_TEXT_POINTS_73,   4,  VTK_VECTOR_TEXT_TRIANGLES_73,    2 },
{ 0.790089f,  VTK_VECTOR_TEXT_POINTS_74,  27,  VTK_VECTOR_TEXT_TRIANGLES_74,   25 },
{ 1.155019f,  VTK_VECTOR_TEXT_POINTS_75,  17,  VTK_VECTOR_TEXT_TRIANGLES_75,   15 },
{ 0.941339f,  VTK_VECTOR_TEXT_POINTS_76,   7,  VTK_VECTOR_TEXT_TRIANGLES_76,    5 },
{ 1.302857f,  VTK_VECTOR_TEXT_POINTS_77,  19,  VTK_VECTOR_TEXT_TRIANGLES_77,   17 },
{ 1.125714f,  VTK_VECTOR_TEXT_POINTS_78,  14,  VTK_VECTOR_TEXT_TRIANGLES_78,   12 },
{ 1.267054f,  VTK_VECTOR_TEXT_POINTS_79,  63,  VTK_VECTOR_TEXT_TRIANGLES_79,   63 },
{ 1.098661f,  VTK_VECTOR_TEXT_POINTS_80,  31,  VTK_VECTOR_TEXT_TRIANGLES_80,   31 },
{ 1.276398f,  VTK_VECTOR_TEXT_POINTS_81,  66,  VTK_VECTOR_TEXT_TRIANGLES_81,   66 },
{ 1.225355f,  VTK_VECTOR_TEXT_POINTS_82,  46,  VTK_VECTOR_TEXT_TRIANGLES_82,   46 },
{ 1.081090f,  VTK_VECTOR_TEXT_POINTS_83,  69,  VTK_VECTOR_TEXT_TRIANGLES_83,   67 },
{ 1.045714f,  VTK_VECTOR_TEXT_POINTS_84,   8,  VTK_VECTOR_TEXT_TRIANGLES_84,    6 },
{ 1.126804f,  VTK_VECTOR_TEXT_POINTS_85,  32,  VTK_VECTOR_TEXT_TRIANGLES_85,   30 },
{ 1.148571f,  VTK_VECTOR_TEXT_POINTS_86,   8,  VTK_VECTOR_TEXT_TRIANGLES_86,    6 },
{ 1.568063f,  VTK_VECTOR_TEXT_POINTS_87,  14,  VTK_VECTOR_TEXT_TRIANGLES_87,   12 },
{ 1.141168f,  VTK_VECTOR_TEXT_POINTS_88,  14,  VTK_VECTOR_TEXT_TRIANGLES_88,   12 },
{ 1.145205f,  VTK_VECTOR_TEXT_POINTS_89,  12,  VTK_VECTOR_TEXT_TRIANGLES_89,   10 },
{ 1.040000f,  VTK_VECTOR_TEXT_POINTS_90,  11,  VTK_VECTOR_TEXT_TRIANGLES_90,    9 },
{ 0.541339f,  VTK_VECTOR_TEXT_POINTS_91,   8,  VTK_VECTOR_TEXT_TRIANGLES_91,    6 },
{ 0.564685f,  VTK_VECTOR_TEXT_POINTS_92,   5,  VTK_VECTOR_TEXT_TRIANGLES_92,    3 },
{ 0.465968f,  VTK_VECTOR_TEXT_POINTS_93,   9,  VTK_VECTOR_TEXT_TRIANGLES_93,    7 },
{ 0.817005f,  VTK_VECTOR_TEXT_POINTS_94,  11,  VTK_VECTOR_TEXT_TRIANGLES_94,    9 },
{ 1.011860f,  VTK_VECTOR_TEXT_POINTS_95,   4,  VTK_VECTOR_TEXT_TRIANGLES_95,    2 },
{ 0.486571f,  VTK_VECTOR_TEXT_POINTS_96,  11,  VTK_VECTOR_TEXT_TRIANGLES_96,    9 },
{ 0.929303f,  VTK_VECTOR_TEXT_POINTS_97,  70,  VTK_VECTOR_TEXT_TRIANGLES_97,   70 },
{ 0.932518f,  VTK_VECTOR_TEXT_POINTS_98,  49,  VTK_VECTOR_TEXT_TRIANGLES_98,   49 },
{ 0.894057f,  VTK_VECTOR_TEXT_POINTS_99,  58,  VTK_VECTOR_TEXT_TRIANGLES_99,   56 },
{ 0.885714f, VTK_VECTOR_TEXT_POINTS_100,  48, VTK_VECTOR_TEXT_TRIANGLES_100,   48 },
{ 0.934539f, VTK_VECTOR_TEXT_POINTS_101,  65, VTK_VECTOR_TEXT_TRIANGLES_101,   65 },
{ 0.617143f, VTK_VECTOR_TEXT_POINTS_102,  24, VTK_VECTOR_TEXT_TRIANGLES_102,   22 },
{ 0.892518f, VTK_VECTOR_TEXT_POINTS_103,  71, VTK_VECTOR_TEXT_TRIANGLES_103,   71 },
{ 0.889502f, VTK_VECTOR_TEXT_POINTS_104,  27, VTK_VECTOR_TEXT_TRIANGLES_104,   25 },
{ 0.377143f, VTK_VECTOR_TEXT_POINTS_105,   8, VTK_VECTOR_TEXT_TRIANGLES_105,    4 },
{ 0.375625f, VTK_VECTOR_TEXT_POINTS_106,  18, VTK_VECTOR_TEXT_TRIANGLES_106,   14 },
{ 0.897876f, VTK_VECTOR_TEXT_POINTS_107,  15, VTK_VECTOR_TEXT_TRIANGLES_107,   13 },
{ 0.371429f, VTK_VECTOR_TEXT_POINTS_108,   4, VTK_VECTOR_TEXT_TRIANGLES_108,    2 },
{ 1.318074f, VTK_VECTOR_TEXT_POINTS_109,  45, VTK_VECTOR_TEXT_TRIANGLES_109,   43 },
{ 0.889911f, VTK_VECTOR_TEXT_POINTS_110,  38, VTK_VECTOR_TEXT_TRIANGLES_110,   36 },
{ 0.938661f, VTK_VECTOR_TEXT_POINTS_111,  65, VTK_VECTOR_TEXT_TRIANGLES_111,   65 },
{ 0.935625f, VTK_VECTOR_TEXT_POINTS_112,  49, VTK_VECTOR_TEXT_TRIANGLES_112,   49 },
{ 0.885714f, VTK_VECTOR_TEXT_POINTS_113,  52, VTK_VECTOR_TEXT_TRIANGLES_113,   52 },
{ 0.667686f, VTK_VECTOR_TEXT_POINTS_114,  24, VTK_VECTOR_TEXT_TRIANGLES_114,   22 },
{ 0.849502f, VTK_VECTOR_TEXT_POINTS_115,  63, VTK_VECTOR_TEXT_TRIANGLES_115,   61 },
{ 0.551972f, VTK_VECTOR_TEXT_POINTS_116,  24, VTK_VECTOR_TEXT_TRIANGLES_116,   22 },
{ 0.884197f, VTK_VECTOR_TEXT_POINTS_117,  38, VTK_VECTOR_TEXT_TRIANGLES_117,   36 },
{ 0.884203f, VTK_VECTOR_TEXT_POINTS_118,  12, VTK_VECTOR_TEXT_TRIANGLES_118,   10 },
{ 1.231638f, VTK_VECTOR_TEXT_POINTS_119,  14, VTK_VECTOR_TEXT_TRIANGLES_119,   12 },
{ 0.882498f, VTK_VECTOR_TEXT_POINTS_120,  17, VTK_VECTOR_TEXT_TRIANGLES_120,   15 },
{ 0.888063f, VTK_VECTOR_TEXT_POINTS_121,  16, VTK_VECTOR_TEXT_TRIANGLES_121,   14 },
{ 0.872768f, VTK_VECTOR_TEXT_POINTS_122,  17, VTK_VECTOR_TEXT_TRIANGLES_122,   15 },
{ 0.611429f, VTK_VECTOR_TEXT_POINTS_123,  39, VTK_VECTOR_TEXT_TRIANGLES_123,   37 },
{ 0.388571f, VTK_VECTOR_TEXT_POINTS_124,   4, VTK_VECTOR_TEXT_TRIANGLES_124,    2 },
{ 0.606299f, VTK_VECTOR_TEXT_POINTS_125,  35, VTK_VECTOR_TEXT_TRIANGLES_125,   33 },
{ 0.971429f, VTK_VECTOR_TEXT_POINTS_126,  25, VTK_VECTOR_TEXT_TRIANGLES_126,   23 },
};

// Construct object with no string set and backing enabled.
vtkVectorText::vtkVectorText()
{
  this->Text = NULL;

  this->SetNumberOfInputPorts(0);
}

int vtkVectorText::RequestData(
  vtkInformation *vtkNotUsed(request),
  vtkInformationVector **vtkNotUsed(inputVector),
  vtkInformationVector *outputVector)
{
  // get the info object
  vtkInformation *outInfo = outputVector->GetInformationObject(0);

  // get the ouptut
  vtkPolyData *output = vtkPolyData::SafeDownCast(
    outInfo->Get(vtkDataObject::DATA_OBJECT()));

  vtkPoints *newPoints;
  vtkCellArray *newPolys;
  int ptOffset = 0;
  int aPoint, i;
  int pos = 0;
  float xpos = 0;
  float ypos = 0;
  int ptCount, triCount;
  VTK_VECTOR_TEXT_GLYPH aLetter;
  float width;
  float ftmp[3];

  if (this->Text == NULL)
    {
    vtkErrorMacro (<< "Text is not set!");
    return 0;
    }

  // Set things up; allocate memory
  newPoints = vtkPoints::New();
  newPolys = vtkCellArray::New();
  ftmp[2] = 0.0;

  // Create Text
  while (this->Text[pos])
    {
    switch (this->Text[pos])
      {
      case 32:
        xpos += 0.4;
        break;

      case 10:
        ypos -= 1.4;
        xpos = 0;
        break;

      default:
        // if we have a valid character
        if ((this->Text[pos] > 32)&&(this->Text[pos] < 127))
          {
          // add the result to our output
          aLetter = Letters[static_cast<int>(this->Text[pos])-33];
          ptCount = aLetter.ptCount;
          width = aLetter.width;
          for (i = 0; i < ptCount; i++)
            {
            ftmp[0] = aLetter.points[i].x;
            ftmp[1] = aLetter.points[i].y;
            ftmp[0] += xpos;
            ftmp[1] += ypos;
            newPoints->InsertNextPoint(ftmp);
            }
          triCount = aLetter.triCount;
          for (i = 0; i < triCount; i++)
            {
            newPolys->InsertNextCell(3);
            aPoint = aLetter.triangles[i].p1;
            newPolys->InsertCellPoint(aPoint + ptOffset);
            aPoint = aLetter.triangles[i].p2;
            newPolys->InsertCellPoint(aPoint + ptOffset);
            aPoint = aLetter.triangles[i].p3;
            newPolys->InsertCellPoint(aPoint + ptOffset);
            }
          ptOffset += ptCount;
          xpos += width;
          }
        break;
      }
    pos++;
    }

  //
  // Update ourselves and release memory
  //
  output->SetPoints(newPoints);
  newPoints->Delete();

  output->SetPolys(newPolys);
  newPolys->Delete();

  return 1;
}

void vtkVectorText::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os,indent);

  os << indent << "Text: " << (this->Text ? this->Text : "(none)") << "\n";
}

vtkVectorText::~vtkVectorText()
{
  delete [] this->Text;
}
