/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.ui.navigation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.j3d.ui.navigation.ViewpointCellRenderer;
import org.j3d.ui.navigation.ViewpointData;
import org.j3d.ui.navigation.ViewpointSelectionListener;
import org.j3d.util.ImageLoader;

public class ViewpointToolbar
extends JPanel
implements ActionListener,
ItemListener {
    private static final String NEXT_BUTTON = "images/navigation/ButtonForward.gif";
    private static final String PREV_BUTTON = "images/navigation/ButtonBack.gif";
    private static final String UP_BUTTON = "images/navigation/ButtonHome.gif";
    private ViewpointSelectionListener viewpointListener;
    private JComboBox viewpoints;
    private DefaultComboBoxModel viewpointModel;
    private JButton nextViewpoint;
    private JButton prevViewpoint;
    private JButton homeViewpoint;

    public ViewpointToolbar() {
        this((ViewpointData[])null);
    }

    public ViewpointToolbar(ViewpointData[] viewpointDataArray) {
        this.viewpointModel = viewpointDataArray != null ? new DefaultComboBoxModel<ViewpointData>(viewpointDataArray) : new DefaultComboBoxModel();
        this.viewpoints = new JComboBox(this.viewpointModel);
        this.viewpoints.setRenderer(new ViewpointCellRenderer());
        this.viewpoints.setEditable(false);
        this.viewpoints.setMaximumRowCount(10);
        this.viewpoints.setMinimumSize(new Dimension(60, 10));
        this.viewpoints.setToolTipText("Select a Viewpoint");
        this.viewpoints.addItemListener(this);
        Icon icon = ImageLoader.loadIcon(NEXT_BUTTON);
        this.nextViewpoint = new JButton(icon);
        this.nextViewpoint.setMargin(new Insets(0, 0, 0, 0));
        this.nextViewpoint.setToolTipText("Next Viewpoint");
        this.nextViewpoint.addActionListener(this);
        icon = ImageLoader.loadIcon(PREV_BUTTON);
        this.prevViewpoint = new JButton(icon);
        this.prevViewpoint.setMargin(new Insets(0, 0, 0, 0));
        this.prevViewpoint.setToolTipText("Previous Viewpoint");
        this.prevViewpoint.addActionListener(this);
        icon = ImageLoader.loadIcon(UP_BUTTON);
        this.homeViewpoint = new JButton(icon);
        this.homeViewpoint.setMargin(new Insets(0, 0, 0, 0));
        this.homeViewpoint.addActionListener(this);
        this.homeViewpoint.setToolTipText("Return to current Viewpoint");
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(this.nextViewpoint);
        jPanel.add(this.homeViewpoint);
        this.setLayout(new BorderLayout());
        this.add((Component)this.prevViewpoint, "West");
        this.add((Component)this.viewpoints, "Center");
        this.add((Component)jPanel, "East");
    }

    public void setViewpointSelectionListener(ViewpointSelectionListener viewpointSelectionListener) {
        this.viewpointListener = viewpointSelectionListener;
    }

    public void setViewpoints(ViewpointData[] viewpointDataArray) {
        this.viewpointModel.removeAllElements();
        if (viewpointDataArray != null) {
            for (int i = 0; i < viewpointDataArray.length; ++i) {
                this.viewpointModel.addElement(viewpointDataArray[i]);
            }
            this.viewpoints.setSelectedIndex(0);
        }
    }

    public void appendViewpoint(ViewpointData viewpointData) {
        this.viewpointModel.addElement(viewpointData);
        if (this.viewpoints.getItemCount() == 1) {
            this.viewpoints.setSelectedIndex(0);
        }
    }

    public void insertViewpoint(int n, ViewpointData viewpointData) {
        this.viewpointModel.insertElementAt(viewpointData, n);
    }

    public void removeViewpoint(ViewpointData viewpointData) {
        this.viewpointModel.removeElement(viewpointData);
    }

    public void selectViewpoint(ViewpointData viewpointData) {
        this.viewpoints.setSelectedItem(viewpointData);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = this.viewpoints.getSelectedIndex();
        if (object == this.nextViewpoint) {
            if (++n >= this.viewpoints.getItemCount()) {
                n = 0;
            }
            this.viewpoints.setSelectedIndex(n);
        } else if (object == this.prevViewpoint) {
            if (--n < 0) {
                n = this.viewpoints.getItemCount() - 1;
            }
            this.viewpoints.setSelectedIndex(n);
        } else if (object == this.homeViewpoint) {
            this.viewpoints.setSelectedIndex(n);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        ViewpointData viewpointData = (ViewpointData)this.viewpoints.getSelectedItem();
        if (this.viewpointListener != null) {
            this.viewpointListener.viewpointSelected(viewpointData);
        }
    }

    public void setEnabled(boolean bl) {
        this.viewpoints.setEnabled(bl);
        this.nextViewpoint.setEnabled(bl);
        this.prevViewpoint.setEnabled(bl);
        this.homeViewpoint.setEnabled(bl);
    }
}

