/*
 * Copyright 2004 Sandia Corporation.
 * Under the terms of Contract DE-AC04-94AL85000, there is a non-exclusive
 * license for use of this work by or on behalf of the
 * U.S. Government. Redistribution and use in source and binary forms, with
 * or without modification, are permitted provided that this Notice and any
 * statement of authorship are reproduced on all copies.
 */
#include "vtkCell.h"
#include "vtkCommand.h"
#include "vtkDataSet.h"
#include "vtkDataSetMapper.h"
#include "vtkActor.h"
#include "vtkRenderer.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkShrinkFilter.h"
#include "vtkCellTypes.h"
#include "vtkLabeledDataMapper.h"
#include "vtkIdTypeArray.h"
#include "vtkPointData.h"
#include "vtkPoints.h"
#include "vtkPNGWriter.h"
#include "vtkTextActor.h"
#include "vtkGlyph3D.h"
#include "vtkSphereSource.h"
#include "vtkPolyData.h"
#include "vtkPolyDataMapper.h"
#include "vtkActor2D.h"
#include "vtkProperty.h"
#include "vtkTessellatorFilter.h"
#include "vtkTestUtilities.h"
#include "vtkTextProperty.h"
#include "vtkToolkits.h"
#include "vtkUnstructuredGrid.h"
#include "vtkXMLUnstructuredGridReader.h"
#include "vtkWindowToImageFilter.h"

#include "vtkStreamingTessellator.h"
#include "vtkEdgeSubdivisionCriterion.h"

#include <algorithm>

#include "vtkObjectFactory.h"
#include "vtkIdList.h"
#include "vtkDataArray.h"
#include "vtkPointData.h"
#include "vtkCellData.h"
#include "vtkCell.h"
#include "vtkDataSet.h"

using std::copy;

#undef ONLY_WIRE
#undef FOR_PAPER
/// Define this and the test will generate arrays of values which you can paste into the code and use to check
#undef VTK_GENERATE_BASELINE
/// Undefine this and the number and coordinates of output tetrahedra will not be checked.
#define VTK_CHECK_RESULTS

// Yeah, global variables suck.
static int vtkTessellatorIsInteractive;
static int vtkTessellatorError = 0;

#ifdef VTK_GENERATE_BASELINE
static ofstream itet;
static ofstream otet;
static ofstream tstc;
static int otetCtr = 0;

static ofstream itri;
static ofstream otri;
static ofstream ttri;
static int otriCtr = 0;
#endif // VTK_GENERATE_BASELINE
#ifdef VTK_CHECK_RESULTS
//static int vtkOTriCtr = 0;
//static int vtkITriCtr = 0;
//static int vtkTriCode = 0;
//static double* vtkITriPtr = 0;
//static double* vtkOTriPtr = 0;

static int vtkOTetCtr = 0;
static int vtkITetCtr = 0;
static int vtkTstCode = 0;
static double* vtkITetPtr = 0;
static double* vtkOTetPtr = 0;

static struct {
  const char* Name;
  int BeginOffset;
  int EndOffset;
}  vtkTestSummaries[] = {
  { "Edge code 0 = 000000, Test ID 0", 0, 1 },
  { "Edge code 1 = 100000, Test ID 1", 1, 3 },
  { "Edge code 2 = 010000, Test ID 2", 3, 5 },
  { "Edge code 4 = 001000, Test ID 3", 5, 7 },
  { "Edge code 8 = 000100, Test ID 4", 7, 9 },
  { "Edge code 16 = 000010, Test ID 5", 9, 11 },
  { "Edge code 32 = 000001, Test ID 6", 11, 13 },
  { "Edge code 3 = 110000, Test ID 7", 13, 16 },
  { "Edge code 5 = 101000, Test ID 8", 16, 19 },
  { "Edge code 6 = 011000, Test ID 9", 19, 22 },
  { "Edge code 9 = 100100, Test ID 10", 22, 25 },
  { "Edge code 17 = 100010, Test ID 11", 25, 28 },
  { "Edge code 24 = 000110, Test ID 12", 28, 31 },
  { "Edge code 18 = 010010, Test ID 13", 31, 34 },
  { "Edge code 34 = 010001, Test ID 14", 34, 37 },
  { "Edge code 48 = 000011, Test ID 15", 37, 40 },
  { "Edge code 12 = 001100, Test ID 16", 40, 43 },
  { "Edge code 36 = 001001, Test ID 17", 43, 46 },
  { "Edge code 40 = 000101, Test ID 18", 46, 49 },
  { "Edge code 33 = 100001, Test ID 19", 49, 53 },
  { "Edge code 10 = 010100, Test ID 20", 53, 57 },
  { "Edge code 20 = 001010, Test ID 21", 57, 61 },
  { "Edge code 13 = 101100, Test ID 22", 61, 65 },
  { "Edge code 19 = 110010, Test ID 23", 65, 69 },
  { "Edge code 38 = 011001, Test ID 24", 69, 73 },
  { "Edge code 56 = 000111, Test ID 25", 73, 77 },
  { "Edge code 25 = 100110, Test ID 26", 77, 81 },
  { "Edge code 50 = 010011, Test ID 27", 81, 85 },
  { "Edge code 44 = 001101, Test ID 28", 85, 89 },
  { "Edge code 7 = 111000, Test ID 29", 89, 93 },
  { "Edge code 21 = 101010, Test ID 30", 93, 98 },
  { "Edge code 11 = 110100, Test ID 31", 98, 103 },
  { "Edge code 35 = 110001, Test ID 32", 103, 108 },
  { "Edge code 22 = 011010, Test ID 33", 108, 113 },
  { "Edge code 37 = 101001, Test ID 34", 113, 118 },
  { "Edge code 14 = 011100, Test ID 35", 118, 123 },
  { "Edge code 49 = 100011, Test ID 36", 123, 128 },
  { "Edge code 26 = 010110, Test ID 37", 128, 133 },
  { "Edge code 52 = 001011, Test ID 38", 133, 138 },
  { "Edge code 42 = 010101, Test ID 39", 138, 143 },
  { "Edge code 28 = 001110, Test ID 40", 143, 148 },
  { "Edge code 41 = 100101, Test ID 41", 148, 153 },
  { "Edge code 58 = 010111, Test ID 42", 153, 159 },
  { "Edge code 54 = 011011, Test ID 43", 159, 165 },
  { "Edge code 51 = 110011, Test ID 44", 165, 171 },
  { "Edge code 60 = 001111, Test ID 45", 171, 177 },
  { "Edge code 46 = 011101, Test ID 46", 177, 183 },
  { "Edge code 45 = 101101, Test ID 47", 183, 189 },
  { "Edge code 57 = 100111, Test ID 48", 189, 195 },
  { "Edge code 27 = 110110, Test ID 49", 195, 201 },
  { "Edge code 29 = 101110, Test ID 50", 201, 207 },
  { "Edge code 39 = 111001, Test ID 51", 207, 213 },
  { "Edge code 23 = 111010, Test ID 52", 213, 219 },
  { "Edge code 15 = 111100, Test ID 53", 219, 225 },
  { "Edge code 30 = 011110, Test ID 54", 225, 231 },
  { "Edge code 53 = 101011, Test ID 55", 231, 237 },
  { "Edge code 43 = 110101, Test ID 56", 237, 243 },
  { "Edge code 62 = 011111, Test ID 57", 243, 250 },
  { "Edge code 61 = 101111, Test ID 58", 250, 257 },
  { "Edge code 59 = 110111, Test ID 59", 257, 264 },
  { "Edge code 55 = 111011, Test ID 60", 264, 271 },
  { "Edge code 47 = 111101, Test ID 61", 271, 278 },
  { "Edge code 31 = 111110, Test ID 62", 278, 285 },
  { "Edge code 63 = 111111, Test ID 63", 285, 293 },
  { "Edge code 0 = 000000, Test ID 0", 293, 294 },
  { "Edge code 1 = 100000, Test ID 1", 294, 296 },
  { "Edge code 2 = 010000, Test ID 2", 296, 298 },
  { "Edge code 4 = 001000, Test ID 3", 298, 300 },
  { "Edge code 8 = 000100, Test ID 4", 300, 302 },
  { "Edge code 16 = 000010, Test ID 5", 302, 304 },
  { "Edge code 32 = 000001, Test ID 6", 304, 306 },
  { "Edge code 3 = 110000, Test ID 7", 306, 309 },
  { "Edge code 5 = 101000, Test ID 8", 309, 312 },
  { "Edge code 6 = 011000, Test ID 9", 312, 315 },
  { "Edge code 9 = 100100, Test ID 10", 315, 318 },
  { "Edge code 17 = 100010, Test ID 11", 318, 321 },
  { "Edge code 24 = 000110, Test ID 12", 321, 324 },
  { "Edge code 18 = 010010, Test ID 13", 324, 327 },
  { "Edge code 34 = 010001, Test ID 14", 327, 330 },
  { "Edge code 48 = 000011, Test ID 15", 330, 333 },
  { "Edge code 12 = 001100, Test ID 16", 333, 336 },
  { "Edge code 36 = 001001, Test ID 17", 336, 339 },
  { "Edge code 40 = 000101, Test ID 18", 339, 342 },
  { "Edge code 33 = 100001, Test ID 19", 342, 346 },
  { "Edge code 10 = 010100, Test ID 20", 346, 350 },
  { "Edge code 20 = 001010, Test ID 21", 350, 354 },
  { "Edge code 13 = 101100, Test ID 22", 354, 358 },
  { "Edge code 19 = 110010, Test ID 23", 358, 362 },
  { "Edge code 38 = 011001, Test ID 24", 362, 366 },
  { "Edge code 56 = 000111, Test ID 25", 366, 370 },
  { "Edge code 25 = 100110, Test ID 26", 370, 374 },
  { "Edge code 50 = 010011, Test ID 27", 374, 378 },
  { "Edge code 44 = 001101, Test ID 28", 378, 382 },
  { "Edge code 7 = 111000, Test ID 29", 382, 386 },
  { "Edge code 21 = 101010, Test ID 30", 386, 391 },
  { "Edge code 11 = 110100, Test ID 31", 391, 396 },
  { "Edge code 35 = 110001, Test ID 32", 396, 401 },
  { "Edge code 22 = 011010, Test ID 33", 401, 406 },
  { "Edge code 37 = 101001, Test ID 34", 406, 411 },
  { "Edge code 14 = 011100, Test ID 35", 411, 416 },
  { "Edge code 49 = 100011, Test ID 36", 416, 421 },
  { "Edge code 26 = 010110, Test ID 37", 421, 426 },
  { "Edge code 52 = 001011, Test ID 38", 426, 431 },
  { "Edge code 42 = 010101, Test ID 39", 431, 436 },
  { "Edge code 28 = 001110, Test ID 40", 436, 441 },
  { "Edge code 41 = 100101, Test ID 41", 441, 446 },
  { "Edge code 58 = 010111, Test ID 42", 446, 452 },
  { "Edge code 54 = 011011, Test ID 43", 452, 458 },
  { "Edge code 51 = 110011, Test ID 44", 458, 464 },
  { "Edge code 60 = 001111, Test ID 45", 464, 470 },
  { "Edge code 46 = 011101, Test ID 46", 470, 476 },
  { "Edge code 45 = 101101, Test ID 47", 476, 482 },
  { "Edge code 57 = 100111, Test ID 48", 482, 488 },
  { "Edge code 27 = 110110, Test ID 49", 488, 494 },
  { "Edge code 29 = 101110, Test ID 50", 494, 500 },
  { "Edge code 39 = 111001, Test ID 51", 500, 506 },
  { "Edge code 23 = 111010, Test ID 52", 506, 512 },
  { "Edge code 15 = 111100, Test ID 53", 512, 518 },
  { "Edge code 30 = 011110, Test ID 54", 518, 524 },
  { "Edge code 53 = 101011, Test ID 55", 524, 530 },
  { "Edge code 43 = 110101, Test ID 56", 530, 536 },
  { "Edge code 62 = 011111, Test ID 57", 536, 543 },
  { "Edge code 61 = 101111, Test ID 58", 543, 550 },
  { "Edge code 59 = 110111, Test ID 59", 550, 557 },
  { "Edge code 55 = 111011, Test ID 60", 557, 564 },
  { "Edge code 47 = 111101, Test ID 61", 564, 571 },
  { "Edge code 31 = 111110, Test ID 62", 571, 578 },
  { "Edge code 63 = 111111, Test ID 63", 578, 586 },
  { "Edge code 0 = 000000, Test ID 0", 586, 587 },
  { "Edge code 1 = 100000, Test ID 1", 587, 589 },
  { "Edge code 2 = 010000, Test ID 2", 589, 591 },
  { "Edge code 4 = 001000, Test ID 3", 591, 593 },
  { "Edge code 8 = 000100, Test ID 4", 593, 595 },
  { "Edge code 16 = 000010, Test ID 5", 595, 597 },
  { "Edge code 32 = 000001, Test ID 6", 597, 599 },
  { "Edge code 3 = 110000, Test ID 7", 599, 602 },
  { "Edge code 5 = 101000, Test ID 8", 602, 605 },
  { "Edge code 6 = 011000, Test ID 9", 605, 608 },
  { "Edge code 9 = 100100, Test ID 10", 608, 611 },
  { "Edge code 17 = 100010, Test ID 11", 611, 614 },
  { "Edge code 24 = 000110, Test ID 12", 614, 617 },
  { "Edge code 18 = 010010, Test ID 13", 617, 620 },
  { "Edge code 34 = 010001, Test ID 14", 620, 623 },
  { "Edge code 48 = 000011, Test ID 15", 623, 626 },
  { "Edge code 12 = 001100, Test ID 16", 626, 629 },
  { "Edge code 36 = 001001, Test ID 17", 629, 632 },
  { "Edge code 40 = 000101, Test ID 18", 632, 635 },
  { "Edge code 33 = 100001, Test ID 19", 635, 639 },
  { "Edge code 10 = 010100, Test ID 20", 639, 643 },
  { "Edge code 20 = 001010, Test ID 21", 643, 647 },
  { "Edge code 13 = 101100, Test ID 22", 647, 651 },
  { "Edge code 19 = 110010, Test ID 23", 651, 655 },
  { "Edge code 38 = 011001, Test ID 24", 655, 659 },
  { "Edge code 56 = 000111, Test ID 25", 659, 663 },
  { "Edge code 25 = 100110, Test ID 26", 663, 667 },
  { "Edge code 50 = 010011, Test ID 27", 667, 671 },
  { "Edge code 44 = 001101, Test ID 28", 671, 675 },
  { "Edge code 7 = 111000, Test ID 29", 675, 679 },
  { "Edge code 21 = 101010, Test ID 30", 679, 684 },
  { "Edge code 11 = 110100, Test ID 31", 684, 689 },
  { "Edge code 35 = 110001, Test ID 32", 689, 694 },
  { "Edge code 22 = 011010, Test ID 33", 694, 699 },
  { "Edge code 37 = 101001, Test ID 34", 699, 704 },
  { "Edge code 14 = 011100, Test ID 35", 704, 709 },
  { "Edge code 49 = 100011, Test ID 36", 709, 714 },
  { "Edge code 26 = 010110, Test ID 37", 714, 719 },
  { "Edge code 52 = 001011, Test ID 38", 719, 724 },
  { "Edge code 42 = 010101, Test ID 39", 724, 729 },
  { "Edge code 28 = 001110, Test ID 40", 729, 734 },
  { "Edge code 41 = 100101, Test ID 41", 734, 739 },
  { "Edge code 58 = 010111, Test ID 42", 739, 745 },
  { "Edge code 54 = 011011, Test ID 43", 745, 751 },
  { "Edge code 51 = 110011, Test ID 44", 751, 757 },
  { "Edge code 60 = 001111, Test ID 45", 757, 763 },
  { "Edge code 46 = 011101, Test ID 46", 763, 769 },
  { "Edge code 45 = 101101, Test ID 47", 769, 775 },
  { "Edge code 57 = 100111, Test ID 48", 775, 781 },
  { "Edge code 27 = 110110, Test ID 49", 781, 787 },
  { "Edge code 29 = 101110, Test ID 50", 787, 793 },
  { "Edge code 39 = 111001, Test ID 51", 793, 799 },
  { "Edge code 23 = 111010, Test ID 52", 799, 805 },
  { "Edge code 15 = 111100, Test ID 53", 805, 811 },
  { "Edge code 30 = 011110, Test ID 54", 811, 817 },
  { "Edge code 53 = 101011, Test ID 55", 817, 823 },
  { "Edge code 43 = 110101, Test ID 56", 823, 829 },
  { "Edge code 62 = 011111, Test ID 57", 829, 836 },
  { "Edge code 61 = 101111, Test ID 58", 836, 843 },
  { "Edge code 59 = 110111, Test ID 59", 843, 850 },
  { "Edge code 55 = 111011, Test ID 60", 850, 857 },
  { "Edge code 47 = 111101, Test ID 61", 857, 864 },
  { "Edge code 31 = 111110, Test ID 62", 864, 871 },
  { "Edge code 63 = 111111, Test ID 63", 871, 879 },
  { "Edge code 0 = 000000, Test ID 0", 879, 880 },
  { "Edge code 1 = 100000, Test ID 1", 880, 882 },
  { "Edge code 2 = 010000, Test ID 2", 882, 884 },
  { "Edge code 4 = 001000, Test ID 3", 884, 886 },
  { "Edge code 8 = 000100, Test ID 4", 886, 888 },
  { "Edge code 16 = 000010, Test ID 5", 888, 890 },
  { "Edge code 32 = 000001, Test ID 6", 890, 892 },
  { "Edge code 3 = 110000, Test ID 7", 892, 895 },
  { "Edge code 5 = 101000, Test ID 8", 895, 898 },
  { "Edge code 6 = 011000, Test ID 9", 898, 901 },
  { "Edge code 9 = 100100, Test ID 10", 901, 904 },
  { "Edge code 17 = 100010, Test ID 11", 904, 907 },
  { "Edge code 24 = 000110, Test ID 12", 907, 910 },
  { "Edge code 18 = 010010, Test ID 13", 910, 913 },
  { "Edge code 34 = 010001, Test ID 14", 913, 916 },
  { "Edge code 48 = 000011, Test ID 15", 916, 919 },
  { "Edge code 12 = 001100, Test ID 16", 919, 922 },
  { "Edge code 36 = 001001, Test ID 17", 922, 925 },
  { "Edge code 40 = 000101, Test ID 18", 925, 928 },
  { "Edge code 33 = 100001, Test ID 19", 928, 932 },
  { "Edge code 10 = 010100, Test ID 20", 932, 936 },
  { "Edge code 20 = 001010, Test ID 21", 936, 940 },
  { "Edge code 13 = 101100, Test ID 22", 940, 944 },
  { "Edge code 19 = 110010, Test ID 23", 944, 948 },
  { "Edge code 38 = 011001, Test ID 24", 948, 952 },
  { "Edge code 56 = 000111, Test ID 25", 952, 956 },
  { "Edge code 25 = 100110, Test ID 26", 956, 960 },
  { "Edge code 50 = 010011, Test ID 27", 960, 964 },
  { "Edge code 44 = 001101, Test ID 28", 964, 968 },
  { "Edge code 7 = 111000, Test ID 29", 968, 972 },
  { "Edge code 21 = 101010, Test ID 30", 972, 977 },
  { "Edge code 11 = 110100, Test ID 31", 977, 982 },
  { "Edge code 35 = 110001, Test ID 32", 982, 987 },
  { "Edge code 22 = 011010, Test ID 33", 987, 992 },
  { "Edge code 37 = 101001, Test ID 34", 992, 997 },
  { "Edge code 14 = 011100, Test ID 35", 997, 1002 },
  { "Edge code 49 = 100011, Test ID 36", 1002, 1007 },
  { "Edge code 26 = 010110, Test ID 37", 1007, 1012 },
  { "Edge code 52 = 001011, Test ID 38", 1012, 1017 },
  { "Edge code 42 = 010101, Test ID 39", 1017, 1022 },
  { "Edge code 28 = 001110, Test ID 40", 1022, 1027 },
  { "Edge code 41 = 100101, Test ID 41", 1027, 1032 },
  { "Edge code 58 = 010111, Test ID 42", 1032, 1038 },
  { "Edge code 54 = 011011, Test ID 43", 1038, 1044 },
  { "Edge code 51 = 110011, Test ID 44", 1044, 1050 },
  { "Edge code 60 = 001111, Test ID 45", 1050, 1056 },
  { "Edge code 46 = 011101, Test ID 46", 1056, 1062 },
  { "Edge code 45 = 101101, Test ID 47", 1062, 1068 },
  { "Edge code 57 = 100111, Test ID 48", 1068, 1074 },
  { "Edge code 27 = 110110, Test ID 49", 1074, 1080 },
  { "Edge code 29 = 101110, Test ID 50", 1080, 1086 },
  { "Edge code 39 = 111001, Test ID 51", 1086, 1092 },
  { "Edge code 23 = 111010, Test ID 52", 1092, 1098 },
  { "Edge code 15 = 111100, Test ID 53", 1098, 1104 },
  { "Edge code 30 = 011110, Test ID 54", 1104, 1110 },
  { "Edge code 53 = 101011, Test ID 55", 1110, 1116 },
  { "Edge code 43 = 110101, Test ID 56", 1116, 1122 },
  { "Edge code 62 = 011111, Test ID 57", 1122, 1129 },
  { "Edge code 61 = 101111, Test ID 58", 1129, 1136 },
  { "Edge code 59 = 110111, Test ID 59", 1136, 1143 },
  { "Edge code 55 = 111011, Test ID 60", 1143, 1150 },
  { "Edge code 47 = 111101, Test ID 61", 1150, 1157 },
  { "Edge code 31 = 111110, Test ID 62", 1157, 1164 },
  { "Edge code 63 = 111111, Test ID 63", 1164, 1172 },
  { "Edge code 0 = 000000, Test ID 0", 1172, 1173 },
  { "Edge code 1 = 100000, Test ID 1", 1173, 1175 },
  { "Edge code 2 = 010000, Test ID 2", 1175, 1177 },
  { "Edge code 4 = 001000, Test ID 3", 1177, 1179 },
  { "Edge code 8 = 000100, Test ID 4", 1179, 1181 },
  { "Edge code 16 = 000010, Test ID 5", 1181, 1183 },
  { "Edge code 32 = 000001, Test ID 6", 1183, 1185 },
  { "Edge code 3 = 110000, Test ID 7", 1185, 1188 },
  { "Edge code 5 = 101000, Test ID 8", 1188, 1191 },
  { "Edge code 6 = 011000, Test ID 9", 1191, 1194 },
  { "Edge code 9 = 100100, Test ID 10", 1194, 1197 },
  { "Edge code 17 = 100010, Test ID 11", 1197, 1200 },
  { "Edge code 24 = 000110, Test ID 12", 1200, 1203 },
  { "Edge code 18 = 010010, Test ID 13", 1203, 1206 },
  { "Edge code 34 = 010001, Test ID 14", 1206, 1209 },
  { "Edge code 48 = 000011, Test ID 15", 1209, 1212 },
  { "Edge code 12 = 001100, Test ID 16", 1212, 1215 },
  { "Edge code 36 = 001001, Test ID 17", 1215, 1218 },
  { "Edge code 40 = 000101, Test ID 18", 1218, 1221 },
  { "Edge code 33 = 100001, Test ID 19", 1221, 1225 },
  { "Edge code 10 = 010100, Test ID 20", 1225, 1229 },
  { "Edge code 20 = 001010, Test ID 21", 1229, 1233 },
  { "Edge code 13 = 101100, Test ID 22", 1233, 1237 },
  { "Edge code 19 = 110010, Test ID 23", 1237, 1241 },
  { "Edge code 38 = 011001, Test ID 24", 1241, 1245 },
  { "Edge code 56 = 000111, Test ID 25", 1245, 1249 },
  { "Edge code 25 = 100110, Test ID 26", 1249, 1253 },
  { "Edge code 50 = 010011, Test ID 27", 1253, 1257 },
  { "Edge code 44 = 001101, Test ID 28", 1257, 1261 },
  { "Edge code 7 = 111000, Test ID 29", 1261, 1265 },
  { "Edge code 21 = 101010, Test ID 30", 1265, 1270 },
  { "Edge code 11 = 110100, Test ID 31", 1270, 1275 },
  { "Edge code 35 = 110001, Test ID 32", 1275, 1280 },
  { "Edge code 22 = 011010, Test ID 33", 1280, 1285 },
  { "Edge code 37 = 101001, Test ID 34", 1285, 1290 },
  { "Edge code 14 = 011100, Test ID 35", 1290, 1295 },
  { "Edge code 49 = 100011, Test ID 36", 1295, 1300 },
  { "Edge code 26 = 010110, Test ID 37", 1300, 1305 },
  { "Edge code 52 = 001011, Test ID 38", 1305, 1310 },
  { "Edge code 42 = 010101, Test ID 39", 1310, 1315 },
  { "Edge code 28 = 001110, Test ID 40", 1315, 1320 },
  { "Edge code 41 = 100101, Test ID 41", 1320, 1325 },
  { "Edge code 58 = 010111, Test ID 42", 1325, 1331 },
  { "Edge code 54 = 011011, Test ID 43", 1331, 1337 },
  { "Edge code 51 = 110011, Test ID 44", 1337, 1343 },
  { "Edge code 60 = 001111, Test ID 45", 1343, 1349 },
  { "Edge code 46 = 011101, Test ID 46", 1349, 1355 },
  { "Edge code 45 = 101101, Test ID 47", 1355, 1361 },
  { "Edge code 57 = 100111, Test ID 48", 1361, 1367 },
  { "Edge code 27 = 110110, Test ID 49", 1367, 1373 },
  { "Edge code 29 = 101110, Test ID 50", 1373, 1379 },
  { "Edge code 39 = 111001, Test ID 51", 1379, 1385 },
  { "Edge code 23 = 111010, Test ID 52", 1385, 1391 },
  { "Edge code 15 = 111100, Test ID 53", 1391, 1397 },
  { "Edge code 30 = 011110, Test ID 54", 1397, 1403 },
  { "Edge code 53 = 101011, Test ID 55", 1403, 1409 },
  { "Edge code 43 = 110101, Test ID 56", 1409, 1415 },
  { "Edge code 62 = 011111, Test ID 57", 1415, 1422 },
  { "Edge code 61 = 101111, Test ID 58", 1422, 1429 },
  { "Edge code 59 = 110111, Test ID 59", 1429, 1436 },
  { "Edge code 55 = 111011, Test ID 60", 1436, 1443 },
  { "Edge code 47 = 111101, Test ID 61", 1443, 1450 },
  { "Edge code 31 = 111110, Test ID 62", 1450, 1457 },
  { "Edge code 63 = 111111, Test ID 63", 1457, 1465 },
  { "Edge code 0 = 000000, Test ID 0", 1465, 1466 },
  { "Edge code 1 = 100000, Test ID 1", 1466, 1468 },
  { "Edge code 2 = 010000, Test ID 2", 1468, 1470 },
  { "Edge code 4 = 001000, Test ID 3", 1470, 1472 },
  { "Edge code 8 = 000100, Test ID 4", 1472, 1474 },
  { "Edge code 16 = 000010, Test ID 5", 1474, 1476 },
  { "Edge code 32 = 000001, Test ID 6", 1476, 1478 },
  { "Edge code 3 = 110000, Test ID 7", 1478, 1481 },
  { "Edge code 5 = 101000, Test ID 8", 1481, 1484 },
  { "Edge code 6 = 011000, Test ID 9", 1484, 1487 },
  { "Edge code 9 = 100100, Test ID 10", 1487, 1490 },
  { "Edge code 17 = 100010, Test ID 11", 1490, 1493 },
  { "Edge code 24 = 000110, Test ID 12", 1493, 1496 },
  { "Edge code 18 = 010010, Test ID 13", 1496, 1499 },
  { "Edge code 34 = 010001, Test ID 14", 1499, 1502 },
  { "Edge code 48 = 000011, Test ID 15", 1502, 1505 },
  { "Edge code 12 = 001100, Test ID 16", 1505, 1508 },
  { "Edge code 36 = 001001, Test ID 17", 1508, 1511 },
  { "Edge code 40 = 000101, Test ID 18", 1511, 1514 },
  { "Edge code 33 = 100001, Test ID 19", 1514, 1518 },
  { "Edge code 10 = 010100, Test ID 20", 1518, 1522 },
  { "Edge code 20 = 001010, Test ID 21", 1522, 1526 },
  { "Edge code 13 = 101100, Test ID 22", 1526, 1530 },
  { "Edge code 19 = 110010, Test ID 23", 1530, 1534 },
  { "Edge code 38 = 011001, Test ID 24", 1534, 1538 },
  { "Edge code 56 = 000111, Test ID 25", 1538, 1542 },
  { "Edge code 25 = 100110, Test ID 26", 1542, 1546 },
  { "Edge code 50 = 010011, Test ID 27", 1546, 1550 },
  { "Edge code 44 = 001101, Test ID 28", 1550, 1554 },
  { "Edge code 7 = 111000, Test ID 29", 1554, 1558 },
  { "Edge code 21 = 101010, Test ID 30", 1558, 1563 },
  { "Edge code 11 = 110100, Test ID 31", 1563, 1568 },
  { "Edge code 35 = 110001, Test ID 32", 1568, 1573 },
  { "Edge code 22 = 011010, Test ID 33", 1573, 1578 },
  { "Edge code 37 = 101001, Test ID 34", 1578, 1583 },
  { "Edge code 14 = 011100, Test ID 35", 1583, 1588 },
  { "Edge code 49 = 100011, Test ID 36", 1588, 1593 },
  { "Edge code 26 = 010110, Test ID 37", 1593, 1598 },
  { "Edge code 52 = 001011, Test ID 38", 1598, 1603 },
  { "Edge code 42 = 010101, Test ID 39", 1603, 1608 },
  { "Edge code 28 = 001110, Test ID 40", 1608, 1613 },
  { "Edge code 41 = 100101, Test ID 41", 1613, 1618 },
  { "Edge code 58 = 010111, Test ID 42", 1618, 1624 },
  { "Edge code 54 = 011011, Test ID 43", 1624, 1630 },
  { "Edge code 51 = 110011, Test ID 44", 1630, 1636 },
  { "Edge code 60 = 001111, Test ID 45", 1636, 1642 },
  { "Edge code 46 = 011101, Test ID 46", 1642, 1648 },
  { "Edge code 45 = 101101, Test ID 47", 1648, 1654 },
  { "Edge code 57 = 100111, Test ID 48", 1654, 1660 },
  { "Edge code 27 = 110110, Test ID 49", 1660, 1666 },
  { "Edge code 29 = 101110, Test ID 50", 1666, 1672 },
  { "Edge code 39 = 111001, Test ID 51", 1672, 1678 },
  { "Edge code 23 = 111010, Test ID 52", 1678, 1684 },
  { "Edge code 15 = 111100, Test ID 53", 1684, 1690 },
  { "Edge code 30 = 011110, Test ID 54", 1690, 1696 },
  { "Edge code 53 = 101011, Test ID 55", 1696, 1702 },
  { "Edge code 43 = 110101, Test ID 56", 1702, 1708 },
  { "Edge code 62 = 011111, Test ID 57", 1708, 1715 },
  { "Edge code 61 = 101111, Test ID 58", 1715, 1722 },
  { "Edge code 59 = 110111, Test ID 59", 1722, 1729 },
  { "Edge code 55 = 111011, Test ID 60", 1729, 1736 },
  { "Edge code 47 = 111101, Test ID 61", 1736, 1743 },
  { "Edge code 31 = 111110, Test ID 62", 1743, 1750 },
  { "Edge code 63 = 111111, Test ID 63", 1750, 1758 },
  { "Edge code 3 = 110000, Test ID 0*", 1758, 1763 },
  { "Edge code 13 = 101100, Test ID 1*", 1763, 1769 },
  { "Edge code 13 = 101100, Test ID 2*", 1769, 1775 },
  { "Edge code 13 = 101100, Test ID 3*", 1775, 1787 },
  { "Edge code 11 = 110100, Test ID 4*", 1787, 1794 },
  { "Edge code 11 = 110100, Test ID 5*", 1794, 1801 },
  { "Edge code 11 = 110100, Test ID 6*", 1801, 1811 },
  { "Edge code 21 = 101010, Test ID 7*", 1811, 1818 },
  { "Edge code 21 = 101010, Test ID 8*", 1818, 1825 },
  { "Edge code 21 = 101010, Test ID 9*", 1825, 1835 },
  { "Edge code 60 = 001111, Test ID 10*", 1835, 1843 },
  { "Edge code 60 = 001111, Test ID 11*", 1843, 1851 },
  { "Edge code 60 = 001111, Test ID 12*", 1851, 1861 },
  { "Edge code 30 = 011110, Test ID 13*", 1861, 1870 },
  { "Edge code 30 = 011110, Test ID 14*", 1870, 1879 },
  { "Edge code 30 = 011110, Test ID 15*", 1879, 1888 },
  { "Edge code 30 = 011110, Test ID 16*", 1888, 1899 },
  { "Edge code 30 = 011110, Test ID 17*", 1899, 1911 },
  { "Edge code 30 = 011110, Test ID 18*", 1911, 1923 },
  { "Edge code 30 = 011110, Test ID 19*", 1923, 1939 },
  { "Edge code 62 = 011111, Test ID 20*", 1939, 1949 },
  { "Edge code 62 = 011111, Test ID 21*", 1949, 1961 }
};

static double vtkITetList[][4][3] = {
  { { 0, 0, 0 }, { 1, 0, 0.1 }, { 0, 2, 0 }, { 0.2, 0.1, 3 } },
  { { 0, 0, 0 }, { 2, 0, 0 }, { 0.1, 3, 0.2 }, { 0, 0.1, 1 } },
  { { 0, 0, 0 }, { 3, 0.2, 0.1 }, { 0.1, 1, 0 }, { 0, 0, 2 } },
  { { 0, 0, 0 }, { 1, 0.1, 0 }, { 0.2, 3, 0.1 }, { 0, 0, 2 } },
  { { 0, 0, 0 }, { 3, 0.1, 0.2 }, { 0, 2, 0 }, { 0.1, 0, 1 } },
  { { 0, 0, 0 }, { 2, 0, 0 }, { 0, 1, 0.1 }, { 0.1, 0.2, 3 } },
  { { 0, 4, -3 }, { 0, 0, 0 }, { 0, 4, 3 }, { -3, 4, 0 } },
  { { 0, 0, 0 }, { 4, -3, 0 }, { 4, 3, 0 }, { 3, 0, 3 } },
  { { 0, 0, 0 }, { 4, -3, 0 }, { 4, 3, 0 }, { 3, 0, 5 } },
  { { 0, 0, 0 }, { 4, -3, 0 }, { 4, 3, 0 }, { 3, 0, 4 } },
  { { 0, 4, -3 }, { 0, 0, 0 }, { 0, 4, 3 }, { -3, 4, 0 } },
  { { 0, 4, -3 }, { 0, 0, 0 }, { 0, 4, 3 }, { -4, 3, 0 } },
  { { 0, 4, -3 }, { 0, 0, 0 }, { 0, 4, 3 }, { -4, 4, 0 } },
  { { 0, 4, -3 }, { 0, 0, 0 }, { 3, 4, 0 }, { 0, 4, 3 } },
  { { 0, 4, -3 }, { 0, 0, 0 }, { 4, 3, 0 }, { 0, 4, 3 } },
  { { 0, 4, -3 }, { 0, 0, 0 }, { 4, 4, 0 }, { 0, 4, 3 } },
  { { 0, 4, -3 }, { 0, 4, 3 }, { -3, 3, 0 }, { 0, 0, 0 } },
  { { 0, 4, -3 }, { 0, 4, 3 }, { -3, 5, 0 }, { 0, 0, 0 } },
  { { 0, 4, -3 }, { 0, 4, 3 }, { -3, 4, 0 }, { 0, 0, 0 } },
  { { 3, 4, 0 }, { -3, 4, 0 }, { 0, 0, 0 }, { -1, 1, 12 } },
  { { 3, 4, 0 }, { -3, 4, 0 }, { 0, 0, 0 }, { 1, 2, 2 } },
  { { 3, 4, 0 }, { -3, 4, 0 }, { 0, 0, 0 }, { 1, 3, 4 } },
  { { 3, 4, 0 }, { -3, 4, 0 }, { 0, 0, 0 }, { 0, 0, 12 } },
  { { 3, 4, 0 }, { -3, 4, 0 }, { 0, 0, 0 }, { 3, 1, 4 } },
  { { 3, 4, 0 }, { -3, 4, 0 }, { 0, 0, 0 }, { -1, 4, 3 } },
  { { 3, 4, 0 }, { -3, 4, 0 }, { 0, 0, 0 }, { 0, 4, 4 } },
  { { 3, 4, 0 }, { -3, 4, 0 }, { 0, 0, 0 }, { -1, 1, 12 } },
  { { 3, 4, 0 }, { -3, 4, 0 }, { 0, 0, 0 }, { 0, 0, 12 } }
};

static double vtkOTetList[][4][3] = {
  { { 0, 0, 0 }, { 1, 0, 0.1 }, { 0, 2, 0 }, { 0.2, 0.1, 3 } },
  { { 0, 0, 0 }, { 0.5, 0, 0.05 }, { 0, 2, 0 }, { 0.2, 0.1, 3 } },
  { { 0.5, 0, 0.05 }, { 1, 0, 0.1 }, { 0, 2, 0 }, { 0.2, 0.1, 3 } },
  { { 1, 0, 0.1 }, { 0.5, 1, 0.05 }, { 0, 0, 0 }, { 0.2, 0.1, 3 } },
  { { 0.5, 1, 0.05 }, { 0, 2, 0 }, { 0, 0, 0 }, { 0.2, 0.1, 3 } },
  { { 0, 2, 0 }, { 0, 1, 0 }, { 1, 0, 0.1 }, { 0.2, 0.1, 3 } },
  { { 0, 1, 0 }, { 0, 0, 0 }, { 1, 0, 0.1 }, { 0.2, 0.1, 3 } },
  { { 0.2, 0.1, 3 }, { 0.1, 0.05, 1.5 }, { 0, 2, 0 }, { 1, 0, 0.1 } },
  { { 0.1, 0.05, 1.5 }, { 0, 0, 0 }, { 0, 2, 0 }, { 1, 0, 0.1 } },
  { { 1, 0, 0.1 }, { 0.6, 0.05, 1.55 }, { 0, 2, 0 }, { 0, 0, 0 } },
  { { 0.6, 0.05, 1.55 }, { 0.2, 0.1, 3 }, { 0, 2, 0 }, { 0, 0, 0 } },
  { { 0.2, 0.1, 3 }, { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 }, { 0, 0, 0 } },
  { { 0.1, 1.05, 1.5 }, { 0, 2, 0 }, { 1, 0, 0.1 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0.5, 0, 0.05 }, { 0.5, 1, 0.05 }, { 0.2, 0.1, 3 } },
  { { 0, 0, 0 }, { 0.5, 1, 0.05 }, { 0, 2, 0 }, { 0.2, 0.1, 3 } },
  { { 0.2, 0.1, 3 }, { 0.5, 0, 0.05 }, { 0.5, 1, 0.05 }, { 1, 0, 0.1 } },
  { { 0, 2, 0 }, { 0, 1, 0 }, { 1, 0, 0.1 }, { 0.2, 0.1, 3 } },
  { { 0, 1, 0 }, { 0.5, 0, 0.05 }, { 1, 0, 0.1 }, { 0.2, 0.1, 3 } },
  { { 0.2, 0.1, 3 }, { 0, 1, 0 }, { 0.5, 0, 0.05 }, { 0, 0, 0 } },
  { { 1, 0, 0.1 }, { 0.5, 1, 0.05 }, { 0, 0, 0 }, { 0.2, 0.1, 3 } },
  { { 0.5, 1, 0.05 }, { 0, 1, 0 }, { 0, 0, 0 }, { 0.2, 0.1, 3 } },
  { { 0.2, 0.1, 3 }, { 0.5, 1, 0.05 }, { 0, 1, 0 }, { 0, 2, 0 } },
  { { 1, 0, 0.1 }, { 0.5, 0, 0.05 }, { 0.1, 0.05, 1.5 }, { 0, 2, 0 } },
  { { 1, 0, 0.1 }, { 0.1, 0.05, 1.5 }, { 0.2, 0.1, 3 }, { 0, 2, 0 } },
  { { 0, 2, 0 }, { 0.5, 0, 0.05 }, { 0.1, 0.05, 1.5 }, { 0, 0, 0 } },
  { { 0.2, 0.1, 3 }, { 0.6, 0.05, 1.55 }, { 0, 0, 0 }, { 0, 2, 0 } },
  { { 0.6, 0.05, 1.55 }, { 0.5, 0, 0.05 }, { 0, 0, 0 }, { 0, 2, 0 } },
  { { 0, 2, 0 }, { 0.6, 0.05, 1.55 }, { 0.5, 0, 0.05 }, { 1, 0, 0.1 } },
  { { 0, 0, 0 }, { 0.1, 0.05, 1.5 }, { 0.6, 0.05, 1.55 }, { 0, 2, 0 } },
  { { 0, 0, 0 }, { 0.6, 0.05, 1.55 }, { 1, 0, 0.1 }, { 0, 2, 0 } },
  { { 0, 2, 0 }, { 0.1, 0.05, 1.5 }, { 0.6, 0.05, 1.55 }, { 0.2, 0.1, 3 } },
  { { 0, 2, 0 }, { 0.5, 1, 0.05 }, { 0.6, 0.05, 1.55 }, { 0, 0, 0 } },
  { { 0, 2, 0 }, { 0.6, 0.05, 1.55 }, { 0.2, 0.1, 3 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0.5, 1, 0.05 }, { 0.6, 0.05, 1.55 }, { 1, 0, 0.1 } },
  { { 0.2, 0.1, 3 }, { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 }, { 0, 0, 0 } },
  { { 0.1, 1.05, 1.5 }, { 0.5, 1, 0.05 }, { 1, 0, 0.1 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0.1, 1.05, 1.5 }, { 0.5, 1, 0.05 }, { 0, 2, 0 } },
  { { 1, 0, 0.1 }, { 0.6, 0.05, 1.55 }, { 0.1, 1.05, 1.5 }, { 0, 0, 0 } },
  { { 1, 0, 0.1 }, { 0.1, 1.05, 1.5 }, { 0, 2, 0 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0.6, 0.05, 1.55 }, { 0.1, 1.05, 1.5 }, { 0.2, 0.1, 3 } },
  { { 0.2, 0.1, 3 }, { 0.1, 0.05, 1.5 }, { 0, 2, 0 }, { 1, 0, 0.1 } },
  { { 0.1, 0.05, 1.5 }, { 0, 1, 0 }, { 0, 2, 0 }, { 1, 0, 0.1 } },
  { { 1, 0, 0.1 }, { 0.1, 0.05, 1.5 }, { 0, 1, 0 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0, 1, 0 }, { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 } },
  { { 0, 0, 0 }, { 0.1, 1.05, 1.5 }, { 0.2, 0.1, 3 }, { 1, 0, 0.1 } },
  { { 1, 0, 0.1 }, { 0, 1, 0 }, { 0.1, 1.05, 1.5 }, { 0, 2, 0 } },
  { { 0, 2, 0 }, { 0.1, 1.05, 1.5 }, { 0, 0, 0 }, { 1, 0, 0.1 } },
  { { 0.1, 1.05, 1.5 }, { 0.1, 0.05, 1.5 }, { 0, 0, 0 }, { 1, 0, 0.1 } },
  { { 1, 0, 0.1 }, { 0.1, 1.05, 1.5 }, { 0.1, 0.05, 1.5 }, { 0.2, 0.1, 3 } },
  { { 0, 0, 0 }, { 0.5, 0, 0.05 }, { 0.1, 1.05, 1.5 }, { 0.2, 0.1, 3 } },
  { { 0.5, 0, 0.05 }, { 1, 0, 0.1 }, { 0.1, 1.05, 1.5 }, { 0.2, 0.1, 3 } },
  { { 0, 0, 0 }, { 0.5, 0, 0.05 }, { 0, 2, 0 }, { 0.1, 1.05, 1.5 } },
  { { 0.5, 0, 0.05 }, { 1, 0, 0.1 }, { 0, 2, 0 }, { 0.1, 1.05, 1.5 } },
  { { 1, 0, 0.1 }, { 0.5, 1, 0.05 }, { 0.1, 0.05, 1.5 }, { 0.2, 0.1, 3 } },
  { { 0.5, 1, 0.05 }, { 0, 2, 0 }, { 0.1, 0.05, 1.5 }, { 0.2, 0.1, 3 } },
  { { 1, 0, 0.1 }, { 0.5, 1, 0.05 }, { 0, 0, 0 }, { 0.1, 0.05, 1.5 } },
  { { 0.5, 1, 0.05 }, { 0, 2, 0 }, { 0, 0, 0 }, { 0.1, 0.05, 1.5 } },
  { { 0, 2, 0 }, { 0, 1, 0 }, { 0.6, 0.05, 1.55 }, { 0.2, 0.1, 3 } },
  { { 0, 1, 0 }, { 0, 0, 0 }, { 0.6, 0.05, 1.55 }, { 0.2, 0.1, 3 } },
  { { 0, 2, 0 }, { 0, 1, 0 }, { 1, 0, 0.1 }, { 0.6, 0.05, 1.55 } },
  { { 0, 1, 0 }, { 0, 0, 0 }, { 1, 0, 0.1 }, { 0.6, 0.05, 1.55 } },
  { { 1, 0, 0.1 }, { 0.2, 0.1, 3 }, { 0, 2, 0 }, { 0.1, 0.05, 1.5 } },
  { { 0, 1, 0 }, { 0.1, 0.05, 1.5 }, { 1, 0, 0.1 }, { 0, 2, 0 } },
  { { 0, 1, 0 }, { 0.1, 0.05, 1.5 }, { 0.5, 0, 0.05 }, { 1, 0, 0.1 } },
  { { 0.5, 0, 0.05 }, { 0.1, 0.05, 1.5 }, { 0, 1, 0 }, { 0, 0, 0 } },
  { { 0.2, 0.1, 3 }, { 0, 0, 0 }, { 0, 2, 0 }, { 0.6, 0.05, 1.55 } },
  { { 0.6, 0.05, 1.55 }, { 0.5, 1, 0.05 }, { 0, 0, 0 }, { 0, 2, 0 } },
  { { 0.6, 0.05, 1.55 }, { 0.5, 1, 0.05 }, { 0.5, 0, 0.05 }, { 0, 0, 0 } },
  { { 0.5, 1, 0.05 }, { 0.6, 0.05, 1.55 }, { 0.5, 0, 0.05 }, { 1, 0, 0.1 } },
  { { 0, 0, 0 }, { 0.2, 0.1, 3 }, { 1, 0, 0.1 }, { 0.1, 1.05, 1.5 } },
  { { 0.5, 1, 0.05 }, { 0.1, 1.05, 1.5 }, { 0, 0, 0 }, { 1, 0, 0.1 } },
  { { 0.5, 1, 0.05 }, { 0.1, 1.05, 1.5 }, { 0, 1, 0 }, { 0, 0, 0 } },
  { { 0, 1, 0 }, { 0.1, 1.05, 1.5 }, { 0.5, 1, 0.05 }, { 0, 2, 0 } },
  { { 0, 2, 0 }, { 0, 0, 0 }, { 1, 0, 0.1 }, { 0.1, 1.05, 1.5 } },
  { { 0.1, 1.05, 1.5 }, { 0.6, 0.05, 1.55 }, { 0, 0, 0 }, { 1, 0, 0.1 } },
  { { 0.1, 1.05, 1.5 }, { 0.6, 0.05, 1.55 }, { 0.1, 0.05, 1.5 }, { 0, 0, 0 } },
  { { 0.1, 0.05, 1.5 }, { 0.6, 0.05, 1.55 }, { 0.1, 1.05, 1.5 }, { 0.2, 0.1, 3 } },
  { { 0, 0, 0 }, { 0.1, 0.05, 1.5 }, { 0.5, 0, 0.05 }, { 0, 2, 0 } },
  { { 0.5, 0, 0.05 }, { 0.1, 0.05, 1.5 }, { 0.6, 0.05, 1.55 }, { 0, 2, 0 } },
  { { 0.5, 0, 0.05 }, { 0.6, 0.05, 1.55 }, { 1, 0, 0.1 }, { 0, 2, 0 } },
  { { 0.1, 0.05, 1.5 }, { 0.2, 0.1, 3 }, { 0.6, 0.05, 1.55 }, { 0, 2, 0 } },
  { { 1, 0, 0.1 }, { 0.6, 0.05, 1.55 }, { 0.5, 1, 0.05 }, { 0, 0, 0 } },
  { { 0.5, 1, 0.05 }, { 0.6, 0.05, 1.55 }, { 0.1, 1.05, 1.5 }, { 0, 0, 0 } },
  { { 0.5, 1, 0.05 }, { 0.1, 1.05, 1.5 }, { 0, 2, 0 }, { 0, 0, 0 } },
  { { 0.6, 0.05, 1.55 }, { 0.2, 0.1, 3 }, { 0.1, 1.05, 1.5 }, { 0, 0, 0 } },
  { { 0.2, 0.1, 3 }, { 0.1, 0.05, 1.5 }, { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 } },
  { { 0.1, 1.05, 1.5 }, { 0.1, 0.05, 1.5 }, { 0, 1, 0 }, { 1, 0, 0.1 } },
  { { 0.1, 1.05, 1.5 }, { 0, 1, 0 }, { 0, 2, 0 }, { 1, 0, 0.1 } },
  { { 0.1, 0.05, 1.5 }, { 0, 0, 0 }, { 0, 1, 0 }, { 1, 0, 0.1 } },
  { { 0, 0, 0 }, { 0.5, 0, 0.05 }, { 0, 1, 0 }, { 0.2, 0.1, 3 } },
  { { 0, 1, 0 }, { 0.5, 0, 0.05 }, { 0.5, 1, 0.05 }, { 0.2, 0.1, 3 } },
  { { 0, 1, 0 }, { 0.5, 1, 0.05 }, { 0, 2, 0 }, { 0.2, 0.1, 3 } },
  { { 0.5, 0, 0.05 }, { 1, 0, 0.1 }, { 0.5, 1, 0.05 }, { 0.2, 0.1, 3 } },
  { { 0.6, 0.05, 1.55 }, { 0, 0, 0 }, { 0, 1, 0 }, { 0.5, 0, 0.05 } },
  { { 0.6, 0.05, 1.55 }, { 0, 0, 0 }, { 0.2, 0.1, 3 }, { 0, 1, 0 } },
  { { 0, 1, 0 }, { 1, 0, 0.1 }, { 0.6, 0.05, 1.55 }, { 0.5, 0, 0.05 } },
  { { 0, 1, 0 }, { 1, 0, 0.1 }, { 0, 2, 0 }, { 0.6, 0.05, 1.55 } },
  { { 0, 2, 0 }, { 0.2, 0.1, 3 }, { 0, 1, 0 }, { 0.6, 0.05, 1.55 } },
  { { 0, 0, 0 }, { 0.5, 1, 0.05 }, { 0, 2, 0 }, { 0.1, 0.05, 1.5 } },
  { { 0, 0, 0 }, { 0.5, 1, 0.05 }, { 0.1, 0.05, 1.5 }, { 0.5, 0, 0.05 } },
  { { 0.1, 0.05, 1.5 }, { 1, 0, 0.1 }, { 0.5, 0, 0.05 }, { 0.5, 1, 0.05 } },
  { { 0.1, 0.05, 1.5 }, { 1, 0, 0.1 }, { 0.5, 1, 0.05 }, { 0.2, 0.1, 3 } },
  { { 0.2, 0.1, 3 }, { 0.5, 1, 0.05 }, { 0.1, 0.05, 1.5 }, { 0, 2, 0 } },
  { { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 }, { 0.5, 0, 0.05 }, { 0.5, 1, 0.05 } },
  { { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 }, { 0.2, 0.1, 3 }, { 0.5, 0, 0.05 } },
  { { 0.5, 1, 0.05 }, { 0, 0, 0 }, { 0.1, 1.05, 1.5 }, { 0, 2, 0 } },
  { { 0.5, 1, 0.05 }, { 0, 0, 0 }, { 0.5, 0, 0.05 }, { 0.1, 1.05, 1.5 } },
  { { 0, 0, 0 }, { 0.2, 0.1, 3 }, { 0.5, 0, 0.05 }, { 0.1, 1.05, 1.5 } },
  { { 0.5, 1, 0.05 }, { 0, 0, 0 }, { 0.6, 0.05, 1.55 }, { 0, 1, 0 } },
  { { 0.5, 1, 0.05 }, { 0, 0, 0 }, { 1, 0, 0.1 }, { 0.6, 0.05, 1.55 } },
  { { 0.6, 0.05, 1.55 }, { 0, 2, 0 }, { 0.5, 1, 0.05 }, { 0, 1, 0 } },
  { { 0.6, 0.05, 1.55 }, { 0, 2, 0 }, { 0, 1, 0 }, { 0.2, 0.1, 3 } },
  { { 0.2, 0.1, 3 }, { 0, 1, 0 }, { 0.6, 0.05, 1.55 }, { 0, 0, 0 } },
  { { 0, 1, 0 }, { 1, 0, 0.1 }, { 0.1, 1.05, 1.5 }, { 0.5, 0, 0.05 } },
  { { 0, 1, 0 }, { 1, 0, 0.1 }, { 0, 2, 0 }, { 0.1, 1.05, 1.5 } },
  { { 0.1, 1.05, 1.5 }, { 0, 0, 0 }, { 0, 1, 0 }, { 0.5, 0, 0.05 } },
  { { 0.1, 1.05, 1.5 }, { 0, 0, 0 }, { 0.5, 0, 0.05 }, { 0.2, 0.1, 3 } },
  { { 0.2, 0.1, 3 }, { 0.5, 0, 0.05 }, { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 } },
  { { 0.1, 0.05, 1.5 }, { 0, 2, 0 }, { 0.5, 1, 0.05 }, { 0, 1, 0 } },
  { { 0.1, 0.05, 1.5 }, { 0, 2, 0 }, { 0.2, 0.1, 3 }, { 0.5, 1, 0.05 } },
  { { 0.5, 1, 0.05 }, { 0, 0, 0 }, { 0.1, 0.05, 1.5 }, { 0, 1, 0 } },
  { { 0.5, 1, 0.05 }, { 0, 0, 0 }, { 1, 0, 0.1 }, { 0.1, 0.05, 1.5 } },
  { { 1, 0, 0.1 }, { 0.2, 0.1, 3 }, { 0.5, 1, 0.05 }, { 0.1, 0.05, 1.5 } },
  { { 0.6, 0.05, 1.55 }, { 0, 0, 0 }, { 0.1, 1.05, 1.5 }, { 0.5, 0, 0.05 } },
  { { 0.6, 0.05, 1.55 }, { 0, 0, 0 }, { 0.2, 0.1, 3 }, { 0.1, 1.05, 1.5 } },
  { { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 }, { 0.6, 0.05, 1.55 }, { 0.5, 0, 0.05 } },
  { { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 }, { 0.5, 0, 0.05 }, { 0, 2, 0 } },
  { { 0, 2, 0 }, { 0.5, 0, 0.05 }, { 0.1, 1.05, 1.5 }, { 0, 0, 0 } },
  { { 0.6, 0.05, 1.55 }, { 0, 2, 0 }, { 0.1, 0.05, 1.5 }, { 0.2, 0.1, 3 } },
  { { 0.6, 0.05, 1.55 }, { 0, 2, 0 }, { 0.5, 1, 0.05 }, { 0.1, 0.05, 1.5 } },
  { { 0.6, 0.05, 1.55 }, { 0, 0, 0 }, { 0.5, 1, 0.05 }, { 1, 0, 0.1 } },
  { { 0.6, 0.05, 1.55 }, { 0, 0, 0 }, { 0.1, 0.05, 1.5 }, { 0.5, 1, 0.05 } },
  { { 0, 0, 0 }, { 0, 2, 0 }, { 0.1, 0.05, 1.5 }, { 0.5, 1, 0.05 } },
  { { 0.1, 1.05, 1.5 }, { 0, 0, 0 }, { 0.6, 0.05, 1.55 }, { 0.2, 0.1, 3 } },
  { { 0.1, 1.05, 1.5 }, { 0, 0, 0 }, { 0, 1, 0 }, { 0.6, 0.05, 1.55 } },
  { { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 }, { 0, 1, 0 }, { 0, 2, 0 } },
  { { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 }, { 0.6, 0.05, 1.55 }, { 0, 1, 0 } },
  { { 1, 0, 0.1 }, { 0, 0, 0 }, { 0.6, 0.05, 1.55 }, { 0, 1, 0 } },
  { { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 }, { 0.1, 0.05, 1.5 }, { 0.5, 1, 0.05 } },
  { { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 }, { 0.2, 0.1, 3 }, { 0.1, 0.05, 1.5 } },
  { { 0.1, 1.05, 1.5 }, { 0, 0, 0 }, { 0, 2, 0 }, { 0.5, 1, 0.05 } },
  { { 0.1, 1.05, 1.5 }, { 0, 0, 0 }, { 0.5, 1, 0.05 }, { 0.1, 0.05, 1.5 } },
  { { 0, 0, 0 }, { 0.5, 1, 0.05 }, { 0.1, 0.05, 1.5 }, { 1, 0, 0.1 } },
  { { 0.1, 0.05, 1.5 }, { 0, 2, 0 }, { 0.6, 0.05, 1.55 }, { 0, 1, 0 } },
  { { 0.1, 0.05, 1.5 }, { 0, 2, 0 }, { 0.2, 0.1, 3 }, { 0.6, 0.05, 1.55 } },
  { { 0.6, 0.05, 1.55 }, { 0, 0, 0 }, { 0.1, 0.05, 1.5 }, { 0, 1, 0 } },
  { { 0.6, 0.05, 1.55 }, { 0, 0, 0 }, { 0, 1, 0 }, { 1, 0, 0.1 } },
  { { 1, 0, 0.1 }, { 0, 1, 0 }, { 0.6, 0.05, 1.55 }, { 0, 2, 0 } },
  { { 0.1, 0.05, 1.5 }, { 1, 0, 0.1 }, { 0.1, 1.05, 1.5 }, { 0.2, 0.1, 3 } },
  { { 0.1, 0.05, 1.5 }, { 1, 0, 0.1 }, { 0.5, 0, 0.05 }, { 0.1, 1.05, 1.5 } },
  { { 0.1, 1.05, 1.5 }, { 0, 0, 0 }, { 0.5, 0, 0.05 }, { 0.1, 0.05, 1.5 } },
  { { 0.1, 1.05, 1.5 }, { 0, 0, 0 }, { 0, 2, 0 }, { 0.5, 0, 0.05 } },
  { { 0, 2, 0 }, { 1, 0, 0.1 }, { 0.1, 1.05, 1.5 }, { 0.5, 0, 0.05 } },
  { { 0.5, 1, 0.05 }, { 0.6, 0.05, 1.55 }, { 0.1, 0.05, 1.5 }, { 0, 0, 0 } },
  { { 0.5, 1, 0.05 }, { 0.6, 0.05, 1.55 }, { 0, 0, 0 }, { 1, 0, 0.1 } },
  { { 0.5, 1, 0.05 }, { 0.1, 1.05, 1.5 }, { 0, 2, 0 }, { 0, 0, 0 } },
  { { 0.5, 1, 0.05 }, { 0.1, 1.05, 1.5 }, { 0, 0, 0 }, { 0.1, 0.05, 1.5 } },
  { { 0.1, 1.05, 1.5 }, { 0.1, 0.05, 1.5 }, { 0.6, 0.05, 1.55 }, { 0.2, 0.1, 3 } },
  { { 0.1, 1.05, 1.5 }, { 0.6, 0.05, 1.55 }, { 0.1, 0.05, 1.5 }, { 0.5, 1, 0.05 } },
  { { 0.6, 0.05, 1.55 }, { 0.1, 1.05, 1.5 }, { 0, 1, 0 }, { 0, 0, 0 } },
  { { 0.6, 0.05, 1.55 }, { 0.1, 1.05, 1.5 }, { 0, 0, 0 }, { 0.2, 0.1, 3 } },
  { { 0.6, 0.05, 1.55 }, { 0.5, 1, 0.05 }, { 1, 0, 0.1 }, { 0, 0, 0 } },
  { { 0.6, 0.05, 1.55 }, { 0.5, 1, 0.05 }, { 0, 0, 0 }, { 0, 1, 0 } },
  { { 0.5, 1, 0.05 }, { 0, 1, 0 }, { 0.1, 1.05, 1.5 }, { 0, 2, 0 } },
  { { 0.5, 1, 0.05 }, { 0.1, 1.05, 1.5 }, { 0, 1, 0 }, { 0.6, 0.05, 1.55 } },
  { { 0.1, 1.05, 1.5 }, { 0.5, 1, 0.05 }, { 0.5, 0, 0.05 }, { 0, 0, 0 } },
  { { 0.1, 1.05, 1.5 }, { 0.5, 1, 0.05 }, { 0, 0, 0 }, { 0, 2, 0 } },
  { { 0.1, 1.05, 1.5 }, { 0.6, 0.05, 1.55 }, { 0.2, 0.1, 3 }, { 0, 0, 0 } },
  { { 0.1, 1.05, 1.5 }, { 0.6, 0.05, 1.55 }, { 0, 0, 0 }, { 0.5, 0, 0.05 } },
  { { 0.6, 0.05, 1.55 }, { 0.5, 0, 0.05 }, { 0.5, 1, 0.05 }, { 1, 0, 0.1 } },
  { { 0.6, 0.05, 1.55 }, { 0.5, 1, 0.05 }, { 0.5, 0, 0.05 }, { 0.1, 1.05, 1.5 } },
  { { 0.6, 0.05, 1.55 }, { 0, 0, 0 }, { 0, 1, 0 }, { 1, 0, 0.1 } },
  { { 0.6, 0.05, 1.55 }, { 0, 0, 0 }, { 0.1, 0.05, 1.5 }, { 0, 1, 0 } },
  { { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 }, { 0, 1, 0 }, { 0, 2, 0 } },
  { { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 }, { 0.6, 0.05, 1.55 }, { 0, 1, 0 } },
  { { 0.1, 0.05, 1.5 }, { 0.6, 0.05, 1.55 }, { 0.1, 1.05, 1.5 }, { 0.2, 0.1, 3 } },
  { { 0.1, 0.05, 1.5 }, { 0.1, 1.05, 1.5 }, { 0.6, 0.05, 1.55 }, { 0, 1, 0 } },
  { { 0, 0, 0 }, { 0.5, 1, 0.05 }, { 0.1, 0.05, 1.5 }, { 1, 0, 0.1 } },
  { { 0, 0, 0 }, { 0.5, 1, 0.05 }, { 0, 1, 0 }, { 0.1, 0.05, 1.5 } },
  { { 1, 0, 0.1 }, { 0.1, 1.05, 1.5 }, { 0.1, 0.05, 1.5 }, { 0.2, 0.1, 3 } },
  { { 1, 0, 0.1 }, { 0.1, 1.05, 1.5 }, { 0.5, 1, 0.05 }, { 0.1, 0.05, 1.5 } },
  { { 0.1, 1.05, 1.5 }, { 0.5, 1, 0.05 }, { 0, 1, 0 }, { 0, 2, 0 } },
  { { 0.1, 1.05, 1.5 }, { 0, 1, 0 }, { 0.5, 1, 0.05 }, { 0.1, 0.05, 1.5 } },
  { { 0.1, 1.05, 1.5 }, { 0.1, 0.05, 1.5 }, { 0.5, 0, 0.05 }, { 1, 0, 0.1 } },
  { { 0.1, 1.05, 1.5 }, { 0.1, 0.05, 1.5 }, { 1, 0, 0.1 }, { 0.2, 0.1, 3 } },
  { { 0.1, 1.05, 1.5 }, { 0, 1, 0 }, { 0, 2, 0 }, { 1, 0, 0.1 } },
  { { 0.1, 1.05, 1.5 }, { 0, 1, 0 }, { 1, 0, 0.1 }, { 0.5, 0, 0.05 } },
  { { 0, 1, 0 }, { 0.5, 0, 0.05 }, { 0.1, 0.05, 1.5 }, { 0, 0, 0 } },
  { { 0, 1, 0 }, { 0.1, 0.05, 1.5 }, { 0.5, 0, 0.05 }, { 0.1, 1.05, 1.5 } },
  { { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 }, { 0.5, 0, 0.05 }, { 0, 2, 0 } },
  { { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 }, { 0.6, 0.05, 1.55 }, { 0.5, 0, 0.05 } },
  { { 0.1, 1.05, 1.5 }, { 0, 0, 0 }, { 0.5, 0, 0.05 }, { 0.1, 0.05, 1.5 } },
  { { 0.1, 1.05, 1.5 }, { 0, 0, 0 }, { 0, 2, 0 }, { 0.5, 0, 0.05 } },
  { { 0.6, 0.05, 1.55 }, { 0.1, 1.05, 1.5 }, { 0.1, 0.05, 1.5 }, { 0.2, 0.1, 3 } },
  { { 0.6, 0.05, 1.55 }, { 0.1, 0.05, 1.5 }, { 0.1, 1.05, 1.5 }, { 0.5, 0, 0.05 } },
  { { 0.5, 1, 0.05 }, { 0, 0, 0 }, { 0.1, 0.05, 1.5 }, { 0, 2, 0 } },
  { { 0.5, 1, 0.05 }, { 0, 0, 0 }, { 0.5, 0, 0.05 }, { 0.1, 0.05, 1.5 } },
  { { 0.6, 0.05, 1.55 }, { 0, 2, 0 }, { 0.1, 0.05, 1.5 }, { 0.2, 0.1, 3 } },
  { { 0.6, 0.05, 1.55 }, { 0, 2, 0 }, { 0.5, 1, 0.05 }, { 0.1, 0.05, 1.5 } },
  { { 0.5, 0, 0.05 }, { 0.5, 1, 0.05 }, { 0.6, 0.05, 1.55 }, { 1, 0, 0.1 } },
  { { 0.5, 0, 0.05 }, { 0.6, 0.05, 1.55 }, { 0.5, 1, 0.05 }, { 0.1, 0.05, 1.5 } },
  { { 1, 0, 0.1 }, { 0, 1, 0 }, { 0.6, 0.05, 1.55 }, { 0, 2, 0 } },
  { { 1, 0, 0.1 }, { 0, 1, 0 }, { 0.5, 0, 0.05 }, { 0.6, 0.05, 1.55 } },
  { { 0, 2, 0 }, { 0.1, 0.05, 1.5 }, { 0.6, 0.05, 1.55 }, { 0.2, 0.1, 3 } },
  { { 0, 2, 0 }, { 0.1, 0.05, 1.5 }, { 0, 1, 0 }, { 0.6, 0.05, 1.55 } },
  { { 0.1, 0.05, 1.5 }, { 0, 1, 0 }, { 0.5, 0, 0.05 }, { 0, 0, 0 } },
  { { 0.1, 0.05, 1.5 }, { 0.5, 0, 0.05 }, { 0, 1, 0 }, { 0.6, 0.05, 1.55 } },
  { { 0.1, 1.05, 1.5 }, { 0, 0, 0 }, { 0.5, 0, 0.05 }, { 0.2, 0.1, 3 } },
  { { 0.1, 1.05, 1.5 }, { 0, 0, 0 }, { 0, 1, 0 }, { 0.5, 0, 0.05 } },
  { { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 }, { 0.5, 0, 0.05 }, { 0.5, 1, 0.05 } },
  { { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 }, { 0.2, 0.1, 3 }, { 0.5, 0, 0.05 } },
  { { 0, 1, 0 }, { 0.1, 1.05, 1.5 }, { 0.5, 1, 0.05 }, { 0, 2, 0 } },
  { { 0, 1, 0 }, { 0.5, 1, 0.05 }, { 0.1, 1.05, 1.5 }, { 0.5, 0, 0.05 } },
  { { 0.6, 0.05, 1.55 }, { 0, 2, 0 }, { 0, 1, 0 }, { 0.2, 0.1, 3 } },
  { { 0.6, 0.05, 1.55 }, { 0, 2, 0 }, { 0.5, 1, 0.05 }, { 0, 1, 0 } },
  { { 0.6, 0.05, 1.55 }, { 0, 0, 0 }, { 0, 1, 0 }, { 0.5, 0, 0.05 } },
  { { 0.6, 0.05, 1.55 }, { 0, 0, 0 }, { 0.2, 0.1, 3 }, { 0, 1, 0 } },
  { { 0.5, 1, 0.05 }, { 0.6, 0.05, 1.55 }, { 0.5, 0, 0.05 }, { 1, 0, 0.1 } },
  { { 0.5, 1, 0.05 }, { 0.5, 0, 0.05 }, { 0.6, 0.05, 1.55 }, { 0, 1, 0 } },
  { { 0.1, 0.05, 1.5 }, { 1, 0, 0.1 }, { 0.5, 1, 0.05 }, { 0.2, 0.1, 3 } },
  { { 0.1, 0.05, 1.5 }, { 1, 0, 0.1 }, { 0.5, 0, 0.05 }, { 0.5, 1, 0.05 } },
  { { 0.1, 0.05, 1.5 }, { 0, 2, 0 }, { 0.5, 1, 0.05 }, { 0, 1, 0 } },
  { { 0.1, 0.05, 1.5 }, { 0, 2, 0 }, { 0.2, 0.1, 3 }, { 0.5, 1, 0.05 } },
  { { 0.5, 0, 0.05 }, { 0.1, 0.05, 1.5 }, { 0, 1, 0 }, { 0, 0, 0 } },
  { { 0.5, 0, 0.05 }, { 0, 1, 0 }, { 0.1, 0.05, 1.5 }, { 0.5, 1, 0.05 } },
  { { 0.1, 0.05, 1.5 }, { 0.5, 1, 0.05 }, { 0, 0, 0 }, { 0, 1, 0 } },
  { { 0.1, 0.05, 1.5 }, { 0.5, 1, 0.05 }, { 0.6, 0.05, 1.55 }, { 0, 0, 0 } },
  { { 0.6, 0.05, 1.55 }, { 0.5, 1, 0.05 }, { 1, 0, 0.1 }, { 0, 0, 0 } },
  { { 0.6, 0.05, 1.55 }, { 0.1, 0.05, 1.5 }, { 0.2, 0.1, 3 }, { 0, 2, 0 } },
  { { 0.1, 0.05, 1.5 }, { 0.5, 1, 0.05 }, { 0, 1, 0 }, { 0, 2, 0 } },
  { { 0.1, 0.05, 1.5 }, { 0.5, 1, 0.05 }, { 0, 2, 0 }, { 0.6, 0.05, 1.55 } },
  { { 0.6, 0.05, 1.55 }, { 0, 1, 0 }, { 1, 0, 0.1 }, { 0.5, 0, 0.05 } },
  { { 0.6, 0.05, 1.55 }, { 0, 1, 0 }, { 0.1, 1.05, 1.5 }, { 1, 0, 0.1 } },
  { { 0.1, 1.05, 1.5 }, { 0, 1, 0 }, { 0, 2, 0 }, { 1, 0, 0.1 } },
  { { 0.1, 1.05, 1.5 }, { 0.6, 0.05, 1.55 }, { 0.2, 0.1, 3 }, { 0, 0, 0 } },
  { { 0.6, 0.05, 1.55 }, { 0, 1, 0 }, { 0.5, 0, 0.05 }, { 0, 0, 0 } },
  { { 0.6, 0.05, 1.55 }, { 0, 1, 0 }, { 0, 0, 0 }, { 0.1, 1.05, 1.5 } },
  { { 0.5, 1, 0.05 }, { 0.1, 0.05, 1.5 }, { 0, 0, 0 }, { 0.5, 0, 0.05 } },
  { { 0.5, 1, 0.05 }, { 0.1, 0.05, 1.5 }, { 0.1, 1.05, 1.5 }, { 0, 0, 0 } },
  { { 0.5, 1, 0.05 }, { 0.1, 1.05, 1.5 }, { 0, 2, 0 }, { 0, 0, 0 } },
  { { 0.1, 0.05, 1.5 }, { 0.1, 1.05, 1.5 }, { 0.2, 0.1, 3 }, { 1, 0, 0.1 } },
  { { 0.5, 1, 0.05 }, { 0.1, 0.05, 1.5 }, { 0.5, 0, 0.05 }, { 1, 0, 0.1 } },
  { { 0.5, 1, 0.05 }, { 0.1, 0.05, 1.5 }, { 1, 0, 0.1 }, { 0.1, 1.05, 1.5 } },
  { { 0, 0, 0 }, { 0.5, 1, 0.05 }, { 0, 1, 0 }, { 0.1, 0.05, 1.5 } },
  { { 0, 0, 0 }, { 0.5, 1, 0.05 }, { 0.1, 0.05, 1.5 }, { 0.6, 0.05, 1.55 } },
  { { 0, 0, 0 }, { 0.5, 1, 0.05 }, { 0.6, 0.05, 1.55 }, { 1, 0, 0.1 } },
  { { 0.5, 1, 0.05 }, { 0.1, 0.05, 1.5 }, { 0.1, 1.05, 1.5 }, { 0, 1, 0 } },
  { { 0.5, 1, 0.05 }, { 0.1, 0.05, 1.5 }, { 0.6, 0.05, 1.55 }, { 0.1, 1.05, 1.5 } },
  { { 0.1, 0.05, 1.5 }, { 0.6, 0.05, 1.55 }, { 0.1, 1.05, 1.5 }, { 0.2, 0.1, 3 } },
  { { 0, 1, 0 }, { 0.5, 1, 0.05 }, { 0, 2, 0 }, { 0.1, 1.05, 1.5 } },
  { { 1, 0, 0.1 }, { 0, 1, 0 }, { 0.5, 0, 0.05 }, { 0.6, 0.05, 1.55 } },
  { { 1, 0, 0.1 }, { 0, 1, 0 }, { 0.6, 0.05, 1.55 }, { 0.1, 1.05, 1.5 } },
  { { 1, 0, 0.1 }, { 0, 1, 0 }, { 0.1, 1.05, 1.5 }, { 0, 2, 0 } },
  { { 0, 1, 0 }, { 0.6, 0.05, 1.55 }, { 0.1, 0.05, 1.5 }, { 0.5, 0, 0.05 } },
  { { 0, 1, 0 }, { 0.6, 0.05, 1.55 }, { 0.1, 1.05, 1.5 }, { 0.1, 0.05, 1.5 } },
  { { 0.6, 0.05, 1.55 }, { 0.1, 1.05, 1.5 }, { 0.1, 0.05, 1.5 }, { 0.2, 0.1, 3 } },
  { { 0.5, 0, 0.05 }, { 0, 1, 0 }, { 0, 0, 0 }, { 0.1, 0.05, 1.5 } },
  { { 0.5, 1, 0.05 }, { 0, 0, 0 }, { 0.5, 0, 0.05 }, { 0.1, 0.05, 1.5 } },
  { { 0.5, 1, 0.05 }, { 0, 0, 0 }, { 0.1, 0.05, 1.5 }, { 0.1, 1.05, 1.5 } },
  { { 0.5, 1, 0.05 }, { 0, 0, 0 }, { 0.1, 1.05, 1.5 }, { 0, 2, 0 } },
  { { 0.1, 0.05, 1.5 }, { 0.5, 1, 0.05 }, { 0.6, 0.05, 1.55 }, { 0.5, 0, 0.05 } },
  { { 0.1, 0.05, 1.5 }, { 0.5, 1, 0.05 }, { 0.1, 1.05, 1.5 }, { 0.6, 0.05, 1.55 } },
  { { 0.1, 1.05, 1.5 }, { 0.1, 0.05, 1.5 }, { 0.6, 0.05, 1.55 }, { 0.2, 0.1, 3 } },
  { { 0.5, 1, 0.05 }, { 0.5, 0, 0.05 }, { 1, 0, 0.1 }, { 0.6, 0.05, 1.55 } },
  { { 0.1, 1.05, 1.5 }, { 0, 0, 0 }, { 0, 1, 0 }, { 0.5, 0, 0.05 } },
  { { 0.1, 1.05, 1.5 }, { 0, 0, 0 }, { 0.5, 0, 0.05 }, { 0.6, 0.05, 1.55 } },
  { { 0.1, 1.05, 1.5 }, { 0, 0, 0 }, { 0.6, 0.05, 1.55 }, { 0.2, 0.1, 3 } },
  { { 0.5, 0, 0.05 }, { 0.1, 1.05, 1.5 }, { 0.5, 1, 0.05 }, { 0, 1, 0 } },
  { { 0.5, 0, 0.05 }, { 0.1, 1.05, 1.5 }, { 0.6, 0.05, 1.55 }, { 0.5, 1, 0.05 } },
  { { 0.6, 0.05, 1.55 }, { 0.5, 0, 0.05 }, { 0.5, 1, 0.05 }, { 1, 0, 0.1 } },
  { { 0.1, 1.05, 1.5 }, { 0, 1, 0 }, { 0, 2, 0 }, { 0.5, 1, 0.05 } },
  { { 1, 0, 0.1 }, { 0.1, 1.05, 1.5 }, { 0.5, 1, 0.05 }, { 0.5, 0, 0.05 } },
  { { 1, 0, 0.1 }, { 0.1, 1.05, 1.5 }, { 0.5, 0, 0.05 }, { 0.1, 0.05, 1.5 } },
  { { 1, 0, 0.1 }, { 0.1, 1.05, 1.5 }, { 0.1, 0.05, 1.5 }, { 0.2, 0.1, 3 } },
  { { 0.1, 1.05, 1.5 }, { 0.5, 0, 0.05 }, { 0, 1, 0 }, { 0.5, 1, 0.05 } },
  { { 0.1, 1.05, 1.5 }, { 0.5, 0, 0.05 }, { 0.1, 0.05, 1.5 }, { 0, 1, 0 } },
  { { 0.5, 0, 0.05 }, { 0.1, 0.05, 1.5 }, { 0, 1, 0 }, { 0, 0, 0 } },
  { { 0.5, 1, 0.05 }, { 0.1, 1.05, 1.5 }, { 0, 2, 0 }, { 0, 1, 0 } },
  { { 0.6, 0.05, 1.55 }, { 0, 2, 0 }, { 0.5, 1, 0.05 }, { 0, 1, 0 } },
  { { 0.6, 0.05, 1.55 }, { 0, 2, 0 }, { 0, 1, 0 }, { 0.1, 0.05, 1.5 } },
  { { 0.6, 0.05, 1.55 }, { 0, 2, 0 }, { 0.1, 0.05, 1.5 }, { 0.2, 0.1, 3 } },
  { { 0, 1, 0 }, { 0.6, 0.05, 1.55 }, { 0.5, 0, 0.05 }, { 0.5, 1, 0.05 } },
  { { 0, 1, 0 }, { 0.6, 0.05, 1.55 }, { 0.1, 0.05, 1.5 }, { 0.5, 0, 0.05 } },
  { { 0.1, 0.05, 1.5 }, { 0, 1, 0 }, { 0.5, 0, 0.05 }, { 0, 0, 0 } },
  { { 0.6, 0.05, 1.55 }, { 0.5, 1, 0.05 }, { 1, 0, 0.1 }, { 0.5, 0, 0.05 } },
  { { 0, 1, 0 }, { 0.5, 0, 0.05 }, { 0.5, 1, 0.05 }, { 0.6, 0.05, 1.55 } },
  { { 0, 1, 0 }, { 0.5, 1, 0.05 }, { 0.1, 1.05, 1.5 }, { 0.6, 0.05, 1.55 } },
  { { 0, 1, 0 }, { 0.1, 1.05, 1.5 }, { 0.1, 0.05, 1.5 }, { 0.6, 0.05, 1.55 } },
  { { 0, 1, 0 }, { 0.1, 0.05, 1.5 }, { 0.5, 0, 0.05 }, { 0.6, 0.05, 1.55 } },
  { { 0.1, 0.05, 1.5 }, { 0.6, 0.05, 1.55 }, { 0.1, 1.05, 1.5 }, { 0.2, 0.1, 3 } },
  { { 0, 1, 0 }, { 0.5, 1, 0.05 }, { 0, 2, 0 }, { 0.1, 1.05, 1.5 } },
  { { 0.5, 0, 0.05 }, { 1, 0, 0.1 }, { 0.5, 1, 0.05 }, { 0.6, 0.05, 1.55 } },
  { { 0, 0, 0 }, { 0.5, 0, 0.05 }, { 0, 1, 0 }, { 0.1, 0.05, 1.5 } },
  { { 0, 0, 0 }, { 2, 0, 0 }, { 0.1, 3, 0.2 }, { 0, 0.1, 1 } },
  { { 0, 0, 0 }, { 1, 0, 0 }, { 0.1, 3, 0.2 }, { 0, 0.1, 1 } },
  { { 1, 0, 0 }, { 2, 0, 0 }, { 0.1, 3, 0.2 }, { 0, 0.1, 1 } },
  { { 2, 0, 0 }, { 1.05, 1.5, 0.1 }, { 0, 0, 0 }, { 0, 0.1, 1 } },
  { { 1.05, 1.5, 0.1 }, { 0.1, 3, 0.2 }, { 0, 0, 0 }, { 0, 0.1, 1 } },
  { { 0.1, 3, 0.2 }, { 0.05, 1.5, 0.1 }, { 2, 0, 0 }, { 0, 0.1, 1 } },
  { { 0.05, 1.5, 0.1 }, { 0, 0, 0 }, { 2, 0, 0 }, { 0, 0.1, 1 } },
  { { 0, 0.1, 1 }, { 0, 0.05, 0.5 }, { 0.1, 3, 0.2 }, { 2, 0, 0 } },
  { { 0, 0.05, 0.5 }, { 0, 0, 0 }, { 0.1, 3, 0.2 }, { 2, 0, 0 } },
  { { 2, 0, 0 }, { 1, 0.05, 0.5 }, { 0.1, 3, 0.2 }, { 0, 0, 0 } },
  { { 1, 0.05, 0.5 }, { 0, 0.1, 1 }, { 0.1, 3, 0.2 }, { 0, 0, 0 } },
  { { 0, 0.1, 1 }, { 0.05, 1.55, 0.6 }, { 2, 0, 0 }, { 0, 0, 0 } },
  { { 0.05, 1.55, 0.6 }, { 0.1, 3, 0.2 }, { 2, 0, 0 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 1, 0, 0 }, { 1.05, 1.5, 0.1 }, { 0, 0.1, 1 } },
  { { 0, 0, 0 }, { 1.05, 1.5, 0.1 }, { 0.1, 3, 0.2 }, { 0, 0.1, 1 } },
  { { 0, 0.1, 1 }, { 1, 0, 0 }, { 1.05, 1.5, 0.1 }, { 2, 0, 0 } },
  { { 0.1, 3, 0.2 }, { 0.05, 1.5, 0.1 }, { 2, 0, 0 }, { 0, 0.1, 1 } },
  { { 0.05, 1.5, 0.1 }, { 1, 0, 0 }, { 2, 0, 0 }, { 0, 0.1, 1 } },
  { { 0, 0.1, 1 }, { 0.05, 1.5, 0.1 }, { 1, 0, 0 }, { 0, 0, 0 } },
  { { 2, 0, 0 }, { 1.05, 1.5, 0.1 }, { 0, 0, 0 }, { 0, 0.1, 1 } },
  { { 1.05, 1.5, 0.1 }, { 0.05, 1.5, 0.1 }, { 0, 0, 0 }, { 0, 0.1, 1 } },
  { { 0, 0.1, 1 }, { 1.05, 1.5, 0.1 }, { 0.05, 1.5, 0.1 }, { 0.1, 3, 0.2 } },
  { { 2, 0, 0 }, { 1, 0, 0 }, { 0, 0.1, 1 }, { 0.1, 3, 0.2 } },
  { { 1, 0, 0 }, { 0, 0.05, 0.5 }, { 0, 0.1, 1 }, { 0.1, 3, 0.2 } },
  { { 0.1, 3, 0.2 }, { 1, 0, 0 }, { 0, 0.05, 0.5 }, { 0, 0, 0 } },
  { { 0, 0.1, 1 }, { 1, 0.05, 0.5 }, { 0, 0, 0 }, { 0.1, 3, 0.2 } },
  { { 1, 0.05, 0.5 }, { 1, 0, 0 }, { 0, 0, 0 }, { 0.1, 3, 0.2 } },
  { { 0.1, 3, 0.2 }, { 1, 0.05, 0.5 }, { 1, 0, 0 }, { 2, 0, 0 } },
  { { 0, 0, 0 }, { 0, 0.05, 0.5 }, { 1, 0.05, 0.5 }, { 0.1, 3, 0.2 } },
  { { 0, 0, 0 }, { 1, 0.05, 0.5 }, { 2, 0, 0 }, { 0.1, 3, 0.2 } },
  { { 0.1, 3, 0.2 }, { 0, 0.05, 0.5 }, { 1, 0.05, 0.5 }, { 0, 0.1, 1 } },
  { { 0.1, 3, 0.2 }, { 1.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 0, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 1, 0.05, 0.5 }, { 0, 0.1, 1 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 1.05, 1.5, 0.1 }, { 1, 0.05, 0.5 }, { 2, 0, 0 } },
  { { 0, 0.1, 1 }, { 0.05, 1.55, 0.6 }, { 1.05, 1.5, 0.1 }, { 0, 0, 0 } },
  { { 0, 0.1, 1 }, { 1.05, 1.5, 0.1 }, { 2, 0, 0 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0.05, 1.55, 0.6 }, { 1.05, 1.5, 0.1 }, { 0.1, 3, 0.2 } },
  { { 2, 0, 0 }, { 1, 0.05, 0.5 }, { 0.05, 1.55, 0.6 }, { 0, 0, 0 } },
  { { 2, 0, 0 }, { 0.05, 1.55, 0.6 }, { 0.1, 3, 0.2 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 1, 0.05, 0.5 }, { 0.05, 1.55, 0.6 }, { 0, 0.1, 1 } },
  { { 0, 0.1, 1 }, { 0, 0.05, 0.5 }, { 0.05, 1.5, 0.1 }, { 2, 0, 0 } },
  { { 0, 0.1, 1 }, { 0.05, 1.5, 0.1 }, { 0.1, 3, 0.2 }, { 2, 0, 0 } },
  { { 2, 0, 0 }, { 0, 0.05, 0.5 }, { 0.05, 1.5, 0.1 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 2, 0, 0 } },
  { { 0, 0, 0 }, { 0.05, 1.55, 0.6 }, { 0, 0.1, 1 }, { 2, 0, 0 } },
  { { 2, 0, 0 }, { 0.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 0.1, 3, 0.2 } },
  { { 0.1, 3, 0.2 }, { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 2, 0, 0 } },
  { { 0.05, 1.55, 0.6 }, { 0, 0.05, 0.5 }, { 0, 0, 0 }, { 2, 0, 0 } },
  { { 2, 0, 0 }, { 0.05, 1.55, 0.6 }, { 0, 0.05, 0.5 }, { 0, 0.1, 1 } },
  { { 0, 0, 0 }, { 1, 0, 0 }, { 0.05, 1.55, 0.6 }, { 0, 0.1, 1 } },
  { { 1, 0, 0 }, { 2, 0, 0 }, { 0.05, 1.55, 0.6 }, { 0, 0.1, 1 } },
  { { 0, 0, 0 }, { 1, 0, 0 }, { 0.1, 3, 0.2 }, { 0.05, 1.55, 0.6 } },
  { { 1, 0, 0 }, { 2, 0, 0 }, { 0.1, 3, 0.2 }, { 0.05, 1.55, 0.6 } },
  { { 2, 0, 0 }, { 1.05, 1.5, 0.1 }, { 0, 0.05, 0.5 }, { 0, 0.1, 1 } },
  { { 1.05, 1.5, 0.1 }, { 0.1, 3, 0.2 }, { 0, 0.05, 0.5 }, { 0, 0.1, 1 } },
  { { 2, 0, 0 }, { 1.05, 1.5, 0.1 }, { 0, 0, 0 }, { 0, 0.05, 0.5 } },
  { { 1.05, 1.5, 0.1 }, { 0.1, 3, 0.2 }, { 0, 0, 0 }, { 0, 0.05, 0.5 } },
  { { 0.1, 3, 0.2 }, { 0.05, 1.5, 0.1 }, { 1, 0.05, 0.5 }, { 0, 0.1, 1 } },
  { { 0.05, 1.5, 0.1 }, { 0, 0, 0 }, { 1, 0.05, 0.5 }, { 0, 0.1, 1 } },
  { { 0.1, 3, 0.2 }, { 0.05, 1.5, 0.1 }, { 2, 0, 0 }, { 1, 0.05, 0.5 } },
  { { 0.05, 1.5, 0.1 }, { 0, 0, 0 }, { 2, 0, 0 }, { 1, 0.05, 0.5 } },
  { { 0, 0.1, 1 }, { 0.1, 3, 0.2 }, { 2, 0, 0 }, { 0.05, 1.5, 0.1 } },
  { { 1, 0, 0 }, { 0.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 2, 0, 0 } },
  { { 1, 0, 0 }, { 0.05, 1.5, 0.1 }, { 0, 0.05, 0.5 }, { 0, 0.1, 1 } },
  { { 1, 0, 0 }, { 0, 0.05, 0.5 }, { 0.05, 1.5, 0.1 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0.1, 3, 0.2 }, { 0, 0.1, 1 }, { 1.05, 1.5, 0.1 } },
  { { 1, 0.05, 0.5 }, { 1.05, 1.5, 0.1 }, { 0, 0, 0 }, { 0, 0.1, 1 } },
  { { 1, 0.05, 0.5 }, { 1.05, 1.5, 0.1 }, { 1, 0, 0 }, { 0, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 1, 0.05, 0.5 }, { 1, 0, 0 }, { 2, 0, 0 } },
  { { 2, 0, 0 }, { 0, 0, 0 }, { 0, 0.1, 1 }, { 1.05, 1.5, 0.1 } },
  { { 1.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 0, 0.1, 1 } },
  { { 1.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 0.05, 1.5, 0.1 }, { 0, 0, 0 } },
  { { 0.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 1.05, 1.5, 0.1 }, { 0.1, 3, 0.2 } },
  { { 0.1, 3, 0.2 }, { 0, 0, 0 }, { 2, 0, 0 }, { 0.05, 1.55, 0.6 } },
  { { 0.05, 1.55, 0.6 }, { 1, 0.05, 0.5 }, { 0, 0, 0 }, { 2, 0, 0 } },
  { { 0.05, 1.55, 0.6 }, { 1, 0.05, 0.5 }, { 0, 0.05, 0.5 }, { 0, 0, 0 } },
  { { 0, 0.05, 0.5 }, { 1, 0.05, 0.5 }, { 0.05, 1.55, 0.6 }, { 0, 0.1, 1 } },
  { { 0, 0, 0 }, { 0, 0.05, 0.5 }, { 1, 0, 0 }, { 0.1, 3, 0.2 } },
  { { 1, 0, 0 }, { 0, 0.05, 0.5 }, { 1, 0.05, 0.5 }, { 0.1, 3, 0.2 } },
  { { 1, 0, 0 }, { 1, 0.05, 0.5 }, { 2, 0, 0 }, { 0.1, 3, 0.2 } },
  { { 0, 0.05, 0.5 }, { 0, 0.1, 1 }, { 1, 0.05, 0.5 }, { 0.1, 3, 0.2 } },
  { { 2, 0, 0 }, { 1, 0.05, 0.5 }, { 1.05, 1.5, 0.1 }, { 0, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 1, 0.05, 0.5 }, { 0.05, 1.55, 0.6 }, { 0, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 0.1, 3, 0.2 }, { 0, 0, 0 } },
  { { 1, 0.05, 0.5 }, { 0, 0.1, 1 }, { 0.05, 1.55, 0.6 }, { 0, 0, 0 } },
  { { 0, 0.1, 1 }, { 0, 0.05, 0.5 }, { 0.05, 1.55, 0.6 }, { 2, 0, 0 } },
  { { 0.05, 1.55, 0.6 }, { 0, 0.05, 0.5 }, { 0.05, 1.5, 0.1 }, { 2, 0, 0 } },
  { { 0.05, 1.55, 0.6 }, { 0.05, 1.5, 0.1 }, { 0.1, 3, 0.2 }, { 2, 0, 0 } },
  { { 0, 0.05, 0.5 }, { 0, 0, 0 }, { 0.05, 1.5, 0.1 }, { 2, 0, 0 } },
  { { 0, 0, 0 }, { 1, 0, 0 }, { 0.05, 1.5, 0.1 }, { 0, 0.1, 1 } },
  { { 0.05, 1.5, 0.1 }, { 1, 0, 0 }, { 1.05, 1.5, 0.1 }, { 0, 0.1, 1 } },
  { { 0.05, 1.5, 0.1 }, { 1.05, 1.5, 0.1 }, { 0.1, 3, 0.2 }, { 0, 0.1, 1 } },
  { { 1, 0, 0 }, { 2, 0, 0 }, { 1.05, 1.5, 0.1 }, { 0, 0.1, 1 } },
  { { 1, 0.05, 0.5 }, { 0, 0, 0 }, { 0.05, 1.5, 0.1 }, { 1, 0, 0 } },
  { { 1, 0.05, 0.5 }, { 0, 0, 0 }, { 0, 0.1, 1 }, { 0.05, 1.5, 0.1 } },
  { { 0.05, 1.5, 0.1 }, { 2, 0, 0 }, { 1, 0.05, 0.5 }, { 1, 0, 0 } },
  { { 0.05, 1.5, 0.1 }, { 2, 0, 0 }, { 0.1, 3, 0.2 }, { 1, 0.05, 0.5 } },
  { { 0.1, 3, 0.2 }, { 0, 0.1, 1 }, { 0.05, 1.5, 0.1 }, { 1, 0.05, 0.5 } },
  { { 0, 0, 0 }, { 1.05, 1.5, 0.1 }, { 0.1, 3, 0.2 }, { 0, 0.05, 0.5 } },
  { { 0, 0, 0 }, { 1.05, 1.5, 0.1 }, { 0, 0.05, 0.5 }, { 1, 0, 0 } },
  { { 1, 0, 0 }, { 0, 0.1, 1 }, { 2, 0, 0 }, { 1.05, 1.5, 0.1 } },
  { { 1, 0, 0 }, { 0, 0.1, 1 }, { 1.05, 1.5, 0.1 }, { 0, 0.05, 0.5 } },
  { { 0, 0.1, 1 }, { 1.05, 1.5, 0.1 }, { 0, 0.05, 0.5 }, { 0.1, 3, 0.2 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 1, 0, 0 }, { 2, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 0.05, 1.55, 0.6 }, { 1, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0, 0 }, { 0.05, 1.55, 0.6 }, { 0.1, 3, 0.2 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0, 0 }, { 1, 0, 0 }, { 0.05, 1.55, 0.6 } },
  { { 0, 0, 0 }, { 0, 0.1, 1 }, { 1, 0, 0 }, { 0.05, 1.55, 0.6 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0, 0 }, { 1, 0.05, 0.5 }, { 0.05, 1.5, 0.1 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0, 0 }, { 2, 0, 0 }, { 1, 0.05, 0.5 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 0.1, 3, 0.2 }, { 0.05, 1.5, 0.1 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 0.05, 1.5, 0.1 }, { 1, 0.05, 0.5 } },
  { { 0, 0.1, 1 }, { 0.05, 1.5, 0.1 }, { 1, 0.05, 0.5 }, { 0, 0, 0 } },
  { { 0.05, 1.5, 0.1 }, { 2, 0, 0 }, { 0.05, 1.55, 0.6 }, { 1, 0, 0 } },
  { { 0.05, 1.5, 0.1 }, { 2, 0, 0 }, { 0.1, 3, 0.2 }, { 0.05, 1.55, 0.6 } },
  { { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 0.05, 1.5, 0.1 }, { 1, 0, 0 } },
  { { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 1, 0, 0 }, { 0, 0.1, 1 } },
  { { 0, 0.1, 1 }, { 1, 0, 0 }, { 0.05, 1.55, 0.6 }, { 2, 0, 0 } },
  { { 0.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 1.05, 1.5, 0.1 }, { 0.1, 3, 0.2 } },
  { { 0.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 0, 0.05, 0.5 }, { 1.05, 1.5, 0.1 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0, 0 }, { 0, 0.05, 0.5 }, { 0.05, 1.5, 0.1 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0, 0 }, { 2, 0, 0 }, { 0, 0.05, 0.5 } },
  { { 2, 0, 0 }, { 0, 0.1, 1 }, { 1.05, 1.5, 0.1 }, { 0, 0.05, 0.5 } },
  { { 1, 0.05, 0.5 }, { 0, 0, 0 }, { 0.05, 1.55, 0.6 }, { 1, 0, 0 } },
  { { 1, 0.05, 0.5 }, { 0, 0, 0 }, { 0, 0.1, 1 }, { 0.05, 1.55, 0.6 } },
  { { 0.05, 1.55, 0.6 }, { 2, 0, 0 }, { 1, 0.05, 0.5 }, { 1, 0, 0 } },
  { { 0.05, 1.55, 0.6 }, { 2, 0, 0 }, { 1, 0, 0 }, { 0.1, 3, 0.2 } },
  { { 0.1, 3, 0.2 }, { 1, 0, 0 }, { 0.05, 1.55, 0.6 }, { 0, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 0, 0.05, 0.5 }, { 1, 0.05, 0.5 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 0.1, 3, 0.2 }, { 0, 0.05, 0.5 } },
  { { 1, 0.05, 0.5 }, { 0, 0, 0 }, { 1.05, 1.5, 0.1 }, { 2, 0, 0 } },
  { { 1, 0.05, 0.5 }, { 0, 0, 0 }, { 0, 0.05, 0.5 }, { 1.05, 1.5, 0.1 } },
  { { 0, 0, 0 }, { 0.1, 3, 0.2 }, { 0, 0.05, 0.5 }, { 1.05, 1.5, 0.1 } },
  { { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 1, 0.05, 0.5 }, { 0, 0.1, 1 } },
  { { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 0.05, 1.5, 0.1 }, { 1, 0.05, 0.5 } },
  { { 0.05, 1.55, 0.6 }, { 2, 0, 0 }, { 0.05, 1.5, 0.1 }, { 0.1, 3, 0.2 } },
  { { 0.05, 1.55, 0.6 }, { 2, 0, 0 }, { 1, 0.05, 0.5 }, { 0.05, 1.5, 0.1 } },
  { { 2, 0, 0 }, { 0, 0, 0 }, { 1, 0.05, 0.5 }, { 0.05, 1.5, 0.1 } },
  { { 0, 0.1, 1 }, { 1.05, 1.5, 0.1 }, { 2, 0, 0 }, { 0, 0.05, 0.5 } },
  { { 0, 0.1, 1 }, { 1.05, 1.5, 0.1 }, { 0, 0.05, 0.5 }, { 0.05, 1.55, 0.6 } },
  { { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 0.1, 3, 0.2 }, { 1.05, 1.5, 0.1 } },
  { { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 1.05, 1.5, 0.1 }, { 0, 0.05, 0.5 } },
  { { 0, 0, 0 }, { 1.05, 1.5, 0.1 }, { 0, 0.05, 0.5 }, { 2, 0, 0 } },
  { { 0, 0.1, 1 }, { 0.05, 1.5, 0.1 }, { 0.1, 3, 0.2 }, { 1, 0.05, 0.5 } },
  { { 0, 0.1, 1 }, { 0.05, 1.5, 0.1 }, { 1, 0.05, 0.5 }, { 0, 0.05, 0.5 } },
  { { 1, 0.05, 0.5 }, { 0, 0, 0 }, { 0, 0.05, 0.5 }, { 0.05, 1.5, 0.1 } },
  { { 1, 0.05, 0.5 }, { 0, 0, 0 }, { 0.05, 1.5, 0.1 }, { 2, 0, 0 } },
  { { 2, 0, 0 }, { 0.05, 1.5, 0.1 }, { 1, 0.05, 0.5 }, { 0.1, 3, 0.2 } },
  { { 1, 0, 0 }, { 0, 0.1, 1 }, { 0.05, 1.55, 0.6 }, { 0, 0.05, 0.5 } },
  { { 1, 0, 0 }, { 0, 0.1, 1 }, { 2, 0, 0 }, { 0.05, 1.55, 0.6 } },
  { { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 1, 0, 0 }, { 0, 0.05, 0.5 } },
  { { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 0.1, 3, 0.2 }, { 1, 0, 0 } },
  { { 0.1, 3, 0.2 }, { 2, 0, 0 }, { 0.05, 1.55, 0.6 }, { 1, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 1, 0.05, 0.5 }, { 0, 0.05, 0.5 }, { 0, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 1, 0.05, 0.5 }, { 0, 0, 0 }, { 2, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 0.1, 3, 0.2 }, { 0, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 0, 0.05, 0.5 } },
  { { 0.05, 1.55, 0.6 }, { 0, 0.05, 0.5 }, { 1, 0.05, 0.5 }, { 0, 0.1, 1 } },
  { { 0.05, 1.55, 0.6 }, { 1, 0.05, 0.5 }, { 0, 0.05, 0.5 }, { 1.05, 1.5, 0.1 } },
  { { 1, 0.05, 0.5 }, { 0.05, 1.55, 0.6 }, { 0.05, 1.5, 0.1 }, { 0, 0, 0 } },
  { { 1, 0.05, 0.5 }, { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 0, 0.1, 1 } },
  { { 1, 0.05, 0.5 }, { 1.05, 1.5, 0.1 }, { 2, 0, 0 }, { 0, 0, 0 } },
  { { 1, 0.05, 0.5 }, { 1.05, 1.5, 0.1 }, { 0, 0, 0 }, { 0.05, 1.5, 0.1 } },
  { { 1.05, 1.5, 0.1 }, { 0.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 0.1, 3, 0.2 } },
  { { 1.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 0.05, 1.5, 0.1 }, { 1, 0.05, 0.5 } },
  { { 0.05, 1.55, 0.6 }, { 1.05, 1.5, 0.1 }, { 1, 0, 0 }, { 0, 0, 0 } },
  { { 0.05, 1.55, 0.6 }, { 1.05, 1.5, 0.1 }, { 0, 0, 0 }, { 0.1, 3, 0.2 } },
  { { 0.05, 1.55, 0.6 }, { 1, 0.05, 0.5 }, { 0, 0.1, 1 }, { 0, 0, 0 } },
  { { 0.05, 1.55, 0.6 }, { 1, 0.05, 0.5 }, { 0, 0, 0 }, { 1, 0, 0 } },
  { { 1, 0.05, 0.5 }, { 1, 0, 0 }, { 1.05, 1.5, 0.1 }, { 2, 0, 0 } },
  { { 1, 0.05, 0.5 }, { 1.05, 1.5, 0.1 }, { 1, 0, 0 }, { 0.05, 1.55, 0.6 } },
  { { 1, 0.05, 0.5 }, { 0, 0, 0 }, { 0.05, 1.5, 0.1 }, { 2, 0, 0 } },
  { { 1, 0.05, 0.5 }, { 0, 0, 0 }, { 0, 0.05, 0.5 }, { 0.05, 1.5, 0.1 } },
  { { 0.05, 1.55, 0.6 }, { 2, 0, 0 }, { 0.05, 1.5, 0.1 }, { 0.1, 3, 0.2 } },
  { { 0.05, 1.55, 0.6 }, { 2, 0, 0 }, { 1, 0.05, 0.5 }, { 0.05, 1.5, 0.1 } },
  { { 0, 0.05, 0.5 }, { 1, 0.05, 0.5 }, { 0.05, 1.55, 0.6 }, { 0, 0.1, 1 } },
  { { 0, 0.05, 0.5 }, { 0.05, 1.55, 0.6 }, { 1, 0.05, 0.5 }, { 0.05, 1.5, 0.1 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 0, 0.05, 0.5 }, { 2, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 0.05, 1.55, 0.6 }, { 0, 0.05, 0.5 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0, 0 }, { 0, 0.05, 0.5 }, { 0.05, 1.5, 0.1 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0, 0 }, { 2, 0, 0 }, { 0, 0.05, 0.5 } },
  { { 0.05, 1.55, 0.6 }, { 1.05, 1.5, 0.1 }, { 0.05, 1.5, 0.1 }, { 0.1, 3, 0.2 } },
  { { 0.05, 1.55, 0.6 }, { 0.05, 1.5, 0.1 }, { 1.05, 1.5, 0.1 }, { 0, 0.05, 0.5 } },
  { { 0, 0.1, 1 }, { 1, 0, 0 }, { 0.05, 1.55, 0.6 }, { 2, 0, 0 } },
  { { 0, 0.1, 1 }, { 1, 0, 0 }, { 0, 0.05, 0.5 }, { 0.05, 1.55, 0.6 } },
  { { 2, 0, 0 }, { 0.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 0.1, 3, 0.2 } },
  { { 2, 0, 0 }, { 0.05, 1.5, 0.1 }, { 1, 0, 0 }, { 0.05, 1.55, 0.6 } },
  { { 0.05, 1.5, 0.1 }, { 1, 0, 0 }, { 0, 0.05, 0.5 }, { 0, 0, 0 } },
  { { 0.05, 1.5, 0.1 }, { 0, 0.05, 0.5 }, { 1, 0, 0 }, { 0.05, 1.55, 0.6 } },
  { { 0.05, 1.55, 0.6 }, { 2, 0, 0 }, { 1, 0, 0 }, { 0.1, 3, 0.2 } },
  { { 0.05, 1.55, 0.6 }, { 2, 0, 0 }, { 1, 0.05, 0.5 }, { 1, 0, 0 } },
  { { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 1, 0, 0 }, { 0, 0.05, 0.5 } },
  { { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 0.1, 3, 0.2 }, { 1, 0, 0 } },
  { { 1, 0.05, 0.5 }, { 0.05, 1.55, 0.6 }, { 0, 0.05, 0.5 }, { 0, 0.1, 1 } },
  { { 1, 0.05, 0.5 }, { 0, 0.05, 0.5 }, { 0.05, 1.55, 0.6 }, { 1, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0, 0 }, { 0, 0.05, 0.5 }, { 0.1, 3, 0.2 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0, 0 }, { 1, 0, 0 }, { 0, 0.05, 0.5 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 0, 0.05, 0.5 }, { 1, 0.05, 0.5 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 0.1, 3, 0.2 }, { 0, 0.05, 0.5 } },
  { { 1, 0, 0 }, { 1.05, 1.5, 0.1 }, { 1, 0.05, 0.5 }, { 2, 0, 0 } },
  { { 1, 0, 0 }, { 1, 0.05, 0.5 }, { 1.05, 1.5, 0.1 }, { 0, 0.05, 0.5 } },
  { { 0.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 1, 0.05, 0.5 }, { 0.1, 3, 0.2 } },
  { { 0.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 0, 0.05, 0.5 }, { 1, 0.05, 0.5 } },
  { { 0.05, 1.5, 0.1 }, { 2, 0, 0 }, { 1, 0.05, 0.5 }, { 1, 0, 0 } },
  { { 0.05, 1.5, 0.1 }, { 2, 0, 0 }, { 0.1, 3, 0.2 }, { 1, 0.05, 0.5 } },
  { { 0, 0.05, 0.5 }, { 0.05, 1.5, 0.1 }, { 1, 0, 0 }, { 0, 0, 0 } },
  { { 0, 0.05, 0.5 }, { 1, 0, 0 }, { 0.05, 1.5, 0.1 }, { 1, 0.05, 0.5 } },
  { { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 1, 0, 0 }, { 0, 0.1, 1 } },
  { { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 0.05, 1.5, 0.1 }, { 1, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 1, 0, 0 }, { 2, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 0.05, 1.55, 0.6 }, { 1, 0, 0 } },
  { { 0.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 1.05, 1.5, 0.1 }, { 0.1, 3, 0.2 } },
  { { 0.05, 1.5, 0.1 }, { 1.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 1, 0, 0 } },
  { { 0, 0, 0 }, { 1, 0.05, 0.5 }, { 0.05, 1.5, 0.1 }, { 0, 0.1, 1 } },
  { { 0, 0, 0 }, { 1, 0.05, 0.5 }, { 1, 0, 0 }, { 0.05, 1.5, 0.1 } },
  { { 0, 0.1, 1 }, { 1.05, 1.5, 0.1 }, { 0.05, 1.5, 0.1 }, { 0.1, 3, 0.2 } },
  { { 0, 0.1, 1 }, { 1.05, 1.5, 0.1 }, { 1, 0.05, 0.5 }, { 0.05, 1.5, 0.1 } },
  { { 1.05, 1.5, 0.1 }, { 1, 0.05, 0.5 }, { 1, 0, 0 }, { 2, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 1, 0, 0 }, { 1, 0.05, 0.5 }, { 0.05, 1.5, 0.1 } },
  { { 1.05, 1.5, 0.1 }, { 0.05, 1.5, 0.1 }, { 0, 0.05, 0.5 }, { 0, 0.1, 1 } },
  { { 1.05, 1.5, 0.1 }, { 0.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 0.1, 3, 0.2 } },
  { { 1.05, 1.5, 0.1 }, { 1, 0, 0 }, { 2, 0, 0 }, { 0, 0.1, 1 } },
  { { 1.05, 1.5, 0.1 }, { 1, 0, 0 }, { 0, 0.1, 1 }, { 0, 0.05, 0.5 } },
  { { 1, 0, 0 }, { 0, 0.05, 0.5 }, { 0.05, 1.5, 0.1 }, { 0, 0, 0 } },
  { { 1, 0, 0 }, { 0.05, 1.5, 0.1 }, { 0, 0.05, 0.5 }, { 1.05, 1.5, 0.1 } },
  { { 1, 0.05, 0.5 }, { 0.05, 1.5, 0.1 }, { 0, 0, 0 }, { 0, 0.05, 0.5 } },
  { { 1, 0.05, 0.5 }, { 0.05, 1.5, 0.1 }, { 1.05, 1.5, 0.1 }, { 0, 0, 0 } },
  { { 1, 0.05, 0.5 }, { 1.05, 1.5, 0.1 }, { 2, 0, 0 }, { 0, 0, 0 } },
  { { 0.05, 1.5, 0.1 }, { 1.05, 1.5, 0.1 }, { 0.1, 3, 0.2 }, { 0, 0.1, 1 } },
  { { 1, 0.05, 0.5 }, { 0.05, 1.5, 0.1 }, { 0, 0.05, 0.5 }, { 0, 0.1, 1 } },
  { { 1, 0.05, 0.5 }, { 0.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 1.05, 1.5, 0.1 } },
  { { 1, 0.05, 0.5 }, { 0.05, 1.5, 0.1 }, { 2, 0, 0 }, { 1, 0, 0 } },
  { { 1, 0.05, 0.5 }, { 0.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 2, 0, 0 } },
  { { 0.05, 1.55, 0.6 }, { 0.05, 1.5, 0.1 }, { 0.1, 3, 0.2 }, { 2, 0, 0 } },
  { { 0.05, 1.55, 0.6 }, { 1, 0.05, 0.5 }, { 0, 0.1, 1 }, { 0, 0, 0 } },
  { { 1, 0.05, 0.5 }, { 0.05, 1.5, 0.1 }, { 1, 0, 0 }, { 0, 0, 0 } },
  { { 1, 0.05, 0.5 }, { 0.05, 1.5, 0.1 }, { 0, 0, 0 }, { 0.05, 1.55, 0.6 } },
  { { 1, 0, 0 }, { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 0, 0.05, 0.5 } },
  { { 1, 0, 0 }, { 0.05, 1.55, 0.6 }, { 1.05, 1.5, 0.1 }, { 0, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 0.1, 3, 0.2 }, { 0, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 1, 0, 0 }, { 2, 0, 0 }, { 0, 0.1, 1 } },
  { { 1, 0, 0 }, { 0.05, 1.55, 0.6 }, { 0, 0.05, 0.5 }, { 0, 0.1, 1 } },
  { { 1, 0, 0 }, { 0.05, 1.55, 0.6 }, { 0, 0.1, 1 }, { 1.05, 1.5, 0.1 } },
  { { 0, 0, 0 }, { 1.05, 1.5, 0.1 }, { 0.05, 1.5, 0.1 }, { 0, 0.05, 0.5 } },
  { { 0, 0, 0 }, { 1.05, 1.5, 0.1 }, { 0, 0.05, 0.5 }, { 1, 0.05, 0.5 } },
  { { 0, 0, 0 }, { 1.05, 1.5, 0.1 }, { 1, 0.05, 0.5 }, { 2, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0.05, 0.5 }, { 0.05, 1.55, 0.6 }, { 0.05, 1.5, 0.1 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0.05, 0.5 }, { 1, 0.05, 0.5 }, { 0.05, 1.55, 0.6 } },
  { { 0, 0.05, 0.5 }, { 1, 0.05, 0.5 }, { 0.05, 1.55, 0.6 }, { 0, 0.1, 1 } },
  { { 0.05, 1.5, 0.1 }, { 1.05, 1.5, 0.1 }, { 0.1, 3, 0.2 }, { 0.05, 1.55, 0.6 } },
  { { 2, 0, 0 }, { 0.05, 1.5, 0.1 }, { 1, 0, 0 }, { 1, 0.05, 0.5 } },
  { { 2, 0, 0 }, { 0.05, 1.5, 0.1 }, { 1, 0.05, 0.5 }, { 0.05, 1.55, 0.6 } },
  { { 2, 0, 0 }, { 0.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 0.1, 3, 0.2 } },
  { { 0.05, 1.5, 0.1 }, { 1, 0.05, 0.5 }, { 0, 0.05, 0.5 }, { 1, 0, 0 } },
  { { 0.05, 1.5, 0.1 }, { 1, 0.05, 0.5 }, { 0.05, 1.55, 0.6 }, { 0, 0.05, 0.5 } },
  { { 1, 0.05, 0.5 }, { 0.05, 1.55, 0.6 }, { 0, 0.05, 0.5 }, { 0, 0.1, 1 } },
  { { 1, 0, 0 }, { 0.05, 1.5, 0.1 }, { 0, 0, 0 }, { 0, 0.05, 0.5 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0, 0 }, { 1, 0, 0 }, { 0, 0.05, 0.5 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0, 0 }, { 0, 0.05, 0.5 }, { 0.05, 1.55, 0.6 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0, 0 }, { 0.05, 1.55, 0.6 }, { 0.1, 3, 0.2 } },
  { { 0, 0.05, 0.5 }, { 1.05, 1.5, 0.1 }, { 1, 0.05, 0.5 }, { 1, 0, 0 } },
  { { 0, 0.05, 0.5 }, { 1.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 1, 0.05, 0.5 } },
  { { 0.05, 1.55, 0.6 }, { 0, 0.05, 0.5 }, { 1, 0.05, 0.5 }, { 0, 0.1, 1 } },
  { { 1.05, 1.5, 0.1 }, { 1, 0, 0 }, { 2, 0, 0 }, { 1, 0.05, 0.5 } },
  { { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 0.05, 1.5, 0.1 }, { 1, 0, 0 } },
  { { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 1, 0, 0 }, { 1, 0.05, 0.5 } },
  { { 0.05, 1.55, 0.6 }, { 0, 0, 0 }, { 1, 0.05, 0.5 }, { 0, 0.1, 1 } },
  { { 1, 0, 0 }, { 0.05, 1.55, 0.6 }, { 1.05, 1.5, 0.1 }, { 0.05, 1.5, 0.1 } },
  { { 1, 0, 0 }, { 0.05, 1.55, 0.6 }, { 1, 0.05, 0.5 }, { 1.05, 1.5, 0.1 } },
  { { 1, 0.05, 0.5 }, { 1, 0, 0 }, { 1.05, 1.5, 0.1 }, { 2, 0, 0 } },
  { { 0.05, 1.55, 0.6 }, { 0.05, 1.5, 0.1 }, { 0.1, 3, 0.2 }, { 1.05, 1.5, 0.1 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 0.05, 1.55, 0.6 }, { 0, 0.05, 0.5 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 0, 0.05, 0.5 }, { 1, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0.1, 1 }, { 1, 0, 0 }, { 2, 0, 0 } },
  { { 0, 0.05, 0.5 }, { 1.05, 1.5, 0.1 }, { 0.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 } },
  { { 0, 0.05, 0.5 }, { 1.05, 1.5, 0.1 }, { 1, 0, 0 }, { 0.05, 1.5, 0.1 } },
  { { 1, 0, 0 }, { 0, 0.05, 0.5 }, { 0.05, 1.5, 0.1 }, { 0, 0, 0 } },
  { { 1.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 0.1, 3, 0.2 }, { 0.05, 1.5, 0.1 } },
  { { 0, 0.1, 1 }, { 1.05, 1.5, 0.1 }, { 1, 0.05, 0.5 }, { 0, 0.05, 0.5 } },
  { { 0, 0.1, 1 }, { 1.05, 1.5, 0.1 }, { 0, 0.05, 0.5 }, { 0.05, 1.5, 0.1 } },
  { { 0, 0.1, 1 }, { 1.05, 1.5, 0.1 }, { 0.05, 1.5, 0.1 }, { 0.1, 3, 0.2 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0.05, 0.5 }, { 1, 0, 0 }, { 1, 0.05, 0.5 } },
  { { 1.05, 1.5, 0.1 }, { 0, 0.05, 0.5 }, { 0.05, 1.5, 0.1 }, { 1, 0, 0 } },
  { { 0, 0.05, 0.5 }, { 0.05, 1.5, 0.1 }, { 1, 0, 0 }, { 0, 0, 0 } },
  { { 1, 0.05, 0.5 }, { 1.05, 1.5, 0.1 }, { 2, 0, 0 }, { 1, 0, 0 } },
  { { 0.05, 1.5, 0.1 }, { 1, 0, 0 }, { 1.05, 1.5, 0.1 }, { 1, 0.05, 0.5 } },
  { { 0.05, 1.5, 0.1 }, { 1.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 1, 0.05, 0.5 } },
  { { 0.05, 1.5, 0.1 }, { 0.05, 1.55, 0.6 }, { 0, 0.05, 0.5 }, { 1, 0.05, 0.5 } },
  { { 0.05, 1.5, 0.1 }, { 0, 0.05, 0.5 }, { 1, 0, 0 }, { 1, 0.05, 0.5 } },
  { { 0, 0.05, 0.5 }, { 1, 0.05, 0.5 }, { 0.05, 1.55, 0.6 }, { 0, 0.1, 1 } },
  { { 0.05, 1.5, 0.1 }, { 1.05, 1.5, 0.1 }, { 0.1, 3, 0.2 }, { 0.05, 1.55, 0.6 } },
  { { 1, 0, 0 }, { 2, 0, 0 }, { 1.05, 1.5, 0.1 }, { 1, 0.05, 0.5 } },
  { { 0, 0, 0 }, { 1, 0, 0 }, { 0.05, 1.5, 0.1 }, { 0, 0.05, 0.5 } },
  { { 0, 0, 0 }, { 3, 0.2, 0.1 }, { 0.1, 1, 0 }, { 0, 0, 2 } },
  { { 0, 0, 0 }, { 1.5, 0.1, 0.05 }, { 0.1, 1, 0 }, { 0, 0, 2 } },
  { { 1.5, 0.1, 0.05 }, { 3, 0.2, 0.1 }, { 0.1, 1, 0 }, { 0, 0, 2 } },
  { { 3, 0.2, 0.1 }, { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 0, 0, 2 } },
  { { 1.55, 0.6, 0.05 }, { 0.1, 1, 0 }, { 0, 0, 0 }, { 0, 0, 2 } },
  { { 0.1, 1, 0 }, { 0.05, 0.5, 0 }, { 3, 0.2, 0.1 }, { 0, 0, 2 } },
  { { 0.05, 0.5, 0 }, { 0, 0, 0 }, { 3, 0.2, 0.1 }, { 0, 0, 2 } },
  { { 0, 0, 2 }, { 0, 0, 1 }, { 0.1, 1, 0 }, { 3, 0.2, 0.1 } },
  { { 0, 0, 1 }, { 0, 0, 0 }, { 0.1, 1, 0 }, { 3, 0.2, 0.1 } },
  { { 3, 0.2, 0.1 }, { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 }, { 0, 0, 0 } },
  { { 1.5, 0.1, 1.05 }, { 0, 0, 2 }, { 0.1, 1, 0 }, { 0, 0, 0 } },
  { { 0, 0, 2 }, { 0.05, 0.5, 1 }, { 3, 0.2, 0.1 }, { 0, 0, 0 } },
  { { 0.05, 0.5, 1 }, { 0.1, 1, 0 }, { 3, 0.2, 0.1 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 1.5, 0.1, 0.05 }, { 1.55, 0.6, 0.05 }, { 0, 0, 2 } },
  { { 0, 0, 0 }, { 1.55, 0.6, 0.05 }, { 0.1, 1, 0 }, { 0, 0, 2 } },
  { { 0, 0, 2 }, { 1.5, 0.1, 0.05 }, { 1.55, 0.6, 0.05 }, { 3, 0.2, 0.1 } },
  { { 0.1, 1, 0 }, { 0.05, 0.5, 0 }, { 1.5, 0.1, 0.05 }, { 0, 0, 2 } },
  { { 0.1, 1, 0 }, { 1.5, 0.1, 0.05 }, { 3, 0.2, 0.1 }, { 0, 0, 2 } },
  { { 0, 0, 2 }, { 0.05, 0.5, 0 }, { 1.5, 0.1, 0.05 }, { 0, 0, 0 } },
  { { 3, 0.2, 0.1 }, { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 0, 0, 2 } },
  { { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 0 }, { 0, 0, 0 }, { 0, 0, 2 } },
  { { 0, 0, 2 }, { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 0 }, { 0.1, 1, 0 } },
  { { 3, 0.2, 0.1 }, { 1.5, 0.1, 0.05 }, { 0, 0, 2 }, { 0.1, 1, 0 } },
  { { 1.5, 0.1, 0.05 }, { 0, 0, 1 }, { 0, 0, 2 }, { 0.1, 1, 0 } },
  { { 0.1, 1, 0 }, { 1.5, 0.1, 0.05 }, { 0, 0, 1 }, { 0, 0, 0 } },
  { { 0, 0, 2 }, { 1.5, 0.1, 1.05 }, { 0, 0, 0 }, { 0.1, 1, 0 } },
  { { 1.5, 0.1, 1.05 }, { 1.5, 0.1, 0.05 }, { 0, 0, 0 }, { 0.1, 1, 0 } },
  { { 0.1, 1, 0 }, { 1.5, 0.1, 1.05 }, { 1.5, 0.1, 0.05 }, { 3, 0.2, 0.1 } },
  { { 0, 0, 0 }, { 0, 0, 1 }, { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 } },
  { { 0, 0, 0 }, { 1.5, 0.1, 1.05 }, { 3, 0.2, 0.1 }, { 0.1, 1, 0 } },
  { { 0.1, 1, 0 }, { 0, 0, 1 }, { 1.5, 0.1, 1.05 }, { 0, 0, 2 } },
  { { 0.1, 1, 0 }, { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 1.05 }, { 0, 0, 0 } },
  { { 0.1, 1, 0 }, { 1.5, 0.1, 1.05 }, { 0, 0, 2 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 1.05 }, { 3, 0.2, 0.1 } },
  { { 0, 0, 2 }, { 0.05, 0.5, 1 }, { 1.55, 0.6, 0.05 }, { 0, 0, 0 } },
  { { 0, 0, 2 }, { 1.55, 0.6, 0.05 }, { 3, 0.2, 0.1 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0.05, 0.5, 1 }, { 1.55, 0.6, 0.05 }, { 0.1, 1, 0 } },
  { { 3, 0.2, 0.1 }, { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 }, { 0, 0, 0 } },
  { { 1.5, 0.1, 1.05 }, { 0.05, 0.5, 1 }, { 0.1, 1, 0 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 1.5, 0.1, 1.05 }, { 0.05, 0.5, 1 }, { 0, 0, 2 } },
  { { 0, 0, 2 }, { 0, 0, 1 }, { 0.1, 1, 0 }, { 3, 0.2, 0.1 } },
  { { 0, 0, 1 }, { 0.05, 0.5, 0 }, { 0.1, 1, 0 }, { 3, 0.2, 0.1 } },
  { { 3, 0.2, 0.1 }, { 0, 0, 1 }, { 0.05, 0.5, 0 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0.05, 0.5, 0 }, { 0.05, 0.5, 1 }, { 3, 0.2, 0.1 } },
  { { 0, 0, 0 }, { 0.05, 0.5, 1 }, { 0, 0, 2 }, { 3, 0.2, 0.1 } },
  { { 3, 0.2, 0.1 }, { 0.05, 0.5, 0 }, { 0.05, 0.5, 1 }, { 0.1, 1, 0 } },
  { { 0.1, 1, 0 }, { 0.05, 0.5, 1 }, { 0, 0, 0 }, { 3, 0.2, 0.1 } },
  { { 0.05, 0.5, 1 }, { 0, 0, 1 }, { 0, 0, 0 }, { 3, 0.2, 0.1 } },
  { { 3, 0.2, 0.1 }, { 0.05, 0.5, 1 }, { 0, 0, 1 }, { 0, 0, 2 } },
  { { 0, 0, 0 }, { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 1 }, { 0, 0, 2 } },
  { { 1.5, 0.1, 0.05 }, { 3, 0.2, 0.1 }, { 0.05, 0.5, 1 }, { 0, 0, 2 } },
  { { 0, 0, 0 }, { 1.5, 0.1, 0.05 }, { 0.1, 1, 0 }, { 0.05, 0.5, 1 } },
  { { 1.5, 0.1, 0.05 }, { 3, 0.2, 0.1 }, { 0.1, 1, 0 }, { 0.05, 0.5, 1 } },
  { { 3, 0.2, 0.1 }, { 1.55, 0.6, 0.05 }, { 0, 0, 1 }, { 0, 0, 2 } },
  { { 1.55, 0.6, 0.05 }, { 0.1, 1, 0 }, { 0, 0, 1 }, { 0, 0, 2 } },
  { { 3, 0.2, 0.1 }, { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 0, 0, 1 } },
  { { 1.55, 0.6, 0.05 }, { 0.1, 1, 0 }, { 0, 0, 0 }, { 0, 0, 1 } },
  { { 0.1, 1, 0 }, { 0.05, 0.5, 0 }, { 1.5, 0.1, 1.05 }, { 0, 0, 2 } },
  { { 0.05, 0.5, 0 }, { 0, 0, 0 }, { 1.5, 0.1, 1.05 }, { 0, 0, 2 } },
  { { 0.1, 1, 0 }, { 0.05, 0.5, 0 }, { 3, 0.2, 0.1 }, { 1.5, 0.1, 1.05 } },
  { { 0.05, 0.5, 0 }, { 0, 0, 0 }, { 3, 0.2, 0.1 }, { 1.5, 0.1, 1.05 } },
  { { 0.1, 1, 0 }, { 3, 0.2, 0.1 }, { 0, 0, 2 }, { 1.5, 0.1, 0.05 } },
  { { 0, 0, 1 }, { 1.5, 0.1, 0.05 }, { 0.1, 1, 0 }, { 0, 0, 2 } },
  { { 0, 0, 1 }, { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 0 }, { 0.1, 1, 0 } },
  { { 1.5, 0.1, 0.05 }, { 0, 0, 1 }, { 0.05, 0.5, 0 }, { 0, 0, 0 } },
  { { 0, 0, 2 }, { 0, 0, 0 }, { 0.1, 1, 0 }, { 1.5, 0.1, 1.05 } },
  { { 1.5, 0.1, 1.05 }, { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 0.1, 1, 0 } },
  { { 1.5, 0.1, 1.05 }, { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 0.05 }, { 0, 0, 0 } },
  { { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 1.05 }, { 1.5, 0.1, 0.05 }, { 3, 0.2, 0.1 } },
  { { 3, 0.2, 0.1 }, { 0, 0, 0 }, { 0, 0, 2 }, { 1.55, 0.6, 0.05 } },
  { { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 1 }, { 0, 0, 0 }, { 0, 0, 2 } },
  { { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 1 }, { 0.05, 0.5, 0 }, { 0, 0, 0 } },
  { { 0.05, 0.5, 0 }, { 0.05, 0.5, 1 }, { 1.55, 0.6, 0.05 }, { 0.1, 1, 0 } },
  { { 0, 0, 0 }, { 3, 0.2, 0.1 }, { 0.1, 1, 0 }, { 1.5, 0.1, 1.05 } },
  { { 0.05, 0.5, 1 }, { 1.5, 0.1, 1.05 }, { 0, 0, 0 }, { 0.1, 1, 0 } },
  { { 0.05, 0.5, 1 }, { 1.5, 0.1, 1.05 }, { 0, 0, 1 }, { 0, 0, 0 } },
  { { 0, 0, 1 }, { 1.5, 0.1, 1.05 }, { 0.05, 0.5, 1 }, { 0, 0, 2 } },
  { { 0, 0, 0 }, { 0, 0, 1 }, { 1.5, 0.1, 0.05 }, { 0.1, 1, 0 } },
  { { 1.5, 0.1, 0.05 }, { 0, 0, 1 }, { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 } },
  { { 1.5, 0.1, 0.05 }, { 1.5, 0.1, 1.05 }, { 3, 0.2, 0.1 }, { 0.1, 1, 0 } },
  { { 0, 0, 1 }, { 0, 0, 2 }, { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 } },
  { { 3, 0.2, 0.1 }, { 1.5, 0.1, 1.05 }, { 1.55, 0.6, 0.05 }, { 0, 0, 0 } },
  { { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 1.05 }, { 0.05, 0.5, 1 }, { 0, 0, 0 } },
  { { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 1 }, { 0.1, 1, 0 }, { 0, 0, 0 } },
  { { 1.5, 0.1, 1.05 }, { 0, 0, 2 }, { 0.05, 0.5, 1 }, { 0, 0, 0 } },
  { { 0, 0, 2 }, { 0, 0, 1 }, { 0.05, 0.5, 1 }, { 3, 0.2, 0.1 } },
  { { 0.05, 0.5, 1 }, { 0, 0, 1 }, { 0.05, 0.5, 0 }, { 3, 0.2, 0.1 } },
  { { 0.05, 0.5, 1 }, { 0.05, 0.5, 0 }, { 0.1, 1, 0 }, { 3, 0.2, 0.1 } },
  { { 0, 0, 1 }, { 0, 0, 0 }, { 0.05, 0.5, 0 }, { 3, 0.2, 0.1 } },
  { { 0, 0, 0 }, { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 0 }, { 0, 0, 2 } },
  { { 0.05, 0.5, 0 }, { 1.5, 0.1, 0.05 }, { 1.55, 0.6, 0.05 }, { 0, 0, 2 } },
  { { 0.05, 0.5, 0 }, { 1.55, 0.6, 0.05 }, { 0.1, 1, 0 }, { 0, 0, 2 } },
  { { 1.5, 0.1, 0.05 }, { 3, 0.2, 0.1 }, { 1.55, 0.6, 0.05 }, { 0, 0, 2 } },
  { { 1.5, 0.1, 1.05 }, { 0, 0, 0 }, { 0.05, 0.5, 0 }, { 1.5, 0.1, 0.05 } },
  { { 1.5, 0.1, 1.05 }, { 0, 0, 0 }, { 0, 0, 2 }, { 0.05, 0.5, 0 } },
  { { 1.5, 0.1, 0.05 }, { 0.1, 1, 0 }, { 1.5, 0.1, 1.05 }, { 3, 0.2, 0.1 } },
  { { 1.5, 0.1, 0.05 }, { 0.1, 1, 0 }, { 0.05, 0.5, 0 }, { 1.5, 0.1, 1.05 } },
  { { 0.1, 1, 0 }, { 0, 0, 2 }, { 0.05, 0.5, 0 }, { 1.5, 0.1, 1.05 } },
  { { 0, 0, 0 }, { 1.55, 0.6, 0.05 }, { 0.1, 1, 0 }, { 0, 0, 1 } },
  { { 0, 0, 0 }, { 1.55, 0.6, 0.05 }, { 0, 0, 1 }, { 1.5, 0.1, 0.05 } },
  { { 1.5, 0.1, 0.05 }, { 0, 0, 2 }, { 3, 0.2, 0.1 }, { 1.55, 0.6, 0.05 } },
  { { 1.5, 0.1, 0.05 }, { 0, 0, 2 }, { 1.55, 0.6, 0.05 }, { 0, 0, 1 } },
  { { 0, 0, 2 }, { 1.55, 0.6, 0.05 }, { 0, 0, 1 }, { 0.1, 1, 0 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 2 }, { 1.5, 0.1, 0.05 }, { 3, 0.2, 0.1 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 2 }, { 0.05, 0.5, 1 }, { 1.5, 0.1, 0.05 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 0.05, 0.5, 1 }, { 0.1, 1, 0 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 1 } },
  { { 0, 0, 0 }, { 0, 0, 2 }, { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 1 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 1.5, 0.1, 1.05 }, { 0.05, 0.5, 0 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 3, 0.2, 0.1 }, { 1.5, 0.1, 1.05 } },
  { { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 }, { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 0 } },
  { { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 }, { 0.05, 0.5, 0 }, { 0, 0, 2 } },
  { { 0, 0, 2 }, { 0.05, 0.5, 0 }, { 1.5, 0.1, 1.05 }, { 0, 0, 0 } },
  { { 0.1, 1, 0 }, { 1.5, 0.1, 0.05 }, { 3, 0.2, 0.1 }, { 0.05, 0.5, 1 } },
  { { 0.1, 1, 0 }, { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 1 }, { 0.05, 0.5, 0 } },
  { { 0.05, 0.5, 1 }, { 0, 0, 0 }, { 0.05, 0.5, 0 }, { 1.5, 0.1, 0.05 } },
  { { 0.05, 0.5, 1 }, { 0, 0, 0 }, { 1.5, 0.1, 0.05 }, { 0, 0, 2 } },
  { { 0, 0, 2 }, { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 1 }, { 3, 0.2, 0.1 } },
  { { 0, 0, 1 }, { 0.1, 1, 0 }, { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 0 } },
  { { 0, 0, 1 }, { 0.1, 1, 0 }, { 0, 0, 2 }, { 1.55, 0.6, 0.05 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 0, 0, 1 }, { 0.05, 0.5, 0 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 3, 0.2, 0.1 }, { 0, 0, 1 } },
  { { 3, 0.2, 0.1 }, { 0, 0, 2 }, { 1.55, 0.6, 0.05 }, { 0, 0, 1 } },
  { { 1.5, 0.1, 1.05 }, { 0, 0, 0 }, { 0.05, 0.5, 1 }, { 1.5, 0.1, 0.05 } },
  { { 1.5, 0.1, 1.05 }, { 0, 0, 0 }, { 0, 0, 2 }, { 0.05, 0.5, 1 } },
  { { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 }, { 3, 0.2, 0.1 }, { 1.5, 0.1, 0.05 } },
  { { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 }, { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 1 } },
  { { 0.1, 1, 0 }, { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 1 }, { 0, 0, 0 } },
  { { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 }, { 0, 0, 1 }, { 0, 0, 2 } },
  { { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 }, { 1.55, 0.6, 0.05 }, { 0, 0, 1 } },
  { { 1.5, 0.1, 1.05 }, { 0, 0, 0 }, { 1.55, 0.6, 0.05 }, { 3, 0.2, 0.1 } },
  { { 1.5, 0.1, 1.05 }, { 0, 0, 0 }, { 0, 0, 1 }, { 1.55, 0.6, 0.05 } },
  { { 0, 0, 0 }, { 0.1, 1, 0 }, { 0, 0, 1 }, { 1.55, 0.6, 0.05 } },
  { { 0.05, 0.5, 1 }, { 0, 0, 0 }, { 1.5, 0.1, 1.05 }, { 0, 0, 2 } },
  { { 0.05, 0.5, 1 }, { 0, 0, 0 }, { 0.05, 0.5, 0 }, { 1.5, 0.1, 1.05 } },
  { { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 }, { 0.05, 0.5, 0 }, { 0.05, 0.5, 1 } },
  { { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 }, { 3, 0.2, 0.1 }, { 0.05, 0.5, 0 } },
  { { 3, 0.2, 0.1 }, { 0, 0, 0 }, { 1.5, 0.1, 1.05 }, { 0.05, 0.5, 0 } },
  { { 0, 0, 2 }, { 1.55, 0.6, 0.05 }, { 3, 0.2, 0.1 }, { 0, 0, 1 } },
  { { 0, 0, 2 }, { 1.55, 0.6, 0.05 }, { 0, 0, 1 }, { 0.05, 0.5, 1 } },
  { { 0.05, 0.5, 1 }, { 0, 0, 0 }, { 0.1, 1, 0 }, { 1.55, 0.6, 0.05 } },
  { { 0.05, 0.5, 1 }, { 0, 0, 0 }, { 1.55, 0.6, 0.05 }, { 0, 0, 1 } },
  { { 0, 0, 0 }, { 1.55, 0.6, 0.05 }, { 0, 0, 1 }, { 3, 0.2, 0.1 } },
  { { 0, 0, 1 }, { 0.1, 1, 0 }, { 1.5, 0.1, 1.05 }, { 0.05, 0.5, 0 } },
  { { 0, 0, 1 }, { 0.1, 1, 0 }, { 0, 0, 2 }, { 1.5, 0.1, 1.05 } },
  { { 1.5, 0.1, 1.05 }, { 0, 0, 0 }, { 0, 0, 1 }, { 0.05, 0.5, 0 } },
  { { 1.5, 0.1, 1.05 }, { 0, 0, 0 }, { 0.05, 0.5, 0 }, { 3, 0.2, 0.1 } },
  { { 3, 0.2, 0.1 }, { 0.05, 0.5, 0 }, { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 } },
  { { 1.5, 0.1, 0.05 }, { 0, 0, 2 }, { 0.05, 0.5, 1 }, { 0, 0, 1 } },
  { { 1.5, 0.1, 0.05 }, { 0, 0, 2 }, { 3, 0.2, 0.1 }, { 0.05, 0.5, 1 } },
  { { 0.05, 0.5, 1 }, { 0, 0, 0 }, { 1.5, 0.1, 0.05 }, { 0, 0, 1 } },
  { { 0.05, 0.5, 1 }, { 0, 0, 0 }, { 0.1, 1, 0 }, { 1.5, 0.1, 0.05 } },
  { { 0.1, 1, 0 }, { 3, 0.2, 0.1 }, { 0.05, 0.5, 1 }, { 1.5, 0.1, 0.05 } },
  { { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 1.05 }, { 0, 0, 1 }, { 0, 0, 0 } },
  { { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 1.05 }, { 0, 0, 0 }, { 3, 0.2, 0.1 } },
  { { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 1 }, { 0.1, 1, 0 }, { 0, 0, 0 } },
  { { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 1 }, { 0, 0, 0 }, { 0, 0, 1 } },
  { { 0.05, 0.5, 1 }, { 0, 0, 1 }, { 1.5, 0.1, 1.05 }, { 0, 0, 2 } },
  { { 0.05, 0.5, 1 }, { 1.5, 0.1, 1.05 }, { 0, 0, 1 }, { 1.55, 0.6, 0.05 } },
  { { 1.5, 0.1, 1.05 }, { 0.05, 0.5, 1 }, { 0.05, 0.5, 0 }, { 0, 0, 0 } },
  { { 1.5, 0.1, 1.05 }, { 0.05, 0.5, 1 }, { 0, 0, 0 }, { 0, 0, 2 } },
  { { 1.5, 0.1, 1.05 }, { 1.55, 0.6, 0.05 }, { 3, 0.2, 0.1 }, { 0, 0, 0 } },
  { { 1.5, 0.1, 1.05 }, { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 0.05, 0.5, 0 } },
  { { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 0 }, { 0.05, 0.5, 1 }, { 0.1, 1, 0 } },
  { { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 1 }, { 0.05, 0.5, 0 }, { 1.5, 0.1, 1.05 } },
  { { 0.05, 0.5, 1 }, { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 0.05 }, { 0, 0, 0 } },
  { { 0.05, 0.5, 1 }, { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 0.1, 1, 0 } },
  { { 0.05, 0.5, 1 }, { 1.5, 0.1, 1.05 }, { 0, 0, 2 }, { 0, 0, 0 } },
  { { 0.05, 0.5, 1 }, { 1.5, 0.1, 1.05 }, { 0, 0, 0 }, { 1.5, 0.1, 0.05 } },
  { { 1.5, 0.1, 1.05 }, { 1.5, 0.1, 0.05 }, { 1.55, 0.6, 0.05 }, { 3, 0.2, 0.1 } },
  { { 1.5, 0.1, 1.05 }, { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 1 } },
  { { 1.5, 0.1, 1.05 }, { 0, 0, 0 }, { 0.05, 0.5, 0 }, { 3, 0.2, 0.1 } },
  { { 1.5, 0.1, 1.05 }, { 0, 0, 0 }, { 0, 0, 1 }, { 0.05, 0.5, 0 } },
  { { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 }, { 0.05, 0.5, 0 }, { 0.05, 0.5, 1 } },
  { { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 }, { 3, 0.2, 0.1 }, { 0.05, 0.5, 0 } },
  { { 0, 0, 1 }, { 1.5, 0.1, 1.05 }, { 0.05, 0.5, 1 }, { 0, 0, 2 } },
  { { 0, 0, 1 }, { 0.05, 0.5, 1 }, { 1.5, 0.1, 1.05 }, { 0.05, 0.5, 0 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 2 }, { 0, 0, 1 }, { 3, 0.2, 0.1 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 2 }, { 0.05, 0.5, 1 }, { 0, 0, 1 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 0, 0, 1 }, { 0.05, 0.5, 0 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 3, 0.2, 0.1 }, { 0, 0, 1 } },
  { { 0.05, 0.5, 1 }, { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 0 }, { 0.1, 1, 0 } },
  { { 0.05, 0.5, 1 }, { 0.05, 0.5, 0 }, { 1.55, 0.6, 0.05 }, { 0, 0, 1 } },
  { { 1.5, 0.1, 0.05 }, { 0.1, 1, 0 }, { 0.05, 0.5, 1 }, { 3, 0.2, 0.1 } },
  { { 1.5, 0.1, 0.05 }, { 0.1, 1, 0 }, { 0.05, 0.5, 0 }, { 0.05, 0.5, 1 } },
  { { 1.5, 0.1, 0.05 }, { 0, 0, 2 }, { 0.05, 0.5, 1 }, { 0, 0, 1 } },
  { { 1.5, 0.1, 0.05 }, { 0, 0, 2 }, { 3, 0.2, 0.1 }, { 0.05, 0.5, 1 } },
  { { 0.05, 0.5, 0 }, { 1.5, 0.1, 0.05 }, { 0, 0, 1 }, { 0, 0, 0 } },
  { { 0.05, 0.5, 0 }, { 0, 0, 1 }, { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 1 } },
  { { 0, 0, 0 }, { 0.05, 0.5, 1 }, { 1.5, 0.1, 0.05 }, { 0.1, 1, 0 } },
  { { 0, 0, 0 }, { 0.05, 0.5, 1 }, { 0, 0, 1 }, { 1.5, 0.1, 0.05 } },
  { { 0.1, 1, 0 }, { 1.5, 0.1, 1.05 }, { 1.5, 0.1, 0.05 }, { 3, 0.2, 0.1 } },
  { { 0.1, 1, 0 }, { 1.5, 0.1, 1.05 }, { 0.05, 0.5, 1 }, { 1.5, 0.1, 0.05 } },
  { { 1.5, 0.1, 1.05 }, { 0.05, 0.5, 1 }, { 0, 0, 1 }, { 0, 0, 2 } },
  { { 1.5, 0.1, 1.05 }, { 0, 0, 1 }, { 0.05, 0.5, 1 }, { 1.5, 0.1, 0.05 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 0, 0, 1 }, { 0.1, 1, 0 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 1.5, 0.1, 0.05 }, { 0, 0, 1 } },
  { { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 }, { 0, 0, 1 }, { 0, 0, 2 } },
  { { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 }, { 1.55, 0.6, 0.05 }, { 0, 0, 1 } },
  { { 1.5, 0.1, 0.05 }, { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 1.05 }, { 3, 0.2, 0.1 } },
  { { 1.5, 0.1, 0.05 }, { 1.5, 0.1, 1.05 }, { 1.55, 0.6, 0.05 }, { 0, 0, 1 } },
  { { 1.5, 0.1, 1.05 }, { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 0 }, { 0.1, 1, 0 } },
  { { 1.5, 0.1, 1.05 }, { 1.5, 0.1, 0.05 }, { 0.1, 1, 0 }, { 3, 0.2, 0.1 } },
  { { 1.5, 0.1, 1.05 }, { 0, 0, 1 }, { 0, 0, 2 }, { 0.1, 1, 0 } },
  { { 1.5, 0.1, 1.05 }, { 0, 0, 1 }, { 0.1, 1, 0 }, { 0.05, 0.5, 0 } },
  { { 0, 0, 1 }, { 0.05, 0.5, 0 }, { 1.5, 0.1, 0.05 }, { 0, 0, 0 } },
  { { 0, 0, 1 }, { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 0 }, { 1.5, 0.1, 1.05 } },
  { { 0.05, 0.5, 1 }, { 0, 0, 0 }, { 1.5, 0.1, 0.05 }, { 0, 0, 2 } },
  { { 0.05, 0.5, 1 }, { 0, 0, 0 }, { 0.05, 0.5, 0 }, { 1.5, 0.1, 0.05 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 2 }, { 1.5, 0.1, 0.05 }, { 3, 0.2, 0.1 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 2 }, { 0.05, 0.5, 1 }, { 1.5, 0.1, 0.05 } },
  { { 0.05, 0.5, 0 }, { 0.05, 0.5, 1 }, { 1.55, 0.6, 0.05 }, { 0.1, 1, 0 } },
  { { 0.05, 0.5, 0 }, { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 1 }, { 1.5, 0.1, 0.05 } },
  { { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 }, { 0.05, 0.5, 0 }, { 0, 0, 2 } },
  { { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 }, { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 0 } },
  { { 1.5, 0.1, 1.05 }, { 0, 0, 0 }, { 0.05, 0.5, 0 }, { 1.5, 0.1, 0.05 } },
  { { 1.5, 0.1, 1.05 }, { 0, 0, 0 }, { 0, 0, 2 }, { 0.05, 0.5, 0 } },
  { { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 1.05 }, { 1.5, 0.1, 0.05 }, { 3, 0.2, 0.1 } },
  { { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 0.05 }, { 1.5, 0.1, 1.05 }, { 0.05, 0.5, 0 } },
  { { 0.1, 1, 0 }, { 0, 0, 1 }, { 1.55, 0.6, 0.05 }, { 0, 0, 2 } },
  { { 0.1, 1, 0 }, { 0, 0, 1 }, { 0.05, 0.5, 0 }, { 1.55, 0.6, 0.05 } },
  { { 0, 0, 2 }, { 1.5, 0.1, 0.05 }, { 1.55, 0.6, 0.05 }, { 3, 0.2, 0.1 } },
  { { 0, 0, 2 }, { 1.5, 0.1, 0.05 }, { 0, 0, 1 }, { 1.55, 0.6, 0.05 } },
  { { 1.5, 0.1, 0.05 }, { 0, 0, 1 }, { 0.05, 0.5, 0 }, { 0, 0, 0 } },
  { { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 0 }, { 0, 0, 1 }, { 1.55, 0.6, 0.05 } },
  { { 0, 0, 1 }, { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 0.05, 0.5, 0 } },
  { { 0, 0, 1 }, { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 1.05 }, { 0, 0, 0 } },
  { { 1.5, 0.1, 1.05 }, { 1.55, 0.6, 0.05 }, { 3, 0.2, 0.1 }, { 0, 0, 0 } },
  { { 1.5, 0.1, 1.05 }, { 0, 0, 1 }, { 0, 0, 2 }, { 0.1, 1, 0 } },
  { { 0, 0, 1 }, { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 0 }, { 0.1, 1, 0 } },
  { { 0, 0, 1 }, { 1.55, 0.6, 0.05 }, { 0.1, 1, 0 }, { 1.5, 0.1, 1.05 } },
  { { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 1 }, { 0.1, 1, 0 }, { 0.05, 0.5, 0 } },
  { { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 1 }, { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 } },
  { { 1.5, 0.1, 0.05 }, { 1.5, 0.1, 1.05 }, { 3, 0.2, 0.1 }, { 0.1, 1, 0 } },
  { { 0.05, 0.5, 1 }, { 1.5, 0.1, 1.05 }, { 0, 0, 2 }, { 0, 0, 0 } },
  { { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 1 }, { 0.05, 0.5, 0 }, { 0, 0, 0 } },
  { { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 1 }, { 0, 0, 0 }, { 1.5, 0.1, 1.05 } },
  { { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 1 }, { 0, 0, 0 }, { 0, 0, 1 } },
  { { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 1 }, { 1.55, 0.6, 0.05 }, { 0, 0, 0 } },
  { { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 1 }, { 0.1, 1, 0 }, { 0, 0, 0 } },
  { { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 0.05 }, { 3, 0.2, 0.1 }, { 0, 0, 2 } },
  { { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 1 }, { 0, 0, 1 }, { 0, 0, 2 } },
  { { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 1 }, { 0, 0, 2 }, { 1.55, 0.6, 0.05 } },
  { { 0, 0, 0 }, { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 0 }, { 0, 0, 1 } },
  { { 0, 0, 0 }, { 1.55, 0.6, 0.05 }, { 0, 0, 1 }, { 1.5, 0.1, 1.05 } },
  { { 0, 0, 0 }, { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 1.05 }, { 3, 0.2, 0.1 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 1 }, { 0.05, 0.5, 1 }, { 0.05, 0.5, 0 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 1 }, { 1.5, 0.1, 1.05 }, { 0.05, 0.5, 1 } },
  { { 0, 0, 1 }, { 1.5, 0.1, 1.05 }, { 0.05, 0.5, 1 }, { 0, 0, 2 } },
  { { 0.05, 0.5, 0 }, { 1.55, 0.6, 0.05 }, { 0.1, 1, 0 }, { 0.05, 0.5, 1 } },
  { { 1.5, 0.1, 0.05 }, { 0.1, 1, 0 }, { 0.05, 0.5, 0 }, { 0.05, 0.5, 1 } },
  { { 1.5, 0.1, 0.05 }, { 0.1, 1, 0 }, { 0.05, 0.5, 1 }, { 1.5, 0.1, 1.05 } },
  { { 1.5, 0.1, 0.05 }, { 0.1, 1, 0 }, { 1.5, 0.1, 1.05 }, { 3, 0.2, 0.1 } },
  { { 0.05, 0.5, 1 }, { 1.5, 0.1, 0.05 }, { 0, 0, 1 }, { 0.05, 0.5, 0 } },
  { { 0.05, 0.5, 1 }, { 1.5, 0.1, 0.05 }, { 1.5, 0.1, 1.05 }, { 0, 0, 1 } },
  { { 1.5, 0.1, 1.05 }, { 0.05, 0.5, 1 }, { 0, 0, 1 }, { 0, 0, 2 } },
  { { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 0 }, { 0, 0, 0 }, { 0, 0, 1 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 1.5, 0.1, 0.05 }, { 0, 0, 1 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 0, 0, 1 }, { 0.05, 0.5, 1 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 0 }, { 0.05, 0.5, 1 }, { 0.1, 1, 0 } },
  { { 0, 0, 1 }, { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 1.05 }, { 1.5, 0.1, 0.05 } },
  { { 0, 0, 1 }, { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 1 }, { 1.5, 0.1, 1.05 } },
  { { 0.05, 0.5, 1 }, { 0, 0, 1 }, { 1.5, 0.1, 1.05 }, { 0, 0, 2 } },
  { { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 0.05 }, { 3, 0.2, 0.1 }, { 1.5, 0.1, 1.05 } },
  { { 0.05, 0.5, 1 }, { 0, 0, 0 }, { 0.05, 0.5, 0 }, { 1.5, 0.1, 0.05 } },
  { { 0.05, 0.5, 1 }, { 0, 0, 0 }, { 1.5, 0.1, 0.05 }, { 1.5, 0.1, 1.05 } },
  { { 0.05, 0.5, 1 }, { 0, 0, 0 }, { 1.5, 0.1, 1.05 }, { 0, 0, 2 } },
  { { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 1 }, { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 0 } },
  { { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 1 }, { 1.5, 0.1, 1.05 }, { 1.55, 0.6, 0.05 } },
  { { 1.5, 0.1, 1.05 }, { 1.5, 0.1, 0.05 }, { 1.55, 0.6, 0.05 }, { 3, 0.2, 0.1 } },
  { { 0.05, 0.5, 1 }, { 0.05, 0.5, 0 }, { 0.1, 1, 0 }, { 1.55, 0.6, 0.05 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 2 }, { 0.05, 0.5, 1 }, { 0, 0, 1 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 2 }, { 0, 0, 1 }, { 1.5, 0.1, 0.05 } },
  { { 1.55, 0.6, 0.05 }, { 0, 0, 2 }, { 1.5, 0.1, 0.05 }, { 3, 0.2, 0.1 } },
  { { 0, 0, 1 }, { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 0 }, { 0.05, 0.5, 1 } },
  { { 0, 0, 1 }, { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 0 } },
  { { 1.5, 0.1, 0.05 }, { 0, 0, 1 }, { 0.05, 0.5, 0 }, { 0, 0, 0 } },
  { { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 1 }, { 0.1, 1, 0 }, { 0.05, 0.5, 0 } },
  { { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 }, { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 0 } },
  { { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 }, { 0.05, 0.5, 0 }, { 0, 0, 1 } },
  { { 1.5, 0.1, 1.05 }, { 0.1, 1, 0 }, { 0, 0, 1 }, { 0, 0, 2 } },
  { { 0.05, 0.5, 0 }, { 1.5, 0.1, 1.05 }, { 1.5, 0.1, 0.05 }, { 1.55, 0.6, 0.05 } },
  { { 0.05, 0.5, 0 }, { 1.5, 0.1, 1.05 }, { 0, 0, 1 }, { 1.5, 0.1, 0.05 } },
  { { 0, 0, 1 }, { 0.05, 0.5, 0 }, { 1.5, 0.1, 0.05 }, { 0, 0, 0 } },
  { { 1.5, 0.1, 1.05 }, { 1.55, 0.6, 0.05 }, { 3, 0.2, 0.1 }, { 1.5, 0.1, 0.05 } },
  { { 0.05, 0.5, 0 }, { 1.5, 0.1, 0.05 }, { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 1.05 } },
  { { 0.05, 0.5, 0 }, { 1.55, 0.6, 0.05 }, { 0.05, 0.5, 1 }, { 1.5, 0.1, 1.05 } },
  { { 0.05, 0.5, 0 }, { 0.05, 0.5, 1 }, { 0, 0, 1 }, { 1.5, 0.1, 1.05 } },
  { { 0.05, 0.5, 0 }, { 0, 0, 1 }, { 1.5, 0.1, 0.05 }, { 1.5, 0.1, 1.05 } },
  { { 0, 0, 1 }, { 1.5, 0.1, 1.05 }, { 0.05, 0.5, 1 }, { 0, 0, 2 } },
  { { 0.05, 0.5, 0 }, { 1.55, 0.6, 0.05 }, { 0.1, 1, 0 }, { 0.05, 0.5, 1 } },
  { { 1.5, 0.1, 0.05 }, { 3, 0.2, 0.1 }, { 1.55, 0.6, 0.05 }, { 1.5, 0.1, 1.05 } },
  { { 0, 0, 0 }, { 1.5, 0.1, 0.05 }, { 0.05, 0.5, 0 }, { 0, 0, 1 } },
  { { 0, 0, 0 }, { 1, 0.1, 0 }, { 0.2, 3, 0.1 }, { 0, 0, 2 } },
  { { 0, 0, 0 }, { 0.5, 0.05, 0 }, { 0.2, 3, 0.1 }, { 0, 0, 2 } },
  { { 0.5, 0.05, 0 }, { 1, 0.1, 0 }, { 0.2, 3, 0.1 }, { 0, 0, 2 } },
  { { 1, 0.1, 0 }, { 0.6, 1.55, 0.05 }, { 0, 0, 0 }, { 0, 0, 2 } },
  { { 0.6, 1.55, 0.05 }, { 0.2, 3, 0.1 }, { 0, 0, 0 }, { 0, 0, 2 } },
  { { 0.2, 3, 0.1 }, { 0.1, 1.5, 0.05 }, { 1, 0.1, 0 }, { 0, 0, 2 } },
  { { 0.1, 1.5, 0.05 }, { 0, 0, 0 }, { 1, 0.1, 0 }, { 0, 0, 2 } },
  { { 0, 0, 2 }, { 0, 0, 1 }, { 0.2, 3, 0.1 }, { 1, 0.1, 0 } },
  { { 0, 0, 1 }, { 0, 0, 0 }, { 0.2, 3, 0.1 }, { 1, 0.1, 0 } },
  { { 1, 0.1, 0 }, { 0.5, 0.05, 1 }, { 0.2, 3, 0.1 }, { 0, 0, 0 } },
  { { 0.5, 0.05, 1 }, { 0, 0, 2 }, { 0.2, 3, 0.1 }, { 0, 0, 0 } },
  { { 0, 0, 2 }, { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 }, { 0, 0, 0 } },
  { { 0.1, 1.5, 1.05 }, { 0.2, 3, 0.1 }, { 1, 0.1, 0 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0.5, 0.05, 0 }, { 0.6, 1.55, 0.05 }, { 0, 0, 2 } },
  { { 0, 0, 0 }, { 0.6, 1.55, 0.05 }, { 0.2, 3, 0.1 }, { 0, 0, 2 } },
  { { 0, 0, 2 }, { 0.5, 0.05, 0 }, { 0.6, 1.55, 0.05 }, { 1, 0.1, 0 } },
  { { 0.2, 3, 0.1 }, { 0.1, 1.5, 0.05 }, { 1, 0.1, 0 }, { 0, 0, 2 } },
  { { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 0 }, { 1, 0.1, 0 }, { 0, 0, 2 } },
  { { 0, 0, 2 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 0 }, { 0, 0, 0 } },
  { { 1, 0.1, 0 }, { 0.6, 1.55, 0.05 }, { 0, 0, 0 }, { 0, 0, 2 } },
  { { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 0.05 }, { 0, 0, 0 }, { 0, 0, 2 } },
  { { 0, 0, 2 }, { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 0.05 }, { 0.2, 3, 0.1 } },
  { { 1, 0.1, 0 }, { 0.5, 0.05, 0 }, { 0, 0, 1 }, { 0.2, 3, 0.1 } },
  { { 1, 0.1, 0 }, { 0, 0, 1 }, { 0, 0, 2 }, { 0.2, 3, 0.1 } },
  { { 0.2, 3, 0.1 }, { 0.5, 0.05, 0 }, { 0, 0, 1 }, { 0, 0, 0 } },
  { { 0, 0, 2 }, { 0.5, 0.05, 1 }, { 0, 0, 0 }, { 0.2, 3, 0.1 } },
  { { 0.5, 0.05, 1 }, { 0.5, 0.05, 0 }, { 0, 0, 0 }, { 0.2, 3, 0.1 } },
  { { 0.2, 3, 0.1 }, { 0.5, 0.05, 1 }, { 0.5, 0.05, 0 }, { 1, 0.1, 0 } },
  { { 0, 0, 0 }, { 0, 0, 1 }, { 0.5, 0.05, 1 }, { 0.2, 3, 0.1 } },
  { { 0, 0, 0 }, { 0.5, 0.05, 1 }, { 1, 0.1, 0 }, { 0.2, 3, 0.1 } },
  { { 0.2, 3, 0.1 }, { 0, 0, 1 }, { 0.5, 0.05, 1 }, { 0, 0, 2 } },
  { { 0.2, 3, 0.1 }, { 0.6, 1.55, 0.05 }, { 0, 0, 2 }, { 0, 0, 0 } },
  { { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 1 }, { 0, 0, 2 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 1 }, { 1, 0.1, 0 } },
  { { 0, 0, 2 }, { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 }, { 0, 0, 0 } },
  { { 0.1, 1.5, 1.05 }, { 0.6, 1.55, 0.05 }, { 1, 0.1, 0 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0.1, 1.5, 1.05 }, { 0.6, 1.55, 0.05 }, { 0.2, 3, 0.1 } },
  { { 1, 0.1, 0 }, { 0.5, 0.05, 1 }, { 0.1, 1.5, 1.05 }, { 0, 0, 0 } },
  { { 1, 0.1, 0 }, { 0.1, 1.5, 1.05 }, { 0.2, 3, 0.1 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0.5, 0.05, 1 }, { 0.1, 1.5, 1.05 }, { 0, 0, 2 } },
  { { 0, 0, 2 }, { 0, 0, 1 }, { 0.1, 1.5, 0.05 }, { 1, 0.1, 0 } },
  { { 0, 0, 2 }, { 0.1, 1.5, 0.05 }, { 0.2, 3, 0.1 }, { 1, 0.1, 0 } },
  { { 1, 0.1, 0 }, { 0, 0, 1 }, { 0.1, 1.5, 0.05 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0.1, 1.5, 0.05 }, { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 } },
  { { 0, 0, 0 }, { 0.1, 1.5, 1.05 }, { 0, 0, 2 }, { 1, 0.1, 0 } },
  { { 1, 0.1, 0 }, { 0.1, 1.5, 0.05 }, { 0.1, 1.5, 1.05 }, { 0.2, 3, 0.1 } },
  { { 0.2, 3, 0.1 }, { 0.1, 1.5, 1.05 }, { 0, 0, 0 }, { 1, 0.1, 0 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 1 }, { 0, 0, 0 }, { 1, 0.1, 0 } },
  { { 1, 0.1, 0 }, { 0.1, 1.5, 1.05 }, { 0, 0, 1 }, { 0, 0, 2 } },
  { { 0, 0, 0 }, { 0.5, 0.05, 0 }, { 0.1, 1.5, 1.05 }, { 0, 0, 2 } },
  { { 0.5, 0.05, 0 }, { 1, 0.1, 0 }, { 0.1, 1.5, 1.05 }, { 0, 0, 2 } },
  { { 0, 0, 0 }, { 0.5, 0.05, 0 }, { 0.2, 3, 0.1 }, { 0.1, 1.5, 1.05 } },
  { { 0.5, 0.05, 0 }, { 1, 0.1, 0 }, { 0.2, 3, 0.1 }, { 0.1, 1.5, 1.05 } },
  { { 1, 0.1, 0 }, { 0.6, 1.55, 0.05 }, { 0, 0, 1 }, { 0, 0, 2 } },
  { { 0.6, 1.55, 0.05 }, { 0.2, 3, 0.1 }, { 0, 0, 1 }, { 0, 0, 2 } },
  { { 1, 0.1, 0 }, { 0.6, 1.55, 0.05 }, { 0, 0, 0 }, { 0, 0, 1 } },
  { { 0.6, 1.55, 0.05 }, { 0.2, 3, 0.1 }, { 0, 0, 0 }, { 0, 0, 1 } },
  { { 0.2, 3, 0.1 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 1 }, { 0, 0, 2 } },
  { { 0.1, 1.5, 0.05 }, { 0, 0, 0 }, { 0.5, 0.05, 1 }, { 0, 0, 2 } },
  { { 0.2, 3, 0.1 }, { 0.1, 1.5, 0.05 }, { 1, 0.1, 0 }, { 0.5, 0.05, 1 } },
  { { 0.1, 1.5, 0.05 }, { 0, 0, 0 }, { 1, 0.1, 0 }, { 0.5, 0.05, 1 } },
  { { 0.2, 3, 0.1 }, { 1, 0.1, 0 }, { 0, 0, 2 }, { 0.1, 1.5, 0.05 } },
  { { 0.1, 1.5, 0.05 }, { 0, 0, 1 }, { 1, 0.1, 0 }, { 0, 0, 2 } },
  { { 0.1, 1.5, 0.05 }, { 0, 0, 1 }, { 0.5, 0.05, 0 }, { 1, 0.1, 0 } },
  { { 0.5, 0.05, 0 }, { 0, 0, 1 }, { 0.1, 1.5, 0.05 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0.2, 3, 0.1 }, { 0, 0, 2 }, { 0.6, 1.55, 0.05 } },
  { { 0.5, 0.05, 1 }, { 0.6, 1.55, 0.05 }, { 0, 0, 0 }, { 0, 0, 2 } },
  { { 0.5, 0.05, 1 }, { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 0 }, { 0, 0, 0 } },
  { { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 1 }, { 0.5, 0.05, 0 }, { 1, 0.1, 0 } },
  { { 0, 0, 0 }, { 0, 0, 2 }, { 1, 0.1, 0 }, { 0.1, 1.5, 1.05 } },
  { { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 1.05 }, { 0, 0, 0 }, { 1, 0.1, 0 } },
  { { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 1.05 }, { 0.1, 1.5, 0.05 }, { 0, 0, 0 } },
  { { 0.1, 1.5, 0.05 }, { 0.1, 1.5, 1.05 }, { 0.6, 1.55, 0.05 }, { 0.2, 3, 0.1 } },
  { { 0.2, 3, 0.1 }, { 0, 0, 0 }, { 1, 0.1, 0 }, { 0.1, 1.5, 1.05 } },
  { { 0.1, 1.5, 1.05 }, { 0.5, 0.05, 1 }, { 0, 0, 0 }, { 1, 0.1, 0 } },
  { { 0.1, 1.5, 1.05 }, { 0.5, 0.05, 1 }, { 0, 0, 1 }, { 0, 0, 0 } },
  { { 0, 0, 1 }, { 0.5, 0.05, 1 }, { 0.1, 1.5, 1.05 }, { 0, 0, 2 } },
  { { 0, 0, 0 }, { 0, 0, 1 }, { 0.5, 0.05, 0 }, { 0.2, 3, 0.1 } },
  { { 0.5, 0.05, 0 }, { 0, 0, 1 }, { 0.5, 0.05, 1 }, { 0.2, 3, 0.1 } },
  { { 0.5, 0.05, 0 }, { 0.5, 0.05, 1 }, { 1, 0.1, 0 }, { 0.2, 3, 0.1 } },
  { { 0, 0, 1 }, { 0, 0, 2 }, { 0.5, 0.05, 1 }, { 0.2, 3, 0.1 } },
  { { 1, 0.1, 0 }, { 0.5, 0.05, 1 }, { 0.6, 1.55, 0.05 }, { 0, 0, 0 } },
  { { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 1 }, { 0.1, 1.5, 1.05 }, { 0, 0, 0 } },
  { { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 1.05 }, { 0.2, 3, 0.1 }, { 0, 0, 0 } },
  { { 0.5, 0.05, 1 }, { 0, 0, 2 }, { 0.1, 1.5, 1.05 }, { 0, 0, 0 } },
  { { 0, 0, 2 }, { 0, 0, 1 }, { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 1 }, { 0.1, 1.5, 0.05 }, { 1, 0.1, 0 } },
  { { 0.1, 1.5, 1.05 }, { 0.1, 1.5, 0.05 }, { 0.2, 3, 0.1 }, { 1, 0.1, 0 } },
  { { 0, 0, 1 }, { 0, 0, 0 }, { 0.1, 1.5, 0.05 }, { 1, 0.1, 0 } },
  { { 0, 0, 0 }, { 0.5, 0.05, 0 }, { 0.1, 1.5, 0.05 }, { 0, 0, 2 } },
  { { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 0 }, { 0.6, 1.55, 0.05 }, { 0, 0, 2 } },
  { { 0.1, 1.5, 0.05 }, { 0.6, 1.55, 0.05 }, { 0.2, 3, 0.1 }, { 0, 0, 2 } },
  { { 0.5, 0.05, 0 }, { 1, 0.1, 0 }, { 0.6, 1.55, 0.05 }, { 0, 0, 2 } },
  { { 0.5, 0.05, 1 }, { 0, 0, 0 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 0 } },
  { { 0.5, 0.05, 1 }, { 0, 0, 0 }, { 0, 0, 2 }, { 0.1, 1.5, 0.05 } },
  { { 0.1, 1.5, 0.05 }, { 1, 0.1, 0 }, { 0.5, 0.05, 1 }, { 0.5, 0.05, 0 } },
  { { 0.1, 1.5, 0.05 }, { 1, 0.1, 0 }, { 0.2, 3, 0.1 }, { 0.5, 0.05, 1 } },
  { { 0.2, 3, 0.1 }, { 0, 0, 2 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 1 } },
  { { 0, 0, 0 }, { 0.6, 1.55, 0.05 }, { 0.2, 3, 0.1 }, { 0, 0, 1 } },
  { { 0, 0, 0 }, { 0.6, 1.55, 0.05 }, { 0, 0, 1 }, { 0.5, 0.05, 0 } },
  { { 0, 0, 1 }, { 1, 0.1, 0 }, { 0.5, 0.05, 0 }, { 0.6, 1.55, 0.05 } },
  { { 0, 0, 1 }, { 1, 0.1, 0 }, { 0.6, 1.55, 0.05 }, { 0, 0, 2 } },
  { { 0, 0, 2 }, { 0.6, 1.55, 0.05 }, { 0, 0, 1 }, { 0.2, 3, 0.1 } },
  { { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 }, { 0.5, 0.05, 0 }, { 0.6, 1.55, 0.05 } },
  { { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 }, { 0, 0, 2 }, { 0.5, 0.05, 0 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 0 }, { 0.1, 1.5, 1.05 }, { 0.2, 3, 0.1 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 0 }, { 0.5, 0.05, 0 }, { 0.1, 1.5, 1.05 } },
  { { 0, 0, 0 }, { 0, 0, 2 }, { 0.5, 0.05, 0 }, { 0.1, 1.5, 1.05 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 0 }, { 0.5, 0.05, 1 }, { 0.1, 1.5, 0.05 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 0 }, { 1, 0.1, 0 }, { 0.5, 0.05, 1 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 2 }, { 0.2, 3, 0.1 }, { 0.1, 1.5, 0.05 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 2 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 1 } },
  { { 0, 0, 2 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 1 }, { 0, 0, 0 } },
  { { 0.1, 1.5, 0.05 }, { 1, 0.1, 0 }, { 0.1, 1.5, 1.05 }, { 0.5, 0.05, 0 } },
  { { 0.1, 1.5, 0.05 }, { 1, 0.1, 0 }, { 0.2, 3, 0.1 }, { 0.1, 1.5, 1.05 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 0 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 0 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 0 }, { 0.5, 0.05, 0 }, { 0, 0, 2 } },
  { { 0, 0, 2 }, { 0.5, 0.05, 0 }, { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 } },
  { { 0.1, 1.5, 0.05 }, { 0, 0, 2 }, { 0.6, 1.55, 0.05 }, { 0.2, 3, 0.1 } },
  { { 0.1, 1.5, 0.05 }, { 0, 0, 2 }, { 0, 0, 1 }, { 0.6, 1.55, 0.05 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 0 }, { 0, 0, 1 }, { 0.1, 1.5, 0.05 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 0 }, { 1, 0.1, 0 }, { 0, 0, 1 } },
  { { 1, 0.1, 0 }, { 0, 0, 2 }, { 0.6, 1.55, 0.05 }, { 0, 0, 1 } },
  { { 0.5, 0.05, 1 }, { 0, 0, 0 }, { 0.1, 1.5, 1.05 }, { 0.5, 0.05, 0 } },
  { { 0.5, 0.05, 1 }, { 0, 0, 0 }, { 0, 0, 2 }, { 0.1, 1.5, 1.05 } },
  { { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 }, { 0.5, 0.05, 1 }, { 0.5, 0.05, 0 } },
  { { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 }, { 0.5, 0.05, 0 }, { 0.2, 3, 0.1 } },
  { { 0.2, 3, 0.1 }, { 0.5, 0.05, 0 }, { 0.1, 1.5, 1.05 }, { 0, 0, 0 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 2 }, { 0, 0, 1 }, { 0.5, 0.05, 1 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 2 }, { 0.2, 3, 0.1 }, { 0, 0, 1 } },
  { { 0.5, 0.05, 1 }, { 0, 0, 0 }, { 0.6, 1.55, 0.05 }, { 1, 0.1, 0 } },
  { { 0.5, 0.05, 1 }, { 0, 0, 0 }, { 0, 0, 1 }, { 0.6, 1.55, 0.05 } },
  { { 0, 0, 0 }, { 0.2, 3, 0.1 }, { 0, 0, 1 }, { 0.6, 1.55, 0.05 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 0 }, { 0.5, 0.05, 1 }, { 0, 0, 2 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 0 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 1 } },
  { { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 }, { 0.1, 1.5, 0.05 }, { 0.2, 3, 0.1 } },
  { { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 }, { 0.5, 0.05, 1 }, { 0.1, 1.5, 0.05 } },
  { { 1, 0.1, 0 }, { 0, 0, 0 }, { 0.5, 0.05, 1 }, { 0.1, 1.5, 0.05 } },
  { { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 }, { 0, 0, 1 }, { 0.6, 1.55, 0.05 } },
  { { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 }, { 0, 0, 2 }, { 0, 0, 1 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 0 }, { 0.2, 3, 0.1 }, { 0.6, 1.55, 0.05 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 0 }, { 0.6, 1.55, 0.05 }, { 0, 0, 1 } },
  { { 0, 0, 0 }, { 0.6, 1.55, 0.05 }, { 0, 0, 1 }, { 1, 0.1, 0 } },
  { { 0, 0, 2 }, { 0.1, 1.5, 0.05 }, { 0.2, 3, 0.1 }, { 0.5, 0.05, 1 } },
  { { 0, 0, 2 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 1 }, { 0, 0, 1 } },
  { { 0.5, 0.05, 1 }, { 0, 0, 0 }, { 0, 0, 1 }, { 0.1, 1.5, 0.05 } },
  { { 0.5, 0.05, 1 }, { 0, 0, 0 }, { 0.1, 1.5, 0.05 }, { 1, 0.1, 0 } },
  { { 1, 0.1, 0 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 1 }, { 0.2, 3, 0.1 } },
  { { 0, 0, 1 }, { 1, 0.1, 0 }, { 0.1, 1.5, 1.05 }, { 0, 0, 2 } },
  { { 0, 0, 1 }, { 1, 0.1, 0 }, { 0.5, 0.05, 0 }, { 0.1, 1.5, 1.05 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 0 }, { 0.5, 0.05, 0 }, { 0, 0, 1 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 0 }, { 0.2, 3, 0.1 }, { 0.5, 0.05, 0 } },
  { { 0.2, 3, 0.1 }, { 1, 0.1, 0 }, { 0.1, 1.5, 1.05 }, { 0.5, 0.05, 0 } },
  { { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 1 }, { 0, 0, 1 }, { 0, 0, 0 } },
  { { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 1 }, { 0, 0, 0 }, { 1, 0.1, 0 } },
  { { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 1.05 }, { 0.2, 3, 0.1 }, { 0, 0, 0 } },
  { { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 1.05 }, { 0, 0, 0 }, { 0, 0, 1 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 1 }, { 0.5, 0.05, 1 }, { 0, 0, 2 } },
  { { 0.1, 1.5, 1.05 }, { 0.5, 0.05, 1 }, { 0, 0, 1 }, { 0.6, 1.55, 0.05 } },
  { { 0.5, 0.05, 1 }, { 0.1, 1.5, 1.05 }, { 0.1, 1.5, 0.05 }, { 0, 0, 0 } },
  { { 0.5, 0.05, 1 }, { 0.1, 1.5, 1.05 }, { 0, 0, 0 }, { 0, 0, 2 } },
  { { 0.5, 0.05, 1 }, { 0.6, 1.55, 0.05 }, { 1, 0.1, 0 }, { 0, 0, 0 } },
  { { 0.5, 0.05, 1 }, { 0.6, 1.55, 0.05 }, { 0, 0, 0 }, { 0.1, 1.5, 0.05 } },
  { { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 0.05 }, { 0.1, 1.5, 1.05 }, { 0.2, 3, 0.1 } },
  { { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 1.05 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 1 } },
  { { 0.1, 1.5, 1.05 }, { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 0 }, { 0, 0, 0 } },
  { { 0.1, 1.5, 1.05 }, { 0.6, 1.55, 0.05 }, { 0, 0, 0 }, { 0.2, 3, 0.1 } },
  { { 0.1, 1.5, 1.05 }, { 0.5, 0.05, 1 }, { 0, 0, 2 }, { 0, 0, 0 } },
  { { 0.1, 1.5, 1.05 }, { 0.5, 0.05, 1 }, { 0, 0, 0 }, { 0.5, 0.05, 0 } },
  { { 0.5, 0.05, 1 }, { 0.5, 0.05, 0 }, { 0.6, 1.55, 0.05 }, { 1, 0.1, 0 } },
  { { 0.5, 0.05, 1 }, { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 0 }, { 0.1, 1.5, 1.05 } },
  { { 0.5, 0.05, 1 }, { 0, 0, 0 }, { 0.1, 1.5, 0.05 }, { 1, 0.1, 0 } },
  { { 0.5, 0.05, 1 }, { 0, 0, 0 }, { 0, 0, 1 }, { 0.1, 1.5, 0.05 } },
  { { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 }, { 0.1, 1.5, 0.05 }, { 0.2, 3, 0.1 } },
  { { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 }, { 0.5, 0.05, 1 }, { 0.1, 1.5, 0.05 } },
  { { 0, 0, 1 }, { 0.5, 0.05, 1 }, { 0.1, 1.5, 1.05 }, { 0, 0, 2 } },
  { { 0, 0, 1 }, { 0.1, 1.5, 1.05 }, { 0.5, 0.05, 1 }, { 0.1, 1.5, 0.05 } },
  { { 0, 0, 0 }, { 0.6, 1.55, 0.05 }, { 0, 0, 1 }, { 1, 0.1, 0 } },
  { { 0, 0, 0 }, { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 0.05 }, { 0, 0, 1 } },
  { { 1, 0.1, 0 }, { 0.1, 1.5, 1.05 }, { 0, 0, 1 }, { 0, 0, 2 } },
  { { 1, 0.1, 0 }, { 0.1, 1.5, 1.05 }, { 0.6, 1.55, 0.05 }, { 0, 0, 1 } },
  { { 0.1, 1.5, 1.05 }, { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 0.05 }, { 0.2, 3, 0.1 } },
  { { 0.1, 1.5, 1.05 }, { 0.1, 1.5, 0.05 }, { 0.6, 1.55, 0.05 }, { 0, 0, 1 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 1 }, { 0.5, 0.05, 0 }, { 1, 0.1, 0 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 1 }, { 1, 0.1, 0 }, { 0, 0, 2 } },
  { { 0.1, 1.5, 1.05 }, { 0.1, 1.5, 0.05 }, { 0.2, 3, 0.1 }, { 1, 0.1, 0 } },
  { { 0.1, 1.5, 1.05 }, { 0.1, 1.5, 0.05 }, { 1, 0.1, 0 }, { 0.5, 0.05, 0 } },
  { { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 0 }, { 0, 0, 1 }, { 0, 0, 0 } },
  { { 0.1, 1.5, 0.05 }, { 0, 0, 1 }, { 0.5, 0.05, 0 }, { 0.1, 1.5, 1.05 } },
  { { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 }, { 0.5, 0.05, 0 }, { 0.2, 3, 0.1 } },
  { { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 }, { 0.5, 0.05, 1 }, { 0.5, 0.05, 0 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 0 }, { 0.5, 0.05, 0 }, { 0, 0, 1 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 0 }, { 0.2, 3, 0.1 }, { 0.5, 0.05, 0 } },
  { { 0.5, 0.05, 1 }, { 0.1, 1.5, 1.05 }, { 0, 0, 1 }, { 0, 0, 2 } },
  { { 0.5, 0.05, 1 }, { 0, 0, 1 }, { 0.1, 1.5, 1.05 }, { 0.5, 0.05, 0 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 0 }, { 0, 0, 1 }, { 0.2, 3, 0.1 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 0 }, { 0.5, 0.05, 0 }, { 0, 0, 1 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 2 }, { 0, 0, 1 }, { 0.5, 0.05, 1 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 2 }, { 0.2, 3, 0.1 }, { 0, 0, 1 } },
  { { 0.5, 0.05, 0 }, { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 1 }, { 1, 0.1, 0 } },
  { { 0.5, 0.05, 0 }, { 0.5, 0.05, 1 }, { 0.6, 1.55, 0.05 }, { 0, 0, 1 } },
  { { 0.1, 1.5, 0.05 }, { 0, 0, 2 }, { 0.5, 0.05, 1 }, { 0.2, 3, 0.1 } },
  { { 0.1, 1.5, 0.05 }, { 0, 0, 2 }, { 0, 0, 1 }, { 0.5, 0.05, 1 } },
  { { 0.1, 1.5, 0.05 }, { 1, 0.1, 0 }, { 0.5, 0.05, 1 }, { 0.5, 0.05, 0 } },
  { { 0.1, 1.5, 0.05 }, { 1, 0.1, 0 }, { 0.2, 3, 0.1 }, { 0.5, 0.05, 1 } },
  { { 0, 0, 1 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 0 }, { 0, 0, 0 } },
  { { 0, 0, 1 }, { 0.5, 0.05, 0 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 1 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 0 }, { 0.5, 0.05, 0 }, { 0, 0, 2 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 0 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 0 } },
  { { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 }, { 0.5, 0.05, 0 }, { 0.6, 1.55, 0.05 } },
  { { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 }, { 0, 0, 2 }, { 0.5, 0.05, 0 } },
  { { 0.1, 1.5, 0.05 }, { 0.1, 1.5, 1.05 }, { 0.6, 1.55, 0.05 }, { 0.2, 3, 0.1 } },
  { { 0.1, 1.5, 0.05 }, { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 1.05 }, { 0.5, 0.05, 0 } },
  { { 0, 0, 0 }, { 0.5, 0.05, 1 }, { 0.1, 1.5, 0.05 }, { 0, 0, 2 } },
  { { 0, 0, 0 }, { 0.5, 0.05, 1 }, { 0.5, 0.05, 0 }, { 0.1, 1.5, 0.05 } },
  { { 0, 0, 2 }, { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 0.05 }, { 0.2, 3, 0.1 } },
  { { 0, 0, 2 }, { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 1 }, { 0.1, 1.5, 0.05 } },
  { { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 1 }, { 0.5, 0.05, 0 }, { 1, 0.1, 0 } },
  { { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 0 }, { 0.5, 0.05, 1 }, { 0.1, 1.5, 0.05 } },
  { { 0, 0, 1 }, { 1, 0.1, 0 }, { 0.6, 1.55, 0.05 }, { 0, 0, 2 } },
  { { 0, 0, 1 }, { 1, 0.1, 0 }, { 0.5, 0.05, 0 }, { 0.6, 1.55, 0.05 } },
  { { 0.1, 1.5, 0.05 }, { 0, 0, 2 }, { 0.6, 1.55, 0.05 }, { 0.2, 3, 0.1 } },
  { { 0.1, 1.5, 0.05 }, { 0, 0, 2 }, { 0, 0, 1 }, { 0.6, 1.55, 0.05 } },
  { { 0.5, 0.05, 0 }, { 0, 0, 1 }, { 0.1, 1.5, 0.05 }, { 0, 0, 0 } },
  { { 0.5, 0.05, 0 }, { 0.1, 1.5, 0.05 }, { 0, 0, 1 }, { 0.6, 1.55, 0.05 } },
  { { 0.5, 0.05, 1 }, { 0.1, 1.5, 0.05 }, { 0, 0, 0 }, { 0, 0, 1 } },
  { { 0.5, 0.05, 1 }, { 0.1, 1.5, 0.05 }, { 0.6, 1.55, 0.05 }, { 0, 0, 0 } },
  { { 0.5, 0.05, 1 }, { 0.6, 1.55, 0.05 }, { 1, 0.1, 0 }, { 0, 0, 0 } },
  { { 0.1, 1.5, 0.05 }, { 0.6, 1.55, 0.05 }, { 0.2, 3, 0.1 }, { 0, 0, 2 } },
  { { 0.5, 0.05, 1 }, { 0.1, 1.5, 0.05 }, { 0, 0, 1 }, { 0, 0, 2 } },
  { { 0.5, 0.05, 1 }, { 0.1, 1.5, 0.05 }, { 0, 0, 2 }, { 0.6, 1.55, 0.05 } },
  { { 0.5, 0.05, 1 }, { 0.1, 1.5, 0.05 }, { 1, 0.1, 0 }, { 0.5, 0.05, 0 } },
  { { 0.5, 0.05, 1 }, { 0.1, 1.5, 0.05 }, { 0.1, 1.5, 1.05 }, { 1, 0.1, 0 } },
  { { 0.1, 1.5, 1.05 }, { 0.1, 1.5, 0.05 }, { 0.2, 3, 0.1 }, { 1, 0.1, 0 } },
  { { 0.1, 1.5, 1.05 }, { 0.5, 0.05, 1 }, { 0, 0, 2 }, { 0, 0, 0 } },
  { { 0.5, 0.05, 1 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 0 }, { 0, 0, 0 } },
  { { 0.5, 0.05, 1 }, { 0.1, 1.5, 0.05 }, { 0, 0, 0 }, { 0.1, 1.5, 1.05 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 1 }, { 0, 0, 0 }, { 0.5, 0.05, 0 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 1 }, { 0.1, 1.5, 1.05 }, { 0, 0, 0 } },
  { { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 1.05 }, { 0.2, 3, 0.1 }, { 0, 0, 0 } },
  { { 0, 0, 1 }, { 0.1, 1.5, 1.05 }, { 0, 0, 2 }, { 1, 0.1, 0 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 1 }, { 0.5, 0.05, 0 }, { 1, 0.1, 0 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 1 }, { 1, 0.1, 0 }, { 0.1, 1.5, 1.05 } },
  { { 0, 0, 0 }, { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 0.05 }, { 0, 0, 1 } },
  { { 0, 0, 0 }, { 0.6, 1.55, 0.05 }, { 0, 0, 1 }, { 0.5, 0.05, 1 } },
  { { 0, 0, 0 }, { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 1 }, { 1, 0.1, 0 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 1 }, { 0.1, 1.5, 1.05 }, { 0.1, 1.5, 0.05 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 1 }, { 0.5, 0.05, 1 }, { 0.1, 1.5, 1.05 } },
  { { 0, 0, 1 }, { 0.5, 0.05, 1 }, { 0.1, 1.5, 1.05 }, { 0, 0, 2 } },
  { { 0.1, 1.5, 0.05 }, { 0.6, 1.55, 0.05 }, { 0.2, 3, 0.1 }, { 0.1, 1.5, 1.05 } },
  { { 1, 0.1, 0 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 0 }, { 0.5, 0.05, 1 } },
  { { 1, 0.1, 0 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 1 }, { 0.1, 1.5, 1.05 } },
  { { 1, 0.1, 0 }, { 0.1, 1.5, 0.05 }, { 0.1, 1.5, 1.05 }, { 0.2, 3, 0.1 } },
  { { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 1 }, { 0, 0, 1 }, { 0.5, 0.05, 0 } },
  { { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 1 }, { 0.1, 1.5, 1.05 }, { 0, 0, 1 } },
  { { 0.5, 0.05, 1 }, { 0.1, 1.5, 1.05 }, { 0, 0, 1 }, { 0, 0, 2 } },
  { { 0.5, 0.05, 0 }, { 0.1, 1.5, 0.05 }, { 0, 0, 0 }, { 0, 0, 1 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 0 }, { 0.5, 0.05, 0 }, { 0, 0, 1 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 0 }, { 0, 0, 1 }, { 0.1, 1.5, 1.05 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 0 }, { 0.1, 1.5, 1.05 }, { 0.2, 3, 0.1 } },
  { { 0, 0, 1 }, { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 1 }, { 0.5, 0.05, 0 } },
  { { 0, 0, 1 }, { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 1.05 }, { 0.5, 0.05, 1 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 1 }, { 0.5, 0.05, 1 }, { 0, 0, 2 } },
  { { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 0 }, { 1, 0.1, 0 }, { 0.5, 0.05, 1 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 0 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 0 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 0 }, { 0.5, 0.05, 0 }, { 0.5, 0.05, 1 } },
  { { 0.1, 1.5, 1.05 }, { 0, 0, 0 }, { 0.5, 0.05, 1 }, { 0, 0, 2 } },
  { { 0.5, 0.05, 0 }, { 0.1, 1.5, 1.05 }, { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 0.05 } },
  { { 0.5, 0.05, 0 }, { 0.1, 1.5, 1.05 }, { 0.5, 0.05, 1 }, { 0.6, 1.55, 0.05 } },
  { { 0.5, 0.05, 1 }, { 0.5, 0.05, 0 }, { 0.6, 1.55, 0.05 }, { 1, 0.1, 0 } },
  { { 0.1, 1.5, 1.05 }, { 0.1, 1.5, 0.05 }, { 0.2, 3, 0.1 }, { 0.6, 1.55, 0.05 } },
  { { 1, 0.1, 0 }, { 0.1, 1.5, 1.05 }, { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 0 } },
  { { 1, 0.1, 0 }, { 0.1, 1.5, 1.05 }, { 0.5, 0.05, 0 }, { 0, 0, 1 } },
  { { 1, 0.1, 0 }, { 0.1, 1.5, 1.05 }, { 0, 0, 1 }, { 0, 0, 2 } },
  { { 0.1, 1.5, 1.05 }, { 0.5, 0.05, 0 }, { 0.1, 1.5, 0.05 }, { 0.6, 1.55, 0.05 } },
  { { 0.1, 1.5, 1.05 }, { 0.5, 0.05, 0 }, { 0, 0, 1 }, { 0.1, 1.5, 0.05 } },
  { { 0.5, 0.05, 0 }, { 0, 0, 1 }, { 0.1, 1.5, 0.05 }, { 0, 0, 0 } },
  { { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 1.05 }, { 0.2, 3, 0.1 }, { 0.1, 1.5, 0.05 } },
  { { 0, 0, 2 }, { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 1 }, { 0, 0, 1 } },
  { { 0, 0, 2 }, { 0.6, 1.55, 0.05 }, { 0, 0, 1 }, { 0.1, 1.5, 0.05 } },
  { { 0, 0, 2 }, { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 0.05 }, { 0.2, 3, 0.1 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 1 }, { 0.5, 0.05, 0 }, { 0.5, 0.05, 1 } },
  { { 0.6, 1.55, 0.05 }, { 0, 0, 1 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 0 } },
  { { 0, 0, 1 }, { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 0 }, { 0, 0, 0 } },
  { { 0.5, 0.05, 1 }, { 0.6, 1.55, 0.05 }, { 1, 0.1, 0 }, { 0.5, 0.05, 0 } },
  { { 0.1, 1.5, 0.05 }, { 0.5, 0.05, 0 }, { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 1 } },
  { { 0.1, 1.5, 0.05 }, { 0.6, 1.55, 0.05 }, { 0.1, 1.5, 1.05 }, { 0.5, 0.05, 1 } },
  { { 0.1, 1.5, 0.05 }, { 0.1, 1.5, 1.05 }, { 0, 0, 1 }, { 0.5, 0.05, 1 } },
  { { 0.1, 1.5, 0.05 }, { 0, 0, 1 }, { 0.5, 0.05, 0 }, { 0.5, 0.05, 1 } },
  { { 0, 0, 1 }, { 0.5, 0.05, 1 }, { 0.1, 1.5, 1.05 }, { 0, 0, 2 } },
  { { 0.1, 1.5, 0.05 }, { 0.6, 1.55, 0.05 }, { 0.2, 3, 0.1 }, { 0.1, 1.5, 1.05 } },
  { { 0.5, 0.05, 0 }, { 1, 0.1, 0 }, { 0.6, 1.55, 0.05 }, { 0.5, 0.05, 1 } },
  { { 0, 0, 0 }, { 0.5, 0.05, 0 }, { 0.1, 1.5, 0.05 }, { 0, 0, 1 } },
  { { 0, 0, 0 }, { 3, 0.1, 0.2 }, { 0, 2, 0 }, { 0.1, 0, 1 } },
  { { 0, 0, 0 }, { 1.5, 0.05, 0.1 }, { 0, 2, 0 }, { 0.1, 0, 1 } },
  { { 1.5, 0.05, 0.1 }, { 3, 0.1, 0.2 }, { 0, 2, 0 }, { 0.1, 0, 1 } },
  { { 3, 0.1, 0.2 }, { 1.5, 1.05, 0.1 }, { 0, 0, 0 }, { 0.1, 0, 1 } },
  { { 1.5, 1.05, 0.1 }, { 0, 2, 0 }, { 0, 0, 0 }, { 0.1, 0, 1 } },
  { { 0, 2, 0 }, { 0, 1, 0 }, { 3, 0.1, 0.2 }, { 0.1, 0, 1 } },
  { { 0, 1, 0 }, { 0, 0, 0 }, { 3, 0.1, 0.2 }, { 0.1, 0, 1 } },
  { { 0.1, 0, 1 }, { 0.05, 0, 0.5 }, { 0, 2, 0 }, { 3, 0.1, 0.2 } },
  { { 0.05, 0, 0.5 }, { 0, 0, 0 }, { 0, 2, 0 }, { 3, 0.1, 0.2 } },
  { { 3, 0.1, 0.2 }, { 1.55, 0.05, 0.6 }, { 0, 2, 0 }, { 0, 0, 0 } },
  { { 1.55, 0.05, 0.6 }, { 0.1, 0, 1 }, { 0, 2, 0 }, { 0, 0, 0 } },
  { { 0.1, 0, 1 }, { 0.05, 1, 0.5 }, { 3, 0.1, 0.2 }, { 0, 0, 0 } },
  { { 0.05, 1, 0.5 }, { 0, 2, 0 }, { 3, 0.1, 0.2 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 1.5, 0.05, 0.1 }, { 1.5, 1.05, 0.1 }, { 0.1, 0, 1 } },
  { { 0, 0, 0 }, { 1.5, 1.05, 0.1 }, { 0, 2, 0 }, { 0.1, 0, 1 } },
  { { 0.1, 0, 1 }, { 1.5, 0.05, 0.1 }, { 1.5, 1.05, 0.1 }, { 3, 0.1, 0.2 } },
  { { 0, 2, 0 }, { 0, 1, 0 }, { 1.5, 0.05, 0.1 }, { 0.1, 0, 1 } },
  { { 0, 2, 0 }, { 1.5, 0.05, 0.1 }, { 3, 0.1, 0.2 }, { 0.1, 0, 1 } },
  { { 0.1, 0, 1 }, { 0, 1, 0 }, { 1.5, 0.05, 0.1 }, { 0, 0, 0 } },
  { { 3, 0.1, 0.2 }, { 1.5, 1.05, 0.1 }, { 0, 0, 0 }, { 0.1, 0, 1 } },
  { { 1.5, 1.05, 0.1 }, { 0, 1, 0 }, { 0, 0, 0 }, { 0.1, 0, 1 } },
  { { 0.1, 0, 1 }, { 1.5, 1.05, 0.1 }, { 0, 1, 0 }, { 0, 2, 0 } },
  { { 3, 0.1, 0.2 }, { 1.5, 0.05, 0.1 }, { 0.1, 0, 1 }, { 0, 2, 0 } },
  { { 1.5, 0.05, 0.1 }, { 0.05, 0, 0.5 }, { 0.1, 0, 1 }, { 0, 2, 0 } },
  { { 0, 2, 0 }, { 1.5, 0.05, 0.1 }, { 0.05, 0, 0.5 }, { 0, 0, 0 } },
  { { 0.1, 0, 1 }, { 1.55, 0.05, 0.6 }, { 0, 0, 0 }, { 0, 2, 0 } },
  { { 1.55, 0.05, 0.6 }, { 1.5, 0.05, 0.1 }, { 0, 0, 0 }, { 0, 2, 0 } },
  { { 0, 2, 0 }, { 1.55, 0.05, 0.6 }, { 1.5, 0.05, 0.1 }, { 3, 0.1, 0.2 } },
  { { 0, 0, 0 }, { 0.05, 0, 0.5 }, { 1.55, 0.05, 0.6 }, { 0, 2, 0 } },
  { { 0, 0, 0 }, { 1.55, 0.05, 0.6 }, { 3, 0.1, 0.2 }, { 0, 2, 0 } },
  { { 0, 2, 0 }, { 0.05, 0, 0.5 }, { 1.55, 0.05, 0.6 }, { 0.1, 0, 1 } },
  { { 0, 2, 0 }, { 1.5, 1.05, 0.1 }, { 0.1, 0, 1 }, { 0, 0, 0 } },
  { { 1.5, 1.05, 0.1 }, { 1.55, 0.05, 0.6 }, { 0.1, 0, 1 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 1.5, 1.05, 0.1 }, { 1.55, 0.05, 0.6 }, { 3, 0.1, 0.2 } },
  { { 0.1, 0, 1 }, { 0.05, 1, 0.5 }, { 1.5, 1.05, 0.1 }, { 0, 0, 0 } },
  { { 0.1, 0, 1 }, { 1.5, 1.05, 0.1 }, { 3, 0.1, 0.2 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0.05, 1, 0.5 }, { 1.5, 1.05, 0.1 }, { 0, 2, 0 } },
  { { 3, 0.1, 0.2 }, { 1.55, 0.05, 0.6 }, { 0, 2, 0 }, { 0, 0, 0 } },
  { { 1.55, 0.05, 0.6 }, { 0.05, 1, 0.5 }, { 0, 2, 0 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 1.55, 0.05, 0.6 }, { 0.05, 1, 0.5 }, { 0.1, 0, 1 } },
  { { 0.1, 0, 1 }, { 0.05, 0, 0.5 }, { 0, 1, 0 }, { 3, 0.1, 0.2 } },
  { { 0.1, 0, 1 }, { 0, 1, 0 }, { 0, 2, 0 }, { 3, 0.1, 0.2 } },
  { { 3, 0.1, 0.2 }, { 0.05, 0, 0.5 }, { 0, 1, 0 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0, 1, 0 }, { 0.05, 1, 0.5 }, { 3, 0.1, 0.2 } },
  { { 0, 0, 0 }, { 0.05, 1, 0.5 }, { 0.1, 0, 1 }, { 3, 0.1, 0.2 } },
  { { 3, 0.1, 0.2 }, { 0, 1, 0 }, { 0.05, 1, 0.5 }, { 0, 2, 0 } },
  { { 0, 2, 0 }, { 0.05, 1, 0.5 }, { 0, 0, 0 }, { 3, 0.1, 0.2 } },
  { { 0.05, 1, 0.5 }, { 0.05, 0, 0.5 }, { 0, 0, 0 }, { 3, 0.1, 0.2 } },
  { { 3, 0.1, 0.2 }, { 0.05, 1, 0.5 }, { 0.05, 0, 0.5 }, { 0.1, 0, 1 } },
  { { 0, 0, 0 }, { 1.5, 0.05, 0.1 }, { 0.05, 1, 0.5 }, { 0.1, 0, 1 } },
  { { 1.5, 0.05, 0.1 }, { 3, 0.1, 0.2 }, { 0.05, 1, 0.5 }, { 0.1, 0, 1 } },
  { { 0, 0, 0 }, { 1.5, 0.05, 0.1 }, { 0, 2, 0 }, { 0.05, 1, 0.5 } },
  { { 1.5, 0.05, 0.1 }, { 3, 0.1, 0.2 }, { 0, 2, 0 }, { 0.05, 1, 0.5 } },
  { { 3, 0.1, 0.2 }, { 1.5, 1.05, 0.1 }, { 0.05, 0, 0.5 }, { 0.1, 0, 1 } },
  { { 1.5, 1.05, 0.1 }, { 0, 2, 0 }, { 0.05, 0, 0.5 }, { 0.1, 0, 1 } },
  { { 3, 0.1, 0.2 }, { 1.5, 1.05, 0.1 }, { 0, 0, 0 }, { 0.05, 0, 0.5 } },
  { { 1.5, 1.05, 0.1 }, { 0, 2, 0 }, { 0, 0, 0 }, { 0.05, 0, 0.5 } },
  { { 0, 2, 0 }, { 0, 1, 0 }, { 1.55, 0.05, 0.6 }, { 0.1, 0, 1 } },
  { { 0, 1, 0 }, { 0, 0, 0 }, { 1.55, 0.05, 0.6 }, { 0.1, 0, 1 } },
  { { 0, 2, 0 }, { 0, 1, 0 }, { 3, 0.1, 0.2 }, { 1.55, 0.05, 0.6 } },
  { { 0, 1, 0 }, { 0, 0, 0 }, { 3, 0.1, 0.2 }, { 1.55, 0.05, 0.6 } },
  { { 3, 0.1, 0.2 }, { 0.1, 0, 1 }, { 0, 2, 0 }, { 1.5, 0.05, 0.1 } },
  { { 1.5, 0.05, 0.1 }, { 0, 1, 0 }, { 0.1, 0, 1 }, { 0, 2, 0 } },
  { { 1.5, 0.05, 0.1 }, { 0, 1, 0 }, { 0.05, 0, 0.5 }, { 0.1, 0, 1 } },
  { { 1.5, 0.05, 0.1 }, { 0.05, 0, 0.5 }, { 0, 1, 0 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0, 2, 0 }, { 0.1, 0, 1 }, { 1.5, 1.05, 0.1 } },
  { { 1.55, 0.05, 0.6 }, { 1.5, 1.05, 0.1 }, { 0, 0, 0 }, { 0.1, 0, 1 } },
  { { 1.55, 0.05, 0.6 }, { 1.5, 1.05, 0.1 }, { 1.5, 0.05, 0.1 }, { 0, 0, 0 } },
  { { 1.5, 1.05, 0.1 }, { 1.55, 0.05, 0.6 }, { 1.5, 0.05, 0.1 }, { 3, 0.1, 0.2 } },
  { { 3, 0.1, 0.2 }, { 0, 0, 0 }, { 0.1, 0, 1 }, { 1.5, 1.05, 0.1 } },
  { { 1.5, 1.05, 0.1 }, { 0.05, 1, 0.5 }, { 0, 0, 0 }, { 0.1, 0, 1 } },
  { { 1.5, 1.05, 0.1 }, { 0.05, 1, 0.5 }, { 0, 1, 0 }, { 0, 0, 0 } },
  { { 0, 1, 0 }, { 0.05, 1, 0.5 }, { 1.5, 1.05, 0.1 }, { 0, 2, 0 } },
  { { 0, 0, 0 }, { 3, 0.1, 0.2 }, { 0, 2, 0 }, { 1.55, 0.05, 0.6 } },
  { { 0.05, 1, 0.5 }, { 1.55, 0.05, 0.6 }, { 0, 0, 0 }, { 0, 2, 0 } },
  { { 0.05, 1, 0.5 }, { 1.55, 0.05, 0.6 }, { 0.05, 0, 0.5 }, { 0, 0, 0 } },
  { { 0.05, 0, 0.5 }, { 1.55, 0.05, 0.6 }, { 0.05, 1, 0.5 }, { 0.1, 0, 1 } },
  { { 0, 0, 0 }, { 0.05, 0, 0.5 }, { 1.5, 0.05, 0.1 }, { 0, 2, 0 } },
  { { 1.5, 0.05, 0.1 }, { 0.05, 0, 0.5 }, { 1.55, 0.05, 0.6 }, { 0, 2, 0 } },
  { { 1.5, 0.05, 0.1 }, { 1.55, 0.05, 0.6 }, { 3, 0.1, 0.2 }, { 0, 2, 0 } },
  { { 0.05, 0, 0.5 }, { 0.1, 0, 1 }, { 1.55, 0.05, 0.6 }, { 0, 2, 0 } },
  { { 3, 0.1, 0.2 }, { 1.55, 0.05, 0.6 }, { 1.5, 1.05, 0.1 }, { 0, 0, 0 } },
  { { 1.5, 1.05, 0.1 }, { 1.55, 0.05, 0.6 }, { 0.05, 1, 0.5 }, { 0, 0, 0 } },
  { { 1.5, 1.05, 0.1 }, { 0.05, 1, 0.5 }, { 0, 2, 0 }, { 0, 0, 0 } },
  { { 1.55, 0.05, 0.6 }, { 0.1, 0, 1 }, { 0.05, 1, 0.5 }, { 0, 0, 0 } },
  { { 0.1, 0, 1 }, { 0.05, 0, 0.5 }, { 0.05, 1, 0.5 }, { 3, 0.1, 0.2 } },
  { { 0.05, 1, 0.5 }, { 0.05, 0, 0.5 }, { 0, 1, 0 }, { 3, 0.1, 0.2 } },
  { { 0.05, 1, 0.5 }, { 0, 1, 0 }, { 0, 2, 0 }, { 3, 0.1, 0.2 } },
  { { 0.05, 0, 0.5 }, { 0, 0, 0 }, { 0, 1, 0 }, { 3, 0.1, 0.2 } },
  { { 0, 0, 0 }, { 1.5, 0.05, 0.1 }, { 0, 1, 0 }, { 0.1, 0, 1 } },
  { { 0, 1, 0 }, { 1.5, 0.05, 0.1 }, { 1.5, 1.05, 0.1 }, { 0.1, 0, 1 } },
  { { 0, 1, 0 }, { 1.5, 1.05, 0.1 }, { 0, 2, 0 }, { 0.1, 0, 1 } },
  { { 1.5, 0.05, 0.1 }, { 3, 0.1, 0.2 }, { 1.5, 1.05, 0.1 }, { 0.1, 0, 1 } },
  { { 1.55, 0.05, 0.6 }, { 0, 0, 0 }, { 0, 1, 0 }, { 1.5, 0.05, 0.1 } },
  { { 1.55, 0.05, 0.6 }, { 0, 0, 0 }, { 0.1, 0, 1 }, { 0, 1, 0 } },
  { { 1.5, 0.05, 0.1 }, { 0, 2, 0 }, { 1.55, 0.05, 0.6 }, { 3, 0.1, 0.2 } },
  { { 1.5, 0.05, 0.1 }, { 0, 2, 0 }, { 0, 1, 0 }, { 1.55, 0.05, 0.6 } },
  { { 0, 2, 0 }, { 0.1, 0, 1 }, { 0, 1, 0 }, { 1.55, 0.05, 0.6 } },
  { { 0, 0, 0 }, { 1.5, 1.05, 0.1 }, { 0, 2, 0 }, { 0.05, 0, 0.5 } },
  { { 0, 0, 0 }, { 1.5, 1.05, 0.1 }, { 0.05, 0, 0.5 }, { 1.5, 0.05, 0.1 } },
  { { 1.5, 0.05, 0.1 }, { 0.1, 0, 1 }, { 3, 0.1, 0.2 }, { 1.5, 1.05, 0.1 } },
  { { 1.5, 0.05, 0.1 }, { 0.1, 0, 1 }, { 1.5, 1.05, 0.1 }, { 0.05, 0, 0.5 } },
  { { 0.1, 0, 1 }, { 1.5, 1.05, 0.1 }, { 0.05, 0, 0.5 }, { 0, 2, 0 } },
  { { 1.5, 1.05, 0.1 }, { 0.1, 0, 1 }, { 1.5, 0.05, 0.1 }, { 3, 0.1, 0.2 } },
  { { 1.5, 1.05, 0.1 }, { 0.1, 0, 1 }, { 0.05, 1, 0.5 }, { 1.5, 0.05, 0.1 } },
  { { 1.5, 1.05, 0.1 }, { 0, 0, 0 }, { 0.05, 1, 0.5 }, { 0, 2, 0 } },
  { { 1.5, 1.05, 0.1 }, { 0, 0, 0 }, { 1.5, 0.05, 0.1 }, { 0.05, 1, 0.5 } },
  { { 0, 0, 0 }, { 0.1, 0, 1 }, { 1.5, 0.05, 0.1 }, { 0.05, 1, 0.5 } },
  { { 1.5, 1.05, 0.1 }, { 0, 0, 0 }, { 1.55, 0.05, 0.6 }, { 0, 1, 0 } },
  { { 1.5, 1.05, 0.1 }, { 0, 0, 0 }, { 3, 0.1, 0.2 }, { 1.55, 0.05, 0.6 } },
  { { 1.5, 1.05, 0.1 }, { 0.1, 0, 1 }, { 0, 2, 0 }, { 0, 1, 0 } },
  { { 1.5, 1.05, 0.1 }, { 0.1, 0, 1 }, { 0, 1, 0 }, { 1.55, 0.05, 0.6 } },
  { { 0.1, 0, 1 }, { 0, 1, 0 }, { 1.55, 0.05, 0.6 }, { 0, 0, 0 } },
  { { 0, 2, 0 }, { 1.5, 0.05, 0.1 }, { 3, 0.1, 0.2 }, { 0.05, 1, 0.5 } },
  { { 0, 2, 0 }, { 1.5, 0.05, 0.1 }, { 0.05, 1, 0.5 }, { 0, 1, 0 } },
  { { 0.05, 1, 0.5 }, { 0, 0, 0 }, { 0, 1, 0 }, { 1.5, 0.05, 0.1 } },
  { { 0.05, 1, 0.5 }, { 0, 0, 0 }, { 1.5, 0.05, 0.1 }, { 0.1, 0, 1 } },
  { { 0.1, 0, 1 }, { 1.5, 0.05, 0.1 }, { 0.05, 1, 0.5 }, { 3, 0.1, 0.2 } },
  { { 0, 1, 0 }, { 0.1, 0, 1 }, { 1.5, 1.05, 0.1 }, { 0, 2, 0 } },
  { { 0, 1, 0 }, { 0.1, 0, 1 }, { 0.05, 0, 0.5 }, { 1.5, 1.05, 0.1 } },
  { { 1.5, 1.05, 0.1 }, { 0, 0, 0 }, { 0.05, 0, 0.5 }, { 0, 1, 0 } },
  { { 1.5, 1.05, 0.1 }, { 0, 0, 0 }, { 3, 0.1, 0.2 }, { 0.05, 0, 0.5 } },
  { { 3, 0.1, 0.2 }, { 0.1, 0, 1 }, { 1.5, 1.05, 0.1 }, { 0.05, 0, 0.5 } },
  { { 1.55, 0.05, 0.6 }, { 0, 0, 0 }, { 0.05, 1, 0.5 }, { 1.5, 0.05, 0.1 } },
  { { 1.55, 0.05, 0.6 }, { 0, 0, 0 }, { 0.1, 0, 1 }, { 0.05, 1, 0.5 } },
  { { 1.55, 0.05, 0.6 }, { 0, 2, 0 }, { 3, 0.1, 0.2 }, { 1.5, 0.05, 0.1 } },
  { { 1.55, 0.05, 0.6 }, { 0, 2, 0 }, { 1.5, 0.05, 0.1 }, { 0.05, 1, 0.5 } },
  { { 0, 2, 0 }, { 1.5, 0.05, 0.1 }, { 0.05, 1, 0.5 }, { 0, 0, 0 } },
  { { 1.5, 1.05, 0.1 }, { 0.1, 0, 1 }, { 0.05, 0, 0.5 }, { 1.55, 0.05, 0.6 } },
  { { 1.5, 1.05, 0.1 }, { 0.1, 0, 1 }, { 0, 2, 0 }, { 0.05, 0, 0.5 } },
  { { 1.55, 0.05, 0.6 }, { 0, 0, 0 }, { 1.5, 1.05, 0.1 }, { 3, 0.1, 0.2 } },
  { { 1.55, 0.05, 0.6 }, { 0, 0, 0 }, { 0.05, 0, 0.5 }, { 1.5, 1.05, 0.1 } },
  { { 0, 0, 0 }, { 0, 2, 0 }, { 0.05, 0, 0.5 }, { 1.5, 1.05, 0.1 } },
  { { 0.05, 1, 0.5 }, { 0, 0, 0 }, { 1.55, 0.05, 0.6 }, { 0.1, 0, 1 } },
  { { 0.05, 1, 0.5 }, { 0, 0, 0 }, { 0, 1, 0 }, { 1.55, 0.05, 0.6 } },
  { { 1.55, 0.05, 0.6 }, { 0, 2, 0 }, { 0, 1, 0 }, { 0.05, 1, 0.5 } },
  { { 1.55, 0.05, 0.6 }, { 0, 2, 0 }, { 3, 0.1, 0.2 }, { 0, 1, 0 } },
  { { 3, 0.1, 0.2 }, { 0, 0, 0 }, { 1.55, 0.05, 0.6 }, { 0, 1, 0 } },
  { { 0.1, 0, 1 }, { 1.5, 1.05, 0.1 }, { 3, 0.1, 0.2 }, { 0.05, 0, 0.5 } },
  { { 0.1, 0, 1 }, { 1.5, 1.05, 0.1 }, { 0.05, 0, 0.5 }, { 0.05, 1, 0.5 } },
  { { 0.05, 1, 0.5 }, { 0, 0, 0 }, { 0, 2, 0 }, { 1.5, 1.05, 0.1 } },
  { { 0.05, 1, 0.5 }, { 0, 0, 0 }, { 1.5, 1.05, 0.1 }, { 0.05, 0, 0.5 } },
  { { 0, 0, 0 }, { 1.5, 1.05, 0.1 }, { 0.05, 0, 0.5 }, { 3, 0.1, 0.2 } },
  { { 0.1, 0, 1 }, { 0, 1, 0 }, { 0, 2, 0 }, { 1.55, 0.05, 0.6 } },
  { { 0.1, 0, 1 }, { 0, 1, 0 }, { 1.55, 0.05, 0.6 }, { 0.05, 0, 0.5 } },
  { { 1.55, 0.05, 0.6 }, { 0, 0, 0 }, { 0.05, 0, 0.5 }, { 0, 1, 0 } },
  { { 1.55, 0.05, 0.6 }, { 0, 0, 0 }, { 0, 1, 0 }, { 3, 0.1, 0.2 } },
  { { 3, 0.1, 0.2 }, { 0, 1, 0 }, { 1.55, 0.05, 0.6 }, { 0, 2, 0 } },
  { { 1.5, 0.05, 0.1 }, { 0.1, 0, 1 }, { 0.05, 1, 0.5 }, { 0.05, 0, 0.5 } },
  { { 1.5, 0.05, 0.1 }, { 0.1, 0, 1 }, { 3, 0.1, 0.2 }, { 0.05, 1, 0.5 } },
  { { 0.05, 1, 0.5 }, { 0, 0, 0 }, { 1.5, 0.05, 0.1 }, { 0.05, 0, 0.5 } },
  { { 0.05, 1, 0.5 }, { 0, 0, 0 }, { 0, 2, 0 }, { 1.5, 0.05, 0.1 } },
  { { 0, 2, 0 }, { 3, 0.1, 0.2 }, { 0.05, 1, 0.5 }, { 1.5, 0.05, 0.1 } },
  { { 1.5, 1.05, 0.1 }, { 1.55, 0.05, 0.6 }, { 0.05, 0, 0.5 }, { 0, 0, 0 } },
  { { 1.5, 1.05, 0.1 }, { 1.55, 0.05, 0.6 }, { 0, 0, 0 }, { 3, 0.1, 0.2 } },
  { { 1.5, 1.05, 0.1 }, { 0.05, 1, 0.5 }, { 0, 2, 0 }, { 0, 0, 0 } },
  { { 1.5, 1.05, 0.1 }, { 0.05, 1, 0.5 }, { 0, 0, 0 }, { 0.05, 0, 0.5 } },
  { { 0.05, 1, 0.5 }, { 0.05, 0, 0.5 }, { 1.55, 0.05, 0.6 }, { 0.1, 0, 1 } },
  { { 0.05, 1, 0.5 }, { 1.55, 0.05, 0.6 }, { 0.05, 0, 0.5 }, { 1.5, 1.05, 0.1 } },
  { { 1.55, 0.05, 0.6 }, { 0.05, 1, 0.5 }, { 0, 1, 0 }, { 0, 0, 0 } },
  { { 1.55, 0.05, 0.6 }, { 0.05, 1, 0.5 }, { 0, 0, 0 }, { 0.1, 0, 1 } },
  { { 1.55, 0.05, 0.6 }, { 1.5, 1.05, 0.1 }, { 3, 0.1, 0.2 }, { 0, 0, 0 } },
  { { 1.55, 0.05, 0.6 }, { 1.5, 1.05, 0.1 }, { 0, 0, 0 }, { 0, 1, 0 } },
  { { 1.5, 1.05, 0.1 }, { 0, 1, 0 }, { 0.05, 1, 0.5 }, { 0, 2, 0 } },
  { { 1.5, 1.05, 0.1 }, { 0.05, 1, 0.5 }, { 0, 1, 0 }, { 1.55, 0.05, 0.6 } },
  { { 0.05, 1, 0.5 }, { 1.5, 1.05, 0.1 }, { 1.5, 0.05, 0.1 }, { 0, 0, 0 } },
  { { 0.05, 1, 0.5 }, { 1.5, 1.05, 0.1 }, { 0, 0, 0 }, { 0, 2, 0 } },
  { { 0.05, 1, 0.5 }, { 1.55, 0.05, 0.6 }, { 0.1, 0, 1 }, { 0, 0, 0 } },
  { { 0.05, 1, 0.5 }, { 1.55, 0.05, 0.6 }, { 0, 0, 0 }, { 1.5, 0.05, 0.1 } },
  { { 1.55, 0.05, 0.6 }, { 1.5, 0.05, 0.1 }, { 1.5, 1.05, 0.1 }, { 3, 0.1, 0.2 } },
  { { 1.55, 0.05, 0.6 }, { 1.5, 1.05, 0.1 }, { 1.5, 0.05, 0.1 }, { 0.05, 1, 0.5 } },
  { { 1.55, 0.05, 0.6 }, { 0, 0, 0 }, { 0, 1, 0 }, { 3, 0.1, 0.2 } },
  { { 1.55, 0.05, 0.6 }, { 0, 0, 0 }, { 0.05, 0, 0.5 }, { 0, 1, 0 } },
  { { 1.55, 0.05, 0.6 }, { 0, 2, 0 }, { 0, 1, 0 }, { 0.05, 1, 0.5 } },
  { { 1.55, 0.05, 0.6 }, { 0, 2, 0 }, { 3, 0.1, 0.2 }, { 0, 1, 0 } },
  { { 0.05, 0, 0.5 }, { 1.55, 0.05, 0.6 }, { 0.05, 1, 0.5 }, { 0.1, 0, 1 } },
  { { 0.05, 0, 0.5 }, { 0.05, 1, 0.5 }, { 1.55, 0.05, 0.6 }, { 0, 1, 0 } },
  { { 1.5, 1.05, 0.1 }, { 0.1, 0, 1 }, { 0.05, 0, 0.5 }, { 3, 0.1, 0.2 } },
  { { 1.5, 1.05, 0.1 }, { 0.1, 0, 1 }, { 0.05, 1, 0.5 }, { 0.05, 0, 0.5 } },
  { { 1.5, 1.05, 0.1 }, { 0, 0, 0 }, { 0.05, 0, 0.5 }, { 0, 1, 0 } },
  { { 1.5, 1.05, 0.1 }, { 0, 0, 0 }, { 3, 0.1, 0.2 }, { 0.05, 0, 0.5 } },
  { { 0.05, 1, 0.5 }, { 1.5, 1.05, 0.1 }, { 0, 1, 0 }, { 0, 2, 0 } },
  { { 0.05, 1, 0.5 }, { 0, 1, 0 }, { 1.5, 1.05, 0.1 }, { 0.05, 0, 0.5 } },
  { { 1.5, 0.05, 0.1 }, { 0, 2, 0 }, { 0.05, 1, 0.5 }, { 3, 0.1, 0.2 } },
  { { 1.5, 0.05, 0.1 }, { 0, 2, 0 }, { 0, 1, 0 }, { 0.05, 1, 0.5 } },
  { { 1.5, 0.05, 0.1 }, { 0.1, 0, 1 }, { 0.05, 1, 0.5 }, { 0.05, 0, 0.5 } },
  { { 1.5, 0.05, 0.1 }, { 0.1, 0, 1 }, { 3, 0.1, 0.2 }, { 0.05, 1, 0.5 } },
  { { 0, 1, 0 }, { 1.5, 0.05, 0.1 }, { 0.05, 0, 0.5 }, { 0, 0, 0 } },
  { { 0, 1, 0 }, { 0.05, 0, 0.5 }, { 1.5, 0.05, 0.1 }, { 0.05, 1, 0.5 } },
  { { 0, 0, 0 }, { 0.05, 1, 0.5 }, { 1.5, 0.05, 0.1 }, { 0, 2, 0 } },
  { { 0, 0, 0 }, { 0.05, 1, 0.5 }, { 0.05, 0, 0.5 }, { 1.5, 0.05, 0.1 } },
  { { 0, 2, 0 }, { 1.55, 0.05, 0.6 }, { 1.5, 0.05, 0.1 }, { 3, 0.1, 0.2 } },
  { { 0, 2, 0 }, { 1.55, 0.05, 0.6 }, { 0.05, 1, 0.5 }, { 1.5, 0.05, 0.1 } },
  { { 1.55, 0.05, 0.6 }, { 0.05, 1, 0.5 }, { 0.05, 0, 0.5 }, { 0.1, 0, 1 } },
  { { 1.55, 0.05, 0.6 }, { 0.05, 0, 0.5 }, { 0.05, 1, 0.5 }, { 1.5, 0.05, 0.1 } },
  { { 1.5, 1.05, 0.1 }, { 0, 0, 0 }, { 0.05, 0, 0.5 }, { 0, 2, 0 } },
  { { 1.5, 1.05, 0.1 }, { 0, 0, 0 }, { 1.5, 0.05, 0.1 }, { 0.05, 0, 0.5 } },
  { { 1.5, 1.05, 0.1 }, { 0.1, 0, 1 }, { 0.05, 0, 0.5 }, { 1.55, 0.05, 0.6 } },
  { { 1.5, 1.05, 0.1 }, { 0.1, 0, 1 }, { 0, 2, 0 }, { 0.05, 0, 0.5 } },
  { { 1.5, 0.05, 0.1 }, { 1.5, 1.05, 0.1 }, { 1.55, 0.05, 0.6 }, { 3, 0.1, 0.2 } },
  { { 1.5, 0.05, 0.1 }, { 1.55, 0.05, 0.6 }, { 1.5, 1.05, 0.1 }, { 0.05, 0, 0.5 } },
  { { 0, 1, 0 }, { 0.1, 0, 1 }, { 1.55, 0.05, 0.6 }, { 0, 2, 0 } },
  { { 0, 1, 0 }, { 0.1, 0, 1 }, { 0.05, 0, 0.5 }, { 1.55, 0.05, 0.6 } },
  { { 1.5, 0.05, 0.1 }, { 0, 2, 0 }, { 1.55, 0.05, 0.6 }, { 3, 0.1, 0.2 } },
  { { 1.5, 0.05, 0.1 }, { 0, 2, 0 }, { 0, 1, 0 }, { 1.55, 0.05, 0.6 } },
  { { 0.05, 0, 0.5 }, { 0, 1, 0 }, { 1.5, 0.05, 0.1 }, { 0, 0, 0 } },
  { { 0.05, 0, 0.5 }, { 1.5, 0.05, 0.1 }, { 0, 1, 0 }, { 1.55, 0.05, 0.6 } },
  { { 0.05, 1, 0.5 }, { 0, 0, 0 }, { 1.5, 0.05, 0.1 }, { 0.1, 0, 1 } },
  { { 0.05, 1, 0.5 }, { 0, 0, 0 }, { 0, 1, 0 }, { 1.5, 0.05, 0.1 } },
  { { 1.5, 1.05, 0.1 }, { 0.1, 0, 1 }, { 1.5, 0.05, 0.1 }, { 3, 0.1, 0.2 } },
  { { 1.5, 1.05, 0.1 }, { 0.1, 0, 1 }, { 0.05, 1, 0.5 }, { 1.5, 0.05, 0.1 } },
  { { 0, 1, 0 }, { 0.05, 1, 0.5 }, { 1.5, 1.05, 0.1 }, { 0, 2, 0 } },
  { { 0, 1, 0 }, { 1.5, 1.05, 0.1 }, { 0.05, 1, 0.5 }, { 1.5, 0.05, 0.1 } },
  { { 0, 0, 0 }, { 1.55, 0.05, 0.6 }, { 0, 1, 0 }, { 0.1, 0, 1 } },
  { { 0, 0, 0 }, { 1.55, 0.05, 0.6 }, { 1.5, 0.05, 0.1 }, { 0, 1, 0 } },
  { { 0.1, 0, 1 }, { 1.5, 1.05, 0.1 }, { 0, 1, 0 }, { 0, 2, 0 } },
  { { 0.1, 0, 1 }, { 1.5, 1.05, 0.1 }, { 1.55, 0.05, 0.6 }, { 0, 1, 0 } },
  { { 1.5, 1.05, 0.1 }, { 1.55, 0.05, 0.6 }, { 1.5, 0.05, 0.1 }, { 3, 0.1, 0.2 } },
  { { 1.5, 1.05, 0.1 }, { 1.5, 0.05, 0.1 }, { 1.55, 0.05, 0.6 }, { 0, 1, 0 } },
  { { 1.5, 1.05, 0.1 }, { 0, 1, 0 }, { 0.05, 0, 0.5 }, { 0.1, 0, 1 } },
  { { 1.5, 1.05, 0.1 }, { 0, 1, 0 }, { 0.1, 0, 1 }, { 0, 2, 0 } },
  { { 1.5, 1.05, 0.1 }, { 1.5, 0.05, 0.1 }, { 3, 0.1, 0.2 }, { 0.1, 0, 1 } },
  { { 1.5, 1.05, 0.1 }, { 1.5, 0.05, 0.1 }, { 0.1, 0, 1 }, { 0.05, 0, 0.5 } },
  { { 1.5, 0.05, 0.1 }, { 0.05, 0, 0.5 }, { 0, 1, 0 }, { 0, 0, 0 } },
  { { 1.5, 0.05, 0.1 }, { 0, 1, 0 }, { 0.05, 0, 0.5 }, { 1.5, 1.05, 0.1 } },
  { { 1.55, 0.05, 0.6 }, { 0, 1, 0 }, { 0, 0, 0 }, { 0.05, 0, 0.5 } },
  { { 1.55, 0.05, 0.6 }, { 0, 1, 0 }, { 1.5, 1.05, 0.1 }, { 0, 0, 0 } },
  { { 1.55, 0.05, 0.6 }, { 1.5, 1.05, 0.1 }, { 3, 0.1, 0.2 }, { 0, 0, 0 } },
  { { 0, 1, 0 }, { 1.5, 1.05, 0.1 }, { 0, 2, 0 }, { 0.1, 0, 1 } },
  { { 1.55, 0.05, 0.6 }, { 0, 1, 0 }, { 0.05, 0, 0.5 }, { 0.1, 0, 1 } },
  { { 1.55, 0.05, 0.6 }, { 0, 1, 0 }, { 0.1, 0, 1 }, { 1.5, 1.05, 0.1 } },
  { { 1.5, 0.05, 0.1 }, { 0.05, 1, 0.5 }, { 0, 2, 0 }, { 0, 1, 0 } },
  { { 1.5, 0.05, 0.1 }, { 0.05, 1, 0.5 }, { 1.55, 0.05, 0.6 }, { 0, 2, 0 } },
  { { 1.5, 0.05, 0.1 }, { 1.55, 0.05, 0.6 }, { 3, 0.1, 0.2 }, { 0, 2, 0 } },
  { { 0.05, 1, 0.5 }, { 1.55, 0.05, 0.6 }, { 0.1, 0, 1 }, { 0, 0, 0 } },
  { { 1.5, 0.05, 0.1 }, { 0.05, 1, 0.5 }, { 0, 1, 0 }, { 0, 0, 0 } },
  { { 1.5, 0.05, 0.1 }, { 0.05, 1, 0.5 }, { 0, 0, 0 }, { 1.55, 0.05, 0.6 } },
  { { 1.5, 0.05, 0.1 }, { 0.05, 1, 0.5 }, { 0, 0, 0 }, { 0.05, 0, 0.5 } },
  { { 1.5, 0.05, 0.1 }, { 0.05, 1, 0.5 }, { 1.5, 1.05, 0.1 }, { 0, 0, 0 } },
  { { 1.5, 1.05, 0.1 }, { 0.05, 1, 0.5 }, { 0, 2, 0 }, { 0, 0, 0 } },
  { { 1.5, 1.05, 0.1 }, { 1.5, 0.05, 0.1 }, { 3, 0.1, 0.2 }, { 0.1, 0, 1 } },
  { { 1.5, 0.05, 0.1 }, { 0.05, 1, 0.5 }, { 0.05, 0, 0.5 }, { 0.1, 0, 1 } },
  { { 1.5, 0.05, 0.1 }, { 0.05, 1, 0.5 }, { 0.1, 0, 1 }, { 1.5, 1.05, 0.1 } },
  { { 0, 0, 0 }, { 1.5, 1.05, 0.1 }, { 0, 1, 0 }, { 0.05, 0, 0.5 } },
  { { 0, 0, 0 }, { 1.5, 1.05, 0.1 }, { 0.05, 0, 0.5 }, { 1.55, 0.05, 0.6 } },
  { { 0, 0, 0 }, { 1.5, 1.05, 0.1 }, { 1.55, 0.05, 0.6 }, { 3, 0.1, 0.2 } },
  { { 1.5, 1.05, 0.1 }, { 0.05, 0, 0.5 }, { 0.05, 1, 0.5 }, { 0, 1, 0 } },
  { { 1.5, 1.05, 0.1 }, { 0.05, 0, 0.5 }, { 1.55, 0.05, 0.6 }, { 0.05, 1, 0.5 } },
  { { 0.05, 0, 0.5 }, { 1.55, 0.05, 0.6 }, { 0.05, 1, 0.5 }, { 0.1, 0, 1 } },
  { { 0, 1, 0 }, { 1.5, 1.05, 0.1 }, { 0, 2, 0 }, { 0.05, 1, 0.5 } },
  { { 1.5, 0.05, 0.1 }, { 0, 2, 0 }, { 0, 1, 0 }, { 0.05, 1, 0.5 } },
  { { 1.5, 0.05, 0.1 }, { 0, 2, 0 }, { 0.05, 1, 0.5 }, { 1.55, 0.05, 0.6 } },
  { { 1.5, 0.05, 0.1 }, { 0, 2, 0 }, { 1.55, 0.05, 0.6 }, { 3, 0.1, 0.2 } },
  { { 0.05, 1, 0.5 }, { 1.5, 0.05, 0.1 }, { 0.05, 0, 0.5 }, { 0, 1, 0 } },
  { { 0.05, 1, 0.5 }, { 1.5, 0.05, 0.1 }, { 1.55, 0.05, 0.6 }, { 0.05, 0, 0.5 } },
  { { 1.55, 0.05, 0.6 }, { 0.05, 1, 0.5 }, { 0.05, 0, 0.5 }, { 0.1, 0, 1 } },
  { { 1.5, 0.05, 0.1 }, { 0, 1, 0 }, { 0, 0, 0 }, { 0.05, 0, 0.5 } },
  { { 1.5, 1.05, 0.1 }, { 0, 0, 0 }, { 1.5, 0.05, 0.1 }, { 0.05, 0, 0.5 } },
  { { 1.5, 1.05, 0.1 }, { 0, 0, 0 }, { 0.05, 0, 0.5 }, { 0.05, 1, 0.5 } },
  { { 1.5, 1.05, 0.1 }, { 0, 0, 0 }, { 0.05, 1, 0.5 }, { 0, 2, 0 } },
  { { 0.05, 0, 0.5 }, { 1.5, 1.05, 0.1 }, { 1.55, 0.05, 0.6 }, { 1.5, 0.05, 0.1 } },
  { { 0.05, 0, 0.5 }, { 1.5, 1.05, 0.1 }, { 0.05, 1, 0.5 }, { 1.55, 0.05, 0.6 } },
  { { 0.05, 1, 0.5 }, { 0.05, 0, 0.5 }, { 1.55, 0.05, 0.6 }, { 0.1, 0, 1 } },
  { { 1.5, 1.05, 0.1 }, { 1.5, 0.05, 0.1 }, { 3, 0.1, 0.2 }, { 1.55, 0.05, 0.6 } },
  { { 0.05, 1, 0.5 }, { 0, 0, 0 }, { 0, 1, 0 }, { 1.5, 0.05, 0.1 } },
  { { 0.05, 1, 0.5 }, { 0, 0, 0 }, { 1.5, 0.05, 0.1 }, { 1.55, 0.05, 0.6 } },
  { { 0.05, 1, 0.5 }, { 0, 0, 0 }, { 1.55, 0.05, 0.6 }, { 0.1, 0, 1 } },
  { { 1.5, 0.05, 0.1 }, { 0.05, 1, 0.5 }, { 1.5, 1.05, 0.1 }, { 0, 1, 0 } },
  { { 1.5, 0.05, 0.1 }, { 0.05, 1, 0.5 }, { 1.55, 0.05, 0.6 }, { 1.5, 1.05, 0.1 } },
  { { 1.55, 0.05, 0.6 }, { 1.5, 0.05, 0.1 }, { 1.5, 1.05, 0.1 }, { 3, 0.1, 0.2 } },
  { { 0.05, 1, 0.5 }, { 0, 1, 0 }, { 0, 2, 0 }, { 1.5, 1.05, 0.1 } },
  { { 1.5, 1.05, 0.1 }, { 0.1, 0, 1 }, { 0.05, 1, 0.5 }, { 0.05, 0, 0.5 } },
  { { 1.5, 1.05, 0.1 }, { 0.1, 0, 1 }, { 0.05, 0, 0.5 }, { 1.5, 0.05, 0.1 } },
  { { 1.5, 1.05, 0.1 }, { 0.1, 0, 1 }, { 1.5, 0.05, 0.1 }, { 3, 0.1, 0.2 } },
  { { 0.05, 0, 0.5 }, { 1.5, 1.05, 0.1 }, { 0, 1, 0 }, { 0.05, 1, 0.5 } },
  { { 0.05, 0, 0.5 }, { 1.5, 1.05, 0.1 }, { 1.5, 0.05, 0.1 }, { 0, 1, 0 } },
  { { 1.5, 0.05, 0.1 }, { 0.05, 0, 0.5 }, { 0, 1, 0 }, { 0, 0, 0 } },
  { { 1.5, 1.05, 0.1 }, { 0.05, 1, 0.5 }, { 0, 2, 0 }, { 0, 1, 0 } },
  { { 0.1, 0, 1 }, { 1.5, 1.05, 0.1 }, { 1.55, 0.05, 0.6 }, { 0.05, 0, 0.5 } },
  { { 0.1, 0, 1 }, { 1.5, 1.05, 0.1 }, { 0.05, 0, 0.5 }, { 0, 1, 0 } },
  { { 0.1, 0, 1 }, { 1.5, 1.05, 0.1 }, { 0, 1, 0 }, { 0, 2, 0 } },
  { { 1.5, 1.05, 0.1 }, { 0.05, 0, 0.5 }, { 1.5, 0.05, 0.1 }, { 1.55, 0.05, 0.6 } },
  { { 1.5, 1.05, 0.1 }, { 0.05, 0, 0.5 }, { 0, 1, 0 }, { 1.5, 0.05, 0.1 } },
  { { 0.05, 0, 0.5 }, { 0, 1, 0 }, { 1.5, 0.05, 0.1 }, { 0, 0, 0 } },
  { { 1.55, 0.05, 0.6 }, { 1.5, 1.05, 0.1 }, { 3, 0.1, 0.2 }, { 1.5, 0.05, 0.1 } },
  { { 0, 1, 0 }, { 1.5, 0.05, 0.1 }, { 1.5, 1.05, 0.1 }, { 1.55, 0.05, 0.6 } },
  { { 0, 1, 0 }, { 1.5, 1.05, 0.1 }, { 0.05, 1, 0.5 }, { 1.55, 0.05, 0.6 } },
  { { 0, 1, 0 }, { 0.05, 1, 0.5 }, { 0.05, 0, 0.5 }, { 1.55, 0.05, 0.6 } },
  { { 0, 1, 0 }, { 0.05, 0, 0.5 }, { 1.5, 0.05, 0.1 }, { 1.55, 0.05, 0.6 } },
  { { 0.05, 0, 0.5 }, { 1.55, 0.05, 0.6 }, { 0.05, 1, 0.5 }, { 0.1, 0, 1 } },
  { { 0, 1, 0 }, { 1.5, 1.05, 0.1 }, { 0, 2, 0 }, { 0.05, 1, 0.5 } },
  { { 1.5, 0.05, 0.1 }, { 3, 0.1, 0.2 }, { 1.5, 1.05, 0.1 }, { 1.55, 0.05, 0.6 } },
  { { 0, 0, 0 }, { 1.5, 0.05, 0.1 }, { 0, 1, 0 }, { 0.05, 0, 0.5 } },
  { { 0, 0, 0 }, { 2, 0, 0 }, { 0, 1, 0.1 }, { 0.1, 0.2, 3 } },
  { { 0, 0, 0 }, { 1, 0, 0 }, { 0, 1, 0.1 }, { 0.1, 0.2, 3 } },
  { { 1, 0, 0 }, { 2, 0, 0 }, { 0, 1, 0.1 }, { 0.1, 0.2, 3 } },
  { { 2, 0, 0 }, { 1, 0.5, 0.05 }, { 0, 0, 0 }, { 0.1, 0.2, 3 } },
  { { 1, 0.5, 0.05 }, { 0, 1, 0.1 }, { 0, 0, 0 }, { 0.1, 0.2, 3 } },
  { { 0, 1, 0.1 }, { 0, 0.5, 0.05 }, { 2, 0, 0 }, { 0.1, 0.2, 3 } },
  { { 0, 0.5, 0.05 }, { 0, 0, 0 }, { 2, 0, 0 }, { 0.1, 0.2, 3 } },
  { { 0.1, 0.2, 3 }, { 0.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 2, 0, 0 } },
  { { 0.05, 0.1, 1.5 }, { 0, 0, 0 }, { 0, 1, 0.1 }, { 2, 0, 0 } },
  { { 2, 0, 0 }, { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 0, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 0.1, 0.2, 3 }, { 0, 1, 0.1 }, { 0, 0, 0 } },
  { { 0.1, 0.2, 3 }, { 0.05, 0.6, 1.55 }, { 2, 0, 0 }, { 0, 0, 0 } },
  { { 0.05, 0.6, 1.55 }, { 0, 1, 0.1 }, { 2, 0, 0 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 1, 0, 0 }, { 1, 0.5, 0.05 }, { 0.1, 0.2, 3 } },
  { { 0, 0, 0 }, { 1, 0.5, 0.05 }, { 0, 1, 0.1 }, { 0.1, 0.2, 3 } },
  { { 0.1, 0.2, 3 }, { 1, 0, 0 }, { 1, 0.5, 0.05 }, { 2, 0, 0 } },
  { { 0, 1, 0.1 }, { 0, 0.5, 0.05 }, { 1, 0, 0 }, { 0.1, 0.2, 3 } },
  { { 0, 1, 0.1 }, { 1, 0, 0 }, { 2, 0, 0 }, { 0.1, 0.2, 3 } },
  { { 0.1, 0.2, 3 }, { 0, 0.5, 0.05 }, { 1, 0, 0 }, { 0, 0, 0 } },
  { { 2, 0, 0 }, { 1, 0.5, 0.05 }, { 0, 0, 0 }, { 0.1, 0.2, 3 } },
  { { 1, 0.5, 0.05 }, { 0, 0.5, 0.05 }, { 0, 0, 0 }, { 0.1, 0.2, 3 } },
  { { 0.1, 0.2, 3 }, { 1, 0.5, 0.05 }, { 0, 0.5, 0.05 }, { 0, 1, 0.1 } },
  { { 2, 0, 0 }, { 1, 0, 0 }, { 0.05, 0.1, 1.5 }, { 0, 1, 0.1 } },
  { { 2, 0, 0 }, { 0.05, 0.1, 1.5 }, { 0.1, 0.2, 3 }, { 0, 1, 0.1 } },
  { { 0, 1, 0.1 }, { 1, 0, 0 }, { 0.05, 0.1, 1.5 }, { 0, 0, 0 } },
  { { 0.1, 0.2, 3 }, { 1.05, 0.1, 1.5 }, { 0, 0, 0 }, { 0, 1, 0.1 } },
  { { 1.05, 0.1, 1.5 }, { 1, 0, 0 }, { 0, 0, 0 }, { 0, 1, 0.1 } },
  { { 0, 1, 0.1 }, { 1.05, 0.1, 1.5 }, { 1, 0, 0 }, { 2, 0, 0 } },
  { { 0, 0, 0 }, { 0.05, 0.1, 1.5 }, { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 } },
  { { 0, 0, 0 }, { 1.05, 0.1, 1.5 }, { 2, 0, 0 }, { 0, 1, 0.1 } },
  { { 0, 1, 0.1 }, { 0.05, 0.1, 1.5 }, { 1.05, 0.1, 1.5 }, { 0.1, 0.2, 3 } },
  { { 0, 1, 0.1 }, { 1, 0.5, 0.05 }, { 1.05, 0.1, 1.5 }, { 0, 0, 0 } },
  { { 0, 1, 0.1 }, { 1.05, 0.1, 1.5 }, { 0.1, 0.2, 3 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 1, 0.5, 0.05 }, { 1.05, 0.1, 1.5 }, { 2, 0, 0 } },
  { { 0.1, 0.2, 3 }, { 0.05, 0.6, 1.55 }, { 2, 0, 0 }, { 0, 0, 0 } },
  { { 0.05, 0.6, 1.55 }, { 1, 0.5, 0.05 }, { 2, 0, 0 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0.05, 0.6, 1.55 }, { 1, 0.5, 0.05 }, { 0, 1, 0.1 } },
  { { 2, 0, 0 }, { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 0, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 }, { 0, 1, 0.1 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 1.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 }, { 0.1, 0.2, 3 } },
  { { 0.1, 0.2, 3 }, { 0.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 2, 0, 0 } },
  { { 0.05, 0.1, 1.5 }, { 0, 0.5, 0.05 }, { 0, 1, 0.1 }, { 2, 0, 0 } },
  { { 2, 0, 0 }, { 0.05, 0.1, 1.5 }, { 0, 0.5, 0.05 }, { 0, 0, 0 } },
  { { 0, 0, 0 }, { 0, 0.5, 0.05 }, { 0.05, 0.6, 1.55 }, { 2, 0, 0 } },
  { { 0, 0, 0 }, { 0.05, 0.6, 1.55 }, { 0.1, 0.2, 3 }, { 2, 0, 0 } },
  { { 2, 0, 0 }, { 0, 0.5, 0.05 }, { 0.05, 0.6, 1.55 }, { 0, 1, 0.1 } },
  { { 0, 1, 0.1 }, { 0.05, 0.6, 1.55 }, { 0, 0, 0 }, { 2, 0, 0 } },
  { { 0.05, 0.6, 1.55 }, { 0.05, 0.1, 1.5 }, { 0, 0, 0 }, { 2, 0, 0 } },
  { { 2, 0, 0 }, { 0.05, 0.6, 1.55 }, { 0.05, 0.1, 1.5 }, { 0.1, 0.2, 3 } },
  { { 0, 0, 0 }, { 1, 0, 0 }, { 0.05, 0.6, 1.55 }, { 0.1, 0.2, 3 } },
  { { 1, 0, 0 }, { 2, 0, 0 }, { 0.05, 0.6, 1.55 }, { 0.1, 0.2, 3 } },
  { { 0, 0, 0 }, { 1, 0, 0 }, { 0, 1, 0.1 }, { 0.05, 0.6, 1.55 } },
  { { 1, 0, 0 }, { 2, 0, 0 }, { 0, 1, 0.1 }, { 0.05, 0.6, 1.55 } },
  { { 2, 0, 0 }, { 1, 0.5, 0.05 }, { 0.05, 0.1, 1.5 }, { 0.1, 0.2, 3 } },
  { { 1, 0.5, 0.05 }, { 0, 1, 0.1 }, { 0.05, 0.1, 1.5 }, { 0.1, 0.2, 3 } },
  { { 2, 0, 0 }, { 1, 0.5, 0.05 }, { 0, 0, 0 }, { 0.05, 0.1, 1.5 } },
  { { 1, 0.5, 0.05 }, { 0, 1, 0.1 }, { 0, 0, 0 }, { 0.05, 0.1, 1.5 } },
  { { 0, 1, 0.1 }, { 0, 0.5, 0.05 }, { 1.05, 0.1, 1.5 }, { 0.1, 0.2, 3 } },
  { { 0, 0.5, 0.05 }, { 0, 0, 0 }, { 1.05, 0.1, 1.5 }, { 0.1, 0.2, 3 } },
  { { 0, 1, 0.1 }, { 0, 0.5, 0.05 }, { 2, 0, 0 }, { 1.05, 0.1, 1.5 } },
  { { 0, 0.5, 0.05 }, { 0, 0, 0 }, { 2, 0, 0 }, { 1.05, 0.1, 1.5 } },
  { { 0.1, 0.2, 3 }, { 0, 1, 0.1 }, { 2, 0, 0 }, { 0.05, 0.1, 1.5 } },
  { { 0.05, 0.1, 1.5 }, { 1, 0, 0 }, { 0, 1, 0.1 }, { 2, 0, 0 } },
  { { 0.05, 0.1, 1.5 }, { 1, 0, 0 }, { 0, 0.5, 0.05 }, { 0, 1, 0.1 } },
  { { 1, 0, 0 }, { 0.05, 0.1, 1.5 }, { 0, 0.5, 0.05 }, { 0, 0, 0 } },
  { { 0.1, 0.2, 3 }, { 0, 0, 0 }, { 0, 1, 0.1 }, { 1.05, 0.1, 1.5 } },
  { { 1.05, 0.1, 1.5 }, { 1, 0.5, 0.05 }, { 0, 0, 0 }, { 0, 1, 0.1 } },
  { { 1.05, 0.1, 1.5 }, { 1, 0.5, 0.05 }, { 1, 0, 0 }, { 0, 0, 0 } },
  { { 1, 0.5, 0.05 }, { 1.05, 0.1, 1.5 }, { 1, 0, 0 }, { 2, 0, 0 } },
  { { 0, 0, 0 }, { 0.1, 0.2, 3 }, { 2, 0, 0 }, { 0.05, 0.6, 1.55 } },
  { { 1, 0.5, 0.05 }, { 0.05, 0.6, 1.55 }, { 0, 0, 0 }, { 2, 0, 0 } },
  { { 1, 0.5, 0.05 }, { 0.05, 0.6, 1.55 }, { 0, 0.5, 0.05 }, { 0, 0, 0 } },
  { { 0, 0.5, 0.05 }, { 0.05, 0.6, 1.55 }, { 1, 0.5, 0.05 }, { 0, 1, 0.1 } },
  { { 0, 0, 0 }, { 2, 0, 0 }, { 0, 1, 0.1 }, { 1.05, 0.1, 1.5 } },
  { { 0.05, 0.6, 1.55 }, { 1.05, 0.1, 1.5 }, { 0, 0, 0 }, { 0, 1, 0.1 } },
  { { 0.05, 0.6, 1.55 }, { 1.05, 0.1, 1.5 }, { 0.05, 0.1, 1.5 }, { 0, 0, 0 } },
  { { 0.05, 0.1, 1.5 }, { 1.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 }, { 0.1, 0.2, 3 } },
  { { 0, 0, 0 }, { 0.05, 0.1, 1.5 }, { 1, 0, 0 }, { 0, 1, 0.1 } },
  { { 1, 0, 0 }, { 0.05, 0.1, 1.5 }, { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 } },
  { { 1, 0, 0 }, { 1.05, 0.1, 1.5 }, { 2, 0, 0 }, { 0, 1, 0.1 } },
  { { 0.05, 0.1, 1.5 }, { 0.1, 0.2, 3 }, { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 } },
  { { 2, 0, 0 }, { 1.05, 0.1, 1.5 }, { 1, 0.5, 0.05 }, { 0, 0, 0 } },
  { { 1, 0.5, 0.05 }, { 1.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 }, { 0, 0, 0 } },
  { { 1, 0.5, 0.05 }, { 0.05, 0.6, 1.55 }, { 0, 1, 0.1 }, { 0, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 0.1, 0.2, 3 }, { 0.05, 0.6, 1.55 }, { 0, 0, 0 } },
  { { 0.1, 0.2, 3 }, { 0.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 }, { 2, 0, 0 } },
  { { 0.05, 0.6, 1.55 }, { 0.05, 0.1, 1.5 }, { 0, 0.5, 0.05 }, { 2, 0, 0 } },
  { { 0.05, 0.6, 1.55 }, { 0, 0.5, 0.05 }, { 0, 1, 0.1 }, { 2, 0, 0 } },
  { { 0.05, 0.1, 1.5 }, { 0, 0, 0 }, { 0, 0.5, 0.05 }, { 2, 0, 0 } },
  { { 0, 0, 0 }, { 1, 0, 0 }, { 0, 0.5, 0.05 }, { 0.1, 0.2, 3 } },
  { { 0, 0.5, 0.05 }, { 1, 0, 0 }, { 1, 0.5, 0.05 }, { 0.1, 0.2, 3 } },
  { { 0, 0.5, 0.05 }, { 1, 0.5, 0.05 }, { 0, 1, 0.1 }, { 0.1, 0.2, 3 } },
  { { 1, 0, 0 }, { 2, 0, 0 }, { 1, 0.5, 0.05 }, { 0.1, 0.2, 3 } },
  { { 1.05, 0.1, 1.5 }, { 0, 0, 0 }, { 0, 0.5, 0.05 }, { 1, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 0, 0, 0 }, { 0.1, 0.2, 3 }, { 0, 0.5, 0.05 } },
  { { 1, 0, 0 }, { 0, 1, 0.1 }, { 1.05, 0.1, 1.5 }, { 2, 0, 0 } },
  { { 1, 0, 0 }, { 0, 1, 0.1 }, { 0, 0.5, 0.05 }, { 1.05, 0.1, 1.5 } },
  { { 0, 1, 0.1 }, { 0.1, 0.2, 3 }, { 0, 0.5, 0.05 }, { 1.05, 0.1, 1.5 } },
  { { 0, 0, 0 }, { 1, 0.5, 0.05 }, { 0, 1, 0.1 }, { 0.05, 0.1, 1.5 } },
  { { 0, 0, 0 }, { 1, 0.5, 0.05 }, { 0.05, 0.1, 1.5 }, { 1, 0, 0 } },
  { { 0.05, 0.1, 1.5 }, { 2, 0, 0 }, { 1, 0, 0 }, { 1, 0.5, 0.05 } },
  { { 0.05, 0.1, 1.5 }, { 2, 0, 0 }, { 1, 0.5, 0.05 }, { 0.1, 0.2, 3 } },
  { { 0.1, 0.2, 3 }, { 1, 0.5, 0.05 }, { 0.05, 0.1, 1.5 }, { 0, 1, 0.1 } },
  { { 0.05, 0.6, 1.55 }, { 2, 0, 0 }, { 1, 0, 0 }, { 1, 0.5, 0.05 } },
  { { 0.05, 0.6, 1.55 }, { 2, 0, 0 }, { 0.1, 0.2, 3 }, { 1, 0, 0 } },
  { { 1, 0.5, 0.05 }, { 0, 0, 0 }, { 0.05, 0.6, 1.55 }, { 0, 1, 0.1 } },
  { { 1, 0.5, 0.05 }, { 0, 0, 0 }, { 1, 0, 0 }, { 0.05, 0.6, 1.55 } },
  { { 0, 0, 0 }, { 0.1, 0.2, 3 }, { 1, 0, 0 }, { 0.05, 0.6, 1.55 } },
  { { 1, 0.5, 0.05 }, { 0, 0, 0 }, { 1.05, 0.1, 1.5 }, { 0, 0.5, 0.05 } },
  { { 1, 0.5, 0.05 }, { 0, 0, 0 }, { 2, 0, 0 }, { 1.05, 0.1, 1.5 } },
  { { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 1, 0.5, 0.05 }, { 0, 0.5, 0.05 } },
  { { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 0, 0.5, 0.05 }, { 0.1, 0.2, 3 } },
  { { 0.1, 0.2, 3 }, { 0, 0.5, 0.05 }, { 1.05, 0.1, 1.5 }, { 0, 0, 0 } },
  { { 0, 1, 0.1 }, { 1, 0, 0 }, { 2, 0, 0 }, { 0.05, 0.6, 1.55 } },
  { { 0, 1, 0.1 }, { 1, 0, 0 }, { 0.05, 0.6, 1.55 }, { 0, 0.5, 0.05 } },
  { { 0.05, 0.6, 1.55 }, { 0, 0, 0 }, { 0, 0.5, 0.05 }, { 1, 0, 0 } },
  { { 0.05, 0.6, 1.55 }, { 0, 0, 0 }, { 1, 0, 0 }, { 0.1, 0.2, 3 } },
  { { 0.1, 0.2, 3 }, { 1, 0, 0 }, { 0.05, 0.6, 1.55 }, { 2, 0, 0 } },
  { { 0.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 1, 0.5, 0.05 }, { 0, 0.5, 0.05 } },
  { { 0.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 0.1, 0.2, 3 }, { 1, 0.5, 0.05 } },
  { { 1, 0.5, 0.05 }, { 0, 0, 0 }, { 0.05, 0.1, 1.5 }, { 0, 0.5, 0.05 } },
  { { 1, 0.5, 0.05 }, { 0, 0, 0 }, { 2, 0, 0 }, { 0.05, 0.1, 1.5 } },
  { { 2, 0, 0 }, { 0.1, 0.2, 3 }, { 1, 0.5, 0.05 }, { 0.05, 0.1, 1.5 } },
  { { 1.05, 0.1, 1.5 }, { 0, 0, 0 }, { 0.05, 0.6, 1.55 }, { 1, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 0, 0, 0 }, { 0.1, 0.2, 3 }, { 0.05, 0.6, 1.55 } },
  { { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 2, 0, 0 }, { 1, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 1, 0, 0 }, { 0.05, 0.6, 1.55 } },
  { { 0, 1, 0.1 }, { 1, 0, 0 }, { 0.05, 0.6, 1.55 }, { 0, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 0.05, 0.1, 1.5 }, { 0.1, 0.2, 3 } },
  { { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 1, 0.5, 0.05 }, { 0.05, 0.1, 1.5 } },
  { { 1.05, 0.1, 1.5 }, { 0, 0, 0 }, { 1, 0.5, 0.05 }, { 2, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 0, 0, 0 }, { 0.05, 0.1, 1.5 }, { 1, 0.5, 0.05 } },
  { { 0, 0, 0 }, { 0, 1, 0.1 }, { 0.05, 0.1, 1.5 }, { 1, 0.5, 0.05 } },
  { { 0.05, 0.6, 1.55 }, { 0, 0, 0 }, { 1.05, 0.1, 1.5 }, { 0.1, 0.2, 3 } },
  { { 0.05, 0.6, 1.55 }, { 0, 0, 0 }, { 0, 0.5, 0.05 }, { 1.05, 0.1, 1.5 } },
  { { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 0, 0.5, 0.05 }, { 0.05, 0.6, 1.55 } },
  { { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 2, 0, 0 }, { 0, 0.5, 0.05 } },
  { { 2, 0, 0 }, { 0, 0, 0 }, { 1.05, 0.1, 1.5 }, { 0, 0.5, 0.05 } },
  { { 0.05, 0.6, 1.55 }, { 2, 0, 0 }, { 0.05, 0.1, 1.5 }, { 1, 0.5, 0.05 } },
  { { 0.05, 0.6, 1.55 }, { 2, 0, 0 }, { 0.1, 0.2, 3 }, { 0.05, 0.1, 1.5 } },
  { { 0.05, 0.6, 1.55 }, { 0, 0, 0 }, { 0, 1, 0.1 }, { 1, 0.5, 0.05 } },
  { { 0.05, 0.6, 1.55 }, { 0, 0, 0 }, { 1, 0.5, 0.05 }, { 0.05, 0.1, 1.5 } },
  { { 0, 0, 0 }, { 1, 0.5, 0.05 }, { 0.05, 0.1, 1.5 }, { 2, 0, 0 } },
  { { 0.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 1.05, 0.1, 1.5 }, { 0, 0.5, 0.05 } },
  { { 0.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 0.1, 0.2, 3 }, { 1.05, 0.1, 1.5 } },
  { { 1.05, 0.1, 1.5 }, { 0, 0, 0 }, { 0.05, 0.1, 1.5 }, { 0, 0.5, 0.05 } },
  { { 1.05, 0.1, 1.5 }, { 0, 0, 0 }, { 0, 0.5, 0.05 }, { 2, 0, 0 } },
  { { 2, 0, 0 }, { 0, 0.5, 0.05 }, { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 } },
  { { 0.05, 0.1, 1.5 }, { 2, 0, 0 }, { 0.05, 0.6, 1.55 }, { 0.1, 0.2, 3 } },
  { { 0.05, 0.1, 1.5 }, { 2, 0, 0 }, { 1, 0, 0 }, { 0.05, 0.6, 1.55 } },
  { { 0.05, 0.6, 1.55 }, { 0, 0, 0 }, { 1, 0, 0 }, { 0.05, 0.1, 1.5 } },
  { { 0.05, 0.6, 1.55 }, { 0, 0, 0 }, { 0, 1, 0.1 }, { 1, 0, 0 } },
  { { 0, 1, 0.1 }, { 2, 0, 0 }, { 0.05, 0.6, 1.55 }, { 1, 0, 0 } },
  { { 1, 0.5, 0.05 }, { 1.05, 0.1, 1.5 }, { 0.05, 0.1, 1.5 }, { 0, 0, 0 } },
  { { 1, 0.5, 0.05 }, { 1.05, 0.1, 1.5 }, { 0, 0, 0 }, { 2, 0, 0 } },
  { { 1, 0.5, 0.05 }, { 0.05, 0.6, 1.55 }, { 0, 1, 0.1 }, { 0, 0, 0 } },
  { { 1, 0.5, 0.05 }, { 0.05, 0.6, 1.55 }, { 0, 0, 0 }, { 0.05, 0.1, 1.5 } },
  { { 0.05, 0.6, 1.55 }, { 0.05, 0.1, 1.5 }, { 1.05, 0.1, 1.5 }, { 0.1, 0.2, 3 } },
  { { 0.05, 0.6, 1.55 }, { 1.05, 0.1, 1.5 }, { 0.05, 0.1, 1.5 }, { 1, 0.5, 0.05 } },
  { { 1.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 }, { 0, 0.5, 0.05 }, { 0, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 }, { 0, 0, 0 }, { 0.1, 0.2, 3 } },
  { { 1.05, 0.1, 1.5 }, { 1, 0.5, 0.05 }, { 2, 0, 0 }, { 0, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 1, 0.5, 0.05 }, { 0, 0, 0 }, { 0, 0.5, 0.05 } },
  { { 1, 0.5, 0.05 }, { 0, 0.5, 0.05 }, { 0.05, 0.6, 1.55 }, { 0, 1, 0.1 } },
  { { 1, 0.5, 0.05 }, { 0.05, 0.6, 1.55 }, { 0, 0.5, 0.05 }, { 1.05, 0.1, 1.5 } },
  { { 0.05, 0.6, 1.55 }, { 1, 0.5, 0.05 }, { 1, 0, 0 }, { 0, 0, 0 } },
  { { 0.05, 0.6, 1.55 }, { 1, 0.5, 0.05 }, { 0, 0, 0 }, { 0, 1, 0.1 } },
  { { 0.05, 0.6, 1.55 }, { 1.05, 0.1, 1.5 }, { 0.1, 0.2, 3 }, { 0, 0, 0 } },
  { { 0.05, 0.6, 1.55 }, { 1.05, 0.1, 1.5 }, { 0, 0, 0 }, { 1, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 1, 0, 0 }, { 1, 0.5, 0.05 }, { 2, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 1, 0.5, 0.05 }, { 1, 0, 0 }, { 0.05, 0.6, 1.55 } },
  { { 1.05, 0.1, 1.5 }, { 0, 0, 0 }, { 0, 0.5, 0.05 }, { 2, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 0, 0, 0 }, { 0.05, 0.1, 1.5 }, { 0, 0.5, 0.05 } },
  { { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 0, 0.5, 0.05 }, { 0.05, 0.6, 1.55 } },
  { { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 2, 0, 0 }, { 0, 0.5, 0.05 } },
  { { 0.05, 0.1, 1.5 }, { 1.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 }, { 0.1, 0.2, 3 } },
  { { 0.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 }, { 1.05, 0.1, 1.5 }, { 0, 0.5, 0.05 } },
  { { 0, 0, 0 }, { 1, 0.5, 0.05 }, { 0.05, 0.1, 1.5 }, { 2, 0, 0 } },
  { { 0, 0, 0 }, { 1, 0.5, 0.05 }, { 0, 0.5, 0.05 }, { 0.05, 0.1, 1.5 } },
  { { 2, 0, 0 }, { 0.05, 0.6, 1.55 }, { 0.05, 0.1, 1.5 }, { 0.1, 0.2, 3 } },
  { { 2, 0, 0 }, { 0.05, 0.6, 1.55 }, { 1, 0.5, 0.05 }, { 0.05, 0.1, 1.5 } },
  { { 0.05, 0.6, 1.55 }, { 1, 0.5, 0.05 }, { 0, 0.5, 0.05 }, { 0, 1, 0.1 } },
  { { 0.05, 0.6, 1.55 }, { 0, 0.5, 0.05 }, { 1, 0.5, 0.05 }, { 0.05, 0.1, 1.5 } },
  { { 1, 0, 0 }, { 0, 1, 0.1 }, { 0.05, 0.6, 1.55 }, { 2, 0, 0 } },
  { { 1, 0, 0 }, { 0, 1, 0.1 }, { 0, 0.5, 0.05 }, { 0.05, 0.6, 1.55 } },
  { { 0.05, 0.1, 1.5 }, { 2, 0, 0 }, { 0.05, 0.6, 1.55 }, { 0.1, 0.2, 3 } },
  { { 0.05, 0.1, 1.5 }, { 2, 0, 0 }, { 1, 0, 0 }, { 0.05, 0.6, 1.55 } },
  { { 0, 0.5, 0.05 }, { 1, 0, 0 }, { 0.05, 0.1, 1.5 }, { 0, 0, 0 } },
  { { 0, 0.5, 0.05 }, { 0.05, 0.1, 1.5 }, { 1, 0, 0 }, { 0.05, 0.6, 1.55 } },
  { { 0, 0, 0 }, { 0.05, 0.6, 1.55 }, { 1, 0, 0 }, { 0, 1, 0.1 } },
  { { 0, 0, 0 }, { 0.05, 0.6, 1.55 }, { 0.05, 0.1, 1.5 }, { 1, 0, 0 } },
  { { 0, 1, 0.1 }, { 1.05, 0.1, 1.5 }, { 1, 0, 0 }, { 2, 0, 0 } },
  { { 0, 1, 0.1 }, { 1.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 }, { 1, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 }, { 0.05, 0.1, 1.5 }, { 0.1, 0.2, 3 } },
  { { 1.05, 0.1, 1.5 }, { 0.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 }, { 1, 0, 0 } },
  { { 1, 0.5, 0.05 }, { 0, 0, 0 }, { 0.05, 0.1, 1.5 }, { 0, 1, 0.1 } },
  { { 1, 0.5, 0.05 }, { 0, 0, 0 }, { 1, 0, 0 }, { 0.05, 0.1, 1.5 } },
  { { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 0.05, 0.1, 1.5 }, { 0.1, 0.2, 3 } },
  { { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 1, 0.5, 0.05 }, { 0.05, 0.1, 1.5 } },
  { { 1, 0, 0 }, { 1, 0.5, 0.05 }, { 1.05, 0.1, 1.5 }, { 2, 0, 0 } },
  { { 1, 0, 0 }, { 1.05, 0.1, 1.5 }, { 1, 0.5, 0.05 }, { 0.05, 0.1, 1.5 } },
  { { 1.05, 0.1, 1.5 }, { 1, 0, 0 }, { 0, 0.5, 0.05 }, { 0, 1, 0.1 } },
  { { 1.05, 0.1, 1.5 }, { 1, 0, 0 }, { 0, 1, 0.1 }, { 2, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 0.05, 0.1, 1.5 }, { 0.1, 0.2, 3 }, { 0, 1, 0.1 } },
  { { 1.05, 0.1, 1.5 }, { 0.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 0, 0.5, 0.05 } },
  { { 0.05, 0.1, 1.5 }, { 0, 0.5, 0.05 }, { 1, 0, 0 }, { 0, 0, 0 } },
  { { 0.05, 0.1, 1.5 }, { 1, 0, 0 }, { 0, 0.5, 0.05 }, { 1.05, 0.1, 1.5 } },
  { { 0.05, 0.6, 1.55 }, { 0, 0, 0 }, { 1, 0, 0 }, { 0.1, 0.2, 3 } },
  { { 0.05, 0.6, 1.55 }, { 0, 0, 0 }, { 0, 0.5, 0.05 }, { 1, 0, 0 } },
  { { 0.05, 0.6, 1.55 }, { 2, 0, 0 }, { 1, 0, 0 }, { 1, 0.5, 0.05 } },
  { { 0.05, 0.6, 1.55 }, { 2, 0, 0 }, { 0.1, 0.2, 3 }, { 1, 0, 0 } },
  { { 0, 0.5, 0.05 }, { 0.05, 0.6, 1.55 }, { 1, 0.5, 0.05 }, { 0, 1, 0.1 } },
  { { 0, 0.5, 0.05 }, { 1, 0.5, 0.05 }, { 0.05, 0.6, 1.55 }, { 1, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 0, 0.5, 0.05 }, { 0.1, 0.2, 3 } },
  { { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 1, 0.5, 0.05 }, { 0, 0.5, 0.05 } },
  { { 1.05, 0.1, 1.5 }, { 0, 0, 0 }, { 0, 0.5, 0.05 }, { 1, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 0, 0, 0 }, { 0.1, 0.2, 3 }, { 0, 0.5, 0.05 } },
  { { 1, 0.5, 0.05 }, { 1.05, 0.1, 1.5 }, { 1, 0, 0 }, { 2, 0, 0 } },
  { { 1, 0.5, 0.05 }, { 1, 0, 0 }, { 1.05, 0.1, 1.5 }, { 0, 0.5, 0.05 } },
  { { 0.05, 0.1, 1.5 }, { 2, 0, 0 }, { 1, 0.5, 0.05 }, { 0.1, 0.2, 3 } },
  { { 0.05, 0.1, 1.5 }, { 2, 0, 0 }, { 1, 0, 0 }, { 1, 0.5, 0.05 } },
  { { 0.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 1, 0.5, 0.05 }, { 0, 0.5, 0.05 } },
  { { 0.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 0.1, 0.2, 3 }, { 1, 0.5, 0.05 } },
  { { 1, 0, 0 }, { 0.05, 0.1, 1.5 }, { 0, 0.5, 0.05 }, { 0, 0, 0 } },
  { { 1, 0, 0 }, { 0, 0.5, 0.05 }, { 0.05, 0.1, 1.5 }, { 1, 0.5, 0.05 } },
  { { 0.05, 0.1, 1.5 }, { 1, 0.5, 0.05 }, { 0, 0, 0 }, { 0, 0.5, 0.05 } },
  { { 0.05, 0.1, 1.5 }, { 1, 0.5, 0.05 }, { 1.05, 0.1, 1.5 }, { 0, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 1, 0.5, 0.05 }, { 2, 0, 0 }, { 0, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 0.05, 0.1, 1.5 }, { 0.1, 0.2, 3 }, { 0, 1, 0.1 } },
  { { 0.05, 0.1, 1.5 }, { 1, 0.5, 0.05 }, { 0, 0.5, 0.05 }, { 0, 1, 0.1 } },
  { { 0.05, 0.1, 1.5 }, { 1, 0.5, 0.05 }, { 0, 1, 0.1 }, { 1.05, 0.1, 1.5 } },
  { { 1, 0, 0 }, { 0.05, 0.6, 1.55 }, { 0, 1, 0.1 }, { 0, 0.5, 0.05 } },
  { { 1, 0, 0 }, { 0.05, 0.6, 1.55 }, { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 } },
  { { 1, 0, 0 }, { 1.05, 0.1, 1.5 }, { 2, 0, 0 }, { 0, 1, 0.1 } },
  { { 0.05, 0.6, 1.55 }, { 1.05, 0.1, 1.5 }, { 0.1, 0.2, 3 }, { 0, 0, 0 } },
  { { 1, 0, 0 }, { 0.05, 0.6, 1.55 }, { 0, 0.5, 0.05 }, { 0, 0, 0 } },
  { { 1, 0, 0 }, { 0.05, 0.6, 1.55 }, { 0, 0, 0 }, { 1.05, 0.1, 1.5 } },
  { { 1, 0.5, 0.05 }, { 0.05, 0.1, 1.5 }, { 0, 0, 0 }, { 1, 0, 0 } },
  { { 1, 0.5, 0.05 }, { 0.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 }, { 0, 0, 0 } },
  { { 1, 0.5, 0.05 }, { 0.05, 0.6, 1.55 }, { 0, 1, 0.1 }, { 0, 0, 0 } },
  { { 0.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 }, { 0.1, 0.2, 3 }, { 2, 0, 0 } },
  { { 1, 0.5, 0.05 }, { 0.05, 0.1, 1.5 }, { 1, 0, 0 }, { 2, 0, 0 } },
  { { 1, 0.5, 0.05 }, { 0.05, 0.1, 1.5 }, { 2, 0, 0 }, { 0.05, 0.6, 1.55 } },
  { { 0, 0, 0 }, { 1, 0.5, 0.05 }, { 0, 0.5, 0.05 }, { 0.05, 0.1, 1.5 } },
  { { 0, 0, 0 }, { 1, 0.5, 0.05 }, { 0.05, 0.1, 1.5 }, { 1.05, 0.1, 1.5 } },
  { { 0, 0, 0 }, { 1, 0.5, 0.05 }, { 1.05, 0.1, 1.5 }, { 2, 0, 0 } },
  { { 1, 0.5, 0.05 }, { 0.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 }, { 0, 0.5, 0.05 } },
  { { 1, 0.5, 0.05 }, { 0.05, 0.1, 1.5 }, { 1.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 } },
  { { 0.05, 0.1, 1.5 }, { 1.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 }, { 0.1, 0.2, 3 } },
  { { 0, 0.5, 0.05 }, { 1, 0.5, 0.05 }, { 0, 1, 0.1 }, { 0.05, 0.6, 1.55 } },
  { { 1, 0, 0 }, { 0, 1, 0.1 }, { 0, 0.5, 0.05 }, { 0.05, 0.6, 1.55 } },
  { { 1, 0, 0 }, { 0, 1, 0.1 }, { 0.05, 0.6, 1.55 }, { 1.05, 0.1, 1.5 } },
  { { 1, 0, 0 }, { 0, 1, 0.1 }, { 1.05, 0.1, 1.5 }, { 2, 0, 0 } },
  { { 0.05, 0.6, 1.55 }, { 1, 0, 0 }, { 0.05, 0.1, 1.5 }, { 0, 0.5, 0.05 } },
  { { 0.05, 0.6, 1.55 }, { 1, 0, 0 }, { 1.05, 0.1, 1.5 }, { 0.05, 0.1, 1.5 } },
  { { 1.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 }, { 0.05, 0.1, 1.5 }, { 0.1, 0.2, 3 } },
  { { 1, 0, 0 }, { 0, 0.5, 0.05 }, { 0, 0, 0 }, { 0.05, 0.1, 1.5 } },
  { { 1, 0.5, 0.05 }, { 0, 0, 0 }, { 1, 0, 0 }, { 0.05, 0.1, 1.5 } },
  { { 1, 0.5, 0.05 }, { 0, 0, 0 }, { 0.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 } },
  { { 1, 0.5, 0.05 }, { 0, 0, 0 }, { 0.05, 0.6, 1.55 }, { 0, 1, 0.1 } },
  { { 0.05, 0.1, 1.5 }, { 1, 0.5, 0.05 }, { 1.05, 0.1, 1.5 }, { 1, 0, 0 } },
  { { 0.05, 0.1, 1.5 }, { 1, 0.5, 0.05 }, { 0.05, 0.6, 1.55 }, { 1.05, 0.1, 1.5 } },
  { { 0.05, 0.6, 1.55 }, { 0.05, 0.1, 1.5 }, { 1.05, 0.1, 1.5 }, { 0.1, 0.2, 3 } },
  { { 1, 0.5, 0.05 }, { 1, 0, 0 }, { 2, 0, 0 }, { 1.05, 0.1, 1.5 } },
  { { 0.05, 0.6, 1.55 }, { 0, 0, 0 }, { 0, 0.5, 0.05 }, { 1, 0, 0 } },
  { { 0.05, 0.6, 1.55 }, { 0, 0, 0 }, { 1, 0, 0 }, { 1.05, 0.1, 1.5 } },
  { { 0.05, 0.6, 1.55 }, { 0, 0, 0 }, { 1.05, 0.1, 1.5 }, { 0.1, 0.2, 3 } },
  { { 1, 0, 0 }, { 0.05, 0.6, 1.55 }, { 1, 0.5, 0.05 }, { 0, 0.5, 0.05 } },
  { { 1, 0, 0 }, { 0.05, 0.6, 1.55 }, { 1.05, 0.1, 1.5 }, { 1, 0.5, 0.05 } },
  { { 1.05, 0.1, 1.5 }, { 1, 0, 0 }, { 1, 0.5, 0.05 }, { 2, 0, 0 } },
  { { 0.05, 0.6, 1.55 }, { 0, 0.5, 0.05 }, { 0, 1, 0.1 }, { 1, 0.5, 0.05 } },
  { { 2, 0, 0 }, { 0.05, 0.6, 1.55 }, { 1, 0.5, 0.05 }, { 1, 0, 0 } },
  { { 2, 0, 0 }, { 0.05, 0.6, 1.55 }, { 1, 0, 0 }, { 0.05, 0.1, 1.5 } },
  { { 2, 0, 0 }, { 0.05, 0.6, 1.55 }, { 0.05, 0.1, 1.5 }, { 0.1, 0.2, 3 } },
  { { 0.05, 0.6, 1.55 }, { 1, 0, 0 }, { 0, 0.5, 0.05 }, { 1, 0.5, 0.05 } },
  { { 0.05, 0.6, 1.55 }, { 1, 0, 0 }, { 0.05, 0.1, 1.5 }, { 0, 0.5, 0.05 } },
  { { 1, 0, 0 }, { 0.05, 0.1, 1.5 }, { 0, 0.5, 0.05 }, { 0, 0, 0 } },
  { { 1, 0.5, 0.05 }, { 0.05, 0.6, 1.55 }, { 0, 1, 0.1 }, { 0, 0.5, 0.05 } },
  { { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 1, 0.5, 0.05 }, { 0, 0.5, 0.05 } },
  { { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 0, 0.5, 0.05 }, { 0.05, 0.1, 1.5 } },
  { { 1.05, 0.1, 1.5 }, { 0, 1, 0.1 }, { 0.05, 0.1, 1.5 }, { 0.1, 0.2, 3 } },
  { { 0, 0.5, 0.05 }, { 1.05, 0.1, 1.5 }, { 1, 0, 0 }, { 1, 0.5, 0.05 } },
  { { 0, 0.5, 0.05 }, { 1.05, 0.1, 1.5 }, { 0.05, 0.1, 1.5 }, { 1, 0, 0 } },
  { { 0.05, 0.1, 1.5 }, { 0, 0.5, 0.05 }, { 1, 0, 0 }, { 0, 0, 0 } },
  { { 1.05, 0.1, 1.5 }, { 1, 0.5, 0.05 }, { 2, 0, 0 }, { 1, 0, 0 } },
  { { 0, 0.5, 0.05 }, { 1, 0, 0 }, { 1, 0.5, 0.05 }, { 1.05, 0.1, 1.5 } },
  { { 0, 0.5, 0.05 }, { 1, 0.5, 0.05 }, { 0.05, 0.6, 1.55 }, { 1.05, 0.1, 1.5 } },
  { { 0, 0.5, 0.05 }, { 0.05, 0.6, 1.55 }, { 0.05, 0.1, 1.5 }, { 1.05, 0.1, 1.5 } },
  { { 0, 0.5, 0.05 }, { 0.05, 0.1, 1.5 }, { 1, 0, 0 }, { 1.05, 0.1, 1.5 } },
  { { 0.05, 0.1, 1.5 }, { 1.05, 0.1, 1.5 }, { 0.05, 0.6, 1.55 }, { 0.1, 0.2, 3 } },
  { { 0, 0.5, 0.05 }, { 1, 0.5, 0.05 }, { 0, 1, 0.1 }, { 0.05, 0.6, 1.55 } },
  { { 1, 0, 0 }, { 2, 0, 0 }, { 1, 0.5, 0.05 }, { 1.05, 0.1, 1.5 } },
  { { 0, 0, 0 }, { 1, 0, 0 }, { 0, 0.5, 0.05 }, { 0.05, 0.1, 1.5 } },
  { { 0, 3, 0 }, { -3, 4, 0 }, { 0, 4, -3 }, { 0, 2, -1.5 } },
  { { 0, 3, 0 }, { -3, 4, 0 }, { 0, 2, -1.5 }, { 0, 2, 1.5 } },
  { { 0, 3, 0 }, { -3, 4, 0 }, { 0, 2, 1.5 }, { 0, 4, 3 } },
  { { 0, 3, 0 }, { -3, 4, 0 }, { 0, 4, 3 }, { 0, 4, -3 } },
  { { -3, 4, 0 }, { 0, 2, -1.5 }, { 0, 2, 1.5 }, { 0, 0, 0 } },
  { { 2, -1.5, 0 }, { 2, 1.5, 0 }, { 1.5, 0, 1.5 }, { 3, 0, 3 } },
  { { 3, 0, 0 }, { 4, -3, 0 }, { 4, 3, 0 }, { 3, 0, 3 } },
  { { 3, 0, 0 }, { 4, 3, 0 }, { 2, 1.5, 0 }, { 3, 0, 3 } },
  { { 3, 0, 0 }, { 2, 1.5, 0 }, { 2, -1.5, 0 }, { 3, 0, 3 } },
  { { 3, 0, 0 }, { 2, -1.5, 0 }, { 4, -3, 0 }, { 3, 0, 3 } },
  { { 2, -1.5, 0 }, { 1.5, 0, 1.5 }, { 2, 1.5, 0 }, { 0, 0, 0 } },
  { { 4, -3, 0 }, { 3, 0, 5 }, { 4, 3, 0 }, { 1.5, 0, 2.5 } },
  { { 3, 0, 0 }, { 4, -3, 0 }, { 4, 3, 0 }, { 1.5, 0, 2.5 } },
  { { 3, 0, 0 }, { 4, 3, 0 }, { 2, 1.5, 0 }, { 1.5, 0, 2.5 } },
  { { 3, 0, 0 }, { 2, 1.5, 0 }, { 2, -1.5, 0 }, { 1.5, 0, 2.5 } },
  { { 3, 0, 0 }, { 2, -1.5, 0 }, { 4, -3, 0 }, { 1.5, 0, 2.5 } },
  { { 2, -1.5, 0 }, { 1.5, 0, 2.5 }, { 2, 1.5, 0 }, { 0, 0, 0 } },
  { { 4, 3, 0 }, { 2, 1.5, 0 }, { 3, 0, 0 }, { 2.625, 1.125, 1.5 } },
  { { 3, 0, 4 }, { 1.5, 0, 2 }, { 2.625, 1.125, 1.5 }, { 2.625, -1.125, 1.5 } },
  { { 2, -1.5, 0 }, { 4, -3, 0 }, { 3, 0, 0 }, { 2.625, -1.125, 1.5 } },
  { { 2.625, -1.125, 1.5 }, { 2, 1.5, 0 }, { 3, 0, 0 }, { 2, -1.5, 0 } },
  { { 2.625, -1.125, 1.5 }, { 2, 1.5, 0 }, { 2.625, 1.125, 1.5 }, { 3, 0, 0 } },
  { { 2.625, -1.125, 1.5 }, { 2, 1.5, 0 }, { 1.5, 0, 2 }, { 2.625, 1.125, 1.5 } },
  { { 2.625, -1.125, 1.5 }, { 2, 1.5, 0 }, { 2, -1.5, 0 }, { 1.5, 0, 2 } },
  { { 4, 3, 0 }, { 3, 0, 0 }, { 2.625, -1.125, 1.5 }, { 2.625, 1.125, 1.5 } },
  { { 4, -3, 0 }, { 3, 0, 0 }, { 2.625, -1.125, 1.5 }, { 4, 3, 0 } },
  { { 4, 3, 0 }, { 2.625, -1.125, 1.5 }, { 3, 0, 4 }, { 2.625, 1.125, 1.5 } },
  { { 3, 0, 4 }, { 4, 3, 0 }, { 4, -3, 0 }, { 2.625, -1.125, 1.5 } },
  { { 2, -1.5, 0 }, { 1.5, 0, 2 }, { 2, 1.5, 0 }, { 0, 0, 0 } },
  { { 0, 2, -1.5 }, { 0, 0, 0 }, { 0, 2, 1.5 }, { -3, 4, 0 } },
  { { 0, 3, 0 }, { 0, 4, -3 }, { 0, 2, -1.5 }, { -1.5, 4, -1.5 } },
  { { 0, 3, 0 }, { 0, 4, 3 }, { 0, 4, -3 }, { -1.5, 4, -1.5 } },
  { { 0, 3, 0 }, { -1.5, 4, -1.5 }, { 0, 2, -1.5 }, { -3, 4, 0 } },
  { { 0, 3, 0 }, { 0, 4, 3 }, { -1.5, 4, -1.5 }, { -3, 4, 0 } },
  { { 0, 3, 0 }, { 0, 2, 1.5 }, { 0, 4, 3 }, { -3, 4, 0 } },
  { { 0, 3, 0 }, { 0, 2, -1.5 }, { 0, 2, 1.5 }, { -3, 4, 0 } },
  { { -2, 3.5, -1.5 }, { 0, 0, 0 }, { 0, 2, 1.5 }, { -4, 3, 0 } },
  { { -2, 3.5, -1.5 }, { 0, 2, 1.5 }, { 0, 4, 3 }, { -4, 3, 0 } },
  { { 0, 3, 0 }, { 0, 4, -3 }, { 0, 2, -1.5 }, { -2, 3.5, -1.5 } },
  { { 0, 3, 0 }, { 0, 4, 3 }, { 0, 4, -3 }, { -2, 3.5, -1.5 } },
  { { 0, 3, 0 }, { 0, 2, 1.5 }, { 0, 4, 3 }, { -2, 3.5, -1.5 } },
  { { 0, 3, 0 }, { 0, 2, -1.5 }, { 0, 2, 1.5 }, { -2, 3.5, -1.5 } },
  { { 0, 0, 0 }, { 0, 2, 1.5 }, { 0, 2, -1.5 }, { -2, 3.5, -1.5 } },
  { { 0, 2, -1.5 }, { 0, 0, 0 }, { 0, 2, 1.5 }, { -1.5, 2.5, -0.75 } },
  { { -1.5, 2.5, -0.75 }, { 0, 0, 0 }, { 0, 2, 1.5 }, { -4, 4, 0 } },
  { { 0, 3, 0 }, { 0, 4, -3 }, { 0, 2, -1.5 }, { -2, 4, -1.5 } },
  { { 0, 3, 0 }, { 0, 4, 3 }, { 0, 4, -3 }, { -2, 4, -1.5 } },
  { { 0, 3, 0 }, { 0, 2, 1.5 }, { 0, 4, 3 }, { -4, 4, 0 } },
  { { 0, 3, 0 }, { 0, 4, 3 }, { -2, 4, -1.5 }, { -4, 4, 0 } },
  { { 0, 3, 0 }, { -2, 4, -1.5 }, { 0, 2, -1.5 }, { -1.5, 2.5, -0.75 } },
  { { 0, 3, 0 }, { -2, 4, -1.5 }, { -1.5, 2.5, -0.75 }, { -4, 4, 0 } },
  { { 0, 3, 0 }, { 0, 2, -1.5 }, { 0, 2, 1.5 }, { -1.5, 2.5, -0.75 } },
  { { 0, 3, 0 }, { -1.5, 2.5, -0.75 }, { 0, 2, 1.5 }, { -4, 4, 0 } },
  { { 0, 2, -1.5 }, { 0, 0, 0 }, { 3, 4, 0 }, { 0, 2, 1.5 } },
  { { 0, 3, 0 }, { 0, 2, -1.5 }, { 0, 4, -3 }, { 1.5, 4, -1.5 } },
  { { 0, 3, 0 }, { 0, 4, -3 }, { 0, 4, 3 }, { 1.5, 4, -1.5 } },
  { { 0, 3, 0 }, { 3, 4, 0 }, { 0, 2, -1.5 }, { 1.5, 4, -1.5 } },
  { { 0, 3, 0 }, { 0, 4, 3 }, { 3, 4, 0 }, { 1.5, 4, -1.5 } },
  { { 0, 3, 0 }, { 0, 4, 3 }, { 0, 2, 1.5 }, { 3, 4, 0 } },
  { { 0, 3, 0 }, { 0, 2, 1.5 }, { 0, 2, -1.5 }, { 3, 4, 0 } },
  { { 2, 3.5, -1.5 }, { 4, 3, 0 }, { 0, 2, 1.5 }, { 0, 0, 0 } },
  { { 2, 3.5, -1.5 }, { 0, 2, 1.5 }, { 4, 3, 0 }, { 0, 4, 3 } },
  { { 0, 3, 0 }, { 0, 2, -1.5 }, { 0, 4, -3 }, { 2, 3.5, -1.5 } },
  { { 0, 3, 0 }, { 0, 4, -3 }, { 0, 4, 3 }, { 2, 3.5, -1.5 } },
  { { 0, 2, 1.5 }, { 0, 3, 0 }, { 0, 4, 3 }, { 2, 3.5, -1.5 } },
  { { 0, 2, 1.5 }, { 0, 2, -1.5 }, { 0, 3, 0 }, { 2, 3.5, -1.5 } },
  { { 0, 0, 0 }, { 2, 3.5, -1.5 }, { 0, 2, -1.5 }, { 0, 2, 1.5 } },
  { { 0, 2, -1.5 }, { 0, 0, 0 }, { 1.5, 2.5, -0.75 }, { 0, 2, 1.5 } },
  { { 1.5, 2.5, -0.75 }, { 4, 4, 0 }, { 0, 2, 1.5 }, { 0, 0, 0 } },
  { { 0, 3, 0 }, { 0, 2, -1.5 }, { 0, 4, -3 }, { 2, 4, -1.5 } },
  { { 0, 3, 0 }, { 0, 4, -3 }, { 0, 4, 3 }, { 2, 4, -1.5 } },
  { { 0, 3, 0 }, { 0, 4, 3 }, { 0, 2, 1.5 }, { 4, 4, 0 } },
  { { 0, 3, 0 }, { 0, 4, 3 }, { 4, 4, 0 }, { 2, 4, -1.5 } },
  { { 0, 3, 0 }, { 1.5, 2.5, -0.75 }, { 0, 2, -1.5 }, { 2, 4, -1.5 } },
  { { 0, 3, 0 }, { 1.5, 2.5, -0.75 }, { 2, 4, -1.5 }, { 4, 4, 0 } },
  { { 0, 2, 1.5 }, { 0, 2, -1.5 }, { 0, 3, 0 }, { 1.5, 2.5, -0.75 } },
  { { 0, 3, 0 }, { 1.5, 2.5, -0.75 }, { 4, 4, 0 }, { 0, 2, 1.5 } },
  { { -1.5, 3.5, -1.5 }, { 0, 2, -1.5 }, { 0, 4, -3 }, { 0, 3, 0 } },
  { { -1.5, 3.5, -1.5 }, { 0, 4, -3 }, { 0, 4, 3 }, { 0, 3, 0 } },
  { { -1.5, 3.5, -1.5 }, { 0, 2, -1.5 }, { 0, 3, 0 }, { 0, 2, 1.5 } },
  { { -1.5, 3.5, -1.5 }, { 0, 3, 0 }, { 0, 4, 3 }, { 0, 2, 1.5 } },
  { { 0, 4, 3 }, { -3, 3, 0 }, { -1.5, 3.5, -1.5 }, { 0, 2, 1.5 } },
  { { -3, 3, 0 }, { -1.5, 3.5, -1.5 }, { 0, 2, 1.5 }, { -1.5, 1.5, 0 } },
  { { 0, 2, -1.5 }, { 0, 2, 1.5 }, { -1.5, 1.5, 0 }, { 0, 0, 0 } },
  { { 0, 2, -1.5 }, { -1.5, 1.5, 0 }, { 0, 2, 1.5 }, { -1.5, 3.5, -1.5 } },
  { { -1.5, 4.5, -1.5 }, { 0, 2, -1.5 }, { 0, 4, -3 }, { 0, 3, 0 } },
  { { -1.5, 4.5, -1.5 }, { 0, 4, -3 }, { 0, 4, 3 }, { 0, 3, 0 } },
  { { -1.5, 4.5, -1.5 }, { 0, 2, -1.5 }, { 0, 3, 0 }, { 0, 2, 1.5 } },
  { { -1.5, 4.5, -1.5 }, { 0, 3, 0 }, { 0, 4, 3 }, { 0, 2, 1.5 } },
  { { 0, 4, 3 }, { -3, 5, 0 }, { -1.5, 4.5, -1.5 }, { -1.5, 2.5, 0 } },
  { { 0, 4, 3 }, { -1.5, 4.5, -1.5 }, { 0, 2, 1.5 }, { -1.5, 2.5, 0 } },
  { { 0, 2, -1.5 }, { 0, 2, 1.5 }, { -1.5, 2.5, 0 }, { 0, 0, 0 } },
  { { 0, 2, -1.5 }, { -1.5, 2.5, 0 }, { 0, 2, 1.5 }, { -1.5, 4.5, -1.5 } },
  { { -1.5, 4, -1.5 }, { 0, 2, -1.5 }, { 0, 4, -3 }, { 0, 3, 0 } },
  { { -1.5, 4, -1.5 }, { 0, 4, -3 }, { 0, 4, 3 }, { 0, 3, 0 } },
  { { -1.5, 4, -1.5 }, { 0, 2, -1.5 }, { 0, 3, 0 }, { 0, 2, 1.5 } },
  { { -1.5, 4, -1.5 }, { 0, 3, 0 }, { 0, 4, 3 }, { 0, 2, 1.5 } },
  { { -1.5, 4, -1.5 }, { 0, 4, 3 }, { -3, 4, 0 }, { -1.125, 3, 1.125 } },
  { { -1.5, 4, -1.5 }, { -3, 4, 0 }, { -1.5, 2, 0 }, { -1.125, 3, 1.125 } },
  { { -1.5, 4, -1.5 }, { -1.5, 2, 0 }, { 0, 2, 1.5 }, { -1.125, 3, 1.125 } },
  { { -1.5, 4, -1.5 }, { 0, 2, 1.5 }, { 0, 4, 3 }, { -1.125, 3, 1.125 } },
  { { 0, 2, -1.5 }, { 0, 2, 1.5 }, { -1.5, 2, 0 }, { 0, 0, 0 } },
  { { 0, 2, -1.5 }, { -1.5, 2, 0 }, { 0, 2, 1.5 }, { -1.5, 4, -1.5 } },
  { { 0, 3, 0 }, { 1.5, 2, 0 }, { 3, 4, 0 }, { 1, 2.5, 6 } },
  { { 0, 3, 0 }, { -3, 4, 0 }, { -1.5, 2, 0 }, { -2, 2.5, 6 } },
  { { 0, 3, 0 }, { 3, 4, 0 }, { -3, 4, 0 }, { 1, 2.5, 6 } },
  { { 0, 3, 0 }, { 1, 2.5, 6 }, { -3, 4, 0 }, { -2, 2.5, 6 } },
  { { 1.5, 2, 0 }, { 1, 2.5, 6 }, { 0, 3, 0 }, { -2, 2.5, 6 } },
  { { 1.5, 2, 0 }, { 0, 3, 0 }, { -1.5, 2, 0 }, { -2, 2.5, 6 } },
  { { 1.5, 2, 0 }, { 0, 0, 0 }, { 1, 2.5, 6 }, { -2, 2.5, 6 } },
  { { 1.5, 2, 0 }, { -1.5, 2, 0 }, { 0, 0, 0 }, { -2, 2.5, 6 } },
  { { 1, 2.5, 6 }, { -2, 2.5, 6 }, { 0, 0, 0 }, { -1, 1, 12 } },
  { { 0, 3, 0 }, { 1.5, 2, 0 }, { 3, 4, 0 }, { 2, 3, 1 } },
  { { 0, 3, 0 }, { -3, 4, 0 }, { -1.5, 2, 0 }, { -1, 3, 1 } },
  { { 0, 3, 0 }, { 3, 4, 0 }, { -3, 4, 0 }, { -1, 3, 1 } },
  { { 0, 3, 0 }, { 2, 3, 1 }, { 3, 4, 0 }, { -1, 3, 1 } },
  { { 1.5, 2, 0 }, { 2, 3, 1 }, { 0, 3, 0 }, { -1, 3, 1 } },
  { { 1.5, 2, 0 }, { 0, 3, 0 }, { -1.5, 2, 0 }, { -1, 3, 1 } },
  { { 1.5, 2, 0 }, { 1, 2, 2 }, { 2, 3, 1 }, { -1, 3, 1 } },
  { { 1.5, 2, 0 }, { -1.5, 2, 0 }, { 1, 2, 2 }, { -1, 3, 1 } },
  { { 1.5, 2, 0 }, { -1.5, 2, 0 }, { 0, 0, 0 }, { 1, 2, 2 } },
  { { 0, 3, 0 }, { 1.5, 2, 0 }, { 3, 4, 0 }, { 2, 3.5, 2 } },
  { { 0, 3, 0 }, { -3, 4, 0 }, { -1.5, 2, 0 }, { -1, 3.5, 2 } },
  { { 0, 3, 0 }, { 3, 4, 0 }, { -3, 4, 0 }, { -1, 3.5, 2 } },
  { { 0, 3, 0 }, { 2, 3.5, 2 }, { 3, 4, 0 }, { -1, 3.5, 2 } },
  { { 1.5, 2, 0 }, { 2, 3.5, 2 }, { 0, 3, 0 }, { -1, 3.5, 2 } },
  { { 1.5, 2, 0 }, { 0, 3, 0 }, { -1.5, 2, 0 }, { -1, 3.5, 2 } },
  { { 1.5, 2, 0 }, { 1, 3, 4 }, { 2, 3.5, 2 }, { -1, 3.5, 2 } },
  { { 1.5, 2, 0 }, { -1.5, 2, 0 }, { 0, 0, 0 }, { -1, 3.5, 2 } },
  { { 1.5, 2, 0 }, { 0, 0, 0 }, { 1, 3, 4 }, { -1, 3.5, 2 } },
  { { 0, 3, 0 }, { 1.5, 2, 0 }, { 3, 4, 0 }, { 1.5, 2, 6 } },
  { { 0, 3, 0 }, { -3, 4, 0 }, { -1.5, 2, 0 }, { -1.5, 2, 6 } },
  { { 0, 3, 0 }, { 3, 4, 0 }, { -3, 4, 0 }, { 0, 3, 3 } },
  { { 0, 3, 0 }, { 0, 3, 3 }, { -3, 4, 0 }, { -1.5, 2, 6 } },
  { { 0, 3, 0 }, { 3, 4, 0 }, { 0, 3, 3 }, { 1.5, 2, 6 } },
  { { 0, 3, 0 }, { 1.5, 2, 6 }, { 0, 3, 3 }, { -1.5, 2, 6 } },
  { { 1.5, 2, 0 }, { 1.5, 2, 6 }, { 0, 3, 0 }, { -1.5, 2, 6 } },
  { { 1.5, 2, 0 }, { 0, 3, 0 }, { -1.5, 2, 0 }, { -1.5, 2, 6 } },
  { { 1.5, 2, 0 }, { 0, 0, 0 }, { 1.5, 2, 6 }, { -1.5, 2, 6 } },
  { { 1.5, 2, 0 }, { -1.5, 2, 0 }, { 0, 0, 0 }, { -1.5, 2, 6 } },
  { { 1.5, 2, 6 }, { -1.5, 2, 6 }, { 0, 0, 0 }, { 0, 0, 12 } },
  { { 0, 3, 0 }, { 1.5, 2, 0 }, { 3, 4, 0 }, { 3, 2.5, 2 } },
  { { 0, 3, 0 }, { -3, 4, 0 }, { -1.5, 2, 0 }, { 0, 2.5, 2 } },
  { { 0, 3, 0 }, { 3, 4, 0 }, { -3, 4, 0 }, { 0, 2.5, 2 } },
  { { 0, 3, 0 }, { 3, 2.5, 2 }, { 3, 4, 0 }, { 0, 2.5, 2 } },
  { { 1.875, 1.375, 1.5 }, { 1.5, 2, 0 }, { 0, 0, 0 }, { -1.5, 2, 0 } },
  { { 1.875, 1.375, 1.5 }, { 3, 1, 4 }, { 3, 2.5, 2 }, { 0, 2.5, 2 } },
  { { 1.875, 1.375, 1.5 }, { 0, 0, 0 }, { 3, 1, 4 }, { 0, 2.5, 2 } },
  { { 1.875, 1.375, 1.5 }, { 0, 0, 0 }, { 0, 2.5, 2 }, { -1.5, 2, 0 } },
  { { 1.5, 2, 0 }, { 3, 2.5, 2 }, { 0, 3, 0 }, { 0, 2.5, 2 } },
  { { 1.5, 2, 0 }, { 0, 3, 0 }, { -1.5, 2, 0 }, { 0, 2.5, 2 } },
  { { 1.5, 2, 0 }, { 1.875, 1.375, 1.5 }, { 3, 2.5, 2 }, { 0, 2.5, 2 } },
  { { 1.5, 2, 0 }, { -1.5, 2, 0 }, { 1.875, 1.375, 1.5 }, { 0, 2.5, 2 } },
  { { 0, 3, 0 }, { 1.5, 2, 0 }, { 3, 4, 0 }, { 1, 4, 1.5 } },
  { { 0, 3, 0 }, { -3, 4, 0 }, { -1.5, 2, 0 }, { -2, 4, 1.5 } },
  { { 0, 3, 0 }, { 3, 4, 0 }, { -3, 4, 0 }, { 1, 4, 1.5 } },
  { { 0, 3, 0 }, { 1, 4, 1.5 }, { -3, 4, 0 }, { -2, 4, 1.5 } },
  { { 0.375, 2.5, 1.125 }, { 1.5, 2, 0 }, { 0, 0, 0 }, { -1.5, 2, 0 } },
  { { 0.375, 2.5, 1.125 }, { -1, 4, 3 }, { 1, 4, 1.5 }, { -2, 4, 1.5 } },
  { { 0.375, 2.5, 1.125 }, { 0, 0, 0 }, { -1, 4, 3 }, { -1.5, 2, 0 } },
  { { 0.375, 2.5, 1.125 }, { -1, 4, 3 }, { -2, 4, 1.5 }, { -1.5, 2, 0 } },
  { { 1.5, 2, 0 }, { 1, 4, 1.5 }, { 0, 3, 0 }, { -2, 4, 1.5 } },
  { { 1.5, 2, 0 }, { 0, 3, 0 }, { -1.5, 2, 0 }, { -2, 4, 1.5 } },
  { { 1.5, 2, 0 }, { 0.375, 2.5, 1.125 }, { 1, 4, 1.5 }, { -2, 4, 1.5 } },
  { { 1.5, 2, 0 }, { -1.5, 2, 0 }, { 0.375, 2.5, 1.125 }, { -2, 4, 1.5 } },
  { { 0, 3, 0 }, { 1.5, 2, 0 }, { 3, 4, 0 }, { 1.5, 4, 2 } },
  { { 0, 3, 0 }, { -3, 4, 0 }, { -1.5, 2, 0 }, { -1.5, 4, 2 } },
  { { 0, 3, 0 }, { 3, 4, 0 }, { -3, 4, 0 }, { 0, 4, 1 } },
  { { 0, 3, 0 }, { 0, 4, 1 }, { -3, 4, 0 }, { -1.5, 4, 2 } },
  { { 0, 3, 0 }, { 3, 4, 0 }, { 0, 4, 1 }, { 1.5, 4, 2 } },
  { { 0, 3, 0 }, { 1.5, 4, 2 }, { 0, 4, 1 }, { -1.5, 4, 2 } },
  { { 0.75, 2.5, 1.5 }, { 1.5, 2, 0 }, { 0, 0, 0 }, { -1.5, 2, 0 } },
  { { 0.75, 2.5, 1.5 }, { 0, 4, 4 }, { 1.5, 4, 2 }, { -1.5, 4, 2 } },
  { { 0.75, 2.5, 1.5 }, { 0, 0, 0 }, { 0, 4, 4 }, { -0.75, 2.5, 1.5 } },
  { { 0.75, 2.5, 1.5 }, { 0, 0, 0 }, { -0.75, 2.5, 1.5 }, { -1.5, 2, 0 } },
  { { 0.75, 2.5, 1.5 }, { -0.75, 2.5, 1.5 }, { 0, 4, 4 }, { -1.5, 4, 2 } },
  { { 0.75, 2.5, 1.5 }, { -0.75, 2.5, 1.5 }, { -1.5, 2, 0 }, { -1.5, 4, 2 } },
  { { 1.5, 2, 0 }, { 1.5, 4, 2 }, { 0, 3, 0 }, { -1.5, 4, 2 } },
  { { 1.5, 2, 0 }, { 0, 3, 0 }, { -1.5, 2, 0 }, { -1.5, 4, 2 } },
  { { 1.5, 2, 0 }, { -1.5, 2, 0 }, { 0.75, 2.5, 1.5 }, { -1.5, 4, 2 } },
  { { 1.5, 2, 0 }, { 0.75, 2.5, 1.5 }, { 1.5, 4, 2 }, { -1.5, 4, 2 } },
  { { 0, 3, 0 }, { 1.5, 2, 0 }, { 3, 4, 0 }, { 1, 2.5, 6 } },
  { { 0, 3, 0 }, { -3, 4, 0 }, { -1.5, 2, 0 }, { -2, 2.5, 6 } },
  { { 0, 3, 0 }, { 3, 4, 0 }, { -3, 4, 0 }, { 1, 2.5, 6 } },
  { { 0, 3, 0 }, { 1, 2.5, 6 }, { -3, 4, 0 }, { -2, 2.5, 6 } },
  { { 0, 3, 0 }, { -2, 2.5, 6 }, { -1.5, 2, 0 }, { -0.5, 0.5, 6 } },
  { { 0, 3, 0 }, { 1.5, 2, 0 }, { 1, 2.5, 6 }, { -0.5, 0.5, 6 } },
  { { 0, 3, 0 }, { 1, 2.5, 6 }, { -2, 2.5, 6 }, { -0.5, 0.5, 6 } },
  { { 0, 3, 0 }, { -1.5, 2, 0 }, { 1.5, 2, 0 }, { -0.5, 0.5, 6 } },
  { { 1, 2.5, 6 }, { -2, 2.5, 6 }, { -0.5, 0.5, 6 }, { -1, 1, 12 } },
  { { 1.5, 2, 0 }, { -1.5, 2, 0 }, { 0, 0, 0 }, { -0.5, 0.5, 6 } },
  { { 0, 3, 0 }, { 1.5, 2, 0 }, { 3, 4, 0 }, { 1.5, 2, 6 } },
  { { 0, 3, 0 }, { -3, 4, 0 }, { -1.5, 2, 0 }, { -1.5, 2, 6 } },
  { { 0, 3, 0 }, { 3, 4, 0 }, { -3, 4, 0 }, { 0, 3, 3 } },
  { { 0, 3, 0 }, { 0, 3, 3 }, { -3, 4, 0 }, { -1.5, 2, 6 } },
  { { 0, 3, 0 }, { 3, 4, 0 }, { 0, 3, 3 }, { 1.5, 2, 6 } },
  { { 0, 3, 0 }, { 1.5, 2, 6 }, { 0, 3, 3 }, { -1.5, 2, 6 } },
  { { 0, 3, 0 }, { -1.5, 2, 6 }, { -1.5, 2, 0 }, { 0, 0, 6 } },
  { { 0, 3, 0 }, { 1.5, 2, 0 }, { 1.5, 2, 6 }, { 0, 0, 6 } },
  { { 0, 3, 0 }, { 1.5, 2, 6 }, { -1.5, 2, 6 }, { 0, 0, 6 } },
  { { 0, 3, 0 }, { -1.5, 2, 0 }, { 1.5, 2, 0 }, { 0, 0, 6 } },
  { { 1.5, 2, 6 }, { -1.5, 2, 6 }, { 0, 0, 6 }, { 0, 0, 12 } },
  { { 1.5, 2, 0 }, { -1.5, 2, 0 }, { 0, 0, 0 }, { 0, 0, 6 } }
};

#endif // VTK_CHECK_RESULTS

// ===============================================================================

// A subclass of vtkEdgeSubdivisionCriterion for testing the vtkStreamingTessellator.
// This is a subclass of vtkEdgeSubdivisionCriterion that is used for
// testing the vtkStreamingTessellator.
// It divides the edges in a predictable pattern that has nothing
// to do with geometric error or field values.
// In fact, it doesn't change the midpoint geometry or field values.
class vtkTestTessellatorSubdivision
  : public vtkEdgeSubdivisionCriterion
{
  public:
    vtkTypeMacro(vtkTestTessellatorSubdivision,vtkEdgeSubdivisionCriterion);
    static vtkTestTessellatorSubdivision* New();
    virtual void PrintSelf( ostream& os, vtkIndent indent );

    virtual bool EvaluateEdge( const double* p0, double* midpt, const double* p1, int field_start );

    static double*  TestPoints;
    static double*  TestPointsCanAmbig;
    static double** TestFacePointsCanAmbig;
    static int*     TestPointConn;

    // Description:
    // Return the current id (sequence number) or edge code of the test.
    // These will only be valid <i>before</i> you call \p vtkStreamingTessellator::AdaptivelySample3Facet().
    int GetCurrentTestId() const { return this->CurrentTestId; }
    int GetCurrentTest() const { return this->CurrentTest; }

    // Description:
    // Choose whether to run unambiguous or ambiguous test cases.
    // If off (the default), then vtkTestTessellatorSubdivision::TestList is used.
    // If on, then vtkTestTessellatorSubdivision::TestListCanAmbig is used.
    virtual void AmbiguousTestsOn();
    virtual void AmbiguousTestsOff();
    vtkGetMacro(AmbiguousTests,int);

    // Description:
    // Returns the index of the tetrahedron that should be used for the current test.
    // This is only valid when AmbiguousTests is turned On.
    // Otherwise, it will report -1.
    int GetCurrentTet() const;

    // Description:
    // Returns a bit vector of mid-face points present in the current test.
    // This is only valid when AmbiguousTests is turned On.
    // Otherwise, it will report -1.
    int GetCurrentAmbiguousFaces() const;

 protected:
    vtkTestTessellatorSubdivision();
    virtual ~vtkTestTessellatorSubdivision();

    int AmbiguousTests;
    int CurrentTest;
    int CurrentTestId;
    int CurrentEdge;
    static int* TestList;
    static int* TestListCanAmbig;

  private:
    vtkTestTessellatorSubdivision( const vtkTestTessellatorSubdivision& ); // Not implemented.
    void operator = ( const vtkTestTessellatorSubdivision& ); // Not implemented.

};

vtkStandardNewMacro(vtkTestTessellatorSubdivision);

static int test_list[] =
{
   0,
   1,
   2,
   4,
   8,
  16,
  32,
   3,
   5,
   6,
   9,
  17,
  24,
  18,
  34,
  48,
  12,
  36,
  40,
  33,
  10,
  20,
  13,
  19,
  38,
  56,
  25,
  50,
  44,
   7,
  21,
  11,
  35,
  22,
  37,
  14,
  49,
  26,
  52,
  42,
  28,
  41,
  58,
  54,
  51,
  60,
  46,
  45,
  57,
  27,
  29,
  39,
  23,
  15,
  30,
  53,
  43,
  62,
  61,
  59,
  55,
  47,
  31,
  63,
  -1
};

int* vtkTestTessellatorSubdivision::TestList = test_list;

double points[] =
{
  0., 0., 0.,  0., 0., 0.,
  1., 0., .1,  1., 0., 0.,
  0., 2., 0.,  0., 1., 0.,
  .2, .1, 3.,  0., 0., 1.,

  0., 0., 0.,  0., 0., 0.,
  2., 0., 0.,  1., 0., 0.,
  .1, 3., .2,  0., 1., 0.,
  0., .1, 1.,  0., 0., 1.,

  0., 0., 0.,  0., 0., 0.,
  3., .2, .1,  1., 0., 0.,
  .1, 1., 0.,  0., 1., 0.,
  0., 0., 2.,  0., 0., 1.,

  0., 0., 0.,  0., 0., 0.,
  1., .1, 0.,  1., 0., 0.,
  .2, 3., .1,  0., 1., 0.,
  0., 0., 2.,  0., 0., 1.,

  0., 0., 0.,  0., 0., 0.,
  3., .1, .2,  1., 0., 0.,
  0., 2., 0.,  0., 1., 0.,
  .1, 0., 1.,  0., 0., 1.,

  0., 0., 0.,  0., 0., 0.,
  2., 0., 0.,  1., 0., 0.,
  0., 1., .1,  0., 1., 0.,
  .1, .2, 3.,  0., 0., 1.
};

static int test_list_can_ambig[] =
{
   // canonical ambiguous configurations
     3,  0,  1, // 2a         |01| = |12|
    13,  3,  1, // 3a-alpha   |01| = |02| > |03|
    13,  4,  1, // 3a-beta    |01| = |02| < |03|
    13,  5, 11, // 3a-gamma   |01| = |02| = |03|
    11,  0,  1, // 3c-alpha   |01| = |12| > |03|
    11,  1,  1, // 3c-beta    |01| = |12| < |03|
    11,  2,  3, // 3c-gamma   |01| = |12| = |03|
    21, 16,  2, // 3d-alpha   |01| = |13| > |02|
    21, 17,  2, // 3d-beta    |01| = |13| < |02|
    21, 18,  3, // 3d-gamma   |01| = |13| = |02|
    60,  6,  2, // 4a-alpha   |03| = |13| > |23|
    60,  7,  2, // 4a-beta    |03| = |13| < |23|
    60,  8,  6, // 4a-gamma   |03| = |13| = |23|
    30,  9,  1, // 4b-alpha   |02| = |12| < |13| < |03|
    30, 10,  1, // 4b-beta    |02| = |12| > |13| > |03|
    30, 11,  1, // 4b-gamma   |03| < |02| = |12| < |13|
    30, 12,  3, // 4b-delta   |02| = |12| < |03| = |13|
    30, 13,  9, // 4b-epsilon |02| = |12| = |03| < |13|
    30, 14,  9, // 4b-zeta    |02| = |12| = |03| > |13|
    30, 15, 15, // 4b-eta     |02| = |12| = |03| = |13|
    62,  9,  1, // 5-alpha    |02| = |12| , |03| > |13|
    62, 12,  3, // 5-beta     |02| = |12| , |03| = |13|
     -1,  0,  0
};

int* vtkTestTessellatorSubdivision::TestListCanAmbig = test_list_can_ambig;

static double ambig_pts[] =
{
  // Nota bene: Vx stands for sqrt(x)

  //00: |01|= 5  |12|= 5  |02|= 6  |03|= 3V2  |13|= 5  |23|= 3V2
   0., 4.,-3.,  0., 0., 0.,
   0., 0., 0.,  1., 0., 0.,
   0., 4., 3.,  0., 1., 0.,
  -3., 4., 0.,  0., 0., 1.,

  //01: |01|= 5  |12|= 5  |02|= 6  |03|= V26  |13|= 5  |23|= V26
   0., 4.,-3.,  0., 0., 0.,
   0., 0., 0.,  1., 0., 0.,
   0., 4., 3.,  0., 1., 0.,
  -4., 3., 0.,  0., 0., 1.,

  //02: |01|= 5  |12|= 5  |02|= 6  |03|= 5  |13|= 4V2  |23|= 5
   0., 4.,-3.,  0., 0., 0.,
   0., 0., 0.,  1., 0., 0.,
   0., 4., 3.,  0., 1., 0.,
  -4., 4., 0.,  0., 0., 1.,

  //03: |01|= 5  |12|= 6  |02|= 5  |03|= 3V2  |13|= V19  |23|= V19
   0., 0., 0.,  0., 0., 0.,
   4.,-3., 0.,  1., 0., 0.,
   4., 3., 0.,  0., 1., 0.,
   3., 0., 3.,  0., 0., 1.,

  //04: |01|= 5  |12|= 6  |02|= 5  |03|= V34  |13|= V35  |23|= V35
   0., 0., 0.,  0., 0., 0.,
   4.,-3., 0.,  1., 0., 0.,
   4., 3., 0.,  0., 1., 0.,
   3., 0., 5.,  0., 0., 1.,

  //05: |01|= 5  |12|= 6  |02|= 5  |03|= 5  |13|= V26  |23|= V26
   0., 0., 0.,  0., 0., 0.,
   4.,-3., 0.,  1., 0., 0.,
   4., 3., 0.,  0., 1., 0.,
   3., 0., 4.,  0., 0., 1.,

  //06: |01|= 6  |12|= V19  |02|= V19  |03|= 5  |13|= 5  |23|= 3V2
   0., 4.,-3.,  0., 0., 0.,
   0., 4., 3.,  1., 0., 0.,
  -3., 3., 0.,  0., 1., 0.,
   0., 0., 0.,  0., 0., 1.,

  //07: |01|= 6  |12|= V19  |02|= V19  |03|= 5  |13|= 5  |23|= V34
   0., 4.,-3.,  0., 0., 0.,
   0., 4., 3.,  1., 0., 0.,
  -3., 5., 0.,  0., 1., 0.,
   0., 0., 0.,  0., 0., 1.,

  //08: |01|= 6  |12|= 3V2  |02|= 3V2  |03|= 5  |13|= 5  |23|= 5
   0., 4.,-3.,  0., 0., 0.,
   0., 4., 3.,  1., 0., 0.,
  -3., 4., 0.,  0., 1., 0.,
   0., 0., 0.,  0., 0., 1.,

  //09: |01|= 6  |12|= 5  |02|= 5  |03|= 13  |13|= V157  |23|= V146 
   3., 4., 0.,  0., 0., 0.,
  -3., 4., 0.,  1., 0., 0.,
   0., 0., 0.,  0., 1., 0.,
  -1., 1.,12.,  0., 0., 1.,

  //10: |01|= 6  |12|= 5  |02|= 5  |03|= 2V3  |13|= 2V6  |23|= 3
   3., 4., 0.,  0., 0., 0.,
  -3., 4., 0.,  1., 0., 0.,
   0., 0., 0.,  0., 1., 0.,
   1., 2., 2.,  0., 0., 1.,

  //11: |01|= 6  |12|= 5  |02|= 5  |03|= V21  |13|= V33  |23|= V26 
   3., 4., 0.,  0., 0., 0.,
  -3., 4., 0.,  1., 0., 0.,
   0., 0., 0.,  0., 1., 0.,
   1., 3., 4.,  0., 0., 1.,

  //12: |01|= 6  |12|= 5  |02|= 5  |03|= 13  |13|= 13  |23|= 12 
   3., 4., 0.,  0., 0., 0.,
  -3., 4., 0.,  1., 0., 0.,
   0., 0., 0.,  0., 1., 0.,
   0., 0.,12.,  0., 0., 1.,

  //13: |01|= 6  |12|= 5  |02|= 5  |03|= 5  |13|= V61  |23|= V26
   3., 4., 0.,  0., 0., 0.,
  -3., 4., 0.,  1., 0., 0.,
   0., 0., 0.,  0., 1., 0.,
   3., 1., 4.,  0., 0., 1.,

  //14: |01|= 6  |12|= 5  |02|= 5  |03|= 5  |13|= V13  |23|= V26 
   3., 4., 0.,  0., 0., 0.,
  -3., 4., 0.,  1., 0., 0.,
   0., 0., 0.,  0., 1., 0.,
  -1., 4., 3.,  0., 0., 1.,

  //15: |01|= 6  |12|= 5  |02|= 5  |03|= 5  |13|= 5  |23|= 4V2
   3., 4., 0.,  0., 0., 0.,
  -3., 4., 0.,  1., 0., 0.,
   0., 0., 0.,  0., 1., 0.,
   0., 4., 4.,  0., 0., 1.,

  //16: |01|= 5  |12|= 5  |02|= 3V2  |03|= 6  |13|= 5  |23|= 3V2
   0., 4.,-3.,  0., 0., 0.,
   0., 0., 0.,  1., 0., 0.,
   3., 4., 0.,  0., 1., 0.,
   0., 4., 3.,  0., 0., 1.,

  //17: |01|= 5  |12|= 5  |02|= V26  |03|= 6  |13|= 5  |23|= V26
   0., 4.,-3.,  0., 0., 0.,
   0., 0., 0.,  1., 0., 0.,
   4., 3., 0.,  0., 1., 0.,
   0., 4., 3.,  0., 0., 1.,

  //18: |01|= 5  |12|= 4V2  |02|= 5  |03|= 6  |13|= 5  |23|= 5
   0., 4.,-3.,  0., 0., 0.,
   0., 0., 0.,  1., 0., 0.,
   4., 4., 0.,  0., 1., 0.,
   0., 4., 3.,  0., 0., 1.
};

static double ambig_A_face[] = { 0., 3., 0. };
static double ambig_B_face[] = { 0., 3., 0. };
static double ambig_C_face[] = { 0., 3., 0.,
        -1.5, 2.5, -.75 };
static double ambig_D_face[] = { 3., 0., 0. };
static double ambig_E_face[] = { 3., 0., 0. };
static double ambig_F_face[] = { 3., 0., 0.,
        2.625, -1.125, 1.5,
        2.625, 1.125, 1.5 };
static double ambig_G_face[] = { 0., 3., 0. };
static double ambig_H_face[] = { 0., 3., 0. };
static double ambig_I_face[] = { 1.5, 2.5, -.75,
        0., 3., 0. };
static double ambig_J_face[] = { 0., 3., 0. };
static double ambig_K_face[] = { 0., 3., 0. };
static double ambig_L_face[] = { 0., 3., 0.,
        -1.125, 3., 1.125 };
static double ambig_M_face[] = { 0., 3., 0. };
static double ambig_N_face[] = { 0., 3., 0. };
static double ambig_O_face[] = { 0., 3., 0. };
static double ambig_P_face[] = { 0., 3., 0.,
        0., 3., 3. };
static double ambig_Q_face[] = { 0., 3., 0.,
        1.875, 1.375, 1.5 };
static double ambig_R_face[] = { 0., 3., 0.,
        0.375, 2.5, 1.125 };
static double ambig_S_face[] = { 0., 3., 0.,
        0., 4., 1.,
        -.75, 2.5, 1.5,
        .75, 2.5, 1.5 };

static double* ambig_face_pts[] =
{
  ambig_A_face, // 2a         |01| = |12|
  ambig_D_face, // 3a-alpha   |01| = |02| > |03|
  ambig_E_face, // 3a-beta    |01| = |02| < |03|
  ambig_F_face, // 3a-gamma   |01| = |02| = |03|
  ambig_A_face, // 3c-alpha   |01| = |12| > |03|
  ambig_B_face, // 3c-beta    |01| = |12| < |03|
  ambig_C_face, // 3c-gamma   |01| = |12| = |03|
  ambig_G_face, // 3d-alpha   |01| = |13| > |02|
  ambig_H_face, // 3d-beta    |01| = |13| < |02|
  ambig_I_face, // 3d-gamma   |01| = |13| = |02|
  ambig_J_face, // 4a-alpha   |03| = |13| > |23|
  ambig_K_face, // 4a-beta    |03| = |13| < |23|
  ambig_L_face, // 4a-gamma   |03| = |13| = |23|
  ambig_M_face, // 4b-alpha   |02| = |12| < |13| < |03|
  ambig_N_face, // 4b-beta    |02| = |12| > |13| > |03|
  ambig_O_face, // 4b-gamma   |03| < |02| = |12| < |13|
  ambig_P_face, // 4b-delta   |02| = |12| < |03| = |13|
  ambig_Q_face, // 4b-epsilon |02| = |12| = |03| < |13|
  ambig_R_face, // 4b-zeta    |02| = |12| = |03| > |13|
  ambig_S_face, // 4b-eta     |02| = |12| = |03| = |13|
  ambig_M_face, // 5-alpha    |02| = |12| , |03| > |13|
  ambig_P_face  // 5-beta     |02| = |12| , |03| = |13|
};

static int pointConn[] =
{
  0, 1, 2, 3,
  0, 2, 3, 1,
  0, 3, 1, 2,
  1, 2, 0, 3,
  1, 3, 2, 0,
  1, 0, 3, 2,
  2, 3, 0, 1,
  2, 0, 1, 3,
  2, 1, 3, 0,
  3, 0, 2, 1,
  3, 1, 0, 2,
  3, 2, 1, 0
};

double* vtkTestTessellatorSubdivision::TestPoints = points;
double* vtkTestTessellatorSubdivision::TestPointsCanAmbig = ambig_pts;
double** vtkTestTessellatorSubdivision::TestFacePointsCanAmbig = ambig_face_pts;
int* vtkTestTessellatorSubdivision::TestPointConn = pointConn;

vtkTestTessellatorSubdivision::vtkTestTessellatorSubdivision()
{
  this->CurrentTestId = 0;
  this->CurrentTest = this->TestList[ this->CurrentTestId ];
  this->CurrentEdge = 0;
  this->AmbiguousTests = 0;
}

vtkTestTessellatorSubdivision::~vtkTestTessellatorSubdivision()
{
}

void vtkTestTessellatorSubdivision::PrintSelf( ostream& os, vtkIndent indent )
{
  this->Superclass::PrintSelf( os, indent );
  os << indent << "AmbiguousTests: " << (this->AmbiguousTests ? "On" : "Off") << endl;
  os << indent << "CurrentTestId: " << this->CurrentTestId << endl;
  os << indent << "CurrentTest: " << this->CurrentTest << endl;
  os << indent << "CurrentEdge: " << this->CurrentEdge << endl;
}

void vtkTestTessellatorSubdivision::AmbiguousTestsOn()
{
  if ( this->AmbiguousTests == 1 )
    return;

  this->AmbiguousTests = 1;
  this->CurrentEdge = 0;
  this->CurrentTestId = 0;
  this->CurrentTest = this->TestListCanAmbig[ 0 ];
  this->Modified();
}

void vtkTestTessellatorSubdivision::AmbiguousTestsOff()
{
  if ( this->AmbiguousTests == 0 )
    return;

  this->AmbiguousTests = 0;
  this->CurrentEdge = 0;
  this->CurrentTestId = 0;
  this->CurrentTest = this->TestList[ 0 ];
  this->Modified();
}

int vtkTestTessellatorSubdivision::GetCurrentTet() const
{
  if ( ! this->AmbiguousTests )
    return -1;

  return this->TestListCanAmbig[ this->CurrentTestId*3 + 1 ];
}

int vtkTestTessellatorSubdivision::GetCurrentAmbiguousFaces() const
{
  if ( ! this->AmbiguousTests )
    return -1;

  return this->TestListCanAmbig[ this->CurrentTestId*3 + 2 ];
}

bool vtkTestTessellatorSubdivision::EvaluateEdge( const double* vtkNotUsed(p0), double* vtkNotUsed(midpt), const double* vtkNotUsed(p1), int vtkNotUsed(field_start) )
{
  bool returnValue = ( this->CurrentTest & (1<<this->CurrentEdge) ) != 0;
  this->CurrentEdge++;
  if ( this->CurrentEdge > 5 )
    {
    this->CurrentEdge = 0;
    if ( this->AmbiguousTests )
      {
      do
        {
        this->CurrentTestId++;
        this->CurrentTest = this->TestListCanAmbig[ this->CurrentTestId*3 ];
        } while  ( this->TestListCanAmbig[ this->CurrentTestId*3 + 1 ] < 0 );
      }
    else
      {
      this->CurrentTestId++;
      this->CurrentTest = this->TestList[ this->CurrentTestId ];
      }
    if ( this->CurrentTest < 0 )
      {
      this->CurrentTestId = 0;
      if ( this->AmbiguousTests )
        {
        this->CurrentTest = this->TestListCanAmbig[ 0 ];
        }
      else
        {
        this->CurrentTest = this->TestList[ 0 ];
        }
      }
    }
  return returnValue;
}
// ===============================================================================

void TessellatorEdgeProcessorFunction( const double*, const double*, vtkEdgeSubdivisionCriterion*, void*, const void* )
{
  cerr << "Don't handle line segments yet." << endl;
}

void TessellatorTriangleProcessorFunction( const double* a, const double* b, const double* c, vtkEdgeSubdivisionCriterion*, void* out, const void* )
{
  (void) a;
  (void) b;
  (void) c;
  (void) out;
#if 0
  vtkUnstructuredGrid* mesh = static_cast<vtkUnstructuredGrid*>(out);
  if ( ! mesh )
    {
    cerr << "ERROR: You didn't pass me a mesh in which to place the triangle." << endl;
    vtkTessellatorError = 1;
    return;
    }

  vtkPoints* p = mesh->GetPoints();
  vtkIdType ids[3];
  ids[0] = p->InsertNextPoint( a );
  ids[1] = p->InsertNextPoint( b );
  ids[2] = p->InsertNextPoint( c );
  mesh->InsertNextCell( VTK_TRIANGLE, 3, ids );

#ifdef VTK_GENERATE_BASELINE
  if ( ! vtkTessellatorIsInteractive )
    {
    //tessellatorRegressionTest.StdOut()
    otri
      << "  { { " << a[0] << ", " << a[1] << ", " << a[2]
      << " }, { " << b[0] << ", " << b[1] << ", " << b[2]
      << " }, { " << c[0] << ", " << c[1] << ", " << c[2]
      << " } },\n";
    ++otriCtr;
    }
#endif // 0
#ifdef VTK_CHECK_RESULTS
  for ( int pt = 0; pt < 3; ++pt )
    {
    if ( vtkOTriPtr[    pt] != a[pt] )
      {
      cerr << "ERROR: Test \"" << vtkTestSummaries[vtkTstCode].Name << "\" bad output tri coord, tri " << vtkOTriCtr << " point a, coord " << pt << "\n";
      vtkTessellatorError = 1;
      }
    if ( vtkOTriPtr[3 + pt] != b[pt] )
      {
      cerr << "ERROR: Test \"" << vtkTestSummaries[vtkTstCode].Name << "\" bad output tri coord, tri " << vtkOTriCtr << " point b, coord " << pt << "\n";
      vtkTessellatorError = 1;
      }
    if ( vtkOTriPtr[6 + pt] != c[pt] )
      {
      cerr << "ERROR: Test \"" << vtkTestSummaries[vtkTstCode].Name << "\" bad output tri coord, tri " << vtkOTriCtr << " point c, coord " << pt << "\n";
      vtkTessellatorError = 1;
      }
    }
  vtkOTriPtr += 9;
  ++vtkOTriCtr;
#endif // VTK_CHECK_RESULTS
#endif // 0
}

void TessellatorTetrahedronProcessorFunction( const double* a, const double* b, const double* c, const double* d, vtkEdgeSubdivisionCriterion*, void* out, const void* )
{
  vtkUnstructuredGrid* mesh = static_cast<vtkUnstructuredGrid*>(out);
  if ( ! mesh )
    {
    cerr << "ERROR: You didn't pass me a mesh in which to place the tetrahedron." << endl;
    return;
    }

  vtkPoints* p = mesh->GetPoints();
  vtkIdType ids[4];
  ids[0] = p->InsertNextPoint( a );
  ids[1] = p->InsertNextPoint( b );
  ids[2] = p->InsertNextPoint( c );
  ids[3] = p->InsertNextPoint( d );
  mesh->InsertNextCell( VTK_TETRA, 4, ids );

#ifdef VTK_GENERATE_BASELINE
  if ( ! vtkTessellatorIsInteractive )
    {
    //tessellatorRegressionTest.StdOut()
    otet
      << "  { { " << a[0] << ", " << a[1] << ", " << a[2]
      << " }, { " << b[0] << ", " << b[1] << ", " << b[2]
      << " }, { " << c[0] << ", " << c[1] << ", " << c[2]
      << " }, { " << d[0] << ", " << d[1] << ", " << d[2]
      << " } },\n";
    ++otetCtr;
    }
#endif // 0
#ifdef VTK_CHECK_RESULTS
  for ( int pt = 0; pt < 3; ++pt )
    {
    if ( vtkOTetPtr[    pt] != a[pt] )
      {
      cerr << "ERROR: Test \"" << vtkTestSummaries[vtkTstCode].Name << "\" bad output tet coord, tet " << vtkOTetCtr << " point a, coord " << pt << "\n";
      vtkTessellatorError = 1;
      }
    if ( vtkOTetPtr[3 + pt] != b[pt] )
      {
      cerr << "ERROR: Test \"" << vtkTestSummaries[vtkTstCode].Name << "\" bad output tet coord, tet " << vtkOTetCtr << " point b, coord " << pt << "\n";
      vtkTessellatorError = 1;
      }
    if ( vtkOTetPtr[6 + pt] != c[pt] )
      {
      cerr << "ERROR: Test \"" << vtkTestSummaries[vtkTstCode].Name << "\" bad output tet coord, tet " << vtkOTetCtr << " point c, coord " << pt << "\n";
      vtkTessellatorError = 1;
      }
    if ( vtkOTetPtr[9 + pt] != d[pt] )
      {
      cerr << "ERROR: Test \"" << vtkTestSummaries[vtkTstCode].Name << "\" bad output tet coord, tet " << vtkOTetCtr << " point d, coord " << pt << "\n";
      vtkTessellatorError = 1;
      }
    }
  vtkOTetPtr += 12;
  ++vtkOTetCtr;
#endif // VTK_CHECK_RESULTS
}

class vtkTessellatorScreenShot : public vtkCommand
{
public:
  static vtkTessellatorScreenShot* New()
    { return new vtkTessellatorScreenShot; }
  vtkTessellatorScreenShot() { this->RenderWindow = 0; this->FileName = 0; }
  vtkRenderWindow* RenderWindow;
  char* FileName;
  virtual void Execute( vtkObject* vtkNotUsed(caller), unsigned long vtkNotUsed(event), void* vtkNotUsed(junk) )
  {
    if ( (! this->RenderWindow) || (! this->FileName) )
      return;

    vtkWindowToImageFilter* wif = vtkWindowToImageFilter::New();
    vtkPNGWriter* pw = vtkPNGWriter::New();
    wif->SetInput( this->RenderWindow );
    wif->ReadFrontBufferOff();
    this->RenderWindow->Render();

    pw->SetFileName( this->FileName );
    pw->SetInputConnection( wif->GetOutputPort() );
    pw->Write();

    pw->Delete();
    wif->Delete();
  }
};

int TestTessellator( int argc, char* argv[] )
{
  vtkTessellatorError = 0;
#ifdef VTK_GENERATE_BASELINE
  itet.open( "itet.c" );
  otet.open( "otet.c" );
  tstc.open( "tstc.c" );

  itet << "static double vtkITetList[][4][3] =\n{\n";
  otet << "static double vtkOTetList[][4][3] =\n{\n";
  tstc << "static struct {\n  const char* Name;\n  int BeginOffset;\n  int EndOffset;\n}  vtkTestSummaries[] =\n{\n";
#endif // VTK_GENERATE_BASELINE
#ifdef VTK_CHECK_RESULTS
  vtkOTetCtr = 0;
  vtkITetCtr = 0;
  vtkTstCode = 0;
  vtkITetPtr = &vtkITetList[0][0][0];
  vtkOTetPtr = &vtkOTetList[0][0][0];
#endif // VTK_CHECK_RESULTS

  int endpts[6][2] =
  {
    { 0, 1 },
    { 1, 2 },
    { 2, 0 },
    { 0, 3 },
    { 1, 3 },
    { 2, 3 },
  };

  int skip = 0;
  vtkTessellatorIsInteractive = 0;
  for ( int i = 0; i < argc; ++i )
    {
    if ( ! strcmp( argv[i], "-skip" ) )
      {
      skip = 1;
      }
    else if ( ! strcmp( argv[i], "-I" ) )
      {
      vtkTessellatorIsInteractive = 1;
      }
    }

  // Set up the objects for the test
  vtkUnstructuredGrid* ug = vtkUnstructuredGrid::New();
  vtkPoints* ugpts = vtkPoints::New();
  ug->SetPoints( ugpts );
  ugpts->FastDelete();
  vtkStreamingTessellator* at = vtkStreamingTessellator::New();
  vtkTestTessellatorSubdivision* tt = vtkTestTessellatorSubdivision::New();
  at->ResetCounts();

  vtkShrinkFilter* sf = 0;
  vtkActor* a = 0;
  vtkDataSetMapper* m = 0;
  vtkRenderer* r = 0;
  vtkRenderWindow* rw = 0;
  vtkRenderWindowInteractor* ri = 0;

  vtkUnstructuredGrid* startTet = 0;
  vtkPoints* startTetPts = 0;
  vtkIdType startTetConn[4];
  char annotation[512];
  char screenshotfile[512];
  vtkTextActor* annotationActor = 0;
  vtkIdTypeArray* pids = 0;
  vtkTessellatorScreenShot* ss = 0;
  vtkDataSetMapper* startTetWireMapper = 0;
  vtkActor* startTetWireActor = 0;
  vtkLabeledDataMapper* startTetLabelMapper = 0;
  vtkActor2D* startTetLabelActor = 0;
  vtkSphereSource* sphere = 0;
  vtkGlyph3D* vertMarkers = 0;
  vtkPolyDataMapper* vertMarkerMapper = 0;
  vtkActor* vertMarkerActor = 0;

  if ( vtkTessellatorIsInteractive )
    {
    sf = vtkShrinkFilter::New();
    a = vtkActor::New();
    m = vtkDataSetMapper::New();
    r = vtkRenderer::New();
    rw = vtkRenderWindow::New();
    ri = vtkRenderWindowInteractor::New();

    rw->AddRenderer( r );
    rw->SetInteractor( ri );
#ifdef FOR_PAPER
    r->SetBackground( 1., 1., 1. );
#else
    r->SetBackground( 0.3, 0.3, 0.7 );
#endif // FOR_PAPER
    r->AddActor( a );
    a->SetMapper( m );
    sf->SetInputData( ug );
#ifdef ONLY_WIRE
    sf->SetShrinkFactor( 1. );
#endif // ONLY_WIRE
    m->SetInputConnection( sf->GetOutputPort() );
    // Add some visual pizazz
    startTet = vtkUnstructuredGrid::New();
    startTetWireMapper = vtkDataSetMapper::New();
    startTetWireActor = vtkActor::New();
    startTetWireMapper->SetInputData( startTet );
    startTetWireMapper->ScalarVisibilityOff();
    startTetWireActor->SetMapper( startTetWireMapper );
    startTetWireActor->GetProperty()->SetRepresentationToWireframe();
    startTetWireActor->GetProperty()->SetDiffuse( 0. );
    startTetWireActor->GetProperty()->SetSpecular( 0. );
    startTetWireActor->GetProperty()->SetLineWidth( 2.0 );
#ifdef ONLY_WIRE
    a->GetProperty()->SetDiffuse( 0. );
    a->GetProperty()->SetSpecular( 0. );
    a->GetProperty()->SetRepresentationToWireframe();
#endif // ONLY_WIRE
    r->AddActor( startTetWireActor );

    pids = vtkIdTypeArray::New();
    pids->SetNumberOfComponents( 1 );
    startTet->GetPointData()->SetScalars( pids );

    startTetLabelMapper = vtkLabeledDataMapper::New();
    startTetLabelActor = vtkActor2D::New();
    startTetLabelMapper->SetInputData( startTet );
    startTetLabelMapper->SetLabelModeToLabelScalars();
    startTetLabelMapper->SetLabelFormat( "  %2d" );
    //startTetLabelMapper->SetLabelModeToLabelIds();
    startTetLabelActor->SetMapper( startTetLabelMapper );
    r->AddActor2D( startTetLabelActor );
    startTetLabelMapper->GetLabelTextProperty()->SetFontSize( 32 );
#ifdef FOR_PAPER
    startTetLabelMapper->GetLabelTextProperty()->SetColor( .1, .1, 0.7 );
#endif // FOR_PAPER

    annotationActor = vtkTextActor::New();
    annotationActor->GetTextProperty()->SetFontSize( 24 );
    annotationActor->GetTextProperty()->ShadowOn();
    annotationActor->SetPosition2( 10, 40 );
#ifndef FOR_PAPER
    r->AddActor2D( annotationActor );
#endif //  FOR_PAPER

    sphere = vtkSphereSource::New();
    vertMarkers = vtkGlyph3D::New();
    vertMarkerMapper = vtkPolyDataMapper::New();
    vertMarkerActor = vtkActor::New();
    vertMarkerMapper->SetInputConnection( vertMarkers->GetOutputPort() );
    vertMarkerMapper->ScalarVisibilityOff();
    vertMarkerActor->SetMapper( vertMarkerMapper );
    vertMarkerActor->GetProperty()->SetColor( 0.6, 0.2, 0.2 );
    vertMarkers->SetInputData( startTet );
    vertMarkers->SetSourceConnection( sphere->GetOutputPort() );
    vertMarkers->SetScaleModeToDataScalingOff();
    vertMarkers->SetScaleFactor(0.125);
    r->AddActor( vertMarkerActor );

    sprintf( screenshotfile, "somethingIsWrong.png" );
    ss = vtkTessellatorScreenShot::New();
    ss->RenderWindow = rw;
    ss->FileName = screenshotfile;
    ri->AddObserver( vtkCommand::UserEvent, ss );
    }

  at->SetPrivateData(ug);
  at->SetSubdivisionAlgorithm( tt );
  at->SetEmbeddingDimension( -1, 3 );
  at->SetEdgeCallback( TessellatorEdgeProcessorFunction );
  at->SetTriangleCallback( TessellatorTriangleProcessorFunction );
  at->SetTetrahedronCallback( TessellatorTetrahedronProcessorFunction );
  at->SetMaximumNumberOfSubdivisions( 1 );
  at->SetFieldSize( -1, 0 );

  double* tetPoints = 0;

  if ( ! skip )
    {
    tetPoints = vtkTestTessellatorSubdivision::TestPoints;
    for ( int g = 0; g < 6; ++g )
      {
#ifdef VTK_GENERATE_BASELINE
      if ( ! vtkTessellatorIsInteractive )
        {
        //tessellatorRegressionTest.StdOut()
        itet
          << "  { { " << tetPoints[ 0] << ", " << tetPoints[ 1] << ", " << tetPoints[ 2]
          << " }, { " << tetPoints[ 6] << ", " << tetPoints[ 7] << ", " << tetPoints[ 8]
          << " }, { " << tetPoints[12] << ", " << tetPoints[13] << ", " << tetPoints[14]
          << " }, { " << tetPoints[18] << ", " << tetPoints[19] << ", " << tetPoints[20]
          << " } },\n";
        }
#endif // VTK_GENERATE_BASELINE
#ifdef VTK_CHECK_RESULTS
      for ( int pt = 0; pt < 4; ++pt )
        {
        for ( int cr = 0; cr < 3; ++cr, ++vtkITetPtr )
          {
          if ( *vtkITetPtr != tetPoints[pt*6 + cr] )
            {
            cerr
              << "ERROR: Test \"" << vtkTestSummaries[vtkTstCode].Name << "\" bad input tet coord, tet " << vtkITetCtr
              << " point " << pt << " coord " << cr << " was " << tetPoints[pt*6 + cr] << ", expecting " << *vtkITetPtr
              << "\n";
            vtkTessellatorError = 1;
            }
          }
        }
      ++vtkITetCtr;
#endif // VTK_CHECK_RESULTS
      // Test every edge code for a tet with the current edge lengths
      int lastTestId = -1;
      int edgeCode;
      while ( tt->GetCurrentTestId() > lastTestId )
        {
        lastTestId = tt->GetCurrentTestId();
        edgeCode = tt->GetCurrentTest();
        sprintf( screenshotfile, "Tessellator-%03du-%02d.png", lastTestId, edgeCode );

        if ( vtkTessellatorIsInteractive )
          {
          // Draw a nice picture of the starting tet
          startTet->Reset();
          pids->Reset();
          startTetPts = vtkPoints::New();
          startTetConn[0] = startTetPts->InsertNextPoint( tetPoints );
          startTetConn[1] = startTetPts->InsertNextPoint( tetPoints +  6 );
          startTetConn[2] = startTetPts->InsertNextPoint( tetPoints + 12 );
          startTetConn[3] = startTetPts->InsertNextPoint( tetPoints + 18 );
          pids->InsertTuple1( 0, 0 );
          pids->InsertTuple1( 1, 1 );
          pids->InsertTuple1( 2, 2 );
          pids->InsertTuple1( 3, 3 );
          }
        int k = 4;
        for ( int i=0; i<6; ++i )
          {
          if ( ! ((edgeCode >>i) & 1) )
            continue;
          double midpt[3];
          for ( int j=0; j<3; ++j )
            midpt[j] = (tetPoints[6*endpts[i][0]+j] + tetPoints[6*endpts[i][1]+j])/2.;
          if ( vtkTessellatorIsInteractive )
            {
            startTetPts->InsertNextPoint( midpt );
            pids->InsertTuple1( k, i+4 );
            }
          k++;
          }
        sprintf( annotation, "Edge code %d = %d%d%d%d%d%d, Test ID %d",
          edgeCode,
          (edgeCode & 1),      ((edgeCode >> 1)&1), ((edgeCode >> 2)&1),
          ((edgeCode >> 3)&1), ((edgeCode >> 4)&1), ((edgeCode >> 5)&1),
          lastTestId );
        if ( vtkTessellatorIsInteractive )
          {
          startTet->SetPoints( startTetPts );
          startTetPts->FastDelete();
          startTet->InsertNextCell( VTK_TETRA, 4, startTetConn );

          annotationActor->SetInput( annotation );
          }
#ifdef VTK_GENERATE_BASELINE
        //tessellatorRegressionTest.StdOut() << annotation << "\nOutput Tetrahedra:\n";
        //cout << annotation << "\nOutput Tetrahedra:\n";
        if ( otetCtr )
          {
          tstc << ", " << otetCtr << " },\n";
          }
        tstc << "  { \"" << annotation << "\", " << otetCtr; // << " },\n";
        //otet << "},\n{\n";
#endif // VTK_GENERATE_BASELINE
#ifdef VTK_CHECK_RESULTS
        if ( strcmp( vtkTestSummaries[vtkTstCode].Name, annotation ) )
          {
          cerr << "ERROR: Test " << vtkTstCode << " was named \"" << annotation << ", expecting \"" << vtkTestSummaries[vtkTstCode].Name << "\"\n";
          vtkTessellatorError = 1;
          }
        if ( vtkOTetCtr != vtkTestSummaries[vtkTstCode].BeginOffset )
          {
          cerr
            << "ERROR: Test " << vtkTstCode << " started at offset "
            << vtkOTetCtr << ", expecting " << vtkTestSummaries[vtkTstCode].BeginOffset << "--" << vtkTestSummaries[vtkTstCode].EndOffset << "\n";
          vtkTessellatorError = 1;
          }
        ++vtkTstCode;
#endif // VTK_CHECK_RESULTS
        ug->Reset();
        ugpts = vtkPoints::New();
        ug->SetPoints( ugpts );
        ugpts->FastDelete();
        at->AdaptivelySample3Facet( tetPoints, tetPoints + 6, tetPoints + 12, tetPoints + 18 );
        if ( vtkTessellatorIsInteractive )
          {
          r->ResetCamera();
          rw->Render();
          ri->Start();
          }
        }

      tetPoints += 24;
      }
    }
  else
    {
#ifdef VTK_CHECK_RESULTS
    vtkTstCode = 384; // First ambiguous case
    vtkITetCtr = 6; // Input tet corresponding to first ambiguous case
    vtkOTetCtr = vtkTestSummaries[vtkTstCode].BeginOffset;
    vtkITetPtr = &vtkITetList[vtkITetCtr][0][0];
    vtkOTetPtr = &vtkOTetList[vtkOTetCtr][0][0];
#endif // VTK_CHECK_RESULTS
    }


  // Now loop over ambiguous cases
  int lastTestId = -1;
  int edgeCode;
  tt->AmbiguousTestsOn();
  while ( tt->GetCurrentTestId() > lastTestId )
    {
    int tet = tt->GetCurrentTet();
    if ( tet < 0 )
      continue;

    sprintf( screenshotfile, "Tessellator-%03da-%02d.png", tt->GetCurrentTestId(), tt->GetCurrentTest() );

    tetPoints = vtkTestTessellatorSubdivision::TestPointsCanAmbig + 24*tet;
#ifdef VTK_GENERATE_BASELINE
    itet
      << "  { { " << tetPoints[ 0] << ", " << tetPoints[ 1] << ", " << tetPoints[ 2]
      << " }, { " << tetPoints[ 6] << ", " << tetPoints[ 7] << ", " << tetPoints[ 8]
      << " }, { " << tetPoints[12] << ", " << tetPoints[13] << ", " << tetPoints[14]
      << " }, { " << tetPoints[18] << ", " << tetPoints[19] << ", " << tetPoints[20]
      << " } },\n";
#endif // VTK_GENERATE_BASELINE
#ifdef VTK_CHECK_RESULTS
    for ( int pt = 0; pt < 4; ++pt )
      {
      for ( int cr = 0; cr < 3; ++cr, ++vtkITetPtr )
        {
        if ( *vtkITetPtr != tetPoints[pt*6 + cr] )
          {
          cerr
            << "ERROR: Test \"" << vtkTestSummaries[vtkTstCode].Name << "\" bad input tet coord, tet " << vtkITetCtr
            << " point " << pt << " coord " << cr << " was " << tetPoints[pt*6 + cr] << ", expecting " << *vtkITetPtr
            << "\n";
          vtkTessellatorError = 1;
          }
        }
      }
    ++vtkITetCtr;
#endif // VTK_CHECK_RESULTS
    lastTestId = tt->GetCurrentTestId();
    edgeCode = tt->GetCurrentTest();

    if ( vtkTessellatorIsInteractive )
      {
      // Draw a nice picture of the starting tet
      startTet->Reset();
      pids->Reset();
      startTetPts = vtkPoints::New();
      startTetConn[0] = startTetPts->InsertNextPoint( tetPoints );
      startTetConn[1] = startTetPts->InsertNextPoint( tetPoints +  6 );
      startTetConn[2] = startTetPts->InsertNextPoint( tetPoints + 12 );
      startTetConn[3] = startTetPts->InsertNextPoint( tetPoints + 18 );
      pids->InsertTuple1( 0, 0 );
      pids->InsertTuple1( 1, 1 );
      pids->InsertTuple1( 2, 2 );
      pids->InsertTuple1( 3, 3 );
      }
    int k=4;
    for ( int i=0; i<6; ++i )
      {
      if ( ! ((edgeCode >>i) & 1) )
        continue;
      double midpt[3];
      for ( int j=0; j<3; ++j )
        midpt[j] = (tetPoints[6*endpts[i][0]+j] + tetPoints[6*endpts[i][1]+j])/2.;
      if ( vtkTessellatorIsInteractive )
        {
        startTetPts->InsertNextPoint( midpt );
        pids->InsertTuple1( k, i+4 );
        }
      k++;
      }
    if ( vtkTessellatorIsInteractive )
      {
      int x = tt->GetCurrentAmbiguousFaces();
      double* fp = vtkTestTessellatorSubdivision::TestFacePointsCanAmbig[tt->GetCurrentTestId()];
      for ( int z=0; z<4; ++z )
        {
        if ( x & (1<<z) )
          {
          startTetPts->InsertNextPoint( fp );
          pids->InsertTuple1( k++, z+10 );
          fp += 3;
          }
        }
      }
    sprintf( annotation, "Edge code %d = %d%d%d%d%d%d, Test ID %d*",
      edgeCode,
      (edgeCode & 1),      ((edgeCode >> 1)&1), ((edgeCode >> 2)&1),
      ((edgeCode >> 3)&1), ((edgeCode >> 4)&1), ((edgeCode >> 5)&1),
      lastTestId );
    if ( vtkTessellatorIsInteractive )
      {
      startTet->SetPoints( startTetPts );
      startTetPts->FastDelete();
      startTet->InsertNextCell( VTK_TETRA, 4, startTetConn );

      annotationActor->SetInput( annotation );
      }
#ifdef VTK_GENERATE_BASELINE
    //tessellatorRegressionTest.StdOut() << annotation << "\nOutput Tetrahedra:\n";
    //cout << annotation << "\nOutput Tetrahedra:\n";
    //tstc << "\"" << annotation << "\",\n";
    //tstc << "  { \"" << annotation << "\", " << otetCtr << " },\n";
    if ( otetCtr )
      {
      tstc << ", " << otetCtr << " },\n";
      }
    tstc << "  { \"" << annotation << "\", " << otetCtr; // << " },\n";
#endif // VTK_GENERATE_BASELINE
#ifdef VTK_CHECK_RESULTS
    if ( strcmp( vtkTestSummaries[vtkTstCode].Name, annotation ) )
      {
      cerr << "ERROR: Test " << vtkTstCode << " was named \"" << annotation << ", expecting \"" << vtkTestSummaries[vtkTstCode].Name << "\"\n";
      vtkTessellatorError = 1;
      }
    if ( vtkOTetCtr != vtkTestSummaries[vtkTstCode].BeginOffset )
      {
      cerr
        << "ERROR: Test " << vtkTstCode << " started at offset "
        << vtkOTetCtr << ", expecting " << vtkTestSummaries[vtkTstCode].BeginOffset << "--" << vtkTestSummaries[vtkTstCode].EndOffset << "\n";
      vtkTessellatorError = 1;
      }
    ++vtkTstCode;
#endif // VTK_CHECK_RESULTS
    ug->Reset();
    ugpts = vtkPoints::New();
    ug->SetPoints( ugpts );
    ugpts->FastDelete();
    at->AdaptivelySample3Facet( tetPoints, tetPoints + 6, tetPoints + 12, tetPoints + 18 );
    if ( vtkTessellatorIsInteractive )
      {
      r->ResetCamera();
      rw->Render();
      ri->Start();
      }
    }

  for ( int c=0; c<11; ++c )
    {
    cout << at->GetCaseCount(c);
    for ( int s=0; s<51; ++s )
      cout << " " << at->GetSubcaseCount(c,s);
    cout << endl;
    }

  ug->Delete();
  at->Delete();
  tt->Delete();
  if ( vtkTessellatorIsInteractive )
    {
    startTet->Delete();
    sf->Delete();
    ri->Delete();
    r->Delete();
    rw->Delete();
    m->Delete();
    a->Delete();
    }

#ifdef VTK_GENERATE_BASELINE
  itet << "};\n";
  otet << "};\n";
  tstc << ", " << otetCtr << " }\n};\n";

  itet.close();
  otet.close();
  tstc.close();
#endif // VTK_GENERATE_BASELINE

#ifdef VTK_CHECK_RESULTS
  --vtkTstCode;
  if ( vtkOTetCtr != vtkTestSummaries[vtkTstCode].EndOffset )
    {
    cerr
      << "ERROR: Test " << vtkTstCode << " ended at offset "
      << vtkOTetCtr << ", expecting " << vtkTestSummaries[vtkTstCode].BeginOffset << "--" << vtkTestSummaries[vtkTstCode].EndOffset << "\n";
    vtkTessellatorError = 1;
    }
#endif // VTK_CHECK_RESULTS

#ifdef VTK_DATA_ROOT
  // Test vtkTessellatorFilter and vtkDataSetEdgeSubdivisionCriterion if we have a dataset to use
  char* fname = vtkTestUtilities::ExpandDataFileName( argc, argv, "Data/quadraticTetra01.vtu" );
  if ( fname )
    {
    vtkXMLUnstructuredGridReader* rdr = vtkXMLUnstructuredGridReader::New();
    rdr->SetFileName( fname );
    delete [] fname ;
    rdr->Update();

    vtkTessellatorFilter* tf = vtkTessellatorFilter::New();
    tf->SetInputConnection( rdr->GetOutputPort() );
    tf->MergePointsOn();
    tf->Update();

    for ( int odim = 1; odim < 4; ++odim )
      {
      tf->SetOutputDimension( odim );
      tf->Update();
      }

    tf->MergePointsOff();
    tf->Update();

    rdr->Delete();
    tf->Delete();
    }
#endif // VTK_DATA_ROOT
  
  return vtkTessellatorError;
}
