/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.overlay;

import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.media.j3d.Behavior;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOr;
import org.j3d.renderer.java3d.overlay.InputRequester;
import org.j3d.renderer.java3d.overlay.Overlay;

class AWTEventBehavior
extends Behavior
implements InputRequester {
    private static final int REBUILD_ID = 1008;
    private WakeupOnAWTEvent awtCondition;
    private ArrayList mouseOverlays;
    private HashMap mouseListeners;
    private ArrayList motionOverlays;
    private HashMap motionListeners;
    private KeyListener currentKey;
    private HashMap keyListeners;
    private WakeupOnBehaviorPost postCondition = new WakeupOnBehaviorPost((Behavior)this, 1008);
    private WakeupCondition bothConditions;
    private Overlay currentMouseOverlay;
    private MouseListener lastMouse;
    private Overlay lastMouseOverlay;
    private Overlay currentMotionOverlay;
    private MouseMotionListener lastMotion;
    private Overlay lastMotionOverlay;
    private boolean inDrag = false;

    public AWTEventBehavior() {
        this.mouseListeners = new HashMap();
        this.mouseOverlays = new ArrayList();
        this.motionListeners = new HashMap();
        this.motionOverlays = new ArrayList();
        this.keyListeners = new HashMap();
    }

    public void requestFocus(Object object) {
        if (this.keyListeners.containsKey(object)) {
            this.currentKey = (KeyListener)this.keyListeners.get(object);
        }
    }

    public void addMouseListener(MouseListener mouseListener, Overlay overlay) {
        if (mouseListener == null) {
            return;
        }
        boolean bl = this.mouseOverlays.size() == 0;
        this.mouseListeners.put(overlay, mouseListener);
        this.mouseOverlays.add(overlay);
        if (bl) {
            this.rebuildCriteria();
            this.postId(1008);
        }
    }

    public void removeMouseListener(MouseListener mouseListener, Overlay overlay) {
        if (mouseListener == null) {
            return;
        }
        this.mouseListeners.remove(overlay);
        this.mouseOverlays.remove(overlay);
        if (this.mouseListeners.size() == 0) {
            this.rebuildCriteria();
        }
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener, Overlay overlay) {
        if (mouseMotionListener == null) {
            return;
        }
        boolean bl = this.motionListeners.size() == 0;
        this.motionListeners.put(overlay, mouseMotionListener);
        this.motionOverlays.add(overlay);
        if (bl) {
            this.rebuildCriteria();
            this.postId(1008);
        }
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener, Overlay overlay) {
        if (mouseMotionListener == null) {
            return;
        }
        this.motionListeners.remove(overlay);
        this.motionOverlays.remove(overlay);
        if (this.motionListeners.size() == 0) {
            this.rebuildCriteria();
        }
    }

    public void addKeyListener(KeyListener keyListener, Object object) {
        boolean bl;
        if (keyListener == null) {
            return;
        }
        boolean bl2 = bl = this.keyListeners.size() == 0;
        if (keyListener != null) {
            this.keyListeners.put(object, keyListener);
        }
        if (bl) {
            this.rebuildCriteria();
            this.postId(1008);
        }
    }

    public void removeKeyListener(KeyListener keyListener, Object object) {
        if (keyListener == null) {
            return;
        }
        Object v = this.keyListeners.get(object);
        if (v == keyListener) {
            this.keyListeners.remove(object);
        }
        if (this.keyListeners.size() == 0) {
            this.rebuildCriteria();
        }
    }

    public void initialize() {
        if (this.awtCondition != null) {
            this.wakeupOn(this.bothConditions);
        } else {
            this.wakeupOn((WakeupCondition)this.postCondition);
        }
    }

    public void processStimulus(Enumeration enumeration) {
        if (this.awtCondition.hasTriggered()) {
            AWTEvent[] aWTEventArray = this.awtCondition.getAWTEvent();
            MouseListener mouseListener = null;
            MouseMotionListener mouseMotionListener = null;
            block12: for (int i = 0; i < aWTEventArray.length; ++i) {
                switch (aWTEventArray[i].getID()) {
                    case 401: {
                        if (this.currentKey == null) continue block12;
                        this.currentKey.keyPressed((KeyEvent)aWTEventArray[i]);
                        continue block12;
                    }
                    case 402: {
                        if (this.currentKey == null) continue block12;
                        this.currentKey.keyReleased((KeyEvent)aWTEventArray[i]);
                        continue block12;
                    }
                    case 400: {
                        if (this.currentKey == null) continue block12;
                        this.currentKey.keyTyped((KeyEvent)aWTEventArray[i]);
                        continue block12;
                    }
                    case 501: {
                        MouseEvent mouseEvent2 = (MouseEvent)aWTEventArray[i];
                        mouseListener = this.getMouseListener(mouseEvent2.getPoint());
                        if (mouseListener == null) continue block12;
                        this.adjustMousePosition(mouseEvent2, this.currentMouseOverlay);
                        mouseListener.mousePressed(mouseEvent2);
                        continue block12;
                    }
                    case 502: {
                        MouseEvent mouseEvent2 = (MouseEvent)aWTEventArray[i];
                        mouseListener = this.getMouseListener(mouseEvent2.getPoint());
                        if (mouseListener == null) continue block12;
                        this.adjustMousePosition(mouseEvent2, this.currentMouseOverlay);
                        mouseListener.mouseReleased(mouseEvent2);
                        continue block12;
                    }
                    case 500: {
                        MouseEvent mouseEvent2 = (MouseEvent)aWTEventArray[i];
                        mouseListener = this.getMouseListener(mouseEvent2.getPoint());
                        if (mouseListener == null) continue block12;
                        this.adjustMousePosition(mouseEvent2, this.currentMouseOverlay);
                        mouseListener.mouseClicked(mouseEvent2);
                        continue block12;
                    }
                    case 504: {
                        MouseEvent mouseEvent;
                        MouseEvent mouseEvent2 = (MouseEvent)aWTEventArray[i];
                        mouseListener = this.getMouseListener(mouseEvent2.getPoint());
                        if (mouseListener == this.lastMouse) continue block12;
                        if (this.lastMouse != null) {
                            mouseEvent = this.cloneEvent(mouseEvent2, true);
                            this.adjustMousePosition(mouseEvent, this.lastMouseOverlay);
                            this.lastMouse.mouseExited(mouseEvent);
                        }
                        if (this.inDrag) continue block12;
                        this.adjustMousePosition(mouseEvent2, this.currentMouseOverlay);
                        mouseListener.mouseEntered(mouseEvent2);
                        this.lastMouse = mouseListener;
                        continue block12;
                    }
                    case 505: {
                        MouseEvent mouseEvent2 = (MouseEvent)aWTEventArray[i];
                        mouseListener = this.getMouseListener(mouseEvent2.getPoint());
                        if (this.inDrag) continue block12;
                        if (mouseListener != null) {
                            this.adjustMousePosition(mouseEvent2, this.currentMouseOverlay);
                            mouseListener.mouseExited(mouseEvent2);
                        }
                        this.lastMouse = null;
                        this.lastMotion = null;
                        continue block12;
                    }
                    case 506: {
                        MouseEvent mouseEvent2 = (MouseEvent)aWTEventArray[i];
                        this.inDrag = true;
                        if (this.lastMotion == null) continue block12;
                        this.adjustMousePosition(mouseEvent2, this.currentMotionOverlay);
                        this.lastMotion.mouseDragged(mouseEvent2);
                        continue block12;
                    }
                    case 503: {
                        MouseEvent mouseEvent;
                        MouseEvent mouseEvent2 = (MouseEvent)aWTEventArray[i];
                        mouseListener = this.getMouseListener(mouseEvent2.getPoint());
                        if (mouseListener != this.lastMouse) {
                            if (this.lastMouse == null) {
                                mouseEvent = this.cloneEvent(mouseEvent2, false);
                                this.adjustMousePosition(mouseEvent, this.currentMouseOverlay);
                                mouseListener.mouseEntered(mouseEvent);
                            } else if (mouseListener == null) {
                                mouseEvent = this.cloneEvent(mouseEvent2, true);
                                this.adjustMousePosition(mouseEvent, this.lastMouseOverlay);
                                this.lastMouse.mouseExited(mouseEvent);
                            } else {
                                mouseEvent = this.cloneEvent(mouseEvent2, true);
                                this.adjustMousePosition(mouseEvent, this.lastMotionOverlay);
                                this.lastMouse.mouseExited(mouseEvent);
                                mouseEvent = this.cloneEvent(mouseEvent2, false);
                                this.adjustMousePosition(mouseEvent, this.currentMouseOverlay);
                                mouseListener.mouseEntered(mouseEvent);
                            }
                            this.lastMouse = mouseListener;
                            continue block12;
                        }
                        mouseMotionListener = this.getMotionListener(mouseEvent2.getPoint());
                        if (mouseMotionListener != null) {
                            this.adjustMousePosition(mouseEvent2, this.currentMotionOverlay);
                            mouseMotionListener.mouseMoved(mouseEvent2);
                        }
                        this.lastMotion = mouseMotionListener;
                    }
                }
            }
        }
        if (this.awtCondition != null) {
            this.wakeupOn(this.bothConditions);
        } else {
            this.wakeupOn((WakeupCondition)this.postCondition);
        }
    }

    private void rebuildCriteria() {
        long l = 0L;
        if (this.mouseListeners.size() != 0) {
            l = 48L;
        } else if (this.motionListeners.size() != 0) {
            l = 32L;
        }
        if (this.keyListeners.size() != 0) {
            l |= 8L;
        }
        if (l != 0L) {
            this.awtCondition = new WakeupOnAWTEvent(l);
            WakeupCriterion[] wakeupCriterionArray = new WakeupCriterion[]{this.awtCondition, this.postCondition};
            this.bothConditions = new WakeupOr(wakeupCriterionArray);
        } else if (this.awtCondition != null) {
            this.awtCondition = null;
            this.bothConditions = null;
        }
    }

    private MouseListener getMouseListener(Point point) {
        if (this.lastMouseOverlay != null && this.lastMouseOverlay.contains(point)) {
            this.currentMouseOverlay = this.lastMouseOverlay;
            return this.lastMouse;
        }
        int n = this.mouseOverlays.size();
        Overlay overlay = null;
        for (int i = 0; !(i >= n || (overlay = (Overlay)this.mouseOverlays.get(i)).isVisible() && overlay.contains(point)); ++i) {
            overlay = null;
        }
        this.lastMouseOverlay = this.currentMouseOverlay;
        this.currentMouseOverlay = overlay != null ? overlay : null;
        MouseListener mouseListener = (MouseListener)this.mouseListeners.get(overlay);
        return mouseListener;
    }

    private MouseMotionListener getMotionListener(Point point) {
        if (this.lastMotionOverlay != null && this.lastMotionOverlay.contains(point)) {
            this.currentMotionOverlay = this.lastMotionOverlay;
            return this.lastMotion;
        }
        int n = this.motionOverlays.size();
        Overlay overlay = null;
        for (int i = 0; !(i >= n || (overlay = (Overlay)this.motionOverlays.get(i)).isVisible() && overlay.contains(point)); ++i) {
            overlay = null;
        }
        this.lastMotionOverlay = this.currentMotionOverlay;
        this.currentMotionOverlay = overlay != null ? overlay : null;
        MouseMotionListener mouseMotionListener = (MouseMotionListener)this.motionListeners.get(overlay);
        return mouseMotionListener;
    }

    private MouseEvent cloneEvent(MouseEvent mouseEvent, boolean bl) {
        return new MouseEvent(mouseEvent.getComponent(), bl ? 505 : 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
    }

    private void adjustMousePosition(MouseEvent mouseEvent, Overlay overlay) {
        if (overlay == null) {
            return;
        }
        Rectangle rectangle = overlay.getBounds();
        mouseEvent.translatePoint(-rectangle.x, -rectangle.y);
    }
}

