/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

import org.j3d.terrain.TerrainData;

class VarianceTree {
    private int[] vTree;
    private int maxLevels;
    private float maxY = -3.4028235E38f;
    private float minY = Float.MAX_VALUE;

    VarianceTree(TerrainData terrainData, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.maxLevels = (int)Math.sqrt(n);
        this.vTree = new int[1 << this.maxLevels];
        this.computeVariance(terrainData, n2, n3, n4, n5, n6, n7, 1, 0);
    }

    float computeVariance(TerrainData terrainData, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n + n3 >> 1;
        int n10 = n2 + n4 >> 1;
        float f = terrainData.getHeightFromGrid(n9, n10);
        if (f > this.maxY) {
            this.maxY = f;
        }
        if (f < this.minY) {
            this.minY = f;
        }
        float f2 = terrainData.getHeightFromGrid(n, n2);
        float f3 = terrainData.getHeightFromGrid(n3, n4);
        float f4 = Math.abs(f - (f2 + f3) * 0.5f);
        if (n8 < this.maxLevels - 1) {
            float f5 = this.computeVariance(terrainData, n5, n6, n, n2, n9, n10, n7 << 1, n8 + 1);
            f4 = Math.max(f4, f5);
            f5 = this.computeVariance(terrainData, n3, n4, n5, n6, n9, n10, 1 + (n7 << 1), n8 + 1);
            f4 = Math.max(f4, f5);
        }
        this.vTree[n7] = 1 + (int)f4;
        return f4;
    }

    int getVariance(int n) {
        return this.vTree[n];
    }

    int getMaxDepth() {
        return this.maxLevels;
    }

    float getMaxY() {
        return this.maxY;
    }

    float getMinY() {
        return this.minY;
    }
}

