/*=========================================================================

  Program:   Visualization Toolkit
  Module:    TestTreeMapView.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/*-------------------------------------------------------------------------
  Copyright 2008 Sandia Corporation.
  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
  the U.S. Government retains certain rights in this software.
-------------------------------------------------------------------------*/

#include "vtkCollection.h"
#include "vtkCommand.h"
#include "vtkDataRepresentation.h"
#include "vtkInteractorEventRecorder.h"
#include "vtkRegressionTestImage.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkSelectionLink.h"
#include "vtkStringToNumeric.h"
#include "vtkTestUtilities.h"
#include "vtkTreeMapView.h"
#include "vtkXMLTreeReader.h"

#include "vtkSmartPointer.h"
#define VTK_CREATE(type, name) \
  vtkSmartPointer<type> name = vtkSmartPointer<type>::New()

char TreeMapViewEventLog[] = 
"# StreamVersion 1\n"
"RenderEvent 0 0 0 0 0 0 0\n"
"RenderEvent 0 0 0 0 0 0 0\n"
"RenderEvent 0 0 0 0 0 0 0\n"
"RenderEvent 0 0 0 0 0 0 0\n"
"RenderEvent 0 0 0 0 0 0 0\n"
"EnterEvent 297 73 0 0 0 0 0\n"
"MouseMoveEvent 297 73 0 0 0 0 0\n"
"RenderEvent 297 73 0 0 0 0 0\n"
"RenderEvent 297 73 0 0 0 0 0\n"
"MouseMoveEvent 260 100 0 0 0 0 0\n"
"RenderEvent 260 100 0 0 0 0 0\n"
"RenderEvent 260 100 0 0 0 0 0\n"
"MouseMoveEvent 257 103 0 0 0 0 0\n"
"RenderEvent 257 103 0 0 0 0 0\n"
"RenderEvent 257 103 0 0 0 0 0\n"
"MouseMoveEvent 252 107 0 0 0 0 0\n"
"RenderEvent 252 107 0 0 0 0 0\n"
"RenderEvent 252 107 0 0 0 0 0\n"
"MouseMoveEvent 233 117 0 0 0 0 0\n"
"RenderEvent 233 117 0 0 0 0 0\n"
"RenderEvent 233 117 0 0 0 0 0\n"
"MouseMoveEvent 228 120 0 0 0 0 0\n"
"RenderEvent 228 120 0 0 0 0 0\n"
"RenderEvent 228 120 0 0 0 0 0\n"
"MouseMoveEvent 211 127 0 0 0 0 0\n"
"RenderEvent 211 127 0 0 0 0 0\n"
"RenderEvent 211 127 0 0 0 0 0\n"
"MouseMoveEvent 202 132 0 0 0 0 0\n"
"RenderEvent 202 132 0 0 0 0 0\n"
"RenderEvent 202 132 0 0 0 0 0\n"
"MouseMoveEvent 185 140 0 0 0 0 0\n"
"RenderEvent 185 140 0 0 0 0 0\n"
"RenderEvent 185 140 0 0 0 0 0\n"
"MouseMoveEvent 178 144 0 0 0 0 0\n"
"RenderEvent 178 144 0 0 0 0 0\n"
"RenderEvent 178 144 0 0 0 0 0\n"
"MouseMoveEvent 171 148 0 0 0 0 0\n"
"RenderEvent 171 148 0 0 0 0 0\n"
"RenderEvent 171 148 0 0 0 0 0\n"
"MouseMoveEvent 158 156 0 0 0 0 0\n"
"RenderEvent 158 156 0 0 0 0 0\n"
"RenderEvent 158 156 0 0 0 0 0\n"
"MouseMoveEvent 152 160 0 0 0 0 0\n"
"RenderEvent 152 160 0 0 0 0 0\n"
"RenderEvent 152 160 0 0 0 0 0\n"
"MouseMoveEvent 142 166 0 0 0 0 0\n"
"RenderEvent 142 166 0 0 0 0 0\n"
"RenderEvent 142 166 0 0 0 0 0\n"
"MouseMoveEvent 137 169 0 0 0 0 0\n"
"RenderEvent 137 169 0 0 0 0 0\n"
"RenderEvent 137 169 0 0 0 0 0\n"
"MouseMoveEvent 131 173 0 0 0 0 0\n"
"RenderEvent 131 173 0 0 0 0 0\n"
"RenderEvent 131 173 0 0 0 0 0\n"
"MouseMoveEvent 128 175 0 0 0 0 0\n"
"RenderEvent 128 175 0 0 0 0 0\n"
"RenderEvent 128 175 0 0 0 0 0\n"
"MouseMoveEvent 126 176 0 0 0 0 0\n"
"RenderEvent 126 176 0 0 0 0 0\n"
"RenderEvent 126 176 0 0 0 0 0\n"
"MouseMoveEvent 124 178 0 0 0 0 0\n"
"RenderEvent 124 178 0 0 0 0 0\n"
"RenderEvent 124 178 0 0 0 0 0\n"
"MouseMoveEvent 123 178 0 0 0 0 0\n"
"RenderEvent 123 178 0 0 0 0 0\n"
"RenderEvent 123 178 0 0 0 0 0\n"
"MouseMoveEvent 122 179 0 0 0 0 0\n"
"RenderEvent 122 179 0 0 0 0 0\n"
"RenderEvent 122 179 0 0 0 0 0\n"
"MouseMoveEvent 121 180 0 0 0 0 0\n"
"RenderEvent 121 180 0 0 0 0 0\n"
"RenderEvent 121 180 0 0 0 0 0\n"
"MouseMoveEvent 121 181 0 0 0 0 0\n"
"RenderEvent 121 181 0 0 0 0 0\n"
"RenderEvent 121 181 0 0 0 0 0\n"
"MouseMoveEvent 120 181 0 0 0 0 0\n"
"RenderEvent 120 181 0 0 0 0 0\n"
"RenderEvent 120 181 0 0 0 0 0\n"
"MouseMoveEvent 119 182 0 0 0 0 0\n"
"RenderEvent 119 182 0 0 0 0 0\n"
"RenderEvent 119 182 0 0 0 0 0\n"
"MouseMoveEvent 118 184 0 0 0 0 0\n"
"RenderEvent 118 184 0 0 0 0 0\n"
"RenderEvent 118 184 0 0 0 0 0\n"
"MouseMoveEvent 117 185 0 0 0 0 0\n"
"RenderEvent 117 185 0 0 0 0 0\n"
"RenderEvent 117 185 0 0 0 0 0\n"
"MouseMoveEvent 116 186 0 0 0 0 0\n"
"RenderEvent 116 186 0 0 0 0 0\n"
"RenderEvent 116 186 0 0 0 0 0\n"
"MouseMoveEvent 114 187 0 0 0 0 0\n"
"RenderEvent 114 187 0 0 0 0 0\n"
"RenderEvent 114 187 0 0 0 0 0\n"
"MouseMoveEvent 113 188 0 0 0 0 0\n"
"RenderEvent 113 188 0 0 0 0 0\n"
"RenderEvent 113 188 0 0 0 0 0\n"
"MouseMoveEvent 112 188 0 0 0 0 0\n"
"RenderEvent 112 188 0 0 0 0 0\n"
"RenderEvent 112 188 0 0 0 0 0\n"
"MouseMoveEvent 111 189 0 0 0 0 0\n"
"RenderEvent 111 189 0 0 0 0 0\n"
"RenderEvent 111 189 0 0 0 0 0\n"
"MouseMoveEvent 109 190 0 0 0 0 0\n"
"RenderEvent 109 190 0 0 0 0 0\n"
"RenderEvent 109 190 0 0 0 0 0\n"
"MouseMoveEvent 106 191 0 0 0 0 0\n"
"RenderEvent 106 191 0 0 0 0 0\n"
"RenderEvent 106 191 0 0 0 0 0\n"
"MouseMoveEvent 103 192 0 0 0 0 0\n"
"RenderEvent 103 192 0 0 0 0 0\n"
"RenderEvent 103 192 0 0 0 0 0\n"
"MouseMoveEvent 100 193 0 0 0 0 0\n"
"RenderEvent 100 193 0 0 0 0 0\n"
"RenderEvent 100 193 0 0 0 0 0\n"
"MouseMoveEvent 95 194 0 0 0 0 0\n"
"RenderEvent 95 194 0 0 0 0 0\n"
"RenderEvent 95 194 0 0 0 0 0\n"
"MouseMoveEvent 92 194 0 0 0 0 0\n"
"RenderEvent 92 194 0 0 0 0 0\n"
"RenderEvent 92 194 0 0 0 0 0\n"
"MouseMoveEvent 88 195 0 0 0 0 0\n"
"RenderEvent 88 195 0 0 0 0 0\n"
"RenderEvent 88 195 0 0 0 0 0\n"
"MouseMoveEvent 84 195 0 0 0 0 0\n"
"RenderEvent 84 195 0 0 0 0 0\n"
"RenderEvent 84 195 0 0 0 0 0\n"
"MouseMoveEvent 81 195 0 0 0 0 0\n"
"RenderEvent 81 195 0 0 0 0 0\n"
"RenderEvent 81 195 0 0 0 0 0\n"
"MouseMoveEvent 78 195 0 0 0 0 0\n"
"RenderEvent 78 195 0 0 0 0 0\n"
"RenderEvent 78 195 0 0 0 0 0\n"
"MouseMoveEvent 76 195 0 0 0 0 0\n"
"RenderEvent 76 195 0 0 0 0 0\n"
"RenderEvent 76 195 0 0 0 0 0\n"
"MouseMoveEvent 75 195 0 0 0 0 0\n"
"RenderEvent 75 195 0 0 0 0 0\n"
"RenderEvent 75 195 0 0 0 0 0\n"
"MiddleButtonPressEvent 75 195 0 0 0 0 0\n"
"StartInteractionEvent 75 195 0 0 0 0 0\n"
"MouseMoveEvent 76 195 0 0 0 0 0\n"
"RenderEvent 76 195 0 0 0 0 0\n"
"RenderEvent 76 195 0 0 0 0 0\n"
"RenderEvent 76 195 0 0 0 0 0\n"
"RenderEvent 76 195 0 0 0 0 0\n"
"MouseMoveEvent 78 196 0 0 0 0 0\n"
"RenderEvent 78 196 0 0 0 0 0\n"
"RenderEvent 78 196 0 0 0 0 0\n"
"RenderEvent 78 196 0 0 0 0 0\n"
"RenderEvent 78 196 0 0 0 0 0\n"
"MouseMoveEvent 78 197 0 0 0 0 0\n"
"RenderEvent 78 197 0 0 0 0 0\n"
"RenderEvent 78 197 0 0 0 0 0\n"
"RenderEvent 78 197 0 0 0 0 0\n"
"RenderEvent 78 197 0 0 0 0 0\n"
"MouseMoveEvent 79 197 0 0 0 0 0\n"
"RenderEvent 79 197 0 0 0 0 0\n"
"RenderEvent 79 197 0 0 0 0 0\n"
"RenderEvent 79 197 0 0 0 0 0\n"
"RenderEvent 79 197 0 0 0 0 0\n"
"MouseMoveEvent 79 198 0 0 0 0 0\n"
"RenderEvent 79 198 0 0 0 0 0\n"
"RenderEvent 79 198 0 0 0 0 0\n"
"RenderEvent 79 198 0 0 0 0 0\n"
"RenderEvent 79 198 0 0 0 0 0\n"
"MouseMoveEvent 80 199 0 0 0 0 0\n"
"RenderEvent 80 199 0 0 0 0 0\n"
"RenderEvent 80 199 0 0 0 0 0\n"
"RenderEvent 80 199 0 0 0 0 0\n"
"RenderEvent 80 199 0 0 0 0 0\n"
"MouseMoveEvent 81 199 0 0 0 0 0\n"
"RenderEvent 81 199 0 0 0 0 0\n"
"RenderEvent 81 199 0 0 0 0 0\n"
"RenderEvent 81 199 0 0 0 0 0\n"
"RenderEvent 81 199 0 0 0 0 0\n"
"MouseMoveEvent 82 201 0 0 0 0 0\n"
"RenderEvent 82 201 0 0 0 0 0\n"
"RenderEvent 82 201 0 0 0 0 0\n"
"RenderEvent 82 201 0 0 0 0 0\n"
"RenderEvent 82 201 0 0 0 0 0\n"
"MouseMoveEvent 83 202 0 0 0 0 0\n"
"RenderEvent 83 202 0 0 0 0 0\n"
"RenderEvent 83 202 0 0 0 0 0\n"
"RenderEvent 83 202 0 0 0 0 0\n"
"RenderEvent 83 202 0 0 0 0 0\n"
"MouseMoveEvent 84 202 0 0 0 0 0\n"
"RenderEvent 84 202 0 0 0 0 0\n"
"RenderEvent 84 202 0 0 0 0 0\n"
"RenderEvent 84 202 0 0 0 0 0\n"
"RenderEvent 84 202 0 0 0 0 0\n"
"MouseMoveEvent 85 204 0 0 0 0 0\n"
"RenderEvent 85 204 0 0 0 0 0\n"
"RenderEvent 85 204 0 0 0 0 0\n"
"RenderEvent 85 204 0 0 0 0 0\n"
"RenderEvent 85 204 0 0 0 0 0\n"
"MouseMoveEvent 86 204 0 0 0 0 0\n"
"RenderEvent 86 204 0 0 0 0 0\n"
"RenderEvent 86 204 0 0 0 0 0\n"
"RenderEvent 86 204 0 0 0 0 0\n"
"RenderEvent 86 204 0 0 0 0 0\n"
"MouseMoveEvent 87 205 0 0 0 0 0\n"
"RenderEvent 87 205 0 0 0 0 0\n"
"RenderEvent 87 205 0 0 0 0 0\n"
"RenderEvent 87 205 0 0 0 0 0\n"
"RenderEvent 87 205 0 0 0 0 0\n"
"MouseMoveEvent 87 206 0 0 0 0 0\n"
"RenderEvent 87 206 0 0 0 0 0\n"
"RenderEvent 87 206 0 0 0 0 0\n"
"RenderEvent 87 206 0 0 0 0 0\n"
"RenderEvent 87 206 0 0 0 0 0\n"
"MouseMoveEvent 88 206 0 0 0 0 0\n"
"RenderEvent 88 206 0 0 0 0 0\n"
"RenderEvent 88 206 0 0 0 0 0\n"
"RenderEvent 88 206 0 0 0 0 0\n"
"RenderEvent 88 206 0 0 0 0 0\n"
"MouseMoveEvent 88 207 0 0 0 0 0\n"
"RenderEvent 88 207 0 0 0 0 0\n"
"RenderEvent 88 207 0 0 0 0 0\n"
"RenderEvent 88 207 0 0 0 0 0\n"
"RenderEvent 88 207 0 0 0 0 0\n"
"MouseMoveEvent 89 207 0 0 0 0 0\n"
"RenderEvent 89 207 0 0 0 0 0\n"
"RenderEvent 89 207 0 0 0 0 0\n"
"RenderEvent 89 207 0 0 0 0 0\n"
"RenderEvent 89 207 0 0 0 0 0\n"
"MouseMoveEvent 89 208 0 0 0 0 0\n"
"RenderEvent 89 208 0 0 0 0 0\n"
"RenderEvent 89 208 0 0 0 0 0\n"
"RenderEvent 89 208 0 0 0 0 0\n"
"RenderEvent 89 208 0 0 0 0 0\n"
"MouseMoveEvent 90 208 0 0 0 0 0\n"
"RenderEvent 90 208 0 0 0 0 0\n"
"RenderEvent 90 208 0 0 0 0 0\n"
"RenderEvent 90 208 0 0 0 0 0\n"
"RenderEvent 90 208 0 0 0 0 0\n"
"MouseMoveEvent 90 207 0 0 0 0 0\n"
"RenderEvent 90 207 0 0 0 0 0\n"
"RenderEvent 90 207 0 0 0 0 0\n"
"RenderEvent 90 207 0 0 0 0 0\n"
"RenderEvent 90 207 0 0 0 0 0\n"
"MouseMoveEvent 90 206 0 0 0 0 0\n"
"RenderEvent 90 206 0 0 0 0 0\n"
"RenderEvent 90 206 0 0 0 0 0\n"
"RenderEvent 90 206 0 0 0 0 0\n"
"RenderEvent 90 206 0 0 0 0 0\n"
"MouseMoveEvent 89 205 0 0 0 0 0\n"
"RenderEvent 89 205 0 0 0 0 0\n"
"RenderEvent 89 205 0 0 0 0 0\n"
"RenderEvent 89 205 0 0 0 0 0\n"
"RenderEvent 89 205 0 0 0 0 0\n"
"MouseMoveEvent 88 202 0 0 0 0 0\n"
"RenderEvent 88 202 0 0 0 0 0\n"
"RenderEvent 88 202 0 0 0 0 0\n"
"RenderEvent 88 202 0 0 0 0 0\n"
"RenderEvent 88 202 0 0 0 0 0\n"
"MouseMoveEvent 86 199 0 0 0 0 0\n"
"RenderEvent 86 199 0 0 0 0 0\n"
"RenderEvent 86 199 0 0 0 0 0\n"
"RenderEvent 86 199 0 0 0 0 0\n"
"RenderEvent 86 199 0 0 0 0 0\n"
"MouseMoveEvent 84 197 0 0 0 0 0\n"
"RenderEvent 84 197 0 0 0 0 0\n"
"RenderEvent 84 197 0 0 0 0 0\n"
"RenderEvent 84 197 0 0 0 0 0\n"
"RenderEvent 84 197 0 0 0 0 0\n"
"MouseMoveEvent 82 195 0 0 0 0 0\n"
"RenderEvent 82 195 0 0 0 0 0\n"
"RenderEvent 82 195 0 0 0 0 0\n"
"RenderEvent 82 195 0 0 0 0 0\n"
"RenderEvent 82 195 0 0 0 0 0\n"
"MouseMoveEvent 80 194 0 0 0 0 0\n"
"RenderEvent 80 194 0 0 0 0 0\n"
"RenderEvent 80 194 0 0 0 0 0\n"
"RenderEvent 80 194 0 0 0 0 0\n"
"RenderEvent 80 194 0 0 0 0 0\n"
"MouseMoveEvent 78 193 0 0 0 0 0\n"
"RenderEvent 78 193 0 0 0 0 0\n"
"RenderEvent 78 193 0 0 0 0 0\n"
"RenderEvent 78 193 0 0 0 0 0\n"
"RenderEvent 78 193 0 0 0 0 0\n"
"MouseMoveEvent 76 191 0 0 0 0 0\n"
"RenderEvent 76 191 0 0 0 0 0\n"
"RenderEvent 76 191 0 0 0 0 0\n"
"RenderEvent 76 191 0 0 0 0 0\n"
"RenderEvent 76 191 0 0 0 0 0\n"
"MouseMoveEvent 75 190 0 0 0 0 0\n"
"RenderEvent 75 190 0 0 0 0 0\n"
"RenderEvent 75 190 0 0 0 0 0\n"
"RenderEvent 75 190 0 0 0 0 0\n"
"RenderEvent 75 190 0 0 0 0 0\n"
"MouseMoveEvent 74 190 0 0 0 0 0\n"
"RenderEvent 74 190 0 0 0 0 0\n"
"RenderEvent 74 190 0 0 0 0 0\n"
"RenderEvent 74 190 0 0 0 0 0\n"
"RenderEvent 74 190 0 0 0 0 0\n"
"MouseMoveEvent 73 189 0 0 0 0 0\n"
"RenderEvent 73 189 0 0 0 0 0\n"
"RenderEvent 73 189 0 0 0 0 0\n"
"RenderEvent 73 189 0 0 0 0 0\n"
"RenderEvent 73 189 0 0 0 0 0\n"
"MouseMoveEvent 71 188 0 0 0 0 0\n"
"RenderEvent 71 188 0 0 0 0 0\n"
"RenderEvent 71 188 0 0 0 0 0\n"
"RenderEvent 71 188 0 0 0 0 0\n"
"RenderEvent 71 188 0 0 0 0 0\n"
"MouseMoveEvent 70 188 0 0 0 0 0\n"
"RenderEvent 70 188 0 0 0 0 0\n"
"RenderEvent 70 188 0 0 0 0 0\n"
"RenderEvent 70 188 0 0 0 0 0\n"
"RenderEvent 70 188 0 0 0 0 0\n"
"MouseMoveEvent 67 186 0 0 0 0 0\n"
"RenderEvent 67 186 0 0 0 0 0\n"
"RenderEvent 67 186 0 0 0 0 0\n"
"RenderEvent 67 186 0 0 0 0 0\n"
"RenderEvent 67 186 0 0 0 0 0\n"
"MouseMoveEvent 65 186 0 0 0 0 0\n"
"RenderEvent 65 186 0 0 0 0 0\n"
"RenderEvent 65 186 0 0 0 0 0\n"
"RenderEvent 65 186 0 0 0 0 0\n"
"RenderEvent 65 186 0 0 0 0 0\n"
"MouseMoveEvent 64 185 0 0 0 0 0\n"
"RenderEvent 64 185 0 0 0 0 0\n"
"RenderEvent 64 185 0 0 0 0 0\n"
"RenderEvent 64 185 0 0 0 0 0\n"
"RenderEvent 64 185 0 0 0 0 0\n"
"MouseMoveEvent 61 184 0 0 0 0 0\n"
"RenderEvent 61 184 0 0 0 0 0\n"
"RenderEvent 61 184 0 0 0 0 0\n"
"RenderEvent 61 184 0 0 0 0 0\n"
"RenderEvent 61 184 0 0 0 0 0\n"
"MouseMoveEvent 59 184 0 0 0 0 0\n"
"RenderEvent 59 184 0 0 0 0 0\n"
"RenderEvent 59 184 0 0 0 0 0\n"
"RenderEvent 59 184 0 0 0 0 0\n"
"RenderEvent 59 184 0 0 0 0 0\n"
"MouseMoveEvent 56 182 0 0 0 0 0\n"
"RenderEvent 56 182 0 0 0 0 0\n"
"RenderEvent 56 182 0 0 0 0 0\n"
"RenderEvent 56 182 0 0 0 0 0\n"
"RenderEvent 56 182 0 0 0 0 0\n"
"MouseMoveEvent 55 182 0 0 0 0 0\n"
"RenderEvent 55 182 0 0 0 0 0\n"
"RenderEvent 55 182 0 0 0 0 0\n"
"RenderEvent 55 182 0 0 0 0 0\n"
"RenderEvent 55 182 0 0 0 0 0\n"
"MiddleButtonReleaseEvent 55 182 0 0 0 0 0\n"
"EndInteractionEvent 55 182 0 0 0 0 0\n"
"RenderEvent 55 182 0 0 0 0 0\n"
"RenderEvent 55 182 0 0 0 0 0\n"
"MouseMoveEvent 55 182 0 0 0 0 0\n"
"RenderEvent 55 182 0 0 0 0 0\n"
"RenderEvent 55 182 0 0 0 0 0\n"
"MouseMoveEvent 56 183 0 0 0 0 0\n"
"RenderEvent 56 183 0 0 0 0 0\n"
"RenderEvent 56 183 0 0 0 0 0\n"
"RightButtonPressEvent 56 183 0 0 0 0 0\n"
"StartInteractionEvent 56 183 0 0 0 0 0\n"
"MouseMoveEvent 57 184 0 0 0 0 0\n"
"RenderEvent 57 184 0 0 0 0 0\n"
"RenderEvent 57 184 0 0 0 0 0\n"
"RenderEvent 57 184 0 0 0 0 0\n"
"RenderEvent 57 184 0 0 0 0 0\n"
"MouseMoveEvent 59 193 0 0 0 0 0\n"
"RenderEvent 59 193 0 0 0 0 0\n"
"RenderEvent 59 193 0 0 0 0 0\n"
"RenderEvent 59 193 0 0 0 0 0\n"
"RenderEvent 59 193 0 0 0 0 0\n"
"MouseMoveEvent 59 194 0 0 0 0 0\n"
"RenderEvent 59 194 0 0 0 0 0\n"
"RenderEvent 59 194 0 0 0 0 0\n"
"RenderEvent 59 194 0 0 0 0 0\n"
"RenderEvent 59 194 0 0 0 0 0\n"
"MouseMoveEvent 59 196 0 0 0 0 0\n"
"RenderEvent 59 196 0 0 0 0 0\n"
"RenderEvent 59 196 0 0 0 0 0\n"
"RenderEvent 59 196 0 0 0 0 0\n"
"RenderEvent 59 196 0 0 0 0 0\n"
"MouseMoveEvent 59 197 0 0 0 0 0\n"
"RenderEvent 59 197 0 0 0 0 0\n"
"RenderEvent 59 197 0 0 0 0 0\n"
"RenderEvent 59 197 0 0 0 0 0\n"
"RenderEvent 59 197 0 0 0 0 0\n"
"MouseMoveEvent 59 201 0 0 0 0 0\n"
"RenderEvent 59 201 0 0 0 0 0\n"
"RenderEvent 59 201 0 0 0 0 0\n"
"RenderEvent 59 201 0 0 0 0 0\n"
"RenderEvent 59 201 0 0 0 0 0\n"
"MouseMoveEvent 59 204 0 0 0 0 0\n"
"RenderEvent 59 204 0 0 0 0 0\n"
"RenderEvent 59 204 0 0 0 0 0\n"
"RenderEvent 59 204 0 0 0 0 0\n"
"RenderEvent 59 204 0 0 0 0 0\n"
"MouseMoveEvent 59 207 0 0 0 0 0\n"
"RenderEvent 59 207 0 0 0 0 0\n"
"RenderEvent 59 207 0 0 0 0 0\n"
"RenderEvent 59 207 0 0 0 0 0\n"
"RenderEvent 59 207 0 0 0 0 0\n"
"MouseMoveEvent 59 208 0 0 0 0 0\n"
"RenderEvent 59 208 0 0 0 0 0\n"
"RenderEvent 59 208 0 0 0 0 0\n"
"RenderEvent 59 208 0 0 0 0 0\n"
"RenderEvent 59 208 0 0 0 0 0\n"
"MouseMoveEvent 59 211 0 0 0 0 0\n"
"RenderEvent 59 211 0 0 0 0 0\n"
"RenderEvent 59 211 0 0 0 0 0\n"
"RenderEvent 59 211 0 0 0 0 0\n"
"RenderEvent 59 211 0 0 0 0 0\n"
"MouseMoveEvent 59 213 0 0 0 0 0\n"
"RenderEvent 59 213 0 0 0 0 0\n"
"RenderEvent 59 213 0 0 0 0 0\n"
"RenderEvent 59 213 0 0 0 0 0\n"
"RenderEvent 59 213 0 0 0 0 0\n"
"MouseMoveEvent 60 217 0 0 0 0 0\n"
"RenderEvent 60 217 0 0 0 0 0\n"
"RenderEvent 60 217 0 0 0 0 0\n"
"RenderEvent 60 217 0 0 0 0 0\n"
"RenderEvent 60 217 0 0 0 0 0\n"
"MouseMoveEvent 60 220 0 0 0 0 0\n"
"RenderEvent 60 220 0 0 0 0 0\n"
"RenderEvent 60 220 0 0 0 0 0\n"
"RenderEvent 60 220 0 0 0 0 0\n"
"RenderEvent 60 220 0 0 0 0 0\n"
"MouseMoveEvent 60 223 0 0 0 0 0\n"
"RenderEvent 60 223 0 0 0 0 0\n"
"RenderEvent 60 223 0 0 0 0 0\n"
"RenderEvent 60 223 0 0 0 0 0\n"
"RenderEvent 60 223 0 0 0 0 0\n"
"MouseMoveEvent 60 227 0 0 0 0 0\n"
"RenderEvent 60 227 0 0 0 0 0\n"
"RenderEvent 60 227 0 0 0 0 0\n"
"RenderEvent 60 227 0 0 0 0 0\n"
"RenderEvent 60 227 0 0 0 0 0\n"
"MouseMoveEvent 60 231 0 0 0 0 0\n"
"RenderEvent 60 231 0 0 0 0 0\n"
"RenderEvent 60 231 0 0 0 0 0\n"
"RenderEvent 60 231 0 0 0 0 0\n"
"RenderEvent 60 231 0 0 0 0 0\n"
"MouseMoveEvent 60 233 0 0 0 0 0\n"
"RenderEvent 60 233 0 0 0 0 0\n"
"RenderEvent 60 233 0 0 0 0 0\n"
"RenderEvent 60 233 0 0 0 0 0\n"
"RenderEvent 60 233 0 0 0 0 0\n"
"MouseMoveEvent 60 235 0 0 0 0 0\n"
"RenderEvent 60 235 0 0 0 0 0\n"
"RenderEvent 60 235 0 0 0 0 0\n"
"RenderEvent 60 235 0 0 0 0 0\n"
"RenderEvent 60 235 0 0 0 0 0\n"
"MouseMoveEvent 61 237 0 0 0 0 0\n"
"RenderEvent 61 237 0 0 0 0 0\n"
"RenderEvent 61 237 0 0 0 0 0\n"
"RenderEvent 61 237 0 0 0 0 0\n"
"RenderEvent 61 237 0 0 0 0 0\n"
"MouseMoveEvent 61 239 0 0 0 0 0\n"
"RenderEvent 61 239 0 0 0 0 0\n"
"RenderEvent 61 239 0 0 0 0 0\n"
"RenderEvent 61 239 0 0 0 0 0\n"
"RenderEvent 61 239 0 0 0 0 0\n"
"MouseMoveEvent 64 244 0 0 0 0 0\n"
"RenderEvent 64 244 0 0 0 0 0\n"
"RenderEvent 64 244 0 0 0 0 0\n"
"RenderEvent 64 244 0 0 0 0 0\n"
"RenderEvent 64 244 0 0 0 0 0\n"
"MouseMoveEvent 66 250 0 0 0 0 0\n"
"RenderEvent 66 250 0 0 0 0 0\n"
"RenderEvent 66 250 0 0 0 0 0\n"
"RenderEvent 66 250 0 0 0 0 0\n"
"RenderEvent 66 250 0 0 0 0 0\n"
"MouseMoveEvent 66 252 0 0 0 0 0\n"
"RenderEvent 66 252 0 0 0 0 0\n"
"RenderEvent 66 252 0 0 0 0 0\n"
"RenderEvent 66 252 0 0 0 0 0\n"
"RenderEvent 66 252 0 0 0 0 0\n"
"MouseMoveEvent 66 254 0 0 0 0 0\n"
"RenderEvent 66 254 0 0 0 0 0\n"
"RenderEvent 66 254 0 0 0 0 0\n"
"RenderEvent 66 254 0 0 0 0 0\n"
"RenderEvent 66 254 0 0 0 0 0\n"
"MouseMoveEvent 66 255 0 0 0 0 0\n"
"RenderEvent 66 255 0 0 0 0 0\n"
"RenderEvent 66 255 0 0 0 0 0\n"
"RenderEvent 66 255 0 0 0 0 0\n"
"RenderEvent 66 255 0 0 0 0 0\n"
"MouseMoveEvent 66 254 0 0 0 0 0\n"
"RenderEvent 66 254 0 0 0 0 0\n"
"RenderEvent 66 254 0 0 0 0 0\n"
"RenderEvent 66 254 0 0 0 0 0\n"
"RenderEvent 66 254 0 0 0 0 0\n"
"MouseMoveEvent 65 251 0 0 0 0 0\n"
"RenderEvent 65 251 0 0 0 0 0\n"
"RenderEvent 65 251 0 0 0 0 0\n"
"RenderEvent 65 251 0 0 0 0 0\n"
"RenderEvent 65 251 0 0 0 0 0\n"
"MouseMoveEvent 64 244 0 0 0 0 0\n"
"RenderEvent 64 244 0 0 0 0 0\n"
"RenderEvent 64 244 0 0 0 0 0\n"
"RenderEvent 64 244 0 0 0 0 0\n"
"RenderEvent 64 244 0 0 0 0 0\n"
"MouseMoveEvent 64 242 0 0 0 0 0\n"
"RenderEvent 64 242 0 0 0 0 0\n"
"RenderEvent 64 242 0 0 0 0 0\n"
"RenderEvent 64 242 0 0 0 0 0\n"
"RenderEvent 64 242 0 0 0 0 0\n"
"MouseMoveEvent 64 240 0 0 0 0 0\n"
"RenderEvent 64 240 0 0 0 0 0\n"
"RenderEvent 64 240 0 0 0 0 0\n"
"RenderEvent 64 240 0 0 0 0 0\n"
"RenderEvent 64 240 0 0 0 0 0\n"
"MouseMoveEvent 64 239 0 0 0 0 0\n"
"RenderEvent 64 239 0 0 0 0 0\n"
"RenderEvent 64 239 0 0 0 0 0\n"
"RenderEvent 64 239 0 0 0 0 0\n"
"RenderEvent 64 239 0 0 0 0 0\n"
"MouseMoveEvent 63 238 0 0 0 0 0\n"
"RenderEvent 63 238 0 0 0 0 0\n"
"RenderEvent 63 238 0 0 0 0 0\n"
"RenderEvent 63 238 0 0 0 0 0\n"
"RenderEvent 63 238 0 0 0 0 0\n"
"MouseMoveEvent 63 237 0 0 0 0 0\n"
"RenderEvent 63 237 0 0 0 0 0\n"
"RenderEvent 63 237 0 0 0 0 0\n"
"RenderEvent 63 237 0 0 0 0 0\n"
"RenderEvent 63 237 0 0 0 0 0\n"
"MouseMoveEvent 63 235 0 0 0 0 0\n"
"RenderEvent 63 235 0 0 0 0 0\n"
"RenderEvent 63 235 0 0 0 0 0\n"
"RenderEvent 63 235 0 0 0 0 0\n"
"RenderEvent 63 235 0 0 0 0 0\n"
"MouseMoveEvent 62 233 0 0 0 0 0\n"
"RenderEvent 62 233 0 0 0 0 0\n"
"RenderEvent 62 233 0 0 0 0 0\n"
"RenderEvent 62 233 0 0 0 0 0\n"
"RenderEvent 62 233 0 0 0 0 0\n"
"MouseMoveEvent 62 231 0 0 0 0 0\n"
"RenderEvent 62 231 0 0 0 0 0\n"
"RenderEvent 62 231 0 0 0 0 0\n"
"RenderEvent 62 231 0 0 0 0 0\n"
"RenderEvent 62 231 0 0 0 0 0\n"
"MouseMoveEvent 61 227 0 0 0 0 0\n"
"RenderEvent 61 227 0 0 0 0 0\n"
"RenderEvent 61 227 0 0 0 0 0\n"
"RenderEvent 61 227 0 0 0 0 0\n"
"RenderEvent 61 227 0 0 0 0 0\n"
"MouseMoveEvent 60 226 0 0 0 0 0\n"
"RenderEvent 60 226 0 0 0 0 0\n"
"RenderEvent 60 226 0 0 0 0 0\n"
"RenderEvent 60 226 0 0 0 0 0\n"
"RenderEvent 60 226 0 0 0 0 0\n"
"MouseMoveEvent 59 224 0 0 0 0 0\n"
"RenderEvent 59 224 0 0 0 0 0\n"
"RenderEvent 59 224 0 0 0 0 0\n"
"RenderEvent 59 224 0 0 0 0 0\n"
"RenderEvent 59 224 0 0 0 0 0\n"
"MouseMoveEvent 59 222 0 0 0 0 0\n"
"RenderEvent 59 222 0 0 0 0 0\n"
"RenderEvent 59 222 0 0 0 0 0\n"
"RenderEvent 59 222 0 0 0 0 0\n"
"RenderEvent 59 222 0 0 0 0 0\n"
"MouseMoveEvent 58 218 0 0 0 0 0\n"
"RenderEvent 58 218 0 0 0 0 0\n"
"RenderEvent 58 218 0 0 0 0 0\n"
"RenderEvent 58 218 0 0 0 0 0\n"
"RenderEvent 58 218 0 0 0 0 0\n"
"MouseMoveEvent 57 216 0 0 0 0 0\n"
"RenderEvent 57 216 0 0 0 0 0\n"
"RenderEvent 57 216 0 0 0 0 0\n"
"RenderEvent 57 216 0 0 0 0 0\n"
"RenderEvent 57 216 0 0 0 0 0\n"
"MouseMoveEvent 56 214 0 0 0 0 0\n"
"RenderEvent 56 214 0 0 0 0 0\n"
"RenderEvent 56 214 0 0 0 0 0\n"
"RenderEvent 56 214 0 0 0 0 0\n"
"RenderEvent 56 214 0 0 0 0 0\n"
"MouseMoveEvent 55 213 0 0 0 0 0\n"
"RenderEvent 55 213 0 0 0 0 0\n"
"RenderEvent 55 213 0 0 0 0 0\n"
"RenderEvent 55 213 0 0 0 0 0\n"
"RenderEvent 55 213 0 0 0 0 0\n"
"MouseMoveEvent 55 212 0 0 0 0 0\n"
"RenderEvent 55 212 0 0 0 0 0\n"
"RenderEvent 55 212 0 0 0 0 0\n"
"RenderEvent 55 212 0 0 0 0 0\n"
"RenderEvent 55 212 0 0 0 0 0\n"
"MouseMoveEvent 55 211 0 0 0 0 0\n"
"RenderEvent 55 211 0 0 0 0 0\n"
"RenderEvent 55 211 0 0 0 0 0\n"
"RenderEvent 55 211 0 0 0 0 0\n"
"RenderEvent 55 211 0 0 0 0 0\n"
"MouseMoveEvent 55 210 0 0 0 0 0\n"
"RenderEvent 55 210 0 0 0 0 0\n"
"RenderEvent 55 210 0 0 0 0 0\n"
"RenderEvent 55 210 0 0 0 0 0\n"
"RenderEvent 55 210 0 0 0 0 0\n"
"MouseMoveEvent 54 210 0 0 0 0 0\n"
"RenderEvent 54 210 0 0 0 0 0\n"
"RenderEvent 54 210 0 0 0 0 0\n"
"RenderEvent 54 210 0 0 0 0 0\n"
"RenderEvent 54 210 0 0 0 0 0\n"
"MouseMoveEvent 54 209 0 0 0 0 0\n"
"RenderEvent 54 209 0 0 0 0 0\n"
"RenderEvent 54 209 0 0 0 0 0\n"
"RenderEvent 54 209 0 0 0 0 0\n"
"RenderEvent 54 209 0 0 0 0 0\n"
"MouseMoveEvent 54 210 0 0 0 0 0\n"
"RenderEvent 54 210 0 0 0 0 0\n"
"RenderEvent 54 210 0 0 0 0 0\n"
"RenderEvent 54 210 0 0 0 0 0\n"
"RenderEvent 54 210 0 0 0 0 0\n"
"MouseMoveEvent 55 211 0 0 0 0 0\n"
"RenderEvent 55 211 0 0 0 0 0\n"
"RenderEvent 55 211 0 0 0 0 0\n"
"RenderEvent 55 211 0 0 0 0 0\n"
"RenderEvent 55 211 0 0 0 0 0\n"
"MouseMoveEvent 56 212 0 0 0 0 0\n"
"RenderEvent 56 212 0 0 0 0 0\n"
"RenderEvent 56 212 0 0 0 0 0\n"
"RenderEvent 56 212 0 0 0 0 0\n"
"RenderEvent 56 212 0 0 0 0 0\n"
"MouseMoveEvent 57 213 0 0 0 0 0\n"
"RenderEvent 57 213 0 0 0 0 0\n"
"RenderEvent 57 213 0 0 0 0 0\n"
"RenderEvent 57 213 0 0 0 0 0\n"
"RenderEvent 57 213 0 0 0 0 0\n"
"MouseMoveEvent 58 215 0 0 0 0 0\n"
"RenderEvent 58 215 0 0 0 0 0\n"
"RenderEvent 58 215 0 0 0 0 0\n"
"RenderEvent 58 215 0 0 0 0 0\n"
"RenderEvent 58 215 0 0 0 0 0\n"
"MouseMoveEvent 58 216 0 0 0 0 0\n"
"RenderEvent 58 216 0 0 0 0 0\n"
"RenderEvent 58 216 0 0 0 0 0\n"
"RenderEvent 58 216 0 0 0 0 0\n"
"RenderEvent 58 216 0 0 0 0 0\n"
"MouseMoveEvent 59 218 0 0 0 0 0\n"
"RenderEvent 59 218 0 0 0 0 0\n"
"RenderEvent 59 218 0 0 0 0 0\n"
"RenderEvent 59 218 0 0 0 0 0\n"
"RenderEvent 59 218 0 0 0 0 0\n"
"MouseMoveEvent 59 220 0 0 0 0 0\n"
"RenderEvent 59 220 0 0 0 0 0\n"
"RenderEvent 59 220 0 0 0 0 0\n"
"RenderEvent 59 220 0 0 0 0 0\n"
"RenderEvent 59 220 0 0 0 0 0\n"
"MouseMoveEvent 60 221 0 0 0 0 0\n"
"RenderEvent 60 221 0 0 0 0 0\n"
"RenderEvent 60 221 0 0 0 0 0\n"
"RenderEvent 60 221 0 0 0 0 0\n"
"RenderEvent 60 221 0 0 0 0 0\n"
"MouseMoveEvent 61 222 0 0 0 0 0\n"
"RenderEvent 61 222 0 0 0 0 0\n"
"RenderEvent 61 222 0 0 0 0 0\n"
"RenderEvent 61 222 0 0 0 0 0\n"
"RenderEvent 61 222 0 0 0 0 0\n"
"MouseMoveEvent 61 223 0 0 0 0 0\n"
"RenderEvent 61 223 0 0 0 0 0\n"
"RenderEvent 61 223 0 0 0 0 0\n"
"RenderEvent 61 223 0 0 0 0 0\n"
"RenderEvent 61 223 0 0 0 0 0\n"
"MouseMoveEvent 62 223 0 0 0 0 0\n"
"RenderEvent 62 223 0 0 0 0 0\n"
"RenderEvent 62 223 0 0 0 0 0\n"
"RenderEvent 62 223 0 0 0 0 0\n"
"RenderEvent 62 223 0 0 0 0 0\n"
"MouseMoveEvent 62 224 0 0 0 0 0\n"
"RenderEvent 62 224 0 0 0 0 0\n"
"RenderEvent 62 224 0 0 0 0 0\n"
"RenderEvent 62 224 0 0 0 0 0\n"
"RenderEvent 62 224 0 0 0 0 0\n"
"MouseMoveEvent 63 225 0 0 0 0 0\n"
"RenderEvent 63 225 0 0 0 0 0\n"
"RenderEvent 63 225 0 0 0 0 0\n"
"RenderEvent 63 225 0 0 0 0 0\n"
"RenderEvent 63 225 0 0 0 0 0\n"
"MouseMoveEvent 64 226 0 0 0 0 0\n"
"RenderEvent 64 226 0 0 0 0 0\n"
"RenderEvent 64 226 0 0 0 0 0\n"
"RenderEvent 64 226 0 0 0 0 0\n"
"RenderEvent 64 226 0 0 0 0 0\n"
"MouseMoveEvent 64 226 0 0 0 0 0\n"
"RenderEvent 64 226 0 0 0 0 0\n"
"RenderEvent 64 226 0 0 0 0 0\n"
"RenderEvent 64 226 0 0 0 0 0\n"
"RenderEvent 64 226 0 0 0 0 0\n"
"MouseMoveEvent 64 228 0 0 0 0 0\n"
"RenderEvent 64 228 0 0 0 0 0\n"
"RenderEvent 64 228 0 0 0 0 0\n"
"RenderEvent 64 228 0 0 0 0 0\n"
"RenderEvent 64 228 0 0 0 0 0\n"
"MouseMoveEvent 64 230 0 0 0 0 0\n"
"RenderEvent 64 230 0 0 0 0 0\n"
"RenderEvent 64 230 0 0 0 0 0\n"
"RenderEvent 64 230 0 0 0 0 0\n"
"RenderEvent 64 230 0 0 0 0 0\n"
"MouseMoveEvent 65 232 0 0 0 0 0\n"
"RenderEvent 65 232 0 0 0 0 0\n"
"RenderEvent 65 232 0 0 0 0 0\n"
"RenderEvent 65 232 0 0 0 0 0\n"
"RenderEvent 65 232 0 0 0 0 0\n"
"MouseMoveEvent 65 233 0 0 0 0 0\n"
"RenderEvent 65 233 0 0 0 0 0\n"
"RenderEvent 65 233 0 0 0 0 0\n"
"RenderEvent 65 233 0 0 0 0 0\n"
"RenderEvent 65 233 0 0 0 0 0\n"
"MouseMoveEvent 65 234 0 0 0 0 0\n"
"RenderEvent 65 234 0 0 0 0 0\n"
"RenderEvent 65 234 0 0 0 0 0\n"
"RenderEvent 65 234 0 0 0 0 0\n"
"RenderEvent 65 234 0 0 0 0 0\n"
"MouseMoveEvent 65 236 0 0 0 0 0\n"
"RenderEvent 65 236 0 0 0 0 0\n"
"RenderEvent 65 236 0 0 0 0 0\n"
"RenderEvent 65 236 0 0 0 0 0\n"
"RenderEvent 65 236 0 0 0 0 0\n"
"MouseMoveEvent 65 237 0 0 0 0 0\n"
"RenderEvent 65 237 0 0 0 0 0\n"
"RenderEvent 65 237 0 0 0 0 0\n"
"RenderEvent 65 237 0 0 0 0 0\n"
"RenderEvent 65 237 0 0 0 0 0\n"
"MouseMoveEvent 66 238 0 0 0 0 0\n"
"RenderEvent 66 238 0 0 0 0 0\n"
"RenderEvent 66 238 0 0 0 0 0\n"
"RenderEvent 66 238 0 0 0 0 0\n"
"RenderEvent 66 238 0 0 0 0 0\n"
"MouseMoveEvent 66 239 0 0 0 0 0\n"
"RenderEvent 66 239 0 0 0 0 0\n"
"RenderEvent 66 239 0 0 0 0 0\n"
"RenderEvent 66 239 0 0 0 0 0\n"
"RenderEvent 66 239 0 0 0 0 0\n"
"RightButtonReleaseEvent 66 239 0 0 0 0 0\n"
"EndInteractionEvent 66 239 0 0 0 0 0\n"
"RenderEvent 66 239 0 0 0 0 0\n"
"RenderEvent 66 239 0 0 0 0 0\n"
"MouseMoveEvent 66 239 0 0 0 0 0\n"
"RenderEvent 66 239 0 0 0 0 0\n"
"RenderEvent 66 239 0 0 0 0 0\n"
"MouseMoveEvent 67 240 0 0 0 0 0\n"
"RenderEvent 67 240 0 0 0 0 0\n"
"RenderEvent 67 240 0 0 0 0 0\n"
"MiddleButtonPressEvent 67 240 0 0 0 0 0\n"
"StartInteractionEvent 67 240 0 0 0 0 0\n"
"MouseMoveEvent 68 240 0 0 0 0 0\n"
"RenderEvent 68 240 0 0 0 0 0\n"
"RenderEvent 68 240 0 0 0 0 0\n"
"RenderEvent 68 240 0 0 0 0 0\n"
"RenderEvent 68 240 0 0 0 0 0\n"
"MouseMoveEvent 70 240 0 0 0 0 0\n"
"RenderEvent 70 240 0 0 0 0 0\n"
"RenderEvent 70 240 0 0 0 0 0\n"
"RenderEvent 70 240 0 0 0 0 0\n"
"RenderEvent 70 240 0 0 0 0 0\n"
"MouseMoveEvent 74 237 0 0 0 0 0\n"
"RenderEvent 74 237 0 0 0 0 0\n"
"RenderEvent 74 237 0 0 0 0 0\n"
"RenderEvent 74 237 0 0 0 0 0\n"
"RenderEvent 74 237 0 0 0 0 0\n"
"MouseMoveEvent 80 233 0 0 0 0 0\n"
"RenderEvent 80 233 0 0 0 0 0\n"
"RenderEvent 80 233 0 0 0 0 0\n"
"RenderEvent 80 233 0 0 0 0 0\n"
"RenderEvent 80 233 0 0 0 0 0\n"
"MouseMoveEvent 83 231 0 0 0 0 0\n"
"RenderEvent 83 231 0 0 0 0 0\n"
"RenderEvent 83 231 0 0 0 0 0\n"
"RenderEvent 83 231 0 0 0 0 0\n"
"RenderEvent 83 231 0 0 0 0 0\n"
"MouseMoveEvent 85 231 0 0 0 0 0\n"
"RenderEvent 85 231 0 0 0 0 0\n"
"RenderEvent 85 231 0 0 0 0 0\n"
"RenderEvent 85 231 0 0 0 0 0\n"
"RenderEvent 85 231 0 0 0 0 0\n"
"MouseMoveEvent 86 230 0 0 0 0 0\n"
"RenderEvent 86 230 0 0 0 0 0\n"
"RenderEvent 86 230 0 0 0 0 0\n"
"RenderEvent 86 230 0 0 0 0 0\n"
"RenderEvent 86 230 0 0 0 0 0\n"
"MouseMoveEvent 90 228 0 0 0 0 0\n"
"RenderEvent 90 228 0 0 0 0 0\n"
"RenderEvent 90 228 0 0 0 0 0\n"
"RenderEvent 90 228 0 0 0 0 0\n"
"RenderEvent 90 228 0 0 0 0 0\n"
"MouseMoveEvent 93 225 0 0 0 0 0\n"
"RenderEvent 93 225 0 0 0 0 0\n"
"RenderEvent 93 225 0 0 0 0 0\n"
"RenderEvent 93 225 0 0 0 0 0\n"
"RenderEvent 93 225 0 0 0 0 0\n"
"MouseMoveEvent 94 224 0 0 0 0 0\n"
"RenderEvent 94 224 0 0 0 0 0\n"
"RenderEvent 94 224 0 0 0 0 0\n"
"RenderEvent 94 224 0 0 0 0 0\n"
"RenderEvent 94 224 0 0 0 0 0\n"
"MouseMoveEvent 94 222 0 0 0 0 0\n"
"RenderEvent 94 222 0 0 0 0 0\n"
"RenderEvent 94 222 0 0 0 0 0\n"
"RenderEvent 94 222 0 0 0 0 0\n"
"RenderEvent 94 222 0 0 0 0 0\n"
"MouseMoveEvent 94 220 0 0 0 0 0\n"
"RenderEvent 94 220 0 0 0 0 0\n"
"RenderEvent 94 220 0 0 0 0 0\n"
"RenderEvent 94 220 0 0 0 0 0\n"
"RenderEvent 94 220 0 0 0 0 0\n"
"MouseMoveEvent 94 218 0 0 0 0 0\n"
"RenderEvent 94 218 0 0 0 0 0\n"
"RenderEvent 94 218 0 0 0 0 0\n"
"RenderEvent 94 218 0 0 0 0 0\n"
"RenderEvent 94 218 0 0 0 0 0\n"
"MouseMoveEvent 93 215 0 0 0 0 0\n"
"RenderEvent 93 215 0 0 0 0 0\n"
"RenderEvent 93 215 0 0 0 0 0\n"
"RenderEvent 93 215 0 0 0 0 0\n"
"RenderEvent 93 215 0 0 0 0 0\n"
"MouseMoveEvent 91 212 0 0 0 0 0\n"
"RenderEvent 91 212 0 0 0 0 0\n"
"RenderEvent 91 212 0 0 0 0 0\n"
"RenderEvent 91 212 0 0 0 0 0\n"
"RenderEvent 91 212 0 0 0 0 0\n"
"MouseMoveEvent 90 211 0 0 0 0 0\n"
"RenderEvent 90 211 0 0 0 0 0\n"
"RenderEvent 90 211 0 0 0 0 0\n"
"RenderEvent 90 211 0 0 0 0 0\n"
"RenderEvent 90 211 0 0 0 0 0\n"
"MouseMoveEvent 89 210 0 0 0 0 0\n"
"RenderEvent 89 210 0 0 0 0 0\n"
"RenderEvent 89 210 0 0 0 0 0\n"
"RenderEvent 89 210 0 0 0 0 0\n"
"RenderEvent 89 210 0 0 0 0 0\n"
"MiddleButtonReleaseEvent 89 210 0 0 0 0 0\n"
"EndInteractionEvent 89 210 0 0 0 0 0\n"
"RenderEvent 89 210 0 0 0 0 0\n"
"RenderEvent 89 210 0 0 0 0 0\n"
"MouseMoveEvent 89 210 0 0 0 0 0\n"
"RenderEvent 89 210 0 0 0 0 0\n"
"RenderEvent 89 210 0 0 0 0 0\n"
"MouseMoveEvent 90 210 0 0 0 0 0\n"
"RenderEvent 90 210 0 0 0 0 0\n"
"RenderEvent 90 210 0 0 0 0 0\n"
"MouseMoveEvent 91 210 0 0 0 0 0\n"
"RenderEvent 91 210 0 0 0 0 0\n"
"RenderEvent 91 210 0 0 0 0 0\n"
"MouseMoveEvent 92 210 0 0 0 0 0\n"
"RenderEvent 92 210 0 0 0 0 0\n"
"RenderEvent 92 210 0 0 0 0 0\n"
"MouseMoveEvent 93 210 0 0 0 0 0\n"
"RenderEvent 93 210 0 0 0 0 0\n"
"RenderEvent 93 210 0 0 0 0 0\n"
"MouseMoveEvent 106 204 0 0 0 0 0\n"
"RenderEvent 106 204 0 0 0 0 0\n"
"RenderEvent 106 204 0 0 0 0 0\n"
"MouseMoveEvent 116 200 0 0 0 0 0\n"
"RenderEvent 116 200 0 0 0 0 0\n"
"RenderEvent 116 200 0 0 0 0 0\n"
"MouseMoveEvent 125 196 0 0 0 0 0\n"
"RenderEvent 125 196 0 0 0 0 0\n"
"RenderEvent 125 196 0 0 0 0 0\n"
"MouseMoveEvent 132 192 0 0 0 0 0\n"
"RenderEvent 132 192 0 0 0 0 0\n"
"RenderEvent 132 192 0 0 0 0 0\n"
"MouseMoveEvent 137 189 0 0 0 0 0\n"
"RenderEvent 137 189 0 0 0 0 0\n"
"RenderEvent 137 189 0 0 0 0 0\n"
"MouseMoveEvent 142 185 0 0 0 0 0\n"
"RenderEvent 142 185 0 0 0 0 0\n"
"RenderEvent 142 185 0 0 0 0 0\n"
"MouseMoveEvent 144 181 0 0 0 0 0\n"
"RenderEvent 144 181 0 0 0 0 0\n"
"RenderEvent 144 181 0 0 0 0 0\n"
"MouseMoveEvent 146 178 0 0 0 0 0\n"
"RenderEvent 146 178 0 0 0 0 0\n"
"RenderEvent 146 178 0 0 0 0 0\n"
"MouseMoveEvent 148 175 0 0 0 0 0\n"
"RenderEvent 148 175 0 0 0 0 0\n"
"RenderEvent 148 175 0 0 0 0 0\n"
"MouseMoveEvent 150 173 0 0 0 0 0\n"
"RenderEvent 150 173 0 0 0 0 0\n"
"RenderEvent 150 173 0 0 0 0 0\n"
"MouseMoveEvent 150 172 0 0 0 0 0\n"
"RenderEvent 150 172 0 0 0 0 0\n"
"RenderEvent 150 172 0 0 0 0 0\n"
"MouseMoveEvent 151 171 0 0 0 0 0\n"
"RenderEvent 151 171 0 0 0 0 0\n"
"RenderEvent 151 171 0 0 0 0 0\n"
"MouseMoveEvent 152 171 0 0 0 0 0\n"
"RenderEvent 152 171 0 0 0 0 0\n"
"RenderEvent 152 171 0 0 0 0 0\n"
"MouseMoveEvent 153 170 0 0 0 0 0\n"
"RenderEvent 153 170 0 0 0 0 0\n"
"RenderEvent 153 170 0 0 0 0 0\n"
"LeftButtonPressEvent 153 170 0 0 0 0 0\n"
"StartInteractionEvent 153 170 0 0 0 0 0\n"
"MouseMoveEvent 153 170 0 0 0 0 0\n"
"RenderEvent 153 170 0 0 0 0 0\n"
"RenderEvent 153 170 0 0 0 0 0\n"
"LeftButtonReleaseEvent 153 170 0 0 0 0 0\n"
"RenderEvent 153 170 0 0 0 0 0\n"
"RenderEvent 153 170 0 0 0 0 0\n"
"EndInteractionEvent 153 170 0 0 0 0 0\n"
"RenderEvent 153 170 0 0 0 0 0\n"
"RenderEvent 153 170 0 0 0 0 0\n"
"MouseMoveEvent 153 170 0 0 0 0 0\n"
"RenderEvent 153 170 0 0 0 0 0\n"
"RenderEvent 153 170 0 0 0 0 0\n"
"MouseMoveEvent 155 171 0 0 0 0 0\n"
"RenderEvent 155 171 0 0 0 0 0\n"
"RenderEvent 155 171 0 0 0 0 0\n"
"MouseMoveEvent 156 172 0 0 0 0 0\n"
"RenderEvent 156 172 0 0 0 0 0\n"
"RenderEvent 156 172 0 0 0 0 0\n"
"MouseMoveEvent 157 172 0 0 0 0 0\n"
"RenderEvent 157 172 0 0 0 0 0\n"
"RenderEvent 157 172 0 0 0 0 0\n"
"MouseMoveEvent 159 173 0 0 0 0 0\n"
"RenderEvent 159 173 0 0 0 0 0\n"
"RenderEvent 159 173 0 0 0 0 0\n"
"MouseMoveEvent 161 174 0 0 0 0 0\n"
"RenderEvent 161 174 0 0 0 0 0\n"
"RenderEvent 161 174 0 0 0 0 0\n"
"MouseMoveEvent 163 175 0 0 0 0 0\n"
"RenderEvent 163 175 0 0 0 0 0\n"
"RenderEvent 163 175 0 0 0 0 0\n"
"MouseMoveEvent 166 177 0 0 0 0 0\n"
"RenderEvent 166 177 0 0 0 0 0\n"
"RenderEvent 166 177 0 0 0 0 0\n"
"MouseMoveEvent 167 177 0 0 0 0 0\n"
"RenderEvent 167 177 0 0 0 0 0\n"
"RenderEvent 167 177 0 0 0 0 0\n"
"MouseMoveEvent 168 178 0 0 0 0 0\n"
"RenderEvent 168 178 0 0 0 0 0\n"
"RenderEvent 168 178 0 0 0 0 0\n"
"MouseMoveEvent 169 180 0 0 0 0 0\n"
"RenderEvent 169 180 0 0 0 0 0\n"
"RenderEvent 169 180 0 0 0 0 0\n"
"MouseMoveEvent 170 181 0 0 0 0 0\n"
"RenderEvent 170 181 0 0 0 0 0\n"
"RenderEvent 170 181 0 0 0 0 0\n"
"MouseMoveEvent 171 183 0 0 0 0 0\n"
"RenderEvent 171 183 0 0 0 0 0\n"
"RenderEvent 171 183 0 0 0 0 0\n"
"MouseMoveEvent 174 185 0 0 0 0 0\n"
"RenderEvent 174 185 0 0 0 0 0\n"
"RenderEvent 174 185 0 0 0 0 0\n"
"MouseMoveEvent 175 185 0 0 0 0 0\n"
"RenderEvent 175 185 0 0 0 0 0\n"
"RenderEvent 175 185 0 0 0 0 0\n"
"MouseMoveEvent 178 188 0 0 0 0 0\n"
"RenderEvent 178 188 0 0 0 0 0\n"
"RenderEvent 178 188 0 0 0 0 0\n"
"MouseMoveEvent 181 190 0 0 0 0 0\n"
"RenderEvent 181 190 0 0 0 0 0\n"
"RenderEvent 181 190 0 0 0 0 0\n"
"MouseMoveEvent 183 191 0 0 0 0 0\n"
"RenderEvent 183 191 0 0 0 0 0\n"
"RenderEvent 183 191 0 0 0 0 0\n"
"MouseMoveEvent 186 193 0 0 0 0 0\n"
"RenderEvent 186 193 0 0 0 0 0\n"
"RenderEvent 186 193 0 0 0 0 0\n"
"MouseMoveEvent 192 195 0 0 0 0 0\n"
"RenderEvent 192 195 0 0 0 0 0\n"
"RenderEvent 192 195 0 0 0 0 0\n"
"MouseMoveEvent 196 196 0 0 0 0 0\n"
"RenderEvent 196 196 0 0 0 0 0\n"
"RenderEvent 196 196 0 0 0 0 0\n"
"MouseMoveEvent 202 199 0 0 0 0 0\n"
"RenderEvent 202 199 0 0 0 0 0\n"
"RenderEvent 202 199 0 0 0 0 0\n"
"MouseMoveEvent 204 199 0 0 0 0 0\n"
"RenderEvent 204 199 0 0 0 0 0\n"
"RenderEvent 204 199 0 0 0 0 0\n"
"MouseMoveEvent 208 201 0 0 0 0 0\n"
"RenderEvent 208 201 0 0 0 0 0\n"
"RenderEvent 208 201 0 0 0 0 0\n"
"MouseMoveEvent 210 202 0 0 0 0 0\n"
"RenderEvent 210 202 0 0 0 0 0\n"
"RenderEvent 210 202 0 0 0 0 0\n"
"MouseMoveEvent 211 202 0 0 0 0 0\n"
"RenderEvent 211 202 0 0 0 0 0\n"
"RenderEvent 211 202 0 0 0 0 0\n"
"MouseMoveEvent 212 202 0 0 0 0 0\n"
"RenderEvent 212 202 0 0 0 0 0\n"
"RenderEvent 212 202 0 0 0 0 0\n"
"LeftButtonPressEvent 212 202 0 0 0 0 0\n"
"StartInteractionEvent 212 202 0 0 0 0 0\n"
"LeftButtonReleaseEvent 212 202 0 0 0 0 0\n"
"RenderEvent 212 202 0 0 0 0 0\n"
"RenderEvent 212 202 0 0 0 0 0\n"
"EndInteractionEvent 212 202 0 0 0 0 0\n"
"RenderEvent 212 202 0 0 0 0 0\n"
"RenderEvent 212 202 0 0 0 0 0\n"
"MouseMoveEvent 212 202 0 0 0 0 0\n"
"RenderEvent 212 202 0 0 0 0 0\n"
"RenderEvent 212 202 0 0 0 0 0\n"
"MouseMoveEvent 213 201 0 0 0 0 0\n"
"RenderEvent 213 201 0 0 0 0 0\n"
"RenderEvent 213 201 0 0 0 0 0\n"
"MouseMoveEvent 217 195 0 0 0 0 0\n"
"RenderEvent 217 195 0 0 0 0 0\n"
"RenderEvent 217 195 0 0 0 0 0\n"
"MouseMoveEvent 220 192 0 0 0 0 0\n"
"RenderEvent 220 192 0 0 0 0 0\n"
"RenderEvent 220 192 0 0 0 0 0\n"
"MouseMoveEvent 223 187 0 0 0 0 0\n"
"RenderEvent 223 187 0 0 0 0 0\n"
"RenderEvent 223 187 0 0 0 0 0\n"
"MouseMoveEvent 226 183 0 0 0 0 0\n"
"RenderEvent 226 183 0 0 0 0 0\n"
"RenderEvent 226 183 0 0 0 0 0\n"
"MouseMoveEvent 229 179 0 0 0 0 0\n"
"RenderEvent 229 179 0 0 0 0 0\n"
"RenderEvent 229 179 0 0 0 0 0\n"
"MouseMoveEvent 230 178 0 0 0 0 0\n"
"RenderEvent 230 178 0 0 0 0 0\n"
"RenderEvent 230 178 0 0 0 0 0\n"
"MouseMoveEvent 230 177 0 0 0 0 0\n"
"RenderEvent 230 177 0 0 0 0 0\n"
"RenderEvent 230 177 0 0 0 0 0\n"
"MouseMoveEvent 231 177 0 0 0 0 0\n"
"RenderEvent 231 177 0 0 0 0 0\n"
"RenderEvent 231 177 0 0 0 0 0\n"
"MouseMoveEvent 232 176 0 0 0 0 0\n"
"RenderEvent 232 176 0 0 0 0 0\n"
"RenderEvent 232 176 0 0 0 0 0\n"
"MouseMoveEvent 232 175 0 0 0 0 0\n"
"RenderEvent 232 175 0 0 0 0 0\n"
"RenderEvent 232 175 0 0 0 0 0\n"
"MouseMoveEvent 232 174 0 0 0 0 0\n"
"RenderEvent 232 174 0 0 0 0 0\n"
"RenderEvent 232 174 0 0 0 0 0\n"
"MouseMoveEvent 233 173 0 0 0 0 0\n"
"RenderEvent 233 173 0 0 0 0 0\n"
"RenderEvent 233 173 0 0 0 0 0\n"
"MouseMoveEvent 233 172 0 0 0 0 0\n"
"RenderEvent 233 172 0 0 0 0 0\n"
"RenderEvent 233 172 0 0 0 0 0\n"
"MouseMoveEvent 233 171 0 0 0 0 0\n"
"RenderEvent 233 171 0 0 0 0 0\n"
"RenderEvent 233 171 0 0 0 0 0\n"
"LeftButtonPressEvent 233 171 0 0 0 0 0\n"
"StartInteractionEvent 233 171 0 0 0 0 0\n"
"LeftButtonReleaseEvent 233 171 0 0 0 0 0\n"
"RenderEvent 233 171 0 0 0 0 0\n"
"RenderEvent 233 171 0 0 0 0 0\n"
"EndInteractionEvent 233 171 0 0 0 0 0\n"
"RenderEvent 233 171 0 0 0 0 0\n"
"RenderEvent 233 171 0 0 0 0 0\n"
"MouseMoveEvent 233 171 0 0 0 0 0\n"
"RenderEvent 233 171 0 0 0 0 0\n"
"RenderEvent 233 171 0 0 0 0 0\n"
"MouseMoveEvent 234 173 0 0 0 0 0\n"
"RenderEvent 234 173 0 0 0 0 0\n"
"RenderEvent 234 173 0 0 0 0 0\n"
"MouseMoveEvent 235 177 0 0 0 0 0\n"
"RenderEvent 235 177 0 0 0 0 0\n"
"RenderEvent 235 177 0 0 0 0 0\n"
"MouseMoveEvent 238 187 0 0 0 0 0\n"
"RenderEvent 238 187 0 0 0 0 0\n"
"RenderEvent 238 187 0 0 0 0 0\n"
"MouseMoveEvent 242 194 0 0 0 0 0\n"
"RenderEvent 242 194 0 0 0 0 0\n"
"RenderEvent 242 194 0 0 0 0 0\n"
"MouseMoveEvent 243 202 0 0 0 0 0\n"
"RenderEvent 243 202 0 0 0 0 0\n"
"RenderEvent 243 202 0 0 0 0 0\n"
"MouseMoveEvent 248 220 0 0 0 0 0\n"
"RenderEvent 248 220 0 0 0 0 0\n"
"RenderEvent 248 220 0 0 0 0 0\n"
"MouseMoveEvent 251 234 0 0 0 0 0\n"
"RenderEvent 251 234 0 0 0 0 0\n"
"RenderEvent 251 234 0 0 0 0 0\n"
"MouseMoveEvent 252 244 0 0 0 0 0\n"
"RenderEvent 252 244 0 0 0 0 0\n"
"RenderEvent 252 244 0 0 0 0 0\n"
"MouseMoveEvent 252 247 0 0 0 0 0\n"
"RenderEvent 252 247 0 0 0 0 0\n"
"RenderEvent 252 247 0 0 0 0 0\n"
"MouseMoveEvent 253 254 0 0 0 0 0\n"
"RenderEvent 253 254 0 0 0 0 0\n"
"RenderEvent 253 254 0 0 0 0 0\n"
"MouseMoveEvent 254 259 0 0 0 0 0\n"
"RenderEvent 254 259 0 0 0 0 0\n"
"RenderEvent 254 259 0 0 0 0 0\n"
"MouseMoveEvent 255 266 0 0 0 0 0\n"
"RenderEvent 255 266 0 0 0 0 0\n"
"RenderEvent 255 266 0 0 0 0 0\n"
"MouseMoveEvent 255 269 0 0 0 0 0\n"
"RenderEvent 255 269 0 0 0 0 0\n"
"RenderEvent 255 269 0 0 0 0 0\n"
"MouseMoveEvent 257 275 0 0 0 0 0\n"
"RenderEvent 257 275 0 0 0 0 0\n"
"RenderEvent 257 275 0 0 0 0 0\n"
"MouseMoveEvent 258 277 0 0 0 0 0\n"
"RenderEvent 258 277 0 0 0 0 0\n"
"RenderEvent 258 277 0 0 0 0 0\n"
"MouseMoveEvent 258 280 0 0 0 0 0\n"
"RenderEvent 258 280 0 0 0 0 0\n"
"RenderEvent 258 280 0 0 0 0 0\n"
"MouseMoveEvent 260 286 0 0 0 0 0\n"
"RenderEvent 260 286 0 0 0 0 0\n"
"RenderEvent 260 286 0 0 0 0 0\n"
"MouseMoveEvent 261 290 0 0 0 0 0\n"
"RenderEvent 261 290 0 0 0 0 0\n"
"RenderEvent 261 290 0 0 0 0 0\n"
"MouseMoveEvent 261 293 0 0 0 0 0\n"
"RenderEvent 261 293 0 0 0 0 0\n"
"RenderEvent 261 293 0 0 0 0 0\n"
"LeaveEvent 261 293 0 0 0 0 0\n"
"ExitEvent 261 293 0 0 0 0 0\n"
;

//#define RECORD

int TestTreeMapView(int argc, char* argv[])
{
  char* file = vtkTestUtilities::ExpandDataFileName(argc, argv,
                                                    "Data/treetest.xml");

  VTK_CREATE(vtkXMLTreeReader, reader);
  reader->SetFileName(file);
  reader->SetMaskArrays(true);

  delete [] file;

  VTK_CREATE(vtkStringToNumeric, numeric);
  numeric->SetInputConnection(reader->GetOutputPort());
    
  // Tree map view
  VTK_CREATE(vtkRenderWindow, win);
  VTK_CREATE(vtkRenderWindowInteractor, iren);
  iren->SetRenderWindow(win);
  VTK_CREATE(vtkTreeMapView, view);
  view->SetSizeArrayName("size");
  view->SetColorArrayName("level");
  view->SetLabelArrayName("name");
  view->SetHoverArrayName("name");
  view->SetLayoutStrategyToSquarify();
  view->SetupRenderWindow(win);
  view->AddRepresentationFromInputConnection(numeric->GetOutputPort());
  
  // record events
  VTK_CREATE(vtkInteractorEventRecorder, recorder);
  recorder->SetInteractor(iren);
#ifdef RECORD
  recorder->SetFileName("record.log");
  recorder->SetEnabled(true);
  recorder->Record();
#else
  recorder->ReadFromInputStringOn();
  recorder->SetInputString(TreeMapViewEventLog);
#endif

  // interact with data
  // render the image
  //
  iren->Initialize();
  win->Render();
#ifdef RECORD
#else
  recorder->Play();

  // Remove the observers so we can go interactive. Without this the "-I"
  // testing option fails.
  recorder->Off();
#endif
  
  int retVal = vtkRegressionTestImage(win);
  if (retVal == vtkRegressionTester::DO_INTERACTOR)
    {
    iren->Initialize();
    iren->Start();
    
    retVal = vtkRegressionTester::PASSED;
    }
  
  return !retVal;
}
