/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.input.dis;

import org.web3d.vrml.renderer.common.input.dis.Solver;
import org.web3d.vrml.renderer.common.input.dis.SolverTarget;

public class RungeKuttaSolver
implements Solver {
    private double[] k1;
    private double[] k2;
    private double[] k3;
    private double[] k4;
    private double[] tmp;
    private double[] tmp2;
    private double[] wholeStepResults;
    private double[] halfStepResults;

    public RungeKuttaSolver(int n) {
        this.k1 = new double[n];
        this.k2 = new double[n];
        this.k3 = new double[n];
        this.k4 = new double[n];
        this.tmp = new double[n];
        this.wholeStepResults = new double[n];
        this.halfStepResults = new double[n];
        this.tmp2 = new double[n];
    }

    private void arraySet(double[] dArray, double[] dArray2) {
        System.arraycopy(dArray2, 0, dArray, 0, dArray2.length);
    }

    private void arrayScale(double[] dArray, double d) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d;
        }
    }

    private void arrayAdd(double[] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] + dArray2[i];
        }
    }

    private void arrayScaleAdd(double[] dArray, double d, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] * d + dArray2[i];
        }
    }

    private double arrayError(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = Math.abs(dArray[i] - dArray2[i]);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    private void step(SolverTarget solverTarget, double[] dArray, double d, double[] dArray2) {
        solverTarget.getRatesOfChange(dArray, 0.0, this.k1);
        this.arrayScale(this.k1, d);
        this.arrayScaleAdd(this.k1, 0.5, dArray, this.tmp);
        solverTarget.getRatesOfChange(this.tmp, d * 0.5, this.k2);
        this.arrayScale(this.k2, d);
        this.arrayScaleAdd(this.k2, 0.5, dArray, this.tmp);
        solverTarget.getRatesOfChange(this.tmp, d * 0.5, this.k3);
        this.arrayScale(this.k3, d);
        this.arrayAdd(dArray, this.k3, this.tmp);
        solverTarget.getRatesOfChange(this.tmp, d, this.k4);
        this.arrayScale(this.k4, d);
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] + this.k1[i] / 6.0 + this.k2[i] / 3.0 + this.k3[i] / 3.0 + this.k4[i] / 6.0;
        }
    }

    public void solve(SolverTarget solverTarget, double[] dArray, double d, double d2, double[] dArray2) {
        this.arraySet(dArray2, dArray);
        double d3 = d;
        while (d > 0.0) {
            this.step(solverTarget, dArray2, d3, this.wholeStepResults);
            this.step(solverTarget, dArray2, d3 * 0.5, this.tmp2);
            this.step(solverTarget, this.tmp2, d3 * 0.5, this.halfStepResults);
            double d4 = this.arrayError(this.wholeStepResults, this.halfStepResults);
            if (d4 <= d2) {
                this.arraySet(dArray2, this.halfStepResults);
                d -= d3;
            }
            d3 = Math.min(d3 * Math.pow(d2 / d4, 0.2), d);
        }
    }
}

