/*
 * Copyright(C) 1999-2020 National Technology & Engineering Solutions
 * of Sandia, LLC (NTESS).  Under the terms of Contract DE-NA0003525 with
 * NTESS, the U.S. Government retains certain rights in this software.
 *
 * See packages/seacas/LICENSE for details
 */

#include "refine_map.h" // for refine_vdata
#include "structs.h"    // for vtx_data

void compute_mesh_vdata(struct refine_vdata *vdata,        /* preference data for a vertex */
                        struct vtx_data **   comm_graph,   /* communication graph data structure */
                        int                  vtx,          /* current vertex */
                        int *                vtx2node,     /* maps graph vtxs to mesh nodes */
                        int                  mesh_dims[3], /* size of mesh */
                        int                  dim /* dimension we are currently working in */
)
{
  float above;      /* my preference to move up in each dimension */
  float below;      /* my preference to move down in each dimension */
  float same;       /* my preference to stay where I am */
  int   my_loc;     /* my location in mesh */
  int   neighb_loc; /* neighbor's location in mesh */
  float ewgt;       /* weight of an edge */
  int   node;       /* set vertex is assigned to */
  int   neighbor;   /* neighboring vtx in comm_graph */
  int   j;          /* loop counter */

  node = vtx2node[vtx];

  neighb_loc = 0;
  my_loc     = 0;

  if (dim == 0) {
    my_loc = node % mesh_dims[0];
  }
  else if (dim == 1) {
    my_loc = (node / mesh_dims[0]) % mesh_dims[1];
  }
  else if (dim == 2) {
    my_loc = node / (mesh_dims[0] * mesh_dims[1]);
  }

  below = above = same = 0;
  for (j = 1; j < comm_graph[vtx]->nedges; j++) {
    neighbor = comm_graph[vtx]->edges[j];
    ewgt     = comm_graph[vtx]->ewgts[j];
    node     = vtx2node[neighbor];

    if (dim == 0) {
      neighb_loc = node % mesh_dims[0];
    }
    else if (dim == 1) {
      neighb_loc = (node / mesh_dims[0]) % mesh_dims[1];
    }
    else if (dim == 2) {
      neighb_loc = node / (mesh_dims[0] * mesh_dims[1]);
    }

    if (neighb_loc < my_loc) {
      below += ewgt;
    }
    else if (neighb_loc > my_loc) {
      above += ewgt;
    }
    else {
      same += ewgt;
    }
  }
  vdata->below = below;
  vdata->above = above;
  vdata->same  = same;
}
