// Copyright(C) 1999-2021 National Technology & Engineering Solutions
// of Sandia, LLC (NTESS).  Under the terms of Contract DE-NA0003525 with
// NTESS, the U.S. Government retains certain rights in this software.
//
// See packages/seacas/LICENSE for details

#include "Utst_structured_decomp.h"
#include <catch.hpp>

// Disable these tests on NVCC. It tries to optimize and takes forever to build...
#ifndef __NVCC__
#if defined(__clang__) || defined (__GNUC__)
# define ATTRIBUTE_NO_SANITIZE_ADDRESS __attribute__((no_sanitize_address))
#else
# define ATTRIBUTE_NO_SANITIZE_ADDRESS
#endif

ATTRIBUTE_NO_SANITIZE_ADDRESS
TEST_CASE("Rocket-1496", "[rocket-1496_zgc]")
{
  int                                       zone = 1;
  std::vector<Iocgns::StructuredZoneData *> zones;

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "A1", zones.back()->m_zone, "zone720", 720, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{1, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2", zones.back()->m_zone, "zone842", 842, Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3", zones.back()->m_zone, "zone1387", 1387,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A4", zones.back()->m_zone, "zone241", 241, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A5", zones.back()->m_zone, "zone609", 609, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A6", zones.back()->m_zone, "zone845", 845, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{1, 1, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B39", zones.back()->m_zone, "zone1275", 1275,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B44", zones.back()->m_zone, "zone1386", 1386, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A46", zones.back()->m_zone, "zone224", 224, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A47", zones.back()->m_zone, "zone14", 14, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A48", zones.back()->m_zone, "zone985", 985, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A49", zones.back()->m_zone, "zone640", 640, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{12, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x7x30"));

  zones.back()->m_zoneConnectivity.emplace_back("B213", zones.back()->m_zone, "zone920", 920,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{5, 8, 31}}, Ioss::IJK_t{{5, 1, 31}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B392", zones.back()->m_zone, "zone1453", 1453,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{5, 8, 31}}, Ioss::IJK_t{{5, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B401", zones.back()->m_zone, "zone1486", 1486,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{5, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A402", zones.back()->m_zone, "zone733", 733, Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 31}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{8, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A403", zones.back()->m_zone, "zone47", 47, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 31}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A404", zones.back()->m_zone, "zone25", 25, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 8, 31}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 8, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2133", zones.back()->m_zone, "zone1172", 1172,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B2957", zones.back()->m_zone, "zone1495", 1495,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A2962", zones.back()->m_zone, "zone221", 221,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A2963", zones.back()->m_zone, "zone184", 184,
                                                Ioss::IJK_t{{-3, 1, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{51, 8, 12}},
                                                Ioss::IJK_t{{51, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2964", zones.back()->m_zone, "zone6", 6, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{12, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2965", zones.back()->m_zone, "zone5", 5, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2127", zones.back()->m_zone, "zone1171", 1171,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B2961", zones.back()->m_zone, "zone1496", 1496,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2965", zones.back()->m_zone, "zone4", 4, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
      Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A2966", zones.back()->m_zone, "zone220", 220,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2967", zones.back()->m_zone, "zone7", 7, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{12, 101, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2130", zones.back()->m_zone, "zone1172", 1172,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 6}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B2922", zones.back()->m_zone, "zone1476", 1476,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 6}},
                                                Ioss::IJK_t{{12, 6, 6}}, Ioss::IJK_t{{12, 1, 11}},
                                                Ioss::IJK_t{{1, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B2927", zones.back()->m_zone, "zone1478", 1478,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 6}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2964", zones.back()->m_zone, "zone4", 4, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A2968", zones.back()->m_zone, "zone185", 185,
                                                Ioss::IJK_t{{-3, 1, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 6}}, Ioss::IJK_t{{51, 6, 12}},
                                                Ioss::IJK_t{{51, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2969", zones.back()->m_zone, "zone7", 7, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{12, 6, 6}}, Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{1, 101, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x100x5 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2126", zones.back()->m_zone, "zone1171", 1171,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 6}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B2926", zones.back()->m_zone, "zone1477", 1477,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 6}},
                                                Ioss::IJK_t{{12, 101, 6}}, Ioss::IJK_t{{12, 1, 11}},
                                                Ioss::IJK_t{{1, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B2931", zones.back()->m_zone, "zone1479", 1479,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 6}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2967", zones.back()->m_zone, "zone5", 5, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{12, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2969", zones.back()->m_zone, "zone6", 6, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
      Ioss::IJK_t{{12, 101, 6}}, Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{1, 6, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2915", zones.back()->m_zone, "zone1472", 1472,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B2917", zones.back()->m_zone, "zone1473", 1473,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2970", zones.back()->m_zone, "zone9", 9, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2971", zones.back()->m_zone, "zone553", 553, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A2972", zones.back()->m_zone, "zone75", 75,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 11}},
                                                Ioss::IJK_t{{11, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2119", zones.back()->m_zone, "zone1169", 1169,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B2180", zones.back()->m_zone, "zone1185", 1185,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2970", zones.back()->m_zone, "zone8", 8, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
      Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2973", zones.back()->m_zone, "zone199", 199, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A2974", zones.back()->m_zone, "zone10", 10,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2122", zones.back()->m_zone, "zone1170", 1170,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B2177", zones.back()->m_zone, "zone1184", 1184,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{12, 1, 11}},
                                                Ioss::IJK_t{{12, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2974", zones.back()->m_zone, "zone9", 9, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2975", zones.back()->m_zone, "zone78", 78, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A2976", zones.back()->m_zone, "zone190", 190,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2977", zones.back()->m_zone, "zone203", 203, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x11x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2434", zones.back()->m_zone, "zone1272", 1272,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 12, 6}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2978", zones.back()->m_zone, "zone183", 183, Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 12, 1}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2979", zones.back()->m_zone, "zone15", 15, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2980", zones.back()->m_zone, "zone12", 12, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2981", zones.back()->m_zone, "zone21", 21, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 12, 1}},
      Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2368", zones.back()->m_zone, "zone1247", 1247, Ioss::IJK_t{{-2, 3, -1}},
      Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{12, 101, 1}},
      Ioss::IJK_t{{1, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2980", zones.back()->m_zone, "zone11", 11, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{1, 12, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2982", zones.back()->m_zone, "zone13", 13, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 11, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A2983", zones.back()->m_zone, "zone20", 20,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2984", zones.back()->m_zone, "zone30", 30, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
      Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back("B2410", zones.back()->m_zone, "zone1263", 1263,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2982", zones.back()->m_zone, "zone12", 12, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2985", zones.back()->m_zone, "zone15", 15, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 6}}, Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2986", zones.back()->m_zone, "zone30", 30, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 11}},
      Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2987", zones.back()->m_zone, "zone16", 16, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 8, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B47", zones.back()->m_zone, "zone2", 2, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B397", zones.back()->m_zone, "zone1475", 1475,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 6, 8}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B399", zones.back()->m_zone, "zone1486", 1486,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A405", zones.back()->m_zone, "zone69", 69, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A406", zones.back()->m_zone, "zone940", 940, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A407", zones.back()->m_zone, "zone25", 25, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{1, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2262", zones.back()->m_zone, "zone1210", 1210,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2979", zones.back()->m_zone, "zone11", 11, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2985", zones.back()->m_zone, "zone13", 13, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A2988", zones.back()->m_zone, "zone182", 182,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2989", zones.back()->m_zone, "zone17", 17, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back("B2409", zones.back()->m_zone, "zone1262", 1262,
                                                Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 11}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2987", zones.back()->m_zone, "zone13", 13, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2990", zones.back()->m_zone, "zone17", 17, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2991", zones.back()->m_zone, "zone19", 19, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2992", zones.back()->m_zone, "zone29", 29, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 11}},
      Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2431", zones.back()->m_zone, "zone1271", 1271,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2989", zones.back()->m_zone, "zone15", 15, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2990", zones.back()->m_zone, "zone16", 16, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A2993", zones.back()->m_zone, "zone181", 181,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2994", zones.back()->m_zone, "zone18", 18, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 8, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2421", zones.back()->m_zone, "zone1267", 1267,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 6}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2994", zones.back()->m_zone, "zone17", 17, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2995", zones.back()->m_zone, "zone167", 167, Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2996", zones.back()->m_zone, "zone23", 23, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2997", zones.back()->m_zone, "zone19", 19, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back("B2412", zones.back()->m_zone, "zone1265", 1265,
                                                Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 11}}, Ioss::IJK_t{{11, 101, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2991", zones.back()->m_zone, "zone16", 16, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2997", zones.back()->m_zone, "zone18", 18, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 6}}, Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A2998", zones.back()->m_zone, "zone22", 22, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A2999", zones.back()->m_zone, "zone28", 28,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2370", zones.back()->m_zone, "zone1248", 1248, Ioss::IJK_t{{2, -3, -1}},
      Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 11, 12}}, Ioss::IJK_t{{12, 101, 11}},
      Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B2983", zones.back()->m_zone, "zone12", 12,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3000", zones.back()->m_zone, "zone57", 57, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 11, 1}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3001", zones.back()->m_zone, "zone21", 21, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{1, 12, 6}}, Ioss::IJK_t{{11, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3002", zones.back()->m_zone, "zone31", 31, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
      Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x11x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2355", zones.back()->m_zone, "zone1243", 1243,
                                                Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 12, 6}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{12, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2981", zones.back()->m_zone, "zone11", 11, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{1, 12, 1}}, Ioss::IJK_t{{11, 12, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3001", zones.back()->m_zone, "zone20", 20, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{1, 1, 12}}, Ioss::IJK_t{{11, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3003", zones.back()->m_zone, "zone66", 66,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 12, 1}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3004", zones.back()->m_zone, "zone65", 65, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 12, 1}},
      Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back("B2400", zones.back()->m_zone, "zone1259", 1259,
                                                Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 11}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2998", zones.back()->m_zone, "zone19", 19, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3005", zones.back()->m_zone, "zone23", 23, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 6}}, Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3006", zones.back()->m_zone, "zone26", 26, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3007", zones.back()->m_zone, "zone27", 27, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 11}},
      Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2426", zones.back()->m_zone, "zone1269", 1269,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 6}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2996", zones.back()->m_zone, "zone18", 18, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3005", zones.back()->m_zone, "zone22", 22, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3008", zones.back()->m_zone, "zone166", 166, Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3009", zones.back()->m_zone, "zone24", 24, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x11x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2545", zones.back()->m_zone, "zone1319", 1319,
                                                Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3009", zones.back()->m_zone, "zone23", 23, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A3010", zones.back()->m_zone, "zone165", 165,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 12, 1}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3011", zones.back()->m_zone, "zone26", 26, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3012", zones.back()->m_zone, "zone37", 37, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 12, 1}},
      Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x7x30 "));

  zones.back()->m_zoneConnectivity.emplace_back("B306", zones.back()->m_zone, "zone1165", 1165,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{12, 8, 31}}, Ioss::IJK_t{{12, 1, 31}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B394", zones.back()->m_zone, "zone1464", 1464,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{12, 8, 31}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B404", zones.back()->m_zone, "zone3", 3, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 31}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B407", zones.back()->m_zone, "zone14", 14, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 8, 1}}, Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A408", zones.back()->m_zone, "zone58", 58, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 31}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A409", zones.back()->m_zone, "zone941", 941, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
      Ioss::IJK_t{{12, 8, 31}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 8, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2392", zones.back()->m_zone, "zone1256", 1256,
                                                Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 12}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{12, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3006", zones.back()->m_zone, "zone22", 22, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 11, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3011", zones.back()->m_zone, "zone24", 24, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{1, 12, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A3013", zones.back()->m_zone, "zone35", 35,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3014", zones.back()->m_zone, "zone27", 27, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
      Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back("B2397", zones.back()->m_zone, "zone1258", 1258,
                                                Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 12}}, Ioss::IJK_t{{12, 101, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3007", zones.back()->m_zone, "zone22", 22, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{11, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3014", zones.back()->m_zone, "zone26", 26, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{11, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3015", zones.back()->m_zone, "zone34", 34,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3016", zones.back()->m_zone, "zone28", 28, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 8, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back("B2403", zones.back()->m_zone, "zone1260", 1260,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{1, 101, 8}},
                                                Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2999", zones.back()->m_zone, "zone19", 19, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3016", zones.back()->m_zone, "zone27", 27, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3017", zones.back()->m_zone, "zone29", 29, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3018", zones.back()->m_zone, "zone33", 33,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back("B2405", zones.back()->m_zone, "zone1261", 1261,
                                                Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 12}}, Ioss::IJK_t{{12, 101, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2992", zones.back()->m_zone, "zone16", 16, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{11, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3017", zones.back()->m_zone, "zone28", 28, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3019", zones.back()->m_zone, "zone32", 32,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3020", zones.back()->m_zone, "zone30", 30, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 8, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back("B2374", zones.back()->m_zone, "zone1249", 1249,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{12, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2984", zones.back()->m_zone, "zone12", 12, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{11, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2986", zones.back()->m_zone, "zone13", 13, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{11, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3020", zones.back()->m_zone, "zone29", 29, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3021", zones.back()->m_zone, "zone31", 31,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back("B2376", zones.back()->m_zone, "zone1250", 1250,
                                                Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 12}}, Ioss::IJK_t{{12, 101, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3002", zones.back()->m_zone, "zone20", 20, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{11, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3021", zones.back()->m_zone, "zone30", 30,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3022", zones.back()->m_zone, "zone57", 57, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3023", zones.back()->m_zone, "zone32", 32, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 8, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back("B2379", zones.back()->m_zone, "zone1251", 1251,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{1, 101, 8}},
                                                Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3019", zones.back()->m_zone, "zone29", 29,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3023", zones.back()->m_zone, "zone31", 31, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3024", zones.back()->m_zone, "zone56", 56, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3025", zones.back()->m_zone, "zone33", 33, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back("B2383", zones.back()->m_zone, "zone1252", 1252,
                                                Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 12}}, Ioss::IJK_t{{12, 101, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3018", zones.back()->m_zone, "zone28", 28,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3025", zones.back()->m_zone, "zone32", 32, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3026", zones.back()->m_zone, "zone55", 55, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3027", zones.back()->m_zone, "zone34", 34, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 8, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back("B2387", zones.back()->m_zone, "zone1255", 1255,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{1, 101, 8}},
                                                Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3015", zones.back()->m_zone, "zone27", 27,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3027", zones.back()->m_zone, "zone33", 33, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3028", zones.back()->m_zone, "zone38", 38, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{11, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3029", zones.back()->m_zone, "zone35", 35, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{11, 11, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2394", zones.back()->m_zone, "zone1257", 1257, Ioss::IJK_t{{-2, -3, 1}},
      Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{1, 101, 11}},
      Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3013", zones.back()->m_zone, "zone26", 26,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3029", zones.back()->m_zone, "zone34", 34, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
      Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3030", zones.back()->m_zone, "zone38", 38, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 11, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3031", zones.back()->m_zone, "zone37", 37, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{1, 12, 6}}, Ioss::IJK_t{{11, 1, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B51", zones.back()->m_zone, "zone113", 113, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B398", zones.back()->m_zone, "zone1486", 1486,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A410", zones.back()->m_zone, "zone447", 447, Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A411", zones.back()->m_zone, "zone91", 91, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A412", zones.back()->m_zone, "zone69", 69, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A413", zones.back()->m_zone, "zone47", 47, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{1, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x11x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2559", zones.back()->m_zone, "zone1326", 1326,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{12, 1, 11}},
                                                Ioss::IJK_t{{1, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3012", zones.back()->m_zone, "zone24", 24, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{1, 12, 1}}, Ioss::IJK_t{{11, 12, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3031", zones.back()->m_zone, "zone35", 35, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{1, 1, 12}}, Ioss::IJK_t{{11, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3032", zones.back()->m_zone, "zone40", 40,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 12, 1}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3033", zones.back()->m_zone, "zone39", 39,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 12, 1}},
                                                Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back("B2320", zones.back()->m_zone, "zone1228", 1228,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3028", zones.back()->m_zone, "zone34", 34, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 11}},
      Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3030", zones.back()->m_zone, "zone35", 35, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3034", zones.back()->m_zone, "zone39", 39, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3035", zones.back()->m_zone, "zone55", 55, Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 8, 11}}, Ioss::IJK_t{{11, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2324", zones.back()->m_zone, "zone1230", 1230,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 6}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3033", zones.back()->m_zone, "zone37", 37, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 12, 1}}, Ioss::IJK_t{{1, 12, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3034", zones.back()->m_zone, "zone38", 38, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3036", zones.back()->m_zone, "zone41", 41,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3037", zones.back()->m_zone, "zone63", 63, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x11"));

  zones.back()->m_zoneConnectivity.emplace_back("B1832", zones.back()->m_zone, "zone1080", 1080,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 12}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3032", zones.back()->m_zone, "zone37", 37,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{11, 12, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3038", zones.back()->m_zone, "zone41", 41, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3039", zones.back()->m_zone, "zone89", 89, Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 12}},
      Ioss::IJK_t{{11, 6, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 11, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3040", zones.back()->m_zone, "zone43", 43, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{11, 6, 12}}, Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 6, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1834", zones.back()->m_zone, "zone1081", 1081,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3036", zones.back()->m_zone, "zone39", 39,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3038", zones.back()->m_zone, "zone40", 40, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3041", zones.back()->m_zone, "zone59", 59, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3042", zones.back()->m_zone, "zone42", 42, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1829", zones.back()->m_zone, "zone1079", 1079,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{6, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3042", zones.back()->m_zone, "zone41", 41, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3043", zones.back()->m_zone, "zone43", 43, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3044", zones.back()->m_zone, "zone44", 44, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3045", zones.back()->m_zone, "zone474", 474, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x11"));

  zones.back()->m_zoneConnectivity.emplace_back("B1825", zones.back()->m_zone, "zone1078", 1078,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 12}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{6, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3040", zones.back()->m_zone, "zone40", 40, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{11, 6, 12}}, Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 6, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3043", zones.back()->m_zone, "zone42", 42, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3046", zones.back()->m_zone, "zone46", 46, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 12, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3047", zones.back()->m_zone, "zone90", 90,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 6, 12}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{51, 1, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2765", zones.back()->m_zone, "zone1415", 1415,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 6}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3044", zones.back()->m_zone, "zone42", 42, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3048", zones.back()->m_zone, "zone46", 46, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3049", zones.back()->m_zone, "zone45", 45, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3050", zones.back()->m_zone, "zone467", 467, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back("B2753", zones.back()->m_zone, "zone1411", 1411,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 101, 8}},
                                                Ioss::IJK_t{{11, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3049", zones.back()->m_zone, "zone44", 44, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A3051", zones.back()->m_zone, "zone466", 466,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A3052", zones.back()->m_zone, "zone54", 54,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3053", zones.back()->m_zone, "zone48", 48, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 11, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x11x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2754", zones.back()->m_zone, "zone1412", 1412,
                                                Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3046", zones.back()->m_zone, "zone43", 43, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 12, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3048", zones.back()->m_zone, "zone44", 44, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3054", zones.back()->m_zone, "zone48", 48, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3055", zones.back()->m_zone, "zone49", 49,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 12, 1}},
                                                Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{11, 12, 1}},
                                                Ioss::IJK_t{{1, 12, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x7x30"));

  zones.back()->m_zoneConnectivity.emplace_back("B198", zones.back()->m_zone, "zone887", 887,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{5, 8, 31}}, Ioss::IJK_t{{5, 1, 31}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B403", zones.back()->m_zone, "zone3", 3, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 31}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B413", zones.back()->m_zone, "zone36", 36, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A414", zones.back()->m_zone, "zone58", 58, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 31}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A415", zones.back()->m_zone, "zone469", 469, Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 8, 31}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A416", zones.back()->m_zone, "zone102", 102, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{5, 8, 31}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2749", zones.back()->m_zone, "zone1410", 1410, Ioss::IJK_t{{2, -3, -1}},
      Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 11, 12}}, Ioss::IJK_t{{12, 101, 11}},
      Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3053", zones.back()->m_zone, "zone45", 45, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 11, 1}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3054", zones.back()->m_zone, "zone46", 46, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{1, 12, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A3056", zones.back()->m_zone, "zone50", 50,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{1, 11, 12}},
                                                Ioss::IJK_t{{11, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3057", zones.back()->m_zone, "zone54", 54, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
      Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x11x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2818", zones.back()->m_zone, "zone1430", 1430,
                                                Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 12, 6}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{12, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B3055", zones.back()->m_zone, "zone46", 46,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 12, 1}},
                                                Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{11, 12, 1}},
                                                Ioss::IJK_t{{1, 12, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3058", zones.back()->m_zone, "zone144", 144, Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 12, 1}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3059", zones.back()->m_zone, "zone51", 51, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3060", zones.back()->m_zone, "zone50", 50, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{11, 11, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2745", zones.back()->m_zone, "zone1408", 1408, Ioss::IJK_t{{2, -3, -1}},
      Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 11, 12}}, Ioss::IJK_t{{12, 101, 11}},
      Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3056", zones.back()->m_zone, "zone48", 48,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{1, 11, 12}},
                                                Ioss::IJK_t{{11, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3060", zones.back()->m_zone, "zone49", 49, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 11, 1}},
      Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{1, 1, 6}}, Ioss::IJK_t{{11, 12, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3061", zones.back()->m_zone, "zone52", 52, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 11, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3062", zones.back()->m_zone, "zone53", 53, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2809", zones.back()->m_zone, "zone1427", 1427,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 6}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3059", zones.back()->m_zone, "zone49", 49, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3063", zones.back()->m_zone, "zone145", 145, Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3064", zones.back()->m_zone, "zone445", 445,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3065", zones.back()->m_zone, "zone52", 52, Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 8, 11}}, Ioss::IJK_t{{11, 1, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back("B2776", zones.back()->m_zone, "zone1418", 1418,
                                                Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 11}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3061", zones.back()->m_zone, "zone50", 50, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3065", zones.back()->m_zone, "zone51", 51,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 8, 6}},
                                                Ioss::IJK_t{{11, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3066", zones.back()->m_zone, "zone53", 53, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3067", zones.back()->m_zone, "zone456", 456,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 1, 11}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back("B2773", zones.back()->m_zone, "zone1417", 1417,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{1, 101, 8}},
                                                Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3062", zones.back()->m_zone, "zone50", 50, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3066", zones.back()->m_zone, "zone52", 52, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3068", zones.back()->m_zone, "zone54", 54,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3069", zones.back()->m_zone, "zone460", 460, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back("B2770", zones.back()->m_zone, "zone1416", 1416,
                                                Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 12}}, Ioss::IJK_t{{12, 101, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3052", zones.back()->m_zone, "zone45", 45, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3057", zones.back()->m_zone, "zone48", 48, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{11, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3068", zones.back()->m_zone, "zone53", 53,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3070", zones.back()->m_zone, "zone465", 465, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back("B2384", zones.back()->m_zone, "zone1254", 1254,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3026", zones.back()->m_zone, "zone33", 33, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3035", zones.back()->m_zone, "zone38", 38, Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 8, 11}}, Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3071", zones.back()->m_zone, "zone56", 56, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A3072", zones.back()->m_zone, "zone63", 63,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 8, 6}},
                                                Ioss::IJK_t{{11, 1, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back("B2336", zones.back()->m_zone, "zone1234", 1234,
                                                Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 11}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3024", zones.back()->m_zone, "zone32", 32, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3071", zones.back()->m_zone, "zone55", 55, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A3073", zones.back()->m_zone, "zone64", 64,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 8, 6}},
                                                Ioss::IJK_t{{11, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3074", zones.back()->m_zone, "zone57", 57, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{1, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back("B2340", zones.back()->m_zone, "zone1235", 1235,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 101, 8}},
                                                Ioss::IJK_t{{11, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3000", zones.back()->m_zone, "zone20", 20, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3022", zones.back()->m_zone, "zone31", 31,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3074", zones.back()->m_zone, "zone56", 56, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3075", zones.back()->m_zone, "zone65", 65, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x7x30 "));

  zones.back()->m_zoneConnectivity.emplace_back("B293", zones.back()->m_zone, "zone1131", 1131,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{12, 8, 31}}, Ioss::IJK_t{{12, 1, 31}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B408", zones.back()->m_zone, "zone25", 25, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 31}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B414", zones.back()->m_zone, "zone47", 47, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
      Ioss::IJK_t{{12, 8, 31}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A417", zones.back()->m_zone, "zone69", 69, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 8, 1}}, Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A418", zones.back()->m_zone, "zone983", 983, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 31}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("A419", zones.back()->m_zone, "zone125", 125,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{12, 8, 31}}, Ioss::IJK_t{{12, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1839", zones.back()->m_zone, "zone1082", 1082,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3041", zones.back()->m_zone, "zone41", 41, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3076", zones.back()->m_zone, "zone63", 63, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3077", zones.back()->m_zone, "zone60", 60, Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3078", zones.back()->m_zone, "zone485", 485,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1843", zones.back()->m_zone, "zone1083", 1083,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3077", zones.back()->m_zone, "zone59", 59, Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3079", zones.back()->m_zone, "zone61", 61, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3080", zones.back()->m_zone, "zone487", 487,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3081", zones.back()->m_zone, "zone64", 64, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1851", zones.back()->m_zone, "zone1085", 1085,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3079", zones.back()->m_zone, "zone60", 60, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3082", zones.back()->m_zone, "zone66", 66, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3083", zones.back()->m_zone, "zone65", 65, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3084", zones.back()->m_zone, "zone62", 62, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1859", zones.back()->m_zone, "zone1088", 1088,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{6, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3084", zones.back()->m_zone, "zone61", 61, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3085", zones.back()->m_zone, "zone67", 67, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3086", zones.back()->m_zone, "zone68", 68, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3087", zones.back()->m_zone, "zone532", 532, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2330", zones.back()->m_zone, "zone1233", 1233,
                                                Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3037", zones.back()->m_zone, "zone39", 39, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3072", zones.back()->m_zone, "zone55", 55, Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 8, 11}}, Ioss::IJK_t{{11, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3076", zones.back()->m_zone, "zone59", 59, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3088", zones.back()->m_zone, "zone64", 64, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 8, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2348", zones.back()->m_zone, "zone1239", 1239,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 6}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3073", zones.back()->m_zone, "zone56", 56, Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 8, 11}}, Ioss::IJK_t{{11, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3081", zones.back()->m_zone, "zone60", 60, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3088", zones.back()->m_zone, "zone63", 63, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3089", zones.back()->m_zone, "zone65", 65, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2363", zones.back()->m_zone, "zone1246", 1246,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 6}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3004", zones.back()->m_zone, "zone21", 21, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{1, 12, 1}}, Ioss::IJK_t{{11, 12, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3075", zones.back()->m_zone, "zone57", 57, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3083", zones.back()->m_zone, "zone61", 61, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3089", zones.back()->m_zone, "zone64", 64, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x11"));

  zones.back()->m_zoneConnectivity.emplace_back("B1847", zones.back()->m_zone, "zone1084", 1084,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 12}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3003", zones.back()->m_zone, "zone21", 21,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{11, 12, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3082", zones.back()->m_zone, "zone61", 61, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3090", zones.back()->m_zone, "zone107", 107,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 6, 12}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{51, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3091", zones.back()->m_zone, "zone67", 67, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{11, 6, 12}}, Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 6, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x11"));

  zones.back()->m_zoneConnectivity.emplace_back("B1856", zones.back()->m_zone, "zone1086", 1086,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 12}}, Ioss::IJK_t{{6, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3085", zones.back()->m_zone, "zone62", 62, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3091", zones.back()->m_zone, "zone66", 66, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{11, 6, 12}}, Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 6, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3092", zones.back()->m_zone, "zone70", 70, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 12, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3093", zones.back()->m_zone, "zone108", 108,
                                                Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 6, 12}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2901", zones.back()->m_zone, "zone1468", 1468,
                                                Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3086", zones.back()->m_zone, "zone62", 62, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3094", zones.back()->m_zone, "zone70", 70, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3095", zones.back()->m_zone, "zone71", 71, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3096", zones.back()->m_zone, "zone536", 536, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B56", zones.back()->m_zone, "zone224", 224, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B405", zones.back()->m_zone, "zone14", 14, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B412", zones.back()->m_zone, "zone36", 36, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B417", zones.back()->m_zone, "zone58", 58, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A420", zones.back()->m_zone, "zone136", 136,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A421", zones.back()->m_zone, "zone939", 939, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x11x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2886", zones.back()->m_zone, "zone1463", 1463,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 12, 6}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3092", zones.back()->m_zone, "zone67", 67, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 12, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3094", zones.back()->m_zone, "zone68", 68, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3097", zones.back()->m_zone, "zone72", 72, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3098", zones.back()->m_zone, "zone77", 77,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 12, 1}},
                                                Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{11, 12, 1}},
                                                Ioss::IJK_t{{1, 12, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back("B2897", zones.back()->m_zone, "zone1466", 1466,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3095", zones.back()->m_zone, "zone68", 68, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 6}}, Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3099", zones.back()->m_zone, "zone72", 72, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3100", zones.back()->m_zone, "zone73", 73, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 11}},
      Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3101", zones.back()->m_zone, "zone538", 538,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2920", zones.back()->m_zone, "zone1474", 1474, Ioss::IJK_t{{-2, -3, 1}},
      Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{1, 101, 11}},
      Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3097", zones.back()->m_zone, "zone70", 70, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{1, 12, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3099", zones.back()->m_zone, "zone71", 71, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 11, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A3102", zones.back()->m_zone, "zone76", 76,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{1, 11, 12}},
                                                Ioss::IJK_t{{11, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3103", zones.back()->m_zone, "zone73", 73, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
      Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back("B2912", zones.back()->m_zone, "zone1471", 1471,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{1, 101, 8}},
                                                Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3100", zones.back()->m_zone, "zone71", 71, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{11, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3103", zones.back()->m_zone, "zone72", 72, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{11, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3104", zones.back()->m_zone, "zone74", 74,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3105", zones.back()->m_zone, "zone542", 542, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back("B2916", zones.back()->m_zone, "zone1472", 1472,
                                                Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 12}}, Ioss::IJK_t{{12, 101, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3104", zones.back()->m_zone, "zone73", 73,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3106", zones.back()->m_zone, "zone75", 75, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3107", zones.back()->m_zone, "zone76", 76, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3108", zones.back()->m_zone, "zone548", 548, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2972", zones.back()->m_zone, "zone8", 8, Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{11, 1, 1}},
      Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3106", zones.back()->m_zone, "zone74", 74, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3109", zones.back()->m_zone, "zone76", 76, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3110", zones.back()->m_zone, "zone78", 78,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 8, 6}},
                                                Ioss::IJK_t{{11, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A3111", zones.back()->m_zone, "zone549", 549,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 1, 11}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2919", zones.back()->m_zone, "zone1473", 1473, Ioss::IJK_t{{-2, -3, 1}},
      Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{1, 101, 11}},
      Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3102", zones.back()->m_zone, "zone72", 72,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{1, 11, 12}},
                                                Ioss::IJK_t{{11, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3107", zones.back()->m_zone, "zone74", 74, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3109", zones.back()->m_zone, "zone75", 75, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 11, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3112", zones.back()->m_zone, "zone77", 77, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 11, 1}},
      Ioss::IJK_t{{11, 11, 12}}, Ioss::IJK_t{{1, 1, 6}}, Ioss::IJK_t{{11, 12, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x11x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B2176", zones.back()->m_zone, "zone1184", 1184,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{12, 1, 11}},
                                                Ioss::IJK_t{{1, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B3098", zones.back()->m_zone, "zone70", 70,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 12, 1}},
                                                Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{11, 12, 1}},
                                                Ioss::IJK_t{{1, 12, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3112", zones.back()->m_zone, "zone76", 76, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 12, 6}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{11, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3113", zones.back()->m_zone, "zone193", 193,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 12, 1}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3114", zones.back()->m_zone, "zone78", 78, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2975", zones.back()->m_zone, "zone10", 10, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{11, 1, 1}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3110", zones.back()->m_zone, "zone75", 75, Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 8, 11}}, Ioss::IJK_t{{11, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3114", zones.back()->m_zone, "zone77", 77, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A3115", zones.back()->m_zone, "zone192", 192,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3116", zones.back()->m_zone, "zone198", 198,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x10 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1780", zones.back()->m_zone, "zone1067", 1067,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{6, 1, 12}},
                                                Ioss::IJK_t{{1, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3117", zones.back()->m_zone, "zone81", 81,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 6}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3118", zones.back()->m_zone, "zone160", 160,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 11}}, Ioss::IJK_t{{1, 11, 12}},
                                                Ioss::IJK_t{{51, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3119", zones.back()->m_zone, "zone88", 88,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{51, 1, 11}},
                                                Ioss::IJK_t{{1, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3120", zones.back()->m_zone, "zone86", 86, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x5"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B79", zones.back()->m_zone, "zone576", 576, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{5, 6, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B84", zones.back()->m_zone, "zone587", 587, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{5, 6, 6}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A422", zones.back()->m_zone, "zone147", 147,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A423", zones.back()->m_zone, "zone555", 555, Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A424", zones.back()->m_zone, "zone91", 91, Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 6}}, Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A425", zones.back()->m_zone, "zone114", 114, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 6, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x5 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1759", zones.back()->m_zone, "zone1061", 1061,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 6}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B3117", zones.back()->m_zone, "zone79", 79,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 6}}, Ioss::IJK_t{{51, 6, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3121", zones.back()->m_zone, "zone82", 82, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 6, 6}}, Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A3122", zones.back()->m_zone, "zone159", 159,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 6}},
                                                Ioss::IJK_t{{51, 6, 6}}, Ioss::IJK_t{{1, 6, 12}},
                                                Ioss::IJK_t{{51, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3123", zones.back()->m_zone, "zone143", 143,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 6}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x5 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2098", zones.back()->m_zone, "zone1160", 1160,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 6}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3121", zones.back()->m_zone, "zone81", 81, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{51, 6, 6}}, Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3124", zones.back()->m_zone, "zone83", 83, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3125", zones.back()->m_zone, "zone94", 94, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3126", zones.back()->m_zone, "zone85", 85, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{51, 6, 6}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2113", zones.back()->m_zone, "zone1167", 1167,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3124", zones.back()->m_zone, "zone82", 82, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3127", zones.back()->m_zone, "zone92", 92, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3128", zones.back()->m_zone, "zone390", 390, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3129", zones.back()->m_zone, "zone84", 84, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1742", zones.back()->m_zone, "zone1057", 1057,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3129", zones.back()->m_zone, "zone83", 83, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3130", zones.back()->m_zone, "zone85", 85,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 6}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3131", zones.back()->m_zone, "zone151", 151,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3132", zones.back()->m_zone, "zone420", 420, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x5 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1756", zones.back()->m_zone, "zone1060", 1060,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 6}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3126", zones.back()->m_zone, "zone82", 82, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B3130", zones.back()->m_zone, "zone84", 84,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 6}}, Ioss::IJK_t{{51, 6, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3133", zones.back()->m_zone, "zone153", 153,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 6}},
                                                Ioss::IJK_t{{51, 6, 6}}, Ioss::IJK_t{{1, 6, 12}},
                                                Ioss::IJK_t{{51, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3134", zones.back()->m_zone, "zone86", 86, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{51, 6, 6}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x10 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1774", zones.back()->m_zone, "zone1064", 1064,
                                                Ioss::IJK_t{{-3, 1, -2}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{1, 11, 12}},
                                                Ioss::IJK_t{{6, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3120", zones.back()->m_zone, "zone79", 79, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 11}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{51, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3134", zones.back()->m_zone, "zone85", 85, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3135", zones.back()->m_zone, "zone87", 87, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 11}},
      Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3136", zones.back()->m_zone, "zone149", 149,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 11, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x10 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1823", zones.back()->m_zone, "zone1078", 1078,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{6, 1, 12}},
                                                Ioss::IJK_t{{1, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3135", zones.back()->m_zone, "zone86", 86, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{51, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3137", zones.back()->m_zone, "zone88", 88, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 11}}, Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3138", zones.back()->m_zone, "zone90", 90, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 11}},
      Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{1, 1, 6}}, Ioss::IJK_t{{51, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3139", zones.back()->m_zone, "zone148", 148,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{51, 11, 12}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x10 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1833", zones.back()->m_zone, "zone1080", 1080,
                                                Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 11}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{6, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3119", zones.back()->m_zone, "zone79", 79,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{51, 1, 11}},
                                                Ioss::IJK_t{{1, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3137", zones.back()->m_zone, "zone87", 87, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{51, 1, 11}}, Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3140", zones.back()->m_zone, "zone89", 89, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A3141", zones.back()->m_zone, "zone164", 164,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 11}}, Ioss::IJK_t{{1, 11, 12}},
                                                Ioss::IJK_t{{51, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x5 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3039", zones.back()->m_zone, "zone40", 40, Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 11, 6}}, Ioss::IJK_t{{1, 1, 12}}, Ioss::IJK_t{{11, 6, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3140", zones.back()->m_zone, "zone88", 88, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3142", zones.back()->m_zone, "zone165", 165, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{1, 1, 12}}, Ioss::IJK_t{{51, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3143", zones.back()->m_zone, "zone90", 90, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{51, 11, 6}}, Ioss::IJK_t{{51, 1, 6}}, Ioss::IJK_t{{1, 11, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x5 "));

  zones.back()->m_zoneConnectivity.emplace_back("B3047", zones.back()->m_zone, "zone43", 43,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 6}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 6, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3138", zones.back()->m_zone, "zone87", 87, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 6}}, Ioss::IJK_t{{1, 6, 11}}, Ioss::IJK_t{{51, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3143", zones.back()->m_zone, "zone89", 89, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{51, 11, 6}}, Ioss::IJK_t{{51, 1, 6}}, Ioss::IJK_t{{1, 11, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3144", zones.back()->m_zone, "zone144", 144, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{1, 1, 12}}, Ioss::IJK_t{{51, 11, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B63", zones.back()->m_zone, "zone335", 335, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{5, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B411", zones.back()->m_zone, "zone36", 36, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B424", zones.back()->m_zone, "zone80", 80, Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{5, 1, 6}}, Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A426", zones.back()->m_zone, "zone136", 136, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A427", zones.back()->m_zone, "zone535", 535, Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A428", zones.back()->m_zone, "zone102", 102, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{5, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x30"));

  zones.back()->m_zoneConnectivity.emplace_back("B2114", zones.back()->m_zone, "zone1168", 1168,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 31}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3127", zones.back()->m_zone, "zone83", 83, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3145", zones.back()->m_zone, "zone93", 93, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 31}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("A3146", zones.back()->m_zone, "zone127", 127,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{51, 1, 31}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("A3147", zones.back()->m_zone, "zone388", 388,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{51, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x30"));

  zones.back()->m_zoneConnectivity.emplace_back("B2101", zones.back()->m_zone, "zone1161", 1161,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3145", zones.back()->m_zone, "zone92", 92, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 31}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3148", zones.back()->m_zone, "zone94", 94, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3149", zones.back()->m_zone, "zone123", 123,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{51, 1, 31}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("A3150", zones.back()->m_zone, "zone139", 139,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2103", zones.back()->m_zone, "zone1162", 1162,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3125", zones.back()->m_zone, "zone82", 82, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3148", zones.back()->m_zone, "zone93", 93, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3151", zones.back()->m_zone, "zone95", 95, Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3152", zones.back()->m_zone, "zone143", 143, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2085", zones.back()->m_zone, "zone1156", 1156,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3151", zones.back()->m_zone, "zone94", 94, Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3153", zones.back()->m_zone, "zone96", 96, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3154", zones.back()->m_zone, "zone142", 142,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3155", zones.back()->m_zone, "zone139", 139,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2071", zones.back()->m_zone, "zone1150", 1150,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3153", zones.back()->m_zone, "zone95", 95, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3156", zones.back()->m_zone, "zone141", 141,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3157", zones.back()->m_zone, "zone99", 99, Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3158", zones.back()->m_zone, "zone97", 97, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{1, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x30"));

  zones.back()->m_zoneConnectivity.emplace_back("B2073", zones.back()->m_zone, "zone1151", 1151,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3158", zones.back()->m_zone, "zone96", 96, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3159", zones.back()->m_zone, "zone139", 139,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 31}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("A3160", zones.back()->m_zone, "zone119", 119,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{51, 1, 31}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3161", zones.back()->m_zone, "zone98", 98, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x30"));

  zones.back()->m_zoneConnectivity.emplace_back("B2059", zones.back()->m_zone, "zone1146", 1146,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3161", zones.back()->m_zone, "zone97", 97, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 31}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{51, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("A3162", zones.back()->m_zone, "zone99", 99,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3163", zones.back()->m_zone, "zone118", 118,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{1, 8, 31}},
                                                Ioss::IJK_t{{51, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3164", zones.back()->m_zone, "zone112", 112, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2062", zones.back()->m_zone, "zone1147", 1147,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3157", zones.back()->m_zone, "zone96", 96, Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3162", zones.back()->m_zone, "zone98", 98,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3165", zones.back()->m_zone, "zone100", 100,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3166", zones.back()->m_zone, "zone140", 140, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x5 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2043", zones.back()->m_zone, "zone1140", 1140,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 6}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3165", zones.back()->m_zone, "zone99", 99, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3167", zones.back()->m_zone, "zone111", 111,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 6}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3168", zones.back()->m_zone, "zone109", 109, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{51, 6, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3169", zones.back()->m_zone, "zone101", 101,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 6}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x5 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1695", zones.back()->m_zone, "zone1045", 1045,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 6}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B3169", zones.back()->m_zone, "zone100", 100,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A3170", zones.back()->m_zone, "zone140", 140,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 6}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3171", zones.back()->m_zone, "zone171", 171,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 6}},
                                                Ioss::IJK_t{{51, 6, 6}}, Ioss::IJK_t{{51, 1, 12}},
                                                Ioss::IJK_t{{1, 6, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3172", zones.back()->m_zone, "zone103", 103,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 6}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x7x30"));

  zones.back()->m_zoneConnectivity.emplace_back("B204", zones.back()->m_zone, "zone898", 898,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{5, 8, 31}}, Ioss::IJK_t{{1, 8, 31}},
                                                Ioss::IJK_t{{5, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B416", zones.back()->m_zone, "zone47", 47, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 31}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{5, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B428", zones.back()->m_zone, "zone91", 91, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{5, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A429", zones.back()->m_zone, "zone125", 125,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 31}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A430", zones.back()->m_zone, "zone513", 513, Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 8, 31}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A431", zones.back()->m_zone, "zone158", 158, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{5, 8, 31}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x10 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1803", zones.back()->m_zone, "zone1072", 1072,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{6, 1, 12}},
                                                Ioss::IJK_t{{1, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3172", zones.back()->m_zone, "zone101", 101,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A3173", zones.back()->m_zone, "zone104", 104,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 11}}, Ioss::IJK_t{{51, 6, 11}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3174", zones.back()->m_zone, "zone106", 106,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{1, 6, 11}},
                                                Ioss::IJK_t{{51, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A3175", zones.back()->m_zone, "zone176", 176,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{51, 11, 12}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x10 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1816", zones.back()->m_zone, "zone1075", 1075,
                                                Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 11}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{6, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3173", zones.back()->m_zone, "zone103", 103,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{51, 1, 11}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3176", zones.back()->m_zone, "zone105", 105,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3177", zones.back()->m_zone, "zone188", 188,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 11}}, Ioss::IJK_t{{1, 11, 12}},
                                                Ioss::IJK_t{{51, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3178", zones.back()->m_zone, "zone109", 109,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{51, 6, 6}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x10 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1854", zones.back()->m_zone, "zone1086", 1086,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{6, 1, 12}},
                                                Ioss::IJK_t{{1, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3176", zones.back()->m_zone, "zone104", 104,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3179", zones.back()->m_zone, "zone189", 189,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 11}}, Ioss::IJK_t{{1, 11, 12}},
                                                Ioss::IJK_t{{51, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3180", zones.back()->m_zone, "zone108", 108,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A3181", zones.back()->m_zone, "zone106", 106,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{1, 6, 11}},
                                                Ioss::IJK_t{{51, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x10 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1848", zones.back()->m_zone, "zone1084", 1084,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{6, 1, 12}},
                                                Ioss::IJK_t{{1, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3174", zones.back()->m_zone, "zone103", 103,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{1, 6, 11}},
                                                Ioss::IJK_t{{51, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B3181", zones.back()->m_zone, "zone105", 105,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 11}}, Ioss::IJK_t{{1, 6, 11}},
                                                Ioss::IJK_t{{51, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3182", zones.back()->m_zone, "zone107", 107,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A3183", zones.back()->m_zone, "zone177", 177,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 11}}, Ioss::IJK_t{{1, 11, 12}},
                                                Ioss::IJK_t{{51, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x5 "));

  zones.back()->m_zoneConnectivity.emplace_back("B3090", zones.back()->m_zone, "zone66", 66,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 6}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 6, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3182", zones.back()->m_zone, "zone106", 106,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 6}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3184", zones.back()->m_zone, "zone183", 183, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{1, 1, 12}}, Ioss::IJK_t{{51, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3185", zones.back()->m_zone, "zone108", 108,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 6}},
                                                Ioss::IJK_t{{51, 11, 6}}, Ioss::IJK_t{{51, 1, 6}},
                                                Ioss::IJK_t{{1, 11, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x5 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3093", zones.back()->m_zone, "zone67", 67, Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 11, 6}}, Ioss::IJK_t{{1, 1, 12}}, Ioss::IJK_t{{11, 6, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3180", zones.back()->m_zone, "zone105", 105,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 6}}, Ioss::IJK_t{{51, 1, 11}},
                                                Ioss::IJK_t{{1, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B3185", zones.back()->m_zone, "zone107", 107,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 6}},
                                                Ioss::IJK_t{{51, 11, 6}}, Ioss::IJK_t{{51, 1, 6}},
                                                Ioss::IJK_t{{1, 11, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3186", zones.back()->m_zone, "zone193", 193, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{1, 1, 12}}, Ioss::IJK_t{{51, 11, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x5 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1685", zones.back()->m_zone, "zone1043", 1043,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 6}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{12, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3168", zones.back()->m_zone, "zone100", 100, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 1, 6}}, Ioss::IJK_t{{51, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B3178", zones.back()->m_zone, "zone104", 104,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 6}}, Ioss::IJK_t{{51, 6, 11}},
                                                Ioss::IJK_t{{1, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A3187", zones.back()->m_zone, "zone110", 110,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 6}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3188", zones.back()->m_zone, "zone185", 185,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 6}},
                                                Ioss::IJK_t{{51, 6, 6}}, Ioss::IJK_t{{1, 6, 12}},
                                                Ioss::IJK_t{{51, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1673", zones.back()->m_zone, "zone1040", 1040,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3187", zones.back()->m_zone, "zone109", 109,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3189", zones.back()->m_zone, "zone111", 111, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3190", zones.back()->m_zone, "zone245", 245, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3191", zones.back()->m_zone, "zone184", 184,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 8, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2046", zones.back()->m_zone, "zone1141", 1141,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3167", zones.back()->m_zone, "zone100", 100,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3189", zones.back()->m_zone, "zone110", 110, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3192", zones.back()->m_zone, "zone112", 112,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3193", zones.back()->m_zone, "zone256", 256, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x30"));

  zones.back()->m_zoneConnectivity.emplace_back("B2048", zones.back()->m_zone, "zone1143", 1143,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3164", zones.back()->m_zone, "zone98", 98, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 31}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{51, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3192", zones.back()->m_zone, "zone111", 111,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3194", zones.back()->m_zone, "zone115", 115,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{51, 1, 31}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("A3195", zones.back()->m_zone, "zone259", 259,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B41", zones.back()->m_zone, "zone1386", 1386,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A50", zones.back()->m_zone, "zone224", 224, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A51", zones.back()->m_zone, "zone36", 36, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A52", zones.back()->m_zone, "zone335", 335, Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A53", zones.back()->m_zone, "zone690", 690, Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A54", zones.back()->m_zone, "zone692", 692, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 5}}, Ioss::IJK_t{{8, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x5"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B89", zones.back()->m_zone, "zone598", 598, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{12, 6, 6}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B93", zones.back()->m_zone, "zone610", 610, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{12, 6, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{12, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B425", zones.back()->m_zone, "zone80", 80, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 6}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A432", zones.back()->m_zone, "zone169", 169,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A433", zones.back()->m_zone, "zone136", 136,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 6}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A434", zones.back()->m_zone, "zone926", 926, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
      Ioss::IJK_t{{12, 6, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x30"));

  zones.back()->m_zoneConnectivity.emplace_back("B1979", zones.back()->m_zone, "zone1118", 1118,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 31}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3194", zones.back()->m_zone, "zone112", 112,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{51, 1, 31}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("A3196", zones.back()->m_zone, "zone116", 116,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{51, 31, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3197", zones.back()->m_zone, "zone118", 118,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 31}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("A3198", zones.back()->m_zone, "zone278", 278,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1997", zones.back()->m_zone, "zone1125", 1125,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3196", zones.back()->m_zone, "zone115", 115,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3199", zones.back()->m_zone, "zone117", 117,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3200", zones.back()->m_zone, "zone135", 135,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3201", zones.back()->m_zone, "zone289", 289, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 31, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1996", zones.back()->m_zone, "zone1124", 1124,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3199", zones.back()->m_zone, "zone116", 116,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3202", zones.back()->m_zone, "zone134", 134,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3203", zones.back()->m_zone, "zone120", 120,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3204", zones.back()->m_zone, "zone118", 118,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x30"));

  zones.back()->m_zoneConnectivity.emplace_back("B1975", zones.back()->m_zone, "zone1117", 1117,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{12, 8, 1}},
                                                Ioss::IJK_t{{12, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3163", zones.back()->m_zone, "zone98", 98,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{1, 8, 31}},
                                                Ioss::IJK_t{{51, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3197", zones.back()->m_zone, "zone115", 115,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 31}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3204", zones.back()->m_zone, "zone117", 117,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{51, 31, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3205", zones.back()->m_zone, "zone119", 119,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x30"));

  zones.back()->m_zoneConnectivity.emplace_back("B1971", zones.back()->m_zone, "zone1116", 1116,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 31}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3160", zones.back()->m_zone, "zone97", 97,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{51, 1, 31}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3205", zones.back()->m_zone, "zone118", 118,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("A3206", zones.back()->m_zone, "zone120", 120,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{51, 31, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3207", zones.back()->m_zone, "zone122", 122,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 31}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1991", zones.back()->m_zone, "zone1123", 1123,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3203", zones.back()->m_zone, "zone117", 117,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3206", zones.back()->m_zone, "zone119", 119,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3208", zones.back()->m_zone, "zone121", 121,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3209", zones.back()->m_zone, "zone133", 133, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1990", zones.back()->m_zone, "zone1122", 1122,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3208", zones.back()->m_zone, "zone120", 120,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3210", zones.back()->m_zone, "zone132", 132, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3211", zones.back()->m_zone, "zone124", 124,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3212", zones.back()->m_zone, "zone122", 122,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x30"));

  zones.back()->m_zoneConnectivity.emplace_back("B1957", zones.back()->m_zone, "zone1113", 1113,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3207", zones.back()->m_zone, "zone119", 119,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 31}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3212", zones.back()->m_zone, "zone121", 121,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{51, 31, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3213", zones.back()->m_zone, "zone139", 139,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{51, 1, 31}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("A3214", zones.back()->m_zone, "zone123", 123,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x30"));

  zones.back()->m_zoneConnectivity.emplace_back("B1964", zones.back()->m_zone, "zone1114", 1114,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 31}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3149", zones.back()->m_zone, "zone93", 93,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{51, 1, 31}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3214", zones.back()->m_zone, "zone122", 122,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("A3215", zones.back()->m_zone, "zone124", 124,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{51, 31, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3216", zones.back()->m_zone, "zone127", 127,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 31}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1985", zones.back()->m_zone, "zone1121", 1121,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3211", zones.back()->m_zone, "zone121", 121,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3215", zones.back()->m_zone, "zone123", 123,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3217", zones.back()->m_zone, "zone126", 126,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3218", zones.back()->m_zone, "zone129", 129,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x7x30 "));

  zones.back()->m_zoneConnectivity.emplace_back("B299", zones.back()->m_zone, "zone1142", 1142,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{12, 8, 31}}, Ioss::IJK_t{{12, 1, 31}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B419", zones.back()->m_zone, "zone58", 58, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{12, 8, 31}}, Ioss::IJK_t{{12, 8, 1}}, Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B429", zones.back()->m_zone, "zone102", 102,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 31}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A435", zones.back()->m_zone, "zone136", 136, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 8, 1}}, Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A436", zones.back()->m_zone, "zone180", 180, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 31}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{12, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A437", zones.back()->m_zone, "zone937", 937, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
      Ioss::IJK_t{{12, 8, 31}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 8, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1984", zones.back()->m_zone, "zone1119", 1119,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3217", zones.back()->m_zone, "zone124", 124,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3219", zones.back()->m_zone, "zone128", 128,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3220", zones.back()->m_zone, "zone367", 367, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 31, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3221", zones.back()->m_zone, "zone127", 127,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x30"));

  zones.back()->m_zoneConnectivity.emplace_back("B1966", zones.back()->m_zone, "zone1115", 1115,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3146", zones.back()->m_zone, "zone92", 92,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{51, 1, 31}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3216", zones.back()->m_zone, "zone123", 123,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 31}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3221", zones.back()->m_zone, "zone126", 126,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{51, 31, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3222", zones.back()->m_zone, "zone377", 377,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2016", zones.back()->m_zone, "zone1132", 1132,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3219", zones.back()->m_zone, "zone126", 126,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3223", zones.back()->m_zone, "zone129", 129,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3224", zones.back()->m_zone, "zone346", 346,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3225", zones.back()->m_zone, "zone130", 130,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2014", zones.back()->m_zone, "zone1130", 1130,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3218", zones.back()->m_zone, "zone124", 124,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3223", zones.back()->m_zone, "zone128", 128,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3226", zones.back()->m_zone, "zone132", 132,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 11, 8}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3227", zones.back()->m_zone, "zone130", 130,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2019", zones.back()->m_zone, "zone1133", 1133,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3225", zones.back()->m_zone, "zone128", 128, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3227", zones.back()->m_zone, "zone129", 129,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3228", zones.back()->m_zone, "zone345", 345, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3229", zones.back()->m_zone, "zone131", 131, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2024", zones.back()->m_zone, "zone1134", 1134,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{12, 8, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3229", zones.back()->m_zone, "zone130", 130, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{51, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3230", zones.back()->m_zone, "zone132", 132,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3231", zones.back()->m_zone, "zone332", 332, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3232", zones.back()->m_zone, "zone138", 138, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2012", zones.back()->m_zone, "zone1129", 1129,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3210", zones.back()->m_zone, "zone121", 121,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3226", zones.back()->m_zone, "zone129", 129,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 11, 8}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3230", zones.back()->m_zone, "zone131", 131,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3233", zones.back()->m_zone, "zone133", 133,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2008", zones.back()->m_zone, "zone1128", 1128,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3209", zones.back()->m_zone, "zone120", 120,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3233", zones.back()->m_zone, "zone132", 132,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3234", zones.back()->m_zone, "zone138", 138,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3235", zones.back()->m_zone, "zone134", 134,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 11, 8}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2004", zones.back()->m_zone, "zone1127", 1127,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3202", zones.back()->m_zone, "zone117", 117,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3235", zones.back()->m_zone, "zone133", 133,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 11, 8}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3236", zones.back()->m_zone, "zone135", 135,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3237", zones.back()->m_zone, "zone137", 137,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2002", zones.back()->m_zone, "zone1126", 1126,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3200", zones.back()->m_zone, "zone116", 116,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3236", zones.back()->m_zone, "zone134", 134,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3238", zones.back()->m_zone, "zone299", 299, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3239", zones.back()->m_zone, "zone137", 137,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B67", zones.back()->m_zone, "zone446", 446, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B420", zones.back()->m_zone, "zone69", 69, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B426", zones.back()->m_zone, "zone91", 91, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B433", zones.back()->m_zone, "zone114", 114,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{12, 1, 6}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B435", zones.back()->m_zone, "zone125", 125, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A438", zones.back()->m_zone, "zone938", 938,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2029", zones.back()->m_zone, "zone1136", 1136,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3237", zones.back()->m_zone, "zone134", 134,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3239", zones.back()->m_zone, "zone135", 135, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3240", zones.back()->m_zone, "zone311", 311, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3241", zones.back()->m_zone, "zone138", 138,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2025", zones.back()->m_zone, "zone1135", 1135,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3232", zones.back()->m_zone, "zone131", 131, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{51, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3234", zones.back()->m_zone, "zone133", 133,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3241", zones.back()->m_zone, "zone137", 137,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3242", zones.back()->m_zone, "zone314", 314,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x30"));

  zones.back()->m_zoneConnectivity.emplace_back("B2083", zones.back()->m_zone, "zone1155", 1155,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 31}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3150", zones.back()->m_zone, "zone93", 93, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3155", zones.back()->m_zone, "zone95", 95, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3159", zones.back()->m_zone, "zone97", 97, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 31}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3213", zones.back()->m_zone, "zone122", 122,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{51, 8, 31}}, Ioss::IJK_t{{51, 1, 31}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1704", zones.back()->m_zone, "zone1047", 1047,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3166", zones.back()->m_zone, "zone99", 99, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3170", zones.back()->m_zone, "zone101", 101,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A3243", zones.back()->m_zone, "zone141", 141,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3244", zones.back()->m_zone, "zone170", 170,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 8, 12}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1712", zones.back()->m_zone, "zone1049", 1049,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3156", zones.back()->m_zone, "zone96", 96, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3243", zones.back()->m_zone, "zone140", 140,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3245", zones.back()->m_zone, "zone142", 142,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3246", zones.back()->m_zone, "zone168", 168,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 8, 12}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1722", zones.back()->m_zone, "zone1051", 1051,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3154", zones.back()->m_zone, "zone95", 95, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3245", zones.back()->m_zone, "zone141", 141,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3247", zones.back()->m_zone, "zone143", 143,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3248", zones.back()->m_zone, "zone154", 154,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 8, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1731", zones.back()->m_zone, "zone1055", 1055,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3123", zones.back()->m_zone, "zone81", 81, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3152", zones.back()->m_zone, "zone94", 94, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3247", zones.back()->m_zone, "zone142", 142,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3249", zones.back()->m_zone, "zone156", 156,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 8, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3058", zones.back()->m_zone, "zone49", 49, Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{51, 1, 1}},
      Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 12, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3144", zones.back()->m_zone, "zone90", 90, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 12}},
      Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3250", zones.back()->m_zone, "zone145", 145, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3251", zones.back()->m_zone, "zone148", 148,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3063", zones.back()->m_zone, "zone51", 51, Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{51, 1, 1}},
      Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3250", zones.back()->m_zone, "zone144", 144, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3252", zones.back()->m_zone, "zone452", 452,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3253", zones.back()->m_zone, "zone146", 146,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2807", zones.back()->m_zone, "zone1427", 1427,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3253", zones.back()->m_zone, "zone145", 145,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3254", zones.back()->m_zone, "zone148", 148,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3255", zones.back()->m_zone, "zone451", 451,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3256", zones.back()->m_zone, "zone150", 150,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B70", zones.back()->m_zone, "zone554", 554, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B422", zones.back()->m_zone, "zone80", 80, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A439", zones.back()->m_zone, "zone169", 169, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A440", zones.back()->m_zone, "zone158", 158, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A441", zones.back()->m_zone, "zone400", 400, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A442", zones.back()->m_zone, "zone794", 794, Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2817", zones.back()->m_zone, "zone1430", 1430,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 12}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{12, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3139", zones.back()->m_zone, "zone87", 87,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{51, 6, 11}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3251", zones.back()->m_zone, "zone144", 144,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3254", zones.back()->m_zone, "zone146", 146,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3257", zones.back()->m_zone, "zone149", 149,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2822", zones.back()->m_zone, "zone1433", 1433,
                                                Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{12, 1, 11}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3136", zones.back()->m_zone, "zone86", 86, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 12}},
      Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{51, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B3257", zones.back()->m_zone, "zone148", 148,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3258", zones.back()->m_zone, "zone150", 150,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3259", zones.back()->m_zone, "zone153", 153,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2814", zones.back()->m_zone, "zone1429", 1429,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3256", zones.back()->m_zone, "zone146", 146,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3258", zones.back()->m_zone, "zone149", 149,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3260", zones.back()->m_zone, "zone152", 152,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3261", zones.back()->m_zone, "zone439", 439, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 11, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2789", zones.back()->m_zone, "zone1422", 1422,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 12}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3131", zones.back()->m_zone, "zone84", 84, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 12}},
      Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3262", zones.back()->m_zone, "zone152", 152,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{51, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3263", zones.back()->m_zone, "zone153", 153, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{51, 6, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3264", zones.back()->m_zone, "zone426", 426, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2798", zones.back()->m_zone, "zone1425", 1425,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3260", zones.back()->m_zone, "zone150", 150,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3262", zones.back()->m_zone, "zone151", 151,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3265", zones.back()->m_zone, "zone153", 153,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3266", zones.back()->m_zone, "zone433", 433,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 6, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2779", zones.back()->m_zone, "zone1419", 1419,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 12}}, Ioss::IJK_t{{1, 1, 6}},
                                                Ioss::IJK_t{{12, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3133", zones.back()->m_zone, "zone85", 85,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 6, 12}}, Ioss::IJK_t{{1, 6, 6}},
                                                Ioss::IJK_t{{51, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B3259", zones.back()->m_zone, "zone149", 149,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3263", zones.back()->m_zone, "zone151", 151, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{51, 6, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3265", zones.back()->m_zone, "zone152", 152,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2487", zones.back()->m_zone, "zone1293", 1293,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 12}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3248", zones.back()->m_zone, "zone142", 142,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3267", zones.back()->m_zone, "zone155", 155,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{51, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3268", zones.back()->m_zone, "zone168", 168, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{51, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3269", zones.back()->m_zone, "zone156", 156,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2530", zones.back()->m_zone, "zone1312", 1312,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3267", zones.back()->m_zone, "zone154", 154,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3270", zones.back()->m_zone, "zone173", 173,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3271", zones.back()->m_zone, "zone161", 161,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3272", zones.back()->m_zone, "zone157", 157,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 6, 8}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2499", zones.back()->m_zone, "zone1297", 1297,
                                                Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3249", zones.back()->m_zone, "zone143", 143,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3269", zones.back()->m_zone, "zone154", 154,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3273", zones.back()->m_zone, "zone157", 157,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3274", zones.back()->m_zone, "zone159", 159,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2540", zones.back()->m_zone, "zone1316", 1316,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3272", zones.back()->m_zone, "zone155", 155,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 6, 8}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3273", zones.back()->m_zone, "zone156", 156,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3275", zones.back()->m_zone, "zone159", 159,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3276", zones.back()->m_zone, "zone194", 194,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x7x30"));

  zones.back()->m_zoneConnectivity.emplace_back("B208", zones.back()->m_zone, "zone909", 909,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{5, 8, 31}}, Ioss::IJK_t{{5, 1, 31}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B431", zones.back()->m_zone, "zone102", 102, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 31}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{5, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B440", zones.back()->m_zone, "zone147", 147, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A443", zones.back()->m_zone, "zone180", 180,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 31}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A444", zones.back()->m_zone, "zone757", 757, Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 8, 31}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A445", zones.back()->m_zone, "zone384", 384, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{5, 8, 31}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{5, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2277", zones.back()->m_zone, "zone1215", 1215,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 12}}, Ioss::IJK_t{{1, 1, 6}},
                                                Ioss::IJK_t{{12, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3122", zones.back()->m_zone, "zone81", 81,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 6, 12}}, Ioss::IJK_t{{1, 6, 6}},
                                                Ioss::IJK_t{{51, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B3274", zones.back()->m_zone, "zone156", 156,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3275", zones.back()->m_zone, "zone157", 157,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3277", zones.back()->m_zone, "zone160", 160,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 12}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2553", zones.back()->m_zone, "zone1322", 1322,
                                                Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{12, 1, 11}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3118", zones.back()->m_zone, "zone79", 79, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 12}},
      Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{51, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3277", zones.back()->m_zone, "zone159", 159,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{51, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3278", zones.back()->m_zone, "zone194", 194,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3279", zones.back()->m_zone, "zone164", 164,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2535", zones.back()->m_zone, "zone1314", 1314,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3271", zones.back()->m_zone, "zone155", 155,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3280", zones.back()->m_zone, "zone174", 174,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3281", zones.back()->m_zone, "zone194", 194,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 11, 8}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3282", zones.back()->m_zone, "zone162", 162,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2419", zones.back()->m_zone, "zone1267", 1267,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3282", zones.back()->m_zone, "zone161", 161,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3283", zones.back()->m_zone, "zone179", 179,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3284", zones.back()->m_zone, "zone167", 167,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3285", zones.back()->m_zone, "zone163", 163,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 11, 8}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2427", zones.back()->m_zone, "zone1269", 1269,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3285", zones.back()->m_zone, "zone162", 162,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 11, 8}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3286", zones.back()->m_zone, "zone164", 164,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3287", zones.back()->m_zone, "zone194", 194,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3288", zones.back()->m_zone, "zone166", 166,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2546", zones.back()->m_zone, "zone1319", 1319,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 12}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{12, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3141", zones.back()->m_zone, "zone88", 88, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 12}},
      Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{51, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3279", zones.back()->m_zone, "zone160", 160,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3286", zones.back()->m_zone, "zone163", 163,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3289", zones.back()->m_zone, "zone165", 165,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3010", zones.back()->m_zone, "zone24", 24, Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 11, 12}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 12, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3142", zones.back()->m_zone, "zone89", 89, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 12}},
      Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3289", zones.back()->m_zone, "zone164", 164, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3290", zones.back()->m_zone, "zone166", 166,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3008", zones.back()->m_zone, "zone23", 23, Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{51, 1, 1}},
      Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3288", zones.back()->m_zone, "zone163", 163, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3290", zones.back()->m_zone, "zone165", 165,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3291", zones.back()->m_zone, "zone167", 167, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 11, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2995", zones.back()->m_zone, "zone18", 18, Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{51, 1, 1}},
      Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3284", zones.back()->m_zone, "zone162", 162,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3291", zones.back()->m_zone, "zone166", 166, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3292", zones.back()->m_zone, "zone181", 181,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2474", zones.back()->m_zone, "zone1289", 1289,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 12}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3246", zones.back()->m_zone, "zone141", 141,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{51, 6, 8}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3268", zones.back()->m_zone, "zone154", 154, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3293", zones.back()->m_zone, "zone173", 173,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{1, 6, 8}},
                                                Ioss::IJK_t{{51, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3294", zones.back()->m_zone, "zone170", 170,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B76", zones.back()->m_zone, "zone565", 565, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B432", zones.back()->m_zone, "zone114", 114,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B439", zones.back()->m_zone, "zone147", 147, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A446", zones.back()->m_zone, "zone927", 927, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A447", zones.back()->m_zone, "zone180", 180,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A448", zones.back()->m_zone, "zone399", 399, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{12, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2462", zones.back()->m_zone, "zone1284", 1284,
                                                Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3244", zones.back()->m_zone, "zone140", 140,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{51, 6, 8}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3294", zones.back()->m_zone, "zone168", 168,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3295", zones.back()->m_zone, "zone172", 172,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3296", zones.back()->m_zone, "zone171", 171, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2451", zones.back()->m_zone, "zone1280", 1280,
                                                Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 12}}, Ioss::IJK_t{{12, 1, 6}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3171", zones.back()->m_zone, "zone101", 101,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 6, 12}}, Ioss::IJK_t{{51, 1, 6}},
                                                Ioss::IJK_t{{1, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3296", zones.back()->m_zone, "zone170", 170, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{51, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3297", zones.back()->m_zone, "zone172", 172,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3298", zones.back()->m_zone, "zone176", 176,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 12}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2510", zones.back()->m_zone, "zone1303", 1303,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3295", zones.back()->m_zone, "zone170", 170,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3297", zones.back()->m_zone, "zone171", 171,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3299", zones.back()->m_zone, "zone173", 173,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 6, 8}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3300", zones.back()->m_zone, "zone175", 175,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2522", zones.back()->m_zone, "zone1307", 1307,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3270", zones.back()->m_zone, "zone155", 155,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3293", zones.back()->m_zone, "zone168", 168,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3299", zones.back()->m_zone, "zone172", 172,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 6, 8}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3301", zones.back()->m_zone, "zone174", 174,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2526", zones.back()->m_zone, "zone1310", 1310,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3280", zones.back()->m_zone, "zone161", 161,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3301", zones.back()->m_zone, "zone173", 173,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3302", zones.back()->m_zone, "zone175", 175,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 11, 8}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3303", zones.back()->m_zone, "zone179", 179,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2515", zones.back()->m_zone, "zone1305", 1305,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3300", zones.back()->m_zone, "zone172", 172,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3302", zones.back()->m_zone, "zone174", 174,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 11, 8}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3304", zones.back()->m_zone, "zone176", 176,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3305", zones.back()->m_zone, "zone178", 178,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2441", zones.back()->m_zone, "zone1274", 1274,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 12}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{12, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3175", zones.back()->m_zone, "zone103", 103,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{51, 6, 11}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3298", zones.back()->m_zone, "zone171", 171,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{51, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3304", zones.back()->m_zone, "zone175", 175,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3306", zones.back()->m_zone, "zone177", 177,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2435", zones.back()->m_zone, "zone1272", 1272,
                                                Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{12, 1, 11}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3183", zones.back()->m_zone, "zone106", 106,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{51, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3306", zones.back()->m_zone, "zone176", 176,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3307", zones.back()->m_zone, "zone178", 178,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3308", zones.back()->m_zone, "zone183", 183,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2260", zones.back()->m_zone, "zone1210", 1210,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3305", zones.back()->m_zone, "zone175", 175,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3307", zones.back()->m_zone, "zone177", 177,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3309", zones.back()->m_zone, "zone179", 179,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 11, 8}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3310", zones.back()->m_zone, "zone182", 182,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2432", zones.back()->m_zone, "zone1271", 1271,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3283", zones.back()->m_zone, "zone162", 162,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3303", zones.back()->m_zone, "zone174", 174,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3309", zones.back()->m_zone, "zone178", 178,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 11, 8}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3311", zones.back()->m_zone, "zone181", 181,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x7x30 "));

  zones.back()->m_zoneConnectivity.emplace_back("B301", zones.back()->m_zone, "zone1153", 1153,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{12, 8, 31}}, Ioss::IJK_t{{1, 8, 31}},
                                                Ioss::IJK_t{{12, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B436", zones.back()->m_zone, "zone125", 125, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{12, 8, 31}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{12, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B443", zones.back()->m_zone, "zone158", 158,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 31}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B447", zones.back()->m_zone, "zone169", 169,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 1}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A449", zones.back()->m_zone, "zone386", 386,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 31}}, Ioss::IJK_t{{12, 31, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A450", zones.back()->m_zone, "zone936", 936,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 31}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{51, 1, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2993", zones.back()->m_zone, "zone17", 17, Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3292", zones.back()->m_zone, "zone167", 167,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3311", zones.back()->m_zone, "zone179", 179,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3312", zones.back()->m_zone, "zone182", 182, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 11, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2988", zones.back()->m_zone, "zone15", 15, Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3310", zones.back()->m_zone, "zone178", 178, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3312", zones.back()->m_zone, "zone181", 181, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3313", zones.back()->m_zone, "zone183", 183,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2978", zones.back()->m_zone, "zone11", 11, Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{51, 1, 1}},
      Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 12, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3184", zones.back()->m_zone, "zone107", 107,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3308", zones.back()->m_zone, "zone177", 177, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3313", zones.back()->m_zone, "zone182", 182,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x11 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2963", zones.back()->m_zone, "zone4", 4, Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{51, 1, 1}},
      Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3191", zones.back()->m_zone, "zone110", 110,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3314", zones.back()->m_zone, "zone186", 186,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{51, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3315", zones.back()->m_zone, "zone185", 185, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{51, 6, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3316", zones.back()->m_zone, "zone223", 223,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x11 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2968", zones.back()->m_zone, "zone6", 6, Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{51, 1, 1}},
      Ioss::IJK_t{{51, 6, 12}}, Ioss::IJK_t{{12, 1, 6}}, Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3188", zones.back()->m_zone, "zone109", 109,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 6, 12}}, Ioss::IJK_t{{1, 6, 6}},
                                                Ioss::IJK_t{{51, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3315", zones.back()->m_zone, "zone184", 184, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{51, 6, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3317", zones.back()->m_zone, "zone186", 186,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3318", zones.back()->m_zone, "zone188", 188,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2131", zones.back()->m_zone, "zone1172", 1172,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3314", zones.back()->m_zone, "zone184", 184,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3317", zones.back()->m_zone, "zone185", 185,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3319", zones.back()->m_zone, "zone187", 187,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3320", zones.back()->m_zone, "zone217", 217, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2123", zones.back()->m_zone, "zone1170", 1170,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3319", zones.back()->m_zone, "zone186", 186,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3321", zones.back()->m_zone, "zone188", 188,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3322", zones.back()->m_zone, "zone210", 210,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3323", zones.back()->m_zone, "zone190", 190,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2921", zones.back()->m_zone, "zone1476", 1476,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 12}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{12, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3177", zones.back()->m_zone, "zone104", 104,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{51, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3318", zones.back()->m_zone, "zone185", 185,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3321", zones.back()->m_zone, "zone187", 187,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3324", zones.back()->m_zone, "zone189", 189,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2175", zones.back()->m_zone, "zone1184", 1184,
                                                Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{12, 1, 11}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3179", zones.back()->m_zone, "zone105", 105,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{51, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3324", zones.back()->m_zone, "zone188", 188,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3325", zones.back()->m_zone, "zone190", 190,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3326", zones.back()->m_zone, "zone193", 193,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2976", zones.back()->m_zone, "zone10", 10, Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3323", zones.back()->m_zone, "zone187", 187,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3325", zones.back()->m_zone, "zone189", 189,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3327", zones.back()->m_zone, "zone192", 192,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3328", zones.back()->m_zone, "zone204", 204, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 11, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "A451", zones.back()->m_zone, "zone826", 826, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A452", zones.back()->m_zone, "zone853", 853, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A453", zones.back()->m_zone, "zone206", 206, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A454", zones.back()->m_zone, "zone213", 213, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
      Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A455", zones.back()->m_zone, "zone202", 202,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3115", zones.back()->m_zone, "zone78", 78, Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3327", zones.back()->m_zone, "zone190", 190,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3329", zones.back()->m_zone, "zone196", 196,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3330", zones.back()->m_zone, "zone193", 193, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 11, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x11 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3113", zones.back()->m_zone, "zone77", 77, Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 11, 12}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 12, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3186", zones.back()->m_zone, "zone108", 108,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 11, 12}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3326", zones.back()->m_zone, "zone189", 189,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3330", zones.back()->m_zone, "zone192", 192, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 11, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2544", zones.back()->m_zone, "zone1318", 1318,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3276", zones.back()->m_zone, "zone157", 157,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3278", zones.back()->m_zone, "zone160", 160,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3281", zones.back()->m_zone, "zone161", 161,
                                                Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 11, 8}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3287", zones.back()->m_zone, "zone163", 163,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1664", zones.back()->m_zone, "zone1036", 1036,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3331", zones.back()->m_zone, "zone197", 197,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3332", zones.back()->m_zone, "zone205", 205,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3333", zones.back()->m_zone, "zone196", 196,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B3329", zones.back()->m_zone, "zone192", 192,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3333", zones.back()->m_zone, "zone195", 195,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3334", zones.back()->m_zone, "zone204", 204,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3335", zones.back()->m_zone, "zone198", 198,
                                                Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B1451", zones.back()->m_zone, "zone923", 923,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B3331", zones.back()->m_zone, "zone195", 195,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3336", zones.back()->m_zone, "zone547", 547, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3337", zones.back()->m_zone, "zone201", 201,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3338", zones.back()->m_zone, "zone198", 198,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3116", zones.back()->m_zone, "zone78", 78, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3335", zones.back()->m_zone, "zone196", 196, Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3338", zones.back()->m_zone, "zone197", 197,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A3339", zones.back()->m_zone, "zone203", 203,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 6}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3340", zones.back()->m_zone, "zone549", 549, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2973", zones.back()->m_zone, "zone9", 9, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3341", zones.back()->m_zone, "zone207", 207, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3342", zones.back()->m_zone, "zone200", 200,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3343", zones.back()->m_zone, "zone553", 553,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3344", zones.back()->m_zone, "zone203", 203,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1308", zones.back()->m_zone, "zone853", 853, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3342", zones.back()->m_zone, "zone199", 199,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3345", zones.back()->m_zone, "zone551", 551, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3346", zones.back()->m_zone, "zone206", 206,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3347", zones.back()->m_zone, "zone201", 201,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1311", zones.back()->m_zone, "zone855", 855, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3337", zones.back()->m_zone, "zone197", 197,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B3347", zones.back()->m_zone, "zone200", 200,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3348", zones.back()->m_zone, "zone208", 208, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3349", zones.back()->m_zone, "zone205", 205,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3350", zones.back()->m_zone, "zone203", 203,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B455", zones.back()->m_zone, "zone191", 191,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A456", zones.back()->m_zone, "zone825", 825, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{12, 1, 11}}, Ioss::IJK_t{{12, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A457", zones.back()->m_zone, "zone225", 225, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A458", zones.back()->m_zone, "zone1032", 1032,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A459", zones.back()->m_zone, "zone208", 208, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A460", zones.back()->m_zone, "zone855", 855, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
      Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2977", zones.back()->m_zone, "zone10", 10, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3339", zones.back()->m_zone, "zone198", 198,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B3344", zones.back()->m_zone, "zone199", 199,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3350", zones.back()->m_zone, "zone201", 201,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3351", zones.back()->m_zone, "zone204", 204,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3352", zones.back()->m_zone, "zone209", 209,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3328", zones.back()->m_zone, "zone190", 190, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3334", zones.back()->m_zone, "zone196", 196,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3351", zones.back()->m_zone, "zone203", 203,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3353", zones.back()->m_zone, "zone205", 205,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3354", zones.back()->m_zone, "zone210", 210,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1663", zones.back()->m_zone, "zone1035", 1035,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3332", zones.back()->m_zone, "zone195", 195,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3349", zones.back()->m_zone, "zone201", 201,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3353", zones.back()->m_zone, "zone204", 204,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3355", zones.back()->m_zone, "zone211", 211,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B453", zones.back()->m_zone, "zone191", 191, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3346", zones.back()->m_zone, "zone200", 200, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3356", zones.back()->m_zone, "zone207", 207,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3357", zones.back()->m_zone, "zone214", 214,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3358", zones.back()->m_zone, "zone208", 208,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2118", zones.back()->m_zone, "zone1169", 1169,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3341", zones.back()->m_zone, "zone199", 199,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3356", zones.back()->m_zone, "zone206", 206,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3359", zones.back()->m_zone, "zone212", 212, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3360", zones.back()->m_zone, "zone209", 209,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B459", zones.back()->m_zone, "zone202", 202, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3348", zones.back()->m_zone, "zone201", 201,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3358", zones.back()->m_zone, "zone206", 206,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3361", zones.back()->m_zone, "zone215", 215, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3362", zones.back()->m_zone, "zone211", 211,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3363", zones.back()->m_zone, "zone209", 209,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2124", zones.back()->m_zone, "zone1170", 1170,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3352", zones.back()->m_zone, "zone203", 203, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3360", zones.back()->m_zone, "zone207", 207,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3363", zones.back()->m_zone, "zone208", 208,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3364", zones.back()->m_zone, "zone210", 210,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3365", zones.back()->m_zone, "zone216", 216,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B3322", zones.back()->m_zone, "zone187", 187,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 11, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3354", zones.back()->m_zone, "zone204", 204, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3364", zones.back()->m_zone, "zone209", 209,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3366", zones.back()->m_zone, "zone211", 211,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3367", zones.back()->m_zone, "zone217", 217,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1657", zones.back()->m_zone, "zone1032", 1032,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 11, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3355", zones.back()->m_zone, "zone205", 205, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3362", zones.back()->m_zone, "zone208", 208,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3366", zones.back()->m_zone, "zone210", 210,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3368", zones.back()->m_zone, "zone218", 218,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2128", zones.back()->m_zone, "zone1171", 1171,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3359", zones.back()->m_zone, "zone207", 207, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3369", zones.back()->m_zone, "zone220", 220, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3370", zones.back()->m_zone, "zone214", 214,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3371", zones.back()->m_zone, "zone216", 216,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B454", zones.back()->m_zone, "zone191", 191, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A461", zones.back()->m_zone, "zone851", 851, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{12, 1, 6}}, Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A462", zones.back()->m_zone, "zone214", 214, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A463", zones.back()->m_zone, "zone849", 849,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A464", zones.back()->m_zone, "zone225", 225,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B462", zones.back()->m_zone, "zone213", 213, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3357", zones.back()->m_zone, "zone206", 206, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3370", zones.back()->m_zone, "zone212", 212,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3372", zones.back()->m_zone, "zone219", 219, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3373", zones.back()->m_zone, "zone215", 215,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B468", zones.back()->m_zone, "zone225", 225, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3361", zones.back()->m_zone, "zone208", 208, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3373", zones.back()->m_zone, "zone214", 214,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3374", zones.back()->m_zone, "zone222", 222, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3375", zones.back()->m_zone, "zone218", 218,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{51, 6, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3376", zones.back()->m_zone, "zone216", 216,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2132", zones.back()->m_zone, "zone1172", 1172,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3365", zones.back()->m_zone, "zone209", 209, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3371", zones.back()->m_zone, "zone212", 212,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3376", zones.back()->m_zone, "zone215", 215,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3377", zones.back()->m_zone, "zone217", 217,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3378", zones.back()->m_zone, "zone221", 221, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3320", zones.back()->m_zone, "zone186", 186, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3367", zones.back()->m_zone, "zone210", 210, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3377", zones.back()->m_zone, "zone216", 216,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3379", zones.back()->m_zone, "zone218", 218,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3380", zones.back()->m_zone, "zone223", 223,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1655", zones.back()->m_zone, "zone1030", 1030,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3368", zones.back()->m_zone, "zone211", 211, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3375", zones.back()->m_zone, "zone215", 215,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3379", zones.back()->m_zone, "zone217", 217,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3381", zones.back()->m_zone, "zone226", 226,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1301", zones.back()->m_zone, "zone849", 849,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3372", zones.back()->m_zone, "zone214", 214, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3382", zones.back()->m_zone, "zone220", 220,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3383", zones.back()->m_zone, "zone227", 227,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3384", zones.back()->m_zone, "zone222", 222,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2966", zones.back()->m_zone, "zone5", 5, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3369", zones.back()->m_zone, "zone212", 212,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3382", zones.back()->m_zone, "zone219", 219,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3385", zones.back()->m_zone, "zone228", 228,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3386", zones.back()->m_zone, "zone221", 221,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2962", zones.back()->m_zone, "zone4", 4, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3378", zones.back()->m_zone, "zone216", 216, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3386", zones.back()->m_zone, "zone220", 220,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3387", zones.back()->m_zone, "zone223", 223,
                                                Ioss::IJK_t{{3, -1, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3388", zones.back()->m_zone, "zone222", 222,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3389", zones.back()->m_zone, "zone229", 229,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1297", zones.back()->m_zone, "zone848", 848,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3374", zones.back()->m_zone, "zone215", 215,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3384", zones.back()->m_zone, "zone219", 219,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3388", zones.back()->m_zone, "zone221", 221,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3390", zones.back()->m_zone, "zone230", 230,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3391", zones.back()->m_zone, "zone226", 226,
                                                Ioss::IJK_t{{-3, 1, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{51, 8, 12}},
                                                Ioss::IJK_t{{51, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B3316", zones.back()->m_zone, "zone184", 184,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3380", zones.back()->m_zone, "zone217", 217,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{1, 6, 8}},
                                                Ioss::IJK_t{{51, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3387", zones.back()->m_zone, "zone221", 221,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 12}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3392", zones.back()->m_zone, "zone226", 226,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3393", zones.back()->m_zone, "zone245", 245,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{51, 6, 8}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B46", zones.back()->m_zone, "zone2", 2, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B50", zones.back()->m_zone, "zone113", 113, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A55", zones.back()->m_zone, "zone986", 986, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A56", zones.back()->m_zone, "zone69", 69, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A57", zones.back()->m_zone, "zone446", 446, Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A58", zones.back()->m_zone, "zone645", 645, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B457", zones.back()->m_zone, "zone202", 202, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B464", zones.back()->m_zone, "zone213", 213,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A465", zones.back()->m_zone, "zone850", 850, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A466", zones.back()->m_zone, "zone848", 848,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A467", zones.back()->m_zone, "zone1030", 1030,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{51, 6, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A468", zones.back()->m_zone, "zone215", 215, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1651", zones.back()->m_zone, "zone1028", 1028,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3381", zones.back()->m_zone, "zone218", 218,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{1, 6, 8}},
                                                Ioss::IJK_t{{51, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3391", zones.back()->m_zone, "zone222", 222,
                                                Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3392", zones.back()->m_zone, "zone223", 223,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3394", zones.back()->m_zone, "zone244", 244,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{51, 6, 8}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1296", zones.back()->m_zone, "zone847", 847,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 12}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3383", zones.back()->m_zone, "zone219", 219,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3395", zones.back()->m_zone, "zone228", 228, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 12}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3396", zones.back()->m_zone, "zone233", 233,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{8, 101, 12}}, Ioss::IJK_t{{8, 1, 5}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A3397", zones.back()->m_zone, "zone230", 230,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 12}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x11 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2960", zones.back()->m_zone, "zone1496", 1496,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 12}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3385", zones.back()->m_zone, "zone220", 220,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3395", zones.back()->m_zone, "zone227", 227, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3398", zones.back()->m_zone, "zone234", 234,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{8, 101, 12}}, Ioss::IJK_t{{8, 1, 5}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A3399", zones.back()->m_zone, "zone229", 229,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 12}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x11"));

  zones.back()->m_zoneConnectivity.emplace_back("B2958", zones.back()->m_zone, "zone1495", 1495,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 12}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3389", zones.back()->m_zone, "zone221", 221,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3399", zones.back()->m_zone, "zone228", 228,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 12}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3400", zones.back()->m_zone, "zone230", 230, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 12}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3401", zones.back()->m_zone, "zone243", 243,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 12}}, Ioss::IJK_t{{1, 6, 8}},
                                                Ioss::IJK_t{{12, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3402", zones.back()->m_zone, "zone232", 232,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{8, 6, 12}}, Ioss::IJK_t{{8, 1, 5}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x11"));

  zones.back()->m_zoneConnectivity.emplace_back("B1292", zones.back()->m_zone, "zone846", 846,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 12}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3390", zones.back()->m_zone, "zone222", 222,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3397", zones.back()->m_zone, "zone227", 227,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 12}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3400", zones.back()->m_zone, "zone229", 229, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 12}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3403", zones.back()->m_zone, "zone242", 242,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 12}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3404", zones.back()->m_zone, "zone231", 231,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{8, 6, 12}}, Ioss::IJK_t{{8, 1, 5}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x4"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1290", zones.back()->m_zone, "zone845", 845, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3404", zones.back()->m_zone, "zone230", 230,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{8, 1, 12}},
                                                Ioss::IJK_t{{1, 6, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3405", zones.back()->m_zone, "zone239", 239,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3406", zones.back()->m_zone, "zone232", 232, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 5}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A3407", zones.back()->m_zone, "zone241", 241,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 5}}, Ioss::IJK_t{{1, 6, 8}},
                                                Ioss::IJK_t{{5, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3408", zones.back()->m_zone, "zone233", 233,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x4"));

  zones.back()->m_zoneConnectivity.emplace_back("B2956", zones.back()->m_zone, "zone1494", 1494,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 5}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3402", zones.back()->m_zone, "zone229", 229,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{8, 1, 12}},
                                                Ioss::IJK_t{{1, 6, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3406", zones.back()->m_zone, "zone231", 231, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A3409", zones.back()->m_zone, "zone238", 238,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3410", zones.back()->m_zone, "zone240", 240,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 5}}, Ioss::IJK_t{{5, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3411", zones.back()->m_zone, "zone234", 234,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x4 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1288", zones.back()->m_zone, "zone844", 844, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 5}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3396", zones.back()->m_zone, "zone227", 227,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{8, 1, 12}},
                                                Ioss::IJK_t{{1, 101, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3408", zones.back()->m_zone, "zone231", 231,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A3412", zones.back()->m_zone, "zone237", 237,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3413", zones.back()->m_zone, "zone234", 234, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x4 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2952", zones.back()->m_zone, "zone1493", 1493,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3398", zones.back()->m_zone, "zone228", 228,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{8, 1, 12}},
                                                Ioss::IJK_t{{1, 101, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3411", zones.back()->m_zone, "zone232", 232,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3413", zones.back()->m_zone, "zone233", 233, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 5}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A3414", zones.back()->m_zone, "zone235", 235,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2947", zones.back()->m_zone, "zone1491", 1491,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3414", zones.back()->m_zone, "zone234", 234,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3415", zones.back()->m_zone, "zone248", 248, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3416", zones.back()->m_zone, "zone237", 237,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3417", zones.back()->m_zone, "zone238", 238,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "A469", zones.back()->m_zone, "zone280", 280, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{6, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A470", zones.back()->m_zone, "zone590", 590, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{8, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A471", zones.back()->m_zone, "zone369", 369, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A472", zones.back()->m_zone, "zone833", 833, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A473", zones.back()->m_zone, "zone247", 247,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1283", zones.back()->m_zone, "zone841", 841, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3412", zones.back()->m_zone, "zone233", 233,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3416", zones.back()->m_zone, "zone235", 235,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3418", zones.back()->m_zone, "zone246", 246, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3419", zones.back()->m_zone, "zone239", 239,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2951", zones.back()->m_zone, "zone1492", 1492,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3409", zones.back()->m_zone, "zone232", 232,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3417", zones.back()->m_zone, "zone235", 235,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3420", zones.back()->m_zone, "zone240", 240,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{5, 6, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3421", zones.back()->m_zone, "zone239", 239,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3422", zones.back()->m_zone, "zone250", 250, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1285", zones.back()->m_zone, "zone842", 842, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3405", zones.back()->m_zone, "zone231", 231,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3419", zones.back()->m_zone, "zone237", 237,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3421", zones.back()->m_zone, "zone238", 238,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3423", zones.back()->m_zone, "zone249", 249, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3424", zones.back()->m_zone, "zone241", 241,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1669", zones.back()->m_zone, "zone1039", 1039,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3410", zones.back()->m_zone, "zone232", 232,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3420", zones.back()->m_zone, "zone238", 238,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3425", zones.back()->m_zone, "zone243", 243, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3426", zones.back()->m_zone, "zone252", 252, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{5, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3427", zones.back()->m_zone, "zone241", 241,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B4", zones.back()->m_zone, "zone1", 1, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{5, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3407", zones.back()->m_zone, "zone231", 231,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3424", zones.back()->m_zone, "zone239", 239,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3427", zones.back()->m_zone, "zone240", 240,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3428", zones.back()->m_zone, "zone251", 251, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{5, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3429", zones.back()->m_zone, "zone242", 242, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B9", zones.back()->m_zone, "zone609", 609, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3403", zones.back()->m_zone, "zone230", 230,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{8, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3429", zones.back()->m_zone, "zone241", 241, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3430", zones.back()->m_zone, "zone253", 253, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3431", zones.back()->m_zone, "zone243", 243,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3432", zones.back()->m_zone, "zone244", 244,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1675", zones.back()->m_zone, "zone1040", 1040,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3401", zones.back()->m_zone, "zone229", 229,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3425", zones.back()->m_zone, "zone240", 240,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3431", zones.back()->m_zone, "zone242", 242,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3433", zones.back()->m_zone, "zone245", 245, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3434", zones.back()->m_zone, "zone254", 254, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1525", zones.back()->m_zone, "zone956", 956, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3394", zones.back()->m_zone, "zone226", 226,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 8, 12}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3432", zones.back()->m_zone, "zone242", 242, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3435", zones.back()->m_zone, "zone255", 255, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3436", zones.back()->m_zone, "zone245", 245,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3190", zones.back()->m_zone, "zone110", 110, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3393", zones.back()->m_zone, "zone223", 223,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 8, 12}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3433", zones.back()->m_zone, "zone243", 243,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3436", zones.back()->m_zone, "zone244", 244,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3437", zones.back()->m_zone, "zone256", 256, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{51, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B997", zones.back()->m_zone, "zone719", 719, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3418", zones.back()->m_zone, "zone237", 237, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3438", zones.back()->m_zone, "zone248", 248,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3439", zones.back()->m_zone, "zone266", 266, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3440", zones.back()->m_zone, "zone249", 249,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B143", zones.back()->m_zone, "zone732", 732, Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B473", zones.back()->m_zone, "zone236", 236,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A474", zones.back()->m_zone, "zone291", 291, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{6, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A475", zones.back()->m_zone, "zone834", 834, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A476", zones.back()->m_zone, "zone380", 380, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A477", zones.back()->m_zone, "zone591", 591, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2662", zones.back()->m_zone, "zone1370", 1370,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3415", zones.back()->m_zone, "zone235", 235, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3438", zones.back()->m_zone, "zone246", 246,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3441", zones.back()->m_zone, "zone267", 267, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3442", zones.back()->m_zone, "zone250", 250,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1002", zones.back()->m_zone, "zone722", 722, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3423", zones.back()->m_zone, "zone239", 239, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3440", zones.back()->m_zone, "zone246", 246,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3443", zones.back()->m_zone, "zone265", 265, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3444", zones.back()->m_zone, "zone251", 251,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3445", zones.back()->m_zone, "zone250", 250,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2667", zones.back()->m_zone, "zone1371", 1371,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3422", zones.back()->m_zone, "zone238", 238, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3442", zones.back()->m_zone, "zone248", 248,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3445", zones.back()->m_zone, "zone249", 249,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3446", zones.back()->m_zone, "zone252", 252,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{5, 6, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3447", zones.back()->m_zone, "zone264", 264, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B370", zones.back()->m_zone, "zone1387", 1387,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{5, 6, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3428", zones.back()->m_zone, "zone241", 241, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3444", zones.back()->m_zone, "zone249", 249,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3448", zones.back()->m_zone, "zone262", 262,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3449", zones.back()->m_zone, "zone252", 252,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3450", zones.back()->m_zone, "zone253", 253, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2035", zones.back()->m_zone, "zone1138", 1138,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{5, 6, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3426", zones.back()->m_zone, "zone240", 240, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3446", zones.back()->m_zone, "zone250", 250,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3449", zones.back()->m_zone, "zone251", 251,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3451", zones.back()->m_zone, "zone254", 254, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3452", zones.back()->m_zone, "zone263", 263,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B381", zones.back()->m_zone, "zone1420", 1420,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{12, 6, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3430", zones.back()->m_zone, "zone242", 242, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3450", zones.back()->m_zone, "zone251", 251, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3453", zones.back()->m_zone, "zone260", 260,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3454", zones.back()->m_zone, "zone254", 254,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3455", zones.back()->m_zone, "zone255", 255,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2045", zones.back()->m_zone, "zone1141", 1141,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{12, 6, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3434", zones.back()->m_zone, "zone243", 243, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3451", zones.back()->m_zone, "zone252", 252,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3454", zones.back()->m_zone, "zone253", 253,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3456", zones.back()->m_zone, "zone256", 256, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3457", zones.back()->m_zone, "zone261", 261,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1528", zones.back()->m_zone, "zone957", 957, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3435", zones.back()->m_zone, "zone244", 244, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3455", zones.back()->m_zone, "zone253", 253, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3458", zones.back()->m_zone, "zone257", 257,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3459", zones.back()->m_zone, "zone256", 256,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3193", zones.back()->m_zone, "zone111", 111, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3437", zones.back()->m_zone, "zone245", 245, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3456", zones.back()->m_zone, "zone254", 254,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3459", zones.back()->m_zone, "zone255", 255,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3460", zones.back()->m_zone, "zone259", 259,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1530", zones.back()->m_zone, "zone958", 958,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 1}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3458", zones.back()->m_zone, "zone255", 255,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3461", zones.back()->m_zone, "zone259", 259,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3462", zones.back()->m_zone, "zone260", 260,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3463", zones.back()->m_zone, "zone277", 277,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 31, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x10 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "A478", zones.back()->m_zone, "zone839", 839, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A479", zones.back()->m_zone, "zone280", 280, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 11}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A480", zones.back()->m_zone, "zone833", 833, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 11}},
      Ioss::IJK_t{{6, 101, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A481", zones.back()->m_zone, "zone811", 811, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 11}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A482", zones.back()->m_zone, "zone269", 269,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 11}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B3195", zones.back()->m_zone, "zone112", 112,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 1}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3460", zones.back()->m_zone, "zone256", 256,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3461", zones.back()->m_zone, "zone257", 257,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3464", zones.back()->m_zone, "zone261", 261, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3465", zones.back()->m_zone, "zone278", 278,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 31, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x30x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B385", zones.back()->m_zone, "zone1431", 1431,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 1}}, Ioss::IJK_t{{12, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3453", zones.back()->m_zone, "zone253", 253,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3462", zones.back()->m_zone, "zone257", 257, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3466", zones.back()->m_zone, "zone261", 261,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3467", zones.back()->m_zone, "zone262", 262,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3468", zones.back()->m_zone, "zone276", 276,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{12, 31, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x30x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2050", zones.back()->m_zone, "zone1143", 1143,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 1}}, Ioss::IJK_t{{12, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3457", zones.back()->m_zone, "zone254", 254,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3464", zones.back()->m_zone, "zone259", 259,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3466", zones.back()->m_zone, "zone260", 260,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3469", zones.back()->m_zone, "zone263", 263, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3470", zones.back()->m_zone, "zone275", 275,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{12, 31, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B376", zones.back()->m_zone, "zone1398", 1398,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 31, 1}}, Ioss::IJK_t{{5, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3448", zones.back()->m_zone, "zone251", 251,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3467", zones.back()->m_zone, "zone260", 260, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3471", zones.back()->m_zone, "zone263", 263,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3472", zones.back()->m_zone, "zone265", 265,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3473", zones.back()->m_zone, "zone274", 274,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{5, 31, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2041", zones.back()->m_zone, "zone1139", 1139,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 31, 1}}, Ioss::IJK_t{{5, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3452", zones.back()->m_zone, "zone252", 252,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3469", zones.back()->m_zone, "zone261", 261, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3471", zones.back()->m_zone, "zone262", 262,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3474", zones.back()->m_zone, "zone264", 264,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3475", zones.back()->m_zone, "zone273", 273,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{5, 31, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2673", zones.back()->m_zone, "zone1373", 1373,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3447", zones.back()->m_zone, "zone250", 250, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3474", zones.back()->m_zone, "zone263", 263,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3476", zones.back()->m_zone, "zone265", 265,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3477", zones.back()->m_zone, "zone271", 271,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3478", zones.back()->m_zone, "zone267", 267,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1010", zones.back()->m_zone, "zone724", 724,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 1}}, Ioss::IJK_t{{8, 1, 31}},
                                                Ioss::IJK_t{{8, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3443", zones.back()->m_zone, "zone249", 249,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3472", zones.back()->m_zone, "zone262", 262,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 1, 8}}, Ioss::IJK_t{{5, 31, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3476", zones.back()->m_zone, "zone264", 264,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3479", zones.back()->m_zone, "zone272", 272, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3480", zones.back()->m_zone, "zone266", 266,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x100x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1004", zones.back()->m_zone, "zone723", 723,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3439", zones.back()->m_zone, "zone246", 246, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3480", zones.back()->m_zone, "zone265", 265,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3481", zones.back()->m_zone, "zone267", 267,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3482", zones.back()->m_zone, "zone268", 268,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x100x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2671", zones.back()->m_zone, "zone1372", 1372,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 1}}, Ioss::IJK_t{{8, 1, 31}},
                                                Ioss::IJK_t{{8, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3441", zones.back()->m_zone, "zone248", 248,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3478", zones.back()->m_zone, "zone264", 264,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3481", zones.back()->m_zone, "zone266", 266,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3483", zones.back()->m_zone, "zone270", 270, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x100x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1012", zones.back()->m_zone, "zone725", 725,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 1}}, Ioss::IJK_t{{8, 1, 31}},
                                                Ioss::IJK_t{{8, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3482", zones.back()->m_zone, "zone266", 266, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3484", zones.back()->m_zone, "zone270", 270,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3485", zones.back()->m_zone, "zone281", 281,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3486", zones.back()->m_zone, "zone272", 272,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x10"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B145", zones.back()->m_zone, "zone743", 743, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 1, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B482", zones.back()->m_zone, "zone258", 258,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 11}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A483", zones.back()->m_zone, "zone840", 840, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{6, 1, 6}}, Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A484", zones.back()->m_zone, "zone812", 812, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A485", zones.back()->m_zone, "zone834", 834, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 11}},
      Ioss::IJK_t{{6, 6, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A486", zones.back()->m_zone, "zone291", 291, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x100x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2676", zones.back()->m_zone, "zone1374", 1374,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3483", zones.back()->m_zone, "zone267", 267,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3484", zones.back()->m_zone, "zone268", 268,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3487", zones.back()->m_zone, "zone279", 279, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3488", zones.back()->m_zone, "zone271", 271,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2680", zones.back()->m_zone, "zone1376", 1376,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 1}}, Ioss::IJK_t{{8, 1, 31}},
                                                Ioss::IJK_t{{8, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3477", zones.back()->m_zone, "zone264", 264, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3488", zones.back()->m_zone, "zone270", 270,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3489", zones.back()->m_zone, "zone273", 273,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 1, 8}}, Ioss::IJK_t{{5, 31, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3490", zones.back()->m_zone, "zone272", 272,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3491", zones.back()->m_zone, "zone283", 283,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1014", zones.back()->m_zone, "zone726", 726,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3479", zones.back()->m_zone, "zone265", 265,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3486", zones.back()->m_zone, "zone268", 268,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3490", zones.back()->m_zone, "zone271", 271,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3492", zones.back()->m_zone, "zone282", 282, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3493", zones.back()->m_zone, "zone274", 274,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1890", zones.back()->m_zone, "zone1094", 1094,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 31, 1}}, Ioss::IJK_t{{5, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3475", zones.back()->m_zone, "zone263", 263,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{5, 31, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3489", zones.back()->m_zone, "zone271", 271,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3494", zones.back()->m_zone, "zone275", 275, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3495", zones.back()->m_zone, "zone284", 284, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{5, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3496", zones.back()->m_zone, "zone274", 274,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B225", zones.back()->m_zone, "zone943", 943, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 31, 1}}, Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3473", zones.back()->m_zone, "zone262", 262,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{5, 31, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3493", zones.back()->m_zone, "zone272", 272,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3496", zones.back()->m_zone, "zone273", 273,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3497", zones.back()->m_zone, "zone285", 285, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{5, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3498", zones.back()->m_zone, "zone276", 276, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 31, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x30x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1980", zones.back()->m_zone, "zone1118", 1118,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 1}}, Ioss::IJK_t{{12, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3470", zones.back()->m_zone, "zone261", 261,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{12, 31, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3494", zones.back()->m_zone, "zone273", 273,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3499", zones.back()->m_zone, "zone278", 278, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3500", zones.back()->m_zone, "zone286", 286, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3501", zones.back()->m_zone, "zone276", 276,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x30x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B315", zones.back()->m_zone, "zone1187", 1187,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 1}}, Ioss::IJK_t{{12, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3468", zones.back()->m_zone, "zone260", 260,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{12, 31, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3498", zones.back()->m_zone, "zone274", 274, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3501", zones.back()->m_zone, "zone275", 275,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3502", zones.back()->m_zone, "zone287", 287, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3503", zones.back()->m_zone, "zone277", 277,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1533", zones.back()->m_zone, "zone959", 959,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 1}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3463", zones.back()->m_zone, "zone257", 257,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 31, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3503", zones.back()->m_zone, "zone276", 276, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3504", zones.back()->m_zone, "zone288", 288, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{51, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3505", zones.back()->m_zone, "zone278", 278,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B3198", zones.back()->m_zone, "zone115", 115,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 1}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3465", zones.back()->m_zone, "zone259", 259,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 31, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3499", zones.back()->m_zone, "zone275", 275,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3505", zones.back()->m_zone, "zone277", 277,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3506", zones.back()->m_zone, "zone289", 289, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{51, 31, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x100x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2655", zones.back()->m_zone, "zone1368", 1368,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3487", zones.back()->m_zone, "zone270", 270,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3507", zones.back()->m_zone, "zone290", 290, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3508", zones.back()->m_zone, "zone281", 281,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3509", zones.back()->m_zone, "zone283", 283,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x10 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B469", zones.back()->m_zone, "zone236", 236, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 11}},
      Ioss::IJK_t{{6, 101, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B479", zones.back()->m_zone, "zone258", 258, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A487", zones.back()->m_zone, "zone302", 302, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{6, 1, 6}}, Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A488", zones.back()->m_zone, "zone571", 571, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A489", zones.back()->m_zone, "zone291", 291,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 11}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x100x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B991", zones.back()->m_zone, "zone717", 717, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{31, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{31, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3485", zones.back()->m_zone, "zone268", 268, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3508", zones.back()->m_zone, "zone279", 279,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3510", zones.back()->m_zone, "zone292", 292,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3511", zones.back()->m_zone, "zone282", 282,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B993", zones.back()->m_zone, "zone718", 718, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{31, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{31, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3492", zones.back()->m_zone, "zone272", 272,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3511", zones.back()->m_zone, "zone281", 281,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3512", zones.back()->m_zone, "zone294", 294, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3513", zones.back()->m_zone, "zone285", 285,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3514", zones.back()->m_zone, "zone283", 283,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2659", zones.back()->m_zone, "zone1369", 1369,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3491", zones.back()->m_zone, "zone271", 271, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3509", zones.back()->m_zone, "zone279", 279,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3514", zones.back()->m_zone, "zone282", 282,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3515", zones.back()->m_zone, "zone284", 284,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 1, 8}}, Ioss::IJK_t{{5, 31, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3516", zones.back()->m_zone, "zone293", 293,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1914", zones.back()->m_zone, "zone1101", 1101,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 31, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3495", zones.back()->m_zone, "zone273", 273,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3515", zones.back()->m_zone, "zone283", 283,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3517", zones.back()->m_zone, "zone286", 286, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3518", zones.back()->m_zone, "zone296", 296, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{5, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3519", zones.back()->m_zone, "zone285", 285,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B249", zones.back()->m_zone, "zone1009", 1009,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 31, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3497", zones.back()->m_zone, "zone274", 274,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3513", zones.back()->m_zone, "zone282", 282,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3519", zones.back()->m_zone, "zone284", 284,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3520", zones.back()->m_zone, "zone295", 295, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{5, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3521", zones.back()->m_zone, "zone287", 287, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 31, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x30x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1999", zones.back()->m_zone, "zone1125", 1125,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3500", zones.back()->m_zone, "zone275", 275,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3517", zones.back()->m_zone, "zone284", 284,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3522", zones.back()->m_zone, "zone289", 289, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3523", zones.back()->m_zone, "zone298", 298, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{12, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3524", zones.back()->m_zone, "zone287", 287,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x30x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B333", zones.back()->m_zone, "zone1253", 1253,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3502", zones.back()->m_zone, "zone276", 276,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3521", zones.back()->m_zone, "zone285", 285, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3524", zones.back()->m_zone, "zone286", 286,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3525", zones.back()->m_zone, "zone297", 297, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{12, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3526", zones.back()->m_zone, "zone288", 288,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1536", zones.back()->m_zone, "zone960", 960, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 31, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3504", zones.back()->m_zone, "zone277", 277,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3526", zones.back()->m_zone, "zone287", 287, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3527", zones.back()->m_zone, "zone300", 300,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3528", zones.back()->m_zone, "zone289", 289,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3201", zones.back()->m_zone, "zone116", 116, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 31, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3506", zones.back()->m_zone, "zone278", 278,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3522", zones.back()->m_zone, "zone286", 286,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3528", zones.back()->m_zone, "zone288", 288,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3529", zones.back()->m_zone, "zone299", 299,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2598", zones.back()->m_zone, "zone1348", 1348,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3507", zones.back()->m_zone, "zone279", 279,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3530", zones.back()->m_zone, "zone301", 301, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3531", zones.back()->m_zone, "zone292", 292,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3532", zones.back()->m_zone, "zone293", 293,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x10"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B132", zones.back()->m_zone, "zone709", 709, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 1, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B474", zones.back()->m_zone, "zone247", 247, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 11}},
      Ioss::IJK_t{{6, 6, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B486", zones.back()->m_zone, "zone269", 269, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 11}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B489", zones.back()->m_zone, "zone280", 280,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 11}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A490", zones.back()->m_zone, "zone313", 313, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A491", zones.back()->m_zone, "zone572", 572, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 11}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B933", zones.back()->m_zone, "zone697", 697, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3510", zones.back()->m_zone, "zone281", 281, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3531", zones.back()->m_zone, "zone290", 290,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3533", zones.back()->m_zone, "zone303", 303,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3534", zones.back()->m_zone, "zone294", 294,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2603", zones.back()->m_zone, "zone1349", 1349,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3516", zones.back()->m_zone, "zone283", 283, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3532", zones.back()->m_zone, "zone290", 290,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3535", zones.back()->m_zone, "zone296", 296,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{5, 11, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3536", zones.back()->m_zone, "zone294", 294,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3537", zones.back()->m_zone, "zone305", 305,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B938", zones.back()->m_zone, "zone699", 699, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3512", zones.back()->m_zone, "zone282", 282,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3534", zones.back()->m_zone, "zone292", 292,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3536", zones.back()->m_zone, "zone293", 293,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3538", zones.back()->m_zone, "zone304", 304, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3539", zones.back()->m_zone, "zone295", 295,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x10x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B253", zones.back()->m_zone, "zone1020", 1020,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 11, 1}}, Ioss::IJK_t{{5, 11, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3520", zones.back()->m_zone, "zone285", 285,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{5, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3539", zones.back()->m_zone, "zone294", 294,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3540", zones.back()->m_zone, "zone306", 306,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3541", zones.back()->m_zone, "zone296", 296,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 11, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3542", zones.back()->m_zone, "zone297", 297, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 11, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 11, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x10x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1918", zones.back()->m_zone, "zone1102", 1102,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 11, 1}}, Ioss::IJK_t{{5, 11, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3518", zones.back()->m_zone, "zone284", 284,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{5, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3535", zones.back()->m_zone, "zone293", 293,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 11, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3541", zones.back()->m_zone, "zone295", 295,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 11, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3543", zones.back()->m_zone, "zone298", 298, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3544", zones.back()->m_zone, "zone307", 307,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x10x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B337", zones.back()->m_zone, "zone1264", 1264,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 11, 1}}, Ioss::IJK_t{{12, 11, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3525", zones.back()->m_zone, "zone287", 287,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{12, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3542", zones.back()->m_zone, "zone295", 295, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3545", zones.back()->m_zone, "zone309", 309,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3546", zones.back()->m_zone, "zone298", 298,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 11, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3547", zones.back()->m_zone, "zone300", 300,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 11, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x10x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2001", zones.back()->m_zone, "zone1126", 1126,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 11, 1}}, Ioss::IJK_t{{12, 11, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3523", zones.back()->m_zone, "zone286", 286,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{12, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3543", zones.back()->m_zone, "zone296", 296,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3546", zones.back()->m_zone, "zone297", 297,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 11, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3548", zones.back()->m_zone, "zone299", 299,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3549", zones.back()->m_zone, "zone308", 308,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3238", zones.back()->m_zone, "zone135", 135, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3529", zones.back()->m_zone, "zone289", 289,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3548", zones.back()->m_zone, "zone298", 298,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3550", zones.back()->m_zone, "zone300", 300,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3551", zones.back()->m_zone, "zone311", 311,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1573", zones.back()->m_zone, "zone980", 980, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3527", zones.back()->m_zone, "zone288", 288,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3547", zones.back()->m_zone, "zone297", 297,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{12, 11, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3550", zones.back()->m_zone, "zone299", 299,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3552", zones.back()->m_zone, "zone310", 310,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2613", zones.back()->m_zone, "zone1352", 1352,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3530", zones.back()->m_zone, "zone290", 290, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3553", zones.back()->m_zone, "zone322", 322, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3554", zones.back()->m_zone, "zone303", 303,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3555", zones.back()->m_zone, "zone305", 305,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x5 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B487", zones.back()->m_zone, "zone280", 280, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 6}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A492", zones.back()->m_zone, "zone837", 837, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A493", zones.back()->m_zone, "zone413", 413, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A494", zones.back()->m_zone, "zone560", 560, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{6, 101, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A495", zones.back()->m_zone, "zone313", 313,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 6}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B947", zones.back()->m_zone, "zone702", 702, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{8, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3533", zones.back()->m_zone, "zone292", 292, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3554", zones.back()->m_zone, "zone301", 301,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3556", zones.back()->m_zone, "zone321", 321, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3557", zones.back()->m_zone, "zone304", 304,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B951", zones.back()->m_zone, "zone703", 703, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3538", zones.back()->m_zone, "zone294", 294, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3557", zones.back()->m_zone, "zone303", 303,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3558", zones.back()->m_zone, "zone319", 319, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3559", zones.back()->m_zone, "zone306", 306,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 8}}, Ioss::IJK_t{{5, 8, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3560", zones.back()->m_zone, "zone305", 305,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2615", zones.back()->m_zone, "zone1354", 1354,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3537", zones.back()->m_zone, "zone293", 293, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3555", zones.back()->m_zone, "zone301", 301,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3560", zones.back()->m_zone, "zone304", 304,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3561", zones.back()->m_zone, "zone307", 307,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3562", zones.back()->m_zone, "zone320", 320, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B289", zones.back()->m_zone, "zone1120", 1120,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3540", zones.back()->m_zone, "zone295", 295,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3559", zones.back()->m_zone, "zone304", 304,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3563", zones.back()->m_zone, "zone309", 309, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3564", zones.back()->m_zone, "zone307", 307,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3565", zones.back()->m_zone, "zone317", 317,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{5, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1954", zones.back()->m_zone, "zone1112", 1112,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3544", zones.back()->m_zone, "zone296", 296,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3561", zones.back()->m_zone, "zone305", 305,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3564", zones.back()->m_zone, "zone306", 306,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3566", zones.back()->m_zone, "zone308", 308, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3567", zones.back()->m_zone, "zone318", 318,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{5, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2028", zones.back()->m_zone, "zone1136", 1136,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3549", zones.back()->m_zone, "zone298", 298,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3566", zones.back()->m_zone, "zone307", 307, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3568", zones.back()->m_zone, "zone309", 309,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3569", zones.back()->m_zone, "zone311", 311,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3570", zones.back()->m_zone, "zone316", 316,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{12, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B364", zones.back()->m_zone, "zone1364", 1364,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3545", zones.back()->m_zone, "zone297", 297,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3563", zones.back()->m_zone, "zone306", 306,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3568", zones.back()->m_zone, "zone308", 308,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3571", zones.back()->m_zone, "zone310", 310, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3572", zones.back()->m_zone, "zone315", 315,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{12, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1575", zones.back()->m_zone, "zone981", 981, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3552", zones.back()->m_zone, "zone300", 300, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3571", zones.back()->m_zone, "zone309", 309,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3573", zones.back()->m_zone, "zone311", 311,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3574", zones.back()->m_zone, "zone312", 312, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3240", zones.back()->m_zone, "zone137", 137, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3551", zones.back()->m_zone, "zone299", 299, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3569", zones.back()->m_zone, "zone308", 308, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3573", zones.back()->m_zone, "zone310", 310,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3575", zones.back()->m_zone, "zone314", 314, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1577", zones.back()->m_zone, "zone982", 982,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{51, 8, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3574", zones.back()->m_zone, "zone310", 310, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{51, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3576", zones.back()->m_zone, "zone314", 314,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3577", zones.back()->m_zone, "zone315", 315,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{12, 8, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3578", zones.back()->m_zone, "zone333", 333,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x5"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B25", zones.back()->m_zone, "zone942", 942, Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 1, 6}}, Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{5, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B490", zones.back()->m_zone, "zone291", 291, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B495", zones.back()->m_zone, "zone302", 302,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 6}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A496", zones.back()->m_zone, "zone838", 838, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{6, 1, 6}}, Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A497", zones.back()->m_zone, "zone561", 561, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{6, 6, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A498", zones.back()->m_zone, "zone424", 424, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 6}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B3242", zones.back()->m_zone, "zone138", 138,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{51, 8, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3575", zones.back()->m_zone, "zone311", 311, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{51, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3576", zones.back()->m_zone, "zone312", 312,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3579", zones.back()->m_zone, "zone316", 316,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3580", zones.back()->m_zone, "zone332", 332,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B360", zones.back()->m_zone, "zone1353", 1353,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3572", zones.back()->m_zone, "zone309", 309,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{12, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3577", zones.back()->m_zone, "zone312", 312,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3581", zones.back()->m_zone, "zone317", 317, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3582", zones.back()->m_zone, "zone331", 331, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{12, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3583", zones.back()->m_zone, "zone316", 316,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2026", zones.back()->m_zone, "zone1135", 1135,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3570", zones.back()->m_zone, "zone308", 308,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{12, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3579", zones.back()->m_zone, "zone314", 314,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3583", zones.back()->m_zone, "zone315", 315,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3584", zones.back()->m_zone, "zone330", 330, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{12, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3585", zones.back()->m_zone, "zone318", 318,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B285", zones.back()->m_zone, "zone1109", 1109,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3565", zones.back()->m_zone, "zone306", 306,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{5, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3581", zones.back()->m_zone, "zone315", 315, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3586", zones.back()->m_zone, "zone319", 319,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3587", zones.back()->m_zone, "zone329", 329, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{5, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3588", zones.back()->m_zone, "zone318", 318,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1950", zones.back()->m_zone, "zone1111", 1111,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3567", zones.back()->m_zone, "zone307", 307,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{5, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3585", zones.back()->m_zone, "zone316", 316, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3588", zones.back()->m_zone, "zone317", 317,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3589", zones.back()->m_zone, "zone328", 328, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{5, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3590", zones.back()->m_zone, "zone320", 320,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B958", zones.back()->m_zone, "zone705", 705, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3558", zones.back()->m_zone, "zone304", 304, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3586", zones.back()->m_zone, "zone317", 317,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3591", zones.back()->m_zone, "zone326", 326, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3592", zones.back()->m_zone, "zone320", 320,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3593", zones.back()->m_zone, "zone321", 321,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2622", zones.back()->m_zone, "zone1356", 1356,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3562", zones.back()->m_zone, "zone305", 305, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3590", zones.back()->m_zone, "zone318", 318,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 8}}, Ioss::IJK_t{{5, 8, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3592", zones.back()->m_zone, "zone319", 319,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3594", zones.back()->m_zone, "zone327", 327, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3595", zones.back()->m_zone, "zone322", 322,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B953", zones.back()->m_zone, "zone704", 704, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{8, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3556", zones.back()->m_zone, "zone303", 303, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3593", zones.back()->m_zone, "zone319", 319,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3596", zones.back()->m_zone, "zone322", 322,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3597", zones.back()->m_zone, "zone325", 325, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2619", zones.back()->m_zone, "zone1355", 1355,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3553", zones.back()->m_zone, "zone301", 301, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3595", zones.back()->m_zone, "zone320", 320,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3596", zones.back()->m_zone, "zone321", 321,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3598", zones.back()->m_zone, "zone323", 323, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2645", zones.back()->m_zone, "zone1363", 1363,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3598", zones.back()->m_zone, "zone322", 322, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3599", zones.back()->m_zone, "zone334", 334, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3600", zones.back()->m_zone, "zone325", 325,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3601", zones.back()->m_zone, "zone327", 327,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x4 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "A499", zones.back()->m_zone, "zone839", 839, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 6}}, Ioss::IJK_t{{6, 101, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A500", zones.back()->m_zone, "zone811", 811, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 5}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A501", zones.back()->m_zone, "zone828", 828,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{6, 101, 5}}, Ioss::IJK_t{{6, 1, 12}},
                                                Ioss::IJK_t{{1, 101, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A502", zones.back()->m_zone, "zone844", 844, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A503", zones.back()->m_zone, "zone336", 336,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 5}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B980", zones.back()->m_zone, "zone713", 713, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{8, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3597", zones.back()->m_zone, "zone321", 321, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3600", zones.back()->m_zone, "zone323", 323,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3602", zones.back()->m_zone, "zone337", 337, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3603", zones.back()->m_zone, "zone326", 326,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B982", zones.back()->m_zone, "zone714", 714, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3591", zones.back()->m_zone, "zone319", 319, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3603", zones.back()->m_zone, "zone325", 325,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3604", zones.back()->m_zone, "zone339", 339, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3605", zones.back()->m_zone, "zone329", 329,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3606", zones.back()->m_zone, "zone327", 327,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2647", zones.back()->m_zone, "zone1365", 1365,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3594", zones.back()->m_zone, "zone320", 320, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3601", zones.back()->m_zone, "zone323", 323,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3606", zones.back()->m_zone, "zone326", 326,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3607", zones.back()->m_zone, "zone328", 328,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 8}}, Ioss::IJK_t{{5, 8, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3608", zones.back()->m_zone, "zone338", 338, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1947", zones.back()->m_zone, "zone1110", 1110,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{5, 8, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3589", zones.back()->m_zone, "zone318", 318, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3607", zones.back()->m_zone, "zone327", 327,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3609", zones.back()->m_zone, "zone330", 330, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3610", zones.back()->m_zone, "zone341", 341, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{5, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3611", zones.back()->m_zone, "zone329", 329,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B282", zones.back()->m_zone, "zone1098", 1098,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{5, 8, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3587", zones.back()->m_zone, "zone317", 317, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3605", zones.back()->m_zone, "zone326", 326,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3611", zones.back()->m_zone, "zone328", 328,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3612", zones.back()->m_zone, "zone340", 340, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{5, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3613", zones.back()->m_zone, "zone331", 331, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2023", zones.back()->m_zone, "zone1134", 1134,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 1}}, Ioss::IJK_t{{12, 8, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3584", zones.back()->m_zone, "zone316", 316, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3609", zones.back()->m_zone, "zone328", 328,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3614", zones.back()->m_zone, "zone332", 332, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3615", zones.back()->m_zone, "zone343", 343, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{12, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3616", zones.back()->m_zone, "zone331", 331,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B359", zones.back()->m_zone, "zone1342", 1342,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 1}}, Ioss::IJK_t{{12, 8, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3582", zones.back()->m_zone, "zone315", 315, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3613", zones.back()->m_zone, "zone329", 329, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3616", zones.back()->m_zone, "zone330", 330,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3617", zones.back()->m_zone, "zone342", 342, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{12, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3618", zones.back()->m_zone, "zone333", 333,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3231", zones.back()->m_zone, "zone131", 131, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3580", zones.back()->m_zone, "zone314", 314,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3614", zones.back()->m_zone, "zone330", 330,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3619", zones.back()->m_zone, "zone345", 345, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{51, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3620", zones.back()->m_zone, "zone333", 333,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1566", zones.back()->m_zone, "zone975", 975, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3578", zones.back()->m_zone, "zone312", 312,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3618", zones.back()->m_zone, "zone331", 331, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3620", zones.back()->m_zone, "zone332", 332,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3621", zones.back()->m_zone, "zone344", 344, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{51, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2638", zones.back()->m_zone, "zone1361", 1361,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3599", zones.back()->m_zone, "zone323", 323, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3622", zones.back()->m_zone, "zone355", 355, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3623", zones.back()->m_zone, "zone337", 337,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3624", zones.back()->m_zone, "zone338", 338,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B52", zones.back()->m_zone, "zone113", 113, Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A59", zones.back()->m_zone, "zone576", 576,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{5, 1, 6}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A60", zones.back()->m_zone, "zone446", 446, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A61", zones.back()->m_zone, "zone688", 688,
                                                Ioss::IJK_t{{-3, -2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{8, 1, 5}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A62", zones.back()->m_zone, "zone685", 685, Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A63", zones.back()->m_zone, "zone91", 91, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x4"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B15", zones.back()->m_zone, "zone720", 720, Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 1, 5}}, Ioss::IJK_t{{5, 6, 6}}, Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B503", zones.back()->m_zone, "zone324", 324,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 5}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A504", zones.back()->m_zone, "zone840", 840, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 6}}, Ioss::IJK_t{{6, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A505", zones.back()->m_zone, "zone845", 845, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 5}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A506", zones.back()->m_zone, "zone827", 827,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{6, 6, 5}}, Ioss::IJK_t{{6, 1, 12}},
                                                Ioss::IJK_t{{1, 6, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A507", zones.back()->m_zone, "zone812", 812, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B973", zones.back()->m_zone, "zone711", 711, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{8, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3602", zones.back()->m_zone, "zone325", 325, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3623", zones.back()->m_zone, "zone334", 334,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3625", zones.back()->m_zone, "zone356", 356, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3626", zones.back()->m_zone, "zone339", 339,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2643", zones.back()->m_zone, "zone1362", 1362,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3608", zones.back()->m_zone, "zone327", 327, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3624", zones.back()->m_zone, "zone334", 334,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3627", zones.back()->m_zone, "zone341", 341,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 8}}, Ioss::IJK_t{{5, 8, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3628", zones.back()->m_zone, "zone339", 339,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3629", zones.back()->m_zone, "zone354", 354, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B978", zones.back()->m_zone, "zone712", 712, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3604", zones.back()->m_zone, "zone326", 326, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3626", zones.back()->m_zone, "zone337", 337,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3628", zones.back()->m_zone, "zone338", 338,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3630", zones.back()->m_zone, "zone353", 353, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3631", zones.back()->m_zone, "zone340", 340,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B277", zones.back()->m_zone, "zone1087", 1087,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3612", zones.back()->m_zone, "zone329", 329, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3631", zones.back()->m_zone, "zone339", 339,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3632", zones.back()->m_zone, "zone352", 352, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{5, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3633", zones.back()->m_zone, "zone341", 341,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3634", zones.back()->m_zone, "zone342", 342, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1942", zones.back()->m_zone, "zone1108", 1108,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3610", zones.back()->m_zone, "zone328", 328, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3627", zones.back()->m_zone, "zone338", 338,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3633", zones.back()->m_zone, "zone340", 340,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3635", zones.back()->m_zone, "zone343", 343, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3636", zones.back()->m_zone, "zone351", 351, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{5, 11, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B354", zones.back()->m_zone, "zone1331", 1331,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3617", zones.back()->m_zone, "zone331", 331, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3634", zones.back()->m_zone, "zone340", 340, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3637", zones.back()->m_zone, "zone350", 350, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{12, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3638", zones.back()->m_zone, "zone343", 343,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3639", zones.back()->m_zone, "zone344", 344,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2020", zones.back()->m_zone, "zone1133", 1133,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3615", zones.back()->m_zone, "zone330", 330, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3635", zones.back()->m_zone, "zone341", 341,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3638", zones.back()->m_zone, "zone342", 342,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 8, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3640", zones.back()->m_zone, "zone345", 345, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3641", zones.back()->m_zone, "zone349", 349, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{12, 11, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1563", zones.back()->m_zone, "zone974", 974, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3621", zones.back()->m_zone, "zone333", 333, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3639", zones.back()->m_zone, "zone342", 342, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3642", zones.back()->m_zone, "zone348", 348,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3643", zones.back()->m_zone, "zone345", 345,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3228", zones.back()->m_zone, "zone130", 130, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3619", zones.back()->m_zone, "zone332", 332, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3640", zones.back()->m_zone, "zone343", 343,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3643", zones.back()->m_zone, "zone344", 344,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 8, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3644", zones.back()->m_zone, "zone346", 346,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B3224", zones.back()->m_zone, "zone128", 128,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 11, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3644", zones.back()->m_zone, "zone345", 345,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3645", zones.back()->m_zone, "zone349", 349,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3646", zones.back()->m_zone, "zone348", 348,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3647", zones.back()->m_zone, "zone367", 367,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x10"));

  zones.back()->m_zoneConnectivity.emplace_back("A508", zones.back()->m_zone, "zone825", 825,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A509", zones.back()->m_zone, "zone855", 855, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A510", zones.back()->m_zone, "zone1034", 1034,
                                                Ioss::IJK_t{{3, -1, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 11}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{1, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A511", zones.back()->m_zone, "zone922", 922, Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 11}},
      Ioss::IJK_t{{12, 6, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 12, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A512", zones.back()->m_zone, "zone813", 813,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 11}}, Ioss::IJK_t{{12, 1, 11}},
                                                Ioss::IJK_t{{12, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A513", zones.back()->m_zone, "zone358", 358,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{12, 6, 11}}, Ioss::IJK_t{{12, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1559", zones.back()->m_zone, "zone972", 972,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 11, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3642", zones.back()->m_zone, "zone344", 344,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3646", zones.back()->m_zone, "zone346", 346,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3648", zones.back()->m_zone, "zone350", 350,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{12, 11, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3649", zones.back()->m_zone, "zone366", 366,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x10x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2017", zones.back()->m_zone, "zone1132", 1132,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 11, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3641", zones.back()->m_zone, "zone343", 343,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{12, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3645", zones.back()->m_zone, "zone346", 346,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3650", zones.back()->m_zone, "zone365", 365,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3651", zones.back()->m_zone, "zone350", 350,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 11, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3652", zones.back()->m_zone, "zone351", 351,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x10x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B351", zones.back()->m_zone, "zone1320", 1320,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 11, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3637", zones.back()->m_zone, "zone342", 342,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{12, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3648", zones.back()->m_zone, "zone348", 348,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 11, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3651", zones.back()->m_zone, "zone349", 349,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 11, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3653", zones.back()->m_zone, "zone352", 352, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3654", zones.back()->m_zone, "zone364", 364,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x10x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1938", zones.back()->m_zone, "zone1107", 1107,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 11, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3636", zones.back()->m_zone, "zone341", 341,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{5, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3652", zones.back()->m_zone, "zone349", 349, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3655", zones.back()->m_zone, "zone362", 362,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3656", zones.back()->m_zone, "zone352", 352,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 11, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3657", zones.back()->m_zone, "zone354", 354,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 11, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x10x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B273", zones.back()->m_zone, "zone1076", 1076,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 11, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3632", zones.back()->m_zone, "zone340", 340,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{5, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3653", zones.back()->m_zone, "zone350", 350, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 11, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3656", zones.back()->m_zone, "zone351", 351,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 11, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3658", zones.back()->m_zone, "zone353", 353,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3659", zones.back()->m_zone, "zone363", 363,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1060", zones.back()->m_zone, "zone750", 750, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3630", zones.back()->m_zone, "zone339", 339,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3658", zones.back()->m_zone, "zone352", 352,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3660", zones.back()->m_zone, "zone361", 361, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3661", zones.back()->m_zone, "zone354", 354,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3662", zones.back()->m_zone, "zone356", 356,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2724", zones.back()->m_zone, "zone1401", 1401,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3629", zones.back()->m_zone, "zone338", 338, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3657", zones.back()->m_zone, "zone351", 351,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{5, 11, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3661", zones.back()->m_zone, "zone353", 353,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3663", zones.back()->m_zone, "zone360", 360,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3664", zones.back()->m_zone, "zone355", 355,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2722", zones.back()->m_zone, "zone1400", 1400,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3622", zones.back()->m_zone, "zone334", 334,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3664", zones.back()->m_zone, "zone354", 354,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3665", zones.back()->m_zone, "zone357", 357, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3666", zones.back()->m_zone, "zone356", 356,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1056", zones.back()->m_zone, "zone749", 749, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3625", zones.back()->m_zone, "zone337", 337, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3662", zones.back()->m_zone, "zone353", 353,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3666", zones.back()->m_zone, "zone355", 355,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3667", zones.back()->m_zone, "zone359", 359,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x100x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2727", zones.back()->m_zone, "zone1402", 1402,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3665", zones.back()->m_zone, "zone355", 355,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3668", zones.back()->m_zone, "zone368", 368, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3669", zones.back()->m_zone, "zone359", 359,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3670", zones.back()->m_zone, "zone360", 360,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x100x10"));

  zones.back()->m_zoneConnectivity.emplace_back("B513", zones.back()->m_zone, "zone347", 347,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{12, 101, 11}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A514", zones.back()->m_zone, "zone826", 826,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A515", zones.back()->m_zone, "zone814", 814,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 11}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A516", zones.back()->m_zone, "zone823", 823, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 11}},
      Ioss::IJK_t{{12, 101, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A517", zones.back()->m_zone, "zone853", 853,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 11}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x100x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1061", zones.back()->m_zone, "zone751", 751, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{31, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{31, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3667", zones.back()->m_zone, "zone356", 356, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3669", zones.back()->m_zone, "zone357", 357,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3671", zones.back()->m_zone, "zone370", 370,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3672", zones.back()->m_zone, "zone361", 361,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2729", zones.back()->m_zone, "zone1403", 1403,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3663", zones.back()->m_zone, "zone354", 354, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3670", zones.back()->m_zone, "zone357", 357,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3673", zones.back()->m_zone, "zone362", 362,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3674", zones.back()->m_zone, "zone361", 361,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3675", zones.back()->m_zone, "zone372", 372,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1065", zones.back()->m_zone, "zone752", 752, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{31, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{31, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3660", zones.back()->m_zone, "zone353", 353,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3672", zones.back()->m_zone, "zone359", 359,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3674", zones.back()->m_zone, "zone360", 360,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3676", zones.back()->m_zone, "zone371", 371, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3677", zones.back()->m_zone, "zone363", 363,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 1, 8}}, Ioss::IJK_t{{5, 31, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1894", zones.back()->m_zone, "zone1095", 1095,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 31, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3655", zones.back()->m_zone, "zone351", 351,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3673", zones.back()->m_zone, "zone360", 360,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3678", zones.back()->m_zone, "zone363", 363,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3679", zones.back()->m_zone, "zone365", 365, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3680", zones.back()->m_zone, "zone373", 373,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B229", zones.back()->m_zone, "zone954", 954, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 31, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{5, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3659", zones.back()->m_zone, "zone352", 352,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3677", zones.back()->m_zone, "zone361", 361,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3678", zones.back()->m_zone, "zone362", 362,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3681", zones.back()->m_zone, "zone364", 364, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3682", zones.back()->m_zone, "zone374", 374,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x30x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B319", zones.back()->m_zone, "zone1198", 1198,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3654", zones.back()->m_zone, "zone350", 350,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3681", zones.back()->m_zone, "zone363", 363,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3683", zones.back()->m_zone, "zone366", 366, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3684", zones.back()->m_zone, "zone365", 365,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3685", zones.back()->m_zone, "zone375", 375,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x30x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1983", zones.back()->m_zone, "zone1119", 1119,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3650", zones.back()->m_zone, "zone349", 349,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3679", zones.back()->m_zone, "zone362", 362, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3684", zones.back()->m_zone, "zone364", 364,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3686", zones.back()->m_zone, "zone367", 367,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3687", zones.back()->m_zone, "zone376", 376,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1555", zones.back()->m_zone, "zone970", 970, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 31, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3649", zones.back()->m_zone, "zone348", 348, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3683", zones.back()->m_zone, "zone364", 364,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3688", zones.back()->m_zone, "zone367", 367,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3689", zones.back()->m_zone, "zone378", 378,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3220", zones.back()->m_zone, "zone126", 126, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 31, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3647", zones.back()->m_zone, "zone346", 346, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3686", zones.back()->m_zone, "zone365", 365, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3688", zones.back()->m_zone, "zone366", 366,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3690", zones.back()->m_zone, "zone377", 377,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x100x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2732", zones.back()->m_zone, "zone1404", 1404,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 1}}, Ioss::IJK_t{{8, 1, 31}},
                                                Ioss::IJK_t{{8, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3668", zones.back()->m_zone, "zone357", 357,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3691", zones.back()->m_zone, "zone381", 381, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3692", zones.back()->m_zone, "zone370", 370,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3693", zones.back()->m_zone, "zone372", 372,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B471", zones.back()->m_zone, "zone236", 236, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A518", zones.back()->m_zone, "zone585", 585, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{8, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A519", zones.back()->m_zone, "zone391", 391,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A520", zones.back()->m_zone, "zone514", 514, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A521", zones.back()->m_zone, "zone380", 380,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x100x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1066", zones.back()->m_zone, "zone753", 753,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3671", zones.back()->m_zone, "zone359", 359, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3692", zones.back()->m_zone, "zone368", 368,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3694", zones.back()->m_zone, "zone379", 379,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3695", zones.back()->m_zone, "zone371", 371,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1070", zones.back()->m_zone, "zone755", 755,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 1}}, Ioss::IJK_t{{8, 1, 31}},
                                                Ioss::IJK_t{{8, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3676", zones.back()->m_zone, "zone361", 361,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3695", zones.back()->m_zone, "zone370", 370,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3696", zones.back()->m_zone, "zone382", 382, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3697", zones.back()->m_zone, "zone374", 374,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 1, 8}}, Ioss::IJK_t{{5, 31, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3698", zones.back()->m_zone, "zone372", 372,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2734", zones.back()->m_zone, "zone1405", 1405,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3675", zones.back()->m_zone, "zone360", 360, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3693", zones.back()->m_zone, "zone368", 368,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3698", zones.back()->m_zone, "zone371", 371,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3699", zones.back()->m_zone, "zone373", 373,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3700", zones.back()->m_zone, "zone383", 383,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1875", zones.back()->m_zone, "zone1091", 1091,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 31, 1}}, Ioss::IJK_t{{5, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3680", zones.back()->m_zone, "zone362", 362, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{5, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3699", zones.back()->m_zone, "zone372", 372,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3701", zones.back()->m_zone, "zone374", 374,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3702", zones.back()->m_zone, "zone376", 376, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3703", zones.back()->m_zone, "zone385", 385,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B210", zones.back()->m_zone, "zone909", 909, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 31, 1}}, Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3682", zones.back()->m_zone, "zone363", 363, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{5, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3697", zones.back()->m_zone, "zone371", 371,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3701", zones.back()->m_zone, "zone373", 373,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3704", zones.back()->m_zone, "zone375", 375, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3705", zones.back()->m_zone, "zone384", 384,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x30x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B303", zones.back()->m_zone, "zone1153", 1153,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 1}}, Ioss::IJK_t{{12, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3685", zones.back()->m_zone, "zone364", 364, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3704", zones.back()->m_zone, "zone374", 374,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3706", zones.back()->m_zone, "zone378", 378, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3707", zones.back()->m_zone, "zone376", 376,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3708", zones.back()->m_zone, "zone386", 386,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x30x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1968", zones.back()->m_zone, "zone1115", 1115,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 1}}, Ioss::IJK_t{{12, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3687", zones.back()->m_zone, "zone365", 365, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3702", zones.back()->m_zone, "zone373", 373, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3707", zones.back()->m_zone, "zone375", 375,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3709", zones.back()->m_zone, "zone377", 377,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3710", zones.back()->m_zone, "zone387", 387,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B3222", zones.back()->m_zone, "zone127", 127,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 1}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3690", zones.back()->m_zone, "zone367", 367, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{51, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3709", zones.back()->m_zone, "zone376", 376, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3711", zones.back()->m_zone, "zone378", 378,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3712", zones.back()->m_zone, "zone388", 388,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1557", zones.back()->m_zone, "zone971", 971,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 1}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3689", zones.back()->m_zone, "zone366", 366, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{51, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3706", zones.back()->m_zone, "zone375", 375,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3711", zones.back()->m_zone, "zone377", 377,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3713", zones.back()->m_zone, "zone389", 389,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x100x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1072", zones.back()->m_zone, "zone756", 756,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 1}}, Ioss::IJK_t{{8, 1, 31}},
                                                Ioss::IJK_t{{8, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3694", zones.back()->m_zone, "zone370", 370, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3714", zones.back()->m_zone, "zone381", 381,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3715", zones.back()->m_zone, "zone393", 393,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3716", zones.back()->m_zone, "zone382", 382,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B128", zones.back()->m_zone, "zone698", 698, Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B476", zones.back()->m_zone, "zone247", 247, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B521", zones.back()->m_zone, "zone369", 369,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A522", zones.back()->m_zone, "zone511", 511, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{8, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A523", zones.back()->m_zone, "zone402", 402,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A524", zones.back()->m_zone, "zone586", 586, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x100x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2737", zones.back()->m_zone, "zone1406", 1406,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3691", zones.back()->m_zone, "zone368", 368,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3714", zones.back()->m_zone, "zone379", 379,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3717", zones.back()->m_zone, "zone394", 394, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3718", zones.back()->m_zone, "zone383", 383,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{31, 101, 8}}, Ioss::IJK_t{{31, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1075", zones.back()->m_zone, "zone757", 757,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B3696", zones.back()->m_zone, "zone371", 371,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3716", zones.back()->m_zone, "zone379", 379,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3719", zones.back()->m_zone, "zone395", 395, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3720", zones.back()->m_zone, "zone384", 384,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 1, 8}}, Ioss::IJK_t{{5, 31, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3721", zones.back()->m_zone, "zone383", 383,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "30x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2740", zones.back()->m_zone, "zone1407", 1407,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 1}}, Ioss::IJK_t{{8, 1, 31}},
                                                Ioss::IJK_t{{8, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3700", zones.back()->m_zone, "zone372", 372, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3718", zones.back()->m_zone, "zone381", 381,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3721", zones.back()->m_zone, "zone382", 382,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{31, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3722", zones.back()->m_zone, "zone385", 385,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3723", zones.back()->m_zone, "zone396", 396,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{31, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B445", zones.back()->m_zone, "zone158", 158, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 31, 1}}, Ioss::IJK_t{{1, 8, 31}}, Ioss::IJK_t{{5, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3705", zones.back()->m_zone, "zone374", 374, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{5, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3720", zones.back()->m_zone, "zone382", 382,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{31, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3724", zones.back()->m_zone, "zone386", 386, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3725", zones.back()->m_zone, "zone385", 385,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3726", zones.back()->m_zone, "zone400", 400,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2110", zones.back()->m_zone, "zone1166", 1166,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 31, 1}}, Ioss::IJK_t{{1, 8, 31}},
                                                Ioss::IJK_t{{5, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3703", zones.back()->m_zone, "zone373", 373, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{5, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3722", zones.back()->m_zone, "zone383", 383,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{31, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3725", zones.back()->m_zone, "zone384", 384,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3727", zones.back()->m_zone, "zone387", 387, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3728", zones.back()->m_zone, "zone397", 397,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{5, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x30x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B449", zones.back()->m_zone, "zone180", 180,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 1}}, Ioss::IJK_t{{12, 1, 31}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3708", zones.back()->m_zone, "zone375", 375, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3724", zones.back()->m_zone, "zone384", 384,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3729", zones.back()->m_zone, "zone389", 389, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3730", zones.back()->m_zone, "zone387", 387,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3731", zones.back()->m_zone, "zone399", 399,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x30x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2115", zones.back()->m_zone, "zone1168", 1168,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 1}}, Ioss::IJK_t{{12, 1, 31}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3710", zones.back()->m_zone, "zone376", 376, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3727", zones.back()->m_zone, "zone385", 385, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3730", zones.back()->m_zone, "zone386", 386,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3732", zones.back()->m_zone, "zone388", 388,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3733", zones.back()->m_zone, "zone398", 398,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{12, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3147", zones.back()->m_zone, "zone92", 92, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 31, 1}}, Ioss::IJK_t{{1, 8, 31}}, Ioss::IJK_t{{51, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3712", zones.back()->m_zone, "zone377", 377, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{51, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3732", zones.back()->m_zone, "zone387", 387, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 31, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3734", zones.back()->m_zone, "zone389", 389,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3735", zones.back()->m_zone, "zone390", 390,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x30x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1482", zones.back()->m_zone, "zone936", 936,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 1}}, Ioss::IJK_t{{1, 8, 31}},
                                                Ioss::IJK_t{{51, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3713", zones.back()->m_zone, "zone378", 378, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{51, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3729", zones.back()->m_zone, "zone386", 386,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3734", zones.back()->m_zone, "zone388", 388,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3736", zones.back()->m_zone, "zone392", 392,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 31, 1}},
                                                Ioss::IJK_t{{51, 31, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3128", zones.back()->m_zone, "zone83", 83, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3735", zones.back()->m_zone, "zone388", 388, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{51, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3737", zones.back()->m_zone, "zone398", 398, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3738", zones.back()->m_zone, "zone392", 392,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3739", zones.back()->m_zone, "zone420", 420,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B519", zones.back()->m_zone, "zone369", 369,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A525", zones.back()->m_zone, "zone556", 556, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A526", zones.back()->m_zone, "zone504", 504, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{8, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A527", zones.back()->m_zone, "zone575", 575, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A528", zones.back()->m_zone, "zone402", 402,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1463", zones.back()->m_zone, "zone927", 927, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3736", zones.back()->m_zone, "zone389", 389, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{51, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3738", zones.back()->m_zone, "zone390", 390,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3740", zones.back()->m_zone, "zone399", 399,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3741", zones.back()->m_zone, "zone419", 419,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1182", zones.back()->m_zone, "zone793", 793, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3715", zones.back()->m_zone, "zone379", 379, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3742", zones.back()->m_zone, "zone394", 394,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3743", zones.back()->m_zone, "zone403", 403, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3744", zones.back()->m_zone, "zone395", 395,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2848", zones.back()->m_zone, "zone1444", 1444,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3717", zones.back()->m_zone, "zone381", 381, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3742", zones.back()->m_zone, "zone393", 393,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3745", zones.back()->m_zone, "zone401", 401, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3746", zones.back()->m_zone, "zone396", 396,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1186", zones.back()->m_zone, "zone794", 794, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3719", zones.back()->m_zone, "zone382", 382, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3744", zones.back()->m_zone, "zone393", 393,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3747", zones.back()->m_zone, "zone404", 404, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3748", zones.back()->m_zone, "zone400", 400,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{5, 6, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3749", zones.back()->m_zone, "zone396", 396,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2850", zones.back()->m_zone, "zone1445", 1445,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3723", zones.back()->m_zone, "zone383", 383, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{31, 1, 1}}, Ioss::IJK_t{{31, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3746", zones.back()->m_zone, "zone394", 394,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3749", zones.back()->m_zone, "zone395", 395,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3750", zones.back()->m_zone, "zone397", 397,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3751", zones.back()->m_zone, "zone405", 405, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2106", zones.back()->m_zone, "zone1163", 1163,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3728", zones.back()->m_zone, "zone385", 385, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{5, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3750", zones.back()->m_zone, "zone396", 396,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3752", zones.back()->m_zone, "zone400", 400,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3753", zones.back()->m_zone, "zone398", 398, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3754", zones.back()->m_zone, "zone408", 408, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2112", zones.back()->m_zone, "zone1167", 1167,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3733", zones.back()->m_zone, "zone387", 387, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3737", zones.back()->m_zone, "zone390", 390,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3753", zones.back()->m_zone, "zone397", 397, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3755", zones.back()->m_zone, "zone399", 399,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3756", zones.back()->m_zone, "zone416", 416,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B448", zones.back()->m_zone, "zone169", 169, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3731", zones.back()->m_zone, "zone386", 386, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{12, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3740", zones.back()->m_zone, "zone392", 392, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3755", zones.back()->m_zone, "zone398", 398,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3757", zones.back()->m_zone, "zone400", 400,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3758", zones.back()->m_zone, "zone417", 417,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B441", zones.back()->m_zone, "zone147", 147, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{5, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3726", zones.back()->m_zone, "zone384", 384, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 31, 1}}, Ioss::IJK_t{{5, 31, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3748", zones.back()->m_zone, "zone395", 395,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3752", zones.back()->m_zone, "zone397", 397,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3757", zones.back()->m_zone, "zone399", 399, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3759", zones.back()->m_zone, "zone410", 410, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2853", zones.back()->m_zone, "zone1446", 1446,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3745", zones.back()->m_zone, "zone394", 394, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3760", zones.back()->m_zone, "zone406", 406,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3761", zones.back()->m_zone, "zone403", 403,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3762", zones.back()->m_zone, "zone405", 405,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B122", zones.back()->m_zone, "zone687", 687, Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B523", zones.back()->m_zone, "zone380", 380,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B528", zones.back()->m_zone, "zone391", 391,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A529", zones.back()->m_zone, "zone557", 557, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A530", zones.back()->m_zone, "zone577", 577, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{8, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A531", zones.back()->m_zone, "zone501", 501, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1188", zones.back()->m_zone, "zone795", 795, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3743", zones.back()->m_zone, "zone393", 393, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3761", zones.back()->m_zone, "zone401", 401,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3763", zones.back()->m_zone, "zone407", 407,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3764", zones.back()->m_zone, "zone404", 404,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1191", zones.back()->m_zone, "zone796", 796, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3747", zones.back()->m_zone, "zone395", 395, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3764", zones.back()->m_zone, "zone403", 403,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3765", zones.back()->m_zone, "zone411", 411,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3766", zones.back()->m_zone, "zone410", 410,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{5, 6, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3767", zones.back()->m_zone, "zone405", 405,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2856", zones.back()->m_zone, "zone1447", 1447,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3751", zones.back()->m_zone, "zone396", 396, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3762", zones.back()->m_zone, "zone401", 401,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3767", zones.back()->m_zone, "zone404", 404,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3768", zones.back()->m_zone, "zone408", 408,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3769", zones.back()->m_zone, "zone409", 409,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x4 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2838", zones.back()->m_zone, "zone1439", 1439,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 5}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3760", zones.back()->m_zone, "zone401", 401,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3770", zones.back()->m_zone, "zone412", 412,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3771", zones.back()->m_zone, "zone407", 407, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A3772", zones.back()->m_zone, "zone409", 409,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x4 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1171", zones.back()->m_zone, "zone789", 789, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3763", zones.back()->m_zone, "zone403", 403,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3771", zones.back()->m_zone, "zone406", 406, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 5}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A3773", zones.back()->m_zone, "zone414", 414,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3774", zones.back()->m_zone, "zone411", 411,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1736", zones.back()->m_zone, "zone1056", 1056,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3754", zones.back()->m_zone, "zone397", 397, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{5, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3768", zones.back()->m_zone, "zone405", 405,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3775", zones.back()->m_zone, "zone410", 410,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3776", zones.back()->m_zone, "zone416", 416,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3777", zones.back()->m_zone, "zone409", 409,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x4"));

  zones.back()->m_zoneConnectivity.emplace_back("B2841", zones.back()->m_zone, "zone1440", 1440,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3769", zones.back()->m_zone, "zone405", 405,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3772", zones.back()->m_zone, "zone406", 406,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3777", zones.back()->m_zone, "zone408", 408,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 5}}, Ioss::IJK_t{{1, 6, 8}},
                                                Ioss::IJK_t{{5, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3778", zones.back()->m_zone, "zone411", 411, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 5}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A3779", zones.back()->m_zone, "zone415", 415,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B71", zones.back()->m_zone, "zone554", 554, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{5, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3759", zones.back()->m_zone, "zone400", 400, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{5, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3766", zones.back()->m_zone, "zone404", 404,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3775", zones.back()->m_zone, "zone408", 408,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3780", zones.back()->m_zone, "zone417", 417,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3781", zones.back()->m_zone, "zone411", 411,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x4"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1178", zones.back()->m_zone, "zone790", 790, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 5}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3765", zones.back()->m_zone, "zone404", 404,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3774", zones.back()->m_zone, "zone407", 407,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3778", zones.back()->m_zone, "zone409", 409, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3781", zones.back()->m_zone, "zone410", 410,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 5}}, Ioss::IJK_t{{5, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3782", zones.back()->m_zone, "zone418", 418,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2846", zones.back()->m_zone, "zone1443", 1443,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{8, 1, 12}},
                                                Ioss::IJK_t{{8, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3770", zones.back()->m_zone, "zone406", 406,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3783", zones.back()->m_zone, "zone422", 422, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3784", zones.back()->m_zone, "zone414", 414,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3785", zones.back()->m_zone, "zone415", 415,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B493", zones.back()->m_zone, "zone302", 302, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A532", zones.back()->m_zone, "zone835", 835, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A533", zones.back()->m_zone, "zone693", 693,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A534", zones.back()->m_zone, "zone562", 562, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A535", zones.back()->m_zone, "zone424", 424,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1181", zones.back()->m_zone, "zone792", 792,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3773", zones.back()->m_zone, "zone407", 407,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{8, 1, 5}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3784", zones.back()->m_zone, "zone412", 412,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3786", zones.back()->m_zone, "zone421", 421,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3787", zones.back()->m_zone, "zone418", 418,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2844", zones.back()->m_zone, "zone1441", 1441,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3779", zones.back()->m_zone, "zone409", 409,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{8, 1, 5}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3785", zones.back()->m_zone, "zone412", 412,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3788", zones.back()->m_zone, "zone416", 416,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3789", zones.back()->m_zone, "zone418", 418,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3790", zones.back()->m_zone, "zone425", 425,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1741", zones.back()->m_zone, "zone1057", 1057,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{12, 6, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3756", zones.back()->m_zone, "zone398", 398,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3776", zones.back()->m_zone, "zone408", 408,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{5, 6, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3788", zones.back()->m_zone, "zone415", 415,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3791", zones.back()->m_zone, "zone420", 420, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3792", zones.back()->m_zone, "zone417", 417,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B77", zones.back()->m_zone, "zone565", 565, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3758", zones.back()->m_zone, "zone399", 399,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3780", zones.back()->m_zone, "zone410", 410,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3792", zones.back()->m_zone, "zone416", 416,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3793", zones.back()->m_zone, "zone418", 418,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3794", zones.back()->m_zone, "zone419", 419,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1179", zones.back()->m_zone, "zone791", 791,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{8, 1, 12}},
                                                Ioss::IJK_t{{8, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3782", zones.back()->m_zone, "zone411", 411,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3787", zones.back()->m_zone, "zone414", 414,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3789", zones.back()->m_zone, "zone415", 415,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3793", zones.back()->m_zone, "zone417", 417,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3795", zones.back()->m_zone, "zone423", 423, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1467", zones.back()->m_zone, "zone928", 928, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3741", zones.back()->m_zone, "zone392", 392,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3794", zones.back()->m_zone, "zone417", 417, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3796", zones.back()->m_zone, "zone427", 427,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3797", zones.back()->m_zone, "zone420", 420,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3132", zones.back()->m_zone, "zone84", 84, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3739", zones.back()->m_zone, "zone390", 390,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3791", zones.back()->m_zone, "zone416", 416,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3797", zones.back()->m_zone, "zone419", 419,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3798", zones.back()->m_zone, "zone426", 426,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{51, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1127", zones.back()->m_zone, "zone772", 772,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3786", zones.back()->m_zone, "zone414", 414, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3799", zones.back()->m_zone, "zone422", 422,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3800", zones.back()->m_zone, "zone428", 428,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3801", zones.back()->m_zone, "zone423", 423,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2792", zones.back()->m_zone, "zone1423", 1423,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3783", zones.back()->m_zone, "zone412", 412,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3799", zones.back()->m_zone, "zone421", 421,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3802", zones.back()->m_zone, "zone429", 429, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3803", zones.back()->m_zone, "zone425", 425,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1122", zones.back()->m_zone, "zone771", 771,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3795", zones.back()->m_zone, "zone418", 418,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3801", zones.back()->m_zone, "zone421", 421,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3804", zones.back()->m_zone, "zone431", 431, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3805", zones.back()->m_zone, "zone427", 427, Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3806", zones.back()->m_zone, "zone425", 425,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B35", zones.back()->m_zone, "zone1164", 1164,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{5, 6, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B498", zones.back()->m_zone, "zone313", 313, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{6, 1, 6}}, Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B535", zones.back()->m_zone, "zone413", 413,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A536", zones.back()->m_zone, "zone563", 563, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{8, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A537", zones.back()->m_zone, "zone694", 694,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A538", zones.back()->m_zone, "zone836", 836, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2787", zones.back()->m_zone, "zone1422", 1422,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3790", zones.back()->m_zone, "zone415", 415, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3803", zones.back()->m_zone, "zone422", 422,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3806", zones.back()->m_zone, "zone423", 423,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3807", zones.back()->m_zone, "zone426", 426,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3808", zones.back()->m_zone, "zone430", 430,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x11 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3264", zones.back()->m_zone, "zone151", 151, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{51, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3798", zones.back()->m_zone, "zone420", 420,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3807", zones.back()->m_zone, "zone425", 425,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 12}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3809", zones.back()->m_zone, "zone433", 433,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3810", zones.back()->m_zone, "zone427", 427,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x7x11 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1599", zones.back()->m_zone, "zone995", 995, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 12}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{51, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3796", zones.back()->m_zone, "zone419", 419,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3805", zones.back()->m_zone, "zone423", 423,
                                                Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3810", zones.back()->m_zone, "zone426", 426,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{51, 8, 12}}, Ioss::IJK_t{{51, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3811", zones.back()->m_zone, "zone432", 432,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1130", zones.back()->m_zone, "zone773", 773, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3800", zones.back()->m_zone, "zone421", 421, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3812", zones.back()->m_zone, "zone429", 429,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3813", zones.back()->m_zone, "zone436", 436, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3814", zones.back()->m_zone, "zone431", 431,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2796", zones.back()->m_zone, "zone1424", 1424,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3802", zones.back()->m_zone, "zone422", 422, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3812", zones.back()->m_zone, "zone428", 428,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3815", zones.back()->m_zone, "zone434", 434, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3816", zones.back()->m_zone, "zone430", 430,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2799", zones.back()->m_zone, "zone1425", 1425,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3808", zones.back()->m_zone, "zone425", 425, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3816", zones.back()->m_zone, "zone429", 429,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3817", zones.back()->m_zone, "zone433", 433,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3818", zones.back()->m_zone, "zone431", 431,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3819", zones.back()->m_zone, "zone438", 438, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1135", zones.back()->m_zone, "zone774", 774, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3804", zones.back()->m_zone, "zone423", 423, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3814", zones.back()->m_zone, "zone428", 428,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3818", zones.back()->m_zone, "zone430", 430,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3820", zones.back()->m_zone, "zone437", 437, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3821", zones.back()->m_zone, "zone432", 432,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{51, 6, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1601", zones.back()->m_zone, "zone996", 996,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 6, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3811", zones.back()->m_zone, "zone427", 427,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3821", zones.back()->m_zone, "zone431", 431,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3822", zones.back()->m_zone, "zone433", 433,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3823", zones.back()->m_zone, "zone440", 440, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x5x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B3266", zones.back()->m_zone, "zone152", 152,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 6, 1}}, Ioss::IJK_t{{51, 6, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3809", zones.back()->m_zone, "zone426", 426,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3817", zones.back()->m_zone, "zone430", 430,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3822", zones.back()->m_zone, "zone432", 432,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3824", zones.back()->m_zone, "zone439", 439, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{51, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2811", zones.back()->m_zone, "zone1428", 1428,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3815", zones.back()->m_zone, "zone429", 429,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3825", zones.back()->m_zone, "zone441", 441, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3826", zones.back()->m_zone, "zone436", 436,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3827", zones.back()->m_zone, "zone438", 438,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("A539", zones.back()->m_zone, "zone734", 734,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A540", zones.back()->m_zone, "zone458", 458, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{8, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A541", zones.back()->m_zone, "zone524", 524,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A542", zones.back()->m_zone, "zone689", 689, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A543", zones.back()->m_zone, "zone447", 447,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1146", zones.back()->m_zone, "zone778", 778, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3813", zones.back()->m_zone, "zone428", 428, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3826", zones.back()->m_zone, "zone434", 434,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3828", zones.back()->m_zone, "zone442", 442,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3829", zones.back()->m_zone, "zone437", 437,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1150", zones.back()->m_zone, "zone779", 779, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3820", zones.back()->m_zone, "zone431", 431,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3829", zones.back()->m_zone, "zone436", 436,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3830", zones.back()->m_zone, "zone443", 443, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3831", zones.back()->m_zone, "zone440", 440,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3832", zones.back()->m_zone, "zone438", 438,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2815", zones.back()->m_zone, "zone1429", 1429,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3819", zones.back()->m_zone, "zone430", 430, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3827", zones.back()->m_zone, "zone434", 434,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3832", zones.back()->m_zone, "zone437", 437,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3833", zones.back()->m_zone, "zone439", 439,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3834", zones.back()->m_zone, "zone444", 444,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3261", zones.back()->m_zone, "zone150", 150, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3824", zones.back()->m_zone, "zone433", 433, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3833", zones.back()->m_zone, "zone438", 438,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3835", zones.back()->m_zone, "zone440", 440,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3836", zones.back()->m_zone, "zone451", 451,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1596", zones.back()->m_zone, "zone994", 994, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3823", zones.back()->m_zone, "zone432", 432, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{51, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3831", zones.back()->m_zone, "zone437", 437,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3835", zones.back()->m_zone, "zone439", 439,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3837", zones.back()->m_zone, "zone449", 449,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2802", zones.back()->m_zone, "zone1426", 1426,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3825", zones.back()->m_zone, "zone434", 434,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3838", zones.back()->m_zone, "zone453", 453, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3839", zones.back()->m_zone, "zone442", 442,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3840", zones.back()->m_zone, "zone444", 444,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1138", zones.back()->m_zone, "zone775", 775, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3828", zones.back()->m_zone, "zone436", 436, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3839", zones.back()->m_zone, "zone441", 441,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3841", zones.back()->m_zone, "zone454", 454,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3842", zones.back()->m_zone, "zone443", 443,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1143", zones.back()->m_zone, "zone777", 777, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3830", zones.back()->m_zone, "zone437", 437,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3842", zones.back()->m_zone, "zone442", 442,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3843", zones.back()->m_zone, "zone448", 448,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A3844", zones.back()->m_zone, "zone449", 449,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3845", zones.back()->m_zone, "zone444", 444,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2808", zones.back()->m_zone, "zone1427", 1427,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3834", zones.back()->m_zone, "zone438", 438, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3840", zones.back()->m_zone, "zone441", 441,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3845", zones.back()->m_zone, "zone443", 443,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3846", zones.back()->m_zone, "zone451", 451,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3847", zones.back()->m_zone, "zone445", 445,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3064", zones.back()->m_zone, "zone51", 51, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B3847", zones.back()->m_zone, "zone444", 444,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3848", zones.back()->m_zone, "zone452", 452,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3849", zones.back()->m_zone, "zone456", 456, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3850", zones.back()->m_zone, "zone448", 448,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B57", zones.back()->m_zone, "zone224", 224, Ioss::IJK_t{{1, -2, -3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B60", zones.back()->m_zone, "zone335", 335, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A64", zones.back()->m_zone, "zone610", 610,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{12, 1, 6}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A65", zones.back()->m_zone, "zone988", 988, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A66", zones.back()->m_zone, "zone649", 649, Ioss::IJK_t{{3, -2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{8, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A67", zones.back()->m_zone, "zone136", 136, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{12, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B410", zones.back()->m_zone, "zone36", 36, Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B543", zones.back()->m_zone, "zone435", 435,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A544", zones.back()->m_zone, "zone735", 735,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A545", zones.back()->m_zone, "zone690", 690, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A546", zones.back()->m_zone, "zone535", 535,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A547", zones.back()->m_zone, "zone469", 469, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back("B1399", zones.back()->m_zone, "zone895", 895,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B3843", zones.back()->m_zone, "zone443", 443,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 6}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3850", zones.back()->m_zone, "zone445", 445,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3851", zones.back()->m_zone, "zone450", 450, Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{51, 1, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3852", zones.back()->m_zone, "zone455", 455, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1590", zones.back()->m_zone, "zone991", 991,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 11, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3837", zones.back()->m_zone, "zone440", 440, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3844", zones.back()->m_zone, "zone443", 443,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3853", zones.back()->m_zone, "zone451", 451,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3854", zones.back()->m_zone, "zone450", 450,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1587", zones.back()->m_zone, "zone990", 990,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3851", zones.back()->m_zone, "zone448", 448,
                                                Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3854", zones.back()->m_zone, "zone449", 449, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3855", zones.back()->m_zone, "zone452", 452,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B3255", zones.back()->m_zone, "zone146", 146,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 11, 8}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3836", zones.back()->m_zone, "zone439", 439, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3846", zones.back()->m_zone, "zone444", 444,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3853", zones.back()->m_zone, "zone449", 449,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3856", zones.back()->m_zone, "zone452", 452,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 11, 1}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "50x10x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B3252", zones.back()->m_zone, "zone145", 145,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{51, 11, 1}}, Ioss::IJK_t{{51, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3848", zones.back()->m_zone, "zone445", 445,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3855", zones.back()->m_zone, "zone450", 450,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{51, 11, 8}}, Ioss::IJK_t{{51, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3856", zones.back()->m_zone, "zone451", 451, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{51, 1, 8}}, Ioss::IJK_t{{1, 11, 1}}, Ioss::IJK_t{{51, 11, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2774", zones.back()->m_zone, "zone1418", 1418,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3838", zones.back()->m_zone, "zone441", 441,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3857", zones.back()->m_zone, "zone457", 457, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3858", zones.back()->m_zone, "zone454", 454,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3859", zones.back()->m_zone, "zone456", 456,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 11}},
                                                Ioss::IJK_t{{11, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1110", zones.back()->m_zone, "zone768", 768, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3841", zones.back()->m_zone, "zone442", 442, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3858", zones.back()->m_zone, "zone453", 453,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3860", zones.back()->m_zone, "zone459", 459,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3861", zones.back()->m_zone, "zone455", 455,
                                                Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back("B1402", zones.back()->m_zone, "zone896", 896,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{11, 8, 11}},
                                                Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3852", zones.back()->m_zone, "zone448", 448, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 6}}, Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3861", zones.back()->m_zone, "zone454", 454, Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 11}}, Ioss::IJK_t{{1, 101, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3862", zones.back()->m_zone, "zone461", 461,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3863", zones.back()->m_zone, "zone456", 456,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3067", zones.back()->m_zone, "zone52", 52, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3849", zones.back()->m_zone, "zone445", 445, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 6}}, Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B3859", zones.back()->m_zone, "zone453", 453,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3863", zones.back()->m_zone, "zone455", 455,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A3864", zones.back()->m_zone, "zone460", 460,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2771", zones.back()->m_zone, "zone1417", 1417,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3857", zones.back()->m_zone, "zone453", 453,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3865", zones.back()->m_zone, "zone463", 463,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3866", zones.back()->m_zone, "zone459", 459,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3867", zones.back()->m_zone, "zone460", 460,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x30"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B540", zones.back()->m_zone, "zone435", 435, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A548", zones.back()->m_zone, "zone731", 731, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 31}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("A549", zones.back()->m_zone, "zone736", 736,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{8, 101, 31}}, Ioss::IJK_t{{8, 1, 31}},
                                                Ioss::IJK_t{{1, 101, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A550", zones.back()->m_zone, "zone502", 502, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 31}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("A551", zones.back()->m_zone, "zone469", 469,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 31}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1106", zones.back()->m_zone, "zone767", 767,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3860", zones.back()->m_zone, "zone454", 454, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3866", zones.back()->m_zone, "zone457", 457,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3868", zones.back()->m_zone, "zone462", 462,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3869", zones.back()->m_zone, "zone461", 461,
                                                Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3069", zones.back()->m_zone, "zone53", 53, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3864", zones.back()->m_zone, "zone456", 456, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{11, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B3867", zones.back()->m_zone, "zone457", 457,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{12, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3870", zones.back()->m_zone, "zone465", 465,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3871", zones.back()->m_zone, "zone461", 461,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1404", zones.back()->m_zone, "zone897", 897, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3862", zones.back()->m_zone, "zone455", 455, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{11, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3869", zones.back()->m_zone, "zone459", 459, Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 12}}, Ioss::IJK_t{{1, 101, 1}}, Ioss::IJK_t{{12, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3871", zones.back()->m_zone, "zone460", 460,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A3872", zones.back()->m_zone, "zone464", 464,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1103", zones.back()->m_zone, "zone766", 766, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3868", zones.back()->m_zone, "zone459", 459,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3873", zones.back()->m_zone, "zone463", 463,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3874", zones.back()->m_zone, "zone472", 472,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3875", zones.back()->m_zone, "zone464", 464,
                                                Ioss::IJK_t{{3, -1, -2}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{11, 1, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2768", zones.back()->m_zone, "zone1416", 1416,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3865", zones.back()->m_zone, "zone457", 457,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3873", zones.back()->m_zone, "zone462", 462,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3876", zones.back()->m_zone, "zone471", 471,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3877", zones.back()->m_zone, "zone465", 465,
                                                Ioss::IJK_t{{-3, 1, -2}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{1, 8, 12}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1405", zones.back()->m_zone, "zone899", 899, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3872", zones.back()->m_zone, "zone461", 461,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3875", zones.back()->m_zone, "zone462", 462,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{1, 101, 8}},
                                                Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3878", zones.back()->m_zone, "zone468", 468, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{11, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A3879", zones.back()->m_zone, "zone465", 465,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3070", zones.back()->m_zone, "zone54", 54, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3870", zones.back()->m_zone, "zone460", 460,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B3877", zones.back()->m_zone, "zone463", 463,
                                                Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 12}}, Ioss::IJK_t{{12, 101, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3879", zones.back()->m_zone, "zone464", 464,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3880", zones.back()->m_zone, "zone466", 466, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{11, 8, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3051", zones.back()->m_zone, "zone45", 45, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{1, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B3880", zones.back()->m_zone, "zone465", 465,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3881", zones.back()->m_zone, "zone467", 467, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 6}}, Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3882", zones.back()->m_zone, "zone471", 471, Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 11}}, Ioss::IJK_t{{1, 101, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3883", zones.back()->m_zone, "zone468", 468,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3050", zones.back()->m_zone, "zone44", 44, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3881", zones.back()->m_zone, "zone466", 466, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3884", zones.back()->m_zone, "zone474", 474,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3885", zones.back()->m_zone, "zone478", 478,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 6}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3886", zones.back()->m_zone, "zone470", 470,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back("B1386", zones.back()->m_zone, "zone890", 890,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B3878", zones.back()->m_zone, "zone464", 464,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3883", zones.back()->m_zone, "zone466", 466,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3887", zones.back()->m_zone, "zone470", 470, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 6}}, Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A3888", zones.back()->m_zone, "zone472", 472,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x30 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B415", zones.back()->m_zone, "zone47", 47, Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 1, 31}}, Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{5, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B547", zones.back()->m_zone, "zone447", 447, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B551", zones.back()->m_zone, "zone458", 458,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 31}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A552", zones.back()->m_zone, "zone513", 513, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 31}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("A553", zones.back()->m_zone, "zone737", 737,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{8, 6, 31}}, Ioss::IJK_t{{8, 1, 31}},
                                                Ioss::IJK_t{{1, 6, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A554", zones.back()->m_zone, "zone733", 733, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 31}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1385", zones.back()->m_zone, "zone889", 889, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B3886", zones.back()->m_zone, "zone467", 467,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3887", zones.back()->m_zone, "zone468", 468, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3889", zones.back()->m_zone, "zone473", 473,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3890", zones.back()->m_zone, "zone477", 477,
                                                Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2751", zones.back()->m_zone, "zone1411", 1411,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3876", zones.back()->m_zone, "zone463", 463,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3882", zones.back()->m_zone, "zone466", 466,
                                                Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A3891", zones.back()->m_zone, "zone476", 476,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3892", zones.back()->m_zone, "zone472", 472,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1086", zones.back()->m_zone, "zone760", 760, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3874", zones.back()->m_zone, "zone462", 462,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3888", zones.back()->m_zone, "zone468", 468,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 11}},
                                                Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3892", zones.back()->m_zone, "zone471", 471,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3893", zones.back()->m_zone, "zone475", 475,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1380", zones.back()->m_zone, "zone886", 886, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3889", zones.back()->m_zone, "zone470", 470,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3894", zones.back()->m_zone, "zone474", 474,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3895", zones.back()->m_zone, "zone488", 488,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3896", zones.back()->m_zone, "zone484", 484,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3045", zones.back()->m_zone, "zone42", 42, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3884", zones.back()->m_zone, "zone467", 467,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3894", zones.back()->m_zone, "zone473", 473,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3897", zones.back()->m_zone, "zone489", 489, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3898", zones.back()->m_zone, "zone485", 485,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x10 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1097", zones.back()->m_zone, "zone763", 763, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B3893", zones.back()->m_zone, "zone472", 472,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3899", zones.back()->m_zone, "zone476", 476, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 11}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A3900", zones.back()->m_zone, "zone483", 483,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{8, 101, 11}}, Ioss::IJK_t{{8, 1, 5}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A3901", zones.back()->m_zone, "zone477", 477,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 11}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x10 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2763", zones.back()->m_zone, "zone1414", 1414,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 11}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B3891", zones.back()->m_zone, "zone471", 471,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3899", zones.back()->m_zone, "zone475", 475, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A3902", zones.back()->m_zone, "zone482", 482,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{8, 101, 11}}, Ioss::IJK_t{{8, 1, 5}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A3903", zones.back()->m_zone, "zone478", 478,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 11}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x10"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1102", zones.back()->m_zone, "zone764", 764, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 11}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3890", zones.back()->m_zone, "zone470", 470, Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B3901", zones.back()->m_zone, "zone475", 475,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 11}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A3904", zones.back()->m_zone, "zone488", 488,
                                                Ioss::IJK_t{{3, -2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 11}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3905", zones.back()->m_zone, "zone479", 479,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{8, 6, 11}}, Ioss::IJK_t{{8, 1, 5}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3906", zones.back()->m_zone, "zone478", 478, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x10"));

  zones.back()->m_zoneConnectivity.emplace_back("B2766", zones.back()->m_zone, "zone1415", 1415,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 11}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B3885", zones.back()->m_zone, "zone467", 467,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B3903", zones.back()->m_zone, "zone476", 476,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 11}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3906", zones.back()->m_zone, "zone477", 477, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 11}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A3907", zones.back()->m_zone, "zone489", 489,
                                                Ioss::IJK_t{{-3, -2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 11}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3908", zones.back()->m_zone, "zone481", 481,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{8, 6, 11}}, Ioss::IJK_t{{8, 1, 5}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x4"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1212", zones.back()->m_zone, "zone807", 807, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3905", zones.back()->m_zone, "zone477", 477,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{8, 1, 11}},
                                                Ioss::IJK_t{{1, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A3909", zones.back()->m_zone, "zone494", 494,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3910", zones.back()->m_zone, "zone481", 481, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 5}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A3911", zones.back()->m_zone, "zone490", 490,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 5}}, Ioss::IJK_t{{1, 6, 8}},
                                                Ioss::IJK_t{{5, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3912", zones.back()->m_zone, "zone483", 483,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x30"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "A555", zones.back()->m_zone, "zone747", 747, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A556", zones.back()->m_zone, "zone753", 753, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 31}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("A557", zones.back()->m_zone, "zone502", 502,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{8, 101, 31}}, Ioss::IJK_t{{8, 1, 31}},
                                                Ioss::IJK_t{{1, 101, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A558", zones.back()->m_zone, "zone736", 736, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 31}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("A559", zones.back()->m_zone, "zone491", 491,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 31}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x4"));

  zones.back()->m_zoneConnectivity.emplace_back("B2877", zones.back()->m_zone, "zone1458", 1458,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 5}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3908", zones.back()->m_zone, "zone478", 478,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{8, 1, 11}},
                                                Ioss::IJK_t{{1, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3910", zones.back()->m_zone, "zone479", 479, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A3913", zones.back()->m_zone, "zone493", 493,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3914", zones.back()->m_zone, "zone492", 492,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 5}}, Ioss::IJK_t{{5, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3915", zones.back()->m_zone, "zone482", 482,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x4 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2874", zones.back()->m_zone, "zone1457", 1457,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3902", zones.back()->m_zone, "zone476", 476,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{8, 1, 11}},
                                                Ioss::IJK_t{{1, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B3915", zones.back()->m_zone, "zone481", 481,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A3916", zones.back()->m_zone, "zone496", 496,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3917", zones.back()->m_zone, "zone483", 483, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 5}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x4 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1209", zones.back()->m_zone, "zone806", 806, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 5}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3900", zones.back()->m_zone, "zone475", 475,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{8, 1, 11}},
                                                Ioss::IJK_t{{1, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B3912", zones.back()->m_zone, "zone479", 479,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3917", zones.back()->m_zone, "zone482", 482, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A3918", zones.back()->m_zone, "zone495", 495,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1413", zones.back()->m_zone, "zone903", 903,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 6, 8}},
                                                Ioss::IJK_t{{11, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3896", zones.back()->m_zone, "zone473", 473,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3919", zones.back()->m_zone, "zone498", 498, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3920", zones.back()->m_zone, "zone486", 486,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3921", zones.back()->m_zone, "zone485", 485,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3078", zones.back()->m_zone, "zone59", 59, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{11, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3898", zones.back()->m_zone, "zone474", 474,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3921", zones.back()->m_zone, "zone484", 484,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3922", zones.back()->m_zone, "zone487", 487,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3923", zones.back()->m_zone, "zone497", 497,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1415", zones.back()->m_zone, "zone904", 904,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3920", zones.back()->m_zone, "zone484", 484,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3924", zones.back()->m_zone, "zone487", 487,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3925", zones.back()->m_zone, "zone507", 507,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3926", zones.back()->m_zone, "zone533", 533,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B3080", zones.back()->m_zone, "zone60", 60,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3922", zones.back()->m_zone, "zone485", 485,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3924", zones.back()->m_zone, "zone486", 486,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3927", zones.back()->m_zone, "zone506", 506,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3928", zones.back()->m_zone, "zone532", 532,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B162", zones.back()->m_zone, "zone787", 787, Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 11, 8}}, Ioss::IJK_t{{6, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3895", zones.back()->m_zone, "zone473", 473, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3904", zones.back()->m_zone, "zone477", 477,
                                                Ioss::IJK_t{{3, -2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A3929", zones.back()->m_zone, "zone489", 489,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3930", zones.back()->m_zone, "zone490", 490,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{5, 6, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3931", zones.back()->m_zone, "zone498", 498,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1827", zones.back()->m_zone, "zone1079", 1079,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3897", zones.back()->m_zone, "zone474", 474,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3907", zones.back()->m_zone, "zone478", 478,
                                                Ioss::IJK_t{{-3, -2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{8, 1, 11}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3929", zones.back()->m_zone, "zone488", 488,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3932", zones.back()->m_zone, "zone492", 492,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3933", zones.back()->m_zone, "zone497", 497,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B100", zones.back()->m_zone, "zone621", 621, Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{1, 5, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3911", zones.back()->m_zone, "zone479", 479,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3930", zones.back()->m_zone, "zone488", 488,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3934", zones.back()->m_zone, "zone494", 494,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3935", zones.back()->m_zone, "zone500", 500, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{5, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3936", zones.back()->m_zone, "zone492", 492,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x30 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B205", zones.back()->m_zone, "zone898", 898, Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 1, 31}}, Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{5, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B559", zones.back()->m_zone, "zone480", 480,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 31}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A560", zones.back()->m_zone, "zone748", 748, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{31, 1, 8}}, Ioss::IJK_t{{31, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A561", zones.back()->m_zone, "zone737", 737, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 31}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("A562", zones.back()->m_zone, "zone513", 513,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{8, 6, 31}}, Ioss::IJK_t{{8, 1, 31}},
                                                Ioss::IJK_t{{1, 6, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A563", zones.back()->m_zone, "zone755", 755, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 31}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1765", zones.back()->m_zone, "zone1062", 1062,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{1, 5, 8}},
                                                Ioss::IJK_t{{6, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3914", zones.back()->m_zone, "zone481", 481,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3932", zones.back()->m_zone, "zone489", 489,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3936", zones.back()->m_zone, "zone490", 490,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3937", zones.back()->m_zone, "zone499", 499, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{5, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3938", zones.back()->m_zone, "zone493", 493,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2880", zones.back()->m_zone, "zone1460", 1460,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3913", zones.back()->m_zone, "zone481", 481,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3938", zones.back()->m_zone, "zone492", 492,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{5, 6, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3939", zones.back()->m_zone, "zone494", 494,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3940", zones.back()->m_zone, "zone503", 503, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3941", zones.back()->m_zone, "zone496", 496,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1215", zones.back()->m_zone, "zone810", 810, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3909", zones.back()->m_zone, "zone479", 479,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3934", zones.back()->m_zone, "zone490", 490,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3939", zones.back()->m_zone, "zone493", 493,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3942", zones.back()->m_zone, "zone501", 501, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3943", zones.back()->m_zone, "zone495", 495,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1213", zones.back()->m_zone, "zone808", 808, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3918", zones.back()->m_zone, "zone483", 483,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3943", zones.back()->m_zone, "zone494", 494,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3944", zones.back()->m_zone, "zone496", 496,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3945", zones.back()->m_zone, "zone504", 504, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2878", zones.back()->m_zone, "zone1459", 1459,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3916", zones.back()->m_zone, "zone482", 482,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3941", zones.back()->m_zone, "zone493", 493,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3944", zones.back()->m_zone, "zone495", 495,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3946", zones.back()->m_zone, "zone505", 505, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1837", zones.back()->m_zone, "zone1082", 1082,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3923", zones.back()->m_zone, "zone485", 485, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3933", zones.back()->m_zone, "zone489", 489,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3947", zones.back()->m_zone, "zone506", 506, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3948", zones.back()->m_zone, "zone498", 498,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3949", zones.back()->m_zone, "zone499", 499,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B173", zones.back()->m_zone, "zone820", 820,
                                                Ioss::IJK_t{{-1, -3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3919", zones.back()->m_zone, "zone484", 484,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3931", zones.back()->m_zone, "zone488", 488,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3948", zones.back()->m_zone, "zone497", 497,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3950", zones.back()->m_zone, "zone500", 500, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3951", zones.back()->m_zone, "zone507", 507, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1791", zones.back()->m_zone, "zone1069", 1069,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{1, 6, 8}},
                                                Ioss::IJK_t{{5, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3937", zones.back()->m_zone, "zone492", 492, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3949", zones.back()->m_zone, "zone497", 497, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3952", zones.back()->m_zone, "zone508", 508, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{5, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3953", zones.back()->m_zone, "zone500", 500,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3954", zones.back()->m_zone, "zone503", 503,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B126", zones.back()->m_zone, "zone687", 687, Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{5, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3935", zones.back()->m_zone, "zone490", 490, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3950", zones.back()->m_zone, "zone498", 498, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3953", zones.back()->m_zone, "zone499", 499,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3955", zones.back()->m_zone, "zone501", 501,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3956", zones.back()->m_zone, "zone509", 509, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{5, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B531", zones.back()->m_zone, "zone402", 402, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3942", zones.back()->m_zone, "zone494", 494, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3955", zones.back()->m_zone, "zone500", 500,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3957", zones.back()->m_zone, "zone511", 511, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3958", zones.back()->m_zone, "zone503", 503,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3959", zones.back()->m_zone, "zone504", 504,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x30"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B550", zones.back()->m_zone, "zone458", 458, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 31}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B557", zones.back()->m_zone, "zone480", 480,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{8, 101, 31}}, Ioss::IJK_t{{8, 1, 31}},
                                                Ioss::IJK_t{{1, 101, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A564", zones.back()->m_zone, "zone524", 524, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A565", zones.back()->m_zone, "zone756", 756, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 31}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("A566", zones.back()->m_zone, "zone513", 513,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 31}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2195", zones.back()->m_zone, "zone1190", 1190,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3940", zones.back()->m_zone, "zone493", 493, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3954", zones.back()->m_zone, "zone499", 499,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 8}}, Ioss::IJK_t{{5, 8, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3958", zones.back()->m_zone, "zone501", 501,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3960", zones.back()->m_zone, "zone510", 510, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3961", zones.back()->m_zone, "zone505", 505,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B526", zones.back()->m_zone, "zone391", 391, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3945", zones.back()->m_zone, "zone495", 495, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3959", zones.back()->m_zone, "zone501", 501,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3962", zones.back()->m_zone, "zone505", 505,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3963", zones.back()->m_zone, "zone514", 514, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2192", zones.back()->m_zone, "zone1189", 1189,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3946", zones.back()->m_zone, "zone496", 496, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3961", zones.back()->m_zone, "zone503", 503,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3962", zones.back()->m_zone, "zone504", 504,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3964", zones.back()->m_zone, "zone512", 512, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1844", zones.back()->m_zone, "zone1083", 1083,
                                                Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3927", zones.back()->m_zone, "zone487", 487,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3947", zones.back()->m_zone, "zone497", 497, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3965", zones.back()->m_zone, "zone528", 528, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3966", zones.back()->m_zone, "zone507", 507,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3967", zones.back()->m_zone, "zone508", 508,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B179", zones.back()->m_zone, "zone832", 832, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3925", zones.back()->m_zone, "zone486", 486,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3951", zones.back()->m_zone, "zone498", 498, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3966", zones.back()->m_zone, "zone506", 506,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 8, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3968", zones.back()->m_zone, "zone509", 509, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3969", zones.back()->m_zone, "zone529", 529, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{11, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1794", zones.back()->m_zone, "zone1070", 1070,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3952", zones.back()->m_zone, "zone499", 499, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3967", zones.back()->m_zone, "zone506", 506, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3970", zones.back()->m_zone, "zone520", 520, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{5, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3971", zones.back()->m_zone, "zone509", 509,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3972", zones.back()->m_zone, "zone510", 510,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x7x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B129", zones.back()->m_zone, "zone698", 698, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3956", zones.back()->m_zone, "zone500", 500, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3968", zones.back()->m_zone, "zone507", 507, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3971", zones.back()->m_zone, "zone508", 508,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 8, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3973", zones.back()->m_zone, "zone511", 511,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3974", zones.back()->m_zone, "zone519", 519, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{5, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2189", zones.back()->m_zone, "zone1188", 1188,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3960", zones.back()->m_zone, "zone503", 503, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3972", zones.back()->m_zone, "zone508", 508,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 8}}, Ioss::IJK_t{{5, 8, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3975", zones.back()->m_zone, "zone511", 511,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3976", zones.back()->m_zone, "zone517", 517, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3977", zones.back()->m_zone, "zone512", 512,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B522", zones.back()->m_zone, "zone380", 380, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3957", zones.back()->m_zone, "zone501", 501, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3973", zones.back()->m_zone, "zone509", 509,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3975", zones.back()->m_zone, "zone510", 510,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3978", zones.back()->m_zone, "zone518", 518, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3979", zones.back()->m_zone, "zone514", 514,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 8}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2183", zones.back()->m_zone, "zone1186", 1186,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3964", zones.back()->m_zone, "zone505", 505, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3977", zones.back()->m_zone, "zone510", 510,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3980", zones.back()->m_zone, "zone516", 516, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3981", zones.back()->m_zone, "zone514", 514,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x30 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B430", zones.back()->m_zone, "zone102", 102, Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 1, 31}}, Ioss::IJK_t{{5, 8, 1}}, Ioss::IJK_t{{5, 1, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B552", zones.back()->m_zone, "zone469", 469, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 31}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B562", zones.back()->m_zone, "zone491", 491,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 31}},
                                                Ioss::IJK_t{{8, 6, 31}}, Ioss::IJK_t{{8, 1, 31}},
                                                Ioss::IJK_t{{1, 6, 31}});

  zones.back()->m_zoneConnectivity.emplace_back("B566", zones.back()->m_zone, "zone502", 502,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 31}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 31}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A567", zones.back()->m_zone, "zone535", 535, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A568", zones.back()->m_zone, "zone757", 757, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 31}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 31}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B520", zones.back()->m_zone, "zone369", 369, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3963", zones.back()->m_zone, "zone504", 504, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3979", zones.back()->m_zone, "zone511", 511,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3981", zones.back()->m_zone, "zone512", 512,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{8, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3982", zones.back()->m_zone, "zone515", 515, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1270", zones.back()->m_zone, "zone833", 833, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3982", zones.back()->m_zone, "zone514", 514, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3983", zones.back()->m_zone, "zone516", 516,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3984", zones.back()->m_zone, "zone523", 523,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3985", zones.back()->m_zone, "zone518", 518,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2935", zones.back()->m_zone, "zone1482", 1482,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3980", zones.back()->m_zone, "zone512", 512, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3983", zones.back()->m_zone, "zone515", 515,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3986", zones.back()->m_zone, "zone525", 525,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3987", zones.back()->m_zone, "zone517", 517,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B2937", zones.back()->m_zone, "zone1483", 1483,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3976", zones.back()->m_zone, "zone510", 510, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3987", zones.back()->m_zone, "zone516", 516,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3988", zones.back()->m_zone, "zone520", 520,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{5, 6, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3989", zones.back()->m_zone, "zone518", 518,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3990", zones.back()->m_zone, "zone521", 521,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1272", zones.back()->m_zone, "zone834", 834, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{6, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3978", zones.back()->m_zone, "zone511", 511, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3985", zones.back()->m_zone, "zone515", 515,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3989", zones.back()->m_zone, "zone517", 517,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3991", zones.back()->m_zone, "zone522", 522,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A3992", zones.back()->m_zone, "zone519", 519,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B153", zones.back()->m_zone, "zone765", 765, Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{1, 5, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3974", zones.back()->m_zone, "zone509", 509, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3992", zones.back()->m_zone, "zone518", 518,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3993", zones.back()->m_zone, "zone522", 522,
                                                Ioss::IJK_t{{3, -2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A3994", zones.back()->m_zone, "zone520", 520,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3995", zones.back()->m_zone, "zone529", 529, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1819", zones.back()->m_zone, "zone1077", 1077,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{1, 5, 8}},
                                                Ioss::IJK_t{{6, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3970", zones.back()->m_zone, "zone508", 508, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3988", zones.back()->m_zone, "zone517", 517,
                                                Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3994", zones.back()->m_zone, "zone519", 519,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3996", zones.back()->m_zone, "zone528", 528, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A3997", zones.back()->m_zone, "zone521", 521,
                                                Ioss::IJK_t{{-3, -2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{8, 1, 5}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x4"));

  zones.back()->m_zoneConnectivity.emplace_back("B2908", zones.back()->m_zone, "zone1470", 1470,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3990", zones.back()->m_zone, "zone517", 517,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B3997", zones.back()->m_zone, "zone520", 520,
                                                Ioss::IJK_t{{-3, -2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 5}}, Ioss::IJK_t{{5, 1, 8}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A3998", zones.back()->m_zone, "zone522", 522, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 5}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A3999", zones.back()->m_zone, "zone530", 530,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{8, 1, 11}},
                                                Ioss::IJK_t{{1, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A4000", zones.back()->m_zone, "zone525", 525,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x4"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1243", zones.back()->m_zone, "zone819", 819, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 5}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3991", zones.back()->m_zone, "zone518", 518,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3993", zones.back()->m_zone, "zone519", 519,
                                                Ioss::IJK_t{{3, -2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 5}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3998", zones.back()->m_zone, "zone521", 521, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A4001", zones.back()->m_zone, "zone531", 531,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{8, 1, 11}},
                                                Ioss::IJK_t{{1, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A4002", zones.back()->m_zone, "zone523", 523,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x4 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1240", zones.back()->m_zone, "zone818", 818, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3984", zones.back()->m_zone, "zone515", 515,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B4002", zones.back()->m_zone, "zone522", 522,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A4003", zones.back()->m_zone, "zone525", 525, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 5}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A4004", zones.back()->m_zone, "zone527", 527,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{8, 1, 11}},
                                                Ioss::IJK_t{{1, 101, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B541", zones.back()->m_zone, "zone435", 435,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B564", zones.back()->m_zone, "zone502", 502, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A569", zones.back()->m_zone, "zone546", 546, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{6, 1, 6}}, Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A570", zones.back()->m_zone, "zone684", 684, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A571", zones.back()->m_zone, "zone535", 535,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x4 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2905", zones.back()->m_zone, "zone1469", 1469,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 5}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B3986", zones.back()->m_zone, "zone516", 516,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B4000", zones.back()->m_zone, "zone521", 521,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B4003", zones.back()->m_zone, "zone523", 523, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A4005", zones.back()->m_zone, "zone526", 526,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{8, 1, 11}},
                                                Ioss::IJK_t{{1, 101, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x10 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2898", zones.back()->m_zone, "zone1467", 1467,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 11}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B4005", zones.back()->m_zone, "zone525", 525,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{8, 101, 11}}, Ioss::IJK_t{{8, 1, 5}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A4006", zones.back()->m_zone, "zone539", 539,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A4007", zones.back()->m_zone, "zone527", 527, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 11}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A4008", zones.back()->m_zone, "zone530", 530,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 11}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x10 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1234", zones.back()->m_zone, "zone816", 816, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 11}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B4004", zones.back()->m_zone, "zone523", 523,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{8, 101, 11}}, Ioss::IJK_t{{8, 1, 5}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B4007", zones.back()->m_zone, "zone526", 526, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A4009", zones.back()->m_zone, "zone540", 540,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A4010", zones.back()->m_zone, "zone531", 531,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 11}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B1858", zones.back()->m_zone, "zone1088", 1088,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 11, 8}},
                                                Ioss::IJK_t{{6, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3965", zones.back()->m_zone, "zone506", 506, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3996", zones.back()->m_zone, "zone520", 520,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A4011", zones.back()->m_zone, "zone532", 532, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A4012", zones.back()->m_zone, "zone530", 530,
                                                Ioss::IJK_t{{3, -2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A4013", zones.back()->m_zone, "zone529", 529,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B192", zones.back()->m_zone, "zone876", 876, Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{1, 11, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3969", zones.back()->m_zone, "zone507", 507, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3995", zones.back()->m_zone, "zone519", 519, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{5, 1, 1}}, Ioss::IJK_t{{5, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B4013", zones.back()->m_zone, "zone528", 528,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A4014", zones.back()->m_zone, "zone531", 531,
                                                Ioss::IJK_t{{-3, -2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{8, 1, 11}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A4015", zones.back()->m_zone, "zone533", 533,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x10"));

  zones.back()->m_zoneConnectivity.emplace_back("B2903", zones.back()->m_zone, "zone1468", 1468,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 11}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B3999", zones.back()->m_zone, "zone521", 521,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{8, 6, 11}}, Ioss::IJK_t{{8, 1, 5}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B4008", zones.back()->m_zone, "zone526", 526,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 11}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B4012", zones.back()->m_zone, "zone528", 528,
                                                Ioss::IJK_t{{3, -2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 11}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A4016", zones.back()->m_zone, "zone536", 536, Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A4017", zones.back()->m_zone, "zone531", 531, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x10"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1237", zones.back()->m_zone, "zone817", 817, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 11}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B4001", zones.back()->m_zone, "zone522", 522,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{8, 6, 11}}, Ioss::IJK_t{{8, 1, 5}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B4010", zones.back()->m_zone, "zone527", 527,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 11}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B4014", zones.back()->m_zone, "zone529", 529,
                                                Ioss::IJK_t{{-3, -2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 11}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B4017", zones.back()->m_zone, "zone530", 530, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 11}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A4018", zones.back()->m_zone, "zone534", 534,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3087", zones.back()->m_zone, "zone62", 62, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3928", zones.back()->m_zone, "zone487", 487,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B4011", zones.back()->m_zone, "zone528", 528,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A4019", zones.back()->m_zone, "zone536", 536,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A4020", zones.back()->m_zone, "zone533", 533,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1422", zones.back()->m_zone, "zone906", 906, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3926", zones.back()->m_zone, "zone486", 486,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B4015", zones.back()->m_zone, "zone529", 529, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B4020", zones.back()->m_zone, "zone532", 532,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A4021", zones.back()->m_zone, "zone534", 534,
                                                Ioss::IJK_t{{1, -3, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1431", zones.back()->m_zone, "zone913", 913, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B4018", zones.back()->m_zone, "zone531", 531,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 6}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B4021", zones.back()->m_zone, "zone533", 533,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A4022", zones.back()->m_zone, "zone537", 537,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 6}},
                                                Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A4023", zones.back()->m_zone, "zone536", 536,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B427", zones.back()->m_zone, "zone91", 91, Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{5, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B546", zones.back()->m_zone, "zone447", 447,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B567", zones.back()->m_zone, "zone513", 513, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{8, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B571", zones.back()->m_zone, "zone524", 524,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A572", zones.back()->m_zone, "zone555", 555, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A573", zones.back()->m_zone, "zone685", 685, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x5"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3096", zones.back()->m_zone, "zone68", 68, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 6}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B4016", zones.back()->m_zone, "zone530", 530,
                                                Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B4019", zones.back()->m_zone, "zone532", 532,
                                                Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B4023", zones.back()->m_zone, "zone534", 534,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A4024", zones.back()->m_zone, "zone538", 538,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 6}},
                                                Ioss::IJK_t{{11, 8, 6}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back("B1436", zones.back()->m_zone, "zone915", 915,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B4022", zones.back()->m_zone, "zone534", 534,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 8, 6}},
                                                Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A4025", zones.back()->m_zone, "zone538", 538,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A4026", zones.back()->m_zone, "zone541", 541,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A4027", zones.back()->m_zone, "zone540", 540,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 101, 8}},
                                                Ioss::IJK_t{{11, 101, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3101", zones.back()->m_zone, "zone71", 71, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
      Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B4024", zones.back()->m_zone, "zone536", 536,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 8, 6}},
                                                Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B4025", zones.back()->m_zone, "zone537", 537,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A4028", zones.back()->m_zone, "zone539", 539,
                                                Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 11}}, Ioss::IJK_t{{11, 101, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A4029", zones.back()->m_zone, "zone542", 542,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2895", zones.back()->m_zone, "zone1466", 1466,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B4006", zones.back()->m_zone, "zone526", 526,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{8, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B4028", zones.back()->m_zone, "zone538", 538,
                                                Ioss::IJK_t{{-3, 1, -2}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 8, 11}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A4030", zones.back()->m_zone, "zone544", 544,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A4031", zones.back()->m_zone, "zone540", 540,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1230", zones.back()->m_zone, "zone815", 815, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B4009", zones.back()->m_zone, "zone527", 527,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B4027", zones.back()->m_zone, "zone537", 537,
                                                Ioss::IJK_t{{3, -1, -2}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{11, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B4031", zones.back()->m_zone, "zone539", 539,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A4032", zones.back()->m_zone, "zone543", 543,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1440", zones.back()->m_zone, "zone917", 917, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B4026", zones.back()->m_zone, "zone537", 537,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 8, 11}},
                                                Ioss::IJK_t{{1, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A4033", zones.back()->m_zone, "zone543", 543,
                                                Ioss::IJK_t{{2, -3, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 12}}, Ioss::IJK_t{{12, 101, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A4034", zones.back()->m_zone, "zone545", 545,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A4035", zones.back()->m_zone, "zone542", 542,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3105", zones.back()->m_zone, "zone73", 73, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B4029", zones.back()->m_zone, "zone538", 538,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{11, 8, 11}},
                                                Ioss::IJK_t{{1, 1, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B4035", zones.back()->m_zone, "zone541", 541,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A4036", zones.back()->m_zone, "zone548", 548,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A4037", zones.back()->m_zone, "zone544", 544,
                                                Ioss::IJK_t{{-2, -3, 1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{1, 101, 8}},
                                                Ioss::IJK_t{{12, 101, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1244", zones.back()->m_zone, "zone821", 821, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B4032", zones.back()->m_zone, "zone540", 540,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B4033", zones.back()->m_zone, "zone541", 541,
                                                Ioss::IJK_t{{-3, 1, -2}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{1, 8, 12}},
                                                Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A4038", zones.back()->m_zone, "zone544", 544,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A4039", zones.back()->m_zone, "zone550", 550,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2909", zones.back()->m_zone, "zone1471", 1471,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B4030", zones.back()->m_zone, "zone539", 539,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B4037", zones.back()->m_zone, "zone542", 542,
                                                Ioss::IJK_t{{3, -1, -2}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{11, 1, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B4038", zones.back()->m_zone, "zone543", 543,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A4040", zones.back()->m_zone, "zone552", 552,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1443", zones.back()->m_zone, "zone918", 918, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B4034", zones.back()->m_zone, "zone541", 541,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A4041", zones.back()->m_zone, "zone547", 547, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{11, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("A4042", zones.back()->m_zone, "zone550", 550,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{12, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A4043", zones.back()->m_zone, "zone548", 548,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x5 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B569", zones.back()->m_zone, "zone524", 524, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 6}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A574", zones.back()->m_zone, "zone793", 793,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A575", zones.back()->m_zone, "zone800", 800, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A576", zones.back()->m_zone, "zone680", 680, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{6, 101, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A577", zones.back()->m_zone, "zone555", 555,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 6}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back("B1446", zones.back()->m_zone, "zone919", 919,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{11, 8, 11}},
                                                Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3336", zones.back()->m_zone, "zone197", 197, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 6}}, Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B4041", zones.back()->m_zone, "zone545", 545,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A4044", zones.back()->m_zone, "zone551", 551,
                                                Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A4045", zones.back()->m_zone, "zone549", 549,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 11}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x11"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3108", zones.back()->m_zone, "zone74", 74, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 12}}, Ioss::IJK_t{{1, 8, 1}}, Ioss::IJK_t{{11, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B4036", zones.back()->m_zone, "zone542", 542,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B4043", zones.back()->m_zone, "zone545", 545,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 12}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A4046", zones.back()->m_zone, "zone549", 549, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{11, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A4047", zones.back()->m_zone, "zone552", 552, Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 12}}, Ioss::IJK_t{{1, 101, 1}}, Ioss::IJK_t{{12, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x7x10"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3111", zones.back()->m_zone, "zone75", 75, Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 11}}, Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3340", zones.back()->m_zone, "zone198", 198, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 8, 1}}, Ioss::IJK_t{{1, 1, 6}}, Ioss::IJK_t{{11, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B4045", zones.back()->m_zone, "zone547", 547,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 8, 1}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{11, 8, 1}},
                                                Ioss::IJK_t{{1, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B4046", zones.back()->m_zone, "zone548", 548,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 11}},
                                                Ioss::IJK_t{{11, 8, 11}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A4048", zones.back()->m_zone, "zone553", 553, Ioss::IJK_t{{2, 3, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 8, 11}}, Ioss::IJK_t{{1, 101, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B1248", zones.back()->m_zone, "zone822", 822,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B4039", zones.back()->m_zone, "zone543", 543,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B4042", zones.back()->m_zone, "zone545", 545,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{11, 1, 12}},
                                                Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A4049", zones.back()->m_zone, "zone552", 552,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A4050", zones.back()->m_zone, "zone551", 551,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B1305", zones.back()->m_zone, "zone852", 852, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B3345", zones.back()->m_zone, "zone200", 200,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B4044", zones.back()->m_zone, "zone547", 547,
                                                Ioss::IJK_t{{-3, -1, 2}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 11}},
                                                Ioss::IJK_t{{11, 8, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B4050", zones.back()->m_zone, "zone550", 550, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A4051", zones.back()->m_zone, "zone553", 553,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back("B2913", zones.back()->m_zone, "zone1472", 1472,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B4040", zones.back()->m_zone, "zone544", 544,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B4047", zones.back()->m_zone, "zone548", 548,
                                                Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("B4049", zones.back()->m_zone, "zone550", 550,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{12, 101, 8}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A4052", zones.back()->m_zone, "zone553", 553, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B2971", zones.back()->m_zone, "zone8", 8, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 8}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B3343", zones.back()->m_zone, "zone199", 199, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B4048", zones.back()->m_zone, "zone549", 549,
                                                Ioss::IJK_t{{3, 1, 2}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 8, 11}});

  zones.back()->m_zoneConnectivity.emplace_back("B4051", zones.back()->m_zone, "zone551", 551,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("B4052", zones.back()->m_zone, "zone552", 552,
                                                Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "4x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "A68", zones.back()->m_zone, "zone587", 587, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 6, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A69", zones.back()->m_zone, "zone565", 565, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A70", zones.back()->m_zone, "zone147", 147, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{5, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{5, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A71", zones.back()->m_zone, "zone410", 410, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{5, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A72", zones.back()->m_zone, "zone796", 796, Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{5, 1, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A73", zones.back()->m_zone, "zone790", 790, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{5, 6, 8}}, Ioss::IJK_t{{1, 1, 5}}, Ioss::IJK_t{{8, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x5"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B423", zones.back()->m_zone, "zone80", 80, Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 1, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B572", zones.back()->m_zone, "zone535", 535, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B577", zones.back()->m_zone, "zone546", 546,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 6}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A578", zones.back()->m_zone, "zone794", 794,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A579", zones.back()->m_zone, "zone681", 681, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{6, 6, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A580", zones.back()->m_zone, "zone801", 801, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 6}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{1, 6, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B525", zones.back()->m_zone, "zone391", 391, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A581", zones.back()->m_zone, "zone682", 682, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{6, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A582", zones.back()->m_zone, "zone808", 808, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A583", zones.back()->m_zone, "zone573", 573, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A584", zones.back()->m_zone, "zone557", 557,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 8}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B118", zones.back()->m_zone, "zone676", 676,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B529", zones.back()->m_zone, "zone402", 402, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("B584", zones.back()->m_zone, "zone556", 556,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A585", zones.back()->m_zone, "zone683", 683, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{6, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A586", zones.back()->m_zone, "zone574", 574, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{8, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A587", zones.back()->m_zone, "zone810", 810, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x7 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "A588", zones.back()->m_zone, "zone624", 624, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{12, 1, 11}}, Ioss::IJK_t{{12, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A589", zones.back()->m_zone, "zone653", 653, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 8}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A590", zones.back()->m_zone, "zone620", 620,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A591", zones.back()->m_zone, "zone614", 614, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
      Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A592", zones.back()->m_zone, "zone559", 559,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 8}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back("B592", zones.back()->m_zone, "zone558", 558,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A593", zones.back()->m_zone, "zone623", 623, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A594", zones.back()->m_zone, "zone859", 859, Ioss::IJK_t{{-1, 3, 2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 8, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A595", zones.back()->m_zone, "zone1023", 1023,
                                                Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{11, 1, 8}}, Ioss::IJK_t{{51, 11, 1}},
                                                Ioss::IJK_t{{51, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A596", zones.back()->m_zone, "zone622", 622,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 8}},
                                                Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{11, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A597", zones.back()->m_zone, "zone655", 655, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
      Ioss::IJK_t{{11, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x100x4 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B494", zones.back()->m_zone, "zone302", 302, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 101, 1}}, Ioss::IJK_t{{1, 1, 6}}, Ioss::IJK_t{{6, 101, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A598", zones.back()->m_zone, "zone562", 562, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 5}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A599", zones.back()->m_zone, "zone633", 633,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{6, 101, 5}}, Ioss::IJK_t{{6, 1, 12}},
                                                Ioss::IJK_t{{1, 101, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A600", zones.back()->m_zone, "zone571", 571, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 101, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A601", zones.back()->m_zone, "zone561", 561,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{6, 101, 5}}, Ioss::IJK_t{{6, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "5x5x4"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B24", zones.back()->m_zone, "zone942", 942, Ioss::IJK_t{{-2, 3, -1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 1, 5}}, Ioss::IJK_t{{5, 6, 6}}, Ioss::IJK_t{{1, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B497", zones.back()->m_zone, "zone313", 313, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{6, 6, 1}}, Ioss::IJK_t{{1, 1, 6}}, Ioss::IJK_t{{6, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B601", zones.back()->m_zone, "zone560", 560,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{6, 6, 5}}, Ioss::IJK_t{{6, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A602", zones.back()->m_zone, "zone572", 572, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 5}}, Ioss::IJK_t{{11, 1, 1}}, Ioss::IJK_t{{11, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A603", zones.back()->m_zone, "zone631", 631,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{6, 6, 5}}, Ioss::IJK_t{{6, 1, 12}},
                                                Ioss::IJK_t{{1, 6, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A604", zones.back()->m_zone, "zone563", 563, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{6, 1, 1}},
      Ioss::IJK_t{{6, 6, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x100x4 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B534", zones.back()->m_zone, "zone413", 413, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 101, 1}}, Ioss::IJK_t{{6, 1, 8}}, Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B598", zones.back()->m_zone, "zone560", 560, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A605", zones.back()->m_zone, "zone695", 695, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 5}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A606", zones.back()->m_zone, "zone637", 637,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{8, 1, 12}},
                                                Ioss::IJK_t{{1, 101, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A607", zones.back()->m_zone, "zone563", 563,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{8, 101, 5}}, Ioss::IJK_t{{8, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "7x5x4"));

  zones.back()->m_zoneConnectivity.emplace_back("B36", zones.back()->m_zone, "zone1164", 1164,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{8, 1, 5}}, Ioss::IJK_t{{5, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B536", zones.back()->m_zone, "zone424", 424, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{8, 6, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B604", zones.back()->m_zone, "zone561", 561, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 5}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B607", zones.back()->m_zone, "zone562", 562,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{8, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A608", zones.back()->m_zone, "zone636", 636,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{8, 1, 12}},
                                                Ioss::IJK_t{{1, 6, 12}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A609", zones.back()->m_zone, "zone696", 696, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{8, 1, 1}},
      Ioss::IJK_t{{8, 6, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x5"));

  zones.back()->m_zoneConnectivity.emplace_back("A610", zones.back()->m_zone, "zone671", 671,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A611", zones.back()->m_zone, "zone567", 567, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 6}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A612", zones.back()->m_zone, "zone1003", 1003,
                                                Ioss::IJK_t{{-3, 1, -2}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 1, 6}}, Ioss::IJK_t{{51, 6, 12}},
                                                Ioss::IJK_t{{51, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A613", zones.back()->m_zone, "zone647", 647,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 6}},
                                                Ioss::IJK_t{{12, 6, 6}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back("A614", zones.back()->m_zone, "zone666", 666,
                                                Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 6, 6}}, Ioss::IJK_t{{6, 1, 1}},
                                                Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A615", zones.back()->m_zone, "zone566", 566,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{12, 6, 6}}, Ioss::IJK_t{{12, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x7"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B69", zones.back()->m_zone, "zone554", 554, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A74", zones.back()->m_zone, "zone598", 598, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{12, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A75", zones.back()->m_zone, "zone928", 928, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{1, 1, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A76", zones.back()->m_zone, "zone169", 169, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 8}}, Ioss::IJK_t{{1, 6, 1}}, Ioss::IJK_t{{12, 6, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A77", zones.back()->m_zone, "zone417", 417, Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 1, 8}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{1, 1, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A78", zones.back()->m_zone, "zone791", 791, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 6, 1}},
      Ioss::IJK_t{{12, 6, 8}}, Ioss::IJK_t{{1, 1, 12}}, Ioss::IJK_t{{8, 1, 1}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x100x5 "));

  zones.back()->m_zoneConnectivity.emplace_back("B615", zones.back()->m_zone, "zone564", 564,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{12, 101, 6}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("A616", zones.back()->m_zone, "zone672", 672,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A617", zones.back()->m_zone, "zone664", 664, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A618", zones.back()->m_zone, "zone648", 648,
                                                Ioss::IJK_t{{-1, 2, -3}}, Ioss::IJK_t{{1, 1, 6}},
                                                Ioss::IJK_t{{12, 101, 6}}, Ioss::IJK_t{{12, 1, 8}},
                                                Ioss::IJK_t{{1, 101, 8}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A619", zones.back()->m_zone, "zone568", 568, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
      Ioss::IJK_t{{12, 101, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x5x5"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B94", zones.back()->m_zone, "zone610", 610, Ioss::IJK_t{{1, 3, -2}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 1, 6}}, Ioss::IJK_t{{1, 6, 6}}, Ioss::IJK_t{{12, 1, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B611", zones.back()->m_zone, "zone564", 564, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{12, 1, 1}},
      Ioss::IJK_t{{12, 6, 6}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A620", zones.back()->m_zone, "zone673", 673, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 6, 1}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{12, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A621", zones.back()->m_zone, "zone679", 679, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 6}}, Ioss::IJK_t{{6, 1, 5}}, Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A622", zones.back()->m_zone, "zone649", 649, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{12, 6, 6}}, Ioss::IJK_t{{1, 1, 12}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back("A623", zones.back()->m_zone, "zone568", 568,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{12, 6, 6}}, Ioss::IJK_t{{12, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 6}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "11x100x5 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B619", zones.back()->m_zone, "zone566", 566, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 6}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 101, 6}});

  zones.back()->m_zoneConnectivity.emplace_back("B623", zones.back()->m_zone, "zone567", 567,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{12, 101, 6}}, Ioss::IJK_t{{12, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 6}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A624", zones.back()->m_zone, "zone674", 674, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{12, 101, 1}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{12, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A625", zones.back()->m_zone, "zone650", 650, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 6}},
      Ioss::IJK_t{{12, 101, 6}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 12}});

  zones.back()->m_zoneConnectivity.emplace_back("A626", zones.back()->m_zone, "zone678", 678,
                                                Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{12, 1, 1}},
                                                Ioss::IJK_t{{12, 101, 6}}, Ioss::IJK_t{{1, 1, 5}},
                                                Ioss::IJK_t{{6, 101, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x4 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "A627", zones.back()->m_zone, "zone682", 682, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{6, 1, 11}}, Ioss::IJK_t{{6, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A628", zones.back()->m_zone, "zone573", 573, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 5}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A629", zones.back()->m_zone, "zone674", 674, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 5}},
      Ioss::IJK_t{{11, 101, 5}}, Ioss::IJK_t{{12, 1, 1}}, Ioss::IJK_t{{12, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A630", zones.back()->m_zone, "zone678", 678, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
      Ioss::IJK_t{{11, 101, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A631", zones.back()->m_zone, "zone570", 570,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 5}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x4"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B112", zones.back()->m_zone, "zone654", 654, Ioss::IJK_t{{2, -1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 11, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B631", zones.back()->m_zone, "zone569", 569,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 5}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A632", zones.back()->m_zone, "zone683", 683, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A633", zones.back()->m_zone, "zone679", 679, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 5}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A634", zones.back()->m_zone, "zone673", 673, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 5}},
      Ioss::IJK_t{{11, 6, 5}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{1, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A635", zones.back()->m_zone, "zone574", 574, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
      Ioss::IJK_t{{11, 6, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x100x4 "));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B488", zones.back()->m_zone, "zone280", 280, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 101, 1}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 11}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B600", zones.back()->m_zone, "zone560", 560, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 101, 5}}, Ioss::IJK_t{{6, 1, 1}}, Ioss::IJK_t{{6, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A636", zones.back()->m_zone, "zone628", 628, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 5}},
      Ioss::IJK_t{{11, 101, 5}}, Ioss::IJK_t{{1, 1, 11}}, Ioss::IJK_t{{1, 101, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A637", zones.back()->m_zone, "zone590", 590, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
      Ioss::IJK_t{{11, 101, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("A638", zones.back()->m_zone, "zone572", 572,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 101, 1}},
                                                Ioss::IJK_t{{11, 101, 5}}, Ioss::IJK_t{{11, 6, 1}},
                                                Ioss::IJK_t{{1, 6, 5}});

  zones.push_back(new Iocgns::StructuredZoneData(zone++, "10x5x4"));

  zones.back()->m_zoneConnectivity.emplace_back(
      "B135", zones.back()->m_zone, "zone709", 709, Ioss::IJK_t{{-2, 1, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 1, 5}}, Ioss::IJK_t{{6, 11, 1}}, Ioss::IJK_t{{6, 1, 5}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B491", zones.back()->m_zone, "zone291", 291, Ioss::IJK_t{{-3, 2, 1}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{11, 6, 1}}, Ioss::IJK_t{{6, 1, 11}}, Ioss::IJK_t{{6, 6, 1}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "B602", zones.back()->m_zone, "zone561", 561, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{11, 1, 1}},
      Ioss::IJK_t{{11, 6, 5}}, Ioss::IJK_t{{1, 1, 1}}, Ioss::IJK_t{{1, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back("B638", zones.back()->m_zone, "zone571", 571,
                                                Ioss::IJK_t{{-1, -2, 3}}, Ioss::IJK_t{{1, 6, 1}},
                                                Ioss::IJK_t{{11, 6, 5}}, Ioss::IJK_t{{11, 101, 1}},
                                                Ioss::IJK_t{{1, 101, 5}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A639", zones.back()->m_zone, "zone591", 591, Ioss::IJK_t{{1, 2, 3}}, Ioss::IJK_t{{1, 1, 1}},
      Ioss::IJK_t{{1, 6, 5}}, Ioss::IJK_t{{8, 1, 1}}, Ioss::IJK_t{{8, 6, 5}});

  zones.back()->m_zoneConnectivity.emplace_back(
      "A640", zones.back()->m_zone, "zone627", 627, Ioss::IJK_t{{3, 2, -1}}, Ioss::IJK_t{{1, 1, 5}},
      Ioss::IJK_t{{11,