INCLUDE(Join)
INCLUDE(TribitsFilepathHelpers)
INCLUDE(AppendStringVarWithSep)


FUNCTION(TRIBITS_RAISE_INSTALL_PERMS_MODS_NOT_SUPPORTED_ON_WINDOWS_ERROR)

  SET(INSTALL_PERMS_SET "")
  TRIBITS_APPEND_INSTALL_PERMS_VAR_NOT_SUPPORTED(
    ${PROJECT_NAME}_MAKE_INSTALL_GROUP_WRITABLE)
  TRIBITS_APPEND_INSTALL_PERMS_VAR_NOT_SUPPORTED(
    ${PROJECT_NAME}_MAKE_INSTALL_GROUP_READABLE)
  TRIBITS_APPEND_INSTALL_PERMS_VAR_NOT_SUPPORTED(
    ${PROJECT_NAME}_MAKE_INSTALL_WORLD_READABLE)
  TRIBITS_APPEND_INSTALL_PERMS_VAR_NOT_SUPPORTED(
    ${PROJECT_NAME}_MAKE_INSTALL_GROUP)

  MESSAGE(FATAL_ERROR
    "ERROR: The options:\n"
    "${INSTALL_PERMS_SET}"
    "are not supported on Windows!\n"
    "Please remove these options and configure from scratch!"
    )

ENDFUNCTION()


# Reads and writes var INSTALL_PERMS_SET in above function
MACRO(TRIBITS_APPEND_INSTALL_PERMS_VAR_NOT_SUPPORTED  VAR_NAME)
  IF (NOT "${${VAR_NAME}}" STREQUAL "")
    SET(INSTALL_PERMS_SET  "${INSTALL_PERMS_SET}    ${VAR_NAME}='${${VAR_NAME}}'\n")
  ENDIF()
ENDMACRO()


FUNCTION(TRIBITS_DETERMINE_IF_SETUP_FOR_GROUP_AND_PERMS_MODIFICATIONS
  SETUP_FOR_GROUP_AND_PERMS_MODIFICATIONS_OUT
  )

  IF(
    ${PROJECT_NAME}_MAKE_INSTALL_GROUP_WRITABLE OR
    ${PROJECT_NAME}_MAKE_INSTALL_GROUP_READABLE OR
    ${PROJECT_NAME}_MAKE_INSTALL_WORLD_READABLE OR
    (NOT "${${PROJECT_NAME}_MAKE_INSTALL_GROUP}" STREQUAL "")
    )
    SET(setupForGroupAndPermsModifications TRUE)
  ELSE()
    SET(setupForGroupAndPermsModifications FALSE)
  ENDIF()

  IF (setupForGroupAndPermsModifications AND
    ${PROJECT_NAME}_HOSTTYPE STREQUAL "Windows"
    )
    TRIBITS_RAISE_INSTALL_PERMS_MODS_NOT_SUPPORTED_ON_WINDOWS_ERROR()
  ENDIF()

  SET(${SETUP_FOR_GROUP_AND_PERMS_MODIFICATIONS_OUT}
    ${setupForGroupAndPermsModifications} PARENT_SCOPE)

ENDFUNCTION()


FUNCTION(TRIBITS_CONFIGURE_SET_INSTALLED_GROUP_AND_PERMS_FILE  TARGET_FILE)

  SET(PROJECT_SET_GROUP_AND_PERMISSIONS_ON_INSTALL_BASE_DIR
    "${${PROJECT_NAME}_SET_GROUP_AND_PERMISSIONS_ON_INSTALL_BASE_DIR}")

  TRIBITS_GET_DIR_ARRAY_BELOW_BASE_DIR(
    "${${PROJECT_NAME}_SET_GROUP_AND_PERMISSIONS_ON_INSTALL_BASE_DIR}"
    "${CMAKE_INSTALL_PREFIX}"
    PROJECT_SUBDIR_PATHS_ARRAY
    )

  SET(PROJECT_MAKE_INSTALL_GROUP "${${PROJECT_NAME}_MAKE_INSTALL_GROUP}")

  SET(group_perms "")
  IF (${PROJECT_NAME}_MAKE_INSTALL_GROUP_WRITABLE)
    SET(group_perms "g+rwX")
  ELSEIF (${PROJECT_NAME}_MAKE_INSTALL_GROUP_READABLE)
    SET(group_perms "g+rX")
  ENDIF()

  SET(other_perms "")
  IF (${PROJECT_NAME}_MAKE_INSTALL_WORLD_READABLE)
    SET(other_perms "o+rX")
  ENDIF()

  JOIN(PROJECT_MAKE_INSTALL_PERMS_CHANGE "," FALSE
    ${group_perms} ${other_perms} )

  SET(tribits_install_src
    "${${PROJECT_NAME}_TRIBITS_DIR}/${TRIBITS_CMAKE_INSTALLATION_FILES_DIR}")
  CONFIGURE_FILE(
    "${tribits_install_src}/set_installed_group_and_permissions.cmake.in"
    "${TARGET_FILE}" @ONLY )

ENDFUNCTION()


FUNCTION(TRIBITS_ADD_INSTALL_GROUP_AND_PERMS_FIXUPS)

  TRIBITS_DETERMINE_IF_SETUP_FOR_GROUP_AND_PERMS_MODIFICATIONS(
    setupForGroupAndPermsModifications)

  IF (setupForGroupAndPermsModifications)

    SET(set_installed_group_and_permissions_file
      "${PROJECT_BINARY_DIR}/set_installed_group_and_permissions.cmake")

    TRIBITS_CONFIGURE_SET_INSTALLED_GROUP_AND_PERMS_FILE(
      "${set_installed_group_and_permissions_file}" )

    # Fix up install for default 'install' command
    INSTALL(SCRIPT "${set_installed_group_and_permissions_file}")

  ENDIF()

ENDFUNCTION()