/*=========================================================================

  Program:   Visualization Toolkit
  Module:    pqPointSpriteTextureComboBox.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

// .NAME pqPointSpriteTextureComboBox
// .SECTION Thanks
// <verbatim>
//
//  This file is part of the PointSprites plugin developed and contributed by
//
//  Copyright (c) CSCS - Swiss National Supercomputing Centre
//                EDF - Electricite de France
//
//  John Biddiscombe, Ugo Varetto (CSCS)
//  Stephane Ploix (EDF)
//
// </verbatim>
// .SECTION Description
// This is a ComboBox that is used on the display tab to select available
// textures. It checks whether current representation has texture coordinates,
// if not, the widget will be disabled automatically.
// It also provides the user with an option to load new images as textures.

#ifndef pqPointSpriteTextureComboBox_h
#define pqPointSpriteTextureComboBox_h

#include "pqTextureComboBox.h"

class pqPointSpriteTextureComboBox : public pqTextureComboBox
{
  Q_OBJECT
  typedef pqTextureComboBox Superclass;

public:
  pqPointSpriteTextureComboBox(QWidget* parent = 0);
  virtual ~pqPointSpriteTextureComboBox();

public slots:
  // Description:
  // Set the point sprite render mode (simple point, texture, exact sphere)
  // this in turns updates the enable state and active the texture
  virtual void setRenderMode(int);

protected slots:
  /// Update the enable state of the widget.
  /// ooverloaded to always return true because texture coordinates are
  /// generated by the point sprite extension.
  virtual void updateEnableState();

  virtual void updateTexture();

protected:
  int RenderMode;
  int CachedTextureIndex;

private:
  Q_DISABLE_COPY(pqPointSpriteTextureComboBox)
};

#endif
