import numpy as np


def vals(min, max, steps):
    percents = [i / (steps + 1) for i in range(1, steps+1)]
    return [min + p * (max - min) for p in percents]


def inverse_lerp(min, max, val):
    return (val - min) / (max - min)


def lerp(min, max, t):
    return min + t * (max - min)


MIN = -0.007938
MAX = +0.007269
STEPS = 10
VALS_IDX_INTEREST = [5, 6]

NEW_MIN = -0.002
NEW_MAX = +0.0004

"""
all_vals = vals(MIN, MAX, STEPS)
for i in VALS_IDX_INTEREST:
    val = round(all_vals[i - 1], 7)
    t = inverse_lerp(NEW_MIN, NEW_MAX, val)
    t = round(t, 4)
    print(t)
"""

delta = 1e-3
for i in np.linspace(0.0, 1.0, 11):
    if i == 0.0:
        print("[0.000, 0.000]")
    elif i == 1.0:
        print("[1.000, 1.000]")
    else:
        print(f"[{round(i - delta, 3):.3f}, {round(i + delta, 3):.3f}]")
