#pragma once

#include "../mpi/MpiEnv.h"
#include "../profiling/Record.h"

#include <ostream>
#include <string>
#include <vector>

namespace beams
{
namespace utils
{
struct Timings
{
  Timings(const std::string& sceneId, const std::vector<std::string>& labels);

  void AddIteration(const std::vector<beams::profiling::Record>& times);

  void Save(const std::string& fileName);

private:
  std::vector<vtkm::Float64> CollectDistributedTimeStats(vtkm::Float64 time);

  std::string SceneId;
  std::vector<std::string> Labels;
  std::map<std::string, std::vector<vtkm::Float64>> DistributedTimings;
};
}
}
