#pragma once

#include <string>
#include <vector>

namespace beams
{
namespace utils
{
struct String
{
  static std::string ToLower(const std::string& s);

  static int CompareIgnoreCase(const std::string& s1, const std::string& s2);

  static std::string LTrim(const std::string& s);

  static std::string RTrim(const std::string& s);

  static std::string Trim(const std::string& s);

  static std::vector<std::string> Split(const std::string& s,
                                        const std::string& delim,
                                        bool trim = false);
};
}
}