#include "String.h"

#include <cctype>

namespace beams
{
namespace utils
{
const std::string WHITESPACE = " \n\r\t\f\v";

std::string String::ToLower(const std::string& s)
{
  std::string result = s;
  for (std::string::iterator i = result.begin(); i != result.end(); ++i)
  {
    *i = std::tolower(*i);
  }
  return result;
}

int String::CompareIgnoreCase(const std::string& s1, const std::string& s2)
{
  std::string is1 = String::ToLower(s1);
  std::string is2 = String::ToLower(s2);
  return is1.compare(is2);
}

std::string String::LTrim(const std::string& s)
{
  size_t start = s.find_first_not_of(WHITESPACE);
  return (start == std::string::npos) ? "" : s.substr(start);
}

std::string String::RTrim(const std::string& s)
{
  size_t end = s.find_last_not_of(WHITESPACE);
  return (end == std::string::npos) ? "" : s.substr(0, end + 1);
}

std::string String::Trim(const std::string& s)
{
  return String::RTrim(String::LTrim(s));
}

std::vector<std::string> String::Split(const std::string& s, const std::string& delim, bool trim)
{
  std::vector<std::string> result;
  size_t start = 0;
  size_t end = s.find_first_of(delim);

  while (end != std::string::npos)
  {
    if (end != start)
    {
      std::string token = s.substr(start, end - start);
      if (trim)
      {
        token = String::Trim(token);
      }
      result.push_back(token);
    }
    start = end + 1;
    end = s.find_first_of(delim, start);
  }

  if (start != s.length())
  {
    std::string token = s.substr(start);
    if (trim)
    {
      token = String::Trim(token);
    }
    result.push_back(token);
  }

  return result;
}
}
}