#ifndef beams_utils_file_h
#define beams_utils_file_h

#include <vtkm/cont/DataSet.h>

#include <string>

namespace beams
{
namespace io
{

struct File
{
  static bool FileExists(const std::string& filePath);

  static bool FolderExists(const std::string& folderPath);

  static std::vector<std::string> Glob(const std::string& pattern);

  static void SaveDataSet(const vtkm::cont::DataSet& dataSet, const std::string& name);

  static std::string SuffixStringToFilename(const std::string& filePath, const std::string& suffix);
};

}
} // namespace beams::io

#endif // beams_utils_file_h