#pragma once

#include <vtkm/source/Source.h>

#include <string>
#include <vector>

namespace beams
{
namespace source
{
class IcoSphere : public vtkm::source::Source
{
public:
  VTKM_CONT
  IcoSphere(vtkm::IdComponent refinementLevel = 4);

  VTKM_CONT
  const std::string& GetFieldName() const;

  VTKM_CONT
  void SetFieldName(const std::string& fieldName);

  VTKM_CONT
  vtkm::IdComponent GetRefinementLevel() const;

  VTKM_CONT
  void SetRefinementLevel(vtkm::IdComponent refinementLevel);

  VTKM_CONT
  void AddSphere(vtkm::Vec3f center, vtkm::FloatDefault radius, vtkm::FloatDefault fieldValue);

protected:
  vtkm::cont::DataSet DoExecute() const override;

private:
  std::vector<vtkm::Vec3f> Centers;
  std::vector<vtkm::FloatDefault> Radii;
  std::vector<vtkm::FloatDefault> FieldValues;
  vtkm::IdComponent RefinementLevel;
  std::string FieldName;
};
}
}