#!/bin/bash

# Clear screen
clear;

# Clear scrollback
printf '\e[3J';

DEVICE=cuda
NUM_PROCS=1
LOG_LEVEL="WARN"
CONFIG=spheres

function get_host_fragment
{
    MYHOST=`hostname`
    if [[ $MYHOST = "manishma-desk" ]]; then
        local fragmemt=""
        echo $fragment
    elif [[ $MYHOST = "alaska"  ||  $MYHOST = "cn1" ]]; then
        local fragment="--host cn1,cn2,cn3,cn4"
        echo $fragment
    fi
}

function run_single
{
    JSON_FILE=$1
    PRESET_NAME=$2
    echo -e "\nRunning ${PRESET_NAME} with $NUM_PROCS mpi processes, on device $DEVICE"
    HOSTS_FRAGMENT=$(get_host_fragment)
    mpirun -n $NUM_PROCS --bind-to none $HOSTS_FRAGMENT ./examples/beams/Beams --vtkm-device=$DEVICE --vtkm-log-level=$LOG_LEVEL --config-file=${JSON_FILE} --preset=$PRESET_NAME
}

function run_synth
{
    PERLIN_256_SM_SIZES=("000" "016" "032" "064" "128")

    if [[ "$CONFIG" == "perlin_256" ]]; then
        SM_SIZES=("${PERLIN_256_SM_SIZES[@]}")
    fi

    JSON_FILE="../data/${CONFIG}/${CONFIG}.json"
    echo "Will run for ${CONFIG} with shadow map sizes ${SM_SIZES[@]}";
    for SM_SIZE in ${SM_SIZES[@]};
    do
        PRESET_NAME="${CONFIG}_sm${SM_SIZE}"
        run_single $JSON_FILE $PRESET_NAME
        if [ $? -ne 0 ]
        then
            echo "Error in previous run. Exiting ...."
            break 2;
        fi
    done
}

function run_file
{
    #SM_SIZES=(8 16 32 64 128)
    SM_SIZES=("016" "032" "064" "128")
    echo "Will run for ${CONFIG} with shadow map sizes ${SM_SIZES[@]}";
    JSON_FILE="../data/${CONFIG}/${CONFIG}.json"

    PRESET_NAME="${CONFIG}.${NUM_PROCS}_no_shadows"
    run_single $JSON_FILE $PRESET_NAME
    if [ $? -ne 0 ]
    then
        echo "Error in previous run. Exiting ...."
        return
    fi
    for SM in ${SM_SIZES[@]};
    do
        PRESET_NAME="${CONFIG}.${NUM_PROCS}_sm${SM}"
        run_single $JSON_FILE $PRESET_NAME
        if [ $? -ne 0 ]
        then
            echo "Error in previous run. Exiting ...."
            break 2;
        fi
    done

}

while getopts ":c:d:l:p:" option; do
    case $option in
        c) CONFIG=$OPTARG ;;
        d) DEVICE=$OPTARG ;;
        l) LOG_LEVEL=$OPTARG ;;
        p) NUM_PROCS=$OPTARG ;;
        ?) echo "Invalid option ${option} ${OPTARG}"
        exit;;
    esac
done

if [[ "$CONFIG" =~ "perlin" ]]; then
    run_synth
elif [[ "$CONFIG" =~ "rayleigh" || "$CONFIG" =~ "fluid_dynamics" || "$CONFIG" =~ "mantle" || "$CONFIG" =~ "miranda" ]]; then
    run_file
else
    echo "Invalid config $CONFIG"
fi
