#include "Utils.h"
#include "../Math.h"

namespace beams
{
namespace rendering
{
vtkm::Float32 Utils::SampleDistanceFromBounds(const vtkm::Bounds& bounds, const vtkm::Id numSamples)
{
  vtkm::Float32 boundsMagnitude = beams::Math::BoundsMagnitude<vtkm::Float32>(bounds);
  return boundsMagnitude / static_cast<vtkm::Float32>(numSamples);
}
}
}