#pragma once

#include "../Config.h"
#include "Scene.h"

namespace beams
{
namespace rendering
{
struct SummerMovieScene : public Scene
{
  SummerMovieScene() = default;
  virtual ~SummerMovieScene() = default;

  void AdvanceFileIndex();

  std::string GetCurretFileName() const { return this->FileNames[this->CurrentFileIndex]; }

  std::size_t GetFilesCount() const { return this->FileNames.size(); }

  virtual void LoadDataSet(const beams::Config& config,
                           const beams::Preset& preset,
                           beams::mpi::MpiEnv& mpi) override;

protected:
  virtual std::string GetFileName(const beams::Config& config,
                                  const beams::Preset& preset,
                                  const beams::mpi::MpiEnv& mpi) const;

  std::vector<std::string> FileNames;
  std::size_t CurrentFileIndex = 0;
}; // struct SummerMovieScene
}
} // namespace beams::rendering