#pragma once

#include "../mpi/MpiEnv.h"

#include <vtkm/Range.h>
#include <vtkm/VectorAnalysis.h>
#include <vtkm/cont/ArrayHandle.h>
#include <vtkm/cont/DataSet.h>

#include <vector>

namespace beams
{
namespace rendering
{
struct RangeMap
{
public:
  RangeMap(const beams::mpi::MpiEnv& mpi, const vtkm::Range& range);

  vtkm::Range GetRange(vtkm::Id rank) const;

  vtkm::Range GetGlobalRange() const;

private:
  void Build(const vtkm::Range& range);

  const beams::mpi::MpiEnv& Mpi;
  std::vector<vtkm::Range> Ranges;
  vtkm::Range GlobalRange;
};
} // namespace rendering
} // namespace beams