#pragma once

#include "Light.h"

#include <vtkm/cont/DataSet.h>
#include <vtkm/rendering/Camera.h>
#include <vtkm/rendering/raytracing/Ray.h>

#include <memory>

namespace beams
{
namespace rendering
{
class PhongVolumeRendererStructured
{
public:
  VTKM_CONT
  void SetColorMap(const vtkm::cont::ArrayHandle<vtkm::Vec4f_32>& colorMap);

  VTKM_CONT
  void SetData(const vtkm::cont::CoordinateSystem& coords,
               const vtkm::cont::Field& scalarField,
               const vtkm::cont::CellSetStructured<3>& cellset,
               const vtkm::Range& scalarRange);


  VTKM_CONT
  void Render(vtkm::rendering::raytracing::Ray<vtkm::Float32>& rays,
              const vtkm::rendering::Camera& camera);

  VTKM_CONT
  void SetSampleDistance(const vtkm::Float32& distance);

  VTKM_CONT
  void SetDensityCorrectionRatio(vtkm::Float32 densityCorrectionRatio);

  VTKM_CONT
  void SetLight(std::shared_ptr<beams::rendering::Light> light);

  VTKM_CONT
  void SetUsePhongDiffuse(bool usePhongDiffuse);

  VTKM_CONT
  void SetUsePhongSpecular(bool usePhongSpecular);

protected:
  template <typename Precision, typename Device>
  VTKM_CONT void RenderOnDevice(vtkm::rendering::raytracing::Ray<Precision>& rays,
                                const vtkm::rendering::Camera& camera,
                                Device);

  bool IsSceneDirty = false;
  bool IsUniformDataSet = true;
  vtkm::Bounds SpatialExtent;
  vtkm::cont::CoordinateSystem Coordinates;
  vtkm::cont::CellSetStructured<3> Cellset;
  const vtkm::cont::Field* ScalarField;
  vtkm::cont::ArrayHandle<vtkm::Vec4f_32> ColorMap;
  vtkm::Float32 SampleDistance = -1.f;
  vtkm::Range ScalarRange;
  vtkm::Float32 DensityCorrectionRatio;
  std::shared_ptr<beams::rendering::Light> Light;
  bool UsePhongDiffuse = true;
  bool UsePhongSpecular = true;
};
}
}
