#pragma once

#include "../Config.h"
#include "Scene.h"

namespace beams
{
namespace rendering
{
struct PerlinScene : public Scene
{
  PerlinScene() = default;
  virtual ~PerlinScene() = default;

  virtual void LoadMpiTopology(const beams::Config& config,
                               const beams::Preset& preset,
                               beams::mpi::MpiEnv& mpi) override;

  virtual void LoadDataSet(const beams::Config& config,
                           const beams::Preset& preset,
                           beams::mpi::MpiEnv& mpi) override;

  virtual void LoadOpacityMap(const beams::Config& config,
                              const beams::Preset& preset,
                              beams::mpi::MpiEnv& mpi) override;

private:
  vtkm::Vec<int, 3> MpiSizes;
}; // struct PerlinScene
}
} // namespace beams::rendering
